/*
Copyright 2021 Rancher Labs, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by main. DO NOT EDIT.

package v3

import (
	"context"
	"time"

	"github.com/rancher/lasso/pkg/client"
	"github.com/rancher/lasso/pkg/controller"
	v3 "github.com/rancher/rancher/pkg/apis/project.cattle.io/v3"
	"github.com/rancher/wrangler/pkg/generic"
	"k8s.io/apimachinery/pkg/api/equality"
	"k8s.io/apimachinery/pkg/api/errors"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/runtime"
	"k8s.io/apimachinery/pkg/runtime/schema"
	"k8s.io/apimachinery/pkg/types"
	utilruntime "k8s.io/apimachinery/pkg/util/runtime"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

type CertificateHandler func(string, *v3.Certificate) (*v3.Certificate, error)

type CertificateController interface {
	generic.ControllerMeta
	CertificateClient

	OnChange(ctx context.Context, name string, sync CertificateHandler)
	OnRemove(ctx context.Context, name string, sync CertificateHandler)
	Enqueue(namespace, name string)
	EnqueueAfter(namespace, name string, duration time.Duration)

	Cache() CertificateCache
}

type CertificateClient interface {
	Create(*v3.Certificate) (*v3.Certificate, error)
	Update(*v3.Certificate) (*v3.Certificate, error)

	Delete(namespace, name string, options *metav1.DeleteOptions) error
	Get(namespace, name string, options metav1.GetOptions) (*v3.Certificate, error)
	List(namespace string, opts metav1.ListOptions) (*v3.CertificateList, error)
	Watch(namespace string, opts metav1.ListOptions) (watch.Interface, error)
	Patch(namespace, name string, pt types.PatchType, data []byte, subresources ...string) (result *v3.Certificate, err error)
}

type CertificateCache interface {
	Get(namespace, name string) (*v3.Certificate, error)
	List(namespace string, selector labels.Selector) ([]*v3.Certificate, error)

	AddIndexer(indexName string, indexer CertificateIndexer)
	GetByIndex(indexName, key string) ([]*v3.Certificate, error)
}

type CertificateIndexer func(obj *v3.Certificate) ([]string, error)

type certificateController struct {
	controller    controller.SharedController
	client        *client.Client
	gvk           schema.GroupVersionKind
	groupResource schema.GroupResource
}

func NewCertificateController(gvk schema.GroupVersionKind, resource string, namespaced bool, controller controller.SharedControllerFactory) CertificateController {
	c := controller.ForResourceKind(gvk.GroupVersion().WithResource(resource), gvk.Kind, namespaced)
	return &certificateController{
		controller: c,
		client:     c.Client(),
		gvk:        gvk,
		groupResource: schema.GroupResource{
			Group:    gvk.Group,
			Resource: resource,
		},
	}
}

func FromCertificateHandlerToHandler(sync CertificateHandler) generic.Handler {
	return func(key string, obj runtime.Object) (ret runtime.Object, err error) {
		var v *v3.Certificate
		if obj == nil {
			v, err = sync(key, nil)
		} else {
			v, err = sync(key, obj.(*v3.Certificate))
		}
		if v == nil {
			return nil, err
		}
		return v, err
	}
}

func (c *certificateController) Updater() generic.Updater {
	return func(obj runtime.Object) (runtime.Object, error) {
		newObj, err := c.Update(obj.(*v3.Certificate))
		if newObj == nil {
			return nil, err
		}
		return newObj, err
	}
}

func UpdateCertificateDeepCopyOnChange(client CertificateClient, obj *v3.Certificate, handler func(obj *v3.Certificate) (*v3.Certificate, error)) (*v3.Certificate, error) {
	if obj == nil {
		return obj, nil
	}

	copyObj := obj.DeepCopy()
	newObj, err := handler(copyObj)
	if newObj != nil {
		copyObj = newObj
	}
	if obj.ResourceVersion == copyObj.ResourceVersion && !equality.Semantic.DeepEqual(obj, copyObj) {
		return client.Update(copyObj)
	}

	return copyObj, err
}

func (c *certificateController) AddGenericHandler(ctx context.Context, name string, handler generic.Handler) {
	c.controller.RegisterHandler(ctx, name, controller.SharedControllerHandlerFunc(handler))
}

func (c *certificateController) AddGenericRemoveHandler(ctx context.Context, name string, handler generic.Handler) {
	c.AddGenericHandler(ctx, name, generic.NewRemoveHandler(name, c.Updater(), handler))
}

func (c *certificateController) OnChange(ctx context.Context, name string, sync CertificateHandler) {
	c.AddGenericHandler(ctx, name, FromCertificateHandlerToHandler(sync))
}

func (c *certificateController) OnRemove(ctx context.Context, name string, sync CertificateHandler) {
	c.AddGenericHandler(ctx, name, generic.NewRemoveHandler(name, c.Updater(), FromCertificateHandlerToHandler(sync)))
}

func (c *certificateController) Enqueue(namespace, name string) {
	c.controller.Enqueue(namespace, name)
}

func (c *certificateController) EnqueueAfter(namespace, name string, duration time.Duration) {
	c.controller.EnqueueAfter(namespace, name, duration)
}

func (c *certificateController) Informer() cache.SharedIndexInformer {
	return c.controller.Informer()
}

func (c *certificateController) GroupVersionKind() schema.GroupVersionKind {
	return c.gvk
}

func (c *certificateController) Cache() CertificateCache {
	return &certificateCache{
		indexer:  c.Informer().GetIndexer(),
		resource: c.groupResource,
	}
}

func (c *certificateController) Create(obj *v3.Certificate) (*v3.Certificate, error) {
	result := &v3.Certificate{}
	return result, c.client.Create(context.TODO(), obj.Namespace, obj, result, metav1.CreateOptions{})
}

func (c *certificateController) Update(obj *v3.Certificate) (*v3.Certificate, error) {
	result := &v3.Certificate{}
	return result, c.client.Update(context.TODO(), obj.Namespace, obj, result, metav1.UpdateOptions{})
}

func (c *certificateController) Delete(namespace, name string, options *metav1.DeleteOptions) error {
	if options == nil {
		options = &metav1.DeleteOptions{}
	}
	return c.client.Delete(context.TODO(), namespace, name, *options)
}

func (c *certificateController) Get(namespace, name string, options metav1.GetOptions) (*v3.Certificate, error) {
	result := &v3.Certificate{}
	return result, c.client.Get(context.TODO(), namespace, name, result, options)
}

func (c *certificateController) List(namespace string, opts metav1.ListOptions) (*v3.CertificateList, error) {
	result := &v3.CertificateList{}
	return result, c.client.List(context.TODO(), namespace, result, opts)
}

func (c *certificateController) Watch(namespace string, opts metav1.ListOptions) (watch.Interface, error) {
	return c.client.Watch(context.TODO(), namespace, opts)
}

func (c *certificateController) Patch(namespace, name string, pt types.PatchType, data []byte, subresources ...string) (*v3.Certificate, error) {
	result := &v3.Certificate{}
	return result, c.client.Patch(context.TODO(), namespace, name, pt, data, result, metav1.PatchOptions{}, subresources...)
}

type certificateCache struct {
	indexer  cache.Indexer
	resource schema.GroupResource
}

func (c *certificateCache) Get(namespace, name string) (*v3.Certificate, error) {
	obj, exists, err := c.indexer.GetByKey(namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(c.resource, name)
	}
	return obj.(*v3.Certificate), nil
}

func (c *certificateCache) List(namespace string, selector labels.Selector) (ret []*v3.Certificate, err error) {

	err = cache.ListAllByNamespace(c.indexer, namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v3.Certificate))
	})

	return ret, err
}

func (c *certificateCache) AddIndexer(indexName string, indexer CertificateIndexer) {
	utilruntime.Must(c.indexer.AddIndexers(map[string]cache.IndexFunc{
		indexName: func(obj interface{}) (strings []string, e error) {
			return indexer(obj.(*v3.Certificate))
		},
	}))
}

func (c *certificateCache) GetByIndex(indexName, key string) (result []*v3.Certificate, err error) {
	objs, err := c.indexer.ByIndex(indexName, key)
	if err != nil {
		return nil, err
	}
	result = make([]*v3.Certificate, 0, len(objs))
	for _, obj := range objs {
		result = append(result, obj.(*v3.Certificate))
	}
	return result, nil
}
