/*
Copyright 2021 Rancher Labs, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by main. DO NOT EDIT.

package v3

import (
	"context"
	"time"

	"github.com/rancher/lasso/pkg/client"
	"github.com/rancher/lasso/pkg/controller"
	v3 "github.com/rancher/rancher/pkg/apis/project.cattle.io/v3"
	"github.com/rancher/wrangler/pkg/apply"
	"github.com/rancher/wrangler/pkg/condition"
	"github.com/rancher/wrangler/pkg/generic"
	"github.com/rancher/wrangler/pkg/kv"
	"k8s.io/apimachinery/pkg/api/equality"
	"k8s.io/apimachinery/pkg/api/errors"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/runtime"
	"k8s.io/apimachinery/pkg/runtime/schema"
	"k8s.io/apimachinery/pkg/types"
	utilruntime "k8s.io/apimachinery/pkg/util/runtime"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

type SourceCodeCredentialHandler func(string, *v3.SourceCodeCredential) (*v3.SourceCodeCredential, error)

type SourceCodeCredentialController interface {
	generic.ControllerMeta
	SourceCodeCredentialClient

	OnChange(ctx context.Context, name string, sync SourceCodeCredentialHandler)
	OnRemove(ctx context.Context, name string, sync SourceCodeCredentialHandler)
	Enqueue(namespace, name string)
	EnqueueAfter(namespace, name string, duration time.Duration)

	Cache() SourceCodeCredentialCache
}

type SourceCodeCredentialClient interface {
	Create(*v3.SourceCodeCredential) (*v3.SourceCodeCredential, error)
	Update(*v3.SourceCodeCredential) (*v3.SourceCodeCredential, error)
	UpdateStatus(*v3.SourceCodeCredential) (*v3.SourceCodeCredential, error)
	Delete(namespace, name string, options *metav1.DeleteOptions) error
	Get(namespace, name string, options metav1.GetOptions) (*v3.SourceCodeCredential, error)
	List(namespace string, opts metav1.ListOptions) (*v3.SourceCodeCredentialList, error)
	Watch(namespace string, opts metav1.ListOptions) (watch.Interface, error)
	Patch(namespace, name string, pt types.PatchType, data []byte, subresources ...string) (result *v3.SourceCodeCredential, err error)
}

type SourceCodeCredentialCache interface {
	Get(namespace, name string) (*v3.SourceCodeCredential, error)
	List(namespace string, selector labels.Selector) ([]*v3.SourceCodeCredential, error)

	AddIndexer(indexName string, indexer SourceCodeCredentialIndexer)
	GetByIndex(indexName, key string) ([]*v3.SourceCodeCredential, error)
}

type SourceCodeCredentialIndexer func(obj *v3.SourceCodeCredential) ([]string, error)

type sourceCodeCredentialController struct {
	controller    controller.SharedController
	client        *client.Client
	gvk           schema.GroupVersionKind
	groupResource schema.GroupResource
}

func NewSourceCodeCredentialController(gvk schema.GroupVersionKind, resource string, namespaced bool, controller controller.SharedControllerFactory) SourceCodeCredentialController {
	c := controller.ForResourceKind(gvk.GroupVersion().WithResource(resource), gvk.Kind, namespaced)
	return &sourceCodeCredentialController{
		controller: c,
		client:     c.Client(),
		gvk:        gvk,
		groupResource: schema.GroupResource{
			Group:    gvk.Group,
			Resource: resource,
		},
	}
}

func FromSourceCodeCredentialHandlerToHandler(sync SourceCodeCredentialHandler) generic.Handler {
	return func(key string, obj runtime.Object) (ret runtime.Object, err error) {
		var v *v3.SourceCodeCredential
		if obj == nil {
			v, err = sync(key, nil)
		} else {
			v, err = sync(key, obj.(*v3.SourceCodeCredential))
		}
		if v == nil {
			return nil, err
		}
		return v, err
	}
}

func (c *sourceCodeCredentialController) Updater() generic.Updater {
	return func(obj runtime.Object) (runtime.Object, error) {
		newObj, err := c.Update(obj.(*v3.SourceCodeCredential))
		if newObj == nil {
			return nil, err
		}
		return newObj, err
	}
}

func UpdateSourceCodeCredentialDeepCopyOnChange(client SourceCodeCredentialClient, obj *v3.SourceCodeCredential, handler func(obj *v3.SourceCodeCredential) (*v3.SourceCodeCredential, error)) (*v3.SourceCodeCredential, error) {
	if obj == nil {
		return obj, nil
	}

	copyObj := obj.DeepCopy()
	newObj, err := handler(copyObj)
	if newObj != nil {
		copyObj = newObj
	}
	if obj.ResourceVersion == copyObj.ResourceVersion && !equality.Semantic.DeepEqual(obj, copyObj) {
		return client.Update(copyObj)
	}

	return copyObj, err
}

func (c *sourceCodeCredentialController) AddGenericHandler(ctx context.Context, name string, handler generic.Handler) {
	c.controller.RegisterHandler(ctx, name, controller.SharedControllerHandlerFunc(handler))
}

func (c *sourceCodeCredentialController) AddGenericRemoveHandler(ctx context.Context, name string, handler generic.Handler) {
	c.AddGenericHandler(ctx, name, generic.NewRemoveHandler(name, c.Updater(), handler))
}

func (c *sourceCodeCredentialController) OnChange(ctx context.Context, name string, sync SourceCodeCredentialHandler) {
	c.AddGenericHandler(ctx, name, FromSourceCodeCredentialHandlerToHandler(sync))
}

func (c *sourceCodeCredentialController) OnRemove(ctx context.Context, name string, sync SourceCodeCredentialHandler) {
	c.AddGenericHandler(ctx, name, generic.NewRemoveHandler(name, c.Updater(), FromSourceCodeCredentialHandlerToHandler(sync)))
}

func (c *sourceCodeCredentialController) Enqueue(namespace, name string) {
	c.controller.Enqueue(namespace, name)
}

func (c *sourceCodeCredentialController) EnqueueAfter(namespace, name string, duration time.Duration) {
	c.controller.EnqueueAfter(namespace, name, duration)
}

func (c *sourceCodeCredentialController) Informer() cache.SharedIndexInformer {
	return c.controller.Informer()
}

func (c *sourceCodeCredentialController) GroupVersionKind() schema.GroupVersionKind {
	return c.gvk
}

func (c *sourceCodeCredentialController) Cache() SourceCodeCredentialCache {
	return &sourceCodeCredentialCache{
		indexer:  c.Informer().GetIndexer(),
		resource: c.groupResource,
	}
}

func (c *sourceCodeCredentialController) Create(obj *v3.SourceCodeCredential) (*v3.SourceCodeCredential, error) {
	result := &v3.SourceCodeCredential{}
	return result, c.client.Create(context.TODO(), obj.Namespace, obj, result, metav1.CreateOptions{})
}

func (c *sourceCodeCredentialController) Update(obj *v3.SourceCodeCredential) (*v3.SourceCodeCredential, error) {
	result := &v3.SourceCodeCredential{}
	return result, c.client.Update(context.TODO(), obj.Namespace, obj, result, metav1.UpdateOptions{})
}

func (c *sourceCodeCredentialController) UpdateStatus(obj *v3.SourceCodeCredential) (*v3.SourceCodeCredential, error) {
	result := &v3.SourceCodeCredential{}
	return result, c.client.UpdateStatus(context.TODO(), obj.Namespace, obj, result, metav1.UpdateOptions{})
}

func (c *sourceCodeCredentialController) Delete(namespace, name string, options *metav1.DeleteOptions) error {
	if options == nil {
		options = &metav1.DeleteOptions{}
	}
	return c.client.Delete(context.TODO(), namespace, name, *options)
}

func (c *sourceCodeCredentialController) Get(namespace, name string, options metav1.GetOptions) (*v3.SourceCodeCredential, error) {
	result := &v3.SourceCodeCredential{}
	return result, c.client.Get(context.TODO(), namespace, name, result, options)
}

func (c *sourceCodeCredentialController) List(namespace string, opts metav1.ListOptions) (*v3.SourceCodeCredentialList, error) {
	result := &v3.SourceCodeCredentialList{}
	return result, c.client.List(context.TODO(), namespace, result, opts)
}

func (c *sourceCodeCredentialController) Watch(namespace string, opts metav1.ListOptions) (watch.Interface, error) {
	return c.client.Watch(context.TODO(), namespace, opts)
}

func (c *sourceCodeCredentialController) Patch(namespace, name string, pt types.PatchType, data []byte, subresources ...string) (*v3.SourceCodeCredential, error) {
	result := &v3.SourceCodeCredential{}
	return result, c.client.Patch(context.TODO(), namespace, name, pt, data, result, metav1.PatchOptions{}, subresources...)
}

type sourceCodeCredentialCache struct {
	indexer  cache.Indexer
	resource schema.GroupResource
}

func (c *sourceCodeCredentialCache) Get(namespace, name string) (*v3.SourceCodeCredential, error) {
	obj, exists, err := c.indexer.GetByKey(namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(c.resource, name)
	}
	return obj.(*v3.SourceCodeCredential), nil
}

func (c *sourceCodeCredentialCache) List(namespace string, selector labels.Selector) (ret []*v3.SourceCodeCredential, err error) {

	err = cache.ListAllByNamespace(c.indexer, namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v3.SourceCodeCredential))
	})

	return ret, err
}

func (c *sourceCodeCredentialCache) AddIndexer(indexName string, indexer SourceCodeCredentialIndexer) {
	utilruntime.Must(c.indexer.AddIndexers(map[string]cache.IndexFunc{
		indexName: func(obj interface{}) (strings []string, e error) {
			return indexer(obj.(*v3.SourceCodeCredential))
		},
	}))
}

func (c *sourceCodeCredentialCache) GetByIndex(indexName, key string) (result []*v3.SourceCodeCredential, err error) {
	objs, err := c.indexer.ByIndex(indexName, key)
	if err != nil {
		return nil, err
	}
	result = make([]*v3.SourceCodeCredential, 0, len(objs))
	for _, obj := range objs {
		result = append(result, obj.(*v3.SourceCodeCredential))
	}
	return result, nil
}

type SourceCodeCredentialStatusHandler func(obj *v3.SourceCodeCredential, status v3.SourceCodeCredentialStatus) (v3.SourceCodeCredentialStatus, error)

type SourceCodeCredentialGeneratingHandler func(obj *v3.SourceCodeCredential, status v3.SourceCodeCredentialStatus) ([]runtime.Object, v3.SourceCodeCredentialStatus, error)

func RegisterSourceCodeCredentialStatusHandler(ctx context.Context, controller SourceCodeCredentialController, condition condition.Cond, name string, handler SourceCodeCredentialStatusHandler) {
	statusHandler := &sourceCodeCredentialStatusHandler{
		client:    controller,
		condition: condition,
		handler:   handler,
	}
	controller.AddGenericHandler(ctx, name, FromSourceCodeCredentialHandlerToHandler(statusHandler.sync))
}

func RegisterSourceCodeCredentialGeneratingHandler(ctx context.Context, controller SourceCodeCredentialController, apply apply.Apply,
	condition condition.Cond, name string, handler SourceCodeCredentialGeneratingHandler, opts *generic.GeneratingHandlerOptions) {
	statusHandler := &sourceCodeCredentialGeneratingHandler{
		SourceCodeCredentialGeneratingHandler: handler,
		apply:                                 apply,
		name:                                  name,
		gvk:                                   controller.GroupVersionKind(),
	}
	if opts != nil {
		statusHandler.opts = *opts
	}
	controller.OnChange(ctx, name, statusHandler.Remove)
	RegisterSourceCodeCredentialStatusHandler(ctx, controller, condition, name, statusHandler.Handle)
}

type sourceCodeCredentialStatusHandler struct {
	client    SourceCodeCredentialClient
	condition condition.Cond
	handler   SourceCodeCredentialStatusHandler
}

func (a *sourceCodeCredentialStatusHandler) sync(key string, obj *v3.SourceCodeCredential) (*v3.SourceCodeCredential, error) {
	if obj == nil {
		return obj, nil
	}

	origStatus := obj.Status.DeepCopy()
	obj = obj.DeepCopy()
	newStatus, err := a.handler(obj, obj.Status)
	if err != nil {
		// Revert to old status on error
		newStatus = *origStatus.DeepCopy()
	}

	if a.condition != "" {
		if errors.IsConflict(err) {
			a.condition.SetError(&newStatus, "", nil)
		} else {
			a.condition.SetError(&newStatus, "", err)
		}
	}
	if !equality.Semantic.DeepEqual(origStatus, &newStatus) {
		if a.condition != "" {
			// Since status has changed, update the lastUpdatedTime
			a.condition.LastUpdated(&newStatus, time.Now().UTC().Format(time.RFC3339))
		}

		var newErr error
		obj.Status = newStatus
		newObj, newErr := a.client.UpdateStatus(obj)
		if err == nil {
			err = newErr
		}
		if newErr == nil {
			obj = newObj
		}
	}
	return obj, err
}

type sourceCodeCredentialGeneratingHandler struct {
	SourceCodeCredentialGeneratingHandler
	apply apply.Apply
	opts  generic.GeneratingHandlerOptions
	gvk   schema.GroupVersionKind
	name  string
}

func (a *sourceCodeCredentialGeneratingHandler) Remove(key string, obj *v3.SourceCodeCredential) (*v3.SourceCodeCredential, error) {
	if obj != nil {
		return obj, nil
	}

	obj = &v3.SourceCodeCredential{}
	obj.Namespace, obj.Name = kv.RSplit(key, "/")
	obj.SetGroupVersionKind(a.gvk)

	return nil, generic.ConfigureApplyForObject(a.apply, obj, &a.opts).
		WithOwner(obj).
		WithSetID(a.name).
		ApplyObjects()
}

func (a *sourceCodeCredentialGeneratingHandler) Handle(obj *v3.SourceCodeCredential, status v3.SourceCodeCredentialStatus) (v3.SourceCodeCredentialStatus, error) {
	objs, newStatus, err := a.SourceCodeCredentialGeneratingHandler(obj, status)
	if err != nil {
		return newStatus, err
	}

	return newStatus, generic.ConfigureApplyForObject(a.apply, obj, &a.opts).
		WithOwner(obj).
		WithSetID(a.name).
		ApplyObjects(objs...)
}
