// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v11 "github.com/rancher/rancher/pkg/generated/norman/apps/v1"
	v1 "k8s.io/api/apps/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockDaemonSetListerMockGet  sync.RWMutex
	lockDaemonSetListerMockList sync.RWMutex
)

// Ensure, that DaemonSetListerMock does implement v11.DaemonSetLister.
// If this is not the case, regenerate this file with moq.
var _ v11.DaemonSetLister = &DaemonSetListerMock{}

// DaemonSetListerMock is a mock implementation of v11.DaemonSetLister.
//
//     func TestSomethingThatUsesDaemonSetLister(t *testing.T) {
//
//         // make and configure a mocked v11.DaemonSetLister
//         mockedDaemonSetLister := &DaemonSetListerMock{
//             GetFunc: func(namespace string, name string) (*v1.DaemonSet, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v1.DaemonSet, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedDaemonSetLister in code that requires v11.DaemonSetLister
//         // and then make assertions.
//
//     }
type DaemonSetListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v1.DaemonSet, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v1.DaemonSet, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *DaemonSetListerMock) Get(namespace string, name string) (*v1.DaemonSet, error) {
	if mock.GetFunc == nil {
		panic("DaemonSetListerMock.GetFunc: method is nil but DaemonSetLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockDaemonSetListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockDaemonSetListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedDaemonSetLister.GetCalls())
func (mock *DaemonSetListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockDaemonSetListerMockGet.RLock()
	calls = mock.calls.Get
	lockDaemonSetListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *DaemonSetListerMock) List(namespace string, selector labels.Selector) ([]*v1.DaemonSet, error) {
	if mock.ListFunc == nil {
		panic("DaemonSetListerMock.ListFunc: method is nil but DaemonSetLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockDaemonSetListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockDaemonSetListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedDaemonSetLister.ListCalls())
func (mock *DaemonSetListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockDaemonSetListerMockList.RLock()
	calls = mock.calls.List
	lockDaemonSetListerMockList.RUnlock()
	return calls
}

var (
	lockDaemonSetControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockDaemonSetControllerMockAddClusterScopedHandler        sync.RWMutex
	lockDaemonSetControllerMockAddFeatureHandler              sync.RWMutex
	lockDaemonSetControllerMockAddHandler                     sync.RWMutex
	lockDaemonSetControllerMockEnqueue                        sync.RWMutex
	lockDaemonSetControllerMockEnqueueAfter                   sync.RWMutex
	lockDaemonSetControllerMockGeneric                        sync.RWMutex
	lockDaemonSetControllerMockInformer                       sync.RWMutex
	lockDaemonSetControllerMockLister                         sync.RWMutex
)

// Ensure, that DaemonSetControllerMock does implement v11.DaemonSetController.
// If this is not the case, regenerate this file with moq.
var _ v11.DaemonSetController = &DaemonSetControllerMock{}

// DaemonSetControllerMock is a mock implementation of v11.DaemonSetController.
//
//     func TestSomethingThatUsesDaemonSetController(t *testing.T) {
//
//         // make and configure a mocked v11.DaemonSetController
//         mockedDaemonSetController := &DaemonSetControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.DaemonSetHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v11.DaemonSetHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.DaemonSetHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v11.DaemonSetHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v11.DaemonSetLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedDaemonSetController in code that requires v11.DaemonSetController
//         // and then make assertions.
//
//     }
type DaemonSetControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.DaemonSetHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v11.DaemonSetHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.DaemonSetHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v11.DaemonSetHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v11.DaemonSetLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.DaemonSetHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.DaemonSetHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.DaemonSetHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v11.DaemonSetHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *DaemonSetControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.DaemonSetHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("DaemonSetControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but DaemonSetController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.DaemonSetHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockDaemonSetControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockDaemonSetControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedDaemonSetController.AddClusterScopedFeatureHandlerCalls())
func (mock *DaemonSetControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v11.DaemonSetHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.DaemonSetHandlerFunc
	}
	lockDaemonSetControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockDaemonSetControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *DaemonSetControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v11.DaemonSetHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("DaemonSetControllerMock.AddClusterScopedHandlerFunc: method is nil but DaemonSetController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.DaemonSetHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockDaemonSetControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockDaemonSetControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedDaemonSetController.AddClusterScopedHandlerCalls())
func (mock *DaemonSetControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v11.DaemonSetHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.DaemonSetHandlerFunc
	}
	lockDaemonSetControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockDaemonSetControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *DaemonSetControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.DaemonSetHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("DaemonSetControllerMock.AddFeatureHandlerFunc: method is nil but DaemonSetController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.DaemonSetHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockDaemonSetControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockDaemonSetControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedDaemonSetController.AddFeatureHandlerCalls())
func (mock *DaemonSetControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.DaemonSetHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.DaemonSetHandlerFunc
	}
	lockDaemonSetControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockDaemonSetControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *DaemonSetControllerMock) AddHandler(ctx context.Context, name string, handler v11.DaemonSetHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("DaemonSetControllerMock.AddHandlerFunc: method is nil but DaemonSetController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v11.DaemonSetHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockDaemonSetControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockDaemonSetControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedDaemonSetController.AddHandlerCalls())
func (mock *DaemonSetControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v11.DaemonSetHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v11.DaemonSetHandlerFunc
	}
	lockDaemonSetControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockDaemonSetControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *DaemonSetControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("DaemonSetControllerMock.EnqueueFunc: method is nil but DaemonSetController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockDaemonSetControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockDaemonSetControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedDaemonSetController.EnqueueCalls())
func (mock *DaemonSetControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockDaemonSetControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockDaemonSetControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *DaemonSetControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("DaemonSetControllerMock.EnqueueAfterFunc: method is nil but DaemonSetController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockDaemonSetControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockDaemonSetControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedDaemonSetController.EnqueueAfterCalls())
func (mock *DaemonSetControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockDaemonSetControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockDaemonSetControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *DaemonSetControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("DaemonSetControllerMock.GenericFunc: method is nil but DaemonSetController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockDaemonSetControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockDaemonSetControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedDaemonSetController.GenericCalls())
func (mock *DaemonSetControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockDaemonSetControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockDaemonSetControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *DaemonSetControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("DaemonSetControllerMock.InformerFunc: method is nil but DaemonSetController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockDaemonSetControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockDaemonSetControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedDaemonSetController.InformerCalls())
func (mock *DaemonSetControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockDaemonSetControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockDaemonSetControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *DaemonSetControllerMock) Lister() v11.DaemonSetLister {
	if mock.ListerFunc == nil {
		panic("DaemonSetControllerMock.ListerFunc: method is nil but DaemonSetController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockDaemonSetControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockDaemonSetControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedDaemonSetController.ListerCalls())
func (mock *DaemonSetControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockDaemonSetControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockDaemonSetControllerMockLister.RUnlock()
	return calls
}

var (
	lockDaemonSetInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockDaemonSetInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockDaemonSetInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockDaemonSetInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockDaemonSetInterfaceMockAddFeatureHandler                sync.RWMutex
	lockDaemonSetInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockDaemonSetInterfaceMockAddHandler                       sync.RWMutex
	lockDaemonSetInterfaceMockAddLifecycle                     sync.RWMutex
	lockDaemonSetInterfaceMockController                       sync.RWMutex
	lockDaemonSetInterfaceMockCreate                           sync.RWMutex
	lockDaemonSetInterfaceMockDelete                           sync.RWMutex
	lockDaemonSetInterfaceMockDeleteCollection                 sync.RWMutex
	lockDaemonSetInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockDaemonSetInterfaceMockGet                              sync.RWMutex
	lockDaemonSetInterfaceMockGetNamespaced                    sync.RWMutex
	lockDaemonSetInterfaceMockList                             sync.RWMutex
	lockDaemonSetInterfaceMockListNamespaced                   sync.RWMutex
	lockDaemonSetInterfaceMockObjectClient                     sync.RWMutex
	lockDaemonSetInterfaceMockUpdate                           sync.RWMutex
	lockDaemonSetInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that DaemonSetInterfaceMock does implement v11.DaemonSetInterface.
// If this is not the case, regenerate this file with moq.
var _ v11.DaemonSetInterface = &DaemonSetInterfaceMock{}

// DaemonSetInterfaceMock is a mock implementation of v11.DaemonSetInterface.
//
//     func TestSomethingThatUsesDaemonSetInterface(t *testing.T) {
//
//         // make and configure a mocked v11.DaemonSetInterface
//         mockedDaemonSetInterface := &DaemonSetInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.DaemonSetHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.DaemonSetLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v11.DaemonSetHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v11.DaemonSetLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.DaemonSetHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v11.DaemonSetLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v11.DaemonSetHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v11.DaemonSetLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v11.DaemonSetController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v1.DaemonSet) (*v1.DaemonSet, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v1.DaemonSet, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v1.DaemonSet, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v1.DaemonSetList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v1.DaemonSetList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v1.DaemonSet) (*v1.DaemonSet, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedDaemonSetInterface in code that requires v11.DaemonSetInterface
//         // and then make assertions.
//
//     }
type DaemonSetInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.DaemonSetHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.DaemonSetLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v11.DaemonSetHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v11.DaemonSetLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.DaemonSetHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v11.DaemonSetLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v11.DaemonSetHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v11.DaemonSetLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v11.DaemonSetController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v1.DaemonSet) (*v1.DaemonSet, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v1.DaemonSet, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v1.DaemonSet, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v1.DaemonSetList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v1.DaemonSetList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v1.DaemonSet) (*v1.DaemonSet, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.DaemonSetHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.DaemonSetLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.DaemonSetHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.DaemonSetLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.DaemonSetHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.DaemonSetLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.DaemonSetHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.DaemonSetLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v1.DaemonSet
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v1.DaemonSet
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *DaemonSetInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.DaemonSetHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("DaemonSetInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but DaemonSetInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.DaemonSetHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockDaemonSetInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockDaemonSetInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedDaemonSetInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *DaemonSetInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v11.DaemonSetHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.DaemonSetHandlerFunc
	}
	lockDaemonSetInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockDaemonSetInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *DaemonSetInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.DaemonSetLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("DaemonSetInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but DaemonSetInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.DaemonSetLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockDaemonSetInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockDaemonSetInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedDaemonSetInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *DaemonSetInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v11.DaemonSetLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.DaemonSetLifecycle
	}
	lockDaemonSetInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockDaemonSetInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *DaemonSetInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v11.DaemonSetHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("DaemonSetInterfaceMock.AddClusterScopedHandlerFunc: method is nil but DaemonSetInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.DaemonSetHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockDaemonSetInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockDaemonSetInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedDaemonSetInterface.AddClusterScopedHandlerCalls())
func (mock *DaemonSetInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v11.DaemonSetHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.DaemonSetHandlerFunc
	}
	lockDaemonSetInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockDaemonSetInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *DaemonSetInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v11.DaemonSetLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("DaemonSetInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but DaemonSetInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.DaemonSetLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockDaemonSetInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockDaemonSetInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedDaemonSetInterface.AddClusterScopedLifecycleCalls())
func (mock *DaemonSetInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v11.DaemonSetLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.DaemonSetLifecycle
	}
	lockDaemonSetInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockDaemonSetInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *DaemonSetInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.DaemonSetHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("DaemonSetInterfaceMock.AddFeatureHandlerFunc: method is nil but DaemonSetInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.DaemonSetHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockDaemonSetInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockDaemonSetInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedDaemonSetInterface.AddFeatureHandlerCalls())
func (mock *DaemonSetInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.DaemonSetHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.DaemonSetHandlerFunc
	}
	lockDaemonSetInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockDaemonSetInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *DaemonSetInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v11.DaemonSetLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("DaemonSetInterfaceMock.AddFeatureLifecycleFunc: method is nil but DaemonSetInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.DaemonSetLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockDaemonSetInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockDaemonSetInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedDaemonSetInterface.AddFeatureLifecycleCalls())
func (mock *DaemonSetInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v11.DaemonSetLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.DaemonSetLifecycle
	}
	lockDaemonSetInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockDaemonSetInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *DaemonSetInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v11.DaemonSetHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("DaemonSetInterfaceMock.AddHandlerFunc: method is nil but DaemonSetInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v11.DaemonSetHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockDaemonSetInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockDaemonSetInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedDaemonSetInterface.AddHandlerCalls())
func (mock *DaemonSetInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v11.DaemonSetHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v11.DaemonSetHandlerFunc
	}
	lockDaemonSetInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockDaemonSetInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *DaemonSetInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v11.DaemonSetLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("DaemonSetInterfaceMock.AddLifecycleFunc: method is nil but DaemonSetInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.DaemonSetLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockDaemonSetInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockDaemonSetInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedDaemonSetInterface.AddLifecycleCalls())
func (mock *DaemonSetInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v11.DaemonSetLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.DaemonSetLifecycle
	}
	lockDaemonSetInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockDaemonSetInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *DaemonSetInterfaceMock) Controller() v11.DaemonSetController {
	if mock.ControllerFunc == nil {
		panic("DaemonSetInterfaceMock.ControllerFunc: method is nil but DaemonSetInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockDaemonSetInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockDaemonSetInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedDaemonSetInterface.ControllerCalls())
func (mock *DaemonSetInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockDaemonSetInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockDaemonSetInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *DaemonSetInterfaceMock) Create(in1 *v1.DaemonSet) (*v1.DaemonSet, error) {
	if mock.CreateFunc == nil {
		panic("DaemonSetInterfaceMock.CreateFunc: method is nil but DaemonSetInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v1.DaemonSet
	}{
		In1: in1,
	}
	lockDaemonSetInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockDaemonSetInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedDaemonSetInterface.CreateCalls())
func (mock *DaemonSetInterfaceMock) CreateCalls() []struct {
	In1 *v1.DaemonSet
} {
	var calls []struct {
		In1 *v1.DaemonSet
	}
	lockDaemonSetInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockDaemonSetInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *DaemonSetInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("DaemonSetInterfaceMock.DeleteFunc: method is nil but DaemonSetInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockDaemonSetInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockDaemonSetInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedDaemonSetInterface.DeleteCalls())
func (mock *DaemonSetInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockDaemonSetInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockDaemonSetInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *DaemonSetInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("DaemonSetInterfaceMock.DeleteCollectionFunc: method is nil but DaemonSetInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockDaemonSetInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockDaemonSetInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedDaemonSetInterface.DeleteCollectionCalls())
func (mock *DaemonSetInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockDaemonSetInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockDaemonSetInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *DaemonSetInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("DaemonSetInterfaceMock.DeleteNamespacedFunc: method is nil but DaemonSetInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockDaemonSetInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockDaemonSetInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedDaemonSetInterface.DeleteNamespacedCalls())
func (mock *DaemonSetInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockDaemonSetInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockDaemonSetInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *DaemonSetInterfaceMock) Get(name string, opts metav1.GetOptions) (*v1.DaemonSet, error) {
	if mock.GetFunc == nil {
		panic("DaemonSetInterfaceMock.GetFunc: method is nil but DaemonSetInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockDaemonSetInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockDaemonSetInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedDaemonSetInterface.GetCalls())
func (mock *DaemonSetInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockDaemonSetInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockDaemonSetInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *DaemonSetInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v1.DaemonSet, error) {
	if mock.GetNamespacedFunc == nil {
		panic("DaemonSetInterfaceMock.GetNamespacedFunc: method is nil but DaemonSetInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockDaemonSetInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockDaemonSetInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedDaemonSetInterface.GetNamespacedCalls())
func (mock *DaemonSetInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockDaemonSetInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockDaemonSetInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *DaemonSetInterfaceMock) List(opts metav1.ListOptions) (*v1.DaemonSetList, error) {
	if mock.ListFunc == nil {
		panic("DaemonSetInterfaceMock.ListFunc: method is nil but DaemonSetInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockDaemonSetInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockDaemonSetInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedDaemonSetInterface.ListCalls())
func (mock *DaemonSetInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockDaemonSetInterfaceMockList.RLock()
	calls = mock.calls.List
	lockDaemonSetInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *DaemonSetInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v1.DaemonSetList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("DaemonSetInterfaceMock.ListNamespacedFunc: method is nil but DaemonSetInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockDaemonSetInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockDaemonSetInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedDaemonSetInterface.ListNamespacedCalls())
func (mock *DaemonSetInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockDaemonSetInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockDaemonSetInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *DaemonSetInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("DaemonSetInterfaceMock.ObjectClientFunc: method is nil but DaemonSetInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockDaemonSetInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockDaemonSetInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedDaemonSetInterface.ObjectClientCalls())
func (mock *DaemonSetInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockDaemonSetInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockDaemonSetInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *DaemonSetInterfaceMock) Update(in1 *v1.DaemonSet) (*v1.DaemonSet, error) {
	if mock.UpdateFunc == nil {
		panic("DaemonSetInterfaceMock.UpdateFunc: method is nil but DaemonSetInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v1.DaemonSet
	}{
		In1: in1,
	}
	lockDaemonSetInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockDaemonSetInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedDaemonSetInterface.UpdateCalls())
func (mock *DaemonSetInterfaceMock) UpdateCalls() []struct {
	In1 *v1.DaemonSet
} {
	var calls []struct {
		In1 *v1.DaemonSet
	}
	lockDaemonSetInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockDaemonSetInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *DaemonSetInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("DaemonSetInterfaceMock.WatchFunc: method is nil but DaemonSetInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockDaemonSetInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockDaemonSetInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedDaemonSetInterface.WatchCalls())
func (mock *DaemonSetInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockDaemonSetInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockDaemonSetInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockDaemonSetsGetterMockDaemonSets sync.RWMutex
)

// Ensure, that DaemonSetsGetterMock does implement v11.DaemonSetsGetter.
// If this is not the case, regenerate this file with moq.
var _ v11.DaemonSetsGetter = &DaemonSetsGetterMock{}

// DaemonSetsGetterMock is a mock implementation of v11.DaemonSetsGetter.
//
//     func TestSomethingThatUsesDaemonSetsGetter(t *testing.T) {
//
//         // make and configure a mocked v11.DaemonSetsGetter
//         mockedDaemonSetsGetter := &DaemonSetsGetterMock{
//             DaemonSetsFunc: func(namespace string) v11.DaemonSetInterface {
// 	               panic("mock out the DaemonSets method")
//             },
//         }
//
//         // use mockedDaemonSetsGetter in code that requires v11.DaemonSetsGetter
//         // and then make assertions.
//
//     }
type DaemonSetsGetterMock struct {
	// DaemonSetsFunc mocks the DaemonSets method.
	DaemonSetsFunc func(namespace string) v11.DaemonSetInterface

	// calls tracks calls to the methods.
	calls struct {
		// DaemonSets holds details about calls to the DaemonSets method.
		DaemonSets []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// DaemonSets calls DaemonSetsFunc.
func (mock *DaemonSetsGetterMock) DaemonSets(namespace string) v11.DaemonSetInterface {
	if mock.DaemonSetsFunc == nil {
		panic("DaemonSetsGetterMock.DaemonSetsFunc: method is nil but DaemonSetsGetter.DaemonSets was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockDaemonSetsGetterMockDaemonSets.Lock()
	mock.calls.DaemonSets = append(mock.calls.DaemonSets, callInfo)
	lockDaemonSetsGetterMockDaemonSets.Unlock()
	return mock.DaemonSetsFunc(namespace)
}

// DaemonSetsCalls gets all the calls that were made to DaemonSets.
// Check the length with:
//     len(mockedDaemonSetsGetter.DaemonSetsCalls())
func (mock *DaemonSetsGetterMock) DaemonSetsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockDaemonSetsGetterMockDaemonSets.RLock()
	calls = mock.calls.DaemonSets
	lockDaemonSetsGetterMockDaemonSets.RUnlock()
	return calls
}
