// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v11 "github.com/rancher/rancher/pkg/generated/norman/apps/v1"
	v1 "k8s.io/api/apps/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockStatefulSetListerMockGet  sync.RWMutex
	lockStatefulSetListerMockList sync.RWMutex
)

// Ensure, that StatefulSetListerMock does implement v11.StatefulSetLister.
// If this is not the case, regenerate this file with moq.
var _ v11.StatefulSetLister = &StatefulSetListerMock{}

// StatefulSetListerMock is a mock implementation of v11.StatefulSetLister.
//
//     func TestSomethingThatUsesStatefulSetLister(t *testing.T) {
//
//         // make and configure a mocked v11.StatefulSetLister
//         mockedStatefulSetLister := &StatefulSetListerMock{
//             GetFunc: func(namespace string, name string) (*v1.StatefulSet, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v1.StatefulSet, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedStatefulSetLister in code that requires v11.StatefulSetLister
//         // and then make assertions.
//
//     }
type StatefulSetListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v1.StatefulSet, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v1.StatefulSet, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *StatefulSetListerMock) Get(namespace string, name string) (*v1.StatefulSet, error) {
	if mock.GetFunc == nil {
		panic("StatefulSetListerMock.GetFunc: method is nil but StatefulSetLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockStatefulSetListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockStatefulSetListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedStatefulSetLister.GetCalls())
func (mock *StatefulSetListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockStatefulSetListerMockGet.RLock()
	calls = mock.calls.Get
	lockStatefulSetListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *StatefulSetListerMock) List(namespace string, selector labels.Selector) ([]*v1.StatefulSet, error) {
	if mock.ListFunc == nil {
		panic("StatefulSetListerMock.ListFunc: method is nil but StatefulSetLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockStatefulSetListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockStatefulSetListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedStatefulSetLister.ListCalls())
func (mock *StatefulSetListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockStatefulSetListerMockList.RLock()
	calls = mock.calls.List
	lockStatefulSetListerMockList.RUnlock()
	return calls
}

var (
	lockStatefulSetControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockStatefulSetControllerMockAddClusterScopedHandler        sync.RWMutex
	lockStatefulSetControllerMockAddFeatureHandler              sync.RWMutex
	lockStatefulSetControllerMockAddHandler                     sync.RWMutex
	lockStatefulSetControllerMockEnqueue                        sync.RWMutex
	lockStatefulSetControllerMockEnqueueAfter                   sync.RWMutex
	lockStatefulSetControllerMockGeneric                        sync.RWMutex
	lockStatefulSetControllerMockInformer                       sync.RWMutex
	lockStatefulSetControllerMockLister                         sync.RWMutex
)

// Ensure, that StatefulSetControllerMock does implement v11.StatefulSetController.
// If this is not the case, regenerate this file with moq.
var _ v11.StatefulSetController = &StatefulSetControllerMock{}

// StatefulSetControllerMock is a mock implementation of v11.StatefulSetController.
//
//     func TestSomethingThatUsesStatefulSetController(t *testing.T) {
//
//         // make and configure a mocked v11.StatefulSetController
//         mockedStatefulSetController := &StatefulSetControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.StatefulSetHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v11.StatefulSetHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.StatefulSetHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v11.StatefulSetHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v11.StatefulSetLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedStatefulSetController in code that requires v11.StatefulSetController
//         // and then make assertions.
//
//     }
type StatefulSetControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.StatefulSetHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v11.StatefulSetHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.StatefulSetHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v11.StatefulSetHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v11.StatefulSetLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.StatefulSetHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.StatefulSetHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.StatefulSetHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v11.StatefulSetHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *StatefulSetControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.StatefulSetHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("StatefulSetControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but StatefulSetController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.StatefulSetHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockStatefulSetControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockStatefulSetControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedStatefulSetController.AddClusterScopedFeatureHandlerCalls())
func (mock *StatefulSetControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v11.StatefulSetHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.StatefulSetHandlerFunc
	}
	lockStatefulSetControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockStatefulSetControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *StatefulSetControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v11.StatefulSetHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("StatefulSetControllerMock.AddClusterScopedHandlerFunc: method is nil but StatefulSetController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.StatefulSetHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockStatefulSetControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockStatefulSetControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedStatefulSetController.AddClusterScopedHandlerCalls())
func (mock *StatefulSetControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v11.StatefulSetHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.StatefulSetHandlerFunc
	}
	lockStatefulSetControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockStatefulSetControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *StatefulSetControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.StatefulSetHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("StatefulSetControllerMock.AddFeatureHandlerFunc: method is nil but StatefulSetController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.StatefulSetHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockStatefulSetControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockStatefulSetControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedStatefulSetController.AddFeatureHandlerCalls())
func (mock *StatefulSetControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.StatefulSetHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.StatefulSetHandlerFunc
	}
	lockStatefulSetControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockStatefulSetControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *StatefulSetControllerMock) AddHandler(ctx context.Context, name string, handler v11.StatefulSetHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("StatefulSetControllerMock.AddHandlerFunc: method is nil but StatefulSetController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v11.StatefulSetHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockStatefulSetControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockStatefulSetControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedStatefulSetController.AddHandlerCalls())
func (mock *StatefulSetControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v11.StatefulSetHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v11.StatefulSetHandlerFunc
	}
	lockStatefulSetControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockStatefulSetControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *StatefulSetControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("StatefulSetControllerMock.EnqueueFunc: method is nil but StatefulSetController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockStatefulSetControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockStatefulSetControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedStatefulSetController.EnqueueCalls())
func (mock *StatefulSetControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockStatefulSetControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockStatefulSetControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *StatefulSetControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("StatefulSetControllerMock.EnqueueAfterFunc: method is nil but StatefulSetController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockStatefulSetControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockStatefulSetControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedStatefulSetController.EnqueueAfterCalls())
func (mock *StatefulSetControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockStatefulSetControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockStatefulSetControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *StatefulSetControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("StatefulSetControllerMock.GenericFunc: method is nil but StatefulSetController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockStatefulSetControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockStatefulSetControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedStatefulSetController.GenericCalls())
func (mock *StatefulSetControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockStatefulSetControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockStatefulSetControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *StatefulSetControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("StatefulSetControllerMock.InformerFunc: method is nil but StatefulSetController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockStatefulSetControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockStatefulSetControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedStatefulSetController.InformerCalls())
func (mock *StatefulSetControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockStatefulSetControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockStatefulSetControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *StatefulSetControllerMock) Lister() v11.StatefulSetLister {
	if mock.ListerFunc == nil {
		panic("StatefulSetControllerMock.ListerFunc: method is nil but StatefulSetController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockStatefulSetControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockStatefulSetControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedStatefulSetController.ListerCalls())
func (mock *StatefulSetControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockStatefulSetControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockStatefulSetControllerMockLister.RUnlock()
	return calls
}

var (
	lockStatefulSetInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockStatefulSetInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockStatefulSetInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockStatefulSetInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockStatefulSetInterfaceMockAddFeatureHandler                sync.RWMutex
	lockStatefulSetInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockStatefulSetInterfaceMockAddHandler                       sync.RWMutex
	lockStatefulSetInterfaceMockAddLifecycle                     sync.RWMutex
	lockStatefulSetInterfaceMockController                       sync.RWMutex
	lockStatefulSetInterfaceMockCreate                           sync.RWMutex
	lockStatefulSetInterfaceMockDelete                           sync.RWMutex
	lockStatefulSetInterfaceMockDeleteCollection                 sync.RWMutex
	lockStatefulSetInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockStatefulSetInterfaceMockGet                              sync.RWMutex
	lockStatefulSetInterfaceMockGetNamespaced                    sync.RWMutex
	lockStatefulSetInterfaceMockList                             sync.RWMutex
	lockStatefulSetInterfaceMockListNamespaced                   sync.RWMutex
	lockStatefulSetInterfaceMockObjectClient                     sync.RWMutex
	lockStatefulSetInterfaceMockUpdate                           sync.RWMutex
	lockStatefulSetInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that StatefulSetInterfaceMock does implement v11.StatefulSetInterface.
// If this is not the case, regenerate this file with moq.
var _ v11.StatefulSetInterface = &StatefulSetInterfaceMock{}

// StatefulSetInterfaceMock is a mock implementation of v11.StatefulSetInterface.
//
//     func TestSomethingThatUsesStatefulSetInterface(t *testing.T) {
//
//         // make and configure a mocked v11.StatefulSetInterface
//         mockedStatefulSetInterface := &StatefulSetInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.StatefulSetHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.StatefulSetLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v11.StatefulSetHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v11.StatefulSetLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.StatefulSetHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v11.StatefulSetLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v11.StatefulSetHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v11.StatefulSetLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v11.StatefulSetController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v1.StatefulSet) (*v1.StatefulSet, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v1.StatefulSet, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v1.StatefulSet, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v1.StatefulSetList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v1.StatefulSetList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v1.StatefulSet) (*v1.StatefulSet, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedStatefulSetInterface in code that requires v11.StatefulSetInterface
//         // and then make assertions.
//
//     }
type StatefulSetInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.StatefulSetHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.StatefulSetLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v11.StatefulSetHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v11.StatefulSetLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.StatefulSetHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v11.StatefulSetLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v11.StatefulSetHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v11.StatefulSetLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v11.StatefulSetController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v1.StatefulSet) (*v1.StatefulSet, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v1.StatefulSet, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v1.StatefulSet, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v1.StatefulSetList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v1.StatefulSetList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v1.StatefulSet) (*v1.StatefulSet, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.StatefulSetHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.StatefulSetLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.StatefulSetHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.StatefulSetLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.StatefulSetHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.StatefulSetLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.StatefulSetHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.StatefulSetLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v1.StatefulSet
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v1.StatefulSet
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *StatefulSetInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.StatefulSetHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("StatefulSetInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but StatefulSetInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.StatefulSetHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockStatefulSetInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockStatefulSetInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedStatefulSetInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *StatefulSetInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v11.StatefulSetHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.StatefulSetHandlerFunc
	}
	lockStatefulSetInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockStatefulSetInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *StatefulSetInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.StatefulSetLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("StatefulSetInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but StatefulSetInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.StatefulSetLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockStatefulSetInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockStatefulSetInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedStatefulSetInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *StatefulSetInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v11.StatefulSetLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.StatefulSetLifecycle
	}
	lockStatefulSetInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockStatefulSetInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *StatefulSetInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v11.StatefulSetHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("StatefulSetInterfaceMock.AddClusterScopedHandlerFunc: method is nil but StatefulSetInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.StatefulSetHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockStatefulSetInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockStatefulSetInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedStatefulSetInterface.AddClusterScopedHandlerCalls())
func (mock *StatefulSetInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v11.StatefulSetHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.StatefulSetHandlerFunc
	}
	lockStatefulSetInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockStatefulSetInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *StatefulSetInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v11.StatefulSetLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("StatefulSetInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but StatefulSetInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.StatefulSetLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockStatefulSetInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockStatefulSetInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedStatefulSetInterface.AddClusterScopedLifecycleCalls())
func (mock *StatefulSetInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v11.StatefulSetLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.StatefulSetLifecycle
	}
	lockStatefulSetInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockStatefulSetInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *StatefulSetInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.StatefulSetHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("StatefulSetInterfaceMock.AddFeatureHandlerFunc: method is nil but StatefulSetInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.StatefulSetHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockStatefulSetInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockStatefulSetInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedStatefulSetInterface.AddFeatureHandlerCalls())
func (mock *StatefulSetInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.StatefulSetHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.StatefulSetHandlerFunc
	}
	lockStatefulSetInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockStatefulSetInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *StatefulSetInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v11.StatefulSetLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("StatefulSetInterfaceMock.AddFeatureLifecycleFunc: method is nil but StatefulSetInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.StatefulSetLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockStatefulSetInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockStatefulSetInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedStatefulSetInterface.AddFeatureLifecycleCalls())
func (mock *StatefulSetInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v11.StatefulSetLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.StatefulSetLifecycle
	}
	lockStatefulSetInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockStatefulSetInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *StatefulSetInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v11.StatefulSetHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("StatefulSetInterfaceMock.AddHandlerFunc: method is nil but StatefulSetInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v11.StatefulSetHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockStatefulSetInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockStatefulSetInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedStatefulSetInterface.AddHandlerCalls())
func (mock *StatefulSetInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v11.StatefulSetHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v11.StatefulSetHandlerFunc
	}
	lockStatefulSetInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockStatefulSetInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *StatefulSetInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v11.StatefulSetLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("StatefulSetInterfaceMock.AddLifecycleFunc: method is nil but StatefulSetInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.StatefulSetLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockStatefulSetInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockStatefulSetInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedStatefulSetInterface.AddLifecycleCalls())
func (mock *StatefulSetInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v11.StatefulSetLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.StatefulSetLifecycle
	}
	lockStatefulSetInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockStatefulSetInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *StatefulSetInterfaceMock) Controller() v11.StatefulSetController {
	if mock.ControllerFunc == nil {
		panic("StatefulSetInterfaceMock.ControllerFunc: method is nil but StatefulSetInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockStatefulSetInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockStatefulSetInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedStatefulSetInterface.ControllerCalls())
func (mock *StatefulSetInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockStatefulSetInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockStatefulSetInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *StatefulSetInterfaceMock) Create(in1 *v1.StatefulSet) (*v1.StatefulSet, error) {
	if mock.CreateFunc == nil {
		panic("StatefulSetInterfaceMock.CreateFunc: method is nil but StatefulSetInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v1.StatefulSet
	}{
		In1: in1,
	}
	lockStatefulSetInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockStatefulSetInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedStatefulSetInterface.CreateCalls())
func (mock *StatefulSetInterfaceMock) CreateCalls() []struct {
	In1 *v1.StatefulSet
} {
	var calls []struct {
		In1 *v1.StatefulSet
	}
	lockStatefulSetInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockStatefulSetInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *StatefulSetInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("StatefulSetInterfaceMock.DeleteFunc: method is nil but StatefulSetInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockStatefulSetInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockStatefulSetInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedStatefulSetInterface.DeleteCalls())
func (mock *StatefulSetInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockStatefulSetInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockStatefulSetInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *StatefulSetInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("StatefulSetInterfaceMock.DeleteCollectionFunc: method is nil but StatefulSetInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockStatefulSetInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockStatefulSetInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedStatefulSetInterface.DeleteCollectionCalls())
func (mock *StatefulSetInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockStatefulSetInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockStatefulSetInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *StatefulSetInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("StatefulSetInterfaceMock.DeleteNamespacedFunc: method is nil but StatefulSetInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockStatefulSetInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockStatefulSetInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedStatefulSetInterface.DeleteNamespacedCalls())
func (mock *StatefulSetInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockStatefulSetInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockStatefulSetInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *StatefulSetInterfaceMock) Get(name string, opts metav1.GetOptions) (*v1.StatefulSet, error) {
	if mock.GetFunc == nil {
		panic("StatefulSetInterfaceMock.GetFunc: method is nil but StatefulSetInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockStatefulSetInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockStatefulSetInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedStatefulSetInterface.GetCalls())
func (mock *StatefulSetInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockStatefulSetInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockStatefulSetInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *StatefulSetInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v1.StatefulSet, error) {
	if mock.GetNamespacedFunc == nil {
		panic("StatefulSetInterfaceMock.GetNamespacedFunc: method is nil but StatefulSetInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockStatefulSetInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockStatefulSetInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedStatefulSetInterface.GetNamespacedCalls())
func (mock *StatefulSetInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockStatefulSetInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockStatefulSetInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *StatefulSetInterfaceMock) List(opts metav1.ListOptions) (*v1.StatefulSetList, error) {
	if mock.ListFunc == nil {
		panic("StatefulSetInterfaceMock.ListFunc: method is nil but StatefulSetInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockStatefulSetInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockStatefulSetInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedStatefulSetInterface.ListCalls())
func (mock *StatefulSetInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockStatefulSetInterfaceMockList.RLock()
	calls = mock.calls.List
	lockStatefulSetInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *StatefulSetInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v1.StatefulSetList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("StatefulSetInterfaceMock.ListNamespacedFunc: method is nil but StatefulSetInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockStatefulSetInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockStatefulSetInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedStatefulSetInterface.ListNamespacedCalls())
func (mock *StatefulSetInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockStatefulSetInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockStatefulSetInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *StatefulSetInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("StatefulSetInterfaceMock.ObjectClientFunc: method is nil but StatefulSetInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockStatefulSetInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockStatefulSetInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedStatefulSetInterface.ObjectClientCalls())
func (mock *StatefulSetInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockStatefulSetInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockStatefulSetInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *StatefulSetInterfaceMock) Update(in1 *v1.StatefulSet) (*v1.StatefulSet, error) {
	if mock.UpdateFunc == nil {
		panic("StatefulSetInterfaceMock.UpdateFunc: method is nil but StatefulSetInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v1.StatefulSet
	}{
		In1: in1,
	}
	lockStatefulSetInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockStatefulSetInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedStatefulSetInterface.UpdateCalls())
func (mock *StatefulSetInterfaceMock) UpdateCalls() []struct {
	In1 *v1.StatefulSet
} {
	var calls []struct {
		In1 *v1.StatefulSet
	}
	lockStatefulSetInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockStatefulSetInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *StatefulSetInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("StatefulSetInterfaceMock.WatchFunc: method is nil but StatefulSetInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockStatefulSetInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockStatefulSetInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedStatefulSetInterface.WatchCalls())
func (mock *StatefulSetInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockStatefulSetInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockStatefulSetInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockStatefulSetsGetterMockStatefulSets sync.RWMutex
)

// Ensure, that StatefulSetsGetterMock does implement v11.StatefulSetsGetter.
// If this is not the case, regenerate this file with moq.
var _ v11.StatefulSetsGetter = &StatefulSetsGetterMock{}

// StatefulSetsGetterMock is a mock implementation of v11.StatefulSetsGetter.
//
//     func TestSomethingThatUsesStatefulSetsGetter(t *testing.T) {
//
//         // make and configure a mocked v11.StatefulSetsGetter
//         mockedStatefulSetsGetter := &StatefulSetsGetterMock{
//             StatefulSetsFunc: func(namespace string) v11.StatefulSetInterface {
// 	               panic("mock out the StatefulSets method")
//             },
//         }
//
//         // use mockedStatefulSetsGetter in code that requires v11.StatefulSetsGetter
//         // and then make assertions.
//
//     }
type StatefulSetsGetterMock struct {
	// StatefulSetsFunc mocks the StatefulSets method.
	StatefulSetsFunc func(namespace string) v11.StatefulSetInterface

	// calls tracks calls to the methods.
	calls struct {
		// StatefulSets holds details about calls to the StatefulSets method.
		StatefulSets []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// StatefulSets calls StatefulSetsFunc.
func (mock *StatefulSetsGetterMock) StatefulSets(namespace string) v11.StatefulSetInterface {
	if mock.StatefulSetsFunc == nil {
		panic("StatefulSetsGetterMock.StatefulSetsFunc: method is nil but StatefulSetsGetter.StatefulSets was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockStatefulSetsGetterMockStatefulSets.Lock()
	mock.calls.StatefulSets = append(mock.calls.StatefulSets, callInfo)
	lockStatefulSetsGetterMockStatefulSets.Unlock()
	return mock.StatefulSetsFunc(namespace)
}

// StatefulSetsCalls gets all the calls that were made to StatefulSets.
// Check the length with:
//     len(mockedStatefulSetsGetter.StatefulSetsCalls())
func (mock *StatefulSetsGetterMock) StatefulSetsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockStatefulSetsGetterMockStatefulSets.RLock()
	calls = mock.calls.StatefulSets
	lockStatefulSetsGetterMockStatefulSets.RUnlock()
	return calls
}
