// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v1beta11 "github.com/rancher/rancher/pkg/generated/norman/batch/v1beta1"
	"k8s.io/api/batch/v1beta1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockCronJobListerMockGet  sync.RWMutex
	lockCronJobListerMockList sync.RWMutex
)

// Ensure, that CronJobListerMock does implement v1beta11.CronJobLister.
// If this is not the case, regenerate this file with moq.
var _ v1beta11.CronJobLister = &CronJobListerMock{}

// CronJobListerMock is a mock implementation of v1beta11.CronJobLister.
//
//     func TestSomethingThatUsesCronJobLister(t *testing.T) {
//
//         // make and configure a mocked v1beta11.CronJobLister
//         mockedCronJobLister := &CronJobListerMock{
//             GetFunc: func(namespace string, name string) (*v1beta1.CronJob, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v1beta1.CronJob, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedCronJobLister in code that requires v1beta11.CronJobLister
//         // and then make assertions.
//
//     }
type CronJobListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v1beta1.CronJob, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v1beta1.CronJob, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *CronJobListerMock) Get(namespace string, name string) (*v1beta1.CronJob, error) {
	if mock.GetFunc == nil {
		panic("CronJobListerMock.GetFunc: method is nil but CronJobLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockCronJobListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockCronJobListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedCronJobLister.GetCalls())
func (mock *CronJobListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockCronJobListerMockGet.RLock()
	calls = mock.calls.Get
	lockCronJobListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *CronJobListerMock) List(namespace string, selector labels.Selector) ([]*v1beta1.CronJob, error) {
	if mock.ListFunc == nil {
		panic("CronJobListerMock.ListFunc: method is nil but CronJobLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockCronJobListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockCronJobListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedCronJobLister.ListCalls())
func (mock *CronJobListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockCronJobListerMockList.RLock()
	calls = mock.calls.List
	lockCronJobListerMockList.RUnlock()
	return calls
}

var (
	lockCronJobControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockCronJobControllerMockAddClusterScopedHandler        sync.RWMutex
	lockCronJobControllerMockAddFeatureHandler              sync.RWMutex
	lockCronJobControllerMockAddHandler                     sync.RWMutex
	lockCronJobControllerMockEnqueue                        sync.RWMutex
	lockCronJobControllerMockEnqueueAfter                   sync.RWMutex
	lockCronJobControllerMockGeneric                        sync.RWMutex
	lockCronJobControllerMockInformer                       sync.RWMutex
	lockCronJobControllerMockLister                         sync.RWMutex
)

// Ensure, that CronJobControllerMock does implement v1beta11.CronJobController.
// If this is not the case, regenerate this file with moq.
var _ v1beta11.CronJobController = &CronJobControllerMock{}

// CronJobControllerMock is a mock implementation of v1beta11.CronJobController.
//
//     func TestSomethingThatUsesCronJobController(t *testing.T) {
//
//         // make and configure a mocked v1beta11.CronJobController
//         mockedCronJobController := &CronJobControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v1beta11.CronJobHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v1beta11.CronJobHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v1beta11.CronJobHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v1beta11.CronJobHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v1beta11.CronJobLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedCronJobController in code that requires v1beta11.CronJobController
//         // and then make assertions.
//
//     }
type CronJobControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v1beta11.CronJobHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v1beta11.CronJobHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v1beta11.CronJobHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v1beta11.CronJobHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v1beta11.CronJobLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v1beta11.CronJobHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v1beta11.CronJobHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v1beta11.CronJobHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v1beta11.CronJobHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *CronJobControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v1beta11.CronJobHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("CronJobControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but CronJobController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v1beta11.CronJobHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockCronJobControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockCronJobControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedCronJobController.AddClusterScopedFeatureHandlerCalls())
func (mock *CronJobControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v1beta11.CronJobHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v1beta11.CronJobHandlerFunc
	}
	lockCronJobControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockCronJobControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *CronJobControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v1beta11.CronJobHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("CronJobControllerMock.AddClusterScopedHandlerFunc: method is nil but CronJobController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v1beta11.CronJobHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockCronJobControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockCronJobControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedCronJobController.AddClusterScopedHandlerCalls())
func (mock *CronJobControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v1beta11.CronJobHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v1beta11.CronJobHandlerFunc
	}
	lockCronJobControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockCronJobControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *CronJobControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v1beta11.CronJobHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("CronJobControllerMock.AddFeatureHandlerFunc: method is nil but CronJobController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v1beta11.CronJobHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockCronJobControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockCronJobControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedCronJobController.AddFeatureHandlerCalls())
func (mock *CronJobControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v1beta11.CronJobHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v1beta11.CronJobHandlerFunc
	}
	lockCronJobControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockCronJobControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *CronJobControllerMock) AddHandler(ctx context.Context, name string, handler v1beta11.CronJobHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("CronJobControllerMock.AddHandlerFunc: method is nil but CronJobController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v1beta11.CronJobHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockCronJobControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockCronJobControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedCronJobController.AddHandlerCalls())
func (mock *CronJobControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v1beta11.CronJobHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v1beta11.CronJobHandlerFunc
	}
	lockCronJobControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockCronJobControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *CronJobControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("CronJobControllerMock.EnqueueFunc: method is nil but CronJobController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockCronJobControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockCronJobControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedCronJobController.EnqueueCalls())
func (mock *CronJobControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockCronJobControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockCronJobControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *CronJobControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("CronJobControllerMock.EnqueueAfterFunc: method is nil but CronJobController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockCronJobControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockCronJobControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedCronJobController.EnqueueAfterCalls())
func (mock *CronJobControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockCronJobControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockCronJobControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *CronJobControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("CronJobControllerMock.GenericFunc: method is nil but CronJobController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockCronJobControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockCronJobControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedCronJobController.GenericCalls())
func (mock *CronJobControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockCronJobControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockCronJobControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *CronJobControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("CronJobControllerMock.InformerFunc: method is nil but CronJobController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockCronJobControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockCronJobControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedCronJobController.InformerCalls())
func (mock *CronJobControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockCronJobControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockCronJobControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *CronJobControllerMock) Lister() v1beta11.CronJobLister {
	if mock.ListerFunc == nil {
		panic("CronJobControllerMock.ListerFunc: method is nil but CronJobController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockCronJobControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockCronJobControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedCronJobController.ListerCalls())
func (mock *CronJobControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockCronJobControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockCronJobControllerMockLister.RUnlock()
	return calls
}

var (
	lockCronJobInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockCronJobInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockCronJobInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockCronJobInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockCronJobInterfaceMockAddFeatureHandler                sync.RWMutex
	lockCronJobInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockCronJobInterfaceMockAddHandler                       sync.RWMutex
	lockCronJobInterfaceMockAddLifecycle                     sync.RWMutex
	lockCronJobInterfaceMockController                       sync.RWMutex
	lockCronJobInterfaceMockCreate                           sync.RWMutex
	lockCronJobInterfaceMockDelete                           sync.RWMutex
	lockCronJobInterfaceMockDeleteCollection                 sync.RWMutex
	lockCronJobInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockCronJobInterfaceMockGet                              sync.RWMutex
	lockCronJobInterfaceMockGetNamespaced                    sync.RWMutex
	lockCronJobInterfaceMockList                             sync.RWMutex
	lockCronJobInterfaceMockListNamespaced                   sync.RWMutex
	lockCronJobInterfaceMockObjectClient                     sync.RWMutex
	lockCronJobInterfaceMockUpdate                           sync.RWMutex
	lockCronJobInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that CronJobInterfaceMock does implement v1beta11.CronJobInterface.
// If this is not the case, regenerate this file with moq.
var _ v1beta11.CronJobInterface = &CronJobInterfaceMock{}

// CronJobInterfaceMock is a mock implementation of v1beta11.CronJobInterface.
//
//     func TestSomethingThatUsesCronJobInterface(t *testing.T) {
//
//         // make and configure a mocked v1beta11.CronJobInterface
//         mockedCronJobInterface := &CronJobInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v1beta11.CronJobHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v1beta11.CronJobLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v1beta11.CronJobHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v1beta11.CronJobLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v1beta11.CronJobHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v1beta11.CronJobLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v1beta11.CronJobHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v1beta11.CronJobLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v1beta11.CronJobController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v1beta1.CronJob) (*v1beta1.CronJob, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v1beta1.CronJob, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v1beta1.CronJob, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v1beta1.CronJobList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v1beta1.CronJobList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v1beta1.CronJob) (*v1beta1.CronJob, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedCronJobInterface in code that requires v1beta11.CronJobInterface
//         // and then make assertions.
//
//     }
type CronJobInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v1beta11.CronJobHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v1beta11.CronJobLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v1beta11.CronJobHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v1beta11.CronJobLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v1beta11.CronJobHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v1beta11.CronJobLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v1beta11.CronJobHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v1beta11.CronJobLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v1beta11.CronJobController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v1beta1.CronJob) (*v1beta1.CronJob, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v1beta1.CronJob, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v1beta1.CronJob, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v1beta1.CronJobList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v1beta1.CronJobList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v1beta1.CronJob) (*v1beta1.CronJob, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v1beta11.CronJobHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v1beta11.CronJobLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v1beta11.CronJobHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v1beta11.CronJobLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v1beta11.CronJobHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v1beta11.CronJobLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v1beta11.CronJobHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v1beta11.CronJobLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v1beta1.CronJob
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v1beta1.CronJob
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *CronJobInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v1beta11.CronJobHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("CronJobInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but CronJobInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v1beta11.CronJobHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockCronJobInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockCronJobInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedCronJobInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *CronJobInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v1beta11.CronJobHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v1beta11.CronJobHandlerFunc
	}
	lockCronJobInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockCronJobInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *CronJobInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v1beta11.CronJobLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("CronJobInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but CronJobInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v1beta11.CronJobLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockCronJobInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockCronJobInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedCronJobInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *CronJobInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v1beta11.CronJobLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v1beta11.CronJobLifecycle
	}
	lockCronJobInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockCronJobInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *CronJobInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v1beta11.CronJobHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("CronJobInterfaceMock.AddClusterScopedHandlerFunc: method is nil but CronJobInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v1beta11.CronJobHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockCronJobInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockCronJobInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedCronJobInterface.AddClusterScopedHandlerCalls())
func (mock *CronJobInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v1beta11.CronJobHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v1beta11.CronJobHandlerFunc
	}
	lockCronJobInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockCronJobInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *CronJobInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v1beta11.CronJobLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("CronJobInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but CronJobInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v1beta11.CronJobLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockCronJobInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockCronJobInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedCronJobInterface.AddClusterScopedLifecycleCalls())
func (mock *CronJobInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v1beta11.CronJobLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v1beta11.CronJobLifecycle
	}
	lockCronJobInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockCronJobInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *CronJobInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v1beta11.CronJobHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("CronJobInterfaceMock.AddFeatureHandlerFunc: method is nil but CronJobInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v1beta11.CronJobHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockCronJobInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockCronJobInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedCronJobInterface.AddFeatureHandlerCalls())
func (mock *CronJobInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v1beta11.CronJobHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v1beta11.CronJobHandlerFunc
	}
	lockCronJobInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockCronJobInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *CronJobInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v1beta11.CronJobLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("CronJobInterfaceMock.AddFeatureLifecycleFunc: method is nil but CronJobInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v1beta11.CronJobLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockCronJobInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockCronJobInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedCronJobInterface.AddFeatureLifecycleCalls())
func (mock *CronJobInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v1beta11.CronJobLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v1beta11.CronJobLifecycle
	}
	lockCronJobInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockCronJobInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *CronJobInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v1beta11.CronJobHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("CronJobInterfaceMock.AddHandlerFunc: method is nil but CronJobInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v1beta11.CronJobHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockCronJobInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockCronJobInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedCronJobInterface.AddHandlerCalls())
func (mock *CronJobInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v1beta11.CronJobHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v1beta11.CronJobHandlerFunc
	}
	lockCronJobInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockCronJobInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *CronJobInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v1beta11.CronJobLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("CronJobInterfaceMock.AddLifecycleFunc: method is nil but CronJobInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v1beta11.CronJobLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockCronJobInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockCronJobInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedCronJobInterface.AddLifecycleCalls())
func (mock *CronJobInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v1beta11.CronJobLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v1beta11.CronJobLifecycle
	}
	lockCronJobInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockCronJobInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *CronJobInterfaceMock) Controller() v1beta11.CronJobController {
	if mock.ControllerFunc == nil {
		panic("CronJobInterfaceMock.ControllerFunc: method is nil but CronJobInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockCronJobInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockCronJobInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedCronJobInterface.ControllerCalls())
func (mock *CronJobInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockCronJobInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockCronJobInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *CronJobInterfaceMock) Create(in1 *v1beta1.CronJob) (*v1beta1.CronJob, error) {
	if mock.CreateFunc == nil {
		panic("CronJobInterfaceMock.CreateFunc: method is nil but CronJobInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v1beta1.CronJob
	}{
		In1: in1,
	}
	lockCronJobInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockCronJobInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedCronJobInterface.CreateCalls())
func (mock *CronJobInterfaceMock) CreateCalls() []struct {
	In1 *v1beta1.CronJob
} {
	var calls []struct {
		In1 *v1beta1.CronJob
	}
	lockCronJobInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockCronJobInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *CronJobInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("CronJobInterfaceMock.DeleteFunc: method is nil but CronJobInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockCronJobInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockCronJobInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedCronJobInterface.DeleteCalls())
func (mock *CronJobInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockCronJobInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockCronJobInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *CronJobInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("CronJobInterfaceMock.DeleteCollectionFunc: method is nil but CronJobInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockCronJobInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockCronJobInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedCronJobInterface.DeleteCollectionCalls())
func (mock *CronJobInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockCronJobInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockCronJobInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *CronJobInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("CronJobInterfaceMock.DeleteNamespacedFunc: method is nil but CronJobInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockCronJobInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockCronJobInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedCronJobInterface.DeleteNamespacedCalls())
func (mock *CronJobInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockCronJobInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockCronJobInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *CronJobInterfaceMock) Get(name string, opts metav1.GetOptions) (*v1beta1.CronJob, error) {
	if mock.GetFunc == nil {
		panic("CronJobInterfaceMock.GetFunc: method is nil but CronJobInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockCronJobInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockCronJobInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedCronJobInterface.GetCalls())
func (mock *CronJobInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockCronJobInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockCronJobInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *CronJobInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v1beta1.CronJob, error) {
	if mock.GetNamespacedFunc == nil {
		panic("CronJobInterfaceMock.GetNamespacedFunc: method is nil but CronJobInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockCronJobInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockCronJobInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedCronJobInterface.GetNamespacedCalls())
func (mock *CronJobInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockCronJobInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockCronJobInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *CronJobInterfaceMock) List(opts metav1.ListOptions) (*v1beta1.CronJobList, error) {
	if mock.ListFunc == nil {
		panic("CronJobInterfaceMock.ListFunc: method is nil but CronJobInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockCronJobInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockCronJobInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedCronJobInterface.ListCalls())
func (mock *CronJobInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockCronJobInterfaceMockList.RLock()
	calls = mock.calls.List
	lockCronJobInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *CronJobInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v1beta1.CronJobList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("CronJobInterfaceMock.ListNamespacedFunc: method is nil but CronJobInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockCronJobInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockCronJobInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedCronJobInterface.ListNamespacedCalls())
func (mock *CronJobInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockCronJobInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockCronJobInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *CronJobInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("CronJobInterfaceMock.ObjectClientFunc: method is nil but CronJobInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockCronJobInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockCronJobInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedCronJobInterface.ObjectClientCalls())
func (mock *CronJobInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockCronJobInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockCronJobInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *CronJobInterfaceMock) Update(in1 *v1beta1.CronJob) (*v1beta1.CronJob, error) {
	if mock.UpdateFunc == nil {
		panic("CronJobInterfaceMock.UpdateFunc: method is nil but CronJobInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v1beta1.CronJob
	}{
		In1: in1,
	}
	lockCronJobInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockCronJobInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedCronJobInterface.UpdateCalls())
func (mock *CronJobInterfaceMock) UpdateCalls() []struct {
	In1 *v1beta1.CronJob
} {
	var calls []struct {
		In1 *v1beta1.CronJob
	}
	lockCronJobInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockCronJobInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *CronJobInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("CronJobInterfaceMock.WatchFunc: method is nil but CronJobInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockCronJobInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockCronJobInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedCronJobInterface.WatchCalls())
func (mock *CronJobInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockCronJobInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockCronJobInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockCronJobsGetterMockCronJobs sync.RWMutex
)

// Ensure, that CronJobsGetterMock does implement v1beta11.CronJobsGetter.
// If this is not the case, regenerate this file with moq.
var _ v1beta11.CronJobsGetter = &CronJobsGetterMock{}

// CronJobsGetterMock is a mock implementation of v1beta11.CronJobsGetter.
//
//     func TestSomethingThatUsesCronJobsGetter(t *testing.T) {
//
//         // make and configure a mocked v1beta11.CronJobsGetter
//         mockedCronJobsGetter := &CronJobsGetterMock{
//             CronJobsFunc: func(namespace string) v1beta11.CronJobInterface {
// 	               panic("mock out the CronJobs method")
//             },
//         }
//
//         // use mockedCronJobsGetter in code that requires v1beta11.CronJobsGetter
//         // and then make assertions.
//
//     }
type CronJobsGetterMock struct {
	// CronJobsFunc mocks the CronJobs method.
	CronJobsFunc func(namespace string) v1beta11.CronJobInterface

	// calls tracks calls to the methods.
	calls struct {
		// CronJobs holds details about calls to the CronJobs method.
		CronJobs []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// CronJobs calls CronJobsFunc.
func (mock *CronJobsGetterMock) CronJobs(namespace string) v1beta11.CronJobInterface {
	if mock.CronJobsFunc == nil {
		panic("CronJobsGetterMock.CronJobsFunc: method is nil but CronJobsGetter.CronJobs was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockCronJobsGetterMockCronJobs.Lock()
	mock.calls.CronJobs = append(mock.calls.CronJobs, callInfo)
	lockCronJobsGetterMockCronJobs.Unlock()
	return mock.CronJobsFunc(namespace)
}

// CronJobsCalls gets all the calls that were made to CronJobs.
// Check the length with:
//     len(mockedCronJobsGetter.CronJobsCalls())
func (mock *CronJobsGetterMock) CronJobsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockCronJobsGetterMockCronJobs.RLock()
	calls = mock.calls.CronJobs
	lockCronJobsGetterMockCronJobs.RUnlock()
	return calls
}
