// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v11 "github.com/rancher/rancher/pkg/generated/norman/core/v1"
	v1 "k8s.io/api/core/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockConfigMapListerMockGet  sync.RWMutex
	lockConfigMapListerMockList sync.RWMutex
)

// Ensure, that ConfigMapListerMock does implement v11.ConfigMapLister.
// If this is not the case, regenerate this file with moq.
var _ v11.ConfigMapLister = &ConfigMapListerMock{}

// ConfigMapListerMock is a mock implementation of v11.ConfigMapLister.
//
//     func TestSomethingThatUsesConfigMapLister(t *testing.T) {
//
//         // make and configure a mocked v11.ConfigMapLister
//         mockedConfigMapLister := &ConfigMapListerMock{
//             GetFunc: func(namespace string, name string) (*v1.ConfigMap, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v1.ConfigMap, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedConfigMapLister in code that requires v11.ConfigMapLister
//         // and then make assertions.
//
//     }
type ConfigMapListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v1.ConfigMap, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v1.ConfigMap, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *ConfigMapListerMock) Get(namespace string, name string) (*v1.ConfigMap, error) {
	if mock.GetFunc == nil {
		panic("ConfigMapListerMock.GetFunc: method is nil but ConfigMapLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockConfigMapListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockConfigMapListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedConfigMapLister.GetCalls())
func (mock *ConfigMapListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockConfigMapListerMockGet.RLock()
	calls = mock.calls.Get
	lockConfigMapListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ConfigMapListerMock) List(namespace string, selector labels.Selector) ([]*v1.ConfigMap, error) {
	if mock.ListFunc == nil {
		panic("ConfigMapListerMock.ListFunc: method is nil but ConfigMapLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockConfigMapListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockConfigMapListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedConfigMapLister.ListCalls())
func (mock *ConfigMapListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockConfigMapListerMockList.RLock()
	calls = mock.calls.List
	lockConfigMapListerMockList.RUnlock()
	return calls
}

var (
	lockConfigMapControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockConfigMapControllerMockAddClusterScopedHandler        sync.RWMutex
	lockConfigMapControllerMockAddFeatureHandler              sync.RWMutex
	lockConfigMapControllerMockAddHandler                     sync.RWMutex
	lockConfigMapControllerMockEnqueue                        sync.RWMutex
	lockConfigMapControllerMockEnqueueAfter                   sync.RWMutex
	lockConfigMapControllerMockGeneric                        sync.RWMutex
	lockConfigMapControllerMockInformer                       sync.RWMutex
	lockConfigMapControllerMockLister                         sync.RWMutex
)

// Ensure, that ConfigMapControllerMock does implement v11.ConfigMapController.
// If this is not the case, regenerate this file with moq.
var _ v11.ConfigMapController = &ConfigMapControllerMock{}

// ConfigMapControllerMock is a mock implementation of v11.ConfigMapController.
//
//     func TestSomethingThatUsesConfigMapController(t *testing.T) {
//
//         // make and configure a mocked v11.ConfigMapController
//         mockedConfigMapController := &ConfigMapControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.ConfigMapHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v11.ConfigMapHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ConfigMapHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v11.ConfigMapHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v11.ConfigMapLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedConfigMapController in code that requires v11.ConfigMapController
//         // and then make assertions.
//
//     }
type ConfigMapControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.ConfigMapHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v11.ConfigMapHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ConfigMapHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v11.ConfigMapHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v11.ConfigMapLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.ConfigMapHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.ConfigMapHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.ConfigMapHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v11.ConfigMapHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ConfigMapControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.ConfigMapHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ConfigMapControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but ConfigMapController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.ConfigMapHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockConfigMapControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockConfigMapControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedConfigMapController.AddClusterScopedFeatureHandlerCalls())
func (mock *ConfigMapControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v11.ConfigMapHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.ConfigMapHandlerFunc
	}
	lockConfigMapControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockConfigMapControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ConfigMapControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v11.ConfigMapHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ConfigMapControllerMock.AddClusterScopedHandlerFunc: method is nil but ConfigMapController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.ConfigMapHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockConfigMapControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockConfigMapControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedConfigMapController.AddClusterScopedHandlerCalls())
func (mock *ConfigMapControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v11.ConfigMapHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.ConfigMapHandlerFunc
	}
	lockConfigMapControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockConfigMapControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ConfigMapControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ConfigMapHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ConfigMapControllerMock.AddFeatureHandlerFunc: method is nil but ConfigMapController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ConfigMapHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockConfigMapControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockConfigMapControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedConfigMapController.AddFeatureHandlerCalls())
func (mock *ConfigMapControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.ConfigMapHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ConfigMapHandlerFunc
	}
	lockConfigMapControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockConfigMapControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ConfigMapControllerMock) AddHandler(ctx context.Context, name string, handler v11.ConfigMapHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ConfigMapControllerMock.AddHandlerFunc: method is nil but ConfigMapController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v11.ConfigMapHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockConfigMapControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockConfigMapControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedConfigMapController.AddHandlerCalls())
func (mock *ConfigMapControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v11.ConfigMapHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v11.ConfigMapHandlerFunc
	}
	lockConfigMapControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockConfigMapControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *ConfigMapControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("ConfigMapControllerMock.EnqueueFunc: method is nil but ConfigMapController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockConfigMapControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockConfigMapControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedConfigMapController.EnqueueCalls())
func (mock *ConfigMapControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockConfigMapControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockConfigMapControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *ConfigMapControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("ConfigMapControllerMock.EnqueueAfterFunc: method is nil but ConfigMapController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockConfigMapControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockConfigMapControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedConfigMapController.EnqueueAfterCalls())
func (mock *ConfigMapControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockConfigMapControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockConfigMapControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *ConfigMapControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("ConfigMapControllerMock.GenericFunc: method is nil but ConfigMapController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockConfigMapControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockConfigMapControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedConfigMapController.GenericCalls())
func (mock *ConfigMapControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockConfigMapControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockConfigMapControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *ConfigMapControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("ConfigMapControllerMock.InformerFunc: method is nil but ConfigMapController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockConfigMapControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockConfigMapControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedConfigMapController.InformerCalls())
func (mock *ConfigMapControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockConfigMapControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockConfigMapControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *ConfigMapControllerMock) Lister() v11.ConfigMapLister {
	if mock.ListerFunc == nil {
		panic("ConfigMapControllerMock.ListerFunc: method is nil but ConfigMapController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockConfigMapControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockConfigMapControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedConfigMapController.ListerCalls())
func (mock *ConfigMapControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockConfigMapControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockConfigMapControllerMockLister.RUnlock()
	return calls
}

var (
	lockConfigMapInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockConfigMapInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockConfigMapInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockConfigMapInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockConfigMapInterfaceMockAddFeatureHandler                sync.RWMutex
	lockConfigMapInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockConfigMapInterfaceMockAddHandler                       sync.RWMutex
	lockConfigMapInterfaceMockAddLifecycle                     sync.RWMutex
	lockConfigMapInterfaceMockController                       sync.RWMutex
	lockConfigMapInterfaceMockCreate                           sync.RWMutex
	lockConfigMapInterfaceMockDelete                           sync.RWMutex
	lockConfigMapInterfaceMockDeleteCollection                 sync.RWMutex
	lockConfigMapInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockConfigMapInterfaceMockGet                              sync.RWMutex
	lockConfigMapInterfaceMockGetNamespaced                    sync.RWMutex
	lockConfigMapInterfaceMockList                             sync.RWMutex
	lockConfigMapInterfaceMockListNamespaced                   sync.RWMutex
	lockConfigMapInterfaceMockObjectClient                     sync.RWMutex
	lockConfigMapInterfaceMockUpdate                           sync.RWMutex
	lockConfigMapInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that ConfigMapInterfaceMock does implement v11.ConfigMapInterface.
// If this is not the case, regenerate this file with moq.
var _ v11.ConfigMapInterface = &ConfigMapInterfaceMock{}

// ConfigMapInterfaceMock is a mock implementation of v11.ConfigMapInterface.
//
//     func TestSomethingThatUsesConfigMapInterface(t *testing.T) {
//
//         // make and configure a mocked v11.ConfigMapInterface
//         mockedConfigMapInterface := &ConfigMapInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.ConfigMapHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.ConfigMapLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v11.ConfigMapHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v11.ConfigMapLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ConfigMapHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v11.ConfigMapLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v11.ConfigMapHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v11.ConfigMapLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v11.ConfigMapController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v1.ConfigMap) (*v1.ConfigMap, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v1.ConfigMap, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v1.ConfigMap, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v1.ConfigMapList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v1.ConfigMapList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v1.ConfigMap) (*v1.ConfigMap, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedConfigMapInterface in code that requires v11.ConfigMapInterface
//         // and then make assertions.
//
//     }
type ConfigMapInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.ConfigMapHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.ConfigMapLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v11.ConfigMapHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v11.ConfigMapLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ConfigMapHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v11.ConfigMapLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v11.ConfigMapHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v11.ConfigMapLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v11.ConfigMapController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v1.ConfigMap) (*v1.ConfigMap, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v1.ConfigMap, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v1.ConfigMap, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v1.ConfigMapList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v1.ConfigMapList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v1.ConfigMap) (*v1.ConfigMap, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.ConfigMapHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ConfigMapLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.ConfigMapHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ConfigMapLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.ConfigMapHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ConfigMapLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.ConfigMapHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ConfigMapLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v1.ConfigMap
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v1.ConfigMap
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ConfigMapInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.ConfigMapHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ConfigMapInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but ConfigMapInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.ConfigMapHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockConfigMapInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockConfigMapInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedConfigMapInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *ConfigMapInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v11.ConfigMapHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.ConfigMapHandlerFunc
	}
	lockConfigMapInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockConfigMapInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *ConfigMapInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.ConfigMapLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("ConfigMapInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but ConfigMapInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.ConfigMapLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockConfigMapInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockConfigMapInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedConfigMapInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *ConfigMapInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v11.ConfigMapLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.ConfigMapLifecycle
	}
	lockConfigMapInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockConfigMapInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ConfigMapInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v11.ConfigMapHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ConfigMapInterfaceMock.AddClusterScopedHandlerFunc: method is nil but ConfigMapInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.ConfigMapHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockConfigMapInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockConfigMapInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedConfigMapInterface.AddClusterScopedHandlerCalls())
func (mock *ConfigMapInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v11.ConfigMapHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.ConfigMapHandlerFunc
	}
	lockConfigMapInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockConfigMapInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *ConfigMapInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v11.ConfigMapLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("ConfigMapInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but ConfigMapInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.ConfigMapLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockConfigMapInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockConfigMapInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedConfigMapInterface.AddClusterScopedLifecycleCalls())
func (mock *ConfigMapInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v11.ConfigMapLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.ConfigMapLifecycle
	}
	lockConfigMapInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockConfigMapInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ConfigMapInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ConfigMapHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ConfigMapInterfaceMock.AddFeatureHandlerFunc: method is nil but ConfigMapInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ConfigMapHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockConfigMapInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockConfigMapInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedConfigMapInterface.AddFeatureHandlerCalls())
func (mock *ConfigMapInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.ConfigMapHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ConfigMapHandlerFunc
	}
	lockConfigMapInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockConfigMapInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *ConfigMapInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v11.ConfigMapLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("ConfigMapInterfaceMock.AddFeatureLifecycleFunc: method is nil but ConfigMapInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.ConfigMapLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockConfigMapInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockConfigMapInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedConfigMapInterface.AddFeatureLifecycleCalls())
func (mock *ConfigMapInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v11.ConfigMapLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.ConfigMapLifecycle
	}
	lockConfigMapInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockConfigMapInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ConfigMapInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v11.ConfigMapHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ConfigMapInterfaceMock.AddHandlerFunc: method is nil but ConfigMapInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v11.ConfigMapHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockConfigMapInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockConfigMapInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedConfigMapInterface.AddHandlerCalls())
func (mock *ConfigMapInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v11.ConfigMapHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v11.ConfigMapHandlerFunc
	}
	lockConfigMapInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockConfigMapInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *ConfigMapInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v11.ConfigMapLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("ConfigMapInterfaceMock.AddLifecycleFunc: method is nil but ConfigMapInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.ConfigMapLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockConfigMapInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockConfigMapInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedConfigMapInterface.AddLifecycleCalls())
func (mock *ConfigMapInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v11.ConfigMapLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.ConfigMapLifecycle
	}
	lockConfigMapInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockConfigMapInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *ConfigMapInterfaceMock) Controller() v11.ConfigMapController {
	if mock.ControllerFunc == nil {
		panic("ConfigMapInterfaceMock.ControllerFunc: method is nil but ConfigMapInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockConfigMapInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockConfigMapInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedConfigMapInterface.ControllerCalls())
func (mock *ConfigMapInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockConfigMapInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockConfigMapInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *ConfigMapInterfaceMock) Create(in1 *v1.ConfigMap) (*v1.ConfigMap, error) {
	if mock.CreateFunc == nil {
		panic("ConfigMapInterfaceMock.CreateFunc: method is nil but ConfigMapInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v1.ConfigMap
	}{
		In1: in1,
	}
	lockConfigMapInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockConfigMapInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedConfigMapInterface.CreateCalls())
func (mock *ConfigMapInterfaceMock) CreateCalls() []struct {
	In1 *v1.ConfigMap
} {
	var calls []struct {
		In1 *v1.ConfigMap
	}
	lockConfigMapInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockConfigMapInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *ConfigMapInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("ConfigMapInterfaceMock.DeleteFunc: method is nil but ConfigMapInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockConfigMapInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockConfigMapInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedConfigMapInterface.DeleteCalls())
func (mock *ConfigMapInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockConfigMapInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockConfigMapInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *ConfigMapInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("ConfigMapInterfaceMock.DeleteCollectionFunc: method is nil but ConfigMapInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockConfigMapInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockConfigMapInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedConfigMapInterface.DeleteCollectionCalls())
func (mock *ConfigMapInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockConfigMapInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockConfigMapInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *ConfigMapInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("ConfigMapInterfaceMock.DeleteNamespacedFunc: method is nil but ConfigMapInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockConfigMapInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockConfigMapInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedConfigMapInterface.DeleteNamespacedCalls())
func (mock *ConfigMapInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockConfigMapInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockConfigMapInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *ConfigMapInterfaceMock) Get(name string, opts metav1.GetOptions) (*v1.ConfigMap, error) {
	if mock.GetFunc == nil {
		panic("ConfigMapInterfaceMock.GetFunc: method is nil but ConfigMapInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockConfigMapInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockConfigMapInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedConfigMapInterface.GetCalls())
func (mock *ConfigMapInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockConfigMapInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockConfigMapInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *ConfigMapInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v1.ConfigMap, error) {
	if mock.GetNamespacedFunc == nil {
		panic("ConfigMapInterfaceMock.GetNamespacedFunc: method is nil but ConfigMapInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockConfigMapInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockConfigMapInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedConfigMapInterface.GetNamespacedCalls())
func (mock *ConfigMapInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockConfigMapInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockConfigMapInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ConfigMapInterfaceMock) List(opts metav1.ListOptions) (*v1.ConfigMapList, error) {
	if mock.ListFunc == nil {
		panic("ConfigMapInterfaceMock.ListFunc: method is nil but ConfigMapInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockConfigMapInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockConfigMapInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedConfigMapInterface.ListCalls())
func (mock *ConfigMapInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockConfigMapInterfaceMockList.RLock()
	calls = mock.calls.List
	lockConfigMapInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *ConfigMapInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v1.ConfigMapList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("ConfigMapInterfaceMock.ListNamespacedFunc: method is nil but ConfigMapInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockConfigMapInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockConfigMapInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedConfigMapInterface.ListNamespacedCalls())
func (mock *ConfigMapInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockConfigMapInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockConfigMapInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *ConfigMapInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("ConfigMapInterfaceMock.ObjectClientFunc: method is nil but ConfigMapInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockConfigMapInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockConfigMapInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedConfigMapInterface.ObjectClientCalls())
func (mock *ConfigMapInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockConfigMapInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockConfigMapInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *ConfigMapInterfaceMock) Update(in1 *v1.ConfigMap) (*v1.ConfigMap, error) {
	if mock.UpdateFunc == nil {
		panic("ConfigMapInterfaceMock.UpdateFunc: method is nil but ConfigMapInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v1.ConfigMap
	}{
		In1: in1,
	}
	lockConfigMapInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockConfigMapInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedConfigMapInterface.UpdateCalls())
func (mock *ConfigMapInterfaceMock) UpdateCalls() []struct {
	In1 *v1.ConfigMap
} {
	var calls []struct {
		In1 *v1.ConfigMap
	}
	lockConfigMapInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockConfigMapInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *ConfigMapInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("ConfigMapInterfaceMock.WatchFunc: method is nil but ConfigMapInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockConfigMapInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockConfigMapInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedConfigMapInterface.WatchCalls())
func (mock *ConfigMapInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockConfigMapInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockConfigMapInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockConfigMapsGetterMockConfigMaps sync.RWMutex
)

// Ensure, that ConfigMapsGetterMock does implement v11.ConfigMapsGetter.
// If this is not the case, regenerate this file with moq.
var _ v11.ConfigMapsGetter = &ConfigMapsGetterMock{}

// ConfigMapsGetterMock is a mock implementation of v11.ConfigMapsGetter.
//
//     func TestSomethingThatUsesConfigMapsGetter(t *testing.T) {
//
//         // make and configure a mocked v11.ConfigMapsGetter
//         mockedConfigMapsGetter := &ConfigMapsGetterMock{
//             ConfigMapsFunc: func(namespace string) v11.ConfigMapInterface {
// 	               panic("mock out the ConfigMaps method")
//             },
//         }
//
//         // use mockedConfigMapsGetter in code that requires v11.ConfigMapsGetter
//         // and then make assertions.
//
//     }
type ConfigMapsGetterMock struct {
	// ConfigMapsFunc mocks the ConfigMaps method.
	ConfigMapsFunc func(namespace string) v11.ConfigMapInterface

	// calls tracks calls to the methods.
	calls struct {
		// ConfigMaps holds details about calls to the ConfigMaps method.
		ConfigMaps []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// ConfigMaps calls ConfigMapsFunc.
func (mock *ConfigMapsGetterMock) ConfigMaps(namespace string) v11.ConfigMapInterface {
	if mock.ConfigMapsFunc == nil {
		panic("ConfigMapsGetterMock.ConfigMapsFunc: method is nil but ConfigMapsGetter.ConfigMaps was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockConfigMapsGetterMockConfigMaps.Lock()
	mock.calls.ConfigMaps = append(mock.calls.ConfigMaps, callInfo)
	lockConfigMapsGetterMockConfigMaps.Unlock()
	return mock.ConfigMapsFunc(namespace)
}

// ConfigMapsCalls gets all the calls that were made to ConfigMaps.
// Check the length with:
//     len(mockedConfigMapsGetter.ConfigMapsCalls())
func (mock *ConfigMapsGetterMock) ConfigMapsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockConfigMapsGetterMockConfigMaps.RLock()
	calls = mock.calls.ConfigMaps
	lockConfigMapsGetterMockConfigMaps.RUnlock()
	return calls
}
