// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v11 "github.com/rancher/rancher/pkg/generated/norman/core/v1"
	v1 "k8s.io/api/core/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockLimitRangeListerMockGet  sync.RWMutex
	lockLimitRangeListerMockList sync.RWMutex
)

// Ensure, that LimitRangeListerMock does implement v11.LimitRangeLister.
// If this is not the case, regenerate this file with moq.
var _ v11.LimitRangeLister = &LimitRangeListerMock{}

// LimitRangeListerMock is a mock implementation of v11.LimitRangeLister.
//
//     func TestSomethingThatUsesLimitRangeLister(t *testing.T) {
//
//         // make and configure a mocked v11.LimitRangeLister
//         mockedLimitRangeLister := &LimitRangeListerMock{
//             GetFunc: func(namespace string, name string) (*v1.LimitRange, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v1.LimitRange, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedLimitRangeLister in code that requires v11.LimitRangeLister
//         // and then make assertions.
//
//     }
type LimitRangeListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v1.LimitRange, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v1.LimitRange, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *LimitRangeListerMock) Get(namespace string, name string) (*v1.LimitRange, error) {
	if mock.GetFunc == nil {
		panic("LimitRangeListerMock.GetFunc: method is nil but LimitRangeLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockLimitRangeListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockLimitRangeListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedLimitRangeLister.GetCalls())
func (mock *LimitRangeListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockLimitRangeListerMockGet.RLock()
	calls = mock.calls.Get
	lockLimitRangeListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *LimitRangeListerMock) List(namespace string, selector labels.Selector) ([]*v1.LimitRange, error) {
	if mock.ListFunc == nil {
		panic("LimitRangeListerMock.ListFunc: method is nil but LimitRangeLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockLimitRangeListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockLimitRangeListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedLimitRangeLister.ListCalls())
func (mock *LimitRangeListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockLimitRangeListerMockList.RLock()
	calls = mock.calls.List
	lockLimitRangeListerMockList.RUnlock()
	return calls
}

var (
	lockLimitRangeControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockLimitRangeControllerMockAddClusterScopedHandler        sync.RWMutex
	lockLimitRangeControllerMockAddFeatureHandler              sync.RWMutex
	lockLimitRangeControllerMockAddHandler                     sync.RWMutex
	lockLimitRangeControllerMockEnqueue                        sync.RWMutex
	lockLimitRangeControllerMockEnqueueAfter                   sync.RWMutex
	lockLimitRangeControllerMockGeneric                        sync.RWMutex
	lockLimitRangeControllerMockInformer                       sync.RWMutex
	lockLimitRangeControllerMockLister                         sync.RWMutex
)

// Ensure, that LimitRangeControllerMock does implement v11.LimitRangeController.
// If this is not the case, regenerate this file with moq.
var _ v11.LimitRangeController = &LimitRangeControllerMock{}

// LimitRangeControllerMock is a mock implementation of v11.LimitRangeController.
//
//     func TestSomethingThatUsesLimitRangeController(t *testing.T) {
//
//         // make and configure a mocked v11.LimitRangeController
//         mockedLimitRangeController := &LimitRangeControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.LimitRangeHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v11.LimitRangeHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.LimitRangeHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v11.LimitRangeHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v11.LimitRangeLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedLimitRangeController in code that requires v11.LimitRangeController
//         // and then make assertions.
//
//     }
type LimitRangeControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.LimitRangeHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v11.LimitRangeHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.LimitRangeHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v11.LimitRangeHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v11.LimitRangeLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.LimitRangeHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.LimitRangeHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.LimitRangeHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v11.LimitRangeHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *LimitRangeControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.LimitRangeHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("LimitRangeControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but LimitRangeController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.LimitRangeHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockLimitRangeControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockLimitRangeControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedLimitRangeController.AddClusterScopedFeatureHandlerCalls())
func (mock *LimitRangeControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v11.LimitRangeHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.LimitRangeHandlerFunc
	}
	lockLimitRangeControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockLimitRangeControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *LimitRangeControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v11.LimitRangeHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("LimitRangeControllerMock.AddClusterScopedHandlerFunc: method is nil but LimitRangeController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.LimitRangeHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockLimitRangeControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockLimitRangeControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedLimitRangeController.AddClusterScopedHandlerCalls())
func (mock *LimitRangeControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v11.LimitRangeHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.LimitRangeHandlerFunc
	}
	lockLimitRangeControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockLimitRangeControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *LimitRangeControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.LimitRangeHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("LimitRangeControllerMock.AddFeatureHandlerFunc: method is nil but LimitRangeController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.LimitRangeHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockLimitRangeControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockLimitRangeControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedLimitRangeController.AddFeatureHandlerCalls())
func (mock *LimitRangeControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.LimitRangeHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.LimitRangeHandlerFunc
	}
	lockLimitRangeControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockLimitRangeControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *LimitRangeControllerMock) AddHandler(ctx context.Context, name string, handler v11.LimitRangeHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("LimitRangeControllerMock.AddHandlerFunc: method is nil but LimitRangeController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v11.LimitRangeHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockLimitRangeControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockLimitRangeControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedLimitRangeController.AddHandlerCalls())
func (mock *LimitRangeControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v11.LimitRangeHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v11.LimitRangeHandlerFunc
	}
	lockLimitRangeControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockLimitRangeControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *LimitRangeControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("LimitRangeControllerMock.EnqueueFunc: method is nil but LimitRangeController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockLimitRangeControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockLimitRangeControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedLimitRangeController.EnqueueCalls())
func (mock *LimitRangeControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockLimitRangeControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockLimitRangeControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *LimitRangeControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("LimitRangeControllerMock.EnqueueAfterFunc: method is nil but LimitRangeController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockLimitRangeControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockLimitRangeControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedLimitRangeController.EnqueueAfterCalls())
func (mock *LimitRangeControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockLimitRangeControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockLimitRangeControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *LimitRangeControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("LimitRangeControllerMock.GenericFunc: method is nil but LimitRangeController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockLimitRangeControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockLimitRangeControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedLimitRangeController.GenericCalls())
func (mock *LimitRangeControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockLimitRangeControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockLimitRangeControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *LimitRangeControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("LimitRangeControllerMock.InformerFunc: method is nil but LimitRangeController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockLimitRangeControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockLimitRangeControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedLimitRangeController.InformerCalls())
func (mock *LimitRangeControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockLimitRangeControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockLimitRangeControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *LimitRangeControllerMock) Lister() v11.LimitRangeLister {
	if mock.ListerFunc == nil {
		panic("LimitRangeControllerMock.ListerFunc: method is nil but LimitRangeController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockLimitRangeControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockLimitRangeControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedLimitRangeController.ListerCalls())
func (mock *LimitRangeControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockLimitRangeControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockLimitRangeControllerMockLister.RUnlock()
	return calls
}

var (
	lockLimitRangeInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockLimitRangeInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockLimitRangeInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockLimitRangeInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockLimitRangeInterfaceMockAddFeatureHandler                sync.RWMutex
	lockLimitRangeInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockLimitRangeInterfaceMockAddHandler                       sync.RWMutex
	lockLimitRangeInterfaceMockAddLifecycle                     sync.RWMutex
	lockLimitRangeInterfaceMockController                       sync.RWMutex
	lockLimitRangeInterfaceMockCreate                           sync.RWMutex
	lockLimitRangeInterfaceMockDelete                           sync.RWMutex
	lockLimitRangeInterfaceMockDeleteCollection                 sync.RWMutex
	lockLimitRangeInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockLimitRangeInterfaceMockGet                              sync.RWMutex
	lockLimitRangeInterfaceMockGetNamespaced                    sync.RWMutex
	lockLimitRangeInterfaceMockList                             sync.RWMutex
	lockLimitRangeInterfaceMockListNamespaced                   sync.RWMutex
	lockLimitRangeInterfaceMockObjectClient                     sync.RWMutex
	lockLimitRangeInterfaceMockUpdate                           sync.RWMutex
	lockLimitRangeInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that LimitRangeInterfaceMock does implement v11.LimitRangeInterface.
// If this is not the case, regenerate this file with moq.
var _ v11.LimitRangeInterface = &LimitRangeInterfaceMock{}

// LimitRangeInterfaceMock is a mock implementation of v11.LimitRangeInterface.
//
//     func TestSomethingThatUsesLimitRangeInterface(t *testing.T) {
//
//         // make and configure a mocked v11.LimitRangeInterface
//         mockedLimitRangeInterface := &LimitRangeInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.LimitRangeHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.LimitRangeLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v11.LimitRangeHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v11.LimitRangeLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.LimitRangeHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v11.LimitRangeLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v11.LimitRangeHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v11.LimitRangeLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v11.LimitRangeController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v1.LimitRange) (*v1.LimitRange, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v1.LimitRange, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v1.LimitRange, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v1.LimitRangeList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v1.LimitRangeList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v1.LimitRange) (*v1.LimitRange, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedLimitRangeInterface in code that requires v11.LimitRangeInterface
//         // and then make assertions.
//
//     }
type LimitRangeInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.LimitRangeHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.LimitRangeLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v11.LimitRangeHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v11.LimitRangeLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.LimitRangeHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v11.LimitRangeLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v11.LimitRangeHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v11.LimitRangeLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v11.LimitRangeController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v1.LimitRange) (*v1.LimitRange, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v1.LimitRange, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v1.LimitRange, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v1.LimitRangeList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v1.LimitRangeList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v1.LimitRange) (*v1.LimitRange, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.LimitRangeHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.LimitRangeLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.LimitRangeHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.LimitRangeLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.LimitRangeHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.LimitRangeLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.LimitRangeHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.LimitRangeLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v1.LimitRange
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v1.LimitRange
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *LimitRangeInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.LimitRangeHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("LimitRangeInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but LimitRangeInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.LimitRangeHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockLimitRangeInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockLimitRangeInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedLimitRangeInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *LimitRangeInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v11.LimitRangeHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.LimitRangeHandlerFunc
	}
	lockLimitRangeInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockLimitRangeInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *LimitRangeInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.LimitRangeLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("LimitRangeInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but LimitRangeInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.LimitRangeLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockLimitRangeInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockLimitRangeInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedLimitRangeInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *LimitRangeInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v11.LimitRangeLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.LimitRangeLifecycle
	}
	lockLimitRangeInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockLimitRangeInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *LimitRangeInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v11.LimitRangeHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("LimitRangeInterfaceMock.AddClusterScopedHandlerFunc: method is nil but LimitRangeInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.LimitRangeHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockLimitRangeInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockLimitRangeInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedLimitRangeInterface.AddClusterScopedHandlerCalls())
func (mock *LimitRangeInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v11.LimitRangeHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.LimitRangeHandlerFunc
	}
	lockLimitRangeInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockLimitRangeInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *LimitRangeInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v11.LimitRangeLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("LimitRangeInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but LimitRangeInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.LimitRangeLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockLimitRangeInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockLimitRangeInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedLimitRangeInterface.AddClusterScopedLifecycleCalls())
func (mock *LimitRangeInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v11.LimitRangeLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.LimitRangeLifecycle
	}
	lockLimitRangeInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockLimitRangeInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *LimitRangeInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.LimitRangeHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("LimitRangeInterfaceMock.AddFeatureHandlerFunc: method is nil but LimitRangeInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.LimitRangeHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockLimitRangeInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockLimitRangeInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedLimitRangeInterface.AddFeatureHandlerCalls())
func (mock *LimitRangeInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.LimitRangeHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.LimitRangeHandlerFunc
	}
	lockLimitRangeInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockLimitRangeInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *LimitRangeInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v11.LimitRangeLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("LimitRangeInterfaceMock.AddFeatureLifecycleFunc: method is nil but LimitRangeInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.LimitRangeLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockLimitRangeInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockLimitRangeInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedLimitRangeInterface.AddFeatureLifecycleCalls())
func (mock *LimitRangeInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v11.LimitRangeLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.LimitRangeLifecycle
	}
	lockLimitRangeInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockLimitRangeInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *LimitRangeInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v11.LimitRangeHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("LimitRangeInterfaceMock.AddHandlerFunc: method is nil but LimitRangeInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v11.LimitRangeHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockLimitRangeInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockLimitRangeInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedLimitRangeInterface.AddHandlerCalls())
func (mock *LimitRangeInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v11.LimitRangeHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v11.LimitRangeHandlerFunc
	}
	lockLimitRangeInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockLimitRangeInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *LimitRangeInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v11.LimitRangeLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("LimitRangeInterfaceMock.AddLifecycleFunc: method is nil but LimitRangeInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.LimitRangeLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockLimitRangeInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockLimitRangeInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedLimitRangeInterface.AddLifecycleCalls())
func (mock *LimitRangeInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v11.LimitRangeLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.LimitRangeLifecycle
	}
	lockLimitRangeInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockLimitRangeInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *LimitRangeInterfaceMock) Controller() v11.LimitRangeController {
	if mock.ControllerFunc == nil {
		panic("LimitRangeInterfaceMock.ControllerFunc: method is nil but LimitRangeInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockLimitRangeInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockLimitRangeInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedLimitRangeInterface.ControllerCalls())
func (mock *LimitRangeInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockLimitRangeInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockLimitRangeInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *LimitRangeInterfaceMock) Create(in1 *v1.LimitRange) (*v1.LimitRange, error) {
	if mock.CreateFunc == nil {
		panic("LimitRangeInterfaceMock.CreateFunc: method is nil but LimitRangeInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v1.LimitRange
	}{
		In1: in1,
	}
	lockLimitRangeInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockLimitRangeInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedLimitRangeInterface.CreateCalls())
func (mock *LimitRangeInterfaceMock) CreateCalls() []struct {
	In1 *v1.LimitRange
} {
	var calls []struct {
		In1 *v1.LimitRange
	}
	lockLimitRangeInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockLimitRangeInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *LimitRangeInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("LimitRangeInterfaceMock.DeleteFunc: method is nil but LimitRangeInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockLimitRangeInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockLimitRangeInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedLimitRangeInterface.DeleteCalls())
func (mock *LimitRangeInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockLimitRangeInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockLimitRangeInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *LimitRangeInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("LimitRangeInterfaceMock.DeleteCollectionFunc: method is nil but LimitRangeInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockLimitRangeInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockLimitRangeInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedLimitRangeInterface.DeleteCollectionCalls())
func (mock *LimitRangeInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockLimitRangeInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockLimitRangeInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *LimitRangeInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("LimitRangeInterfaceMock.DeleteNamespacedFunc: method is nil but LimitRangeInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockLimitRangeInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockLimitRangeInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedLimitRangeInterface.DeleteNamespacedCalls())
func (mock *LimitRangeInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockLimitRangeInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockLimitRangeInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *LimitRangeInterfaceMock) Get(name string, opts metav1.GetOptions) (*v1.LimitRange, error) {
	if mock.GetFunc == nil {
		panic("LimitRangeInterfaceMock.GetFunc: method is nil but LimitRangeInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockLimitRangeInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockLimitRangeInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedLimitRangeInterface.GetCalls())
func (mock *LimitRangeInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockLimitRangeInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockLimitRangeInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *LimitRangeInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v1.LimitRange, error) {
	if mock.GetNamespacedFunc == nil {
		panic("LimitRangeInterfaceMock.GetNamespacedFunc: method is nil but LimitRangeInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockLimitRangeInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockLimitRangeInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedLimitRangeInterface.GetNamespacedCalls())
func (mock *LimitRangeInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockLimitRangeInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockLimitRangeInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *LimitRangeInterfaceMock) List(opts metav1.ListOptions) (*v1.LimitRangeList, error) {
	if mock.ListFunc == nil {
		panic("LimitRangeInterfaceMock.ListFunc: method is nil but LimitRangeInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockLimitRangeInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockLimitRangeInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedLimitRangeInterface.ListCalls())
func (mock *LimitRangeInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockLimitRangeInterfaceMockList.RLock()
	calls = mock.calls.List
	lockLimitRangeInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *LimitRangeInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v1.LimitRangeList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("LimitRangeInterfaceMock.ListNamespacedFunc: method is nil but LimitRangeInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockLimitRangeInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockLimitRangeInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedLimitRangeInterface.ListNamespacedCalls())
func (mock *LimitRangeInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockLimitRangeInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockLimitRangeInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *LimitRangeInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("LimitRangeInterfaceMock.ObjectClientFunc: method is nil but LimitRangeInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockLimitRangeInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockLimitRangeInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedLimitRangeInterface.ObjectClientCalls())
func (mock *LimitRangeInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockLimitRangeInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockLimitRangeInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *LimitRangeInterfaceMock) Update(in1 *v1.LimitRange) (*v1.LimitRange, error) {
	if mock.UpdateFunc == nil {
		panic("LimitRangeInterfaceMock.UpdateFunc: method is nil but LimitRangeInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v1.LimitRange
	}{
		In1: in1,
	}
	lockLimitRangeInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockLimitRangeInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedLimitRangeInterface.UpdateCalls())
func (mock *LimitRangeInterfaceMock) UpdateCalls() []struct {
	In1 *v1.LimitRange
} {
	var calls []struct {
		In1 *v1.LimitRange
	}
	lockLimitRangeInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockLimitRangeInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *LimitRangeInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("LimitRangeInterfaceMock.WatchFunc: method is nil but LimitRangeInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockLimitRangeInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockLimitRangeInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedLimitRangeInterface.WatchCalls())
func (mock *LimitRangeInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockLimitRangeInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockLimitRangeInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockLimitRangesGetterMockLimitRanges sync.RWMutex
)

// Ensure, that LimitRangesGetterMock does implement v11.LimitRangesGetter.
// If this is not the case, regenerate this file with moq.
var _ v11.LimitRangesGetter = &LimitRangesGetterMock{}

// LimitRangesGetterMock is a mock implementation of v11.LimitRangesGetter.
//
//     func TestSomethingThatUsesLimitRangesGetter(t *testing.T) {
//
//         // make and configure a mocked v11.LimitRangesGetter
//         mockedLimitRangesGetter := &LimitRangesGetterMock{
//             LimitRangesFunc: func(namespace string) v11.LimitRangeInterface {
// 	               panic("mock out the LimitRanges method")
//             },
//         }
//
//         // use mockedLimitRangesGetter in code that requires v11.LimitRangesGetter
//         // and then make assertions.
//
//     }
type LimitRangesGetterMock struct {
	// LimitRangesFunc mocks the LimitRanges method.
	LimitRangesFunc func(namespace string) v11.LimitRangeInterface

	// calls tracks calls to the methods.
	calls struct {
		// LimitRanges holds details about calls to the LimitRanges method.
		LimitRanges []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// LimitRanges calls LimitRangesFunc.
func (mock *LimitRangesGetterMock) LimitRanges(namespace string) v11.LimitRangeInterface {
	if mock.LimitRangesFunc == nil {
		panic("LimitRangesGetterMock.LimitRangesFunc: method is nil but LimitRangesGetter.LimitRanges was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockLimitRangesGetterMockLimitRanges.Lock()
	mock.calls.LimitRanges = append(mock.calls.LimitRanges, callInfo)
	lockLimitRangesGetterMockLimitRanges.Unlock()
	return mock.LimitRangesFunc(namespace)
}

// LimitRangesCalls gets all the calls that were made to LimitRanges.
// Check the length with:
//     len(mockedLimitRangesGetter.LimitRangesCalls())
func (mock *LimitRangesGetterMock) LimitRangesCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockLimitRangesGetterMockLimitRanges.RLock()
	calls = mock.calls.LimitRanges
	lockLimitRangesGetterMockLimitRanges.RUnlock()
	return calls
}
