// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v11 "github.com/rancher/rancher/pkg/generated/norman/core/v1"
	v1 "k8s.io/api/core/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockNamespaceListerMockGet  sync.RWMutex
	lockNamespaceListerMockList sync.RWMutex
)

// Ensure, that NamespaceListerMock does implement v11.NamespaceLister.
// If this is not the case, regenerate this file with moq.
var _ v11.NamespaceLister = &NamespaceListerMock{}

// NamespaceListerMock is a mock implementation of v11.NamespaceLister.
//
//     func TestSomethingThatUsesNamespaceLister(t *testing.T) {
//
//         // make and configure a mocked v11.NamespaceLister
//         mockedNamespaceLister := &NamespaceListerMock{
//             GetFunc: func(namespace string, name string) (*v1.Namespace, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v1.Namespace, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedNamespaceLister in code that requires v11.NamespaceLister
//         // and then make assertions.
//
//     }
type NamespaceListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v1.Namespace, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v1.Namespace, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *NamespaceListerMock) Get(namespace string, name string) (*v1.Namespace, error) {
	if mock.GetFunc == nil {
		panic("NamespaceListerMock.GetFunc: method is nil but NamespaceLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockNamespaceListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockNamespaceListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedNamespaceLister.GetCalls())
func (mock *NamespaceListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockNamespaceListerMockGet.RLock()
	calls = mock.calls.Get
	lockNamespaceListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *NamespaceListerMock) List(namespace string, selector labels.Selector) ([]*v1.Namespace, error) {
	if mock.ListFunc == nil {
		panic("NamespaceListerMock.ListFunc: method is nil but NamespaceLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockNamespaceListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockNamespaceListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedNamespaceLister.ListCalls())
func (mock *NamespaceListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockNamespaceListerMockList.RLock()
	calls = mock.calls.List
	lockNamespaceListerMockList.RUnlock()
	return calls
}

var (
	lockNamespaceControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockNamespaceControllerMockAddClusterScopedHandler        sync.RWMutex
	lockNamespaceControllerMockAddFeatureHandler              sync.RWMutex
	lockNamespaceControllerMockAddHandler                     sync.RWMutex
	lockNamespaceControllerMockEnqueue                        sync.RWMutex
	lockNamespaceControllerMockEnqueueAfter                   sync.RWMutex
	lockNamespaceControllerMockGeneric                        sync.RWMutex
	lockNamespaceControllerMockInformer                       sync.RWMutex
	lockNamespaceControllerMockLister                         sync.RWMutex
)

// Ensure, that NamespaceControllerMock does implement v11.NamespaceController.
// If this is not the case, regenerate this file with moq.
var _ v11.NamespaceController = &NamespaceControllerMock{}

// NamespaceControllerMock is a mock implementation of v11.NamespaceController.
//
//     func TestSomethingThatUsesNamespaceController(t *testing.T) {
//
//         // make and configure a mocked v11.NamespaceController
//         mockedNamespaceController := &NamespaceControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.NamespaceHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v11.NamespaceHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.NamespaceHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v11.NamespaceHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v11.NamespaceLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedNamespaceController in code that requires v11.NamespaceController
//         // and then make assertions.
//
//     }
type NamespaceControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.NamespaceHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v11.NamespaceHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.NamespaceHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v11.NamespaceHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v11.NamespaceLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.NamespaceHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.NamespaceHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.NamespaceHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v11.NamespaceHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *NamespaceControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.NamespaceHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("NamespaceControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but NamespaceController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.NamespaceHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockNamespaceControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockNamespaceControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedNamespaceController.AddClusterScopedFeatureHandlerCalls())
func (mock *NamespaceControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v11.NamespaceHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.NamespaceHandlerFunc
	}
	lockNamespaceControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockNamespaceControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *NamespaceControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v11.NamespaceHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("NamespaceControllerMock.AddClusterScopedHandlerFunc: method is nil but NamespaceController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.NamespaceHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockNamespaceControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockNamespaceControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedNamespaceController.AddClusterScopedHandlerCalls())
func (mock *NamespaceControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v11.NamespaceHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.NamespaceHandlerFunc
	}
	lockNamespaceControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockNamespaceControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *NamespaceControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.NamespaceHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("NamespaceControllerMock.AddFeatureHandlerFunc: method is nil but NamespaceController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.NamespaceHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockNamespaceControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockNamespaceControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedNamespaceController.AddFeatureHandlerCalls())
func (mock *NamespaceControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.NamespaceHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.NamespaceHandlerFunc
	}
	lockNamespaceControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockNamespaceControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *NamespaceControllerMock) AddHandler(ctx context.Context, name string, handler v11.NamespaceHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("NamespaceControllerMock.AddHandlerFunc: method is nil but NamespaceController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v11.NamespaceHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockNamespaceControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockNamespaceControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedNamespaceController.AddHandlerCalls())
func (mock *NamespaceControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v11.NamespaceHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v11.NamespaceHandlerFunc
	}
	lockNamespaceControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockNamespaceControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *NamespaceControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("NamespaceControllerMock.EnqueueFunc: method is nil but NamespaceController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockNamespaceControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockNamespaceControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedNamespaceController.EnqueueCalls())
func (mock *NamespaceControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockNamespaceControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockNamespaceControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *NamespaceControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("NamespaceControllerMock.EnqueueAfterFunc: method is nil but NamespaceController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockNamespaceControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockNamespaceControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedNamespaceController.EnqueueAfterCalls())
func (mock *NamespaceControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockNamespaceControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockNamespaceControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *NamespaceControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("NamespaceControllerMock.GenericFunc: method is nil but NamespaceController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockNamespaceControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockNamespaceControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedNamespaceController.GenericCalls())
func (mock *NamespaceControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockNamespaceControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockNamespaceControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *NamespaceControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("NamespaceControllerMock.InformerFunc: method is nil but NamespaceController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockNamespaceControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockNamespaceControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedNamespaceController.InformerCalls())
func (mock *NamespaceControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockNamespaceControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockNamespaceControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *NamespaceControllerMock) Lister() v11.NamespaceLister {
	if mock.ListerFunc == nil {
		panic("NamespaceControllerMock.ListerFunc: method is nil but NamespaceController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockNamespaceControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockNamespaceControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedNamespaceController.ListerCalls())
func (mock *NamespaceControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockNamespaceControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockNamespaceControllerMockLister.RUnlock()
	return calls
}

var (
	lockNamespaceInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockNamespaceInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockNamespaceInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockNamespaceInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockNamespaceInterfaceMockAddFeatureHandler                sync.RWMutex
	lockNamespaceInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockNamespaceInterfaceMockAddHandler                       sync.RWMutex
	lockNamespaceInterfaceMockAddLifecycle                     sync.RWMutex
	lockNamespaceInterfaceMockController                       sync.RWMutex
	lockNamespaceInterfaceMockCreate                           sync.RWMutex
	lockNamespaceInterfaceMockDelete                           sync.RWMutex
	lockNamespaceInterfaceMockDeleteCollection                 sync.RWMutex
	lockNamespaceInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockNamespaceInterfaceMockGet                              sync.RWMutex
	lockNamespaceInterfaceMockGetNamespaced                    sync.RWMutex
	lockNamespaceInterfaceMockList                             sync.RWMutex
	lockNamespaceInterfaceMockListNamespaced                   sync.RWMutex
	lockNamespaceInterfaceMockObjectClient                     sync.RWMutex
	lockNamespaceInterfaceMockUpdate                           sync.RWMutex
	lockNamespaceInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that NamespaceInterfaceMock does implement v11.NamespaceInterface.
// If this is not the case, regenerate this file with moq.
var _ v11.NamespaceInterface = &NamespaceInterfaceMock{}

// NamespaceInterfaceMock is a mock implementation of v11.NamespaceInterface.
//
//     func TestSomethingThatUsesNamespaceInterface(t *testing.T) {
//
//         // make and configure a mocked v11.NamespaceInterface
//         mockedNamespaceInterface := &NamespaceInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.NamespaceHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.NamespaceLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v11.NamespaceHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v11.NamespaceLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.NamespaceHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v11.NamespaceLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v11.NamespaceHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v11.NamespaceLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v11.NamespaceController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v1.Namespace) (*v1.Namespace, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v1.Namespace, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v1.Namespace, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v1.NamespaceList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v1.NamespaceList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v1.Namespace) (*v1.Namespace, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedNamespaceInterface in code that requires v11.NamespaceInterface
//         // and then make assertions.
//
//     }
type NamespaceInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.NamespaceHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.NamespaceLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v11.NamespaceHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v11.NamespaceLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.NamespaceHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v11.NamespaceLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v11.NamespaceHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v11.NamespaceLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v11.NamespaceController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v1.Namespace) (*v1.Namespace, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v1.Namespace, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v1.Namespace, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v1.NamespaceList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v1.NamespaceList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v1.Namespace) (*v1.Namespace, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.NamespaceHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.NamespaceLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.NamespaceHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.NamespaceLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.NamespaceHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.NamespaceLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.NamespaceHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.NamespaceLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v1.Namespace
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v1.Namespace
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *NamespaceInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.NamespaceHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("NamespaceInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but NamespaceInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.NamespaceHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockNamespaceInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockNamespaceInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedNamespaceInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *NamespaceInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v11.NamespaceHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.NamespaceHandlerFunc
	}
	lockNamespaceInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockNamespaceInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *NamespaceInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.NamespaceLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("NamespaceInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but NamespaceInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.NamespaceLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockNamespaceInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockNamespaceInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedNamespaceInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *NamespaceInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v11.NamespaceLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.NamespaceLifecycle
	}
	lockNamespaceInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockNamespaceInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *NamespaceInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v11.NamespaceHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("NamespaceInterfaceMock.AddClusterScopedHandlerFunc: method is nil but NamespaceInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.NamespaceHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockNamespaceInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockNamespaceInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedNamespaceInterface.AddClusterScopedHandlerCalls())
func (mock *NamespaceInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v11.NamespaceHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.NamespaceHandlerFunc
	}
	lockNamespaceInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockNamespaceInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *NamespaceInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v11.NamespaceLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("NamespaceInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but NamespaceInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.NamespaceLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockNamespaceInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockNamespaceInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedNamespaceInterface.AddClusterScopedLifecycleCalls())
func (mock *NamespaceInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v11.NamespaceLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.NamespaceLifecycle
	}
	lockNamespaceInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockNamespaceInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *NamespaceInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.NamespaceHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("NamespaceInterfaceMock.AddFeatureHandlerFunc: method is nil but NamespaceInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.NamespaceHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockNamespaceInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockNamespaceInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedNamespaceInterface.AddFeatureHandlerCalls())
func (mock *NamespaceInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.NamespaceHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.NamespaceHandlerFunc
	}
	lockNamespaceInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockNamespaceInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *NamespaceInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v11.NamespaceLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("NamespaceInterfaceMock.AddFeatureLifecycleFunc: method is nil but NamespaceInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.NamespaceLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockNamespaceInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockNamespaceInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedNamespaceInterface.AddFeatureLifecycleCalls())
func (mock *NamespaceInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v11.NamespaceLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.NamespaceLifecycle
	}
	lockNamespaceInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockNamespaceInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *NamespaceInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v11.NamespaceHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("NamespaceInterfaceMock.AddHandlerFunc: method is nil but NamespaceInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v11.NamespaceHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockNamespaceInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockNamespaceInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedNamespaceInterface.AddHandlerCalls())
func (mock *NamespaceInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v11.NamespaceHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v11.NamespaceHandlerFunc
	}
	lockNamespaceInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockNamespaceInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *NamespaceInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v11.NamespaceLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("NamespaceInterfaceMock.AddLifecycleFunc: method is nil but NamespaceInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.NamespaceLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockNamespaceInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockNamespaceInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedNamespaceInterface.AddLifecycleCalls())
func (mock *NamespaceInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v11.NamespaceLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.NamespaceLifecycle
	}
	lockNamespaceInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockNamespaceInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *NamespaceInterfaceMock) Controller() v11.NamespaceController {
	if mock.ControllerFunc == nil {
		panic("NamespaceInterfaceMock.ControllerFunc: method is nil but NamespaceInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockNamespaceInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockNamespaceInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedNamespaceInterface.ControllerCalls())
func (mock *NamespaceInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockNamespaceInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockNamespaceInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *NamespaceInterfaceMock) Create(in1 *v1.Namespace) (*v1.Namespace, error) {
	if mock.CreateFunc == nil {
		panic("NamespaceInterfaceMock.CreateFunc: method is nil but NamespaceInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v1.Namespace
	}{
		In1: in1,
	}
	lockNamespaceInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockNamespaceInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedNamespaceInterface.CreateCalls())
func (mock *NamespaceInterfaceMock) CreateCalls() []struct {
	In1 *v1.Namespace
} {
	var calls []struct {
		In1 *v1.Namespace
	}
	lockNamespaceInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockNamespaceInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *NamespaceInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("NamespaceInterfaceMock.DeleteFunc: method is nil but NamespaceInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockNamespaceInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockNamespaceInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedNamespaceInterface.DeleteCalls())
func (mock *NamespaceInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockNamespaceInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockNamespaceInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *NamespaceInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("NamespaceInterfaceMock.DeleteCollectionFunc: method is nil but NamespaceInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockNamespaceInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockNamespaceInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedNamespaceInterface.DeleteCollectionCalls())
func (mock *NamespaceInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockNamespaceInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockNamespaceInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *NamespaceInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("NamespaceInterfaceMock.DeleteNamespacedFunc: method is nil but NamespaceInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockNamespaceInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockNamespaceInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedNamespaceInterface.DeleteNamespacedCalls())
func (mock *NamespaceInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockNamespaceInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockNamespaceInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *NamespaceInterfaceMock) Get(name string, opts metav1.GetOptions) (*v1.Namespace, error) {
	if mock.GetFunc == nil {
		panic("NamespaceInterfaceMock.GetFunc: method is nil but NamespaceInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockNamespaceInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockNamespaceInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedNamespaceInterface.GetCalls())
func (mock *NamespaceInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockNamespaceInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockNamespaceInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *NamespaceInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v1.Namespace, error) {
	if mock.GetNamespacedFunc == nil {
		panic("NamespaceInterfaceMock.GetNamespacedFunc: method is nil but NamespaceInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockNamespaceInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockNamespaceInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedNamespaceInterface.GetNamespacedCalls())
func (mock *NamespaceInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockNamespaceInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockNamespaceInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *NamespaceInterfaceMock) List(opts metav1.ListOptions) (*v1.NamespaceList, error) {
	if mock.ListFunc == nil {
		panic("NamespaceInterfaceMock.ListFunc: method is nil but NamespaceInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockNamespaceInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockNamespaceInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedNamespaceInterface.ListCalls())
func (mock *NamespaceInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockNamespaceInterfaceMockList.RLock()
	calls = mock.calls.List
	lockNamespaceInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *NamespaceInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v1.NamespaceList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("NamespaceInterfaceMock.ListNamespacedFunc: method is nil but NamespaceInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockNamespaceInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockNamespaceInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedNamespaceInterface.ListNamespacedCalls())
func (mock *NamespaceInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockNamespaceInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockNamespaceInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *NamespaceInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("NamespaceInterfaceMock.ObjectClientFunc: method is nil but NamespaceInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockNamespaceInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockNamespaceInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedNamespaceInterface.ObjectClientCalls())
func (mock *NamespaceInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockNamespaceInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockNamespaceInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *NamespaceInterfaceMock) Update(in1 *v1.Namespace) (*v1.Namespace, error) {
	if mock.UpdateFunc == nil {
		panic("NamespaceInterfaceMock.UpdateFunc: method is nil but NamespaceInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v1.Namespace
	}{
		In1: in1,
	}
	lockNamespaceInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockNamespaceInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedNamespaceInterface.UpdateCalls())
func (mock *NamespaceInterfaceMock) UpdateCalls() []struct {
	In1 *v1.Namespace
} {
	var calls []struct {
		In1 *v1.Namespace
	}
	lockNamespaceInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockNamespaceInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *NamespaceInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("NamespaceInterfaceMock.WatchFunc: method is nil but NamespaceInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockNamespaceInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockNamespaceInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedNamespaceInterface.WatchCalls())
func (mock *NamespaceInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockNamespaceInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockNamespaceInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockNamespacesGetterMockNamespaces sync.RWMutex
)

// Ensure, that NamespacesGetterMock does implement v11.NamespacesGetter.
// If this is not the case, regenerate this file with moq.
var _ v11.NamespacesGetter = &NamespacesGetterMock{}

// NamespacesGetterMock is a mock implementation of v11.NamespacesGetter.
//
//     func TestSomethingThatUsesNamespacesGetter(t *testing.T) {
//
//         // make and configure a mocked v11.NamespacesGetter
//         mockedNamespacesGetter := &NamespacesGetterMock{
//             NamespacesFunc: func(namespace string) v11.NamespaceInterface {
// 	               panic("mock out the Namespaces method")
//             },
//         }
//
//         // use mockedNamespacesGetter in code that requires v11.NamespacesGetter
//         // and then make assertions.
//
//     }
type NamespacesGetterMock struct {
	// NamespacesFunc mocks the Namespaces method.
	NamespacesFunc func(namespace string) v11.NamespaceInterface

	// calls tracks calls to the methods.
	calls struct {
		// Namespaces holds details about calls to the Namespaces method.
		Namespaces []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// Namespaces calls NamespacesFunc.
func (mock *NamespacesGetterMock) Namespaces(namespace string) v11.NamespaceInterface {
	if mock.NamespacesFunc == nil {
		panic("NamespacesGetterMock.NamespacesFunc: method is nil but NamespacesGetter.Namespaces was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockNamespacesGetterMockNamespaces.Lock()
	mock.calls.Namespaces = append(mock.calls.Namespaces, callInfo)
	lockNamespacesGetterMockNamespaces.Unlock()
	return mock.NamespacesFunc(namespace)
}

// NamespacesCalls gets all the calls that were made to Namespaces.
// Check the length with:
//     len(mockedNamespacesGetter.NamespacesCalls())
func (mock *NamespacesGetterMock) NamespacesCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockNamespacesGetterMockNamespaces.RLock()
	calls = mock.calls.Namespaces
	lockNamespacesGetterMockNamespaces.RUnlock()
	return calls
}
