// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v11 "github.com/rancher/rancher/pkg/generated/norman/core/v1"
	v1 "k8s.io/api/core/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockPersistentVolumeClaimListerMockGet  sync.RWMutex
	lockPersistentVolumeClaimListerMockList sync.RWMutex
)

// Ensure, that PersistentVolumeClaimListerMock does implement v11.PersistentVolumeClaimLister.
// If this is not the case, regenerate this file with moq.
var _ v11.PersistentVolumeClaimLister = &PersistentVolumeClaimListerMock{}

// PersistentVolumeClaimListerMock is a mock implementation of v11.PersistentVolumeClaimLister.
//
//     func TestSomethingThatUsesPersistentVolumeClaimLister(t *testing.T) {
//
//         // make and configure a mocked v11.PersistentVolumeClaimLister
//         mockedPersistentVolumeClaimLister := &PersistentVolumeClaimListerMock{
//             GetFunc: func(namespace string, name string) (*v1.PersistentVolumeClaim, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v1.PersistentVolumeClaim, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedPersistentVolumeClaimLister in code that requires v11.PersistentVolumeClaimLister
//         // and then make assertions.
//
//     }
type PersistentVolumeClaimListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v1.PersistentVolumeClaim, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v1.PersistentVolumeClaim, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *PersistentVolumeClaimListerMock) Get(namespace string, name string) (*v1.PersistentVolumeClaim, error) {
	if mock.GetFunc == nil {
		panic("PersistentVolumeClaimListerMock.GetFunc: method is nil but PersistentVolumeClaimLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockPersistentVolumeClaimListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockPersistentVolumeClaimListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedPersistentVolumeClaimLister.GetCalls())
func (mock *PersistentVolumeClaimListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockPersistentVolumeClaimListerMockGet.RLock()
	calls = mock.calls.Get
	lockPersistentVolumeClaimListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *PersistentVolumeClaimListerMock) List(namespace string, selector labels.Selector) ([]*v1.PersistentVolumeClaim, error) {
	if mock.ListFunc == nil {
		panic("PersistentVolumeClaimListerMock.ListFunc: method is nil but PersistentVolumeClaimLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockPersistentVolumeClaimListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockPersistentVolumeClaimListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedPersistentVolumeClaimLister.ListCalls())
func (mock *PersistentVolumeClaimListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockPersistentVolumeClaimListerMockList.RLock()
	calls = mock.calls.List
	lockPersistentVolumeClaimListerMockList.RUnlock()
	return calls
}

var (
	lockPersistentVolumeClaimControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockPersistentVolumeClaimControllerMockAddClusterScopedHandler        sync.RWMutex
	lockPersistentVolumeClaimControllerMockAddFeatureHandler              sync.RWMutex
	lockPersistentVolumeClaimControllerMockAddHandler                     sync.RWMutex
	lockPersistentVolumeClaimControllerMockEnqueue                        sync.RWMutex
	lockPersistentVolumeClaimControllerMockEnqueueAfter                   sync.RWMutex
	lockPersistentVolumeClaimControllerMockGeneric                        sync.RWMutex
	lockPersistentVolumeClaimControllerMockInformer                       sync.RWMutex
	lockPersistentVolumeClaimControllerMockLister                         sync.RWMutex
)

// Ensure, that PersistentVolumeClaimControllerMock does implement v11.PersistentVolumeClaimController.
// If this is not the case, regenerate this file with moq.
var _ v11.PersistentVolumeClaimController = &PersistentVolumeClaimControllerMock{}

// PersistentVolumeClaimControllerMock is a mock implementation of v11.PersistentVolumeClaimController.
//
//     func TestSomethingThatUsesPersistentVolumeClaimController(t *testing.T) {
//
//         // make and configure a mocked v11.PersistentVolumeClaimController
//         mockedPersistentVolumeClaimController := &PersistentVolumeClaimControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.PersistentVolumeClaimHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v11.PersistentVolumeClaimHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.PersistentVolumeClaimHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v11.PersistentVolumeClaimHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v11.PersistentVolumeClaimLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedPersistentVolumeClaimController in code that requires v11.PersistentVolumeClaimController
//         // and then make assertions.
//
//     }
type PersistentVolumeClaimControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.PersistentVolumeClaimHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v11.PersistentVolumeClaimHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.PersistentVolumeClaimHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v11.PersistentVolumeClaimHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v11.PersistentVolumeClaimLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.PersistentVolumeClaimHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.PersistentVolumeClaimHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.PersistentVolumeClaimHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v11.PersistentVolumeClaimHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *PersistentVolumeClaimControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.PersistentVolumeClaimHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("PersistentVolumeClaimControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but PersistentVolumeClaimController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.PersistentVolumeClaimHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockPersistentVolumeClaimControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockPersistentVolumeClaimControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedPersistentVolumeClaimController.AddClusterScopedFeatureHandlerCalls())
func (mock *PersistentVolumeClaimControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v11.PersistentVolumeClaimHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.PersistentVolumeClaimHandlerFunc
	}
	lockPersistentVolumeClaimControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockPersistentVolumeClaimControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *PersistentVolumeClaimControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v11.PersistentVolumeClaimHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("PersistentVolumeClaimControllerMock.AddClusterScopedHandlerFunc: method is nil but PersistentVolumeClaimController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.PersistentVolumeClaimHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockPersistentVolumeClaimControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockPersistentVolumeClaimControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedPersistentVolumeClaimController.AddClusterScopedHandlerCalls())
func (mock *PersistentVolumeClaimControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v11.PersistentVolumeClaimHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.PersistentVolumeClaimHandlerFunc
	}
	lockPersistentVolumeClaimControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockPersistentVolumeClaimControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *PersistentVolumeClaimControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.PersistentVolumeClaimHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("PersistentVolumeClaimControllerMock.AddFeatureHandlerFunc: method is nil but PersistentVolumeClaimController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.PersistentVolumeClaimHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockPersistentVolumeClaimControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockPersistentVolumeClaimControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedPersistentVolumeClaimController.AddFeatureHandlerCalls())
func (mock *PersistentVolumeClaimControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.PersistentVolumeClaimHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.PersistentVolumeClaimHandlerFunc
	}
	lockPersistentVolumeClaimControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockPersistentVolumeClaimControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *PersistentVolumeClaimControllerMock) AddHandler(ctx context.Context, name string, handler v11.PersistentVolumeClaimHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("PersistentVolumeClaimControllerMock.AddHandlerFunc: method is nil but PersistentVolumeClaimController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v11.PersistentVolumeClaimHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockPersistentVolumeClaimControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockPersistentVolumeClaimControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedPersistentVolumeClaimController.AddHandlerCalls())
func (mock *PersistentVolumeClaimControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v11.PersistentVolumeClaimHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v11.PersistentVolumeClaimHandlerFunc
	}
	lockPersistentVolumeClaimControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockPersistentVolumeClaimControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *PersistentVolumeClaimControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("PersistentVolumeClaimControllerMock.EnqueueFunc: method is nil but PersistentVolumeClaimController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockPersistentVolumeClaimControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockPersistentVolumeClaimControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedPersistentVolumeClaimController.EnqueueCalls())
func (mock *PersistentVolumeClaimControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockPersistentVolumeClaimControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockPersistentVolumeClaimControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *PersistentVolumeClaimControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("PersistentVolumeClaimControllerMock.EnqueueAfterFunc: method is nil but PersistentVolumeClaimController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockPersistentVolumeClaimControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockPersistentVolumeClaimControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedPersistentVolumeClaimController.EnqueueAfterCalls())
func (mock *PersistentVolumeClaimControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockPersistentVolumeClaimControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockPersistentVolumeClaimControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *PersistentVolumeClaimControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("PersistentVolumeClaimControllerMock.GenericFunc: method is nil but PersistentVolumeClaimController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockPersistentVolumeClaimControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockPersistentVolumeClaimControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedPersistentVolumeClaimController.GenericCalls())
func (mock *PersistentVolumeClaimControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockPersistentVolumeClaimControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockPersistentVolumeClaimControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *PersistentVolumeClaimControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("PersistentVolumeClaimControllerMock.InformerFunc: method is nil but PersistentVolumeClaimController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockPersistentVolumeClaimControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockPersistentVolumeClaimControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedPersistentVolumeClaimController.InformerCalls())
func (mock *PersistentVolumeClaimControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockPersistentVolumeClaimControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockPersistentVolumeClaimControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *PersistentVolumeClaimControllerMock) Lister() v11.PersistentVolumeClaimLister {
	if mock.ListerFunc == nil {
		panic("PersistentVolumeClaimControllerMock.ListerFunc: method is nil but PersistentVolumeClaimController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockPersistentVolumeClaimControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockPersistentVolumeClaimControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedPersistentVolumeClaimController.ListerCalls())
func (mock *PersistentVolumeClaimControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockPersistentVolumeClaimControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockPersistentVolumeClaimControllerMockLister.RUnlock()
	return calls
}

var (
	lockPersistentVolumeClaimInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockPersistentVolumeClaimInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockPersistentVolumeClaimInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockPersistentVolumeClaimInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockPersistentVolumeClaimInterfaceMockAddFeatureHandler                sync.RWMutex
	lockPersistentVolumeClaimInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockPersistentVolumeClaimInterfaceMockAddHandler                       sync.RWMutex
	lockPersistentVolumeClaimInterfaceMockAddLifecycle                     sync.RWMutex
	lockPersistentVolumeClaimInterfaceMockController                       sync.RWMutex
	lockPersistentVolumeClaimInterfaceMockCreate                           sync.RWMutex
	lockPersistentVolumeClaimInterfaceMockDelete                           sync.RWMutex
	lockPersistentVolumeClaimInterfaceMockDeleteCollection                 sync.RWMutex
	lockPersistentVolumeClaimInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockPersistentVolumeClaimInterfaceMockGet                              sync.RWMutex
	lockPersistentVolumeClaimInterfaceMockGetNamespaced                    sync.RWMutex
	lockPersistentVolumeClaimInterfaceMockList                             sync.RWMutex
	lockPersistentVolumeClaimInterfaceMockListNamespaced                   sync.RWMutex
	lockPersistentVolumeClaimInterfaceMockObjectClient                     sync.RWMutex
	lockPersistentVolumeClaimInterfaceMockUpdate                           sync.RWMutex
	lockPersistentVolumeClaimInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that PersistentVolumeClaimInterfaceMock does implement v11.PersistentVolumeClaimInterface.
// If this is not the case, regenerate this file with moq.
var _ v11.PersistentVolumeClaimInterface = &PersistentVolumeClaimInterfaceMock{}

// PersistentVolumeClaimInterfaceMock is a mock implementation of v11.PersistentVolumeClaimInterface.
//
//     func TestSomethingThatUsesPersistentVolumeClaimInterface(t *testing.T) {
//
//         // make and configure a mocked v11.PersistentVolumeClaimInterface
//         mockedPersistentVolumeClaimInterface := &PersistentVolumeClaimInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.PersistentVolumeClaimHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.PersistentVolumeClaimLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v11.PersistentVolumeClaimHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v11.PersistentVolumeClaimLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.PersistentVolumeClaimHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v11.PersistentVolumeClaimLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v11.PersistentVolumeClaimHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v11.PersistentVolumeClaimLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v11.PersistentVolumeClaimController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v1.PersistentVolumeClaim) (*v1.PersistentVolumeClaim, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v1.PersistentVolumeClaim, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v1.PersistentVolumeClaim, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v1.PersistentVolumeClaimList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v1.PersistentVolumeClaimList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v1.PersistentVolumeClaim) (*v1.PersistentVolumeClaim, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedPersistentVolumeClaimInterface in code that requires v11.PersistentVolumeClaimInterface
//         // and then make assertions.
//
//     }
type PersistentVolumeClaimInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.PersistentVolumeClaimHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.PersistentVolumeClaimLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v11.PersistentVolumeClaimHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v11.PersistentVolumeClaimLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.PersistentVolumeClaimHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v11.PersistentVolumeClaimLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v11.PersistentVolumeClaimHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v11.PersistentVolumeClaimLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v11.PersistentVolumeClaimController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v1.PersistentVolumeClaim) (*v1.PersistentVolumeClaim, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v1.PersistentVolumeClaim, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v1.PersistentVolumeClaim, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v1.PersistentVolumeClaimList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v1.PersistentVolumeClaimList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v1.PersistentVolumeClaim) (*v1.PersistentVolumeClaim, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.PersistentVolumeClaimHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.PersistentVolumeClaimLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.PersistentVolumeClaimHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.PersistentVolumeClaimLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.PersistentVolumeClaimHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.PersistentVolumeClaimLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.PersistentVolumeClaimHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.PersistentVolumeClaimLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v1.PersistentVolumeClaim
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v1.PersistentVolumeClaim
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *PersistentVolumeClaimInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.PersistentVolumeClaimHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("PersistentVolumeClaimInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but PersistentVolumeClaimInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.PersistentVolumeClaimHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockPersistentVolumeClaimInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockPersistentVolumeClaimInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedPersistentVolumeClaimInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *PersistentVolumeClaimInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v11.PersistentVolumeClaimHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.PersistentVolumeClaimHandlerFunc
	}
	lockPersistentVolumeClaimInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockPersistentVolumeClaimInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *PersistentVolumeClaimInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.PersistentVolumeClaimLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("PersistentVolumeClaimInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but PersistentVolumeClaimInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.PersistentVolumeClaimLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockPersistentVolumeClaimInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockPersistentVolumeClaimInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedPersistentVolumeClaimInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *PersistentVolumeClaimInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v11.PersistentVolumeClaimLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.PersistentVolumeClaimLifecycle
	}
	lockPersistentVolumeClaimInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockPersistentVolumeClaimInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *PersistentVolumeClaimInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v11.PersistentVolumeClaimHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("PersistentVolumeClaimInterfaceMock.AddClusterScopedHandlerFunc: method is nil but PersistentVolumeClaimInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.PersistentVolumeClaimHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockPersistentVolumeClaimInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockPersistentVolumeClaimInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedPersistentVolumeClaimInterface.AddClusterScopedHandlerCalls())
func (mock *PersistentVolumeClaimInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v11.PersistentVolumeClaimHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.PersistentVolumeClaimHandlerFunc
	}
	lockPersistentVolumeClaimInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockPersistentVolumeClaimInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *PersistentVolumeClaimInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v11.PersistentVolumeClaimLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("PersistentVolumeClaimInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but PersistentVolumeClaimInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.PersistentVolumeClaimLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockPersistentVolumeClaimInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockPersistentVolumeClaimInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedPersistentVolumeClaimInterface.AddClusterScopedLifecycleCalls())
func (mock *PersistentVolumeClaimInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v11.PersistentVolumeClaimLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.PersistentVolumeClaimLifecycle
	}
	lockPersistentVolumeClaimInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockPersistentVolumeClaimInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *PersistentVolumeClaimInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.PersistentVolumeClaimHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("PersistentVolumeClaimInterfaceMock.AddFeatureHandlerFunc: method is nil but PersistentVolumeClaimInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.PersistentVolumeClaimHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockPersistentVolumeClaimInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockPersistentVolumeClaimInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedPersistentVolumeClaimInterface.AddFeatureHandlerCalls())
func (mock *PersistentVolumeClaimInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.PersistentVolumeClaimHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.PersistentVolumeClaimHandlerFunc
	}
	lockPersistentVolumeClaimInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockPersistentVolumeClaimInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *PersistentVolumeClaimInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v11.PersistentVolumeClaimLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("PersistentVolumeClaimInterfaceMock.AddFeatureLifecycleFunc: method is nil but PersistentVolumeClaimInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.PersistentVolumeClaimLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockPersistentVolumeClaimInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockPersistentVolumeClaimInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedPersistentVolumeClaimInterface.AddFeatureLifecycleCalls())
func (mock *PersistentVolumeClaimInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v11.PersistentVolumeClaimLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.PersistentVolumeClaimLifecycle
	}
	lockPersistentVolumeClaimInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockPersistentVolumeClaimInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *PersistentVolumeClaimInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v11.PersistentVolumeClaimHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("PersistentVolumeClaimInterfaceMock.AddHandlerFunc: method is nil but PersistentVolumeClaimInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v11.PersistentVolumeClaimHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockPersistentVolumeClaimInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockPersistentVolumeClaimInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedPersistentVolumeClaimInterface.AddHandlerCalls())
func (mock *PersistentVolumeClaimInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v11.PersistentVolumeClaimHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v11.PersistentVolumeClaimHandlerFunc
	}
	lockPersistentVolumeClaimInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockPersistentVolumeClaimInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *PersistentVolumeClaimInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v11.PersistentVolumeClaimLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("PersistentVolumeClaimInterfaceMock.AddLifecycleFunc: method is nil but PersistentVolumeClaimInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.PersistentVolumeClaimLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockPersistentVolumeClaimInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockPersistentVolumeClaimInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedPersistentVolumeClaimInterface.AddLifecycleCalls())
func (mock *PersistentVolumeClaimInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v11.PersistentVolumeClaimLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.PersistentVolumeClaimLifecycle
	}
	lockPersistentVolumeClaimInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockPersistentVolumeClaimInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *PersistentVolumeClaimInterfaceMock) Controller() v11.PersistentVolumeClaimController {
	if mock.ControllerFunc == nil {
		panic("PersistentVolumeClaimInterfaceMock.ControllerFunc: method is nil but PersistentVolumeClaimInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockPersistentVolumeClaimInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockPersistentVolumeClaimInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedPersistentVolumeClaimInterface.ControllerCalls())
func (mock *PersistentVolumeClaimInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockPersistentVolumeClaimInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockPersistentVolumeClaimInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *PersistentVolumeClaimInterfaceMock) Create(in1 *v1.PersistentVolumeClaim) (*v1.PersistentVolumeClaim, error) {
	if mock.CreateFunc == nil {
		panic("PersistentVolumeClaimInterfaceMock.CreateFunc: method is nil but PersistentVolumeClaimInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v1.PersistentVolumeClaim
	}{
		In1: in1,
	}
	lockPersistentVolumeClaimInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockPersistentVolumeClaimInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedPersistentVolumeClaimInterface.CreateCalls())
func (mock *PersistentVolumeClaimInterfaceMock) CreateCalls() []struct {
	In1 *v1.PersistentVolumeClaim
} {
	var calls []struct {
		In1 *v1.PersistentVolumeClaim
	}
	lockPersistentVolumeClaimInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockPersistentVolumeClaimInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *PersistentVolumeClaimInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("PersistentVolumeClaimInterfaceMock.DeleteFunc: method is nil but PersistentVolumeClaimInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockPersistentVolumeClaimInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockPersistentVolumeClaimInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedPersistentVolumeClaimInterface.DeleteCalls())
func (mock *PersistentVolumeClaimInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockPersistentVolumeClaimInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockPersistentVolumeClaimInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *PersistentVolumeClaimInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("PersistentVolumeClaimInterfaceMock.DeleteCollectionFunc: method is nil but PersistentVolumeClaimInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockPersistentVolumeClaimInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockPersistentVolumeClaimInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedPersistentVolumeClaimInterface.DeleteCollectionCalls())
func (mock *PersistentVolumeClaimInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockPersistentVolumeClaimInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockPersistentVolumeClaimInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *PersistentVolumeClaimInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("PersistentVolumeClaimInterfaceMock.DeleteNamespacedFunc: method is nil but PersistentVolumeClaimInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockPersistentVolumeClaimInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockPersistentVolumeClaimInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedPersistentVolumeClaimInterface.DeleteNamespacedCalls())
func (mock *PersistentVolumeClaimInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockPersistentVolumeClaimInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockPersistentVolumeClaimInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *PersistentVolumeClaimInterfaceMock) Get(name string, opts metav1.GetOptions) (*v1.PersistentVolumeClaim, error) {
	if mock.GetFunc == nil {
		panic("PersistentVolumeClaimInterfaceMock.GetFunc: method is nil but PersistentVolumeClaimInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockPersistentVolumeClaimInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockPersistentVolumeClaimInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedPersistentVolumeClaimInterface.GetCalls())
func (mock *PersistentVolumeClaimInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockPersistentVolumeClaimInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockPersistentVolumeClaimInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *PersistentVolumeClaimInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v1.PersistentVolumeClaim, error) {
	if mock.GetNamespacedFunc == nil {
		panic("PersistentVolumeClaimInterfaceMock.GetNamespacedFunc: method is nil but PersistentVolumeClaimInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockPersistentVolumeClaimInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockPersistentVolumeClaimInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedPersistentVolumeClaimInterface.GetNamespacedCalls())
func (mock *PersistentVolumeClaimInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockPersistentVolumeClaimInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockPersistentVolumeClaimInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *PersistentVolumeClaimInterfaceMock) List(opts metav1.ListOptions) (*v1.PersistentVolumeClaimList, error) {
	if mock.ListFunc == nil {
		panic("PersistentVolumeClaimInterfaceMock.ListFunc: method is nil but PersistentVolumeClaimInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockPersistentVolumeClaimInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockPersistentVolumeClaimInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedPersistentVolumeClaimInterface.ListCalls())
func (mock *PersistentVolumeClaimInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockPersistentVolumeClaimInterfaceMockList.RLock()
	calls = mock.calls.List
	lockPersistentVolumeClaimInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *PersistentVolumeClaimInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v1.PersistentVolumeClaimList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("PersistentVolumeClaimInterfaceMock.ListNamespacedFunc: method is nil but PersistentVolumeClaimInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockPersistentVolumeClaimInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockPersistentVolumeClaimInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedPersistentVolumeClaimInterface.ListNamespacedCalls())
func (mock *PersistentVolumeClaimInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockPersistentVolumeClaimInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockPersistentVolumeClaimInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *PersistentVolumeClaimInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("PersistentVolumeClaimInterfaceMock.ObjectClientFunc: method is nil but PersistentVolumeClaimInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockPersistentVolumeClaimInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockPersistentVolumeClaimInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedPersistentVolumeClaimInterface.ObjectClientCalls())
func (mock *PersistentVolumeClaimInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockPersistentVolumeClaimInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockPersistentVolumeClaimInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *PersistentVolumeClaimInterfaceMock) Update(in1 *v1.PersistentVolumeClaim) (*v1.PersistentVolumeClaim, error) {
	if mock.UpdateFunc == nil {
		panic("PersistentVolumeClaimInterfaceMock.UpdateFunc: method is nil but PersistentVolumeClaimInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v1.PersistentVolumeClaim
	}{
		In1: in1,
	}
	lockPersistentVolumeClaimInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockPersistentVolumeClaimInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedPersistentVolumeClaimInterface.UpdateCalls())
func (mock *PersistentVolumeClaimInterfaceMock) UpdateCalls() []struct {
	In1 *v1.PersistentVolumeClaim
} {
	var calls []struct {
		In1 *v1.PersistentVolumeClaim
	}
	lockPersistentVolumeClaimInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockPersistentVolumeClaimInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *PersistentVolumeClaimInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("PersistentVolumeClaimInterfaceMock.WatchFunc: method is nil but PersistentVolumeClaimInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockPersistentVolumeClaimInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockPersistentVolumeClaimInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedPersistentVolumeClaimInterface.WatchCalls())
func (mock *PersistentVolumeClaimInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockPersistentVolumeClaimInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockPersistentVolumeClaimInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockPersistentVolumeClaimsGetterMockPersistentVolumeClaims sync.RWMutex
)

// Ensure, that PersistentVolumeClaimsGetterMock does implement v11.PersistentVolumeClaimsGetter.
// If this is not the case, regenerate this file with moq.
var _ v11.PersistentVolumeClaimsGetter = &PersistentVolumeClaimsGetterMock{}

// PersistentVolumeClaimsGetterMock is a mock implementation of v11.PersistentVolumeClaimsGetter.
//
//     func TestSomethingThatUsesPersistentVolumeClaimsGetter(t *testing.T) {
//
//         // make and configure a mocked v11.PersistentVolumeClaimsGetter
//         mockedPersistentVolumeClaimsGetter := &PersistentVolumeClaimsGetterMock{
//             PersistentVolumeClaimsFunc: func(namespace string) v11.PersistentVolumeClaimInterface {
// 	               panic("mock out the PersistentVolumeClaims method")
//             },
//         }
//
//         // use mockedPersistentVolumeClaimsGetter in code that requires v11.PersistentVolumeClaimsGetter
//         // and then make assertions.
//
//     }
type PersistentVolumeClaimsGetterMock struct {
	// PersistentVolumeClaimsFunc mocks the PersistentVolumeClaims method.
	PersistentVolumeClaimsFunc func(namespace string) v11.PersistentVolumeClaimInterface

	// calls tracks calls to the methods.
	calls struct {
		// PersistentVolumeClaims holds details about calls to the PersistentVolumeClaims method.
		PersistentVolumeClaims []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// PersistentVolumeClaims calls PersistentVolumeClaimsFunc.
func (mock *PersistentVolumeClaimsGetterMock) PersistentVolumeClaims(namespace string) v11.PersistentVolumeClaimInterface {
	if mock.PersistentVolumeClaimsFunc == nil {
		panic("PersistentVolumeClaimsGetterMock.PersistentVolumeClaimsFunc: method is nil but PersistentVolumeClaimsGetter.PersistentVolumeClaims was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockPersistentVolumeClaimsGetterMockPersistentVolumeClaims.Lock()
	mock.calls.PersistentVolumeClaims = append(mock.calls.PersistentVolumeClaims, callInfo)
	lockPersistentVolumeClaimsGetterMockPersistentVolumeClaims.Unlock()
	return mock.PersistentVolumeClaimsFunc(namespace)
}

// PersistentVolumeClaimsCalls gets all the calls that were made to PersistentVolumeClaims.
// Check the length with:
//     len(mockedPersistentVolumeClaimsGetter.PersistentVolumeClaimsCalls())
func (mock *PersistentVolumeClaimsGetterMock) PersistentVolumeClaimsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockPersistentVolumeClaimsGetterMockPersistentVolumeClaims.RLock()
	calls = mock.calls.PersistentVolumeClaims
	lockPersistentVolumeClaimsGetterMockPersistentVolumeClaims.RUnlock()
	return calls
}
