// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v11 "github.com/rancher/rancher/pkg/generated/norman/core/v1"
	v1 "k8s.io/api/core/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockReplicationControllerListerMockGet  sync.RWMutex
	lockReplicationControllerListerMockList sync.RWMutex
)

// Ensure, that ReplicationControllerListerMock does implement v11.ReplicationControllerLister.
// If this is not the case, regenerate this file with moq.
var _ v11.ReplicationControllerLister = &ReplicationControllerListerMock{}

// ReplicationControllerListerMock is a mock implementation of v11.ReplicationControllerLister.
//
//     func TestSomethingThatUsesReplicationControllerLister(t *testing.T) {
//
//         // make and configure a mocked v11.ReplicationControllerLister
//         mockedReplicationControllerLister := &ReplicationControllerListerMock{
//             GetFunc: func(namespace string, name string) (*v1.ReplicationController, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v1.ReplicationController, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedReplicationControllerLister in code that requires v11.ReplicationControllerLister
//         // and then make assertions.
//
//     }
type ReplicationControllerListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v1.ReplicationController, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v1.ReplicationController, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *ReplicationControllerListerMock) Get(namespace string, name string) (*v1.ReplicationController, error) {
	if mock.GetFunc == nil {
		panic("ReplicationControllerListerMock.GetFunc: method is nil but ReplicationControllerLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockReplicationControllerListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockReplicationControllerListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedReplicationControllerLister.GetCalls())
func (mock *ReplicationControllerListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockReplicationControllerListerMockGet.RLock()
	calls = mock.calls.Get
	lockReplicationControllerListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ReplicationControllerListerMock) List(namespace string, selector labels.Selector) ([]*v1.ReplicationController, error) {
	if mock.ListFunc == nil {
		panic("ReplicationControllerListerMock.ListFunc: method is nil but ReplicationControllerLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockReplicationControllerListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockReplicationControllerListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedReplicationControllerLister.ListCalls())
func (mock *ReplicationControllerListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockReplicationControllerListerMockList.RLock()
	calls = mock.calls.List
	lockReplicationControllerListerMockList.RUnlock()
	return calls
}

var (
	lockReplicationControllerControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockReplicationControllerControllerMockAddClusterScopedHandler        sync.RWMutex
	lockReplicationControllerControllerMockAddFeatureHandler              sync.RWMutex
	lockReplicationControllerControllerMockAddHandler                     sync.RWMutex
	lockReplicationControllerControllerMockEnqueue                        sync.RWMutex
	lockReplicationControllerControllerMockEnqueueAfter                   sync.RWMutex
	lockReplicationControllerControllerMockGeneric                        sync.RWMutex
	lockReplicationControllerControllerMockInformer                       sync.RWMutex
	lockReplicationControllerControllerMockLister                         sync.RWMutex
)

// Ensure, that ReplicationControllerControllerMock does implement v11.ReplicationControllerController.
// If this is not the case, regenerate this file with moq.
var _ v11.ReplicationControllerController = &ReplicationControllerControllerMock{}

// ReplicationControllerControllerMock is a mock implementation of v11.ReplicationControllerController.
//
//     func TestSomethingThatUsesReplicationControllerController(t *testing.T) {
//
//         // make and configure a mocked v11.ReplicationControllerController
//         mockedReplicationControllerController := &ReplicationControllerControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.ReplicationControllerHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v11.ReplicationControllerHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ReplicationControllerHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v11.ReplicationControllerHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v11.ReplicationControllerLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedReplicationControllerController in code that requires v11.ReplicationControllerController
//         // and then make assertions.
//
//     }
type ReplicationControllerControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.ReplicationControllerHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v11.ReplicationControllerHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ReplicationControllerHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v11.ReplicationControllerHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v11.ReplicationControllerLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.ReplicationControllerHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.ReplicationControllerHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.ReplicationControllerHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v11.ReplicationControllerHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ReplicationControllerControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.ReplicationControllerHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ReplicationControllerControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but ReplicationControllerController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.ReplicationControllerHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockReplicationControllerControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockReplicationControllerControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedReplicationControllerController.AddClusterScopedFeatureHandlerCalls())
func (mock *ReplicationControllerControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v11.ReplicationControllerHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.ReplicationControllerHandlerFunc
	}
	lockReplicationControllerControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockReplicationControllerControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ReplicationControllerControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v11.ReplicationControllerHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ReplicationControllerControllerMock.AddClusterScopedHandlerFunc: method is nil but ReplicationControllerController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.ReplicationControllerHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockReplicationControllerControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockReplicationControllerControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedReplicationControllerController.AddClusterScopedHandlerCalls())
func (mock *ReplicationControllerControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v11.ReplicationControllerHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.ReplicationControllerHandlerFunc
	}
	lockReplicationControllerControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockReplicationControllerControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ReplicationControllerControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ReplicationControllerHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ReplicationControllerControllerMock.AddFeatureHandlerFunc: method is nil but ReplicationControllerController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ReplicationControllerHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockReplicationControllerControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockReplicationControllerControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedReplicationControllerController.AddFeatureHandlerCalls())
func (mock *ReplicationControllerControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.ReplicationControllerHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ReplicationControllerHandlerFunc
	}
	lockReplicationControllerControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockReplicationControllerControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ReplicationControllerControllerMock) AddHandler(ctx context.Context, name string, handler v11.ReplicationControllerHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ReplicationControllerControllerMock.AddHandlerFunc: method is nil but ReplicationControllerController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v11.ReplicationControllerHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockReplicationControllerControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockReplicationControllerControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedReplicationControllerController.AddHandlerCalls())
func (mock *ReplicationControllerControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v11.ReplicationControllerHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v11.ReplicationControllerHandlerFunc
	}
	lockReplicationControllerControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockReplicationControllerControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *ReplicationControllerControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("ReplicationControllerControllerMock.EnqueueFunc: method is nil but ReplicationControllerController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockReplicationControllerControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockReplicationControllerControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedReplicationControllerController.EnqueueCalls())
func (mock *ReplicationControllerControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockReplicationControllerControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockReplicationControllerControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *ReplicationControllerControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("ReplicationControllerControllerMock.EnqueueAfterFunc: method is nil but ReplicationControllerController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockReplicationControllerControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockReplicationControllerControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedReplicationControllerController.EnqueueAfterCalls())
func (mock *ReplicationControllerControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockReplicationControllerControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockReplicationControllerControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *ReplicationControllerControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("ReplicationControllerControllerMock.GenericFunc: method is nil but ReplicationControllerController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockReplicationControllerControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockReplicationControllerControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedReplicationControllerController.GenericCalls())
func (mock *ReplicationControllerControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockReplicationControllerControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockReplicationControllerControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *ReplicationControllerControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("ReplicationControllerControllerMock.InformerFunc: method is nil but ReplicationControllerController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockReplicationControllerControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockReplicationControllerControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedReplicationControllerController.InformerCalls())
func (mock *ReplicationControllerControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockReplicationControllerControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockReplicationControllerControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *ReplicationControllerControllerMock) Lister() v11.ReplicationControllerLister {
	if mock.ListerFunc == nil {
		panic("ReplicationControllerControllerMock.ListerFunc: method is nil but ReplicationControllerController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockReplicationControllerControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockReplicationControllerControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedReplicationControllerController.ListerCalls())
func (mock *ReplicationControllerControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockReplicationControllerControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockReplicationControllerControllerMockLister.RUnlock()
	return calls
}

var (
	lockReplicationControllerInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockReplicationControllerInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockReplicationControllerInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockReplicationControllerInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockReplicationControllerInterfaceMockAddFeatureHandler                sync.RWMutex
	lockReplicationControllerInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockReplicationControllerInterfaceMockAddHandler                       sync.RWMutex
	lockReplicationControllerInterfaceMockAddLifecycle                     sync.RWMutex
	lockReplicationControllerInterfaceMockController                       sync.RWMutex
	lockReplicationControllerInterfaceMockCreate                           sync.RWMutex
	lockReplicationControllerInterfaceMockDelete                           sync.RWMutex
	lockReplicationControllerInterfaceMockDeleteCollection                 sync.RWMutex
	lockReplicationControllerInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockReplicationControllerInterfaceMockGet                              sync.RWMutex
	lockReplicationControllerInterfaceMockGetNamespaced                    sync.RWMutex
	lockReplicationControllerInterfaceMockList                             sync.RWMutex
	lockReplicationControllerInterfaceMockListNamespaced                   sync.RWMutex
	lockReplicationControllerInterfaceMockObjectClient                     sync.RWMutex
	lockReplicationControllerInterfaceMockUpdate                           sync.RWMutex
	lockReplicationControllerInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that ReplicationControllerInterfaceMock does implement v11.ReplicationControllerInterface.
// If this is not the case, regenerate this file with moq.
var _ v11.ReplicationControllerInterface = &ReplicationControllerInterfaceMock{}

// ReplicationControllerInterfaceMock is a mock implementation of v11.ReplicationControllerInterface.
//
//     func TestSomethingThatUsesReplicationControllerInterface(t *testing.T) {
//
//         // make and configure a mocked v11.ReplicationControllerInterface
//         mockedReplicationControllerInterface := &ReplicationControllerInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.ReplicationControllerHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.ReplicationControllerLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v11.ReplicationControllerHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v11.ReplicationControllerLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ReplicationControllerHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v11.ReplicationControllerLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v11.ReplicationControllerHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v11.ReplicationControllerLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v11.ReplicationControllerController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v1.ReplicationController) (*v1.ReplicationController, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v1.ReplicationController, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v1.ReplicationController, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v1.ReplicationControllerList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v1.ReplicationControllerList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v1.ReplicationController) (*v1.ReplicationController, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedReplicationControllerInterface in code that requires v11.ReplicationControllerInterface
//         // and then make assertions.
//
//     }
type ReplicationControllerInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.ReplicationControllerHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.ReplicationControllerLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v11.ReplicationControllerHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v11.ReplicationControllerLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ReplicationControllerHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v11.ReplicationControllerLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v11.ReplicationControllerHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v11.ReplicationControllerLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v11.ReplicationControllerController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v1.ReplicationController) (*v1.ReplicationController, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v1.ReplicationController, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v1.ReplicationController, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v1.ReplicationControllerList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v1.ReplicationControllerList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v1.ReplicationController) (*v1.ReplicationController, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.ReplicationControllerHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ReplicationControllerLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.ReplicationControllerHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ReplicationControllerLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.ReplicationControllerHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ReplicationControllerLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.ReplicationControllerHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.ReplicationControllerLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v1.ReplicationController
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v1.ReplicationController
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ReplicationControllerInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.ReplicationControllerHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ReplicationControllerInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but ReplicationControllerInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.ReplicationControllerHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockReplicationControllerInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockReplicationControllerInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedReplicationControllerInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *ReplicationControllerInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v11.ReplicationControllerHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.ReplicationControllerHandlerFunc
	}
	lockReplicationControllerInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockReplicationControllerInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *ReplicationControllerInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.ReplicationControllerLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("ReplicationControllerInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but ReplicationControllerInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.ReplicationControllerLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockReplicationControllerInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockReplicationControllerInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedReplicationControllerInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *ReplicationControllerInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v11.ReplicationControllerLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.ReplicationControllerLifecycle
	}
	lockReplicationControllerInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockReplicationControllerInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ReplicationControllerInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v11.ReplicationControllerHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ReplicationControllerInterfaceMock.AddClusterScopedHandlerFunc: method is nil but ReplicationControllerInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.ReplicationControllerHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockReplicationControllerInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockReplicationControllerInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedReplicationControllerInterface.AddClusterScopedHandlerCalls())
func (mock *ReplicationControllerInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v11.ReplicationControllerHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.ReplicationControllerHandlerFunc
	}
	lockReplicationControllerInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockReplicationControllerInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *ReplicationControllerInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v11.ReplicationControllerLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("ReplicationControllerInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but ReplicationControllerInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.ReplicationControllerLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockReplicationControllerInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockReplicationControllerInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedReplicationControllerInterface.AddClusterScopedLifecycleCalls())
func (mock *ReplicationControllerInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v11.ReplicationControllerLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.ReplicationControllerLifecycle
	}
	lockReplicationControllerInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockReplicationControllerInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ReplicationControllerInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.ReplicationControllerHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ReplicationControllerInterfaceMock.AddFeatureHandlerFunc: method is nil but ReplicationControllerInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ReplicationControllerHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockReplicationControllerInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockReplicationControllerInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedReplicationControllerInterface.AddFeatureHandlerCalls())
func (mock *ReplicationControllerInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.ReplicationControllerHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.ReplicationControllerHandlerFunc
	}
	lockReplicationControllerInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockReplicationControllerInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *ReplicationControllerInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v11.ReplicationControllerLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("ReplicationControllerInterfaceMock.AddFeatureLifecycleFunc: method is nil but ReplicationControllerInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.ReplicationControllerLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockReplicationControllerInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockReplicationControllerInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedReplicationControllerInterface.AddFeatureLifecycleCalls())
func (mock *ReplicationControllerInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v11.ReplicationControllerLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.ReplicationControllerLifecycle
	}
	lockReplicationControllerInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockReplicationControllerInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ReplicationControllerInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v11.ReplicationControllerHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ReplicationControllerInterfaceMock.AddHandlerFunc: method is nil but ReplicationControllerInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v11.ReplicationControllerHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockReplicationControllerInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockReplicationControllerInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedReplicationControllerInterface.AddHandlerCalls())
func (mock *ReplicationControllerInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v11.ReplicationControllerHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v11.ReplicationControllerHandlerFunc
	}
	lockReplicationControllerInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockReplicationControllerInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *ReplicationControllerInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v11.ReplicationControllerLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("ReplicationControllerInterfaceMock.AddLifecycleFunc: method is nil but ReplicationControllerInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.ReplicationControllerLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockReplicationControllerInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockReplicationControllerInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedReplicationControllerInterface.AddLifecycleCalls())
func (mock *ReplicationControllerInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v11.ReplicationControllerLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.ReplicationControllerLifecycle
	}
	lockReplicationControllerInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockReplicationControllerInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *ReplicationControllerInterfaceMock) Controller() v11.ReplicationControllerController {
	if mock.ControllerFunc == nil {
		panic("ReplicationControllerInterfaceMock.ControllerFunc: method is nil but ReplicationControllerInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockReplicationControllerInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockReplicationControllerInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedReplicationControllerInterface.ControllerCalls())
func (mock *ReplicationControllerInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockReplicationControllerInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockReplicationControllerInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *ReplicationControllerInterfaceMock) Create(in1 *v1.ReplicationController) (*v1.ReplicationController, error) {
	if mock.CreateFunc == nil {
		panic("ReplicationControllerInterfaceMock.CreateFunc: method is nil but ReplicationControllerInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v1.ReplicationController
	}{
		In1: in1,
	}
	lockReplicationControllerInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockReplicationControllerInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedReplicationControllerInterface.CreateCalls())
func (mock *ReplicationControllerInterfaceMock) CreateCalls() []struct {
	In1 *v1.ReplicationController
} {
	var calls []struct {
		In1 *v1.ReplicationController
	}
	lockReplicationControllerInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockReplicationControllerInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *ReplicationControllerInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("ReplicationControllerInterfaceMock.DeleteFunc: method is nil but ReplicationControllerInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockReplicationControllerInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockReplicationControllerInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedReplicationControllerInterface.DeleteCalls())
func (mock *ReplicationControllerInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockReplicationControllerInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockReplicationControllerInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *ReplicationControllerInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("ReplicationControllerInterfaceMock.DeleteCollectionFunc: method is nil but ReplicationControllerInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockReplicationControllerInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockReplicationControllerInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedReplicationControllerInterface.DeleteCollectionCalls())
func (mock *ReplicationControllerInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockReplicationControllerInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockReplicationControllerInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *ReplicationControllerInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("ReplicationControllerInterfaceMock.DeleteNamespacedFunc: method is nil but ReplicationControllerInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockReplicationControllerInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockReplicationControllerInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedReplicationControllerInterface.DeleteNamespacedCalls())
func (mock *ReplicationControllerInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockReplicationControllerInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockReplicationControllerInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *ReplicationControllerInterfaceMock) Get(name string, opts metav1.GetOptions) (*v1.ReplicationController, error) {
	if mock.GetFunc == nil {
		panic("ReplicationControllerInterfaceMock.GetFunc: method is nil but ReplicationControllerInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockReplicationControllerInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockReplicationControllerInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedReplicationControllerInterface.GetCalls())
func (mock *ReplicationControllerInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockReplicationControllerInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockReplicationControllerInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *ReplicationControllerInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v1.ReplicationController, error) {
	if mock.GetNamespacedFunc == nil {
		panic("ReplicationControllerInterfaceMock.GetNamespacedFunc: method is nil but ReplicationControllerInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockReplicationControllerInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockReplicationControllerInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedReplicationControllerInterface.GetNamespacedCalls())
func (mock *ReplicationControllerInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockReplicationControllerInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockReplicationControllerInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ReplicationControllerInterfaceMock) List(opts metav1.ListOptions) (*v1.ReplicationControllerList, error) {
	if mock.ListFunc == nil {
		panic("ReplicationControllerInterfaceMock.ListFunc: method is nil but ReplicationControllerInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockReplicationControllerInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockReplicationControllerInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedReplicationControllerInterface.ListCalls())
func (mock *ReplicationControllerInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockReplicationControllerInterfaceMockList.RLock()
	calls = mock.calls.List
	lockReplicationControllerInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *ReplicationControllerInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v1.ReplicationControllerList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("ReplicationControllerInterfaceMock.ListNamespacedFunc: method is nil but ReplicationControllerInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockReplicationControllerInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockReplicationControllerInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedReplicationControllerInterface.ListNamespacedCalls())
func (mock *ReplicationControllerInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockReplicationControllerInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockReplicationControllerInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *ReplicationControllerInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("ReplicationControllerInterfaceMock.ObjectClientFunc: method is nil but ReplicationControllerInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockReplicationControllerInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockReplicationControllerInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedReplicationControllerInterface.ObjectClientCalls())
func (mock *ReplicationControllerInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockReplicationControllerInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockReplicationControllerInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *ReplicationControllerInterfaceMock) Update(in1 *v1.ReplicationController) (*v1.ReplicationController, error) {
	if mock.UpdateFunc == nil {
		panic("ReplicationControllerInterfaceMock.UpdateFunc: method is nil but ReplicationControllerInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v1.ReplicationController
	}{
		In1: in1,
	}
	lockReplicationControllerInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockReplicationControllerInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedReplicationControllerInterface.UpdateCalls())
func (mock *ReplicationControllerInterfaceMock) UpdateCalls() []struct {
	In1 *v1.ReplicationController
} {
	var calls []struct {
		In1 *v1.ReplicationController
	}
	lockReplicationControllerInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockReplicationControllerInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *ReplicationControllerInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("ReplicationControllerInterfaceMock.WatchFunc: method is nil but ReplicationControllerInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockReplicationControllerInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockReplicationControllerInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedReplicationControllerInterface.WatchCalls())
func (mock *ReplicationControllerInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockReplicationControllerInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockReplicationControllerInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockReplicationControllersGetterMockReplicationControllers sync.RWMutex
)

// Ensure, that ReplicationControllersGetterMock does implement v11.ReplicationControllersGetter.
// If this is not the case, regenerate this file with moq.
var _ v11.ReplicationControllersGetter = &ReplicationControllersGetterMock{}

// ReplicationControllersGetterMock is a mock implementation of v11.ReplicationControllersGetter.
//
//     func TestSomethingThatUsesReplicationControllersGetter(t *testing.T) {
//
//         // make and configure a mocked v11.ReplicationControllersGetter
//         mockedReplicationControllersGetter := &ReplicationControllersGetterMock{
//             ReplicationControllersFunc: func(namespace string) v11.ReplicationControllerInterface {
// 	               panic("mock out the ReplicationControllers method")
//             },
//         }
//
//         // use mockedReplicationControllersGetter in code that requires v11.ReplicationControllersGetter
//         // and then make assertions.
//
//     }
type ReplicationControllersGetterMock struct {
	// ReplicationControllersFunc mocks the ReplicationControllers method.
	ReplicationControllersFunc func(namespace string) v11.ReplicationControllerInterface

	// calls tracks calls to the methods.
	calls struct {
		// ReplicationControllers holds details about calls to the ReplicationControllers method.
		ReplicationControllers []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// ReplicationControllers calls ReplicationControllersFunc.
func (mock *ReplicationControllersGetterMock) ReplicationControllers(namespace string) v11.ReplicationControllerInterface {
	if mock.ReplicationControllersFunc == nil {
		panic("ReplicationControllersGetterMock.ReplicationControllersFunc: method is nil but ReplicationControllersGetter.ReplicationControllers was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockReplicationControllersGetterMockReplicationControllers.Lock()
	mock.calls.ReplicationControllers = append(mock.calls.ReplicationControllers, callInfo)
	lockReplicationControllersGetterMockReplicationControllers.Unlock()
	return mock.ReplicationControllersFunc(namespace)
}

// ReplicationControllersCalls gets all the calls that were made to ReplicationControllers.
// Check the length with:
//     len(mockedReplicationControllersGetter.ReplicationControllersCalls())
func (mock *ReplicationControllersGetterMock) ReplicationControllersCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockReplicationControllersGetterMockReplicationControllers.RLock()
	calls = mock.calls.ReplicationControllers
	lockReplicationControllersGetterMockReplicationControllers.RUnlock()
	return calls
}
