// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockAuthConfigListerMockGet  sync.RWMutex
	lockAuthConfigListerMockList sync.RWMutex
)

// Ensure, that AuthConfigListerMock does implement v31.AuthConfigLister.
// If this is not the case, regenerate this file with moq.
var _ v31.AuthConfigLister = &AuthConfigListerMock{}

// AuthConfigListerMock is a mock implementation of v31.AuthConfigLister.
//
//     func TestSomethingThatUsesAuthConfigLister(t *testing.T) {
//
//         // make and configure a mocked v31.AuthConfigLister
//         mockedAuthConfigLister := &AuthConfigListerMock{
//             GetFunc: func(namespace string, name string) (*v3.AuthConfig, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.AuthConfig, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedAuthConfigLister in code that requires v31.AuthConfigLister
//         // and then make assertions.
//
//     }
type AuthConfigListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.AuthConfig, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.AuthConfig, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *AuthConfigListerMock) Get(namespace string, name string) (*v3.AuthConfig, error) {
	if mock.GetFunc == nil {
		panic("AuthConfigListerMock.GetFunc: method is nil but AuthConfigLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockAuthConfigListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockAuthConfigListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedAuthConfigLister.GetCalls())
func (mock *AuthConfigListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockAuthConfigListerMockGet.RLock()
	calls = mock.calls.Get
	lockAuthConfigListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *AuthConfigListerMock) List(namespace string, selector labels.Selector) ([]*v3.AuthConfig, error) {
	if mock.ListFunc == nil {
		panic("AuthConfigListerMock.ListFunc: method is nil but AuthConfigLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockAuthConfigListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockAuthConfigListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedAuthConfigLister.ListCalls())
func (mock *AuthConfigListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockAuthConfigListerMockList.RLock()
	calls = mock.calls.List
	lockAuthConfigListerMockList.RUnlock()
	return calls
}

var (
	lockAuthConfigControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockAuthConfigControllerMockAddClusterScopedHandler        sync.RWMutex
	lockAuthConfigControllerMockAddFeatureHandler              sync.RWMutex
	lockAuthConfigControllerMockAddHandler                     sync.RWMutex
	lockAuthConfigControllerMockEnqueue                        sync.RWMutex
	lockAuthConfigControllerMockEnqueueAfter                   sync.RWMutex
	lockAuthConfigControllerMockGeneric                        sync.RWMutex
	lockAuthConfigControllerMockInformer                       sync.RWMutex
	lockAuthConfigControllerMockLister                         sync.RWMutex
)

// Ensure, that AuthConfigControllerMock does implement v31.AuthConfigController.
// If this is not the case, regenerate this file with moq.
var _ v31.AuthConfigController = &AuthConfigControllerMock{}

// AuthConfigControllerMock is a mock implementation of v31.AuthConfigController.
//
//     func TestSomethingThatUsesAuthConfigController(t *testing.T) {
//
//         // make and configure a mocked v31.AuthConfigController
//         mockedAuthConfigController := &AuthConfigControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.AuthConfigHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.AuthConfigHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.AuthConfigHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.AuthConfigHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.AuthConfigLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedAuthConfigController in code that requires v31.AuthConfigController
//         // and then make assertions.
//
//     }
type AuthConfigControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.AuthConfigHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.AuthConfigHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.AuthConfigHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.AuthConfigHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.AuthConfigLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.AuthConfigHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.AuthConfigHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.AuthConfigHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.AuthConfigHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *AuthConfigControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.AuthConfigHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("AuthConfigControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but AuthConfigController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.AuthConfigHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockAuthConfigControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockAuthConfigControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedAuthConfigController.AddClusterScopedFeatureHandlerCalls())
func (mock *AuthConfigControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.AuthConfigHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.AuthConfigHandlerFunc
	}
	lockAuthConfigControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockAuthConfigControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *AuthConfigControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.AuthConfigHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("AuthConfigControllerMock.AddClusterScopedHandlerFunc: method is nil but AuthConfigController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.AuthConfigHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockAuthConfigControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockAuthConfigControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedAuthConfigController.AddClusterScopedHandlerCalls())
func (mock *AuthConfigControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.AuthConfigHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.AuthConfigHandlerFunc
	}
	lockAuthConfigControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockAuthConfigControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *AuthConfigControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.AuthConfigHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("AuthConfigControllerMock.AddFeatureHandlerFunc: method is nil but AuthConfigController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.AuthConfigHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockAuthConfigControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockAuthConfigControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedAuthConfigController.AddFeatureHandlerCalls())
func (mock *AuthConfigControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.AuthConfigHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.AuthConfigHandlerFunc
	}
	lockAuthConfigControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockAuthConfigControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *AuthConfigControllerMock) AddHandler(ctx context.Context, name string, handler v31.AuthConfigHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("AuthConfigControllerMock.AddHandlerFunc: method is nil but AuthConfigController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.AuthConfigHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockAuthConfigControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockAuthConfigControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedAuthConfigController.AddHandlerCalls())
func (mock *AuthConfigControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.AuthConfigHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.AuthConfigHandlerFunc
	}
	lockAuthConfigControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockAuthConfigControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *AuthConfigControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("AuthConfigControllerMock.EnqueueFunc: method is nil but AuthConfigController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockAuthConfigControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockAuthConfigControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedAuthConfigController.EnqueueCalls())
func (mock *AuthConfigControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockAuthConfigControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockAuthConfigControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *AuthConfigControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("AuthConfigControllerMock.EnqueueAfterFunc: method is nil but AuthConfigController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockAuthConfigControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockAuthConfigControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedAuthConfigController.EnqueueAfterCalls())
func (mock *AuthConfigControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockAuthConfigControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockAuthConfigControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *AuthConfigControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("AuthConfigControllerMock.GenericFunc: method is nil but AuthConfigController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockAuthConfigControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockAuthConfigControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedAuthConfigController.GenericCalls())
func (mock *AuthConfigControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockAuthConfigControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockAuthConfigControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *AuthConfigControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("AuthConfigControllerMock.InformerFunc: method is nil but AuthConfigController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockAuthConfigControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockAuthConfigControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedAuthConfigController.InformerCalls())
func (mock *AuthConfigControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockAuthConfigControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockAuthConfigControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *AuthConfigControllerMock) Lister() v31.AuthConfigLister {
	if mock.ListerFunc == nil {
		panic("AuthConfigControllerMock.ListerFunc: method is nil but AuthConfigController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockAuthConfigControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockAuthConfigControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedAuthConfigController.ListerCalls())
func (mock *AuthConfigControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockAuthConfigControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockAuthConfigControllerMockLister.RUnlock()
	return calls
}

var (
	lockAuthConfigInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockAuthConfigInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockAuthConfigInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockAuthConfigInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockAuthConfigInterfaceMockAddFeatureHandler                sync.RWMutex
	lockAuthConfigInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockAuthConfigInterfaceMockAddHandler                       sync.RWMutex
	lockAuthConfigInterfaceMockAddLifecycle                     sync.RWMutex
	lockAuthConfigInterfaceMockController                       sync.RWMutex
	lockAuthConfigInterfaceMockCreate                           sync.RWMutex
	lockAuthConfigInterfaceMockDelete                           sync.RWMutex
	lockAuthConfigInterfaceMockDeleteCollection                 sync.RWMutex
	lockAuthConfigInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockAuthConfigInterfaceMockGet                              sync.RWMutex
	lockAuthConfigInterfaceMockGetNamespaced                    sync.RWMutex
	lockAuthConfigInterfaceMockList                             sync.RWMutex
	lockAuthConfigInterfaceMockListNamespaced                   sync.RWMutex
	lockAuthConfigInterfaceMockObjectClient                     sync.RWMutex
	lockAuthConfigInterfaceMockUpdate                           sync.RWMutex
	lockAuthConfigInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that AuthConfigInterfaceMock does implement v31.AuthConfigInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.AuthConfigInterface = &AuthConfigInterfaceMock{}

// AuthConfigInterfaceMock is a mock implementation of v31.AuthConfigInterface.
//
//     func TestSomethingThatUsesAuthConfigInterface(t *testing.T) {
//
//         // make and configure a mocked v31.AuthConfigInterface
//         mockedAuthConfigInterface := &AuthConfigInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.AuthConfigHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.AuthConfigLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.AuthConfigHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.AuthConfigLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.AuthConfigHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.AuthConfigLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.AuthConfigHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.AuthConfigLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.AuthConfigController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.AuthConfig) (*v3.AuthConfig, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.AuthConfig, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.AuthConfig, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.AuthConfigList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.AuthConfigList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.AuthConfig) (*v3.AuthConfig, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedAuthConfigInterface in code that requires v31.AuthConfigInterface
//         // and then make assertions.
//
//     }
type AuthConfigInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.AuthConfigHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.AuthConfigLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.AuthConfigHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.AuthConfigLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.AuthConfigHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.AuthConfigLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.AuthConfigHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.AuthConfigLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.AuthConfigController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.AuthConfig) (*v3.AuthConfig, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.AuthConfig, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.AuthConfig, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.AuthConfigList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.AuthConfigList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.AuthConfig) (*v3.AuthConfig, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.AuthConfigHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.AuthConfigLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.AuthConfigHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.AuthConfigLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.AuthConfigHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.AuthConfigLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.AuthConfigHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.AuthConfigLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.AuthConfig
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.AuthConfig
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *AuthConfigInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.AuthConfigHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("AuthConfigInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but AuthConfigInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.AuthConfigHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockAuthConfigInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockAuthConfigInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedAuthConfigInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *AuthConfigInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.AuthConfigHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.AuthConfigHandlerFunc
	}
	lockAuthConfigInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockAuthConfigInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *AuthConfigInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.AuthConfigLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("AuthConfigInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but AuthConfigInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.AuthConfigLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockAuthConfigInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockAuthConfigInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedAuthConfigInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *AuthConfigInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.AuthConfigLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.AuthConfigLifecycle
	}
	lockAuthConfigInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockAuthConfigInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *AuthConfigInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.AuthConfigHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("AuthConfigInterfaceMock.AddClusterScopedHandlerFunc: method is nil but AuthConfigInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.AuthConfigHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockAuthConfigInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockAuthConfigInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedAuthConfigInterface.AddClusterScopedHandlerCalls())
func (mock *AuthConfigInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.AuthConfigHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.AuthConfigHandlerFunc
	}
	lockAuthConfigInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockAuthConfigInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *AuthConfigInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.AuthConfigLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("AuthConfigInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but AuthConfigInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.AuthConfigLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockAuthConfigInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockAuthConfigInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedAuthConfigInterface.AddClusterScopedLifecycleCalls())
func (mock *AuthConfigInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.AuthConfigLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.AuthConfigLifecycle
	}
	lockAuthConfigInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockAuthConfigInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *AuthConfigInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.AuthConfigHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("AuthConfigInterfaceMock.AddFeatureHandlerFunc: method is nil but AuthConfigInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.AuthConfigHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockAuthConfigInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockAuthConfigInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedAuthConfigInterface.AddFeatureHandlerCalls())
func (mock *AuthConfigInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.AuthConfigHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.AuthConfigHandlerFunc
	}
	lockAuthConfigInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockAuthConfigInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *AuthConfigInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.AuthConfigLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("AuthConfigInterfaceMock.AddFeatureLifecycleFunc: method is nil but AuthConfigInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.AuthConfigLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockAuthConfigInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockAuthConfigInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedAuthConfigInterface.AddFeatureLifecycleCalls())
func (mock *AuthConfigInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.AuthConfigLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.AuthConfigLifecycle
	}
	lockAuthConfigInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockAuthConfigInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *AuthConfigInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.AuthConfigHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("AuthConfigInterfaceMock.AddHandlerFunc: method is nil but AuthConfigInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.AuthConfigHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockAuthConfigInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockAuthConfigInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedAuthConfigInterface.AddHandlerCalls())
func (mock *AuthConfigInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.AuthConfigHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.AuthConfigHandlerFunc
	}
	lockAuthConfigInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockAuthConfigInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *AuthConfigInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.AuthConfigLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("AuthConfigInterfaceMock.AddLifecycleFunc: method is nil but AuthConfigInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.AuthConfigLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockAuthConfigInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockAuthConfigInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedAuthConfigInterface.AddLifecycleCalls())
func (mock *AuthConfigInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.AuthConfigLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.AuthConfigLifecycle
	}
	lockAuthConfigInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockAuthConfigInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *AuthConfigInterfaceMock) Controller() v31.AuthConfigController {
	if mock.ControllerFunc == nil {
		panic("AuthConfigInterfaceMock.ControllerFunc: method is nil but AuthConfigInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockAuthConfigInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockAuthConfigInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedAuthConfigInterface.ControllerCalls())
func (mock *AuthConfigInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockAuthConfigInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockAuthConfigInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *AuthConfigInterfaceMock) Create(in1 *v3.AuthConfig) (*v3.AuthConfig, error) {
	if mock.CreateFunc == nil {
		panic("AuthConfigInterfaceMock.CreateFunc: method is nil but AuthConfigInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.AuthConfig
	}{
		In1: in1,
	}
	lockAuthConfigInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockAuthConfigInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedAuthConfigInterface.CreateCalls())
func (mock *AuthConfigInterfaceMock) CreateCalls() []struct {
	In1 *v3.AuthConfig
} {
	var calls []struct {
		In1 *v3.AuthConfig
	}
	lockAuthConfigInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockAuthConfigInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *AuthConfigInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("AuthConfigInterfaceMock.DeleteFunc: method is nil but AuthConfigInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockAuthConfigInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockAuthConfigInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedAuthConfigInterface.DeleteCalls())
func (mock *AuthConfigInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockAuthConfigInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockAuthConfigInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *AuthConfigInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("AuthConfigInterfaceMock.DeleteCollectionFunc: method is nil but AuthConfigInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockAuthConfigInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockAuthConfigInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedAuthConfigInterface.DeleteCollectionCalls())
func (mock *AuthConfigInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockAuthConfigInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockAuthConfigInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *AuthConfigInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("AuthConfigInterfaceMock.DeleteNamespacedFunc: method is nil but AuthConfigInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockAuthConfigInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockAuthConfigInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedAuthConfigInterface.DeleteNamespacedCalls())
func (mock *AuthConfigInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockAuthConfigInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockAuthConfigInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *AuthConfigInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.AuthConfig, error) {
	if mock.GetFunc == nil {
		panic("AuthConfigInterfaceMock.GetFunc: method is nil but AuthConfigInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockAuthConfigInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockAuthConfigInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedAuthConfigInterface.GetCalls())
func (mock *AuthConfigInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockAuthConfigInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockAuthConfigInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *AuthConfigInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.AuthConfig, error) {
	if mock.GetNamespacedFunc == nil {
		panic("AuthConfigInterfaceMock.GetNamespacedFunc: method is nil but AuthConfigInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockAuthConfigInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockAuthConfigInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedAuthConfigInterface.GetNamespacedCalls())
func (mock *AuthConfigInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockAuthConfigInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockAuthConfigInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *AuthConfigInterfaceMock) List(opts metav1.ListOptions) (*v3.AuthConfigList, error) {
	if mock.ListFunc == nil {
		panic("AuthConfigInterfaceMock.ListFunc: method is nil but AuthConfigInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockAuthConfigInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockAuthConfigInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedAuthConfigInterface.ListCalls())
func (mock *AuthConfigInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockAuthConfigInterfaceMockList.RLock()
	calls = mock.calls.List
	lockAuthConfigInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *AuthConfigInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.AuthConfigList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("AuthConfigInterfaceMock.ListNamespacedFunc: method is nil but AuthConfigInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockAuthConfigInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockAuthConfigInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedAuthConfigInterface.ListNamespacedCalls())
func (mock *AuthConfigInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockAuthConfigInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockAuthConfigInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *AuthConfigInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("AuthConfigInterfaceMock.ObjectClientFunc: method is nil but AuthConfigInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockAuthConfigInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockAuthConfigInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedAuthConfigInterface.ObjectClientCalls())
func (mock *AuthConfigInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockAuthConfigInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockAuthConfigInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *AuthConfigInterfaceMock) Update(in1 *v3.AuthConfig) (*v3.AuthConfig, error) {
	if mock.UpdateFunc == nil {
		panic("AuthConfigInterfaceMock.UpdateFunc: method is nil but AuthConfigInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.AuthConfig
	}{
		In1: in1,
	}
	lockAuthConfigInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockAuthConfigInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedAuthConfigInterface.UpdateCalls())
func (mock *AuthConfigInterfaceMock) UpdateCalls() []struct {
	In1 *v3.AuthConfig
} {
	var calls []struct {
		In1 *v3.AuthConfig
	}
	lockAuthConfigInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockAuthConfigInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *AuthConfigInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("AuthConfigInterfaceMock.WatchFunc: method is nil but AuthConfigInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockAuthConfigInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockAuthConfigInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedAuthConfigInterface.WatchCalls())
func (mock *AuthConfigInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockAuthConfigInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockAuthConfigInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockAuthConfigsGetterMockAuthConfigs sync.RWMutex
)

// Ensure, that AuthConfigsGetterMock does implement v31.AuthConfigsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.AuthConfigsGetter = &AuthConfigsGetterMock{}

// AuthConfigsGetterMock is a mock implementation of v31.AuthConfigsGetter.
//
//     func TestSomethingThatUsesAuthConfigsGetter(t *testing.T) {
//
//         // make and configure a mocked v31.AuthConfigsGetter
//         mockedAuthConfigsGetter := &AuthConfigsGetterMock{
//             AuthConfigsFunc: func(namespace string) v31.AuthConfigInterface {
// 	               panic("mock out the AuthConfigs method")
//             },
//         }
//
//         // use mockedAuthConfigsGetter in code that requires v31.AuthConfigsGetter
//         // and then make assertions.
//
//     }
type AuthConfigsGetterMock struct {
	// AuthConfigsFunc mocks the AuthConfigs method.
	AuthConfigsFunc func(namespace string) v31.AuthConfigInterface

	// calls tracks calls to the methods.
	calls struct {
		// AuthConfigs holds details about calls to the AuthConfigs method.
		AuthConfigs []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// AuthConfigs calls AuthConfigsFunc.
func (mock *AuthConfigsGetterMock) AuthConfigs(namespace string) v31.AuthConfigInterface {
	if mock.AuthConfigsFunc == nil {
		panic("AuthConfigsGetterMock.AuthConfigsFunc: method is nil but AuthConfigsGetter.AuthConfigs was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockAuthConfigsGetterMockAuthConfigs.Lock()
	mock.calls.AuthConfigs = append(mock.calls.AuthConfigs, callInfo)
	lockAuthConfigsGetterMockAuthConfigs.Unlock()
	return mock.AuthConfigsFunc(namespace)
}

// AuthConfigsCalls gets all the calls that were made to AuthConfigs.
// Check the length with:
//     len(mockedAuthConfigsGetter.AuthConfigsCalls())
func (mock *AuthConfigsGetterMock) AuthConfigsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockAuthConfigsGetterMockAuthConfigs.RLock()
	calls = mock.calls.AuthConfigs
	lockAuthConfigsGetterMockAuthConfigs.RUnlock()
	return calls
}
