// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockCatalogListerMockGet  sync.RWMutex
	lockCatalogListerMockList sync.RWMutex
)

// Ensure, that CatalogListerMock does implement v31.CatalogLister.
// If this is not the case, regenerate this file with moq.
var _ v31.CatalogLister = &CatalogListerMock{}

// CatalogListerMock is a mock implementation of v31.CatalogLister.
//
//     func TestSomethingThatUsesCatalogLister(t *testing.T) {
//
//         // make and configure a mocked v31.CatalogLister
//         mockedCatalogLister := &CatalogListerMock{
//             GetFunc: func(namespace string, name string) (*v3.Catalog, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.Catalog, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedCatalogLister in code that requires v31.CatalogLister
//         // and then make assertions.
//
//     }
type CatalogListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.Catalog, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.Catalog, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *CatalogListerMock) Get(namespace string, name string) (*v3.Catalog, error) {
	if mock.GetFunc == nil {
		panic("CatalogListerMock.GetFunc: method is nil but CatalogLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockCatalogListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockCatalogListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedCatalogLister.GetCalls())
func (mock *CatalogListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockCatalogListerMockGet.RLock()
	calls = mock.calls.Get
	lockCatalogListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *CatalogListerMock) List(namespace string, selector labels.Selector) ([]*v3.Catalog, error) {
	if mock.ListFunc == nil {
		panic("CatalogListerMock.ListFunc: method is nil but CatalogLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockCatalogListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockCatalogListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedCatalogLister.ListCalls())
func (mock *CatalogListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockCatalogListerMockList.RLock()
	calls = mock.calls.List
	lockCatalogListerMockList.RUnlock()
	return calls
}

var (
	lockCatalogControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockCatalogControllerMockAddClusterScopedHandler        sync.RWMutex
	lockCatalogControllerMockAddFeatureHandler              sync.RWMutex
	lockCatalogControllerMockAddHandler                     sync.RWMutex
	lockCatalogControllerMockEnqueue                        sync.RWMutex
	lockCatalogControllerMockEnqueueAfter                   sync.RWMutex
	lockCatalogControllerMockGeneric                        sync.RWMutex
	lockCatalogControllerMockInformer                       sync.RWMutex
	lockCatalogControllerMockLister                         sync.RWMutex
)

// Ensure, that CatalogControllerMock does implement v31.CatalogController.
// If this is not the case, regenerate this file with moq.
var _ v31.CatalogController = &CatalogControllerMock{}

// CatalogControllerMock is a mock implementation of v31.CatalogController.
//
//     func TestSomethingThatUsesCatalogController(t *testing.T) {
//
//         // make and configure a mocked v31.CatalogController
//         mockedCatalogController := &CatalogControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.CatalogHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.CatalogHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CatalogHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.CatalogHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.CatalogLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedCatalogController in code that requires v31.CatalogController
//         // and then make assertions.
//
//     }
type CatalogControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.CatalogHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.CatalogHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CatalogHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.CatalogHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.CatalogLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.CatalogHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.CatalogHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.CatalogHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.CatalogHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *CatalogControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.CatalogHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("CatalogControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but CatalogController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.CatalogHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockCatalogControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockCatalogControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedCatalogController.AddClusterScopedFeatureHandlerCalls())
func (mock *CatalogControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.CatalogHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.CatalogHandlerFunc
	}
	lockCatalogControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockCatalogControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *CatalogControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.CatalogHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("CatalogControllerMock.AddClusterScopedHandlerFunc: method is nil but CatalogController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.CatalogHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockCatalogControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockCatalogControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedCatalogController.AddClusterScopedHandlerCalls())
func (mock *CatalogControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.CatalogHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.CatalogHandlerFunc
	}
	lockCatalogControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockCatalogControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *CatalogControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CatalogHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("CatalogControllerMock.AddFeatureHandlerFunc: method is nil but CatalogController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.CatalogHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockCatalogControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockCatalogControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedCatalogController.AddFeatureHandlerCalls())
func (mock *CatalogControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.CatalogHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.CatalogHandlerFunc
	}
	lockCatalogControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockCatalogControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *CatalogControllerMock) AddHandler(ctx context.Context, name string, handler v31.CatalogHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("CatalogControllerMock.AddHandlerFunc: method is nil but CatalogController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.CatalogHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockCatalogControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockCatalogControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedCatalogController.AddHandlerCalls())
func (mock *CatalogControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.CatalogHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.CatalogHandlerFunc
	}
	lockCatalogControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockCatalogControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *CatalogControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("CatalogControllerMock.EnqueueFunc: method is nil but CatalogController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockCatalogControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockCatalogControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedCatalogController.EnqueueCalls())
func (mock *CatalogControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockCatalogControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockCatalogControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *CatalogControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("CatalogControllerMock.EnqueueAfterFunc: method is nil but CatalogController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockCatalogControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockCatalogControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedCatalogController.EnqueueAfterCalls())
func (mock *CatalogControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockCatalogControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockCatalogControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *CatalogControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("CatalogControllerMock.GenericFunc: method is nil but CatalogController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockCatalogControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockCatalogControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedCatalogController.GenericCalls())
func (mock *CatalogControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockCatalogControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockCatalogControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *CatalogControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("CatalogControllerMock.InformerFunc: method is nil but CatalogController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockCatalogControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockCatalogControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedCatalogController.InformerCalls())
func (mock *CatalogControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockCatalogControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockCatalogControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *CatalogControllerMock) Lister() v31.CatalogLister {
	if mock.ListerFunc == nil {
		panic("CatalogControllerMock.ListerFunc: method is nil but CatalogController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockCatalogControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockCatalogControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedCatalogController.ListerCalls())
func (mock *CatalogControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockCatalogControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockCatalogControllerMockLister.RUnlock()
	return calls
}

var (
	lockCatalogInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockCatalogInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockCatalogInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockCatalogInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockCatalogInterfaceMockAddFeatureHandler                sync.RWMutex
	lockCatalogInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockCatalogInterfaceMockAddHandler                       sync.RWMutex
	lockCatalogInterfaceMockAddLifecycle                     sync.RWMutex
	lockCatalogInterfaceMockController                       sync.RWMutex
	lockCatalogInterfaceMockCreate                           sync.RWMutex
	lockCatalogInterfaceMockDelete                           sync.RWMutex
	lockCatalogInterfaceMockDeleteCollection                 sync.RWMutex
	lockCatalogInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockCatalogInterfaceMockGet                              sync.RWMutex
	lockCatalogInterfaceMockGetNamespaced                    sync.RWMutex
	lockCatalogInterfaceMockList                             sync.RWMutex
	lockCatalogInterfaceMockListNamespaced                   sync.RWMutex
	lockCatalogInterfaceMockObjectClient                     sync.RWMutex
	lockCatalogInterfaceMockUpdate                           sync.RWMutex
	lockCatalogInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that CatalogInterfaceMock does implement v31.CatalogInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.CatalogInterface = &CatalogInterfaceMock{}

// CatalogInterfaceMock is a mock implementation of v31.CatalogInterface.
//
//     func TestSomethingThatUsesCatalogInterface(t *testing.T) {
//
//         // make and configure a mocked v31.CatalogInterface
//         mockedCatalogInterface := &CatalogInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.CatalogHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.CatalogLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.CatalogHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.CatalogLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CatalogHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.CatalogLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.CatalogHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.CatalogLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.CatalogController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.Catalog) (*v3.Catalog, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.Catalog, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.Catalog, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.CatalogList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.CatalogList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.Catalog) (*v3.Catalog, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedCatalogInterface in code that requires v31.CatalogInterface
//         // and then make assertions.
//
//     }
type CatalogInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.CatalogHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.CatalogLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.CatalogHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.CatalogLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CatalogHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.CatalogLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.CatalogHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.CatalogLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.CatalogController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.Catalog) (*v3.Catalog, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.Catalog, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.Catalog, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.CatalogList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.CatalogList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.Catalog) (*v3.Catalog, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.CatalogHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.CatalogLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.CatalogHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.CatalogLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.CatalogHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.CatalogLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.CatalogHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.CatalogLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.Catalog
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.Catalog
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *CatalogInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.CatalogHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("CatalogInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but CatalogInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.CatalogHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockCatalogInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockCatalogInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedCatalogInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *CatalogInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.CatalogHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.CatalogHandlerFunc
	}
	lockCatalogInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockCatalogInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *CatalogInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.CatalogLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("CatalogInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but CatalogInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.CatalogLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockCatalogInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockCatalogInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedCatalogInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *CatalogInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.CatalogLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.CatalogLifecycle
	}
	lockCatalogInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockCatalogInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *CatalogInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.CatalogHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("CatalogInterfaceMock.AddClusterScopedHandlerFunc: method is nil but CatalogInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.CatalogHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockCatalogInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockCatalogInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedCatalogInterface.AddClusterScopedHandlerCalls())
func (mock *CatalogInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.CatalogHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.CatalogHandlerFunc
	}
	lockCatalogInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockCatalogInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *CatalogInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.CatalogLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("CatalogInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but CatalogInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.CatalogLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockCatalogInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockCatalogInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedCatalogInterface.AddClusterScopedLifecycleCalls())
func (mock *CatalogInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.CatalogLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.CatalogLifecycle
	}
	lockCatalogInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockCatalogInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *CatalogInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CatalogHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("CatalogInterfaceMock.AddFeatureHandlerFunc: method is nil but CatalogInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.CatalogHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockCatalogInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockCatalogInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedCatalogInterface.AddFeatureHandlerCalls())
func (mock *CatalogInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.CatalogHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.CatalogHandlerFunc
	}
	lockCatalogInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockCatalogInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *CatalogInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.CatalogLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("CatalogInterfaceMock.AddFeatureLifecycleFunc: method is nil but CatalogInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.CatalogLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockCatalogInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockCatalogInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedCatalogInterface.AddFeatureLifecycleCalls())
func (mock *CatalogInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.CatalogLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.CatalogLifecycle
	}
	lockCatalogInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockCatalogInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *CatalogInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.CatalogHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("CatalogInterfaceMock.AddHandlerFunc: method is nil but CatalogInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.CatalogHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockCatalogInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockCatalogInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedCatalogInterface.AddHandlerCalls())
func (mock *CatalogInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.CatalogHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.CatalogHandlerFunc
	}
	lockCatalogInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockCatalogInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *CatalogInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.CatalogLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("CatalogInterfaceMock.AddLifecycleFunc: method is nil but CatalogInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.CatalogLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockCatalogInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockCatalogInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedCatalogInterface.AddLifecycleCalls())
func (mock *CatalogInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.CatalogLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.CatalogLifecycle
	}
	lockCatalogInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockCatalogInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *CatalogInterfaceMock) Controller() v31.CatalogController {
	if mock.ControllerFunc == nil {
		panic("CatalogInterfaceMock.ControllerFunc: method is nil but CatalogInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockCatalogInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockCatalogInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedCatalogInterface.ControllerCalls())
func (mock *CatalogInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockCatalogInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockCatalogInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *CatalogInterfaceMock) Create(in1 *v3.Catalog) (*v3.Catalog, error) {
	if mock.CreateFunc == nil {
		panic("CatalogInterfaceMock.CreateFunc: method is nil but CatalogInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.Catalog
	}{
		In1: in1,
	}
	lockCatalogInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockCatalogInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedCatalogInterface.CreateCalls())
func (mock *CatalogInterfaceMock) CreateCalls() []struct {
	In1 *v3.Catalog
} {
	var calls []struct {
		In1 *v3.Catalog
	}
	lockCatalogInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockCatalogInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *CatalogInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("CatalogInterfaceMock.DeleteFunc: method is nil but CatalogInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockCatalogInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockCatalogInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedCatalogInterface.DeleteCalls())
func (mock *CatalogInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockCatalogInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockCatalogInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *CatalogInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("CatalogInterfaceMock.DeleteCollectionFunc: method is nil but CatalogInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockCatalogInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockCatalogInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedCatalogInterface.DeleteCollectionCalls())
func (mock *CatalogInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockCatalogInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockCatalogInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *CatalogInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("CatalogInterfaceMock.DeleteNamespacedFunc: method is nil but CatalogInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockCatalogInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockCatalogInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedCatalogInterface.DeleteNamespacedCalls())
func (mock *CatalogInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockCatalogInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockCatalogInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *CatalogInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.Catalog, error) {
	if mock.GetFunc == nil {
		panic("CatalogInterfaceMock.GetFunc: method is nil but CatalogInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockCatalogInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockCatalogInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedCatalogInterface.GetCalls())
func (mock *CatalogInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockCatalogInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockCatalogInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *CatalogInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.Catalog, error) {
	if mock.GetNamespacedFunc == nil {
		panic("CatalogInterfaceMock.GetNamespacedFunc: method is nil but CatalogInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockCatalogInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockCatalogInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedCatalogInterface.GetNamespacedCalls())
func (mock *CatalogInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockCatalogInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockCatalogInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *CatalogInterfaceMock) List(opts metav1.ListOptions) (*v3.CatalogList, error) {
	if mock.ListFunc == nil {
		panic("CatalogInterfaceMock.ListFunc: method is nil but CatalogInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockCatalogInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockCatalogInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedCatalogInterface.ListCalls())
func (mock *CatalogInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockCatalogInterfaceMockList.RLock()
	calls = mock.calls.List
	lockCatalogInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *CatalogInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.CatalogList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("CatalogInterfaceMock.ListNamespacedFunc: method is nil but CatalogInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockCatalogInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockCatalogInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedCatalogInterface.ListNamespacedCalls())
func (mock *CatalogInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockCatalogInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockCatalogInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *CatalogInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("CatalogInterfaceMock.ObjectClientFunc: method is nil but CatalogInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockCatalogInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockCatalogInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedCatalogInterface.ObjectClientCalls())
func (mock *CatalogInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockCatalogInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockCatalogInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *CatalogInterfaceMock) Update(in1 *v3.Catalog) (*v3.Catalog, error) {
	if mock.UpdateFunc == nil {
		panic("CatalogInterfaceMock.UpdateFunc: method is nil but CatalogInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.Catalog
	}{
		In1: in1,
	}
	lockCatalogInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockCatalogInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedCatalogInterface.UpdateCalls())
func (mock *CatalogInterfaceMock) UpdateCalls() []struct {
	In1 *v3.Catalog
} {
	var calls []struct {
		In1 *v3.Catalog
	}
	lockCatalogInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockCatalogInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *CatalogInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("CatalogInterfaceMock.WatchFunc: method is nil but CatalogInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockCatalogInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockCatalogInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedCatalogInterface.WatchCalls())
func (mock *CatalogInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockCatalogInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockCatalogInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockCatalogsGetterMockCatalogs sync.RWMutex
)

// Ensure, that CatalogsGetterMock does implement v31.CatalogsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.CatalogsGetter = &CatalogsGetterMock{}

// CatalogsGetterMock is a mock implementation of v31.CatalogsGetter.
//
//     func TestSomethingThatUsesCatalogsGetter(t *testing.T) {
//
//         // make and configure a mocked v31.CatalogsGetter
//         mockedCatalogsGetter := &CatalogsGetterMock{
//             CatalogsFunc: func(namespace string) v31.CatalogInterface {
// 	               panic("mock out the Catalogs method")
//             },
//         }
//
//         // use mockedCatalogsGetter in code that requires v31.CatalogsGetter
//         // and then make assertions.
//
//     }
type CatalogsGetterMock struct {
	// CatalogsFunc mocks the Catalogs method.
	CatalogsFunc func(namespace string) v31.CatalogInterface

	// calls tracks calls to the methods.
	calls struct {
		// Catalogs holds details about calls to the Catalogs method.
		Catalogs []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// Catalogs calls CatalogsFunc.
func (mock *CatalogsGetterMock) Catalogs(namespace string) v31.CatalogInterface {
	if mock.CatalogsFunc == nil {
		panic("CatalogsGetterMock.CatalogsFunc: method is nil but CatalogsGetter.Catalogs was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockCatalogsGetterMockCatalogs.Lock()
	mock.calls.Catalogs = append(mock.calls.Catalogs, callInfo)
	lockCatalogsGetterMockCatalogs.Unlock()
	return mock.CatalogsFunc(namespace)
}

// CatalogsCalls gets all the calls that were made to Catalogs.
// Check the length with:
//     len(mockedCatalogsGetter.CatalogsCalls())
func (mock *CatalogsGetterMock) CatalogsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockCatalogsGetterMockCatalogs.RLock()
	calls = mock.calls.Catalogs
	lockCatalogsGetterMockCatalogs.RUnlock()
	return calls
}
