// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockCatalogTemplateListerMockGet  sync.RWMutex
	lockCatalogTemplateListerMockList sync.RWMutex
)

// Ensure, that CatalogTemplateListerMock does implement v31.CatalogTemplateLister.
// If this is not the case, regenerate this file with moq.
var _ v31.CatalogTemplateLister = &CatalogTemplateListerMock{}

// CatalogTemplateListerMock is a mock implementation of v31.CatalogTemplateLister.
//
//     func TestSomethingThatUsesCatalogTemplateLister(t *testing.T) {
//
//         // make and configure a mocked v31.CatalogTemplateLister
//         mockedCatalogTemplateLister := &CatalogTemplateListerMock{
//             GetFunc: func(namespace string, name string) (*v3.CatalogTemplate, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.CatalogTemplate, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedCatalogTemplateLister in code that requires v31.CatalogTemplateLister
//         // and then make assertions.
//
//     }
type CatalogTemplateListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.CatalogTemplate, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.CatalogTemplate, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *CatalogTemplateListerMock) Get(namespace string, name string) (*v3.CatalogTemplate, error) {
	if mock.GetFunc == nil {
		panic("CatalogTemplateListerMock.GetFunc: method is nil but CatalogTemplateLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockCatalogTemplateListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockCatalogTemplateListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedCatalogTemplateLister.GetCalls())
func (mock *CatalogTemplateListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockCatalogTemplateListerMockGet.RLock()
	calls = mock.calls.Get
	lockCatalogTemplateListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *CatalogTemplateListerMock) List(namespace string, selector labels.Selector) ([]*v3.CatalogTemplate, error) {
	if mock.ListFunc == nil {
		panic("CatalogTemplateListerMock.ListFunc: method is nil but CatalogTemplateLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockCatalogTemplateListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockCatalogTemplateListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedCatalogTemplateLister.ListCalls())
func (mock *CatalogTemplateListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockCatalogTemplateListerMockList.RLock()
	calls = mock.calls.List
	lockCatalogTemplateListerMockList.RUnlock()
	return calls
}

var (
	lockCatalogTemplateControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockCatalogTemplateControllerMockAddClusterScopedHandler        sync.RWMutex
	lockCatalogTemplateControllerMockAddFeatureHandler              sync.RWMutex
	lockCatalogTemplateControllerMockAddHandler                     sync.RWMutex
	lockCatalogTemplateControllerMockEnqueue                        sync.RWMutex
	lockCatalogTemplateControllerMockEnqueueAfter                   sync.RWMutex
	lockCatalogTemplateControllerMockGeneric                        sync.RWMutex
	lockCatalogTemplateControllerMockInformer                       sync.RWMutex
	lockCatalogTemplateControllerMockLister                         sync.RWMutex
)

// Ensure, that CatalogTemplateControllerMock does implement v31.CatalogTemplateController.
// If this is not the case, regenerate this file with moq.
var _ v31.CatalogTemplateController = &CatalogTemplateControllerMock{}

// CatalogTemplateControllerMock is a mock implementation of v31.CatalogTemplateController.
//
//     func TestSomethingThatUsesCatalogTemplateController(t *testing.T) {
//
//         // make and configure a mocked v31.CatalogTemplateController
//         mockedCatalogTemplateController := &CatalogTemplateControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.CatalogTemplateHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.CatalogTemplateHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CatalogTemplateHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.CatalogTemplateHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.CatalogTemplateLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedCatalogTemplateController in code that requires v31.CatalogTemplateController
//         // and then make assertions.
//
//     }
type CatalogTemplateControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.CatalogTemplateHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.CatalogTemplateHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CatalogTemplateHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.CatalogTemplateHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.CatalogTemplateLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.CatalogTemplateHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.CatalogTemplateHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.CatalogTemplateHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.CatalogTemplateHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *CatalogTemplateControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.CatalogTemplateHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("CatalogTemplateControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but CatalogTemplateController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.CatalogTemplateHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockCatalogTemplateControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockCatalogTemplateControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedCatalogTemplateController.AddClusterScopedFeatureHandlerCalls())
func (mock *CatalogTemplateControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.CatalogTemplateHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.CatalogTemplateHandlerFunc
	}
	lockCatalogTemplateControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockCatalogTemplateControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *CatalogTemplateControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.CatalogTemplateHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("CatalogTemplateControllerMock.AddClusterScopedHandlerFunc: method is nil but CatalogTemplateController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.CatalogTemplateHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockCatalogTemplateControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockCatalogTemplateControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedCatalogTemplateController.AddClusterScopedHandlerCalls())
func (mock *CatalogTemplateControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.CatalogTemplateHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.CatalogTemplateHandlerFunc
	}
	lockCatalogTemplateControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockCatalogTemplateControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *CatalogTemplateControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CatalogTemplateHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("CatalogTemplateControllerMock.AddFeatureHandlerFunc: method is nil but CatalogTemplateController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.CatalogTemplateHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockCatalogTemplateControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockCatalogTemplateControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedCatalogTemplateController.AddFeatureHandlerCalls())
func (mock *CatalogTemplateControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.CatalogTemplateHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.CatalogTemplateHandlerFunc
	}
	lockCatalogTemplateControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockCatalogTemplateControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *CatalogTemplateControllerMock) AddHandler(ctx context.Context, name string, handler v31.CatalogTemplateHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("CatalogTemplateControllerMock.AddHandlerFunc: method is nil but CatalogTemplateController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.CatalogTemplateHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockCatalogTemplateControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockCatalogTemplateControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedCatalogTemplateController.AddHandlerCalls())
func (mock *CatalogTemplateControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.CatalogTemplateHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.CatalogTemplateHandlerFunc
	}
	lockCatalogTemplateControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockCatalogTemplateControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *CatalogTemplateControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("CatalogTemplateControllerMock.EnqueueFunc: method is nil but CatalogTemplateController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockCatalogTemplateControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockCatalogTemplateControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedCatalogTemplateController.EnqueueCalls())
func (mock *CatalogTemplateControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockCatalogTemplateControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockCatalogTemplateControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *CatalogTemplateControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("CatalogTemplateControllerMock.EnqueueAfterFunc: method is nil but CatalogTemplateController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockCatalogTemplateControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockCatalogTemplateControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedCatalogTemplateController.EnqueueAfterCalls())
func (mock *CatalogTemplateControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockCatalogTemplateControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockCatalogTemplateControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *CatalogTemplateControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("CatalogTemplateControllerMock.GenericFunc: method is nil but CatalogTemplateController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockCatalogTemplateControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockCatalogTemplateControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedCatalogTemplateController.GenericCalls())
func (mock *CatalogTemplateControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockCatalogTemplateControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockCatalogTemplateControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *CatalogTemplateControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("CatalogTemplateControllerMock.InformerFunc: method is nil but CatalogTemplateController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockCatalogTemplateControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockCatalogTemplateControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedCatalogTemplateController.InformerCalls())
func (mock *CatalogTemplateControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockCatalogTemplateControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockCatalogTemplateControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *CatalogTemplateControllerMock) Lister() v31.CatalogTemplateLister {
	if mock.ListerFunc == nil {
		panic("CatalogTemplateControllerMock.ListerFunc: method is nil but CatalogTemplateController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockCatalogTemplateControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockCatalogTemplateControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedCatalogTemplateController.ListerCalls())
func (mock *CatalogTemplateControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockCatalogTemplateControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockCatalogTemplateControllerMockLister.RUnlock()
	return calls
}

var (
	lockCatalogTemplateInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockCatalogTemplateInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockCatalogTemplateInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockCatalogTemplateInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockCatalogTemplateInterfaceMockAddFeatureHandler                sync.RWMutex
	lockCatalogTemplateInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockCatalogTemplateInterfaceMockAddHandler                       sync.RWMutex
	lockCatalogTemplateInterfaceMockAddLifecycle                     sync.RWMutex
	lockCatalogTemplateInterfaceMockController                       sync.RWMutex
	lockCatalogTemplateInterfaceMockCreate                           sync.RWMutex
	lockCatalogTemplateInterfaceMockDelete                           sync.RWMutex
	lockCatalogTemplateInterfaceMockDeleteCollection                 sync.RWMutex
	lockCatalogTemplateInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockCatalogTemplateInterfaceMockGet                              sync.RWMutex
	lockCatalogTemplateInterfaceMockGetNamespaced                    sync.RWMutex
	lockCatalogTemplateInterfaceMockList                             sync.RWMutex
	lockCatalogTemplateInterfaceMockListNamespaced                   sync.RWMutex
	lockCatalogTemplateInterfaceMockObjectClient                     sync.RWMutex
	lockCatalogTemplateInterfaceMockUpdate                           sync.RWMutex
	lockCatalogTemplateInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that CatalogTemplateInterfaceMock does implement v31.CatalogTemplateInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.CatalogTemplateInterface = &CatalogTemplateInterfaceMock{}

// CatalogTemplateInterfaceMock is a mock implementation of v31.CatalogTemplateInterface.
//
//     func TestSomethingThatUsesCatalogTemplateInterface(t *testing.T) {
//
//         // make and configure a mocked v31.CatalogTemplateInterface
//         mockedCatalogTemplateInterface := &CatalogTemplateInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.CatalogTemplateHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.CatalogTemplateLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.CatalogTemplateHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.CatalogTemplateLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CatalogTemplateHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.CatalogTemplateLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.CatalogTemplateHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.CatalogTemplateLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.CatalogTemplateController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.CatalogTemplate) (*v3.CatalogTemplate, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.CatalogTemplate, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.CatalogTemplate, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.CatalogTemplateList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.CatalogTemplateList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.CatalogTemplate) (*v3.CatalogTemplate, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedCatalogTemplateInterface in code that requires v31.CatalogTemplateInterface
//         // and then make assertions.
//
//     }
type CatalogTemplateInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.CatalogTemplateHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.CatalogTemplateLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.CatalogTemplateHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.CatalogTemplateLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CatalogTemplateHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.CatalogTemplateLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.CatalogTemplateHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.CatalogTemplateLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.CatalogTemplateController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.CatalogTemplate) (*v3.CatalogTemplate, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.CatalogTemplate, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.CatalogTemplate, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.CatalogTemplateList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.CatalogTemplateList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.CatalogTemplate) (*v3.CatalogTemplate, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.CatalogTemplateHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.CatalogTemplateLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.CatalogTemplateHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.CatalogTemplateLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.CatalogTemplateHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.CatalogTemplateLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.CatalogTemplateHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.CatalogTemplateLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.CatalogTemplate
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.CatalogTemplate
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *CatalogTemplateInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.CatalogTemplateHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("CatalogTemplateInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but CatalogTemplateInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.CatalogTemplateHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockCatalogTemplateInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockCatalogTemplateInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedCatalogTemplateInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *CatalogTemplateInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.CatalogTemplateHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.CatalogTemplateHandlerFunc
	}
	lockCatalogTemplateInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockCatalogTemplateInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *CatalogTemplateInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.CatalogTemplateLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("CatalogTemplateInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but CatalogTemplateInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.CatalogTemplateLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockCatalogTemplateInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockCatalogTemplateInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedCatalogTemplateInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *CatalogTemplateInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.CatalogTemplateLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.CatalogTemplateLifecycle
	}
	lockCatalogTemplateInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockCatalogTemplateInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *CatalogTemplateInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.CatalogTemplateHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("CatalogTemplateInterfaceMock.AddClusterScopedHandlerFunc: method is nil but CatalogTemplateInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.CatalogTemplateHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockCatalogTemplateInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockCatalogTemplateInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedCatalogTemplateInterface.AddClusterScopedHandlerCalls())
func (mock *CatalogTemplateInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.CatalogTemplateHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.CatalogTemplateHandlerFunc
	}
	lockCatalogTemplateInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockCatalogTemplateInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *CatalogTemplateInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.CatalogTemplateLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("CatalogTemplateInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but CatalogTemplateInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.CatalogTemplateLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockCatalogTemplateInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockCatalogTemplateInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedCatalogTemplateInterface.AddClusterScopedLifecycleCalls())
func (mock *CatalogTemplateInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.CatalogTemplateLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.CatalogTemplateLifecycle
	}
	lockCatalogTemplateInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockCatalogTemplateInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *CatalogTemplateInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CatalogTemplateHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("CatalogTemplateInterfaceMock.AddFeatureHandlerFunc: method is nil but CatalogTemplateInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.CatalogTemplateHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockCatalogTemplateInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockCatalogTemplateInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedCatalogTemplateInterface.AddFeatureHandlerCalls())
func (mock *CatalogTemplateInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.CatalogTemplateHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.CatalogTemplateHandlerFunc
	}
	lockCatalogTemplateInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockCatalogTemplateInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *CatalogTemplateInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.CatalogTemplateLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("CatalogTemplateInterfaceMock.AddFeatureLifecycleFunc: method is nil but CatalogTemplateInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.CatalogTemplateLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockCatalogTemplateInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockCatalogTemplateInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedCatalogTemplateInterface.AddFeatureLifecycleCalls())
func (mock *CatalogTemplateInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.CatalogTemplateLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.CatalogTemplateLifecycle
	}
	lockCatalogTemplateInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockCatalogTemplateInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *CatalogTemplateInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.CatalogTemplateHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("CatalogTemplateInterfaceMock.AddHandlerFunc: method is nil but CatalogTemplateInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.CatalogTemplateHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockCatalogTemplateInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockCatalogTemplateInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedCatalogTemplateInterface.AddHandlerCalls())
func (mock *CatalogTemplateInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.CatalogTemplateHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.CatalogTemplateHandlerFunc
	}
	lockCatalogTemplateInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockCatalogTemplateInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *CatalogTemplateInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.CatalogTemplateLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("CatalogTemplateInterfaceMock.AddLifecycleFunc: method is nil but CatalogTemplateInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.CatalogTemplateLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockCatalogTemplateInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockCatalogTemplateInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedCatalogTemplateInterface.AddLifecycleCalls())
func (mock *CatalogTemplateInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.CatalogTemplateLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.CatalogTemplateLifecycle
	}
	lockCatalogTemplateInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockCatalogTemplateInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *CatalogTemplateInterfaceMock) Controller() v31.CatalogTemplateController {
	if mock.ControllerFunc == nil {
		panic("CatalogTemplateInterfaceMock.ControllerFunc: method is nil but CatalogTemplateInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockCatalogTemplateInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockCatalogTemplateInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedCatalogTemplateInterface.ControllerCalls())
func (mock *CatalogTemplateInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockCatalogTemplateInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockCatalogTemplateInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *CatalogTemplateInterfaceMock) Create(in1 *v3.CatalogTemplate) (*v3.CatalogTemplate, error) {
	if mock.CreateFunc == nil {
		panic("CatalogTemplateInterfaceMock.CreateFunc: method is nil but CatalogTemplateInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.CatalogTemplate
	}{
		In1: in1,
	}
	lockCatalogTemplateInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockCatalogTemplateInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedCatalogTemplateInterface.CreateCalls())
func (mock *CatalogTemplateInterfaceMock) CreateCalls() []struct {
	In1 *v3.CatalogTemplate
} {
	var calls []struct {
		In1 *v3.CatalogTemplate
	}
	lockCatalogTemplateInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockCatalogTemplateInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *CatalogTemplateInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("CatalogTemplateInterfaceMock.DeleteFunc: method is nil but CatalogTemplateInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockCatalogTemplateInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockCatalogTemplateInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedCatalogTemplateInterface.DeleteCalls())
func (mock *CatalogTemplateInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockCatalogTemplateInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockCatalogTemplateInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *CatalogTemplateInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("CatalogTemplateInterfaceMock.DeleteCollectionFunc: method is nil but CatalogTemplateInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockCatalogTemplateInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockCatalogTemplateInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedCatalogTemplateInterface.DeleteCollectionCalls())
func (mock *CatalogTemplateInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockCatalogTemplateInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockCatalogTemplateInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *CatalogTemplateInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("CatalogTemplateInterfaceMock.DeleteNamespacedFunc: method is nil but CatalogTemplateInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockCatalogTemplateInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockCatalogTemplateInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedCatalogTemplateInterface.DeleteNamespacedCalls())
func (mock *CatalogTemplateInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockCatalogTemplateInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockCatalogTemplateInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *CatalogTemplateInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.CatalogTemplate, error) {
	if mock.GetFunc == nil {
		panic("CatalogTemplateInterfaceMock.GetFunc: method is nil but CatalogTemplateInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockCatalogTemplateInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockCatalogTemplateInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedCatalogTemplateInterface.GetCalls())
func (mock *CatalogTemplateInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockCatalogTemplateInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockCatalogTemplateInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *CatalogTemplateInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.CatalogTemplate, error) {
	if mock.GetNamespacedFunc == nil {
		panic("CatalogTemplateInterfaceMock.GetNamespacedFunc: method is nil but CatalogTemplateInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockCatalogTemplateInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockCatalogTemplateInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedCatalogTemplateInterface.GetNamespacedCalls())
func (mock *CatalogTemplateInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockCatalogTemplateInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockCatalogTemplateInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *CatalogTemplateInterfaceMock) List(opts metav1.ListOptions) (*v3.CatalogTemplateList, error) {
	if mock.ListFunc == nil {
		panic("CatalogTemplateInterfaceMock.ListFunc: method is nil but CatalogTemplateInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockCatalogTemplateInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockCatalogTemplateInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedCatalogTemplateInterface.ListCalls())
func (mock *CatalogTemplateInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockCatalogTemplateInterfaceMockList.RLock()
	calls = mock.calls.List
	lockCatalogTemplateInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *CatalogTemplateInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.CatalogTemplateList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("CatalogTemplateInterfaceMock.ListNamespacedFunc: method is nil but CatalogTemplateInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockCatalogTemplateInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockCatalogTemplateInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedCatalogTemplateInterface.ListNamespacedCalls())
func (mock *CatalogTemplateInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockCatalogTemplateInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockCatalogTemplateInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *CatalogTemplateInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("CatalogTemplateInterfaceMock.ObjectClientFunc: method is nil but CatalogTemplateInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockCatalogTemplateInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockCatalogTemplateInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedCatalogTemplateInterface.ObjectClientCalls())
func (mock *CatalogTemplateInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockCatalogTemplateInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockCatalogTemplateInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *CatalogTemplateInterfaceMock) Update(in1 *v3.CatalogTemplate) (*v3.CatalogTemplate, error) {
	if mock.UpdateFunc == nil {
		panic("CatalogTemplateInterfaceMock.UpdateFunc: method is nil but CatalogTemplateInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.CatalogTemplate
	}{
		In1: in1,
	}
	lockCatalogTemplateInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockCatalogTemplateInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedCatalogTemplateInterface.UpdateCalls())
func (mock *CatalogTemplateInterfaceMock) UpdateCalls() []struct {
	In1 *v3.CatalogTemplate
} {
	var calls []struct {
		In1 *v3.CatalogTemplate
	}
	lockCatalogTemplateInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockCatalogTemplateInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *CatalogTemplateInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("CatalogTemplateInterfaceMock.WatchFunc: method is nil but CatalogTemplateInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockCatalogTemplateInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockCatalogTemplateInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedCatalogTemplateInterface.WatchCalls())
func (mock *CatalogTemplateInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockCatalogTemplateInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockCatalogTemplateInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockCatalogTemplatesGetterMockCatalogTemplates sync.RWMutex
)

// Ensure, that CatalogTemplatesGetterMock does implement v31.CatalogTemplatesGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.CatalogTemplatesGetter = &CatalogTemplatesGetterMock{}

// CatalogTemplatesGetterMock is a mock implementation of v31.CatalogTemplatesGetter.
//
//     func TestSomethingThatUsesCatalogTemplatesGetter(t *testing.T) {
//
//         // make and configure a mocked v31.CatalogTemplatesGetter
//         mockedCatalogTemplatesGetter := &CatalogTemplatesGetterMock{
//             CatalogTemplatesFunc: func(namespace string) v31.CatalogTemplateInterface {
// 	               panic("mock out the CatalogTemplates method")
//             },
//         }
//
//         // use mockedCatalogTemplatesGetter in code that requires v31.CatalogTemplatesGetter
//         // and then make assertions.
//
//     }
type CatalogTemplatesGetterMock struct {
	// CatalogTemplatesFunc mocks the CatalogTemplates method.
	CatalogTemplatesFunc func(namespace string) v31.CatalogTemplateInterface

	// calls tracks calls to the methods.
	calls struct {
		// CatalogTemplates holds details about calls to the CatalogTemplates method.
		CatalogTemplates []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// CatalogTemplates calls CatalogTemplatesFunc.
func (mock *CatalogTemplatesGetterMock) CatalogTemplates(namespace string) v31.CatalogTemplateInterface {
	if mock.CatalogTemplatesFunc == nil {
		panic("CatalogTemplatesGetterMock.CatalogTemplatesFunc: method is nil but CatalogTemplatesGetter.CatalogTemplates was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockCatalogTemplatesGetterMockCatalogTemplates.Lock()
	mock.calls.CatalogTemplates = append(mock.calls.CatalogTemplates, callInfo)
	lockCatalogTemplatesGetterMockCatalogTemplates.Unlock()
	return mock.CatalogTemplatesFunc(namespace)
}

// CatalogTemplatesCalls gets all the calls that were made to CatalogTemplates.
// Check the length with:
//     len(mockedCatalogTemplatesGetter.CatalogTemplatesCalls())
func (mock *CatalogTemplatesGetterMock) CatalogTemplatesCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockCatalogTemplatesGetterMockCatalogTemplates.RLock()
	calls = mock.calls.CatalogTemplates
	lockCatalogTemplatesGetterMockCatalogTemplates.RUnlock()
	return calls
}
