// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockCisBenchmarkVersionListerMockGet  sync.RWMutex
	lockCisBenchmarkVersionListerMockList sync.RWMutex
)

// Ensure, that CisBenchmarkVersionListerMock does implement v31.CisBenchmarkVersionLister.
// If this is not the case, regenerate this file with moq.
var _ v31.CisBenchmarkVersionLister = &CisBenchmarkVersionListerMock{}

// CisBenchmarkVersionListerMock is a mock implementation of v31.CisBenchmarkVersionLister.
//
//     func TestSomethingThatUsesCisBenchmarkVersionLister(t *testing.T) {
//
//         // make and configure a mocked v31.CisBenchmarkVersionLister
//         mockedCisBenchmarkVersionLister := &CisBenchmarkVersionListerMock{
//             GetFunc: func(namespace string, name string) (*v3.CisBenchmarkVersion, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.CisBenchmarkVersion, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedCisBenchmarkVersionLister in code that requires v31.CisBenchmarkVersionLister
//         // and then make assertions.
//
//     }
type CisBenchmarkVersionListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.CisBenchmarkVersion, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.CisBenchmarkVersion, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *CisBenchmarkVersionListerMock) Get(namespace string, name string) (*v3.CisBenchmarkVersion, error) {
	if mock.GetFunc == nil {
		panic("CisBenchmarkVersionListerMock.GetFunc: method is nil but CisBenchmarkVersionLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockCisBenchmarkVersionListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockCisBenchmarkVersionListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedCisBenchmarkVersionLister.GetCalls())
func (mock *CisBenchmarkVersionListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockCisBenchmarkVersionListerMockGet.RLock()
	calls = mock.calls.Get
	lockCisBenchmarkVersionListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *CisBenchmarkVersionListerMock) List(namespace string, selector labels.Selector) ([]*v3.CisBenchmarkVersion, error) {
	if mock.ListFunc == nil {
		panic("CisBenchmarkVersionListerMock.ListFunc: method is nil but CisBenchmarkVersionLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockCisBenchmarkVersionListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockCisBenchmarkVersionListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedCisBenchmarkVersionLister.ListCalls())
func (mock *CisBenchmarkVersionListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockCisBenchmarkVersionListerMockList.RLock()
	calls = mock.calls.List
	lockCisBenchmarkVersionListerMockList.RUnlock()
	return calls
}

var (
	lockCisBenchmarkVersionControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockCisBenchmarkVersionControllerMockAddClusterScopedHandler        sync.RWMutex
	lockCisBenchmarkVersionControllerMockAddFeatureHandler              sync.RWMutex
	lockCisBenchmarkVersionControllerMockAddHandler                     sync.RWMutex
	lockCisBenchmarkVersionControllerMockEnqueue                        sync.RWMutex
	lockCisBenchmarkVersionControllerMockEnqueueAfter                   sync.RWMutex
	lockCisBenchmarkVersionControllerMockGeneric                        sync.RWMutex
	lockCisBenchmarkVersionControllerMockInformer                       sync.RWMutex
	lockCisBenchmarkVersionControllerMockLister                         sync.RWMutex
)

// Ensure, that CisBenchmarkVersionControllerMock does implement v31.CisBenchmarkVersionController.
// If this is not the case, regenerate this file with moq.
var _ v31.CisBenchmarkVersionController = &CisBenchmarkVersionControllerMock{}

// CisBenchmarkVersionControllerMock is a mock implementation of v31.CisBenchmarkVersionController.
//
//     func TestSomethingThatUsesCisBenchmarkVersionController(t *testing.T) {
//
//         // make and configure a mocked v31.CisBenchmarkVersionController
//         mockedCisBenchmarkVersionController := &CisBenchmarkVersionControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.CisBenchmarkVersionHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.CisBenchmarkVersionHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CisBenchmarkVersionHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.CisBenchmarkVersionHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.CisBenchmarkVersionLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedCisBenchmarkVersionController in code that requires v31.CisBenchmarkVersionController
//         // and then make assertions.
//
//     }
type CisBenchmarkVersionControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.CisBenchmarkVersionHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.CisBenchmarkVersionHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CisBenchmarkVersionHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.CisBenchmarkVersionHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.CisBenchmarkVersionLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.CisBenchmarkVersionHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.CisBenchmarkVersionHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.CisBenchmarkVersionHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.CisBenchmarkVersionHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *CisBenchmarkVersionControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.CisBenchmarkVersionHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("CisBenchmarkVersionControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but CisBenchmarkVersionController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.CisBenchmarkVersionHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockCisBenchmarkVersionControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockCisBenchmarkVersionControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedCisBenchmarkVersionController.AddClusterScopedFeatureHandlerCalls())
func (mock *CisBenchmarkVersionControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.CisBenchmarkVersionHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.CisBenchmarkVersionHandlerFunc
	}
	lockCisBenchmarkVersionControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockCisBenchmarkVersionControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *CisBenchmarkVersionControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.CisBenchmarkVersionHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("CisBenchmarkVersionControllerMock.AddClusterScopedHandlerFunc: method is nil but CisBenchmarkVersionController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.CisBenchmarkVersionHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockCisBenchmarkVersionControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockCisBenchmarkVersionControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedCisBenchmarkVersionController.AddClusterScopedHandlerCalls())
func (mock *CisBenchmarkVersionControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.CisBenchmarkVersionHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.CisBenchmarkVersionHandlerFunc
	}
	lockCisBenchmarkVersionControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockCisBenchmarkVersionControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *CisBenchmarkVersionControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CisBenchmarkVersionHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("CisBenchmarkVersionControllerMock.AddFeatureHandlerFunc: method is nil but CisBenchmarkVersionController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.CisBenchmarkVersionHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockCisBenchmarkVersionControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockCisBenchmarkVersionControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedCisBenchmarkVersionController.AddFeatureHandlerCalls())
func (mock *CisBenchmarkVersionControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.CisBenchmarkVersionHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.CisBenchmarkVersionHandlerFunc
	}
	lockCisBenchmarkVersionControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockCisBenchmarkVersionControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *CisBenchmarkVersionControllerMock) AddHandler(ctx context.Context, name string, handler v31.CisBenchmarkVersionHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("CisBenchmarkVersionControllerMock.AddHandlerFunc: method is nil but CisBenchmarkVersionController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.CisBenchmarkVersionHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockCisBenchmarkVersionControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockCisBenchmarkVersionControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedCisBenchmarkVersionController.AddHandlerCalls())
func (mock *CisBenchmarkVersionControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.CisBenchmarkVersionHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.CisBenchmarkVersionHandlerFunc
	}
	lockCisBenchmarkVersionControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockCisBenchmarkVersionControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *CisBenchmarkVersionControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("CisBenchmarkVersionControllerMock.EnqueueFunc: method is nil but CisBenchmarkVersionController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockCisBenchmarkVersionControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockCisBenchmarkVersionControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedCisBenchmarkVersionController.EnqueueCalls())
func (mock *CisBenchmarkVersionControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockCisBenchmarkVersionControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockCisBenchmarkVersionControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *CisBenchmarkVersionControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("CisBenchmarkVersionControllerMock.EnqueueAfterFunc: method is nil but CisBenchmarkVersionController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockCisBenchmarkVersionControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockCisBenchmarkVersionControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedCisBenchmarkVersionController.EnqueueAfterCalls())
func (mock *CisBenchmarkVersionControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockCisBenchmarkVersionControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockCisBenchmarkVersionControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *CisBenchmarkVersionControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("CisBenchmarkVersionControllerMock.GenericFunc: method is nil but CisBenchmarkVersionController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockCisBenchmarkVersionControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockCisBenchmarkVersionControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedCisBenchmarkVersionController.GenericCalls())
func (mock *CisBenchmarkVersionControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockCisBenchmarkVersionControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockCisBenchmarkVersionControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *CisBenchmarkVersionControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("CisBenchmarkVersionControllerMock.InformerFunc: method is nil but CisBenchmarkVersionController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockCisBenchmarkVersionControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockCisBenchmarkVersionControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedCisBenchmarkVersionController.InformerCalls())
func (mock *CisBenchmarkVersionControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockCisBenchmarkVersionControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockCisBenchmarkVersionControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *CisBenchmarkVersionControllerMock) Lister() v31.CisBenchmarkVersionLister {
	if mock.ListerFunc == nil {
		panic("CisBenchmarkVersionControllerMock.ListerFunc: method is nil but CisBenchmarkVersionController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockCisBenchmarkVersionControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockCisBenchmarkVersionControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedCisBenchmarkVersionController.ListerCalls())
func (mock *CisBenchmarkVersionControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockCisBenchmarkVersionControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockCisBenchmarkVersionControllerMockLister.RUnlock()
	return calls
}

var (
	lockCisBenchmarkVersionInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockCisBenchmarkVersionInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockCisBenchmarkVersionInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockCisBenchmarkVersionInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockCisBenchmarkVersionInterfaceMockAddFeatureHandler                sync.RWMutex
	lockCisBenchmarkVersionInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockCisBenchmarkVersionInterfaceMockAddHandler                       sync.RWMutex
	lockCisBenchmarkVersionInterfaceMockAddLifecycle                     sync.RWMutex
	lockCisBenchmarkVersionInterfaceMockController                       sync.RWMutex
	lockCisBenchmarkVersionInterfaceMockCreate                           sync.RWMutex
	lockCisBenchmarkVersionInterfaceMockDelete                           sync.RWMutex
	lockCisBenchmarkVersionInterfaceMockDeleteCollection                 sync.RWMutex
	lockCisBenchmarkVersionInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockCisBenchmarkVersionInterfaceMockGet                              sync.RWMutex
	lockCisBenchmarkVersionInterfaceMockGetNamespaced                    sync.RWMutex
	lockCisBenchmarkVersionInterfaceMockList                             sync.RWMutex
	lockCisBenchmarkVersionInterfaceMockListNamespaced                   sync.RWMutex
	lockCisBenchmarkVersionInterfaceMockObjectClient                     sync.RWMutex
	lockCisBenchmarkVersionInterfaceMockUpdate                           sync.RWMutex
	lockCisBenchmarkVersionInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that CisBenchmarkVersionInterfaceMock does implement v31.CisBenchmarkVersionInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.CisBenchmarkVersionInterface = &CisBenchmarkVersionInterfaceMock{}

// CisBenchmarkVersionInterfaceMock is a mock implementation of v31.CisBenchmarkVersionInterface.
//
//     func TestSomethingThatUsesCisBenchmarkVersionInterface(t *testing.T) {
//
//         // make and configure a mocked v31.CisBenchmarkVersionInterface
//         mockedCisBenchmarkVersionInterface := &CisBenchmarkVersionInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.CisBenchmarkVersionHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.CisBenchmarkVersionLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.CisBenchmarkVersionHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.CisBenchmarkVersionLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CisBenchmarkVersionHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.CisBenchmarkVersionLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.CisBenchmarkVersionHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.CisBenchmarkVersionLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.CisBenchmarkVersionController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.CisBenchmarkVersion) (*v3.CisBenchmarkVersion, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.CisBenchmarkVersion, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.CisBenchmarkVersion, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.CisBenchmarkVersionList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.CisBenchmarkVersionList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.CisBenchmarkVersion) (*v3.CisBenchmarkVersion, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedCisBenchmarkVersionInterface in code that requires v31.CisBenchmarkVersionInterface
//         // and then make assertions.
//
//     }
type CisBenchmarkVersionInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.CisBenchmarkVersionHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.CisBenchmarkVersionLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.CisBenchmarkVersionHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.CisBenchmarkVersionLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CisBenchmarkVersionHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.CisBenchmarkVersionLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.CisBenchmarkVersionHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.CisBenchmarkVersionLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.CisBenchmarkVersionController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.CisBenchmarkVersion) (*v3.CisBenchmarkVersion, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.CisBenchmarkVersion, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.CisBenchmarkVersion, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.CisBenchmarkVersionList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.CisBenchmarkVersionList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.CisBenchmarkVersion) (*v3.CisBenchmarkVersion, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.CisBenchmarkVersionHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.CisBenchmarkVersionLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.CisBenchmarkVersionHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.CisBenchmarkVersionLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.CisBenchmarkVersionHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.CisBenchmarkVersionLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.CisBenchmarkVersionHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.CisBenchmarkVersionLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.CisBenchmarkVersion
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.CisBenchmarkVersion
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *CisBenchmarkVersionInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.CisBenchmarkVersionHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("CisBenchmarkVersionInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but CisBenchmarkVersionInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.CisBenchmarkVersionHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockCisBenchmarkVersionInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockCisBenchmarkVersionInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedCisBenchmarkVersionInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *CisBenchmarkVersionInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.CisBenchmarkVersionHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.CisBenchmarkVersionHandlerFunc
	}
	lockCisBenchmarkVersionInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockCisBenchmarkVersionInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *CisBenchmarkVersionInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.CisBenchmarkVersionLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("CisBenchmarkVersionInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but CisBenchmarkVersionInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.CisBenchmarkVersionLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockCisBenchmarkVersionInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockCisBenchmarkVersionInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedCisBenchmarkVersionInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *CisBenchmarkVersionInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.CisBenchmarkVersionLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.CisBenchmarkVersionLifecycle
	}
	lockCisBenchmarkVersionInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockCisBenchmarkVersionInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *CisBenchmarkVersionInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.CisBenchmarkVersionHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("CisBenchmarkVersionInterfaceMock.AddClusterScopedHandlerFunc: method is nil but CisBenchmarkVersionInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.CisBenchmarkVersionHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockCisBenchmarkVersionInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockCisBenchmarkVersionInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedCisBenchmarkVersionInterface.AddClusterScopedHandlerCalls())
func (mock *CisBenchmarkVersionInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.CisBenchmarkVersionHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.CisBenchmarkVersionHandlerFunc
	}
	lockCisBenchmarkVersionInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockCisBenchmarkVersionInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *CisBenchmarkVersionInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.CisBenchmarkVersionLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("CisBenchmarkVersionInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but CisBenchmarkVersionInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.CisBenchmarkVersionLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockCisBenchmarkVersionInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockCisBenchmarkVersionInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedCisBenchmarkVersionInterface.AddClusterScopedLifecycleCalls())
func (mock *CisBenchmarkVersionInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.CisBenchmarkVersionLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.CisBenchmarkVersionLifecycle
	}
	lockCisBenchmarkVersionInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockCisBenchmarkVersionInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *CisBenchmarkVersionInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CisBenchmarkVersionHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("CisBenchmarkVersionInterfaceMock.AddFeatureHandlerFunc: method is nil but CisBenchmarkVersionInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.CisBenchmarkVersionHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockCisBenchmarkVersionInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockCisBenchmarkVersionInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedCisBenchmarkVersionInterface.AddFeatureHandlerCalls())
func (mock *CisBenchmarkVersionInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.CisBenchmarkVersionHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.CisBenchmarkVersionHandlerFunc
	}
	lockCisBenchmarkVersionInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockCisBenchmarkVersionInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *CisBenchmarkVersionInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.CisBenchmarkVersionLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("CisBenchmarkVersionInterfaceMock.AddFeatureLifecycleFunc: method is nil but CisBenchmarkVersionInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.CisBenchmarkVersionLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockCisBenchmarkVersionInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockCisBenchmarkVersionInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedCisBenchmarkVersionInterface.AddFeatureLifecycleCalls())
func (mock *CisBenchmarkVersionInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.CisBenchmarkVersionLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.CisBenchmarkVersionLifecycle
	}
	lockCisBenchmarkVersionInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockCisBenchmarkVersionInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *CisBenchmarkVersionInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.CisBenchmarkVersionHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("CisBenchmarkVersionInterfaceMock.AddHandlerFunc: method is nil but CisBenchmarkVersionInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.CisBenchmarkVersionHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockCisBenchmarkVersionInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockCisBenchmarkVersionInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedCisBenchmarkVersionInterface.AddHandlerCalls())
func (mock *CisBenchmarkVersionInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.CisBenchmarkVersionHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.CisBenchmarkVersionHandlerFunc
	}
	lockCisBenchmarkVersionInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockCisBenchmarkVersionInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *CisBenchmarkVersionInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.CisBenchmarkVersionLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("CisBenchmarkVersionInterfaceMock.AddLifecycleFunc: method is nil but CisBenchmarkVersionInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.CisBenchmarkVersionLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockCisBenchmarkVersionInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockCisBenchmarkVersionInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedCisBenchmarkVersionInterface.AddLifecycleCalls())
func (mock *CisBenchmarkVersionInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.CisBenchmarkVersionLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.CisBenchmarkVersionLifecycle
	}
	lockCisBenchmarkVersionInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockCisBenchmarkVersionInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *CisBenchmarkVersionInterfaceMock) Controller() v31.CisBenchmarkVersionController {
	if mock.ControllerFunc == nil {
		panic("CisBenchmarkVersionInterfaceMock.ControllerFunc: method is nil but CisBenchmarkVersionInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockCisBenchmarkVersionInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockCisBenchmarkVersionInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedCisBenchmarkVersionInterface.ControllerCalls())
func (mock *CisBenchmarkVersionInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockCisBenchmarkVersionInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockCisBenchmarkVersionInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *CisBenchmarkVersionInterfaceMock) Create(in1 *v3.CisBenchmarkVersion) (*v3.CisBenchmarkVersion, error) {
	if mock.CreateFunc == nil {
		panic("CisBenchmarkVersionInterfaceMock.CreateFunc: method is nil but CisBenchmarkVersionInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.CisBenchmarkVersion
	}{
		In1: in1,
	}
	lockCisBenchmarkVersionInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockCisBenchmarkVersionInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedCisBenchmarkVersionInterface.CreateCalls())
func (mock *CisBenchmarkVersionInterfaceMock) CreateCalls() []struct {
	In1 *v3.CisBenchmarkVersion
} {
	var calls []struct {
		In1 *v3.CisBenchmarkVersion
	}
	lockCisBenchmarkVersionInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockCisBenchmarkVersionInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *CisBenchmarkVersionInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("CisBenchmarkVersionInterfaceMock.DeleteFunc: method is nil but CisBenchmarkVersionInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockCisBenchmarkVersionInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockCisBenchmarkVersionInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedCisBenchmarkVersionInterface.DeleteCalls())
func (mock *CisBenchmarkVersionInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockCisBenchmarkVersionInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockCisBenchmarkVersionInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *CisBenchmarkVersionInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("CisBenchmarkVersionInterfaceMock.DeleteCollectionFunc: method is nil but CisBenchmarkVersionInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockCisBenchmarkVersionInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockCisBenchmarkVersionInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedCisBenchmarkVersionInterface.DeleteCollectionCalls())
func (mock *CisBenchmarkVersionInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockCisBenchmarkVersionInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockCisBenchmarkVersionInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *CisBenchmarkVersionInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("CisBenchmarkVersionInterfaceMock.DeleteNamespacedFunc: method is nil but CisBenchmarkVersionInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockCisBenchmarkVersionInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockCisBenchmarkVersionInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedCisBenchmarkVersionInterface.DeleteNamespacedCalls())
func (mock *CisBenchmarkVersionInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockCisBenchmarkVersionInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockCisBenchmarkVersionInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *CisBenchmarkVersionInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.CisBenchmarkVersion, error) {
	if mock.GetFunc == nil {
		panic("CisBenchmarkVersionInterfaceMock.GetFunc: method is nil but CisBenchmarkVersionInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockCisBenchmarkVersionInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockCisBenchmarkVersionInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedCisBenchmarkVersionInterface.GetCalls())
func (mock *CisBenchmarkVersionInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockCisBenchmarkVersionInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockCisBenchmarkVersionInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *CisBenchmarkVersionInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.CisBenchmarkVersion, error) {
	if mock.GetNamespacedFunc == nil {
		panic("CisBenchmarkVersionInterfaceMock.GetNamespacedFunc: method is nil but CisBenchmarkVersionInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockCisBenchmarkVersionInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockCisBenchmarkVersionInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedCisBenchmarkVersionInterface.GetNamespacedCalls())
func (mock *CisBenchmarkVersionInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockCisBenchmarkVersionInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockCisBenchmarkVersionInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *CisBenchmarkVersionInterfaceMock) List(opts metav1.ListOptions) (*v3.CisBenchmarkVersionList, error) {
	if mock.ListFunc == nil {
		panic("CisBenchmarkVersionInterfaceMock.ListFunc: method is nil but CisBenchmarkVersionInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockCisBenchmarkVersionInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockCisBenchmarkVersionInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedCisBenchmarkVersionInterface.ListCalls())
func (mock *CisBenchmarkVersionInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockCisBenchmarkVersionInterfaceMockList.RLock()
	calls = mock.calls.List
	lockCisBenchmarkVersionInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *CisBenchmarkVersionInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.CisBenchmarkVersionList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("CisBenchmarkVersionInterfaceMock.ListNamespacedFunc: method is nil but CisBenchmarkVersionInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockCisBenchmarkVersionInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockCisBenchmarkVersionInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedCisBenchmarkVersionInterface.ListNamespacedCalls())
func (mock *CisBenchmarkVersionInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockCisBenchmarkVersionInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockCisBenchmarkVersionInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *CisBenchmarkVersionInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("CisBenchmarkVersionInterfaceMock.ObjectClientFunc: method is nil but CisBenchmarkVersionInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockCisBenchmarkVersionInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockCisBenchmarkVersionInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedCisBenchmarkVersionInterface.ObjectClientCalls())
func (mock *CisBenchmarkVersionInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockCisBenchmarkVersionInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockCisBenchmarkVersionInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *CisBenchmarkVersionInterfaceMock) Update(in1 *v3.CisBenchmarkVersion) (*v3.CisBenchmarkVersion, error) {
	if mock.UpdateFunc == nil {
		panic("CisBenchmarkVersionInterfaceMock.UpdateFunc: method is nil but CisBenchmarkVersionInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.CisBenchmarkVersion
	}{
		In1: in1,
	}
	lockCisBenchmarkVersionInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockCisBenchmarkVersionInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedCisBenchmarkVersionInterface.UpdateCalls())
func (mock *CisBenchmarkVersionInterfaceMock) UpdateCalls() []struct {
	In1 *v3.CisBenchmarkVersion
} {
	var calls []struct {
		In1 *v3.CisBenchmarkVersion
	}
	lockCisBenchmarkVersionInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockCisBenchmarkVersionInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *CisBenchmarkVersionInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("CisBenchmarkVersionInterfaceMock.WatchFunc: method is nil but CisBenchmarkVersionInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockCisBenchmarkVersionInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockCisBenchmarkVersionInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedCisBenchmarkVersionInterface.WatchCalls())
func (mock *CisBenchmarkVersionInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockCisBenchmarkVersionInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockCisBenchmarkVersionInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockCisBenchmarkVersionsGetterMockCisBenchmarkVersions sync.RWMutex
)

// Ensure, that CisBenchmarkVersionsGetterMock does implement v31.CisBenchmarkVersionsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.CisBenchmarkVersionsGetter = &CisBenchmarkVersionsGetterMock{}

// CisBenchmarkVersionsGetterMock is a mock implementation of v31.CisBenchmarkVersionsGetter.
//
//     func TestSomethingThatUsesCisBenchmarkVersionsGetter(t *testing.T) {
//
//         // make and configure a mocked v31.CisBenchmarkVersionsGetter
//         mockedCisBenchmarkVersionsGetter := &CisBenchmarkVersionsGetterMock{
//             CisBenchmarkVersionsFunc: func(namespace string) v31.CisBenchmarkVersionInterface {
// 	               panic("mock out the CisBenchmarkVersions method")
//             },
//         }
//
//         // use mockedCisBenchmarkVersionsGetter in code that requires v31.CisBenchmarkVersionsGetter
//         // and then make assertions.
//
//     }
type CisBenchmarkVersionsGetterMock struct {
	// CisBenchmarkVersionsFunc mocks the CisBenchmarkVersions method.
	CisBenchmarkVersionsFunc func(namespace string) v31.CisBenchmarkVersionInterface

	// calls tracks calls to the methods.
	calls struct {
		// CisBenchmarkVersions holds details about calls to the CisBenchmarkVersions method.
		CisBenchmarkVersions []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// CisBenchmarkVersions calls CisBenchmarkVersionsFunc.
func (mock *CisBenchmarkVersionsGetterMock) CisBenchmarkVersions(namespace string) v31.CisBenchmarkVersionInterface {
	if mock.CisBenchmarkVersionsFunc == nil {
		panic("CisBenchmarkVersionsGetterMock.CisBenchmarkVersionsFunc: method is nil but CisBenchmarkVersionsGetter.CisBenchmarkVersions was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockCisBenchmarkVersionsGetterMockCisBenchmarkVersions.Lock()
	mock.calls.CisBenchmarkVersions = append(mock.calls.CisBenchmarkVersions, callInfo)
	lockCisBenchmarkVersionsGetterMockCisBenchmarkVersions.Unlock()
	return mock.CisBenchmarkVersionsFunc(namespace)
}

// CisBenchmarkVersionsCalls gets all the calls that were made to CisBenchmarkVersions.
// Check the length with:
//     len(mockedCisBenchmarkVersionsGetter.CisBenchmarkVersionsCalls())
func (mock *CisBenchmarkVersionsGetterMock) CisBenchmarkVersionsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockCisBenchmarkVersionsGetterMockCisBenchmarkVersions.RLock()
	calls = mock.calls.CisBenchmarkVersions
	lockCisBenchmarkVersionsGetterMockCisBenchmarkVersions.RUnlock()
	return calls
}
