// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockCisConfigListerMockGet  sync.RWMutex
	lockCisConfigListerMockList sync.RWMutex
)

// Ensure, that CisConfigListerMock does implement v31.CisConfigLister.
// If this is not the case, regenerate this file with moq.
var _ v31.CisConfigLister = &CisConfigListerMock{}

// CisConfigListerMock is a mock implementation of v31.CisConfigLister.
//
//     func TestSomethingThatUsesCisConfigLister(t *testing.T) {
//
//         // make and configure a mocked v31.CisConfigLister
//         mockedCisConfigLister := &CisConfigListerMock{
//             GetFunc: func(namespace string, name string) (*v3.CisConfig, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.CisConfig, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedCisConfigLister in code that requires v31.CisConfigLister
//         // and then make assertions.
//
//     }
type CisConfigListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.CisConfig, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.CisConfig, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *CisConfigListerMock) Get(namespace string, name string) (*v3.CisConfig, error) {
	if mock.GetFunc == nil {
		panic("CisConfigListerMock.GetFunc: method is nil but CisConfigLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockCisConfigListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockCisConfigListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedCisConfigLister.GetCalls())
func (mock *CisConfigListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockCisConfigListerMockGet.RLock()
	calls = mock.calls.Get
	lockCisConfigListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *CisConfigListerMock) List(namespace string, selector labels.Selector) ([]*v3.CisConfig, error) {
	if mock.ListFunc == nil {
		panic("CisConfigListerMock.ListFunc: method is nil but CisConfigLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockCisConfigListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockCisConfigListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedCisConfigLister.ListCalls())
func (mock *CisConfigListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockCisConfigListerMockList.RLock()
	calls = mock.calls.List
	lockCisConfigListerMockList.RUnlock()
	return calls
}

var (
	lockCisConfigControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockCisConfigControllerMockAddClusterScopedHandler        sync.RWMutex
	lockCisConfigControllerMockAddFeatureHandler              sync.RWMutex
	lockCisConfigControllerMockAddHandler                     sync.RWMutex
	lockCisConfigControllerMockEnqueue                        sync.RWMutex
	lockCisConfigControllerMockEnqueueAfter                   sync.RWMutex
	lockCisConfigControllerMockGeneric                        sync.RWMutex
	lockCisConfigControllerMockInformer                       sync.RWMutex
	lockCisConfigControllerMockLister                         sync.RWMutex
)

// Ensure, that CisConfigControllerMock does implement v31.CisConfigController.
// If this is not the case, regenerate this file with moq.
var _ v31.CisConfigController = &CisConfigControllerMock{}

// CisConfigControllerMock is a mock implementation of v31.CisConfigController.
//
//     func TestSomethingThatUsesCisConfigController(t *testing.T) {
//
//         // make and configure a mocked v31.CisConfigController
//         mockedCisConfigController := &CisConfigControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.CisConfigHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.CisConfigHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CisConfigHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.CisConfigHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.CisConfigLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedCisConfigController in code that requires v31.CisConfigController
//         // and then make assertions.
//
//     }
type CisConfigControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.CisConfigHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.CisConfigHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CisConfigHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.CisConfigHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.CisConfigLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.CisConfigHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.CisConfigHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.CisConfigHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.CisConfigHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *CisConfigControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.CisConfigHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("CisConfigControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but CisConfigController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.CisConfigHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockCisConfigControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockCisConfigControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedCisConfigController.AddClusterScopedFeatureHandlerCalls())
func (mock *CisConfigControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.CisConfigHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.CisConfigHandlerFunc
	}
	lockCisConfigControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockCisConfigControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *CisConfigControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.CisConfigHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("CisConfigControllerMock.AddClusterScopedHandlerFunc: method is nil but CisConfigController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.CisConfigHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockCisConfigControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockCisConfigControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedCisConfigController.AddClusterScopedHandlerCalls())
func (mock *CisConfigControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.CisConfigHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.CisConfigHandlerFunc
	}
	lockCisConfigControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockCisConfigControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *CisConfigControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CisConfigHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("CisConfigControllerMock.AddFeatureHandlerFunc: method is nil but CisConfigController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.CisConfigHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockCisConfigControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockCisConfigControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedCisConfigController.AddFeatureHandlerCalls())
func (mock *CisConfigControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.CisConfigHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.CisConfigHandlerFunc
	}
	lockCisConfigControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockCisConfigControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *CisConfigControllerMock) AddHandler(ctx context.Context, name string, handler v31.CisConfigHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("CisConfigControllerMock.AddHandlerFunc: method is nil but CisConfigController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.CisConfigHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockCisConfigControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockCisConfigControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedCisConfigController.AddHandlerCalls())
func (mock *CisConfigControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.CisConfigHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.CisConfigHandlerFunc
	}
	lockCisConfigControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockCisConfigControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *CisConfigControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("CisConfigControllerMock.EnqueueFunc: method is nil but CisConfigController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockCisConfigControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockCisConfigControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedCisConfigController.EnqueueCalls())
func (mock *CisConfigControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockCisConfigControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockCisConfigControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *CisConfigControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("CisConfigControllerMock.EnqueueAfterFunc: method is nil but CisConfigController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockCisConfigControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockCisConfigControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedCisConfigController.EnqueueAfterCalls())
func (mock *CisConfigControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockCisConfigControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockCisConfigControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *CisConfigControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("CisConfigControllerMock.GenericFunc: method is nil but CisConfigController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockCisConfigControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockCisConfigControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedCisConfigController.GenericCalls())
func (mock *CisConfigControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockCisConfigControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockCisConfigControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *CisConfigControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("CisConfigControllerMock.InformerFunc: method is nil but CisConfigController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockCisConfigControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockCisConfigControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedCisConfigController.InformerCalls())
func (mock *CisConfigControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockCisConfigControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockCisConfigControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *CisConfigControllerMock) Lister() v31.CisConfigLister {
	if mock.ListerFunc == nil {
		panic("CisConfigControllerMock.ListerFunc: method is nil but CisConfigController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockCisConfigControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockCisConfigControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedCisConfigController.ListerCalls())
func (mock *CisConfigControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockCisConfigControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockCisConfigControllerMockLister.RUnlock()
	return calls
}

var (
	lockCisConfigInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockCisConfigInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockCisConfigInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockCisConfigInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockCisConfigInterfaceMockAddFeatureHandler                sync.RWMutex
	lockCisConfigInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockCisConfigInterfaceMockAddHandler                       sync.RWMutex
	lockCisConfigInterfaceMockAddLifecycle                     sync.RWMutex
	lockCisConfigInterfaceMockController                       sync.RWMutex
	lockCisConfigInterfaceMockCreate                           sync.RWMutex
	lockCisConfigInterfaceMockDelete                           sync.RWMutex
	lockCisConfigInterfaceMockDeleteCollection                 sync.RWMutex
	lockCisConfigInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockCisConfigInterfaceMockGet                              sync.RWMutex
	lockCisConfigInterfaceMockGetNamespaced                    sync.RWMutex
	lockCisConfigInterfaceMockList                             sync.RWMutex
	lockCisConfigInterfaceMockListNamespaced                   sync.RWMutex
	lockCisConfigInterfaceMockObjectClient                     sync.RWMutex
	lockCisConfigInterfaceMockUpdate                           sync.RWMutex
	lockCisConfigInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that CisConfigInterfaceMock does implement v31.CisConfigInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.CisConfigInterface = &CisConfigInterfaceMock{}

// CisConfigInterfaceMock is a mock implementation of v31.CisConfigInterface.
//
//     func TestSomethingThatUsesCisConfigInterface(t *testing.T) {
//
//         // make and configure a mocked v31.CisConfigInterface
//         mockedCisConfigInterface := &CisConfigInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.CisConfigHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.CisConfigLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.CisConfigHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.CisConfigLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CisConfigHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.CisConfigLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.CisConfigHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.CisConfigLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.CisConfigController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.CisConfig) (*v3.CisConfig, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.CisConfig, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.CisConfig, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.CisConfigList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.CisConfigList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.CisConfig) (*v3.CisConfig, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedCisConfigInterface in code that requires v31.CisConfigInterface
//         // and then make assertions.
//
//     }
type CisConfigInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.CisConfigHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.CisConfigLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.CisConfigHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.CisConfigLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CisConfigHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.CisConfigLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.CisConfigHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.CisConfigLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.CisConfigController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.CisConfig) (*v3.CisConfig, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.CisConfig, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.CisConfig, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.CisConfigList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.CisConfigList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.CisConfig) (*v3.CisConfig, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.CisConfigHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.CisConfigLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.CisConfigHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.CisConfigLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.CisConfigHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.CisConfigLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.CisConfigHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.CisConfigLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.CisConfig
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.CisConfig
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *CisConfigInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.CisConfigHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("CisConfigInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but CisConfigInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.CisConfigHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockCisConfigInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockCisConfigInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedCisConfigInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *CisConfigInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.CisConfigHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.CisConfigHandlerFunc
	}
	lockCisConfigInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockCisConfigInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *CisConfigInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.CisConfigLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("CisConfigInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but CisConfigInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.CisConfigLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockCisConfigInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockCisConfigInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedCisConfigInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *CisConfigInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.CisConfigLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.CisConfigLifecycle
	}
	lockCisConfigInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockCisConfigInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *CisConfigInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.CisConfigHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("CisConfigInterfaceMock.AddClusterScopedHandlerFunc: method is nil but CisConfigInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.CisConfigHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockCisConfigInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockCisConfigInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedCisConfigInterface.AddClusterScopedHandlerCalls())
func (mock *CisConfigInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.CisConfigHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.CisConfigHandlerFunc
	}
	lockCisConfigInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockCisConfigInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *CisConfigInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.CisConfigLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("CisConfigInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but CisConfigInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.CisConfigLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockCisConfigInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockCisConfigInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedCisConfigInterface.AddClusterScopedLifecycleCalls())
func (mock *CisConfigInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.CisConfigLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.CisConfigLifecycle
	}
	lockCisConfigInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockCisConfigInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *CisConfigInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CisConfigHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("CisConfigInterfaceMock.AddFeatureHandlerFunc: method is nil but CisConfigInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.CisConfigHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockCisConfigInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockCisConfigInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedCisConfigInterface.AddFeatureHandlerCalls())
func (mock *CisConfigInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.CisConfigHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.CisConfigHandlerFunc
	}
	lockCisConfigInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockCisConfigInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *CisConfigInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.CisConfigLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("CisConfigInterfaceMock.AddFeatureLifecycleFunc: method is nil but CisConfigInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.CisConfigLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockCisConfigInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockCisConfigInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedCisConfigInterface.AddFeatureLifecycleCalls())
func (mock *CisConfigInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.CisConfigLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.CisConfigLifecycle
	}
	lockCisConfigInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockCisConfigInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *CisConfigInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.CisConfigHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("CisConfigInterfaceMock.AddHandlerFunc: method is nil but CisConfigInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.CisConfigHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockCisConfigInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockCisConfigInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedCisConfigInterface.AddHandlerCalls())
func (mock *CisConfigInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.CisConfigHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.CisConfigHandlerFunc
	}
	lockCisConfigInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockCisConfigInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *CisConfigInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.CisConfigLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("CisConfigInterfaceMock.AddLifecycleFunc: method is nil but CisConfigInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.CisConfigLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockCisConfigInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockCisConfigInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedCisConfigInterface.AddLifecycleCalls())
func (mock *CisConfigInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.CisConfigLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.CisConfigLifecycle
	}
	lockCisConfigInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockCisConfigInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *CisConfigInterfaceMock) Controller() v31.CisConfigController {
	if mock.ControllerFunc == nil {
		panic("CisConfigInterfaceMock.ControllerFunc: method is nil but CisConfigInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockCisConfigInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockCisConfigInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedCisConfigInterface.ControllerCalls())
func (mock *CisConfigInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockCisConfigInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockCisConfigInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *CisConfigInterfaceMock) Create(in1 *v3.CisConfig) (*v3.CisConfig, error) {
	if mock.CreateFunc == nil {
		panic("CisConfigInterfaceMock.CreateFunc: method is nil but CisConfigInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.CisConfig
	}{
		In1: in1,
	}
	lockCisConfigInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockCisConfigInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedCisConfigInterface.CreateCalls())
func (mock *CisConfigInterfaceMock) CreateCalls() []struct {
	In1 *v3.CisConfig
} {
	var calls []struct {
		In1 *v3.CisConfig
	}
	lockCisConfigInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockCisConfigInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *CisConfigInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("CisConfigInterfaceMock.DeleteFunc: method is nil but CisConfigInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockCisConfigInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockCisConfigInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedCisConfigInterface.DeleteCalls())
func (mock *CisConfigInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockCisConfigInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockCisConfigInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *CisConfigInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("CisConfigInterfaceMock.DeleteCollectionFunc: method is nil but CisConfigInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockCisConfigInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockCisConfigInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedCisConfigInterface.DeleteCollectionCalls())
func (mock *CisConfigInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockCisConfigInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockCisConfigInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *CisConfigInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("CisConfigInterfaceMock.DeleteNamespacedFunc: method is nil but CisConfigInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockCisConfigInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockCisConfigInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedCisConfigInterface.DeleteNamespacedCalls())
func (mock *CisConfigInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockCisConfigInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockCisConfigInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *CisConfigInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.CisConfig, error) {
	if mock.GetFunc == nil {
		panic("CisConfigInterfaceMock.GetFunc: method is nil but CisConfigInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockCisConfigInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockCisConfigInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedCisConfigInterface.GetCalls())
func (mock *CisConfigInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockCisConfigInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockCisConfigInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *CisConfigInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.CisConfig, error) {
	if mock.GetNamespacedFunc == nil {
		panic("CisConfigInterfaceMock.GetNamespacedFunc: method is nil but CisConfigInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockCisConfigInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockCisConfigInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedCisConfigInterface.GetNamespacedCalls())
func (mock *CisConfigInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockCisConfigInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockCisConfigInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *CisConfigInterfaceMock) List(opts metav1.ListOptions) (*v3.CisConfigList, error) {
	if mock.ListFunc == nil {
		panic("CisConfigInterfaceMock.ListFunc: method is nil but CisConfigInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockCisConfigInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockCisConfigInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedCisConfigInterface.ListCalls())
func (mock *CisConfigInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockCisConfigInterfaceMockList.RLock()
	calls = mock.calls.List
	lockCisConfigInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *CisConfigInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.CisConfigList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("CisConfigInterfaceMock.ListNamespacedFunc: method is nil but CisConfigInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockCisConfigInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockCisConfigInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedCisConfigInterface.ListNamespacedCalls())
func (mock *CisConfigInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockCisConfigInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockCisConfigInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *CisConfigInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("CisConfigInterfaceMock.ObjectClientFunc: method is nil but CisConfigInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockCisConfigInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockCisConfigInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedCisConfigInterface.ObjectClientCalls())
func (mock *CisConfigInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockCisConfigInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockCisConfigInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *CisConfigInterfaceMock) Update(in1 *v3.CisConfig) (*v3.CisConfig, error) {
	if mock.UpdateFunc == nil {
		panic("CisConfigInterfaceMock.UpdateFunc: method is nil but CisConfigInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.CisConfig
	}{
		In1: in1,
	}
	lockCisConfigInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockCisConfigInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedCisConfigInterface.UpdateCalls())
func (mock *CisConfigInterfaceMock) UpdateCalls() []struct {
	In1 *v3.CisConfig
} {
	var calls []struct {
		In1 *v3.CisConfig
	}
	lockCisConfigInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockCisConfigInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *CisConfigInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("CisConfigInterfaceMock.WatchFunc: method is nil but CisConfigInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockCisConfigInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockCisConfigInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedCisConfigInterface.WatchCalls())
func (mock *CisConfigInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockCisConfigInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockCisConfigInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockCisConfigsGetterMockCisConfigs sync.RWMutex
)

// Ensure, that CisConfigsGetterMock does implement v31.CisConfigsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.CisConfigsGetter = &CisConfigsGetterMock{}

// CisConfigsGetterMock is a mock implementation of v31.CisConfigsGetter.
//
//     func TestSomethingThatUsesCisConfigsGetter(t *testing.T) {
//
//         // make and configure a mocked v31.CisConfigsGetter
//         mockedCisConfigsGetter := &CisConfigsGetterMock{
//             CisConfigsFunc: func(namespace string) v31.CisConfigInterface {
// 	               panic("mock out the CisConfigs method")
//             },
//         }
//
//         // use mockedCisConfigsGetter in code that requires v31.CisConfigsGetter
//         // and then make assertions.
//
//     }
type CisConfigsGetterMock struct {
	// CisConfigsFunc mocks the CisConfigs method.
	CisConfigsFunc func(namespace string) v31.CisConfigInterface

	// calls tracks calls to the methods.
	calls struct {
		// CisConfigs holds details about calls to the CisConfigs method.
		CisConfigs []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// CisConfigs calls CisConfigsFunc.
func (mock *CisConfigsGetterMock) CisConfigs(namespace string) v31.CisConfigInterface {
	if mock.CisConfigsFunc == nil {
		panic("CisConfigsGetterMock.CisConfigsFunc: method is nil but CisConfigsGetter.CisConfigs was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockCisConfigsGetterMockCisConfigs.Lock()
	mock.calls.CisConfigs = append(mock.calls.CisConfigs, callInfo)
	lockCisConfigsGetterMockCisConfigs.Unlock()
	return mock.CisConfigsFunc(namespace)
}

// CisConfigsCalls gets all the calls that were made to CisConfigs.
// Check the length with:
//     len(mockedCisConfigsGetter.CisConfigsCalls())
func (mock *CisConfigsGetterMock) CisConfigsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockCisConfigsGetterMockCisConfigs.RLock()
	calls = mock.calls.CisConfigs
	lockCisConfigsGetterMockCisConfigs.RUnlock()
	return calls
}
