// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockCloudCredentialListerMockGet  sync.RWMutex
	lockCloudCredentialListerMockList sync.RWMutex
)

// Ensure, that CloudCredentialListerMock does implement v31.CloudCredentialLister.
// If this is not the case, regenerate this file with moq.
var _ v31.CloudCredentialLister = &CloudCredentialListerMock{}

// CloudCredentialListerMock is a mock implementation of v31.CloudCredentialLister.
//
//     func TestSomethingThatUsesCloudCredentialLister(t *testing.T) {
//
//         // make and configure a mocked v31.CloudCredentialLister
//         mockedCloudCredentialLister := &CloudCredentialListerMock{
//             GetFunc: func(namespace string, name string) (*v3.CloudCredential, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.CloudCredential, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedCloudCredentialLister in code that requires v31.CloudCredentialLister
//         // and then make assertions.
//
//     }
type CloudCredentialListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.CloudCredential, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.CloudCredential, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *CloudCredentialListerMock) Get(namespace string, name string) (*v3.CloudCredential, error) {
	if mock.GetFunc == nil {
		panic("CloudCredentialListerMock.GetFunc: method is nil but CloudCredentialLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockCloudCredentialListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockCloudCredentialListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedCloudCredentialLister.GetCalls())
func (mock *CloudCredentialListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockCloudCredentialListerMockGet.RLock()
	calls = mock.calls.Get
	lockCloudCredentialListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *CloudCredentialListerMock) List(namespace string, selector labels.Selector) ([]*v3.CloudCredential, error) {
	if mock.ListFunc == nil {
		panic("CloudCredentialListerMock.ListFunc: method is nil but CloudCredentialLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockCloudCredentialListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockCloudCredentialListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedCloudCredentialLister.ListCalls())
func (mock *CloudCredentialListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockCloudCredentialListerMockList.RLock()
	calls = mock.calls.List
	lockCloudCredentialListerMockList.RUnlock()
	return calls
}

var (
	lockCloudCredentialControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockCloudCredentialControllerMockAddClusterScopedHandler        sync.RWMutex
	lockCloudCredentialControllerMockAddFeatureHandler              sync.RWMutex
	lockCloudCredentialControllerMockAddHandler                     sync.RWMutex
	lockCloudCredentialControllerMockEnqueue                        sync.RWMutex
	lockCloudCredentialControllerMockEnqueueAfter                   sync.RWMutex
	lockCloudCredentialControllerMockGeneric                        sync.RWMutex
	lockCloudCredentialControllerMockInformer                       sync.RWMutex
	lockCloudCredentialControllerMockLister                         sync.RWMutex
)

// Ensure, that CloudCredentialControllerMock does implement v31.CloudCredentialController.
// If this is not the case, regenerate this file with moq.
var _ v31.CloudCredentialController = &CloudCredentialControllerMock{}

// CloudCredentialControllerMock is a mock implementation of v31.CloudCredentialController.
//
//     func TestSomethingThatUsesCloudCredentialController(t *testing.T) {
//
//         // make and configure a mocked v31.CloudCredentialController
//         mockedCloudCredentialController := &CloudCredentialControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.CloudCredentialHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.CloudCredentialHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CloudCredentialHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.CloudCredentialHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.CloudCredentialLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedCloudCredentialController in code that requires v31.CloudCredentialController
//         // and then make assertions.
//
//     }
type CloudCredentialControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.CloudCredentialHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.CloudCredentialHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CloudCredentialHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.CloudCredentialHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.CloudCredentialLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.CloudCredentialHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.CloudCredentialHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.CloudCredentialHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.CloudCredentialHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *CloudCredentialControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.CloudCredentialHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("CloudCredentialControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but CloudCredentialController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.CloudCredentialHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockCloudCredentialControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockCloudCredentialControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedCloudCredentialController.AddClusterScopedFeatureHandlerCalls())
func (mock *CloudCredentialControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.CloudCredentialHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.CloudCredentialHandlerFunc
	}
	lockCloudCredentialControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockCloudCredentialControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *CloudCredentialControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.CloudCredentialHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("CloudCredentialControllerMock.AddClusterScopedHandlerFunc: method is nil but CloudCredentialController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.CloudCredentialHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockCloudCredentialControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockCloudCredentialControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedCloudCredentialController.AddClusterScopedHandlerCalls())
func (mock *CloudCredentialControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.CloudCredentialHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.CloudCredentialHandlerFunc
	}
	lockCloudCredentialControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockCloudCredentialControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *CloudCredentialControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CloudCredentialHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("CloudCredentialControllerMock.AddFeatureHandlerFunc: method is nil but CloudCredentialController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.CloudCredentialHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockCloudCredentialControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockCloudCredentialControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedCloudCredentialController.AddFeatureHandlerCalls())
func (mock *CloudCredentialControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.CloudCredentialHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.CloudCredentialHandlerFunc
	}
	lockCloudCredentialControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockCloudCredentialControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *CloudCredentialControllerMock) AddHandler(ctx context.Context, name string, handler v31.CloudCredentialHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("CloudCredentialControllerMock.AddHandlerFunc: method is nil but CloudCredentialController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.CloudCredentialHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockCloudCredentialControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockCloudCredentialControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedCloudCredentialController.AddHandlerCalls())
func (mock *CloudCredentialControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.CloudCredentialHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.CloudCredentialHandlerFunc
	}
	lockCloudCredentialControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockCloudCredentialControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *CloudCredentialControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("CloudCredentialControllerMock.EnqueueFunc: method is nil but CloudCredentialController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockCloudCredentialControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockCloudCredentialControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedCloudCredentialController.EnqueueCalls())
func (mock *CloudCredentialControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockCloudCredentialControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockCloudCredentialControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *CloudCredentialControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("CloudCredentialControllerMock.EnqueueAfterFunc: method is nil but CloudCredentialController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockCloudCredentialControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockCloudCredentialControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedCloudCredentialController.EnqueueAfterCalls())
func (mock *CloudCredentialControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockCloudCredentialControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockCloudCredentialControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *CloudCredentialControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("CloudCredentialControllerMock.GenericFunc: method is nil but CloudCredentialController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockCloudCredentialControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockCloudCredentialControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedCloudCredentialController.GenericCalls())
func (mock *CloudCredentialControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockCloudCredentialControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockCloudCredentialControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *CloudCredentialControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("CloudCredentialControllerMock.InformerFunc: method is nil but CloudCredentialController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockCloudCredentialControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockCloudCredentialControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedCloudCredentialController.InformerCalls())
func (mock *CloudCredentialControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockCloudCredentialControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockCloudCredentialControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *CloudCredentialControllerMock) Lister() v31.CloudCredentialLister {
	if mock.ListerFunc == nil {
		panic("CloudCredentialControllerMock.ListerFunc: method is nil but CloudCredentialController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockCloudCredentialControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockCloudCredentialControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedCloudCredentialController.ListerCalls())
func (mock *CloudCredentialControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockCloudCredentialControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockCloudCredentialControllerMockLister.RUnlock()
	return calls
}

var (
	lockCloudCredentialInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockCloudCredentialInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockCloudCredentialInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockCloudCredentialInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockCloudCredentialInterfaceMockAddFeatureHandler                sync.RWMutex
	lockCloudCredentialInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockCloudCredentialInterfaceMockAddHandler                       sync.RWMutex
	lockCloudCredentialInterfaceMockAddLifecycle                     sync.RWMutex
	lockCloudCredentialInterfaceMockController                       sync.RWMutex
	lockCloudCredentialInterfaceMockCreate                           sync.RWMutex
	lockCloudCredentialInterfaceMockDelete                           sync.RWMutex
	lockCloudCredentialInterfaceMockDeleteCollection                 sync.RWMutex
	lockCloudCredentialInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockCloudCredentialInterfaceMockGet                              sync.RWMutex
	lockCloudCredentialInterfaceMockGetNamespaced                    sync.RWMutex
	lockCloudCredentialInterfaceMockList                             sync.RWMutex
	lockCloudCredentialInterfaceMockListNamespaced                   sync.RWMutex
	lockCloudCredentialInterfaceMockObjectClient                     sync.RWMutex
	lockCloudCredentialInterfaceMockUpdate                           sync.RWMutex
	lockCloudCredentialInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that CloudCredentialInterfaceMock does implement v31.CloudCredentialInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.CloudCredentialInterface = &CloudCredentialInterfaceMock{}

// CloudCredentialInterfaceMock is a mock implementation of v31.CloudCredentialInterface.
//
//     func TestSomethingThatUsesCloudCredentialInterface(t *testing.T) {
//
//         // make and configure a mocked v31.CloudCredentialInterface
//         mockedCloudCredentialInterface := &CloudCredentialInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.CloudCredentialHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.CloudCredentialLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.CloudCredentialHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.CloudCredentialLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CloudCredentialHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.CloudCredentialLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.CloudCredentialHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.CloudCredentialLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.CloudCredentialController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.CloudCredential) (*v3.CloudCredential, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.CloudCredential, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.CloudCredential, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.CloudCredentialList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.CloudCredentialList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.CloudCredential) (*v3.CloudCredential, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedCloudCredentialInterface in code that requires v31.CloudCredentialInterface
//         // and then make assertions.
//
//     }
type CloudCredentialInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.CloudCredentialHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.CloudCredentialLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.CloudCredentialHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.CloudCredentialLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CloudCredentialHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.CloudCredentialLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.CloudCredentialHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.CloudCredentialLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.CloudCredentialController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.CloudCredential) (*v3.CloudCredential, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.CloudCredential, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.CloudCredential, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.CloudCredentialList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.CloudCredentialList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.CloudCredential) (*v3.CloudCredential, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.CloudCredentialHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.CloudCredentialLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.CloudCredentialHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.CloudCredentialLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.CloudCredentialHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.CloudCredentialLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.CloudCredentialHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.CloudCredentialLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.CloudCredential
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.CloudCredential
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *CloudCredentialInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.CloudCredentialHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("CloudCredentialInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but CloudCredentialInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.CloudCredentialHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockCloudCredentialInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockCloudCredentialInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedCloudCredentialInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *CloudCredentialInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.CloudCredentialHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.CloudCredentialHandlerFunc
	}
	lockCloudCredentialInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockCloudCredentialInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *CloudCredentialInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.CloudCredentialLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("CloudCredentialInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but CloudCredentialInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.CloudCredentialLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockCloudCredentialInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockCloudCredentialInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedCloudCredentialInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *CloudCredentialInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.CloudCredentialLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.CloudCredentialLifecycle
	}
	lockCloudCredentialInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockCloudCredentialInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *CloudCredentialInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.CloudCredentialHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("CloudCredentialInterfaceMock.AddClusterScopedHandlerFunc: method is nil but CloudCredentialInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.CloudCredentialHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockCloudCredentialInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockCloudCredentialInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedCloudCredentialInterface.AddClusterScopedHandlerCalls())
func (mock *CloudCredentialInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.CloudCredentialHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.CloudCredentialHandlerFunc
	}
	lockCloudCredentialInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockCloudCredentialInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *CloudCredentialInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.CloudCredentialLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("CloudCredentialInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but CloudCredentialInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.CloudCredentialLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockCloudCredentialInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockCloudCredentialInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedCloudCredentialInterface.AddClusterScopedLifecycleCalls())
func (mock *CloudCredentialInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.CloudCredentialLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.CloudCredentialLifecycle
	}
	lockCloudCredentialInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockCloudCredentialInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *CloudCredentialInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.CloudCredentialHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("CloudCredentialInterfaceMock.AddFeatureHandlerFunc: method is nil but CloudCredentialInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.CloudCredentialHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockCloudCredentialInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockCloudCredentialInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedCloudCredentialInterface.AddFeatureHandlerCalls())
func (mock *CloudCredentialInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.CloudCredentialHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.CloudCredentialHandlerFunc
	}
	lockCloudCredentialInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockCloudCredentialInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *CloudCredentialInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.CloudCredentialLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("CloudCredentialInterfaceMock.AddFeatureLifecycleFunc: method is nil but CloudCredentialInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.CloudCredentialLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockCloudCredentialInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockCloudCredentialInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedCloudCredentialInterface.AddFeatureLifecycleCalls())
func (mock *CloudCredentialInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.CloudCredentialLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.CloudCredentialLifecycle
	}
	lockCloudCredentialInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockCloudCredentialInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *CloudCredentialInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.CloudCredentialHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("CloudCredentialInterfaceMock.AddHandlerFunc: method is nil but CloudCredentialInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.CloudCredentialHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockCloudCredentialInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockCloudCredentialInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedCloudCredentialInterface.AddHandlerCalls())
func (mock *CloudCredentialInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.CloudCredentialHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.CloudCredentialHandlerFunc
	}
	lockCloudCredentialInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockCloudCredentialInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *CloudCredentialInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.CloudCredentialLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("CloudCredentialInterfaceMock.AddLifecycleFunc: method is nil but CloudCredentialInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.CloudCredentialLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockCloudCredentialInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockCloudCredentialInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedCloudCredentialInterface.AddLifecycleCalls())
func (mock *CloudCredentialInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.CloudCredentialLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.CloudCredentialLifecycle
	}
	lockCloudCredentialInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockCloudCredentialInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *CloudCredentialInterfaceMock) Controller() v31.CloudCredentialController {
	if mock.ControllerFunc == nil {
		panic("CloudCredentialInterfaceMock.ControllerFunc: method is nil but CloudCredentialInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockCloudCredentialInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockCloudCredentialInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedCloudCredentialInterface.ControllerCalls())
func (mock *CloudCredentialInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockCloudCredentialInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockCloudCredentialInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *CloudCredentialInterfaceMock) Create(in1 *v3.CloudCredential) (*v3.CloudCredential, error) {
	if mock.CreateFunc == nil {
		panic("CloudCredentialInterfaceMock.CreateFunc: method is nil but CloudCredentialInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.CloudCredential
	}{
		In1: in1,
	}
	lockCloudCredentialInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockCloudCredentialInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedCloudCredentialInterface.CreateCalls())
func (mock *CloudCredentialInterfaceMock) CreateCalls() []struct {
	In1 *v3.CloudCredential
} {
	var calls []struct {
		In1 *v3.CloudCredential
	}
	lockCloudCredentialInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockCloudCredentialInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *CloudCredentialInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("CloudCredentialInterfaceMock.DeleteFunc: method is nil but CloudCredentialInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockCloudCredentialInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockCloudCredentialInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedCloudCredentialInterface.DeleteCalls())
func (mock *CloudCredentialInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockCloudCredentialInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockCloudCredentialInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *CloudCredentialInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("CloudCredentialInterfaceMock.DeleteCollectionFunc: method is nil but CloudCredentialInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockCloudCredentialInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockCloudCredentialInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedCloudCredentialInterface.DeleteCollectionCalls())
func (mock *CloudCredentialInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockCloudCredentialInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockCloudCredentialInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *CloudCredentialInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("CloudCredentialInterfaceMock.DeleteNamespacedFunc: method is nil but CloudCredentialInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockCloudCredentialInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockCloudCredentialInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedCloudCredentialInterface.DeleteNamespacedCalls())
func (mock *CloudCredentialInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockCloudCredentialInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockCloudCredentialInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *CloudCredentialInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.CloudCredential, error) {
	if mock.GetFunc == nil {
		panic("CloudCredentialInterfaceMock.GetFunc: method is nil but CloudCredentialInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockCloudCredentialInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockCloudCredentialInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedCloudCredentialInterface.GetCalls())
func (mock *CloudCredentialInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockCloudCredentialInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockCloudCredentialInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *CloudCredentialInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.CloudCredential, error) {
	if mock.GetNamespacedFunc == nil {
		panic("CloudCredentialInterfaceMock.GetNamespacedFunc: method is nil but CloudCredentialInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockCloudCredentialInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockCloudCredentialInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedCloudCredentialInterface.GetNamespacedCalls())
func (mock *CloudCredentialInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockCloudCredentialInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockCloudCredentialInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *CloudCredentialInterfaceMock) List(opts metav1.ListOptions) (*v3.CloudCredentialList, error) {
	if mock.ListFunc == nil {
		panic("CloudCredentialInterfaceMock.ListFunc: method is nil but CloudCredentialInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockCloudCredentialInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockCloudCredentialInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedCloudCredentialInterface.ListCalls())
func (mock *CloudCredentialInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockCloudCredentialInterfaceMockList.RLock()
	calls = mock.calls.List
	lockCloudCredentialInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *CloudCredentialInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.CloudCredentialList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("CloudCredentialInterfaceMock.ListNamespacedFunc: method is nil but CloudCredentialInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockCloudCredentialInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockCloudCredentialInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedCloudCredentialInterface.ListNamespacedCalls())
func (mock *CloudCredentialInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockCloudCredentialInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockCloudCredentialInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *CloudCredentialInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("CloudCredentialInterfaceMock.ObjectClientFunc: method is nil but CloudCredentialInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockCloudCredentialInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockCloudCredentialInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedCloudCredentialInterface.ObjectClientCalls())
func (mock *CloudCredentialInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockCloudCredentialInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockCloudCredentialInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *CloudCredentialInterfaceMock) Update(in1 *v3.CloudCredential) (*v3.CloudCredential, error) {
	if mock.UpdateFunc == nil {
		panic("CloudCredentialInterfaceMock.UpdateFunc: method is nil but CloudCredentialInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.CloudCredential
	}{
		In1: in1,
	}
	lockCloudCredentialInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockCloudCredentialInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedCloudCredentialInterface.UpdateCalls())
func (mock *CloudCredentialInterfaceMock) UpdateCalls() []struct {
	In1 *v3.CloudCredential
} {
	var calls []struct {
		In1 *v3.CloudCredential
	}
	lockCloudCredentialInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockCloudCredentialInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *CloudCredentialInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("CloudCredentialInterfaceMock.WatchFunc: method is nil but CloudCredentialInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockCloudCredentialInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockCloudCredentialInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedCloudCredentialInterface.WatchCalls())
func (mock *CloudCredentialInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockCloudCredentialInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockCloudCredentialInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockCloudCredentialsGetterMockCloudCredentials sync.RWMutex
)

// Ensure, that CloudCredentialsGetterMock does implement v31.CloudCredentialsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.CloudCredentialsGetter = &CloudCredentialsGetterMock{}

// CloudCredentialsGetterMock is a mock implementation of v31.CloudCredentialsGetter.
//
//     func TestSomethingThatUsesCloudCredentialsGetter(t *testing.T) {
//
//         // make and configure a mocked v31.CloudCredentialsGetter
//         mockedCloudCredentialsGetter := &CloudCredentialsGetterMock{
//             CloudCredentialsFunc: func(namespace string) v31.CloudCredentialInterface {
// 	               panic("mock out the CloudCredentials method")
//             },
//         }
//
//         // use mockedCloudCredentialsGetter in code that requires v31.CloudCredentialsGetter
//         // and then make assertions.
//
//     }
type CloudCredentialsGetterMock struct {
	// CloudCredentialsFunc mocks the CloudCredentials method.
	CloudCredentialsFunc func(namespace string) v31.CloudCredentialInterface

	// calls tracks calls to the methods.
	calls struct {
		// CloudCredentials holds details about calls to the CloudCredentials method.
		CloudCredentials []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// CloudCredentials calls CloudCredentialsFunc.
func (mock *CloudCredentialsGetterMock) CloudCredentials(namespace string) v31.CloudCredentialInterface {
	if mock.CloudCredentialsFunc == nil {
		panic("CloudCredentialsGetterMock.CloudCredentialsFunc: method is nil but CloudCredentialsGetter.CloudCredentials was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockCloudCredentialsGetterMockCloudCredentials.Lock()
	mock.calls.CloudCredentials = append(mock.calls.CloudCredentials, callInfo)
	lockCloudCredentialsGetterMockCloudCredentials.Unlock()
	return mock.CloudCredentialsFunc(namespace)
}

// CloudCredentialsCalls gets all the calls that were made to CloudCredentials.
// Check the length with:
//     len(mockedCloudCredentialsGetter.CloudCredentialsCalls())
func (mock *CloudCredentialsGetterMock) CloudCredentialsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockCloudCredentialsGetterMockCloudCredentials.RLock()
	calls = mock.calls.CloudCredentials
	lockCloudCredentialsGetterMockCloudCredentials.RUnlock()
	return calls
}
