// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockClusterAlertGroupListerMockGet  sync.RWMutex
	lockClusterAlertGroupListerMockList sync.RWMutex
)

// Ensure, that ClusterAlertGroupListerMock does implement v31.ClusterAlertGroupLister.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterAlertGroupLister = &ClusterAlertGroupListerMock{}

// ClusterAlertGroupListerMock is a mock implementation of v31.ClusterAlertGroupLister.
//
//     func TestSomethingThatUsesClusterAlertGroupLister(t *testing.T) {
//
//         // make and configure a mocked v31.ClusterAlertGroupLister
//         mockedClusterAlertGroupLister := &ClusterAlertGroupListerMock{
//             GetFunc: func(namespace string, name string) (*v3.ClusterAlertGroup, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.ClusterAlertGroup, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedClusterAlertGroupLister in code that requires v31.ClusterAlertGroupLister
//         // and then make assertions.
//
//     }
type ClusterAlertGroupListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.ClusterAlertGroup, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.ClusterAlertGroup, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *ClusterAlertGroupListerMock) Get(namespace string, name string) (*v3.ClusterAlertGroup, error) {
	if mock.GetFunc == nil {
		panic("ClusterAlertGroupListerMock.GetFunc: method is nil but ClusterAlertGroupLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockClusterAlertGroupListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockClusterAlertGroupListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedClusterAlertGroupLister.GetCalls())
func (mock *ClusterAlertGroupListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockClusterAlertGroupListerMockGet.RLock()
	calls = mock.calls.Get
	lockClusterAlertGroupListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ClusterAlertGroupListerMock) List(namespace string, selector labels.Selector) ([]*v3.ClusterAlertGroup, error) {
	if mock.ListFunc == nil {
		panic("ClusterAlertGroupListerMock.ListFunc: method is nil but ClusterAlertGroupLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockClusterAlertGroupListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockClusterAlertGroupListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedClusterAlertGroupLister.ListCalls())
func (mock *ClusterAlertGroupListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockClusterAlertGroupListerMockList.RLock()
	calls = mock.calls.List
	lockClusterAlertGroupListerMockList.RUnlock()
	return calls
}

var (
	lockClusterAlertGroupControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockClusterAlertGroupControllerMockAddClusterScopedHandler        sync.RWMutex
	lockClusterAlertGroupControllerMockAddFeatureHandler              sync.RWMutex
	lockClusterAlertGroupControllerMockAddHandler                     sync.RWMutex
	lockClusterAlertGroupControllerMockEnqueue                        sync.RWMutex
	lockClusterAlertGroupControllerMockEnqueueAfter                   sync.RWMutex
	lockClusterAlertGroupControllerMockGeneric                        sync.RWMutex
	lockClusterAlertGroupControllerMockInformer                       sync.RWMutex
	lockClusterAlertGroupControllerMockLister                         sync.RWMutex
)

// Ensure, that ClusterAlertGroupControllerMock does implement v31.ClusterAlertGroupController.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterAlertGroupController = &ClusterAlertGroupControllerMock{}

// ClusterAlertGroupControllerMock is a mock implementation of v31.ClusterAlertGroupController.
//
//     func TestSomethingThatUsesClusterAlertGroupController(t *testing.T) {
//
//         // make and configure a mocked v31.ClusterAlertGroupController
//         mockedClusterAlertGroupController := &ClusterAlertGroupControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ClusterAlertGroupHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.ClusterAlertGroupHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterAlertGroupHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.ClusterAlertGroupHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.ClusterAlertGroupLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedClusterAlertGroupController in code that requires v31.ClusterAlertGroupController
//         // and then make assertions.
//
//     }
type ClusterAlertGroupControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ClusterAlertGroupHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.ClusterAlertGroupHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterAlertGroupHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.ClusterAlertGroupHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.ClusterAlertGroupLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.ClusterAlertGroupHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.ClusterAlertGroupHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ClusterAlertGroupHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.ClusterAlertGroupHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ClusterAlertGroupControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ClusterAlertGroupHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ClusterAlertGroupControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but ClusterAlertGroupController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.ClusterAlertGroupHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockClusterAlertGroupControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockClusterAlertGroupControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedClusterAlertGroupController.AddClusterScopedFeatureHandlerCalls())
func (mock *ClusterAlertGroupControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.ClusterAlertGroupHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.ClusterAlertGroupHandlerFunc
	}
	lockClusterAlertGroupControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockClusterAlertGroupControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ClusterAlertGroupControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.ClusterAlertGroupHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ClusterAlertGroupControllerMock.AddClusterScopedHandlerFunc: method is nil but ClusterAlertGroupController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.ClusterAlertGroupHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockClusterAlertGroupControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockClusterAlertGroupControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedClusterAlertGroupController.AddClusterScopedHandlerCalls())
func (mock *ClusterAlertGroupControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.ClusterAlertGroupHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.ClusterAlertGroupHandlerFunc
	}
	lockClusterAlertGroupControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockClusterAlertGroupControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ClusterAlertGroupControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterAlertGroupHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ClusterAlertGroupControllerMock.AddFeatureHandlerFunc: method is nil but ClusterAlertGroupController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterAlertGroupHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockClusterAlertGroupControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockClusterAlertGroupControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedClusterAlertGroupController.AddFeatureHandlerCalls())
func (mock *ClusterAlertGroupControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.ClusterAlertGroupHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterAlertGroupHandlerFunc
	}
	lockClusterAlertGroupControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockClusterAlertGroupControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ClusterAlertGroupControllerMock) AddHandler(ctx context.Context, name string, handler v31.ClusterAlertGroupHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ClusterAlertGroupControllerMock.AddHandlerFunc: method is nil but ClusterAlertGroupController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.ClusterAlertGroupHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockClusterAlertGroupControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockClusterAlertGroupControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedClusterAlertGroupController.AddHandlerCalls())
func (mock *ClusterAlertGroupControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.ClusterAlertGroupHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.ClusterAlertGroupHandlerFunc
	}
	lockClusterAlertGroupControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockClusterAlertGroupControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *ClusterAlertGroupControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("ClusterAlertGroupControllerMock.EnqueueFunc: method is nil but ClusterAlertGroupController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockClusterAlertGroupControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockClusterAlertGroupControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedClusterAlertGroupController.EnqueueCalls())
func (mock *ClusterAlertGroupControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockClusterAlertGroupControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockClusterAlertGroupControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *ClusterAlertGroupControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("ClusterAlertGroupControllerMock.EnqueueAfterFunc: method is nil but ClusterAlertGroupController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockClusterAlertGroupControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockClusterAlertGroupControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedClusterAlertGroupController.EnqueueAfterCalls())
func (mock *ClusterAlertGroupControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockClusterAlertGroupControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockClusterAlertGroupControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *ClusterAlertGroupControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("ClusterAlertGroupControllerMock.GenericFunc: method is nil but ClusterAlertGroupController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockClusterAlertGroupControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockClusterAlertGroupControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedClusterAlertGroupController.GenericCalls())
func (mock *ClusterAlertGroupControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterAlertGroupControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockClusterAlertGroupControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *ClusterAlertGroupControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("ClusterAlertGroupControllerMock.InformerFunc: method is nil but ClusterAlertGroupController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockClusterAlertGroupControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockClusterAlertGroupControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedClusterAlertGroupController.InformerCalls())
func (mock *ClusterAlertGroupControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterAlertGroupControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockClusterAlertGroupControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *ClusterAlertGroupControllerMock) Lister() v31.ClusterAlertGroupLister {
	if mock.ListerFunc == nil {
		panic("ClusterAlertGroupControllerMock.ListerFunc: method is nil but ClusterAlertGroupController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockClusterAlertGroupControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockClusterAlertGroupControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedClusterAlertGroupController.ListerCalls())
func (mock *ClusterAlertGroupControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterAlertGroupControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockClusterAlertGroupControllerMockLister.RUnlock()
	return calls
}

var (
	lockClusterAlertGroupInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockClusterAlertGroupInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockClusterAlertGroupInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockClusterAlertGroupInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockClusterAlertGroupInterfaceMockAddFeatureHandler                sync.RWMutex
	lockClusterAlertGroupInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockClusterAlertGroupInterfaceMockAddHandler                       sync.RWMutex
	lockClusterAlertGroupInterfaceMockAddLifecycle                     sync.RWMutex
	lockClusterAlertGroupInterfaceMockController                       sync.RWMutex
	lockClusterAlertGroupInterfaceMockCreate                           sync.RWMutex
	lockClusterAlertGroupInterfaceMockDelete                           sync.RWMutex
	lockClusterAlertGroupInterfaceMockDeleteCollection                 sync.RWMutex
	lockClusterAlertGroupInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockClusterAlertGroupInterfaceMockGet                              sync.RWMutex
	lockClusterAlertGroupInterfaceMockGetNamespaced                    sync.RWMutex
	lockClusterAlertGroupInterfaceMockList                             sync.RWMutex
	lockClusterAlertGroupInterfaceMockListNamespaced                   sync.RWMutex
	lockClusterAlertGroupInterfaceMockObjectClient                     sync.RWMutex
	lockClusterAlertGroupInterfaceMockUpdate                           sync.RWMutex
	lockClusterAlertGroupInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that ClusterAlertGroupInterfaceMock does implement v31.ClusterAlertGroupInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterAlertGroupInterface = &ClusterAlertGroupInterfaceMock{}

// ClusterAlertGroupInterfaceMock is a mock implementation of v31.ClusterAlertGroupInterface.
//
//     func TestSomethingThatUsesClusterAlertGroupInterface(t *testing.T) {
//
//         // make and configure a mocked v31.ClusterAlertGroupInterface
//         mockedClusterAlertGroupInterface := &ClusterAlertGroupInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ClusterAlertGroupHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ClusterAlertGroupLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.ClusterAlertGroupHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.ClusterAlertGroupLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterAlertGroupHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.ClusterAlertGroupLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.ClusterAlertGroupHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.ClusterAlertGroupLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.ClusterAlertGroupController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.ClusterAlertGroup) (*v3.ClusterAlertGroup, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.ClusterAlertGroup, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.ClusterAlertGroup, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.ClusterAlertGroupList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.ClusterAlertGroupList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.ClusterAlertGroup) (*v3.ClusterAlertGroup, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedClusterAlertGroupInterface in code that requires v31.ClusterAlertGroupInterface
//         // and then make assertions.
//
//     }
type ClusterAlertGroupInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ClusterAlertGroupHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ClusterAlertGroupLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.ClusterAlertGroupHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.ClusterAlertGroupLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterAlertGroupHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.ClusterAlertGroupLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.ClusterAlertGroupHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.ClusterAlertGroupLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.ClusterAlertGroupController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.ClusterAlertGroup) (*v3.ClusterAlertGroup, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.ClusterAlertGroup, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.ClusterAlertGroup, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.ClusterAlertGroupList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.ClusterAlertGroupList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.ClusterAlertGroup) (*v3.ClusterAlertGroup, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.ClusterAlertGroupHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterAlertGroupLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.ClusterAlertGroupHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterAlertGroupLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ClusterAlertGroupHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterAlertGroupLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ClusterAlertGroupHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterAlertGroupLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.ClusterAlertGroup
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.ClusterAlertGroup
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ClusterAlertGroupInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ClusterAlertGroupHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ClusterAlertGroupInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but ClusterAlertGroupInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.ClusterAlertGroupHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockClusterAlertGroupInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockClusterAlertGroupInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedClusterAlertGroupInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *ClusterAlertGroupInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.ClusterAlertGroupHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.ClusterAlertGroupHandlerFunc
	}
	lockClusterAlertGroupInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockClusterAlertGroupInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *ClusterAlertGroupInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ClusterAlertGroupLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("ClusterAlertGroupInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but ClusterAlertGroupInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterAlertGroupLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockClusterAlertGroupInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockClusterAlertGroupInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedClusterAlertGroupInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *ClusterAlertGroupInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.ClusterAlertGroupLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterAlertGroupLifecycle
	}
	lockClusterAlertGroupInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockClusterAlertGroupInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ClusterAlertGroupInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.ClusterAlertGroupHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ClusterAlertGroupInterfaceMock.AddClusterScopedHandlerFunc: method is nil but ClusterAlertGroupInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.ClusterAlertGroupHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockClusterAlertGroupInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockClusterAlertGroupInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedClusterAlertGroupInterface.AddClusterScopedHandlerCalls())
func (mock *ClusterAlertGroupInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.ClusterAlertGroupHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.ClusterAlertGroupHandlerFunc
	}
	lockClusterAlertGroupInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockClusterAlertGroupInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *ClusterAlertGroupInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.ClusterAlertGroupLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("ClusterAlertGroupInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but ClusterAlertGroupInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterAlertGroupLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockClusterAlertGroupInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockClusterAlertGroupInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedClusterAlertGroupInterface.AddClusterScopedLifecycleCalls())
func (mock *ClusterAlertGroupInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.ClusterAlertGroupLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterAlertGroupLifecycle
	}
	lockClusterAlertGroupInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockClusterAlertGroupInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ClusterAlertGroupInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterAlertGroupHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ClusterAlertGroupInterfaceMock.AddFeatureHandlerFunc: method is nil but ClusterAlertGroupInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterAlertGroupHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockClusterAlertGroupInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockClusterAlertGroupInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedClusterAlertGroupInterface.AddFeatureHandlerCalls())
func (mock *ClusterAlertGroupInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.ClusterAlertGroupHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterAlertGroupHandlerFunc
	}
	lockClusterAlertGroupInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockClusterAlertGroupInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *ClusterAlertGroupInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.ClusterAlertGroupLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("ClusterAlertGroupInterfaceMock.AddFeatureLifecycleFunc: method is nil but ClusterAlertGroupInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.ClusterAlertGroupLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockClusterAlertGroupInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockClusterAlertGroupInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedClusterAlertGroupInterface.AddFeatureLifecycleCalls())
func (mock *ClusterAlertGroupInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.ClusterAlertGroupLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.ClusterAlertGroupLifecycle
	}
	lockClusterAlertGroupInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockClusterAlertGroupInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ClusterAlertGroupInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.ClusterAlertGroupHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ClusterAlertGroupInterfaceMock.AddHandlerFunc: method is nil but ClusterAlertGroupInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.ClusterAlertGroupHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockClusterAlertGroupInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockClusterAlertGroupInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedClusterAlertGroupInterface.AddHandlerCalls())
func (mock *ClusterAlertGroupInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.ClusterAlertGroupHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.ClusterAlertGroupHandlerFunc
	}
	lockClusterAlertGroupInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockClusterAlertGroupInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *ClusterAlertGroupInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.ClusterAlertGroupLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("ClusterAlertGroupInterfaceMock.AddLifecycleFunc: method is nil but ClusterAlertGroupInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.ClusterAlertGroupLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockClusterAlertGroupInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockClusterAlertGroupInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedClusterAlertGroupInterface.AddLifecycleCalls())
func (mock *ClusterAlertGroupInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.ClusterAlertGroupLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.ClusterAlertGroupLifecycle
	}
	lockClusterAlertGroupInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockClusterAlertGroupInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *ClusterAlertGroupInterfaceMock) Controller() v31.ClusterAlertGroupController {
	if mock.ControllerFunc == nil {
		panic("ClusterAlertGroupInterfaceMock.ControllerFunc: method is nil but ClusterAlertGroupInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockClusterAlertGroupInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockClusterAlertGroupInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedClusterAlertGroupInterface.ControllerCalls())
func (mock *ClusterAlertGroupInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterAlertGroupInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockClusterAlertGroupInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *ClusterAlertGroupInterfaceMock) Create(in1 *v3.ClusterAlertGroup) (*v3.ClusterAlertGroup, error) {
	if mock.CreateFunc == nil {
		panic("ClusterAlertGroupInterfaceMock.CreateFunc: method is nil but ClusterAlertGroupInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.ClusterAlertGroup
	}{
		In1: in1,
	}
	lockClusterAlertGroupInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockClusterAlertGroupInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedClusterAlertGroupInterface.CreateCalls())
func (mock *ClusterAlertGroupInterfaceMock) CreateCalls() []struct {
	In1 *v3.ClusterAlertGroup
} {
	var calls []struct {
		In1 *v3.ClusterAlertGroup
	}
	lockClusterAlertGroupInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockClusterAlertGroupInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *ClusterAlertGroupInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("ClusterAlertGroupInterfaceMock.DeleteFunc: method is nil but ClusterAlertGroupInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockClusterAlertGroupInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockClusterAlertGroupInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedClusterAlertGroupInterface.DeleteCalls())
func (mock *ClusterAlertGroupInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockClusterAlertGroupInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockClusterAlertGroupInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *ClusterAlertGroupInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("ClusterAlertGroupInterfaceMock.DeleteCollectionFunc: method is nil but ClusterAlertGroupInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockClusterAlertGroupInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockClusterAlertGroupInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedClusterAlertGroupInterface.DeleteCollectionCalls())
func (mock *ClusterAlertGroupInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockClusterAlertGroupInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockClusterAlertGroupInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *ClusterAlertGroupInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("ClusterAlertGroupInterfaceMock.DeleteNamespacedFunc: method is nil but ClusterAlertGroupInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockClusterAlertGroupInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockClusterAlertGroupInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedClusterAlertGroupInterface.DeleteNamespacedCalls())
func (mock *ClusterAlertGroupInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockClusterAlertGroupInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockClusterAlertGroupInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *ClusterAlertGroupInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.ClusterAlertGroup, error) {
	if mock.GetFunc == nil {
		panic("ClusterAlertGroupInterfaceMock.GetFunc: method is nil but ClusterAlertGroupInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockClusterAlertGroupInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockClusterAlertGroupInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedClusterAlertGroupInterface.GetCalls())
func (mock *ClusterAlertGroupInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockClusterAlertGroupInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockClusterAlertGroupInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *ClusterAlertGroupInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.ClusterAlertGroup, error) {
	if mock.GetNamespacedFunc == nil {
		panic("ClusterAlertGroupInterfaceMock.GetNamespacedFunc: method is nil but ClusterAlertGroupInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockClusterAlertGroupInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockClusterAlertGroupInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedClusterAlertGroupInterface.GetNamespacedCalls())
func (mock *ClusterAlertGroupInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockClusterAlertGroupInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockClusterAlertGroupInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ClusterAlertGroupInterfaceMock) List(opts metav1.ListOptions) (*v3.ClusterAlertGroupList, error) {
	if mock.ListFunc == nil {
		panic("ClusterAlertGroupInterfaceMock.ListFunc: method is nil but ClusterAlertGroupInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockClusterAlertGroupInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockClusterAlertGroupInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedClusterAlertGroupInterface.ListCalls())
func (mock *ClusterAlertGroupInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockClusterAlertGroupInterfaceMockList.RLock()
	calls = mock.calls.List
	lockClusterAlertGroupInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *ClusterAlertGroupInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.ClusterAlertGroupList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("ClusterAlertGroupInterfaceMock.ListNamespacedFunc: method is nil but ClusterAlertGroupInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockClusterAlertGroupInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockClusterAlertGroupInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedClusterAlertGroupInterface.ListNamespacedCalls())
func (mock *ClusterAlertGroupInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockClusterAlertGroupInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockClusterAlertGroupInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *ClusterAlertGroupInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("ClusterAlertGroupInterfaceMock.ObjectClientFunc: method is nil but ClusterAlertGroupInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockClusterAlertGroupInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockClusterAlertGroupInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedClusterAlertGroupInterface.ObjectClientCalls())
func (mock *ClusterAlertGroupInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterAlertGroupInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockClusterAlertGroupInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *ClusterAlertGroupInterfaceMock) Update(in1 *v3.ClusterAlertGroup) (*v3.ClusterAlertGroup, error) {
	if mock.UpdateFunc == nil {
		panic("ClusterAlertGroupInterfaceMock.UpdateFunc: method is nil but ClusterAlertGroupInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.ClusterAlertGroup
	}{
		In1: in1,
	}
	lockClusterAlertGroupInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockClusterAlertGroupInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedClusterAlertGroupInterface.UpdateCalls())
func (mock *ClusterAlertGroupInterfaceMock) UpdateCalls() []struct {
	In1 *v3.ClusterAlertGroup
} {
	var calls []struct {
		In1 *v3.ClusterAlertGroup
	}
	lockClusterAlertGroupInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockClusterAlertGroupInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *ClusterAlertGroupInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("ClusterAlertGroupInterfaceMock.WatchFunc: method is nil but ClusterAlertGroupInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockClusterAlertGroupInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockClusterAlertGroupInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedClusterAlertGroupInterface.WatchCalls())
func (mock *ClusterAlertGroupInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockClusterAlertGroupInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockClusterAlertGroupInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockClusterAlertGroupsGetterMockClusterAlertGroups sync.RWMutex
)

// Ensure, that ClusterAlertGroupsGetterMock does implement v31.ClusterAlertGroupsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterAlertGroupsGetter = &ClusterAlertGroupsGetterMock{}

// ClusterAlertGroupsGetterMock is a mock implementation of v31.ClusterAlertGroupsGetter.
//
//     func TestSomethingThatUsesClusterAlertGroupsGetter(t *testing.T) {
//
//         // make and configure a mocked v31.ClusterAlertGroupsGetter
//         mockedClusterAlertGroupsGetter := &ClusterAlertGroupsGetterMock{
//             ClusterAlertGroupsFunc: func(namespace string) v31.ClusterAlertGroupInterface {
// 	               panic("mock out the ClusterAlertGroups method")
//             },
//         }
//
//         // use mockedClusterAlertGroupsGetter in code that requires v31.ClusterAlertGroupsGetter
//         // and then make assertions.
//
//     }
type ClusterAlertGroupsGetterMock struct {
	// ClusterAlertGroupsFunc mocks the ClusterAlertGroups method.
	ClusterAlertGroupsFunc func(namespace string) v31.ClusterAlertGroupInterface

	// calls tracks calls to the methods.
	calls struct {
		// ClusterAlertGroups holds details about calls to the ClusterAlertGroups method.
		ClusterAlertGroups []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// ClusterAlertGroups calls ClusterAlertGroupsFunc.
func (mock *ClusterAlertGroupsGetterMock) ClusterAlertGroups(namespace string) v31.ClusterAlertGroupInterface {
	if mock.ClusterAlertGroupsFunc == nil {
		panic("ClusterAlertGroupsGetterMock.ClusterAlertGroupsFunc: method is nil but ClusterAlertGroupsGetter.ClusterAlertGroups was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockClusterAlertGroupsGetterMockClusterAlertGroups.Lock()
	mock.calls.ClusterAlertGroups = append(mock.calls.ClusterAlertGroups, callInfo)
	lockClusterAlertGroupsGetterMockClusterAlertGroups.Unlock()
	return mock.ClusterAlertGroupsFunc(namespace)
}

// ClusterAlertGroupsCalls gets all the calls that were made to ClusterAlertGroups.
// Check the length with:
//     len(mockedClusterAlertGroupsGetter.ClusterAlertGroupsCalls())
func (mock *ClusterAlertGroupsGetterMock) ClusterAlertGroupsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockClusterAlertGroupsGetterMockClusterAlertGroups.RLock()
	calls = mock.calls.ClusterAlertGroups
	lockClusterAlertGroupsGetterMockClusterAlertGroups.RUnlock()
	return calls
}
