// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockClusterAlertRuleListerMockGet  sync.RWMutex
	lockClusterAlertRuleListerMockList sync.RWMutex
)

// Ensure, that ClusterAlertRuleListerMock does implement v31.ClusterAlertRuleLister.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterAlertRuleLister = &ClusterAlertRuleListerMock{}

// ClusterAlertRuleListerMock is a mock implementation of v31.ClusterAlertRuleLister.
//
//     func TestSomethingThatUsesClusterAlertRuleLister(t *testing.T) {
//
//         // make and configure a mocked v31.ClusterAlertRuleLister
//         mockedClusterAlertRuleLister := &ClusterAlertRuleListerMock{
//             GetFunc: func(namespace string, name string) (*v3.ClusterAlertRule, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.ClusterAlertRule, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedClusterAlertRuleLister in code that requires v31.ClusterAlertRuleLister
//         // and then make assertions.
//
//     }
type ClusterAlertRuleListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.ClusterAlertRule, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.ClusterAlertRule, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *ClusterAlertRuleListerMock) Get(namespace string, name string) (*v3.ClusterAlertRule, error) {
	if mock.GetFunc == nil {
		panic("ClusterAlertRuleListerMock.GetFunc: method is nil but ClusterAlertRuleLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockClusterAlertRuleListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockClusterAlertRuleListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedClusterAlertRuleLister.GetCalls())
func (mock *ClusterAlertRuleListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockClusterAlertRuleListerMockGet.RLock()
	calls = mock.calls.Get
	lockClusterAlertRuleListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ClusterAlertRuleListerMock) List(namespace string, selector labels.Selector) ([]*v3.ClusterAlertRule, error) {
	if mock.ListFunc == nil {
		panic("ClusterAlertRuleListerMock.ListFunc: method is nil but ClusterAlertRuleLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockClusterAlertRuleListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockClusterAlertRuleListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedClusterAlertRuleLister.ListCalls())
func (mock *ClusterAlertRuleListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockClusterAlertRuleListerMockList.RLock()
	calls = mock.calls.List
	lockClusterAlertRuleListerMockList.RUnlock()
	return calls
}

var (
	lockClusterAlertRuleControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockClusterAlertRuleControllerMockAddClusterScopedHandler        sync.RWMutex
	lockClusterAlertRuleControllerMockAddFeatureHandler              sync.RWMutex
	lockClusterAlertRuleControllerMockAddHandler                     sync.RWMutex
	lockClusterAlertRuleControllerMockEnqueue                        sync.RWMutex
	lockClusterAlertRuleControllerMockEnqueueAfter                   sync.RWMutex
	lockClusterAlertRuleControllerMockGeneric                        sync.RWMutex
	lockClusterAlertRuleControllerMockInformer                       sync.RWMutex
	lockClusterAlertRuleControllerMockLister                         sync.RWMutex
)

// Ensure, that ClusterAlertRuleControllerMock does implement v31.ClusterAlertRuleController.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterAlertRuleController = &ClusterAlertRuleControllerMock{}

// ClusterAlertRuleControllerMock is a mock implementation of v31.ClusterAlertRuleController.
//
//     func TestSomethingThatUsesClusterAlertRuleController(t *testing.T) {
//
//         // make and configure a mocked v31.ClusterAlertRuleController
//         mockedClusterAlertRuleController := &ClusterAlertRuleControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ClusterAlertRuleHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.ClusterAlertRuleHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterAlertRuleHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.ClusterAlertRuleHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.ClusterAlertRuleLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedClusterAlertRuleController in code that requires v31.ClusterAlertRuleController
//         // and then make assertions.
//
//     }
type ClusterAlertRuleControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ClusterAlertRuleHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.ClusterAlertRuleHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterAlertRuleHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.ClusterAlertRuleHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.ClusterAlertRuleLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.ClusterAlertRuleHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.ClusterAlertRuleHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ClusterAlertRuleHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.ClusterAlertRuleHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ClusterAlertRuleControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ClusterAlertRuleHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ClusterAlertRuleControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but ClusterAlertRuleController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.ClusterAlertRuleHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockClusterAlertRuleControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockClusterAlertRuleControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedClusterAlertRuleController.AddClusterScopedFeatureHandlerCalls())
func (mock *ClusterAlertRuleControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.ClusterAlertRuleHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.ClusterAlertRuleHandlerFunc
	}
	lockClusterAlertRuleControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockClusterAlertRuleControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ClusterAlertRuleControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.ClusterAlertRuleHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ClusterAlertRuleControllerMock.AddClusterScopedHandlerFunc: method is nil but ClusterAlertRuleController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.ClusterAlertRuleHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockClusterAlertRuleControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockClusterAlertRuleControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedClusterAlertRuleController.AddClusterScopedHandlerCalls())
func (mock *ClusterAlertRuleControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.ClusterAlertRuleHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.ClusterAlertRuleHandlerFunc
	}
	lockClusterAlertRuleControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockClusterAlertRuleControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ClusterAlertRuleControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterAlertRuleHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ClusterAlertRuleControllerMock.AddFeatureHandlerFunc: method is nil but ClusterAlertRuleController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterAlertRuleHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockClusterAlertRuleControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockClusterAlertRuleControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedClusterAlertRuleController.AddFeatureHandlerCalls())
func (mock *ClusterAlertRuleControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.ClusterAlertRuleHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterAlertRuleHandlerFunc
	}
	lockClusterAlertRuleControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockClusterAlertRuleControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ClusterAlertRuleControllerMock) AddHandler(ctx context.Context, name string, handler v31.ClusterAlertRuleHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ClusterAlertRuleControllerMock.AddHandlerFunc: method is nil but ClusterAlertRuleController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.ClusterAlertRuleHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockClusterAlertRuleControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockClusterAlertRuleControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedClusterAlertRuleController.AddHandlerCalls())
func (mock *ClusterAlertRuleControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.ClusterAlertRuleHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.ClusterAlertRuleHandlerFunc
	}
	lockClusterAlertRuleControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockClusterAlertRuleControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *ClusterAlertRuleControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("ClusterAlertRuleControllerMock.EnqueueFunc: method is nil but ClusterAlertRuleController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockClusterAlertRuleControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockClusterAlertRuleControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedClusterAlertRuleController.EnqueueCalls())
func (mock *ClusterAlertRuleControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockClusterAlertRuleControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockClusterAlertRuleControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *ClusterAlertRuleControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("ClusterAlertRuleControllerMock.EnqueueAfterFunc: method is nil but ClusterAlertRuleController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockClusterAlertRuleControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockClusterAlertRuleControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedClusterAlertRuleController.EnqueueAfterCalls())
func (mock *ClusterAlertRuleControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockClusterAlertRuleControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockClusterAlertRuleControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *ClusterAlertRuleControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("ClusterAlertRuleControllerMock.GenericFunc: method is nil but ClusterAlertRuleController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockClusterAlertRuleControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockClusterAlertRuleControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedClusterAlertRuleController.GenericCalls())
func (mock *ClusterAlertRuleControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterAlertRuleControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockClusterAlertRuleControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *ClusterAlertRuleControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("ClusterAlertRuleControllerMock.InformerFunc: method is nil but ClusterAlertRuleController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockClusterAlertRuleControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockClusterAlertRuleControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedClusterAlertRuleController.InformerCalls())
func (mock *ClusterAlertRuleControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterAlertRuleControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockClusterAlertRuleControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *ClusterAlertRuleControllerMock) Lister() v31.ClusterAlertRuleLister {
	if mock.ListerFunc == nil {
		panic("ClusterAlertRuleControllerMock.ListerFunc: method is nil but ClusterAlertRuleController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockClusterAlertRuleControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockClusterAlertRuleControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedClusterAlertRuleController.ListerCalls())
func (mock *ClusterAlertRuleControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterAlertRuleControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockClusterAlertRuleControllerMockLister.RUnlock()
	return calls
}

var (
	lockClusterAlertRuleInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockClusterAlertRuleInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockClusterAlertRuleInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockClusterAlertRuleInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockClusterAlertRuleInterfaceMockAddFeatureHandler                sync.RWMutex
	lockClusterAlertRuleInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockClusterAlertRuleInterfaceMockAddHandler                       sync.RWMutex
	lockClusterAlertRuleInterfaceMockAddLifecycle                     sync.RWMutex
	lockClusterAlertRuleInterfaceMockController                       sync.RWMutex
	lockClusterAlertRuleInterfaceMockCreate                           sync.RWMutex
	lockClusterAlertRuleInterfaceMockDelete                           sync.RWMutex
	lockClusterAlertRuleInterfaceMockDeleteCollection                 sync.RWMutex
	lockClusterAlertRuleInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockClusterAlertRuleInterfaceMockGet                              sync.RWMutex
	lockClusterAlertRuleInterfaceMockGetNamespaced                    sync.RWMutex
	lockClusterAlertRuleInterfaceMockList                             sync.RWMutex
	lockClusterAlertRuleInterfaceMockListNamespaced                   sync.RWMutex
	lockClusterAlertRuleInterfaceMockObjectClient                     sync.RWMutex
	lockClusterAlertRuleInterfaceMockUpdate                           sync.RWMutex
	lockClusterAlertRuleInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that ClusterAlertRuleInterfaceMock does implement v31.ClusterAlertRuleInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterAlertRuleInterface = &ClusterAlertRuleInterfaceMock{}

// ClusterAlertRuleInterfaceMock is a mock implementation of v31.ClusterAlertRuleInterface.
//
//     func TestSomethingThatUsesClusterAlertRuleInterface(t *testing.T) {
//
//         // make and configure a mocked v31.ClusterAlertRuleInterface
//         mockedClusterAlertRuleInterface := &ClusterAlertRuleInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ClusterAlertRuleHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ClusterAlertRuleLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.ClusterAlertRuleHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.ClusterAlertRuleLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterAlertRuleHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.ClusterAlertRuleLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.ClusterAlertRuleHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.ClusterAlertRuleLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.ClusterAlertRuleController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.ClusterAlertRule) (*v3.ClusterAlertRule, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.ClusterAlertRule, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.ClusterAlertRule, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.ClusterAlertRuleList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.ClusterAlertRuleList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.ClusterAlertRule) (*v3.ClusterAlertRule, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedClusterAlertRuleInterface in code that requires v31.ClusterAlertRuleInterface
//         // and then make assertions.
//
//     }
type ClusterAlertRuleInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ClusterAlertRuleHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ClusterAlertRuleLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.ClusterAlertRuleHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.ClusterAlertRuleLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterAlertRuleHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.ClusterAlertRuleLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.ClusterAlertRuleHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.ClusterAlertRuleLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.ClusterAlertRuleController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.ClusterAlertRule) (*v3.ClusterAlertRule, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.ClusterAlertRule, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.ClusterAlertRule, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.ClusterAlertRuleList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.ClusterAlertRuleList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.ClusterAlertRule) (*v3.ClusterAlertRule, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.ClusterAlertRuleHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterAlertRuleLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.ClusterAlertRuleHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterAlertRuleLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ClusterAlertRuleHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterAlertRuleLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ClusterAlertRuleHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterAlertRuleLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.ClusterAlertRule
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.ClusterAlertRule
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ClusterAlertRuleInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ClusterAlertRuleHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ClusterAlertRuleInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but ClusterAlertRuleInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.ClusterAlertRuleHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockClusterAlertRuleInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockClusterAlertRuleInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedClusterAlertRuleInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *ClusterAlertRuleInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.ClusterAlertRuleHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.ClusterAlertRuleHandlerFunc
	}
	lockClusterAlertRuleInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockClusterAlertRuleInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *ClusterAlertRuleInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ClusterAlertRuleLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("ClusterAlertRuleInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but ClusterAlertRuleInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterAlertRuleLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockClusterAlertRuleInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockClusterAlertRuleInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedClusterAlertRuleInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *ClusterAlertRuleInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.ClusterAlertRuleLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterAlertRuleLifecycle
	}
	lockClusterAlertRuleInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockClusterAlertRuleInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ClusterAlertRuleInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.ClusterAlertRuleHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ClusterAlertRuleInterfaceMock.AddClusterScopedHandlerFunc: method is nil but ClusterAlertRuleInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.ClusterAlertRuleHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockClusterAlertRuleInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockClusterAlertRuleInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedClusterAlertRuleInterface.AddClusterScopedHandlerCalls())
func (mock *ClusterAlertRuleInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.ClusterAlertRuleHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.ClusterAlertRuleHandlerFunc
	}
	lockClusterAlertRuleInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockClusterAlertRuleInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *ClusterAlertRuleInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.ClusterAlertRuleLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("ClusterAlertRuleInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but ClusterAlertRuleInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterAlertRuleLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockClusterAlertRuleInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockClusterAlertRuleInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedClusterAlertRuleInterface.AddClusterScopedLifecycleCalls())
func (mock *ClusterAlertRuleInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.ClusterAlertRuleLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterAlertRuleLifecycle
	}
	lockClusterAlertRuleInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockClusterAlertRuleInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ClusterAlertRuleInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterAlertRuleHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ClusterAlertRuleInterfaceMock.AddFeatureHandlerFunc: method is nil but ClusterAlertRuleInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterAlertRuleHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockClusterAlertRuleInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockClusterAlertRuleInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedClusterAlertRuleInterface.AddFeatureHandlerCalls())
func (mock *ClusterAlertRuleInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.ClusterAlertRuleHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterAlertRuleHandlerFunc
	}
	lockClusterAlertRuleInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockClusterAlertRuleInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *ClusterAlertRuleInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.ClusterAlertRuleLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("ClusterAlertRuleInterfaceMock.AddFeatureLifecycleFunc: method is nil but ClusterAlertRuleInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.ClusterAlertRuleLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockClusterAlertRuleInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockClusterAlertRuleInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedClusterAlertRuleInterface.AddFeatureLifecycleCalls())
func (mock *ClusterAlertRuleInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.ClusterAlertRuleLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.ClusterAlertRuleLifecycle
	}
	lockClusterAlertRuleInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockClusterAlertRuleInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ClusterAlertRuleInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.ClusterAlertRuleHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ClusterAlertRuleInterfaceMock.AddHandlerFunc: method is nil but ClusterAlertRuleInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.ClusterAlertRuleHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockClusterAlertRuleInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockClusterAlertRuleInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedClusterAlertRuleInterface.AddHandlerCalls())
func (mock *ClusterAlertRuleInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.ClusterAlertRuleHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.ClusterAlertRuleHandlerFunc
	}
	lockClusterAlertRuleInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockClusterAlertRuleInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *ClusterAlertRuleInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.ClusterAlertRuleLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("ClusterAlertRuleInterfaceMock.AddLifecycleFunc: method is nil but ClusterAlertRuleInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.ClusterAlertRuleLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockClusterAlertRuleInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockClusterAlertRuleInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedClusterAlertRuleInterface.AddLifecycleCalls())
func (mock *ClusterAlertRuleInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.ClusterAlertRuleLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.ClusterAlertRuleLifecycle
	}
	lockClusterAlertRuleInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockClusterAlertRuleInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *ClusterAlertRuleInterfaceMock) Controller() v31.ClusterAlertRuleController {
	if mock.ControllerFunc == nil {
		panic("ClusterAlertRuleInterfaceMock.ControllerFunc: method is nil but ClusterAlertRuleInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockClusterAlertRuleInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockClusterAlertRuleInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedClusterAlertRuleInterface.ControllerCalls())
func (mock *ClusterAlertRuleInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterAlertRuleInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockClusterAlertRuleInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *ClusterAlertRuleInterfaceMock) Create(in1 *v3.ClusterAlertRule) (*v3.ClusterAlertRule, error) {
	if mock.CreateFunc == nil {
		panic("ClusterAlertRuleInterfaceMock.CreateFunc: method is nil but ClusterAlertRuleInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.ClusterAlertRule
	}{
		In1: in1,
	}
	lockClusterAlertRuleInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockClusterAlertRuleInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedClusterAlertRuleInterface.CreateCalls())
func (mock *ClusterAlertRuleInterfaceMock) CreateCalls() []struct {
	In1 *v3.ClusterAlertRule
} {
	var calls []struct {
		In1 *v3.ClusterAlertRule
	}
	lockClusterAlertRuleInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockClusterAlertRuleInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *ClusterAlertRuleInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("ClusterAlertRuleInterfaceMock.DeleteFunc: method is nil but ClusterAlertRuleInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockClusterAlertRuleInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockClusterAlertRuleInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedClusterAlertRuleInterface.DeleteCalls())
func (mock *ClusterAlertRuleInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockClusterAlertRuleInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockClusterAlertRuleInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *ClusterAlertRuleInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("ClusterAlertRuleInterfaceMock.DeleteCollectionFunc: method is nil but ClusterAlertRuleInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockClusterAlertRuleInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockClusterAlertRuleInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedClusterAlertRuleInterface.DeleteCollectionCalls())
func (mock *ClusterAlertRuleInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockClusterAlertRuleInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockClusterAlertRuleInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *ClusterAlertRuleInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("ClusterAlertRuleInterfaceMock.DeleteNamespacedFunc: method is nil but ClusterAlertRuleInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockClusterAlertRuleInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockClusterAlertRuleInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedClusterAlertRuleInterface.DeleteNamespacedCalls())
func (mock *ClusterAlertRuleInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockClusterAlertRuleInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockClusterAlertRuleInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *ClusterAlertRuleInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.ClusterAlertRule, error) {
	if mock.GetFunc == nil {
		panic("ClusterAlertRuleInterfaceMock.GetFunc: method is nil but ClusterAlertRuleInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockClusterAlertRuleInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockClusterAlertRuleInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedClusterAlertRuleInterface.GetCalls())
func (mock *ClusterAlertRuleInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockClusterAlertRuleInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockClusterAlertRuleInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *ClusterAlertRuleInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.ClusterAlertRule, error) {
	if mock.GetNamespacedFunc == nil {
		panic("ClusterAlertRuleInterfaceMock.GetNamespacedFunc: method is nil but ClusterAlertRuleInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockClusterAlertRuleInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockClusterAlertRuleInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedClusterAlertRuleInterface.GetNamespacedCalls())
func (mock *ClusterAlertRuleInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockClusterAlertRuleInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockClusterAlertRuleInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ClusterAlertRuleInterfaceMock) List(opts metav1.ListOptions) (*v3.ClusterAlertRuleList, error) {
	if mock.ListFunc == nil {
		panic("ClusterAlertRuleInterfaceMock.ListFunc: method is nil but ClusterAlertRuleInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockClusterAlertRuleInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockClusterAlertRuleInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedClusterAlertRuleInterface.ListCalls())
func (mock *ClusterAlertRuleInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockClusterAlertRuleInterfaceMockList.RLock()
	calls = mock.calls.List
	lockClusterAlertRuleInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *ClusterAlertRuleInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.ClusterAlertRuleList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("ClusterAlertRuleInterfaceMock.ListNamespacedFunc: method is nil but ClusterAlertRuleInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockClusterAlertRuleInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockClusterAlertRuleInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedClusterAlertRuleInterface.ListNamespacedCalls())
func (mock *ClusterAlertRuleInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockClusterAlertRuleInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockClusterAlertRuleInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *ClusterAlertRuleInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("ClusterAlertRuleInterfaceMock.ObjectClientFunc: method is nil but ClusterAlertRuleInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockClusterAlertRuleInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockClusterAlertRuleInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedClusterAlertRuleInterface.ObjectClientCalls())
func (mock *ClusterAlertRuleInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterAlertRuleInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockClusterAlertRuleInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *ClusterAlertRuleInterfaceMock) Update(in1 *v3.ClusterAlertRule) (*v3.ClusterAlertRule, error) {
	if mock.UpdateFunc == nil {
		panic("ClusterAlertRuleInterfaceMock.UpdateFunc: method is nil but ClusterAlertRuleInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.ClusterAlertRule
	}{
		In1: in1,
	}
	lockClusterAlertRuleInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockClusterAlertRuleInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedClusterAlertRuleInterface.UpdateCalls())
func (mock *ClusterAlertRuleInterfaceMock) UpdateCalls() []struct {
	In1 *v3.ClusterAlertRule
} {
	var calls []struct {
		In1 *v3.ClusterAlertRule
	}
	lockClusterAlertRuleInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockClusterAlertRuleInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *ClusterAlertRuleInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("ClusterAlertRuleInterfaceMock.WatchFunc: method is nil but ClusterAlertRuleInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockClusterAlertRuleInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockClusterAlertRuleInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedClusterAlertRuleInterface.WatchCalls())
func (mock *ClusterAlertRuleInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockClusterAlertRuleInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockClusterAlertRuleInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockClusterAlertRulesGetterMockClusterAlertRules sync.RWMutex
)

// Ensure, that ClusterAlertRulesGetterMock does implement v31.ClusterAlertRulesGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterAlertRulesGetter = &ClusterAlertRulesGetterMock{}

// ClusterAlertRulesGetterMock is a mock implementation of v31.ClusterAlertRulesGetter.
//
//     func TestSomethingThatUsesClusterAlertRulesGetter(t *testing.T) {
//
//         // make and configure a mocked v31.ClusterAlertRulesGetter
//         mockedClusterAlertRulesGetter := &ClusterAlertRulesGetterMock{
//             ClusterAlertRulesFunc: func(namespace string) v31.ClusterAlertRuleInterface {
// 	               panic("mock out the ClusterAlertRules method")
//             },
//         }
//
//         // use mockedClusterAlertRulesGetter in code that requires v31.ClusterAlertRulesGetter
//         // and then make assertions.
//
//     }
type ClusterAlertRulesGetterMock struct {
	// ClusterAlertRulesFunc mocks the ClusterAlertRules method.
	ClusterAlertRulesFunc func(namespace string) v31.ClusterAlertRuleInterface

	// calls tracks calls to the methods.
	calls struct {
		// ClusterAlertRules holds details about calls to the ClusterAlertRules method.
		ClusterAlertRules []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// ClusterAlertRules calls ClusterAlertRulesFunc.
func (mock *ClusterAlertRulesGetterMock) ClusterAlertRules(namespace string) v31.ClusterAlertRuleInterface {
	if mock.ClusterAlertRulesFunc == nil {
		panic("ClusterAlertRulesGetterMock.ClusterAlertRulesFunc: method is nil but ClusterAlertRulesGetter.ClusterAlertRules was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockClusterAlertRulesGetterMockClusterAlertRules.Lock()
	mock.calls.ClusterAlertRules = append(mock.calls.ClusterAlertRules, callInfo)
	lockClusterAlertRulesGetterMockClusterAlertRules.Unlock()
	return mock.ClusterAlertRulesFunc(namespace)
}

// ClusterAlertRulesCalls gets all the calls that were made to ClusterAlertRules.
// Check the length with:
//     len(mockedClusterAlertRulesGetter.ClusterAlertRulesCalls())
func (mock *ClusterAlertRulesGetterMock) ClusterAlertRulesCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockClusterAlertRulesGetterMockClusterAlertRules.RLock()
	calls = mock.calls.ClusterAlertRules
	lockClusterAlertRulesGetterMockClusterAlertRules.RUnlock()
	return calls
}
