// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockClusterCatalogListerMockGet  sync.RWMutex
	lockClusterCatalogListerMockList sync.RWMutex
)

// Ensure, that ClusterCatalogListerMock does implement v31.ClusterCatalogLister.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterCatalogLister = &ClusterCatalogListerMock{}

// ClusterCatalogListerMock is a mock implementation of v31.ClusterCatalogLister.
//
//     func TestSomethingThatUsesClusterCatalogLister(t *testing.T) {
//
//         // make and configure a mocked v31.ClusterCatalogLister
//         mockedClusterCatalogLister := &ClusterCatalogListerMock{
//             GetFunc: func(namespace string, name string) (*v3.ClusterCatalog, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.ClusterCatalog, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedClusterCatalogLister in code that requires v31.ClusterCatalogLister
//         // and then make assertions.
//
//     }
type ClusterCatalogListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.ClusterCatalog, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.ClusterCatalog, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *ClusterCatalogListerMock) Get(namespace string, name string) (*v3.ClusterCatalog, error) {
	if mock.GetFunc == nil {
		panic("ClusterCatalogListerMock.GetFunc: method is nil but ClusterCatalogLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockClusterCatalogListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockClusterCatalogListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedClusterCatalogLister.GetCalls())
func (mock *ClusterCatalogListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockClusterCatalogListerMockGet.RLock()
	calls = mock.calls.Get
	lockClusterCatalogListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ClusterCatalogListerMock) List(namespace string, selector labels.Selector) ([]*v3.ClusterCatalog, error) {
	if mock.ListFunc == nil {
		panic("ClusterCatalogListerMock.ListFunc: method is nil but ClusterCatalogLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockClusterCatalogListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockClusterCatalogListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedClusterCatalogLister.ListCalls())
func (mock *ClusterCatalogListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockClusterCatalogListerMockList.RLock()
	calls = mock.calls.List
	lockClusterCatalogListerMockList.RUnlock()
	return calls
}

var (
	lockClusterCatalogControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockClusterCatalogControllerMockAddClusterScopedHandler        sync.RWMutex
	lockClusterCatalogControllerMockAddFeatureHandler              sync.RWMutex
	lockClusterCatalogControllerMockAddHandler                     sync.RWMutex
	lockClusterCatalogControllerMockEnqueue                        sync.RWMutex
	lockClusterCatalogControllerMockEnqueueAfter                   sync.RWMutex
	lockClusterCatalogControllerMockGeneric                        sync.RWMutex
	lockClusterCatalogControllerMockInformer                       sync.RWMutex
	lockClusterCatalogControllerMockLister                         sync.RWMutex
)

// Ensure, that ClusterCatalogControllerMock does implement v31.ClusterCatalogController.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterCatalogController = &ClusterCatalogControllerMock{}

// ClusterCatalogControllerMock is a mock implementation of v31.ClusterCatalogController.
//
//     func TestSomethingThatUsesClusterCatalogController(t *testing.T) {
//
//         // make and configure a mocked v31.ClusterCatalogController
//         mockedClusterCatalogController := &ClusterCatalogControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ClusterCatalogHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.ClusterCatalogHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterCatalogHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.ClusterCatalogHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.ClusterCatalogLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedClusterCatalogController in code that requires v31.ClusterCatalogController
//         // and then make assertions.
//
//     }
type ClusterCatalogControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ClusterCatalogHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.ClusterCatalogHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterCatalogHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.ClusterCatalogHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.ClusterCatalogLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.ClusterCatalogHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.ClusterCatalogHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ClusterCatalogHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.ClusterCatalogHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ClusterCatalogControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ClusterCatalogHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ClusterCatalogControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but ClusterCatalogController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.ClusterCatalogHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockClusterCatalogControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockClusterCatalogControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedClusterCatalogController.AddClusterScopedFeatureHandlerCalls())
func (mock *ClusterCatalogControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.ClusterCatalogHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.ClusterCatalogHandlerFunc
	}
	lockClusterCatalogControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockClusterCatalogControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ClusterCatalogControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.ClusterCatalogHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ClusterCatalogControllerMock.AddClusterScopedHandlerFunc: method is nil but ClusterCatalogController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.ClusterCatalogHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockClusterCatalogControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockClusterCatalogControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedClusterCatalogController.AddClusterScopedHandlerCalls())
func (mock *ClusterCatalogControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.ClusterCatalogHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.ClusterCatalogHandlerFunc
	}
	lockClusterCatalogControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockClusterCatalogControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ClusterCatalogControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterCatalogHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ClusterCatalogControllerMock.AddFeatureHandlerFunc: method is nil but ClusterCatalogController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterCatalogHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockClusterCatalogControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockClusterCatalogControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedClusterCatalogController.AddFeatureHandlerCalls())
func (mock *ClusterCatalogControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.ClusterCatalogHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterCatalogHandlerFunc
	}
	lockClusterCatalogControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockClusterCatalogControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ClusterCatalogControllerMock) AddHandler(ctx context.Context, name string, handler v31.ClusterCatalogHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ClusterCatalogControllerMock.AddHandlerFunc: method is nil but ClusterCatalogController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.ClusterCatalogHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockClusterCatalogControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockClusterCatalogControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedClusterCatalogController.AddHandlerCalls())
func (mock *ClusterCatalogControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.ClusterCatalogHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.ClusterCatalogHandlerFunc
	}
	lockClusterCatalogControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockClusterCatalogControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *ClusterCatalogControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("ClusterCatalogControllerMock.EnqueueFunc: method is nil but ClusterCatalogController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockClusterCatalogControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockClusterCatalogControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedClusterCatalogController.EnqueueCalls())
func (mock *ClusterCatalogControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockClusterCatalogControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockClusterCatalogControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *ClusterCatalogControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("ClusterCatalogControllerMock.EnqueueAfterFunc: method is nil but ClusterCatalogController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockClusterCatalogControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockClusterCatalogControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedClusterCatalogController.EnqueueAfterCalls())
func (mock *ClusterCatalogControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockClusterCatalogControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockClusterCatalogControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *ClusterCatalogControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("ClusterCatalogControllerMock.GenericFunc: method is nil but ClusterCatalogController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockClusterCatalogControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockClusterCatalogControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedClusterCatalogController.GenericCalls())
func (mock *ClusterCatalogControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterCatalogControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockClusterCatalogControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *ClusterCatalogControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("ClusterCatalogControllerMock.InformerFunc: method is nil but ClusterCatalogController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockClusterCatalogControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockClusterCatalogControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedClusterCatalogController.InformerCalls())
func (mock *ClusterCatalogControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterCatalogControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockClusterCatalogControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *ClusterCatalogControllerMock) Lister() v31.ClusterCatalogLister {
	if mock.ListerFunc == nil {
		panic("ClusterCatalogControllerMock.ListerFunc: method is nil but ClusterCatalogController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockClusterCatalogControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockClusterCatalogControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedClusterCatalogController.ListerCalls())
func (mock *ClusterCatalogControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterCatalogControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockClusterCatalogControllerMockLister.RUnlock()
	return calls
}

var (
	lockClusterCatalogInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockClusterCatalogInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockClusterCatalogInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockClusterCatalogInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockClusterCatalogInterfaceMockAddFeatureHandler                sync.RWMutex
	lockClusterCatalogInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockClusterCatalogInterfaceMockAddHandler                       sync.RWMutex
	lockClusterCatalogInterfaceMockAddLifecycle                     sync.RWMutex
	lockClusterCatalogInterfaceMockController                       sync.RWMutex
	lockClusterCatalogInterfaceMockCreate                           sync.RWMutex
	lockClusterCatalogInterfaceMockDelete                           sync.RWMutex
	lockClusterCatalogInterfaceMockDeleteCollection                 sync.RWMutex
	lockClusterCatalogInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockClusterCatalogInterfaceMockGet                              sync.RWMutex
	lockClusterCatalogInterfaceMockGetNamespaced                    sync.RWMutex
	lockClusterCatalogInterfaceMockList                             sync.RWMutex
	lockClusterCatalogInterfaceMockListNamespaced                   sync.RWMutex
	lockClusterCatalogInterfaceMockObjectClient                     sync.RWMutex
	lockClusterCatalogInterfaceMockUpdate                           sync.RWMutex
	lockClusterCatalogInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that ClusterCatalogInterfaceMock does implement v31.ClusterCatalogInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterCatalogInterface = &ClusterCatalogInterfaceMock{}

// ClusterCatalogInterfaceMock is a mock implementation of v31.ClusterCatalogInterface.
//
//     func TestSomethingThatUsesClusterCatalogInterface(t *testing.T) {
//
//         // make and configure a mocked v31.ClusterCatalogInterface
//         mockedClusterCatalogInterface := &ClusterCatalogInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ClusterCatalogHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ClusterCatalogLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.ClusterCatalogHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.ClusterCatalogLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterCatalogHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.ClusterCatalogLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.ClusterCatalogHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.ClusterCatalogLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.ClusterCatalogController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.ClusterCatalog) (*v3.ClusterCatalog, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.ClusterCatalog, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.ClusterCatalog, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.ClusterCatalogList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.ClusterCatalogList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.ClusterCatalog) (*v3.ClusterCatalog, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedClusterCatalogInterface in code that requires v31.ClusterCatalogInterface
//         // and then make assertions.
//
//     }
type ClusterCatalogInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ClusterCatalogHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ClusterCatalogLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.ClusterCatalogHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.ClusterCatalogLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterCatalogHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.ClusterCatalogLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.ClusterCatalogHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.ClusterCatalogLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.ClusterCatalogController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.ClusterCatalog) (*v3.ClusterCatalog, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.ClusterCatalog, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.ClusterCatalog, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.ClusterCatalogList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.ClusterCatalogList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.ClusterCatalog) (*v3.ClusterCatalog, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.ClusterCatalogHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterCatalogLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.ClusterCatalogHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterCatalogLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ClusterCatalogHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterCatalogLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ClusterCatalogHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterCatalogLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.ClusterCatalog
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.ClusterCatalog
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ClusterCatalogInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ClusterCatalogHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ClusterCatalogInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but ClusterCatalogInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.ClusterCatalogHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockClusterCatalogInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockClusterCatalogInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedClusterCatalogInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *ClusterCatalogInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.ClusterCatalogHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.ClusterCatalogHandlerFunc
	}
	lockClusterCatalogInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockClusterCatalogInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *ClusterCatalogInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ClusterCatalogLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("ClusterCatalogInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but ClusterCatalogInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterCatalogLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockClusterCatalogInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockClusterCatalogInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedClusterCatalogInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *ClusterCatalogInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.ClusterCatalogLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterCatalogLifecycle
	}
	lockClusterCatalogInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockClusterCatalogInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ClusterCatalogInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.ClusterCatalogHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ClusterCatalogInterfaceMock.AddClusterScopedHandlerFunc: method is nil but ClusterCatalogInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.ClusterCatalogHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockClusterCatalogInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockClusterCatalogInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedClusterCatalogInterface.AddClusterScopedHandlerCalls())
func (mock *ClusterCatalogInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.ClusterCatalogHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.ClusterCatalogHandlerFunc
	}
	lockClusterCatalogInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockClusterCatalogInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *ClusterCatalogInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.ClusterCatalogLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("ClusterCatalogInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but ClusterCatalogInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterCatalogLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockClusterCatalogInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockClusterCatalogInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedClusterCatalogInterface.AddClusterScopedLifecycleCalls())
func (mock *ClusterCatalogInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.ClusterCatalogLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterCatalogLifecycle
	}
	lockClusterCatalogInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockClusterCatalogInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ClusterCatalogInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterCatalogHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ClusterCatalogInterfaceMock.AddFeatureHandlerFunc: method is nil but ClusterCatalogInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterCatalogHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockClusterCatalogInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockClusterCatalogInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedClusterCatalogInterface.AddFeatureHandlerCalls())
func (mock *ClusterCatalogInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.ClusterCatalogHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterCatalogHandlerFunc
	}
	lockClusterCatalogInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockClusterCatalogInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *ClusterCatalogInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.ClusterCatalogLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("ClusterCatalogInterfaceMock.AddFeatureLifecycleFunc: method is nil but ClusterCatalogInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.ClusterCatalogLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockClusterCatalogInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockClusterCatalogInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedClusterCatalogInterface.AddFeatureLifecycleCalls())
func (mock *ClusterCatalogInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.ClusterCatalogLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.ClusterCatalogLifecycle
	}
	lockClusterCatalogInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockClusterCatalogInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ClusterCatalogInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.ClusterCatalogHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ClusterCatalogInterfaceMock.AddHandlerFunc: method is nil but ClusterCatalogInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.ClusterCatalogHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockClusterCatalogInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockClusterCatalogInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedClusterCatalogInterface.AddHandlerCalls())
func (mock *ClusterCatalogInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.ClusterCatalogHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.ClusterCatalogHandlerFunc
	}
	lockClusterCatalogInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockClusterCatalogInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *ClusterCatalogInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.ClusterCatalogLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("ClusterCatalogInterfaceMock.AddLifecycleFunc: method is nil but ClusterCatalogInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.ClusterCatalogLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockClusterCatalogInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockClusterCatalogInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedClusterCatalogInterface.AddLifecycleCalls())
func (mock *ClusterCatalogInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.ClusterCatalogLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.ClusterCatalogLifecycle
	}
	lockClusterCatalogInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockClusterCatalogInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *ClusterCatalogInterfaceMock) Controller() v31.ClusterCatalogController {
	if mock.ControllerFunc == nil {
		panic("ClusterCatalogInterfaceMock.ControllerFunc: method is nil but ClusterCatalogInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockClusterCatalogInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockClusterCatalogInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedClusterCatalogInterface.ControllerCalls())
func (mock *ClusterCatalogInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterCatalogInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockClusterCatalogInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *ClusterCatalogInterfaceMock) Create(in1 *v3.ClusterCatalog) (*v3.ClusterCatalog, error) {
	if mock.CreateFunc == nil {
		panic("ClusterCatalogInterfaceMock.CreateFunc: method is nil but ClusterCatalogInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.ClusterCatalog
	}{
		In1: in1,
	}
	lockClusterCatalogInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockClusterCatalogInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedClusterCatalogInterface.CreateCalls())
func (mock *ClusterCatalogInterfaceMock) CreateCalls() []struct {
	In1 *v3.ClusterCatalog
} {
	var calls []struct {
		In1 *v3.ClusterCatalog
	}
	lockClusterCatalogInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockClusterCatalogInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *ClusterCatalogInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("ClusterCatalogInterfaceMock.DeleteFunc: method is nil but ClusterCatalogInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockClusterCatalogInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockClusterCatalogInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedClusterCatalogInterface.DeleteCalls())
func (mock *ClusterCatalogInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockClusterCatalogInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockClusterCatalogInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *ClusterCatalogInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("ClusterCatalogInterfaceMock.DeleteCollectionFunc: method is nil but ClusterCatalogInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockClusterCatalogInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockClusterCatalogInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedClusterCatalogInterface.DeleteCollectionCalls())
func (mock *ClusterCatalogInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockClusterCatalogInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockClusterCatalogInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *ClusterCatalogInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("ClusterCatalogInterfaceMock.DeleteNamespacedFunc: method is nil but ClusterCatalogInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockClusterCatalogInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockClusterCatalogInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedClusterCatalogInterface.DeleteNamespacedCalls())
func (mock *ClusterCatalogInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockClusterCatalogInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockClusterCatalogInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *ClusterCatalogInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.ClusterCatalog, error) {
	if mock.GetFunc == nil {
		panic("ClusterCatalogInterfaceMock.GetFunc: method is nil but ClusterCatalogInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockClusterCatalogInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockClusterCatalogInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedClusterCatalogInterface.GetCalls())
func (mock *ClusterCatalogInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockClusterCatalogInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockClusterCatalogInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *ClusterCatalogInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.ClusterCatalog, error) {
	if mock.GetNamespacedFunc == nil {
		panic("ClusterCatalogInterfaceMock.GetNamespacedFunc: method is nil but ClusterCatalogInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockClusterCatalogInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockClusterCatalogInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedClusterCatalogInterface.GetNamespacedCalls())
func (mock *ClusterCatalogInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockClusterCatalogInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockClusterCatalogInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ClusterCatalogInterfaceMock) List(opts metav1.ListOptions) (*v3.ClusterCatalogList, error) {
	if mock.ListFunc == nil {
		panic("ClusterCatalogInterfaceMock.ListFunc: method is nil but ClusterCatalogInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockClusterCatalogInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockClusterCatalogInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedClusterCatalogInterface.ListCalls())
func (mock *ClusterCatalogInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockClusterCatalogInterfaceMockList.RLock()
	calls = mock.calls.List
	lockClusterCatalogInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *ClusterCatalogInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.ClusterCatalogList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("ClusterCatalogInterfaceMock.ListNamespacedFunc: method is nil but ClusterCatalogInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockClusterCatalogInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockClusterCatalogInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedClusterCatalogInterface.ListNamespacedCalls())
func (mock *ClusterCatalogInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockClusterCatalogInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockClusterCatalogInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *ClusterCatalogInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("ClusterCatalogInterfaceMock.ObjectClientFunc: method is nil but ClusterCatalogInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockClusterCatalogInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockClusterCatalogInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedClusterCatalogInterface.ObjectClientCalls())
func (mock *ClusterCatalogInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterCatalogInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockClusterCatalogInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *ClusterCatalogInterfaceMock) Update(in1 *v3.ClusterCatalog) (*v3.ClusterCatalog, error) {
	if mock.UpdateFunc == nil {
		panic("ClusterCatalogInterfaceMock.UpdateFunc: method is nil but ClusterCatalogInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.ClusterCatalog
	}{
		In1: in1,
	}
	lockClusterCatalogInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockClusterCatalogInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedClusterCatalogInterface.UpdateCalls())
func (mock *ClusterCatalogInterfaceMock) UpdateCalls() []struct {
	In1 *v3.ClusterCatalog
} {
	var calls []struct {
		In1 *v3.ClusterCatalog
	}
	lockClusterCatalogInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockClusterCatalogInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *ClusterCatalogInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("ClusterCatalogInterfaceMock.WatchFunc: method is nil but ClusterCatalogInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockClusterCatalogInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockClusterCatalogInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedClusterCatalogInterface.WatchCalls())
func (mock *ClusterCatalogInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockClusterCatalogInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockClusterCatalogInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockClusterCatalogsGetterMockClusterCatalogs sync.RWMutex
)

// Ensure, that ClusterCatalogsGetterMock does implement v31.ClusterCatalogsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterCatalogsGetter = &ClusterCatalogsGetterMock{}

// ClusterCatalogsGetterMock is a mock implementation of v31.ClusterCatalogsGetter.
//
//     func TestSomethingThatUsesClusterCatalogsGetter(t *testing.T) {
//
//         // make and configure a mocked v31.ClusterCatalogsGetter
//         mockedClusterCatalogsGetter := &ClusterCatalogsGetterMock{
//             ClusterCatalogsFunc: func(namespace string) v31.ClusterCatalogInterface {
// 	               panic("mock out the ClusterCatalogs method")
//             },
//         }
//
//         // use mockedClusterCatalogsGetter in code that requires v31.ClusterCatalogsGetter
//         // and then make assertions.
//
//     }
type ClusterCatalogsGetterMock struct {
	// ClusterCatalogsFunc mocks the ClusterCatalogs method.
	ClusterCatalogsFunc func(namespace string) v31.ClusterCatalogInterface

	// calls tracks calls to the methods.
	calls struct {
		// ClusterCatalogs holds details about calls to the ClusterCatalogs method.
		ClusterCatalogs []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// ClusterCatalogs calls ClusterCatalogsFunc.
func (mock *ClusterCatalogsGetterMock) ClusterCatalogs(namespace string) v31.ClusterCatalogInterface {
	if mock.ClusterCatalogsFunc == nil {
		panic("ClusterCatalogsGetterMock.ClusterCatalogsFunc: method is nil but ClusterCatalogsGetter.ClusterCatalogs was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockClusterCatalogsGetterMockClusterCatalogs.Lock()
	mock.calls.ClusterCatalogs = append(mock.calls.ClusterCatalogs, callInfo)
	lockClusterCatalogsGetterMockClusterCatalogs.Unlock()
	return mock.ClusterCatalogsFunc(namespace)
}

// ClusterCatalogsCalls gets all the calls that were made to ClusterCatalogs.
// Check the length with:
//     len(mockedClusterCatalogsGetter.ClusterCatalogsCalls())
func (mock *ClusterCatalogsGetterMock) ClusterCatalogsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockClusterCatalogsGetterMockClusterCatalogs.RLock()
	calls = mock.calls.ClusterCatalogs
	lockClusterCatalogsGetterMockClusterCatalogs.RUnlock()
	return calls
}
