// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockClusterLoggingListerMockGet  sync.RWMutex
	lockClusterLoggingListerMockList sync.RWMutex
)

// Ensure, that ClusterLoggingListerMock does implement v31.ClusterLoggingLister.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterLoggingLister = &ClusterLoggingListerMock{}

// ClusterLoggingListerMock is a mock implementation of v31.ClusterLoggingLister.
//
//     func TestSomethingThatUsesClusterLoggingLister(t *testing.T) {
//
//         // make and configure a mocked v31.ClusterLoggingLister
//         mockedClusterLoggingLister := &ClusterLoggingListerMock{
//             GetFunc: func(namespace string, name string) (*v3.ClusterLogging, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.ClusterLogging, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedClusterLoggingLister in code that requires v31.ClusterLoggingLister
//         // and then make assertions.
//
//     }
type ClusterLoggingListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.ClusterLogging, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.ClusterLogging, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *ClusterLoggingListerMock) Get(namespace string, name string) (*v3.ClusterLogging, error) {
	if mock.GetFunc == nil {
		panic("ClusterLoggingListerMock.GetFunc: method is nil but ClusterLoggingLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockClusterLoggingListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockClusterLoggingListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedClusterLoggingLister.GetCalls())
func (mock *ClusterLoggingListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockClusterLoggingListerMockGet.RLock()
	calls = mock.calls.Get
	lockClusterLoggingListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ClusterLoggingListerMock) List(namespace string, selector labels.Selector) ([]*v3.ClusterLogging, error) {
	if mock.ListFunc == nil {
		panic("ClusterLoggingListerMock.ListFunc: method is nil but ClusterLoggingLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockClusterLoggingListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockClusterLoggingListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedClusterLoggingLister.ListCalls())
func (mock *ClusterLoggingListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockClusterLoggingListerMockList.RLock()
	calls = mock.calls.List
	lockClusterLoggingListerMockList.RUnlock()
	return calls
}

var (
	lockClusterLoggingControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockClusterLoggingControllerMockAddClusterScopedHandler        sync.RWMutex
	lockClusterLoggingControllerMockAddFeatureHandler              sync.RWMutex
	lockClusterLoggingControllerMockAddHandler                     sync.RWMutex
	lockClusterLoggingControllerMockEnqueue                        sync.RWMutex
	lockClusterLoggingControllerMockEnqueueAfter                   sync.RWMutex
	lockClusterLoggingControllerMockGeneric                        sync.RWMutex
	lockClusterLoggingControllerMockInformer                       sync.RWMutex
	lockClusterLoggingControllerMockLister                         sync.RWMutex
)

// Ensure, that ClusterLoggingControllerMock does implement v31.ClusterLoggingController.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterLoggingController = &ClusterLoggingControllerMock{}

// ClusterLoggingControllerMock is a mock implementation of v31.ClusterLoggingController.
//
//     func TestSomethingThatUsesClusterLoggingController(t *testing.T) {
//
//         // make and configure a mocked v31.ClusterLoggingController
//         mockedClusterLoggingController := &ClusterLoggingControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ClusterLoggingHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.ClusterLoggingHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterLoggingHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.ClusterLoggingHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.ClusterLoggingLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedClusterLoggingController in code that requires v31.ClusterLoggingController
//         // and then make assertions.
//
//     }
type ClusterLoggingControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ClusterLoggingHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.ClusterLoggingHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterLoggingHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.ClusterLoggingHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.ClusterLoggingLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.ClusterLoggingHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.ClusterLoggingHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ClusterLoggingHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.ClusterLoggingHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ClusterLoggingControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ClusterLoggingHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ClusterLoggingControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but ClusterLoggingController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.ClusterLoggingHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockClusterLoggingControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockClusterLoggingControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedClusterLoggingController.AddClusterScopedFeatureHandlerCalls())
func (mock *ClusterLoggingControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.ClusterLoggingHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.ClusterLoggingHandlerFunc
	}
	lockClusterLoggingControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockClusterLoggingControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ClusterLoggingControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.ClusterLoggingHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ClusterLoggingControllerMock.AddClusterScopedHandlerFunc: method is nil but ClusterLoggingController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.ClusterLoggingHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockClusterLoggingControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockClusterLoggingControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedClusterLoggingController.AddClusterScopedHandlerCalls())
func (mock *ClusterLoggingControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.ClusterLoggingHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.ClusterLoggingHandlerFunc
	}
	lockClusterLoggingControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockClusterLoggingControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ClusterLoggingControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterLoggingHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ClusterLoggingControllerMock.AddFeatureHandlerFunc: method is nil but ClusterLoggingController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterLoggingHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockClusterLoggingControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockClusterLoggingControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedClusterLoggingController.AddFeatureHandlerCalls())
func (mock *ClusterLoggingControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.ClusterLoggingHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterLoggingHandlerFunc
	}
	lockClusterLoggingControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockClusterLoggingControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ClusterLoggingControllerMock) AddHandler(ctx context.Context, name string, handler v31.ClusterLoggingHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ClusterLoggingControllerMock.AddHandlerFunc: method is nil but ClusterLoggingController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.ClusterLoggingHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockClusterLoggingControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockClusterLoggingControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedClusterLoggingController.AddHandlerCalls())
func (mock *ClusterLoggingControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.ClusterLoggingHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.ClusterLoggingHandlerFunc
	}
	lockClusterLoggingControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockClusterLoggingControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *ClusterLoggingControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("ClusterLoggingControllerMock.EnqueueFunc: method is nil but ClusterLoggingController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockClusterLoggingControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockClusterLoggingControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedClusterLoggingController.EnqueueCalls())
func (mock *ClusterLoggingControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockClusterLoggingControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockClusterLoggingControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *ClusterLoggingControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("ClusterLoggingControllerMock.EnqueueAfterFunc: method is nil but ClusterLoggingController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockClusterLoggingControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockClusterLoggingControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedClusterLoggingController.EnqueueAfterCalls())
func (mock *ClusterLoggingControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockClusterLoggingControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockClusterLoggingControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *ClusterLoggingControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("ClusterLoggingControllerMock.GenericFunc: method is nil but ClusterLoggingController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockClusterLoggingControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockClusterLoggingControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedClusterLoggingController.GenericCalls())
func (mock *ClusterLoggingControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterLoggingControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockClusterLoggingControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *ClusterLoggingControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("ClusterLoggingControllerMock.InformerFunc: method is nil but ClusterLoggingController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockClusterLoggingControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockClusterLoggingControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedClusterLoggingController.InformerCalls())
func (mock *ClusterLoggingControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterLoggingControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockClusterLoggingControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *ClusterLoggingControllerMock) Lister() v31.ClusterLoggingLister {
	if mock.ListerFunc == nil {
		panic("ClusterLoggingControllerMock.ListerFunc: method is nil but ClusterLoggingController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockClusterLoggingControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockClusterLoggingControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedClusterLoggingController.ListerCalls())
func (mock *ClusterLoggingControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterLoggingControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockClusterLoggingControllerMockLister.RUnlock()
	return calls
}

var (
	lockClusterLoggingInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockClusterLoggingInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockClusterLoggingInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockClusterLoggingInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockClusterLoggingInterfaceMockAddFeatureHandler                sync.RWMutex
	lockClusterLoggingInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockClusterLoggingInterfaceMockAddHandler                       sync.RWMutex
	lockClusterLoggingInterfaceMockAddLifecycle                     sync.RWMutex
	lockClusterLoggingInterfaceMockController                       sync.RWMutex
	lockClusterLoggingInterfaceMockCreate                           sync.RWMutex
	lockClusterLoggingInterfaceMockDelete                           sync.RWMutex
	lockClusterLoggingInterfaceMockDeleteCollection                 sync.RWMutex
	lockClusterLoggingInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockClusterLoggingInterfaceMockGet                              sync.RWMutex
	lockClusterLoggingInterfaceMockGetNamespaced                    sync.RWMutex
	lockClusterLoggingInterfaceMockList                             sync.RWMutex
	lockClusterLoggingInterfaceMockListNamespaced                   sync.RWMutex
	lockClusterLoggingInterfaceMockObjectClient                     sync.RWMutex
	lockClusterLoggingInterfaceMockUpdate                           sync.RWMutex
	lockClusterLoggingInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that ClusterLoggingInterfaceMock does implement v31.ClusterLoggingInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterLoggingInterface = &ClusterLoggingInterfaceMock{}

// ClusterLoggingInterfaceMock is a mock implementation of v31.ClusterLoggingInterface.
//
//     func TestSomethingThatUsesClusterLoggingInterface(t *testing.T) {
//
//         // make and configure a mocked v31.ClusterLoggingInterface
//         mockedClusterLoggingInterface := &ClusterLoggingInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ClusterLoggingHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ClusterLoggingLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.ClusterLoggingHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.ClusterLoggingLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterLoggingHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.ClusterLoggingLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.ClusterLoggingHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.ClusterLoggingLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.ClusterLoggingController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.ClusterLogging) (*v3.ClusterLogging, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.ClusterLogging, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.ClusterLogging, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.ClusterLoggingList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.ClusterLoggingList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.ClusterLogging) (*v3.ClusterLogging, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedClusterLoggingInterface in code that requires v31.ClusterLoggingInterface
//         // and then make assertions.
//
//     }
type ClusterLoggingInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ClusterLoggingHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ClusterLoggingLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.ClusterLoggingHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.ClusterLoggingLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterLoggingHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.ClusterLoggingLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.ClusterLoggingHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.ClusterLoggingLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.ClusterLoggingController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.ClusterLogging) (*v3.ClusterLogging, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.ClusterLogging, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.ClusterLogging, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.ClusterLoggingList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.ClusterLoggingList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.ClusterLogging) (*v3.ClusterLogging, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.ClusterLoggingHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterLoggingLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.ClusterLoggingHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterLoggingLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ClusterLoggingHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterLoggingLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ClusterLoggingHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterLoggingLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.ClusterLogging
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.ClusterLogging
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ClusterLoggingInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ClusterLoggingHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ClusterLoggingInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but ClusterLoggingInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.ClusterLoggingHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockClusterLoggingInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockClusterLoggingInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedClusterLoggingInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *ClusterLoggingInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.ClusterLoggingHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.ClusterLoggingHandlerFunc
	}
	lockClusterLoggingInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockClusterLoggingInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *ClusterLoggingInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ClusterLoggingLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("ClusterLoggingInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but ClusterLoggingInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterLoggingLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockClusterLoggingInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockClusterLoggingInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedClusterLoggingInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *ClusterLoggingInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.ClusterLoggingLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterLoggingLifecycle
	}
	lockClusterLoggingInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockClusterLoggingInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ClusterLoggingInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.ClusterLoggingHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ClusterLoggingInterfaceMock.AddClusterScopedHandlerFunc: method is nil but ClusterLoggingInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.ClusterLoggingHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockClusterLoggingInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockClusterLoggingInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedClusterLoggingInterface.AddClusterScopedHandlerCalls())
func (mock *ClusterLoggingInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.ClusterLoggingHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.ClusterLoggingHandlerFunc
	}
	lockClusterLoggingInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockClusterLoggingInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *ClusterLoggingInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.ClusterLoggingLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("ClusterLoggingInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but ClusterLoggingInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterLoggingLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockClusterLoggingInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockClusterLoggingInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedClusterLoggingInterface.AddClusterScopedLifecycleCalls())
func (mock *ClusterLoggingInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.ClusterLoggingLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterLoggingLifecycle
	}
	lockClusterLoggingInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockClusterLoggingInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ClusterLoggingInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterLoggingHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ClusterLoggingInterfaceMock.AddFeatureHandlerFunc: method is nil but ClusterLoggingInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterLoggingHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockClusterLoggingInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockClusterLoggingInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedClusterLoggingInterface.AddFeatureHandlerCalls())
func (mock *ClusterLoggingInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.ClusterLoggingHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterLoggingHandlerFunc
	}
	lockClusterLoggingInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockClusterLoggingInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *ClusterLoggingInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.ClusterLoggingLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("ClusterLoggingInterfaceMock.AddFeatureLifecycleFunc: method is nil but ClusterLoggingInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.ClusterLoggingLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockClusterLoggingInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockClusterLoggingInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedClusterLoggingInterface.AddFeatureLifecycleCalls())
func (mock *ClusterLoggingInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.ClusterLoggingLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.ClusterLoggingLifecycle
	}
	lockClusterLoggingInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockClusterLoggingInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ClusterLoggingInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.ClusterLoggingHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ClusterLoggingInterfaceMock.AddHandlerFunc: method is nil but ClusterLoggingInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.ClusterLoggingHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockClusterLoggingInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockClusterLoggingInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedClusterLoggingInterface.AddHandlerCalls())
func (mock *ClusterLoggingInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.ClusterLoggingHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.ClusterLoggingHandlerFunc
	}
	lockClusterLoggingInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockClusterLoggingInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *ClusterLoggingInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.ClusterLoggingLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("ClusterLoggingInterfaceMock.AddLifecycleFunc: method is nil but ClusterLoggingInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.ClusterLoggingLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockClusterLoggingInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockClusterLoggingInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedClusterLoggingInterface.AddLifecycleCalls())
func (mock *ClusterLoggingInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.ClusterLoggingLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.ClusterLoggingLifecycle
	}
	lockClusterLoggingInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockClusterLoggingInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *ClusterLoggingInterfaceMock) Controller() v31.ClusterLoggingController {
	if mock.ControllerFunc == nil {
		panic("ClusterLoggingInterfaceMock.ControllerFunc: method is nil but ClusterLoggingInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockClusterLoggingInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockClusterLoggingInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedClusterLoggingInterface.ControllerCalls())
func (mock *ClusterLoggingInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterLoggingInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockClusterLoggingInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *ClusterLoggingInterfaceMock) Create(in1 *v3.ClusterLogging) (*v3.ClusterLogging, error) {
	if mock.CreateFunc == nil {
		panic("ClusterLoggingInterfaceMock.CreateFunc: method is nil but ClusterLoggingInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.ClusterLogging
	}{
		In1: in1,
	}
	lockClusterLoggingInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockClusterLoggingInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedClusterLoggingInterface.CreateCalls())
func (mock *ClusterLoggingInterfaceMock) CreateCalls() []struct {
	In1 *v3.ClusterLogging
} {
	var calls []struct {
		In1 *v3.ClusterLogging
	}
	lockClusterLoggingInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockClusterLoggingInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *ClusterLoggingInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("ClusterLoggingInterfaceMock.DeleteFunc: method is nil but ClusterLoggingInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockClusterLoggingInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockClusterLoggingInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedClusterLoggingInterface.DeleteCalls())
func (mock *ClusterLoggingInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockClusterLoggingInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockClusterLoggingInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *ClusterLoggingInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("ClusterLoggingInterfaceMock.DeleteCollectionFunc: method is nil but ClusterLoggingInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockClusterLoggingInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockClusterLoggingInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedClusterLoggingInterface.DeleteCollectionCalls())
func (mock *ClusterLoggingInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockClusterLoggingInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockClusterLoggingInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *ClusterLoggingInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("ClusterLoggingInterfaceMock.DeleteNamespacedFunc: method is nil but ClusterLoggingInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockClusterLoggingInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockClusterLoggingInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedClusterLoggingInterface.DeleteNamespacedCalls())
func (mock *ClusterLoggingInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockClusterLoggingInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockClusterLoggingInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *ClusterLoggingInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.ClusterLogging, error) {
	if mock.GetFunc == nil {
		panic("ClusterLoggingInterfaceMock.GetFunc: method is nil but ClusterLoggingInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockClusterLoggingInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockClusterLoggingInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedClusterLoggingInterface.GetCalls())
func (mock *ClusterLoggingInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockClusterLoggingInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockClusterLoggingInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *ClusterLoggingInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.ClusterLogging, error) {
	if mock.GetNamespacedFunc == nil {
		panic("ClusterLoggingInterfaceMock.GetNamespacedFunc: method is nil but ClusterLoggingInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockClusterLoggingInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockClusterLoggingInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedClusterLoggingInterface.GetNamespacedCalls())
func (mock *ClusterLoggingInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockClusterLoggingInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockClusterLoggingInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ClusterLoggingInterfaceMock) List(opts metav1.ListOptions) (*v3.ClusterLoggingList, error) {
	if mock.ListFunc == nil {
		panic("ClusterLoggingInterfaceMock.ListFunc: method is nil but ClusterLoggingInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockClusterLoggingInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockClusterLoggingInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedClusterLoggingInterface.ListCalls())
func (mock *ClusterLoggingInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockClusterLoggingInterfaceMockList.RLock()
	calls = mock.calls.List
	lockClusterLoggingInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *ClusterLoggingInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.ClusterLoggingList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("ClusterLoggingInterfaceMock.ListNamespacedFunc: method is nil but ClusterLoggingInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockClusterLoggingInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockClusterLoggingInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedClusterLoggingInterface.ListNamespacedCalls())
func (mock *ClusterLoggingInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockClusterLoggingInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockClusterLoggingInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *ClusterLoggingInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("ClusterLoggingInterfaceMock.ObjectClientFunc: method is nil but ClusterLoggingInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockClusterLoggingInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockClusterLoggingInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedClusterLoggingInterface.ObjectClientCalls())
func (mock *ClusterLoggingInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterLoggingInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockClusterLoggingInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *ClusterLoggingInterfaceMock) Update(in1 *v3.ClusterLogging) (*v3.ClusterLogging, error) {
	if mock.UpdateFunc == nil {
		panic("ClusterLoggingInterfaceMock.UpdateFunc: method is nil but ClusterLoggingInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.ClusterLogging
	}{
		In1: in1,
	}
	lockClusterLoggingInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockClusterLoggingInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedClusterLoggingInterface.UpdateCalls())
func (mock *ClusterLoggingInterfaceMock) UpdateCalls() []struct {
	In1 *v3.ClusterLogging
} {
	var calls []struct {
		In1 *v3.ClusterLogging
	}
	lockClusterLoggingInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockClusterLoggingInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *ClusterLoggingInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("ClusterLoggingInterfaceMock.WatchFunc: method is nil but ClusterLoggingInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockClusterLoggingInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockClusterLoggingInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedClusterLoggingInterface.WatchCalls())
func (mock *ClusterLoggingInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockClusterLoggingInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockClusterLoggingInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockClusterLoggingsGetterMockClusterLoggings sync.RWMutex
)

// Ensure, that ClusterLoggingsGetterMock does implement v31.ClusterLoggingsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterLoggingsGetter = &ClusterLoggingsGetterMock{}

// ClusterLoggingsGetterMock is a mock implementation of v31.ClusterLoggingsGetter.
//
//     func TestSomethingThatUsesClusterLoggingsGetter(t *testing.T) {
//
//         // make and configure a mocked v31.ClusterLoggingsGetter
//         mockedClusterLoggingsGetter := &ClusterLoggingsGetterMock{
//             ClusterLoggingsFunc: func(namespace string) v31.ClusterLoggingInterface {
// 	               panic("mock out the ClusterLoggings method")
//             },
//         }
//
//         // use mockedClusterLoggingsGetter in code that requires v31.ClusterLoggingsGetter
//         // and then make assertions.
//
//     }
type ClusterLoggingsGetterMock struct {
	// ClusterLoggingsFunc mocks the ClusterLoggings method.
	ClusterLoggingsFunc func(namespace string) v31.ClusterLoggingInterface

	// calls tracks calls to the methods.
	calls struct {
		// ClusterLoggings holds details about calls to the ClusterLoggings method.
		ClusterLoggings []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// ClusterLoggings calls ClusterLoggingsFunc.
func (mock *ClusterLoggingsGetterMock) ClusterLoggings(namespace string) v31.ClusterLoggingInterface {
	if mock.ClusterLoggingsFunc == nil {
		panic("ClusterLoggingsGetterMock.ClusterLoggingsFunc: method is nil but ClusterLoggingsGetter.ClusterLoggings was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockClusterLoggingsGetterMockClusterLoggings.Lock()
	mock.calls.ClusterLoggings = append(mock.calls.ClusterLoggings, callInfo)
	lockClusterLoggingsGetterMockClusterLoggings.Unlock()
	return mock.ClusterLoggingsFunc(namespace)
}

// ClusterLoggingsCalls gets all the calls that were made to ClusterLoggings.
// Check the length with:
//     len(mockedClusterLoggingsGetter.ClusterLoggingsCalls())
func (mock *ClusterLoggingsGetterMock) ClusterLoggingsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockClusterLoggingsGetterMockClusterLoggings.RLock()
	calls = mock.calls.ClusterLoggings
	lockClusterLoggingsGetterMockClusterLoggings.RUnlock()
	return calls
}
