// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockClusterScanListerMockGet  sync.RWMutex
	lockClusterScanListerMockList sync.RWMutex
)

// Ensure, that ClusterScanListerMock does implement v31.ClusterScanLister.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterScanLister = &ClusterScanListerMock{}

// ClusterScanListerMock is a mock implementation of v31.ClusterScanLister.
//
//     func TestSomethingThatUsesClusterScanLister(t *testing.T) {
//
//         // make and configure a mocked v31.ClusterScanLister
//         mockedClusterScanLister := &ClusterScanListerMock{
//             GetFunc: func(namespace string, name string) (*v3.ClusterScan, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.ClusterScan, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedClusterScanLister in code that requires v31.ClusterScanLister
//         // and then make assertions.
//
//     }
type ClusterScanListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.ClusterScan, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.ClusterScan, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *ClusterScanListerMock) Get(namespace string, name string) (*v3.ClusterScan, error) {
	if mock.GetFunc == nil {
		panic("ClusterScanListerMock.GetFunc: method is nil but ClusterScanLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockClusterScanListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockClusterScanListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedClusterScanLister.GetCalls())
func (mock *ClusterScanListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockClusterScanListerMockGet.RLock()
	calls = mock.calls.Get
	lockClusterScanListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ClusterScanListerMock) List(namespace string, selector labels.Selector) ([]*v3.ClusterScan, error) {
	if mock.ListFunc == nil {
		panic("ClusterScanListerMock.ListFunc: method is nil but ClusterScanLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockClusterScanListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockClusterScanListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedClusterScanLister.ListCalls())
func (mock *ClusterScanListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockClusterScanListerMockList.RLock()
	calls = mock.calls.List
	lockClusterScanListerMockList.RUnlock()
	return calls
}

var (
	lockClusterScanControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockClusterScanControllerMockAddClusterScopedHandler        sync.RWMutex
	lockClusterScanControllerMockAddFeatureHandler              sync.RWMutex
	lockClusterScanControllerMockAddHandler                     sync.RWMutex
	lockClusterScanControllerMockEnqueue                        sync.RWMutex
	lockClusterScanControllerMockEnqueueAfter                   sync.RWMutex
	lockClusterScanControllerMockGeneric                        sync.RWMutex
	lockClusterScanControllerMockInformer                       sync.RWMutex
	lockClusterScanControllerMockLister                         sync.RWMutex
)

// Ensure, that ClusterScanControllerMock does implement v31.ClusterScanController.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterScanController = &ClusterScanControllerMock{}

// ClusterScanControllerMock is a mock implementation of v31.ClusterScanController.
//
//     func TestSomethingThatUsesClusterScanController(t *testing.T) {
//
//         // make and configure a mocked v31.ClusterScanController
//         mockedClusterScanController := &ClusterScanControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ClusterScanHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.ClusterScanHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterScanHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.ClusterScanHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.ClusterScanLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedClusterScanController in code that requires v31.ClusterScanController
//         // and then make assertions.
//
//     }
type ClusterScanControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ClusterScanHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.ClusterScanHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterScanHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.ClusterScanHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.ClusterScanLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.ClusterScanHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.ClusterScanHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ClusterScanHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.ClusterScanHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ClusterScanControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ClusterScanHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ClusterScanControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but ClusterScanController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.ClusterScanHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockClusterScanControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockClusterScanControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedClusterScanController.AddClusterScopedFeatureHandlerCalls())
func (mock *ClusterScanControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.ClusterScanHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.ClusterScanHandlerFunc
	}
	lockClusterScanControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockClusterScanControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ClusterScanControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.ClusterScanHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ClusterScanControllerMock.AddClusterScopedHandlerFunc: method is nil but ClusterScanController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.ClusterScanHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockClusterScanControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockClusterScanControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedClusterScanController.AddClusterScopedHandlerCalls())
func (mock *ClusterScanControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.ClusterScanHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.ClusterScanHandlerFunc
	}
	lockClusterScanControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockClusterScanControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ClusterScanControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterScanHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ClusterScanControllerMock.AddFeatureHandlerFunc: method is nil but ClusterScanController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterScanHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockClusterScanControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockClusterScanControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedClusterScanController.AddFeatureHandlerCalls())
func (mock *ClusterScanControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.ClusterScanHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterScanHandlerFunc
	}
	lockClusterScanControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockClusterScanControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ClusterScanControllerMock) AddHandler(ctx context.Context, name string, handler v31.ClusterScanHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ClusterScanControllerMock.AddHandlerFunc: method is nil but ClusterScanController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.ClusterScanHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockClusterScanControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockClusterScanControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedClusterScanController.AddHandlerCalls())
func (mock *ClusterScanControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.ClusterScanHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.ClusterScanHandlerFunc
	}
	lockClusterScanControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockClusterScanControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *ClusterScanControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("ClusterScanControllerMock.EnqueueFunc: method is nil but ClusterScanController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockClusterScanControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockClusterScanControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedClusterScanController.EnqueueCalls())
func (mock *ClusterScanControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockClusterScanControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockClusterScanControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *ClusterScanControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("ClusterScanControllerMock.EnqueueAfterFunc: method is nil but ClusterScanController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockClusterScanControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockClusterScanControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedClusterScanController.EnqueueAfterCalls())
func (mock *ClusterScanControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockClusterScanControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockClusterScanControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *ClusterScanControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("ClusterScanControllerMock.GenericFunc: method is nil but ClusterScanController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockClusterScanControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockClusterScanControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedClusterScanController.GenericCalls())
func (mock *ClusterScanControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterScanControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockClusterScanControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *ClusterScanControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("ClusterScanControllerMock.InformerFunc: method is nil but ClusterScanController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockClusterScanControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockClusterScanControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedClusterScanController.InformerCalls())
func (mock *ClusterScanControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterScanControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockClusterScanControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *ClusterScanControllerMock) Lister() v31.ClusterScanLister {
	if mock.ListerFunc == nil {
		panic("ClusterScanControllerMock.ListerFunc: method is nil but ClusterScanController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockClusterScanControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockClusterScanControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedClusterScanController.ListerCalls())
func (mock *ClusterScanControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterScanControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockClusterScanControllerMockLister.RUnlock()
	return calls
}

var (
	lockClusterScanInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockClusterScanInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockClusterScanInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockClusterScanInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockClusterScanInterfaceMockAddFeatureHandler                sync.RWMutex
	lockClusterScanInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockClusterScanInterfaceMockAddHandler                       sync.RWMutex
	lockClusterScanInterfaceMockAddLifecycle                     sync.RWMutex
	lockClusterScanInterfaceMockController                       sync.RWMutex
	lockClusterScanInterfaceMockCreate                           sync.RWMutex
	lockClusterScanInterfaceMockDelete                           sync.RWMutex
	lockClusterScanInterfaceMockDeleteCollection                 sync.RWMutex
	lockClusterScanInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockClusterScanInterfaceMockGet                              sync.RWMutex
	lockClusterScanInterfaceMockGetNamespaced                    sync.RWMutex
	lockClusterScanInterfaceMockList                             sync.RWMutex
	lockClusterScanInterfaceMockListNamespaced                   sync.RWMutex
	lockClusterScanInterfaceMockObjectClient                     sync.RWMutex
	lockClusterScanInterfaceMockUpdate                           sync.RWMutex
	lockClusterScanInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that ClusterScanInterfaceMock does implement v31.ClusterScanInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterScanInterface = &ClusterScanInterfaceMock{}

// ClusterScanInterfaceMock is a mock implementation of v31.ClusterScanInterface.
//
//     func TestSomethingThatUsesClusterScanInterface(t *testing.T) {
//
//         // make and configure a mocked v31.ClusterScanInterface
//         mockedClusterScanInterface := &ClusterScanInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ClusterScanHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ClusterScanLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.ClusterScanHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.ClusterScanLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterScanHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.ClusterScanLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.ClusterScanHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.ClusterScanLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.ClusterScanController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.ClusterScan) (*v3.ClusterScan, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.ClusterScan, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.ClusterScan, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.ClusterScanList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.ClusterScanList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.ClusterScan) (*v3.ClusterScan, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedClusterScanInterface in code that requires v31.ClusterScanInterface
//         // and then make assertions.
//
//     }
type ClusterScanInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ClusterScanHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ClusterScanLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.ClusterScanHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.ClusterScanLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterScanHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.ClusterScanLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.ClusterScanHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.ClusterScanLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.ClusterScanController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.ClusterScan) (*v3.ClusterScan, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.ClusterScan, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.ClusterScan, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.ClusterScanList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.ClusterScanList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.ClusterScan) (*v3.ClusterScan, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.ClusterScanHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterScanLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.ClusterScanHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterScanLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ClusterScanHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterScanLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ClusterScanHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterScanLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.ClusterScan
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.ClusterScan
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ClusterScanInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ClusterScanHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ClusterScanInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but ClusterScanInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.ClusterScanHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockClusterScanInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockClusterScanInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedClusterScanInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *ClusterScanInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.ClusterScanHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.ClusterScanHandlerFunc
	}
	lockClusterScanInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockClusterScanInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *ClusterScanInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ClusterScanLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("ClusterScanInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but ClusterScanInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterScanLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockClusterScanInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockClusterScanInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedClusterScanInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *ClusterScanInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.ClusterScanLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterScanLifecycle
	}
	lockClusterScanInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockClusterScanInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ClusterScanInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.ClusterScanHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ClusterScanInterfaceMock.AddClusterScopedHandlerFunc: method is nil but ClusterScanInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.ClusterScanHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockClusterScanInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockClusterScanInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedClusterScanInterface.AddClusterScopedHandlerCalls())
func (mock *ClusterScanInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.ClusterScanHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.ClusterScanHandlerFunc
	}
	lockClusterScanInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockClusterScanInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *ClusterScanInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.ClusterScanLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("ClusterScanInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but ClusterScanInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterScanLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockClusterScanInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockClusterScanInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedClusterScanInterface.AddClusterScopedLifecycleCalls())
func (mock *ClusterScanInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.ClusterScanLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterScanLifecycle
	}
	lockClusterScanInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockClusterScanInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ClusterScanInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterScanHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ClusterScanInterfaceMock.AddFeatureHandlerFunc: method is nil but ClusterScanInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterScanHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockClusterScanInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockClusterScanInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedClusterScanInterface.AddFeatureHandlerCalls())
func (mock *ClusterScanInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.ClusterScanHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterScanHandlerFunc
	}
	lockClusterScanInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockClusterScanInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *ClusterScanInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.ClusterScanLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("ClusterScanInterfaceMock.AddFeatureLifecycleFunc: method is nil but ClusterScanInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.ClusterScanLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockClusterScanInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockClusterScanInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedClusterScanInterface.AddFeatureLifecycleCalls())
func (mock *ClusterScanInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.ClusterScanLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.ClusterScanLifecycle
	}
	lockClusterScanInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockClusterScanInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ClusterScanInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.ClusterScanHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ClusterScanInterfaceMock.AddHandlerFunc: method is nil but ClusterScanInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.ClusterScanHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockClusterScanInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockClusterScanInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedClusterScanInterface.AddHandlerCalls())
func (mock *ClusterScanInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.ClusterScanHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.ClusterScanHandlerFunc
	}
	lockClusterScanInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockClusterScanInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *ClusterScanInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.ClusterScanLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("ClusterScanInterfaceMock.AddLifecycleFunc: method is nil but ClusterScanInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.ClusterScanLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockClusterScanInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockClusterScanInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedClusterScanInterface.AddLifecycleCalls())
func (mock *ClusterScanInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.ClusterScanLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.ClusterScanLifecycle
	}
	lockClusterScanInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockClusterScanInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *ClusterScanInterfaceMock) Controller() v31.ClusterScanController {
	if mock.ControllerFunc == nil {
		panic("ClusterScanInterfaceMock.ControllerFunc: method is nil but ClusterScanInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockClusterScanInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockClusterScanInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedClusterScanInterface.ControllerCalls())
func (mock *ClusterScanInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterScanInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockClusterScanInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *ClusterScanInterfaceMock) Create(in1 *v3.ClusterScan) (*v3.ClusterScan, error) {
	if mock.CreateFunc == nil {
		panic("ClusterScanInterfaceMock.CreateFunc: method is nil but ClusterScanInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.ClusterScan
	}{
		In1: in1,
	}
	lockClusterScanInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockClusterScanInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedClusterScanInterface.CreateCalls())
func (mock *ClusterScanInterfaceMock) CreateCalls() []struct {
	In1 *v3.ClusterScan
} {
	var calls []struct {
		In1 *v3.ClusterScan
	}
	lockClusterScanInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockClusterScanInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *ClusterScanInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("ClusterScanInterfaceMock.DeleteFunc: method is nil but ClusterScanInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockClusterScanInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockClusterScanInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedClusterScanInterface.DeleteCalls())
func (mock *ClusterScanInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockClusterScanInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockClusterScanInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *ClusterScanInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("ClusterScanInterfaceMock.DeleteCollectionFunc: method is nil but ClusterScanInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockClusterScanInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockClusterScanInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedClusterScanInterface.DeleteCollectionCalls())
func (mock *ClusterScanInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockClusterScanInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockClusterScanInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *ClusterScanInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("ClusterScanInterfaceMock.DeleteNamespacedFunc: method is nil but ClusterScanInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockClusterScanInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockClusterScanInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedClusterScanInterface.DeleteNamespacedCalls())
func (mock *ClusterScanInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockClusterScanInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockClusterScanInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *ClusterScanInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.ClusterScan, error) {
	if mock.GetFunc == nil {
		panic("ClusterScanInterfaceMock.GetFunc: method is nil but ClusterScanInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockClusterScanInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockClusterScanInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedClusterScanInterface.GetCalls())
func (mock *ClusterScanInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockClusterScanInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockClusterScanInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *ClusterScanInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.ClusterScan, error) {
	if mock.GetNamespacedFunc == nil {
		panic("ClusterScanInterfaceMock.GetNamespacedFunc: method is nil but ClusterScanInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockClusterScanInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockClusterScanInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedClusterScanInterface.GetNamespacedCalls())
func (mock *ClusterScanInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockClusterScanInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockClusterScanInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ClusterScanInterfaceMock) List(opts metav1.ListOptions) (*v3.ClusterScanList, error) {
	if mock.ListFunc == nil {
		panic("ClusterScanInterfaceMock.ListFunc: method is nil but ClusterScanInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockClusterScanInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockClusterScanInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedClusterScanInterface.ListCalls())
func (mock *ClusterScanInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockClusterScanInterfaceMockList.RLock()
	calls = mock.calls.List
	lockClusterScanInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *ClusterScanInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.ClusterScanList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("ClusterScanInterfaceMock.ListNamespacedFunc: method is nil but ClusterScanInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockClusterScanInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockClusterScanInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedClusterScanInterface.ListNamespacedCalls())
func (mock *ClusterScanInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockClusterScanInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockClusterScanInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *ClusterScanInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("ClusterScanInterfaceMock.ObjectClientFunc: method is nil but ClusterScanInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockClusterScanInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockClusterScanInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedClusterScanInterface.ObjectClientCalls())
func (mock *ClusterScanInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterScanInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockClusterScanInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *ClusterScanInterfaceMock) Update(in1 *v3.ClusterScan) (*v3.ClusterScan, error) {
	if mock.UpdateFunc == nil {
		panic("ClusterScanInterfaceMock.UpdateFunc: method is nil but ClusterScanInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.ClusterScan
	}{
		In1: in1,
	}
	lockClusterScanInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockClusterScanInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedClusterScanInterface.UpdateCalls())
func (mock *ClusterScanInterfaceMock) UpdateCalls() []struct {
	In1 *v3.ClusterScan
} {
	var calls []struct {
		In1 *v3.ClusterScan
	}
	lockClusterScanInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockClusterScanInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *ClusterScanInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("ClusterScanInterfaceMock.WatchFunc: method is nil but ClusterScanInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockClusterScanInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockClusterScanInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedClusterScanInterface.WatchCalls())
func (mock *ClusterScanInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockClusterScanInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockClusterScanInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockClusterScansGetterMockClusterScans sync.RWMutex
)

// Ensure, that ClusterScansGetterMock does implement v31.ClusterScansGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterScansGetter = &ClusterScansGetterMock{}

// ClusterScansGetterMock is a mock implementation of v31.ClusterScansGetter.
//
//     func TestSomethingThatUsesClusterScansGetter(t *testing.T) {
//
//         // make and configure a mocked v31.ClusterScansGetter
//         mockedClusterScansGetter := &ClusterScansGetterMock{
//             ClusterScansFunc: func(namespace string) v31.ClusterScanInterface {
// 	               panic("mock out the ClusterScans method")
//             },
//         }
//
//         // use mockedClusterScansGetter in code that requires v31.ClusterScansGetter
//         // and then make assertions.
//
//     }
type ClusterScansGetterMock struct {
	// ClusterScansFunc mocks the ClusterScans method.
	ClusterScansFunc func(namespace string) v31.ClusterScanInterface

	// calls tracks calls to the methods.
	calls struct {
		// ClusterScans holds details about calls to the ClusterScans method.
		ClusterScans []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// ClusterScans calls ClusterScansFunc.
func (mock *ClusterScansGetterMock) ClusterScans(namespace string) v31.ClusterScanInterface {
	if mock.ClusterScansFunc == nil {
		panic("ClusterScansGetterMock.ClusterScansFunc: method is nil but ClusterScansGetter.ClusterScans was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockClusterScansGetterMockClusterScans.Lock()
	mock.calls.ClusterScans = append(mock.calls.ClusterScans, callInfo)
	lockClusterScansGetterMockClusterScans.Unlock()
	return mock.ClusterScansFunc(namespace)
}

// ClusterScansCalls gets all the calls that were made to ClusterScans.
// Check the length with:
//     len(mockedClusterScansGetter.ClusterScansCalls())
func (mock *ClusterScansGetterMock) ClusterScansCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockClusterScansGetterMockClusterScans.RLock()
	calls = mock.calls.ClusterScans
	lockClusterScansGetterMockClusterScans.RUnlock()
	return calls
}
