// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockClusterTemplateListerMockGet  sync.RWMutex
	lockClusterTemplateListerMockList sync.RWMutex
)

// Ensure, that ClusterTemplateListerMock does implement v31.ClusterTemplateLister.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterTemplateLister = &ClusterTemplateListerMock{}

// ClusterTemplateListerMock is a mock implementation of v31.ClusterTemplateLister.
//
//     func TestSomethingThatUsesClusterTemplateLister(t *testing.T) {
//
//         // make and configure a mocked v31.ClusterTemplateLister
//         mockedClusterTemplateLister := &ClusterTemplateListerMock{
//             GetFunc: func(namespace string, name string) (*v3.ClusterTemplate, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.ClusterTemplate, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedClusterTemplateLister in code that requires v31.ClusterTemplateLister
//         // and then make assertions.
//
//     }
type ClusterTemplateListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.ClusterTemplate, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.ClusterTemplate, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *ClusterTemplateListerMock) Get(namespace string, name string) (*v3.ClusterTemplate, error) {
	if mock.GetFunc == nil {
		panic("ClusterTemplateListerMock.GetFunc: method is nil but ClusterTemplateLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockClusterTemplateListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockClusterTemplateListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedClusterTemplateLister.GetCalls())
func (mock *ClusterTemplateListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockClusterTemplateListerMockGet.RLock()
	calls = mock.calls.Get
	lockClusterTemplateListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ClusterTemplateListerMock) List(namespace string, selector labels.Selector) ([]*v3.ClusterTemplate, error) {
	if mock.ListFunc == nil {
		panic("ClusterTemplateListerMock.ListFunc: method is nil but ClusterTemplateLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockClusterTemplateListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockClusterTemplateListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedClusterTemplateLister.ListCalls())
func (mock *ClusterTemplateListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockClusterTemplateListerMockList.RLock()
	calls = mock.calls.List
	lockClusterTemplateListerMockList.RUnlock()
	return calls
}

var (
	lockClusterTemplateControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockClusterTemplateControllerMockAddClusterScopedHandler        sync.RWMutex
	lockClusterTemplateControllerMockAddFeatureHandler              sync.RWMutex
	lockClusterTemplateControllerMockAddHandler                     sync.RWMutex
	lockClusterTemplateControllerMockEnqueue                        sync.RWMutex
	lockClusterTemplateControllerMockEnqueueAfter                   sync.RWMutex
	lockClusterTemplateControllerMockGeneric                        sync.RWMutex
	lockClusterTemplateControllerMockInformer                       sync.RWMutex
	lockClusterTemplateControllerMockLister                         sync.RWMutex
)

// Ensure, that ClusterTemplateControllerMock does implement v31.ClusterTemplateController.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterTemplateController = &ClusterTemplateControllerMock{}

// ClusterTemplateControllerMock is a mock implementation of v31.ClusterTemplateController.
//
//     func TestSomethingThatUsesClusterTemplateController(t *testing.T) {
//
//         // make and configure a mocked v31.ClusterTemplateController
//         mockedClusterTemplateController := &ClusterTemplateControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ClusterTemplateHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.ClusterTemplateHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterTemplateHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.ClusterTemplateHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.ClusterTemplateLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedClusterTemplateController in code that requires v31.ClusterTemplateController
//         // and then make assertions.
//
//     }
type ClusterTemplateControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ClusterTemplateHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.ClusterTemplateHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterTemplateHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.ClusterTemplateHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.ClusterTemplateLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.ClusterTemplateHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.ClusterTemplateHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ClusterTemplateHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.ClusterTemplateHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ClusterTemplateControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ClusterTemplateHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ClusterTemplateControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but ClusterTemplateController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.ClusterTemplateHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockClusterTemplateControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockClusterTemplateControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedClusterTemplateController.AddClusterScopedFeatureHandlerCalls())
func (mock *ClusterTemplateControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.ClusterTemplateHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.ClusterTemplateHandlerFunc
	}
	lockClusterTemplateControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockClusterTemplateControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ClusterTemplateControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.ClusterTemplateHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ClusterTemplateControllerMock.AddClusterScopedHandlerFunc: method is nil but ClusterTemplateController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.ClusterTemplateHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockClusterTemplateControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockClusterTemplateControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedClusterTemplateController.AddClusterScopedHandlerCalls())
func (mock *ClusterTemplateControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.ClusterTemplateHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.ClusterTemplateHandlerFunc
	}
	lockClusterTemplateControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockClusterTemplateControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ClusterTemplateControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterTemplateHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ClusterTemplateControllerMock.AddFeatureHandlerFunc: method is nil but ClusterTemplateController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterTemplateHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockClusterTemplateControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockClusterTemplateControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedClusterTemplateController.AddFeatureHandlerCalls())
func (mock *ClusterTemplateControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.ClusterTemplateHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterTemplateHandlerFunc
	}
	lockClusterTemplateControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockClusterTemplateControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ClusterTemplateControllerMock) AddHandler(ctx context.Context, name string, handler v31.ClusterTemplateHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ClusterTemplateControllerMock.AddHandlerFunc: method is nil but ClusterTemplateController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.ClusterTemplateHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockClusterTemplateControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockClusterTemplateControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedClusterTemplateController.AddHandlerCalls())
func (mock *ClusterTemplateControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.ClusterTemplateHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.ClusterTemplateHandlerFunc
	}
	lockClusterTemplateControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockClusterTemplateControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *ClusterTemplateControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("ClusterTemplateControllerMock.EnqueueFunc: method is nil but ClusterTemplateController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockClusterTemplateControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockClusterTemplateControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedClusterTemplateController.EnqueueCalls())
func (mock *ClusterTemplateControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockClusterTemplateControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockClusterTemplateControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *ClusterTemplateControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("ClusterTemplateControllerMock.EnqueueAfterFunc: method is nil but ClusterTemplateController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockClusterTemplateControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockClusterTemplateControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedClusterTemplateController.EnqueueAfterCalls())
func (mock *ClusterTemplateControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockClusterTemplateControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockClusterTemplateControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *ClusterTemplateControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("ClusterTemplateControllerMock.GenericFunc: method is nil but ClusterTemplateController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockClusterTemplateControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockClusterTemplateControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedClusterTemplateController.GenericCalls())
func (mock *ClusterTemplateControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterTemplateControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockClusterTemplateControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *ClusterTemplateControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("ClusterTemplateControllerMock.InformerFunc: method is nil but ClusterTemplateController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockClusterTemplateControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockClusterTemplateControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedClusterTemplateController.InformerCalls())
func (mock *ClusterTemplateControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterTemplateControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockClusterTemplateControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *ClusterTemplateControllerMock) Lister() v31.ClusterTemplateLister {
	if mock.ListerFunc == nil {
		panic("ClusterTemplateControllerMock.ListerFunc: method is nil but ClusterTemplateController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockClusterTemplateControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockClusterTemplateControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedClusterTemplateController.ListerCalls())
func (mock *ClusterTemplateControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterTemplateControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockClusterTemplateControllerMockLister.RUnlock()
	return calls
}

var (
	lockClusterTemplateInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockClusterTemplateInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockClusterTemplateInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockClusterTemplateInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockClusterTemplateInterfaceMockAddFeatureHandler                sync.RWMutex
	lockClusterTemplateInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockClusterTemplateInterfaceMockAddHandler                       sync.RWMutex
	lockClusterTemplateInterfaceMockAddLifecycle                     sync.RWMutex
	lockClusterTemplateInterfaceMockController                       sync.RWMutex
	lockClusterTemplateInterfaceMockCreate                           sync.RWMutex
	lockClusterTemplateInterfaceMockDelete                           sync.RWMutex
	lockClusterTemplateInterfaceMockDeleteCollection                 sync.RWMutex
	lockClusterTemplateInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockClusterTemplateInterfaceMockGet                              sync.RWMutex
	lockClusterTemplateInterfaceMockGetNamespaced                    sync.RWMutex
	lockClusterTemplateInterfaceMockList                             sync.RWMutex
	lockClusterTemplateInterfaceMockListNamespaced                   sync.RWMutex
	lockClusterTemplateInterfaceMockObjectClient                     sync.RWMutex
	lockClusterTemplateInterfaceMockUpdate                           sync.RWMutex
	lockClusterTemplateInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that ClusterTemplateInterfaceMock does implement v31.ClusterTemplateInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterTemplateInterface = &ClusterTemplateInterfaceMock{}

// ClusterTemplateInterfaceMock is a mock implementation of v31.ClusterTemplateInterface.
//
//     func TestSomethingThatUsesClusterTemplateInterface(t *testing.T) {
//
//         // make and configure a mocked v31.ClusterTemplateInterface
//         mockedClusterTemplateInterface := &ClusterTemplateInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ClusterTemplateHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ClusterTemplateLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.ClusterTemplateHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.ClusterTemplateLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterTemplateHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.ClusterTemplateLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.ClusterTemplateHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.ClusterTemplateLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.ClusterTemplateController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.ClusterTemplate) (*v3.ClusterTemplate, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.ClusterTemplate, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.ClusterTemplate, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.ClusterTemplateList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.ClusterTemplateList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.ClusterTemplate) (*v3.ClusterTemplate, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedClusterTemplateInterface in code that requires v31.ClusterTemplateInterface
//         // and then make assertions.
//
//     }
type ClusterTemplateInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ClusterTemplateHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ClusterTemplateLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.ClusterTemplateHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.ClusterTemplateLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterTemplateHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.ClusterTemplateLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.ClusterTemplateHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.ClusterTemplateLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.ClusterTemplateController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.ClusterTemplate) (*v3.ClusterTemplate, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.ClusterTemplate, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.ClusterTemplate, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.ClusterTemplateList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.ClusterTemplateList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.ClusterTemplate) (*v3.ClusterTemplate, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.ClusterTemplateHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterTemplateLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.ClusterTemplateHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterTemplateLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ClusterTemplateHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterTemplateLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ClusterTemplateHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ClusterTemplateLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.ClusterTemplate
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.ClusterTemplate
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ClusterTemplateInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ClusterTemplateHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ClusterTemplateInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but ClusterTemplateInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.ClusterTemplateHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockClusterTemplateInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockClusterTemplateInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedClusterTemplateInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *ClusterTemplateInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.ClusterTemplateHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.ClusterTemplateHandlerFunc
	}
	lockClusterTemplateInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockClusterTemplateInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *ClusterTemplateInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ClusterTemplateLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("ClusterTemplateInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but ClusterTemplateInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterTemplateLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockClusterTemplateInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockClusterTemplateInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedClusterTemplateInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *ClusterTemplateInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.ClusterTemplateLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterTemplateLifecycle
	}
	lockClusterTemplateInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockClusterTemplateInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ClusterTemplateInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.ClusterTemplateHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ClusterTemplateInterfaceMock.AddClusterScopedHandlerFunc: method is nil but ClusterTemplateInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.ClusterTemplateHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockClusterTemplateInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockClusterTemplateInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedClusterTemplateInterface.AddClusterScopedHandlerCalls())
func (mock *ClusterTemplateInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.ClusterTemplateHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.ClusterTemplateHandlerFunc
	}
	lockClusterTemplateInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockClusterTemplateInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *ClusterTemplateInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.ClusterTemplateLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("ClusterTemplateInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but ClusterTemplateInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterTemplateLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockClusterTemplateInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockClusterTemplateInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedClusterTemplateInterface.AddClusterScopedLifecycleCalls())
func (mock *ClusterTemplateInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.ClusterTemplateLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.ClusterTemplateLifecycle
	}
	lockClusterTemplateInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockClusterTemplateInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ClusterTemplateInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ClusterTemplateHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ClusterTemplateInterfaceMock.AddFeatureHandlerFunc: method is nil but ClusterTemplateInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterTemplateHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockClusterTemplateInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockClusterTemplateInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedClusterTemplateInterface.AddFeatureHandlerCalls())
func (mock *ClusterTemplateInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.ClusterTemplateHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ClusterTemplateHandlerFunc
	}
	lockClusterTemplateInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockClusterTemplateInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *ClusterTemplateInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.ClusterTemplateLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("ClusterTemplateInterfaceMock.AddFeatureLifecycleFunc: method is nil but ClusterTemplateInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.ClusterTemplateLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockClusterTemplateInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockClusterTemplateInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedClusterTemplateInterface.AddFeatureLifecycleCalls())
func (mock *ClusterTemplateInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.ClusterTemplateLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.ClusterTemplateLifecycle
	}
	lockClusterTemplateInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockClusterTemplateInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ClusterTemplateInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.ClusterTemplateHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ClusterTemplateInterfaceMock.AddHandlerFunc: method is nil but ClusterTemplateInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.ClusterTemplateHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockClusterTemplateInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockClusterTemplateInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedClusterTemplateInterface.AddHandlerCalls())
func (mock *ClusterTemplateInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.ClusterTemplateHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.ClusterTemplateHandlerFunc
	}
	lockClusterTemplateInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockClusterTemplateInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *ClusterTemplateInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.ClusterTemplateLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("ClusterTemplateInterfaceMock.AddLifecycleFunc: method is nil but ClusterTemplateInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.ClusterTemplateLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockClusterTemplateInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockClusterTemplateInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedClusterTemplateInterface.AddLifecycleCalls())
func (mock *ClusterTemplateInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.ClusterTemplateLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.ClusterTemplateLifecycle
	}
	lockClusterTemplateInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockClusterTemplateInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *ClusterTemplateInterfaceMock) Controller() v31.ClusterTemplateController {
	if mock.ControllerFunc == nil {
		panic("ClusterTemplateInterfaceMock.ControllerFunc: method is nil but ClusterTemplateInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockClusterTemplateInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockClusterTemplateInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedClusterTemplateInterface.ControllerCalls())
func (mock *ClusterTemplateInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterTemplateInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockClusterTemplateInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *ClusterTemplateInterfaceMock) Create(in1 *v3.ClusterTemplate) (*v3.ClusterTemplate, error) {
	if mock.CreateFunc == nil {
		panic("ClusterTemplateInterfaceMock.CreateFunc: method is nil but ClusterTemplateInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.ClusterTemplate
	}{
		In1: in1,
	}
	lockClusterTemplateInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockClusterTemplateInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedClusterTemplateInterface.CreateCalls())
func (mock *ClusterTemplateInterfaceMock) CreateCalls() []struct {
	In1 *v3.ClusterTemplate
} {
	var calls []struct {
		In1 *v3.ClusterTemplate
	}
	lockClusterTemplateInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockClusterTemplateInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *ClusterTemplateInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("ClusterTemplateInterfaceMock.DeleteFunc: method is nil but ClusterTemplateInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockClusterTemplateInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockClusterTemplateInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedClusterTemplateInterface.DeleteCalls())
func (mock *ClusterTemplateInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockClusterTemplateInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockClusterTemplateInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *ClusterTemplateInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("ClusterTemplateInterfaceMock.DeleteCollectionFunc: method is nil but ClusterTemplateInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockClusterTemplateInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockClusterTemplateInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedClusterTemplateInterface.DeleteCollectionCalls())
func (mock *ClusterTemplateInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockClusterTemplateInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockClusterTemplateInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *ClusterTemplateInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("ClusterTemplateInterfaceMock.DeleteNamespacedFunc: method is nil but ClusterTemplateInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockClusterTemplateInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockClusterTemplateInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedClusterTemplateInterface.DeleteNamespacedCalls())
func (mock *ClusterTemplateInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockClusterTemplateInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockClusterTemplateInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *ClusterTemplateInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.ClusterTemplate, error) {
	if mock.GetFunc == nil {
		panic("ClusterTemplateInterfaceMock.GetFunc: method is nil but ClusterTemplateInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockClusterTemplateInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockClusterTemplateInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedClusterTemplateInterface.GetCalls())
func (mock *ClusterTemplateInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockClusterTemplateInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockClusterTemplateInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *ClusterTemplateInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.ClusterTemplate, error) {
	if mock.GetNamespacedFunc == nil {
		panic("ClusterTemplateInterfaceMock.GetNamespacedFunc: method is nil but ClusterTemplateInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockClusterTemplateInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockClusterTemplateInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedClusterTemplateInterface.GetNamespacedCalls())
func (mock *ClusterTemplateInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockClusterTemplateInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockClusterTemplateInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ClusterTemplateInterfaceMock) List(opts metav1.ListOptions) (*v3.ClusterTemplateList, error) {
	if mock.ListFunc == nil {
		panic("ClusterTemplateInterfaceMock.ListFunc: method is nil but ClusterTemplateInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockClusterTemplateInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockClusterTemplateInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedClusterTemplateInterface.ListCalls())
func (mock *ClusterTemplateInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockClusterTemplateInterfaceMockList.RLock()
	calls = mock.calls.List
	lockClusterTemplateInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *ClusterTemplateInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.ClusterTemplateList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("ClusterTemplateInterfaceMock.ListNamespacedFunc: method is nil but ClusterTemplateInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockClusterTemplateInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockClusterTemplateInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedClusterTemplateInterface.ListNamespacedCalls())
func (mock *ClusterTemplateInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockClusterTemplateInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockClusterTemplateInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *ClusterTemplateInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("ClusterTemplateInterfaceMock.ObjectClientFunc: method is nil but ClusterTemplateInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockClusterTemplateInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockClusterTemplateInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedClusterTemplateInterface.ObjectClientCalls())
func (mock *ClusterTemplateInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockClusterTemplateInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockClusterTemplateInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *ClusterTemplateInterfaceMock) Update(in1 *v3.ClusterTemplate) (*v3.ClusterTemplate, error) {
	if mock.UpdateFunc == nil {
		panic("ClusterTemplateInterfaceMock.UpdateFunc: method is nil but ClusterTemplateInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.ClusterTemplate
	}{
		In1: in1,
	}
	lockClusterTemplateInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockClusterTemplateInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedClusterTemplateInterface.UpdateCalls())
func (mock *ClusterTemplateInterfaceMock) UpdateCalls() []struct {
	In1 *v3.ClusterTemplate
} {
	var calls []struct {
		In1 *v3.ClusterTemplate
	}
	lockClusterTemplateInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockClusterTemplateInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *ClusterTemplateInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("ClusterTemplateInterfaceMock.WatchFunc: method is nil but ClusterTemplateInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockClusterTemplateInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockClusterTemplateInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedClusterTemplateInterface.WatchCalls())
func (mock *ClusterTemplateInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockClusterTemplateInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockClusterTemplateInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockClusterTemplatesGetterMockClusterTemplates sync.RWMutex
)

// Ensure, that ClusterTemplatesGetterMock does implement v31.ClusterTemplatesGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.ClusterTemplatesGetter = &ClusterTemplatesGetterMock{}

// ClusterTemplatesGetterMock is a mock implementation of v31.ClusterTemplatesGetter.
//
//     func TestSomethingThatUsesClusterTemplatesGetter(t *testing.T) {
//
//         // make and configure a mocked v31.ClusterTemplatesGetter
//         mockedClusterTemplatesGetter := &ClusterTemplatesGetterMock{
//             ClusterTemplatesFunc: func(namespace string) v31.ClusterTemplateInterface {
// 	               panic("mock out the ClusterTemplates method")
//             },
//         }
//
//         // use mockedClusterTemplatesGetter in code that requires v31.ClusterTemplatesGetter
//         // and then make assertions.
//
//     }
type ClusterTemplatesGetterMock struct {
	// ClusterTemplatesFunc mocks the ClusterTemplates method.
	ClusterTemplatesFunc func(namespace string) v31.ClusterTemplateInterface

	// calls tracks calls to the methods.
	calls struct {
		// ClusterTemplates holds details about calls to the ClusterTemplates method.
		ClusterTemplates []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// ClusterTemplates calls ClusterTemplatesFunc.
func (mock *ClusterTemplatesGetterMock) ClusterTemplates(namespace string) v31.ClusterTemplateInterface {
	if mock.ClusterTemplatesFunc == nil {
		panic("ClusterTemplatesGetterMock.ClusterTemplatesFunc: method is nil but ClusterTemplatesGetter.ClusterTemplates was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockClusterTemplatesGetterMockClusterTemplates.Lock()
	mock.calls.ClusterTemplates = append(mock.calls.ClusterTemplates, callInfo)
	lockClusterTemplatesGetterMockClusterTemplates.Unlock()
	return mock.ClusterTemplatesFunc(namespace)
}

// ClusterTemplatesCalls gets all the calls that were made to ClusterTemplates.
// Check the length with:
//     len(mockedClusterTemplatesGetter.ClusterTemplatesCalls())
func (mock *ClusterTemplatesGetterMock) ClusterTemplatesCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockClusterTemplatesGetterMockClusterTemplates.RLock()
	calls = mock.calls.ClusterTemplates
	lockClusterTemplatesGetterMockClusterTemplates.RUnlock()
	return calls
}
