// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockComposeConfigListerMockGet  sync.RWMutex
	lockComposeConfigListerMockList sync.RWMutex
)

// Ensure, that ComposeConfigListerMock does implement v31.ComposeConfigLister.
// If this is not the case, regenerate this file with moq.
var _ v31.ComposeConfigLister = &ComposeConfigListerMock{}

// ComposeConfigListerMock is a mock implementation of v31.ComposeConfigLister.
//
//     func TestSomethingThatUsesComposeConfigLister(t *testing.T) {
//
//         // make and configure a mocked v31.ComposeConfigLister
//         mockedComposeConfigLister := &ComposeConfigListerMock{
//             GetFunc: func(namespace string, name string) (*v3.ComposeConfig, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.ComposeConfig, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedComposeConfigLister in code that requires v31.ComposeConfigLister
//         // and then make assertions.
//
//     }
type ComposeConfigListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.ComposeConfig, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.ComposeConfig, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *ComposeConfigListerMock) Get(namespace string, name string) (*v3.ComposeConfig, error) {
	if mock.GetFunc == nil {
		panic("ComposeConfigListerMock.GetFunc: method is nil but ComposeConfigLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockComposeConfigListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockComposeConfigListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedComposeConfigLister.GetCalls())
func (mock *ComposeConfigListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockComposeConfigListerMockGet.RLock()
	calls = mock.calls.Get
	lockComposeConfigListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ComposeConfigListerMock) List(namespace string, selector labels.Selector) ([]*v3.ComposeConfig, error) {
	if mock.ListFunc == nil {
		panic("ComposeConfigListerMock.ListFunc: method is nil but ComposeConfigLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockComposeConfigListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockComposeConfigListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedComposeConfigLister.ListCalls())
func (mock *ComposeConfigListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockComposeConfigListerMockList.RLock()
	calls = mock.calls.List
	lockComposeConfigListerMockList.RUnlock()
	return calls
}

var (
	lockComposeConfigControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockComposeConfigControllerMockAddClusterScopedHandler        sync.RWMutex
	lockComposeConfigControllerMockAddFeatureHandler              sync.RWMutex
	lockComposeConfigControllerMockAddHandler                     sync.RWMutex
	lockComposeConfigControllerMockEnqueue                        sync.RWMutex
	lockComposeConfigControllerMockEnqueueAfter                   sync.RWMutex
	lockComposeConfigControllerMockGeneric                        sync.RWMutex
	lockComposeConfigControllerMockInformer                       sync.RWMutex
	lockComposeConfigControllerMockLister                         sync.RWMutex
)

// Ensure, that ComposeConfigControllerMock does implement v31.ComposeConfigController.
// If this is not the case, regenerate this file with moq.
var _ v31.ComposeConfigController = &ComposeConfigControllerMock{}

// ComposeConfigControllerMock is a mock implementation of v31.ComposeConfigController.
//
//     func TestSomethingThatUsesComposeConfigController(t *testing.T) {
//
//         // make and configure a mocked v31.ComposeConfigController
//         mockedComposeConfigController := &ComposeConfigControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ComposeConfigHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.ComposeConfigHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ComposeConfigHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.ComposeConfigHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.ComposeConfigLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedComposeConfigController in code that requires v31.ComposeConfigController
//         // and then make assertions.
//
//     }
type ComposeConfigControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ComposeConfigHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.ComposeConfigHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ComposeConfigHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.ComposeConfigHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.ComposeConfigLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.ComposeConfigHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.ComposeConfigHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ComposeConfigHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.ComposeConfigHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ComposeConfigControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ComposeConfigHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ComposeConfigControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but ComposeConfigController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.ComposeConfigHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockComposeConfigControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockComposeConfigControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedComposeConfigController.AddClusterScopedFeatureHandlerCalls())
func (mock *ComposeConfigControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.ComposeConfigHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.ComposeConfigHandlerFunc
	}
	lockComposeConfigControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockComposeConfigControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ComposeConfigControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.ComposeConfigHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ComposeConfigControllerMock.AddClusterScopedHandlerFunc: method is nil but ComposeConfigController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.ComposeConfigHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockComposeConfigControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockComposeConfigControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedComposeConfigController.AddClusterScopedHandlerCalls())
func (mock *ComposeConfigControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.ComposeConfigHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.ComposeConfigHandlerFunc
	}
	lockComposeConfigControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockComposeConfigControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ComposeConfigControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ComposeConfigHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ComposeConfigControllerMock.AddFeatureHandlerFunc: method is nil but ComposeConfigController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ComposeConfigHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockComposeConfigControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockComposeConfigControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedComposeConfigController.AddFeatureHandlerCalls())
func (mock *ComposeConfigControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.ComposeConfigHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ComposeConfigHandlerFunc
	}
	lockComposeConfigControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockComposeConfigControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ComposeConfigControllerMock) AddHandler(ctx context.Context, name string, handler v31.ComposeConfigHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ComposeConfigControllerMock.AddHandlerFunc: method is nil but ComposeConfigController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.ComposeConfigHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockComposeConfigControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockComposeConfigControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedComposeConfigController.AddHandlerCalls())
func (mock *ComposeConfigControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.ComposeConfigHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.ComposeConfigHandlerFunc
	}
	lockComposeConfigControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockComposeConfigControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *ComposeConfigControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("ComposeConfigControllerMock.EnqueueFunc: method is nil but ComposeConfigController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockComposeConfigControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockComposeConfigControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedComposeConfigController.EnqueueCalls())
func (mock *ComposeConfigControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockComposeConfigControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockComposeConfigControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *ComposeConfigControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("ComposeConfigControllerMock.EnqueueAfterFunc: method is nil but ComposeConfigController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockComposeConfigControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockComposeConfigControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedComposeConfigController.EnqueueAfterCalls())
func (mock *ComposeConfigControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockComposeConfigControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockComposeConfigControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *ComposeConfigControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("ComposeConfigControllerMock.GenericFunc: method is nil but ComposeConfigController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockComposeConfigControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockComposeConfigControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedComposeConfigController.GenericCalls())
func (mock *ComposeConfigControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockComposeConfigControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockComposeConfigControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *ComposeConfigControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("ComposeConfigControllerMock.InformerFunc: method is nil but ComposeConfigController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockComposeConfigControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockComposeConfigControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedComposeConfigController.InformerCalls())
func (mock *ComposeConfigControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockComposeConfigControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockComposeConfigControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *ComposeConfigControllerMock) Lister() v31.ComposeConfigLister {
	if mock.ListerFunc == nil {
		panic("ComposeConfigControllerMock.ListerFunc: method is nil but ComposeConfigController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockComposeConfigControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockComposeConfigControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedComposeConfigController.ListerCalls())
func (mock *ComposeConfigControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockComposeConfigControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockComposeConfigControllerMockLister.RUnlock()
	return calls
}

var (
	lockComposeConfigInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockComposeConfigInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockComposeConfigInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockComposeConfigInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockComposeConfigInterfaceMockAddFeatureHandler                sync.RWMutex
	lockComposeConfigInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockComposeConfigInterfaceMockAddHandler                       sync.RWMutex
	lockComposeConfigInterfaceMockAddLifecycle                     sync.RWMutex
	lockComposeConfigInterfaceMockController                       sync.RWMutex
	lockComposeConfigInterfaceMockCreate                           sync.RWMutex
	lockComposeConfigInterfaceMockDelete                           sync.RWMutex
	lockComposeConfigInterfaceMockDeleteCollection                 sync.RWMutex
	lockComposeConfigInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockComposeConfigInterfaceMockGet                              sync.RWMutex
	lockComposeConfigInterfaceMockGetNamespaced                    sync.RWMutex
	lockComposeConfigInterfaceMockList                             sync.RWMutex
	lockComposeConfigInterfaceMockListNamespaced                   sync.RWMutex
	lockComposeConfigInterfaceMockObjectClient                     sync.RWMutex
	lockComposeConfigInterfaceMockUpdate                           sync.RWMutex
	lockComposeConfigInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that ComposeConfigInterfaceMock does implement v31.ComposeConfigInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.ComposeConfigInterface = &ComposeConfigInterfaceMock{}

// ComposeConfigInterfaceMock is a mock implementation of v31.ComposeConfigInterface.
//
//     func TestSomethingThatUsesComposeConfigInterface(t *testing.T) {
//
//         // make and configure a mocked v31.ComposeConfigInterface
//         mockedComposeConfigInterface := &ComposeConfigInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ComposeConfigHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ComposeConfigLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.ComposeConfigHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.ComposeConfigLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ComposeConfigHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.ComposeConfigLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.ComposeConfigHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.ComposeConfigLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.ComposeConfigController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.ComposeConfig) (*v3.ComposeConfig, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.ComposeConfig, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.ComposeConfig, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.ComposeConfigList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.ComposeConfigList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.ComposeConfig) (*v3.ComposeConfig, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedComposeConfigInterface in code that requires v31.ComposeConfigInterface
//         // and then make assertions.
//
//     }
type ComposeConfigInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ComposeConfigHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ComposeConfigLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.ComposeConfigHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.ComposeConfigLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ComposeConfigHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.ComposeConfigLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.ComposeConfigHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.ComposeConfigLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.ComposeConfigController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.ComposeConfig) (*v3.ComposeConfig, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.ComposeConfig, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.ComposeConfig, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.ComposeConfigList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.ComposeConfigList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.ComposeConfig) (*v3.ComposeConfig, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.ComposeConfigHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ComposeConfigLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.ComposeConfigHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ComposeConfigLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ComposeConfigHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ComposeConfigLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ComposeConfigHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ComposeConfigLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.ComposeConfig
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.ComposeConfig
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ComposeConfigInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ComposeConfigHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ComposeConfigInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but ComposeConfigInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.ComposeConfigHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockComposeConfigInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockComposeConfigInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedComposeConfigInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *ComposeConfigInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.ComposeConfigHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.ComposeConfigHandlerFunc
	}
	lockComposeConfigInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockComposeConfigInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *ComposeConfigInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ComposeConfigLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("ComposeConfigInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but ComposeConfigInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.ComposeConfigLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockComposeConfigInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockComposeConfigInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedComposeConfigInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *ComposeConfigInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.ComposeConfigLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.ComposeConfigLifecycle
	}
	lockComposeConfigInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockComposeConfigInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ComposeConfigInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.ComposeConfigHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ComposeConfigInterfaceMock.AddClusterScopedHandlerFunc: method is nil but ComposeConfigInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.ComposeConfigHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockComposeConfigInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockComposeConfigInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedComposeConfigInterface.AddClusterScopedHandlerCalls())
func (mock *ComposeConfigInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.ComposeConfigHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.ComposeConfigHandlerFunc
	}
	lockComposeConfigInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockComposeConfigInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *ComposeConfigInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.ComposeConfigLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("ComposeConfigInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but ComposeConfigInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.ComposeConfigLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockComposeConfigInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockComposeConfigInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedComposeConfigInterface.AddClusterScopedLifecycleCalls())
func (mock *ComposeConfigInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.ComposeConfigLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.ComposeConfigLifecycle
	}
	lockComposeConfigInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockComposeConfigInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ComposeConfigInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ComposeConfigHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ComposeConfigInterfaceMock.AddFeatureHandlerFunc: method is nil but ComposeConfigInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ComposeConfigHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockComposeConfigInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockComposeConfigInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedComposeConfigInterface.AddFeatureHandlerCalls())
func (mock *ComposeConfigInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.ComposeConfigHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ComposeConfigHandlerFunc
	}
	lockComposeConfigInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockComposeConfigInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *ComposeConfigInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.ComposeConfigLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("ComposeConfigInterfaceMock.AddFeatureLifecycleFunc: method is nil but ComposeConfigInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.ComposeConfigLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockComposeConfigInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockComposeConfigInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedComposeConfigInterface.AddFeatureLifecycleCalls())
func (mock *ComposeConfigInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.ComposeConfigLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.ComposeConfigLifecycle
	}
	lockComposeConfigInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockComposeConfigInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ComposeConfigInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.ComposeConfigHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ComposeConfigInterfaceMock.AddHandlerFunc: method is nil but ComposeConfigInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.ComposeConfigHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockComposeConfigInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockComposeConfigInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedComposeConfigInterface.AddHandlerCalls())
func (mock *ComposeConfigInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.ComposeConfigHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.ComposeConfigHandlerFunc
	}
	lockComposeConfigInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockComposeConfigInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *ComposeConfigInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.ComposeConfigLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("ComposeConfigInterfaceMock.AddLifecycleFunc: method is nil but ComposeConfigInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.ComposeConfigLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockComposeConfigInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockComposeConfigInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedComposeConfigInterface.AddLifecycleCalls())
func (mock *ComposeConfigInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.ComposeConfigLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.ComposeConfigLifecycle
	}
	lockComposeConfigInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockComposeConfigInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *ComposeConfigInterfaceMock) Controller() v31.ComposeConfigController {
	if mock.ControllerFunc == nil {
		panic("ComposeConfigInterfaceMock.ControllerFunc: method is nil but ComposeConfigInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockComposeConfigInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockComposeConfigInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedComposeConfigInterface.ControllerCalls())
func (mock *ComposeConfigInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockComposeConfigInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockComposeConfigInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *ComposeConfigInterfaceMock) Create(in1 *v3.ComposeConfig) (*v3.ComposeConfig, error) {
	if mock.CreateFunc == nil {
		panic("ComposeConfigInterfaceMock.CreateFunc: method is nil but ComposeConfigInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.ComposeConfig
	}{
		In1: in1,
	}
	lockComposeConfigInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockComposeConfigInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedComposeConfigInterface.CreateCalls())
func (mock *ComposeConfigInterfaceMock) CreateCalls() []struct {
	In1 *v3.ComposeConfig
} {
	var calls []struct {
		In1 *v3.ComposeConfig
	}
	lockComposeConfigInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockComposeConfigInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *ComposeConfigInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("ComposeConfigInterfaceMock.DeleteFunc: method is nil but ComposeConfigInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockComposeConfigInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockComposeConfigInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedComposeConfigInterface.DeleteCalls())
func (mock *ComposeConfigInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockComposeConfigInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockComposeConfigInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *ComposeConfigInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("ComposeConfigInterfaceMock.DeleteCollectionFunc: method is nil but ComposeConfigInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockComposeConfigInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockComposeConfigInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedComposeConfigInterface.DeleteCollectionCalls())
func (mock *ComposeConfigInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockComposeConfigInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockComposeConfigInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *ComposeConfigInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("ComposeConfigInterfaceMock.DeleteNamespacedFunc: method is nil but ComposeConfigInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockComposeConfigInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockComposeConfigInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedComposeConfigInterface.DeleteNamespacedCalls())
func (mock *ComposeConfigInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockComposeConfigInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockComposeConfigInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *ComposeConfigInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.ComposeConfig, error) {
	if mock.GetFunc == nil {
		panic("ComposeConfigInterfaceMock.GetFunc: method is nil but ComposeConfigInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockComposeConfigInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockComposeConfigInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedComposeConfigInterface.GetCalls())
func (mock *ComposeConfigInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockComposeConfigInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockComposeConfigInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *ComposeConfigInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.ComposeConfig, error) {
	if mock.GetNamespacedFunc == nil {
		panic("ComposeConfigInterfaceMock.GetNamespacedFunc: method is nil but ComposeConfigInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockComposeConfigInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockComposeConfigInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedComposeConfigInterface.GetNamespacedCalls())
func (mock *ComposeConfigInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockComposeConfigInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockComposeConfigInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ComposeConfigInterfaceMock) List(opts metav1.ListOptions) (*v3.ComposeConfigList, error) {
	if mock.ListFunc == nil {
		panic("ComposeConfigInterfaceMock.ListFunc: method is nil but ComposeConfigInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockComposeConfigInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockComposeConfigInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedComposeConfigInterface.ListCalls())
func (mock *ComposeConfigInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockComposeConfigInterfaceMockList.RLock()
	calls = mock.calls.List
	lockComposeConfigInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *ComposeConfigInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.ComposeConfigList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("ComposeConfigInterfaceMock.ListNamespacedFunc: method is nil but ComposeConfigInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockComposeConfigInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockComposeConfigInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedComposeConfigInterface.ListNamespacedCalls())
func (mock *ComposeConfigInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockComposeConfigInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockComposeConfigInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *ComposeConfigInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("ComposeConfigInterfaceMock.ObjectClientFunc: method is nil but ComposeConfigInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockComposeConfigInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockComposeConfigInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedComposeConfigInterface.ObjectClientCalls())
func (mock *ComposeConfigInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockComposeConfigInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockComposeConfigInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *ComposeConfigInterfaceMock) Update(in1 *v3.ComposeConfig) (*v3.ComposeConfig, error) {
	if mock.UpdateFunc == nil {
		panic("ComposeConfigInterfaceMock.UpdateFunc: method is nil but ComposeConfigInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.ComposeConfig
	}{
		In1: in1,
	}
	lockComposeConfigInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockComposeConfigInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedComposeConfigInterface.UpdateCalls())
func (mock *ComposeConfigInterfaceMock) UpdateCalls() []struct {
	In1 *v3.ComposeConfig
} {
	var calls []struct {
		In1 *v3.ComposeConfig
	}
	lockComposeConfigInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockComposeConfigInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *ComposeConfigInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("ComposeConfigInterfaceMock.WatchFunc: method is nil but ComposeConfigInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockComposeConfigInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockComposeConfigInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedComposeConfigInterface.WatchCalls())
func (mock *ComposeConfigInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockComposeConfigInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockComposeConfigInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockComposeConfigsGetterMockComposeConfigs sync.RWMutex
)

// Ensure, that ComposeConfigsGetterMock does implement v31.ComposeConfigsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.ComposeConfigsGetter = &ComposeConfigsGetterMock{}

// ComposeConfigsGetterMock is a mock implementation of v31.ComposeConfigsGetter.
//
//     func TestSomethingThatUsesComposeConfigsGetter(t *testing.T) {
//
//         // make and configure a mocked v31.ComposeConfigsGetter
//         mockedComposeConfigsGetter := &ComposeConfigsGetterMock{
//             ComposeConfigsFunc: func(namespace string) v31.ComposeConfigInterface {
// 	               panic("mock out the ComposeConfigs method")
//             },
//         }
//
//         // use mockedComposeConfigsGetter in code that requires v31.ComposeConfigsGetter
//         // and then make assertions.
//
//     }
type ComposeConfigsGetterMock struct {
	// ComposeConfigsFunc mocks the ComposeConfigs method.
	ComposeConfigsFunc func(namespace string) v31.ComposeConfigInterface

	// calls tracks calls to the methods.
	calls struct {
		// ComposeConfigs holds details about calls to the ComposeConfigs method.
		ComposeConfigs []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// ComposeConfigs calls ComposeConfigsFunc.
func (mock *ComposeConfigsGetterMock) ComposeConfigs(namespace string) v31.ComposeConfigInterface {
	if mock.ComposeConfigsFunc == nil {
		panic("ComposeConfigsGetterMock.ComposeConfigsFunc: method is nil but ComposeConfigsGetter.ComposeConfigs was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockComposeConfigsGetterMockComposeConfigs.Lock()
	mock.calls.ComposeConfigs = append(mock.calls.ComposeConfigs, callInfo)
	lockComposeConfigsGetterMockComposeConfigs.Unlock()
	return mock.ComposeConfigsFunc(namespace)
}

// ComposeConfigsCalls gets all the calls that were made to ComposeConfigs.
// Check the length with:
//     len(mockedComposeConfigsGetter.ComposeConfigsCalls())
func (mock *ComposeConfigsGetterMock) ComposeConfigsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockComposeConfigsGetterMockComposeConfigs.RLock()
	calls = mock.calls.ComposeConfigs
	lockComposeConfigsGetterMockComposeConfigs.RUnlock()
	return calls
}
