// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockDynamicSchemaListerMockGet  sync.RWMutex
	lockDynamicSchemaListerMockList sync.RWMutex
)

// Ensure, that DynamicSchemaListerMock does implement v31.DynamicSchemaLister.
// If this is not the case, regenerate this file with moq.
var _ v31.DynamicSchemaLister = &DynamicSchemaListerMock{}

// DynamicSchemaListerMock is a mock implementation of v31.DynamicSchemaLister.
//
//     func TestSomethingThatUsesDynamicSchemaLister(t *testing.T) {
//
//         // make and configure a mocked v31.DynamicSchemaLister
//         mockedDynamicSchemaLister := &DynamicSchemaListerMock{
//             GetFunc: func(namespace string, name string) (*v3.DynamicSchema, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.DynamicSchema, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedDynamicSchemaLister in code that requires v31.DynamicSchemaLister
//         // and then make assertions.
//
//     }
type DynamicSchemaListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.DynamicSchema, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.DynamicSchema, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *DynamicSchemaListerMock) Get(namespace string, name string) (*v3.DynamicSchema, error) {
	if mock.GetFunc == nil {
		panic("DynamicSchemaListerMock.GetFunc: method is nil but DynamicSchemaLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockDynamicSchemaListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockDynamicSchemaListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedDynamicSchemaLister.GetCalls())
func (mock *DynamicSchemaListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockDynamicSchemaListerMockGet.RLock()
	calls = mock.calls.Get
	lockDynamicSchemaListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *DynamicSchemaListerMock) List(namespace string, selector labels.Selector) ([]*v3.DynamicSchema, error) {
	if mock.ListFunc == nil {
		panic("DynamicSchemaListerMock.ListFunc: method is nil but DynamicSchemaLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockDynamicSchemaListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockDynamicSchemaListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedDynamicSchemaLister.ListCalls())
func (mock *DynamicSchemaListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockDynamicSchemaListerMockList.RLock()
	calls = mock.calls.List
	lockDynamicSchemaListerMockList.RUnlock()
	return calls
}

var (
	lockDynamicSchemaControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockDynamicSchemaControllerMockAddClusterScopedHandler        sync.RWMutex
	lockDynamicSchemaControllerMockAddFeatureHandler              sync.RWMutex
	lockDynamicSchemaControllerMockAddHandler                     sync.RWMutex
	lockDynamicSchemaControllerMockEnqueue                        sync.RWMutex
	lockDynamicSchemaControllerMockEnqueueAfter                   sync.RWMutex
	lockDynamicSchemaControllerMockGeneric                        sync.RWMutex
	lockDynamicSchemaControllerMockInformer                       sync.RWMutex
	lockDynamicSchemaControllerMockLister                         sync.RWMutex
)

// Ensure, that DynamicSchemaControllerMock does implement v31.DynamicSchemaController.
// If this is not the case, regenerate this file with moq.
var _ v31.DynamicSchemaController = &DynamicSchemaControllerMock{}

// DynamicSchemaControllerMock is a mock implementation of v31.DynamicSchemaController.
//
//     func TestSomethingThatUsesDynamicSchemaController(t *testing.T) {
//
//         // make and configure a mocked v31.DynamicSchemaController
//         mockedDynamicSchemaController := &DynamicSchemaControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.DynamicSchemaHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.DynamicSchemaHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.DynamicSchemaHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.DynamicSchemaHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.DynamicSchemaLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedDynamicSchemaController in code that requires v31.DynamicSchemaController
//         // and then make assertions.
//
//     }
type DynamicSchemaControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.DynamicSchemaHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.DynamicSchemaHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.DynamicSchemaHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.DynamicSchemaHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.DynamicSchemaLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.DynamicSchemaHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.DynamicSchemaHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.DynamicSchemaHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.DynamicSchemaHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *DynamicSchemaControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.DynamicSchemaHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("DynamicSchemaControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but DynamicSchemaController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.DynamicSchemaHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockDynamicSchemaControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockDynamicSchemaControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedDynamicSchemaController.AddClusterScopedFeatureHandlerCalls())
func (mock *DynamicSchemaControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.DynamicSchemaHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.DynamicSchemaHandlerFunc
	}
	lockDynamicSchemaControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockDynamicSchemaControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *DynamicSchemaControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.DynamicSchemaHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("DynamicSchemaControllerMock.AddClusterScopedHandlerFunc: method is nil but DynamicSchemaController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.DynamicSchemaHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockDynamicSchemaControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockDynamicSchemaControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedDynamicSchemaController.AddClusterScopedHandlerCalls())
func (mock *DynamicSchemaControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.DynamicSchemaHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.DynamicSchemaHandlerFunc
	}
	lockDynamicSchemaControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockDynamicSchemaControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *DynamicSchemaControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.DynamicSchemaHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("DynamicSchemaControllerMock.AddFeatureHandlerFunc: method is nil but DynamicSchemaController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.DynamicSchemaHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockDynamicSchemaControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockDynamicSchemaControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedDynamicSchemaController.AddFeatureHandlerCalls())
func (mock *DynamicSchemaControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.DynamicSchemaHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.DynamicSchemaHandlerFunc
	}
	lockDynamicSchemaControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockDynamicSchemaControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *DynamicSchemaControllerMock) AddHandler(ctx context.Context, name string, handler v31.DynamicSchemaHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("DynamicSchemaControllerMock.AddHandlerFunc: method is nil but DynamicSchemaController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.DynamicSchemaHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockDynamicSchemaControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockDynamicSchemaControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedDynamicSchemaController.AddHandlerCalls())
func (mock *DynamicSchemaControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.DynamicSchemaHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.DynamicSchemaHandlerFunc
	}
	lockDynamicSchemaControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockDynamicSchemaControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *DynamicSchemaControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("DynamicSchemaControllerMock.EnqueueFunc: method is nil but DynamicSchemaController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockDynamicSchemaControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockDynamicSchemaControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedDynamicSchemaController.EnqueueCalls())
func (mock *DynamicSchemaControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockDynamicSchemaControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockDynamicSchemaControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *DynamicSchemaControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("DynamicSchemaControllerMock.EnqueueAfterFunc: method is nil but DynamicSchemaController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockDynamicSchemaControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockDynamicSchemaControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedDynamicSchemaController.EnqueueAfterCalls())
func (mock *DynamicSchemaControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockDynamicSchemaControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockDynamicSchemaControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *DynamicSchemaControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("DynamicSchemaControllerMock.GenericFunc: method is nil but DynamicSchemaController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockDynamicSchemaControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockDynamicSchemaControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedDynamicSchemaController.GenericCalls())
func (mock *DynamicSchemaControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockDynamicSchemaControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockDynamicSchemaControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *DynamicSchemaControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("DynamicSchemaControllerMock.InformerFunc: method is nil but DynamicSchemaController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockDynamicSchemaControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockDynamicSchemaControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedDynamicSchemaController.InformerCalls())
func (mock *DynamicSchemaControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockDynamicSchemaControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockDynamicSchemaControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *DynamicSchemaControllerMock) Lister() v31.DynamicSchemaLister {
	if mock.ListerFunc == nil {
		panic("DynamicSchemaControllerMock.ListerFunc: method is nil but DynamicSchemaController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockDynamicSchemaControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockDynamicSchemaControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedDynamicSchemaController.ListerCalls())
func (mock *DynamicSchemaControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockDynamicSchemaControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockDynamicSchemaControllerMockLister.RUnlock()
	return calls
}

var (
	lockDynamicSchemaInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockDynamicSchemaInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockDynamicSchemaInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockDynamicSchemaInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockDynamicSchemaInterfaceMockAddFeatureHandler                sync.RWMutex
	lockDynamicSchemaInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockDynamicSchemaInterfaceMockAddHandler                       sync.RWMutex
	lockDynamicSchemaInterfaceMockAddLifecycle                     sync.RWMutex
	lockDynamicSchemaInterfaceMockController                       sync.RWMutex
	lockDynamicSchemaInterfaceMockCreate                           sync.RWMutex
	lockDynamicSchemaInterfaceMockDelete                           sync.RWMutex
	lockDynamicSchemaInterfaceMockDeleteCollection                 sync.RWMutex
	lockDynamicSchemaInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockDynamicSchemaInterfaceMockGet                              sync.RWMutex
	lockDynamicSchemaInterfaceMockGetNamespaced                    sync.RWMutex
	lockDynamicSchemaInterfaceMockList                             sync.RWMutex
	lockDynamicSchemaInterfaceMockListNamespaced                   sync.RWMutex
	lockDynamicSchemaInterfaceMockObjectClient                     sync.RWMutex
	lockDynamicSchemaInterfaceMockUpdate                           sync.RWMutex
	lockDynamicSchemaInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that DynamicSchemaInterfaceMock does implement v31.DynamicSchemaInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.DynamicSchemaInterface = &DynamicSchemaInterfaceMock{}

// DynamicSchemaInterfaceMock is a mock implementation of v31.DynamicSchemaInterface.
//
//     func TestSomethingThatUsesDynamicSchemaInterface(t *testing.T) {
//
//         // make and configure a mocked v31.DynamicSchemaInterface
//         mockedDynamicSchemaInterface := &DynamicSchemaInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.DynamicSchemaHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.DynamicSchemaLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.DynamicSchemaHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.DynamicSchemaLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.DynamicSchemaHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.DynamicSchemaLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.DynamicSchemaHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.DynamicSchemaLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.DynamicSchemaController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.DynamicSchema) (*v3.DynamicSchema, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.DynamicSchema, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.DynamicSchema, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.DynamicSchemaList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.DynamicSchemaList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.DynamicSchema) (*v3.DynamicSchema, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedDynamicSchemaInterface in code that requires v31.DynamicSchemaInterface
//         // and then make assertions.
//
//     }
type DynamicSchemaInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.DynamicSchemaHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.DynamicSchemaLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.DynamicSchemaHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.DynamicSchemaLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.DynamicSchemaHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.DynamicSchemaLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.DynamicSchemaHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.DynamicSchemaLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.DynamicSchemaController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.DynamicSchema) (*v3.DynamicSchema, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.DynamicSchema, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.DynamicSchema, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.DynamicSchemaList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.DynamicSchemaList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.DynamicSchema) (*v3.DynamicSchema, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.DynamicSchemaHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.DynamicSchemaLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.DynamicSchemaHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.DynamicSchemaLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.DynamicSchemaHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.DynamicSchemaLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.DynamicSchemaHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.DynamicSchemaLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.DynamicSchema
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.DynamicSchema
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *DynamicSchemaInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.DynamicSchemaHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("DynamicSchemaInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but DynamicSchemaInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.DynamicSchemaHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockDynamicSchemaInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockDynamicSchemaInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedDynamicSchemaInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *DynamicSchemaInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.DynamicSchemaHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.DynamicSchemaHandlerFunc
	}
	lockDynamicSchemaInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockDynamicSchemaInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *DynamicSchemaInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.DynamicSchemaLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("DynamicSchemaInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but DynamicSchemaInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.DynamicSchemaLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockDynamicSchemaInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockDynamicSchemaInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedDynamicSchemaInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *DynamicSchemaInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.DynamicSchemaLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.DynamicSchemaLifecycle
	}
	lockDynamicSchemaInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockDynamicSchemaInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *DynamicSchemaInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.DynamicSchemaHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("DynamicSchemaInterfaceMock.AddClusterScopedHandlerFunc: method is nil but DynamicSchemaInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.DynamicSchemaHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockDynamicSchemaInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockDynamicSchemaInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedDynamicSchemaInterface.AddClusterScopedHandlerCalls())
func (mock *DynamicSchemaInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.DynamicSchemaHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.DynamicSchemaHandlerFunc
	}
	lockDynamicSchemaInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockDynamicSchemaInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *DynamicSchemaInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.DynamicSchemaLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("DynamicSchemaInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but DynamicSchemaInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.DynamicSchemaLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockDynamicSchemaInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockDynamicSchemaInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedDynamicSchemaInterface.AddClusterScopedLifecycleCalls())
func (mock *DynamicSchemaInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.DynamicSchemaLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.DynamicSchemaLifecycle
	}
	lockDynamicSchemaInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockDynamicSchemaInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *DynamicSchemaInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.DynamicSchemaHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("DynamicSchemaInterfaceMock.AddFeatureHandlerFunc: method is nil but DynamicSchemaInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.DynamicSchemaHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockDynamicSchemaInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockDynamicSchemaInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedDynamicSchemaInterface.AddFeatureHandlerCalls())
func (mock *DynamicSchemaInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.DynamicSchemaHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.DynamicSchemaHandlerFunc
	}
	lockDynamicSchemaInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockDynamicSchemaInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *DynamicSchemaInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.DynamicSchemaLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("DynamicSchemaInterfaceMock.AddFeatureLifecycleFunc: method is nil but DynamicSchemaInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.DynamicSchemaLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockDynamicSchemaInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockDynamicSchemaInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedDynamicSchemaInterface.AddFeatureLifecycleCalls())
func (mock *DynamicSchemaInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.DynamicSchemaLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.DynamicSchemaLifecycle
	}
	lockDynamicSchemaInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockDynamicSchemaInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *DynamicSchemaInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.DynamicSchemaHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("DynamicSchemaInterfaceMock.AddHandlerFunc: method is nil but DynamicSchemaInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.DynamicSchemaHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockDynamicSchemaInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockDynamicSchemaInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedDynamicSchemaInterface.AddHandlerCalls())
func (mock *DynamicSchemaInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.DynamicSchemaHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.DynamicSchemaHandlerFunc
	}
	lockDynamicSchemaInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockDynamicSchemaInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *DynamicSchemaInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.DynamicSchemaLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("DynamicSchemaInterfaceMock.AddLifecycleFunc: method is nil but DynamicSchemaInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.DynamicSchemaLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockDynamicSchemaInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockDynamicSchemaInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedDynamicSchemaInterface.AddLifecycleCalls())
func (mock *DynamicSchemaInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.DynamicSchemaLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.DynamicSchemaLifecycle
	}
	lockDynamicSchemaInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockDynamicSchemaInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *DynamicSchemaInterfaceMock) Controller() v31.DynamicSchemaController {
	if mock.ControllerFunc == nil {
		panic("DynamicSchemaInterfaceMock.ControllerFunc: method is nil but DynamicSchemaInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockDynamicSchemaInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockDynamicSchemaInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedDynamicSchemaInterface.ControllerCalls())
func (mock *DynamicSchemaInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockDynamicSchemaInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockDynamicSchemaInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *DynamicSchemaInterfaceMock) Create(in1 *v3.DynamicSchema) (*v3.DynamicSchema, error) {
	if mock.CreateFunc == nil {
		panic("DynamicSchemaInterfaceMock.CreateFunc: method is nil but DynamicSchemaInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.DynamicSchema
	}{
		In1: in1,
	}
	lockDynamicSchemaInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockDynamicSchemaInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedDynamicSchemaInterface.CreateCalls())
func (mock *DynamicSchemaInterfaceMock) CreateCalls() []struct {
	In1 *v3.DynamicSchema
} {
	var calls []struct {
		In1 *v3.DynamicSchema
	}
	lockDynamicSchemaInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockDynamicSchemaInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *DynamicSchemaInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("DynamicSchemaInterfaceMock.DeleteFunc: method is nil but DynamicSchemaInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockDynamicSchemaInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockDynamicSchemaInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedDynamicSchemaInterface.DeleteCalls())
func (mock *DynamicSchemaInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockDynamicSchemaInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockDynamicSchemaInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *DynamicSchemaInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("DynamicSchemaInterfaceMock.DeleteCollectionFunc: method is nil but DynamicSchemaInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockDynamicSchemaInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockDynamicSchemaInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedDynamicSchemaInterface.DeleteCollectionCalls())
func (mock *DynamicSchemaInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockDynamicSchemaInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockDynamicSchemaInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *DynamicSchemaInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("DynamicSchemaInterfaceMock.DeleteNamespacedFunc: method is nil but DynamicSchemaInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockDynamicSchemaInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockDynamicSchemaInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedDynamicSchemaInterface.DeleteNamespacedCalls())
func (mock *DynamicSchemaInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockDynamicSchemaInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockDynamicSchemaInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *DynamicSchemaInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.DynamicSchema, error) {
	if mock.GetFunc == nil {
		panic("DynamicSchemaInterfaceMock.GetFunc: method is nil but DynamicSchemaInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockDynamicSchemaInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockDynamicSchemaInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedDynamicSchemaInterface.GetCalls())
func (mock *DynamicSchemaInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockDynamicSchemaInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockDynamicSchemaInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *DynamicSchemaInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.DynamicSchema, error) {
	if mock.GetNamespacedFunc == nil {
		panic("DynamicSchemaInterfaceMock.GetNamespacedFunc: method is nil but DynamicSchemaInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockDynamicSchemaInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockDynamicSchemaInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedDynamicSchemaInterface.GetNamespacedCalls())
func (mock *DynamicSchemaInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockDynamicSchemaInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockDynamicSchemaInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *DynamicSchemaInterfaceMock) List(opts metav1.ListOptions) (*v3.DynamicSchemaList, error) {
	if mock.ListFunc == nil {
		panic("DynamicSchemaInterfaceMock.ListFunc: method is nil but DynamicSchemaInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockDynamicSchemaInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockDynamicSchemaInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedDynamicSchemaInterface.ListCalls())
func (mock *DynamicSchemaInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockDynamicSchemaInterfaceMockList.RLock()
	calls = mock.calls.List
	lockDynamicSchemaInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *DynamicSchemaInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.DynamicSchemaList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("DynamicSchemaInterfaceMock.ListNamespacedFunc: method is nil but DynamicSchemaInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockDynamicSchemaInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockDynamicSchemaInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedDynamicSchemaInterface.ListNamespacedCalls())
func (mock *DynamicSchemaInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockDynamicSchemaInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockDynamicSchemaInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *DynamicSchemaInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("DynamicSchemaInterfaceMock.ObjectClientFunc: method is nil but DynamicSchemaInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockDynamicSchemaInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockDynamicSchemaInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedDynamicSchemaInterface.ObjectClientCalls())
func (mock *DynamicSchemaInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockDynamicSchemaInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockDynamicSchemaInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *DynamicSchemaInterfaceMock) Update(in1 *v3.DynamicSchema) (*v3.DynamicSchema, error) {
	if mock.UpdateFunc == nil {
		panic("DynamicSchemaInterfaceMock.UpdateFunc: method is nil but DynamicSchemaInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.DynamicSchema
	}{
		In1: in1,
	}
	lockDynamicSchemaInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockDynamicSchemaInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedDynamicSchemaInterface.UpdateCalls())
func (mock *DynamicSchemaInterfaceMock) UpdateCalls() []struct {
	In1 *v3.DynamicSchema
} {
	var calls []struct {
		In1 *v3.DynamicSchema
	}
	lockDynamicSchemaInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockDynamicSchemaInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *DynamicSchemaInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("DynamicSchemaInterfaceMock.WatchFunc: method is nil but DynamicSchemaInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockDynamicSchemaInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockDynamicSchemaInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedDynamicSchemaInterface.WatchCalls())
func (mock *DynamicSchemaInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockDynamicSchemaInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockDynamicSchemaInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockDynamicSchemasGetterMockDynamicSchemas sync.RWMutex
)

// Ensure, that DynamicSchemasGetterMock does implement v31.DynamicSchemasGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.DynamicSchemasGetter = &DynamicSchemasGetterMock{}

// DynamicSchemasGetterMock is a mock implementation of v31.DynamicSchemasGetter.
//
//     func TestSomethingThatUsesDynamicSchemasGetter(t *testing.T) {
//
//         // make and configure a mocked v31.DynamicSchemasGetter
//         mockedDynamicSchemasGetter := &DynamicSchemasGetterMock{
//             DynamicSchemasFunc: func(namespace string) v31.DynamicSchemaInterface {
// 	               panic("mock out the DynamicSchemas method")
//             },
//         }
//
//         // use mockedDynamicSchemasGetter in code that requires v31.DynamicSchemasGetter
//         // and then make assertions.
//
//     }
type DynamicSchemasGetterMock struct {
	// DynamicSchemasFunc mocks the DynamicSchemas method.
	DynamicSchemasFunc func(namespace string) v31.DynamicSchemaInterface

	// calls tracks calls to the methods.
	calls struct {
		// DynamicSchemas holds details about calls to the DynamicSchemas method.
		DynamicSchemas []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// DynamicSchemas calls DynamicSchemasFunc.
func (mock *DynamicSchemasGetterMock) DynamicSchemas(namespace string) v31.DynamicSchemaInterface {
	if mock.DynamicSchemasFunc == nil {
		panic("DynamicSchemasGetterMock.DynamicSchemasFunc: method is nil but DynamicSchemasGetter.DynamicSchemas was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockDynamicSchemasGetterMockDynamicSchemas.Lock()
	mock.calls.DynamicSchemas = append(mock.calls.DynamicSchemas, callInfo)
	lockDynamicSchemasGetterMockDynamicSchemas.Unlock()
	return mock.DynamicSchemasFunc(namespace)
}

// DynamicSchemasCalls gets all the calls that were made to DynamicSchemas.
// Check the length with:
//     len(mockedDynamicSchemasGetter.DynamicSchemasCalls())
func (mock *DynamicSchemasGetterMock) DynamicSchemasCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockDynamicSchemasGetterMockDynamicSchemas.RLock()
	calls = mock.calls.DynamicSchemas
	lockDynamicSchemasGetterMockDynamicSchemas.RUnlock()
	return calls
}
