// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockEtcdBackupListerMockGet  sync.RWMutex
	lockEtcdBackupListerMockList sync.RWMutex
)

// Ensure, that EtcdBackupListerMock does implement v31.EtcdBackupLister.
// If this is not the case, regenerate this file with moq.
var _ v31.EtcdBackupLister = &EtcdBackupListerMock{}

// EtcdBackupListerMock is a mock implementation of v31.EtcdBackupLister.
//
//     func TestSomethingThatUsesEtcdBackupLister(t *testing.T) {
//
//         // make and configure a mocked v31.EtcdBackupLister
//         mockedEtcdBackupLister := &EtcdBackupListerMock{
//             GetFunc: func(namespace string, name string) (*v3.EtcdBackup, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.EtcdBackup, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedEtcdBackupLister in code that requires v31.EtcdBackupLister
//         // and then make assertions.
//
//     }
type EtcdBackupListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.EtcdBackup, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.EtcdBackup, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *EtcdBackupListerMock) Get(namespace string, name string) (*v3.EtcdBackup, error) {
	if mock.GetFunc == nil {
		panic("EtcdBackupListerMock.GetFunc: method is nil but EtcdBackupLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockEtcdBackupListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockEtcdBackupListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedEtcdBackupLister.GetCalls())
func (mock *EtcdBackupListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockEtcdBackupListerMockGet.RLock()
	calls = mock.calls.Get
	lockEtcdBackupListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *EtcdBackupListerMock) List(namespace string, selector labels.Selector) ([]*v3.EtcdBackup, error) {
	if mock.ListFunc == nil {
		panic("EtcdBackupListerMock.ListFunc: method is nil but EtcdBackupLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockEtcdBackupListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockEtcdBackupListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedEtcdBackupLister.ListCalls())
func (mock *EtcdBackupListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockEtcdBackupListerMockList.RLock()
	calls = mock.calls.List
	lockEtcdBackupListerMockList.RUnlock()
	return calls
}

var (
	lockEtcdBackupControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockEtcdBackupControllerMockAddClusterScopedHandler        sync.RWMutex
	lockEtcdBackupControllerMockAddFeatureHandler              sync.RWMutex
	lockEtcdBackupControllerMockAddHandler                     sync.RWMutex
	lockEtcdBackupControllerMockEnqueue                        sync.RWMutex
	lockEtcdBackupControllerMockEnqueueAfter                   sync.RWMutex
	lockEtcdBackupControllerMockGeneric                        sync.RWMutex
	lockEtcdBackupControllerMockInformer                       sync.RWMutex
	lockEtcdBackupControllerMockLister                         sync.RWMutex
)

// Ensure, that EtcdBackupControllerMock does implement v31.EtcdBackupController.
// If this is not the case, regenerate this file with moq.
var _ v31.EtcdBackupController = &EtcdBackupControllerMock{}

// EtcdBackupControllerMock is a mock implementation of v31.EtcdBackupController.
//
//     func TestSomethingThatUsesEtcdBackupController(t *testing.T) {
//
//         // make and configure a mocked v31.EtcdBackupController
//         mockedEtcdBackupController := &EtcdBackupControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.EtcdBackupHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.EtcdBackupHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.EtcdBackupHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.EtcdBackupHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.EtcdBackupLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedEtcdBackupController in code that requires v31.EtcdBackupController
//         // and then make assertions.
//
//     }
type EtcdBackupControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.EtcdBackupHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.EtcdBackupHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.EtcdBackupHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.EtcdBackupHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.EtcdBackupLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.EtcdBackupHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.EtcdBackupHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.EtcdBackupHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.EtcdBackupHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *EtcdBackupControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.EtcdBackupHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("EtcdBackupControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but EtcdBackupController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.EtcdBackupHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockEtcdBackupControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockEtcdBackupControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedEtcdBackupController.AddClusterScopedFeatureHandlerCalls())
func (mock *EtcdBackupControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.EtcdBackupHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.EtcdBackupHandlerFunc
	}
	lockEtcdBackupControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockEtcdBackupControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *EtcdBackupControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.EtcdBackupHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("EtcdBackupControllerMock.AddClusterScopedHandlerFunc: method is nil but EtcdBackupController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.EtcdBackupHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockEtcdBackupControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockEtcdBackupControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedEtcdBackupController.AddClusterScopedHandlerCalls())
func (mock *EtcdBackupControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.EtcdBackupHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.EtcdBackupHandlerFunc
	}
	lockEtcdBackupControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockEtcdBackupControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *EtcdBackupControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.EtcdBackupHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("EtcdBackupControllerMock.AddFeatureHandlerFunc: method is nil but EtcdBackupController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.EtcdBackupHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockEtcdBackupControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockEtcdBackupControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedEtcdBackupController.AddFeatureHandlerCalls())
func (mock *EtcdBackupControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.EtcdBackupHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.EtcdBackupHandlerFunc
	}
	lockEtcdBackupControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockEtcdBackupControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *EtcdBackupControllerMock) AddHandler(ctx context.Context, name string, handler v31.EtcdBackupHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("EtcdBackupControllerMock.AddHandlerFunc: method is nil but EtcdBackupController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.EtcdBackupHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockEtcdBackupControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockEtcdBackupControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedEtcdBackupController.AddHandlerCalls())
func (mock *EtcdBackupControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.EtcdBackupHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.EtcdBackupHandlerFunc
	}
	lockEtcdBackupControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockEtcdBackupControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *EtcdBackupControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("EtcdBackupControllerMock.EnqueueFunc: method is nil but EtcdBackupController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockEtcdBackupControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockEtcdBackupControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedEtcdBackupController.EnqueueCalls())
func (mock *EtcdBackupControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockEtcdBackupControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockEtcdBackupControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *EtcdBackupControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("EtcdBackupControllerMock.EnqueueAfterFunc: method is nil but EtcdBackupController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockEtcdBackupControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockEtcdBackupControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedEtcdBackupController.EnqueueAfterCalls())
func (mock *EtcdBackupControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockEtcdBackupControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockEtcdBackupControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *EtcdBackupControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("EtcdBackupControllerMock.GenericFunc: method is nil but EtcdBackupController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockEtcdBackupControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockEtcdBackupControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedEtcdBackupController.GenericCalls())
func (mock *EtcdBackupControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockEtcdBackupControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockEtcdBackupControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *EtcdBackupControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("EtcdBackupControllerMock.InformerFunc: method is nil but EtcdBackupController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockEtcdBackupControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockEtcdBackupControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedEtcdBackupController.InformerCalls())
func (mock *EtcdBackupControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockEtcdBackupControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockEtcdBackupControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *EtcdBackupControllerMock) Lister() v31.EtcdBackupLister {
	if mock.ListerFunc == nil {
		panic("EtcdBackupControllerMock.ListerFunc: method is nil but EtcdBackupController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockEtcdBackupControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockEtcdBackupControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedEtcdBackupController.ListerCalls())
func (mock *EtcdBackupControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockEtcdBackupControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockEtcdBackupControllerMockLister.RUnlock()
	return calls
}

var (
	lockEtcdBackupInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockEtcdBackupInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockEtcdBackupInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockEtcdBackupInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockEtcdBackupInterfaceMockAddFeatureHandler                sync.RWMutex
	lockEtcdBackupInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockEtcdBackupInterfaceMockAddHandler                       sync.RWMutex
	lockEtcdBackupInterfaceMockAddLifecycle                     sync.RWMutex
	lockEtcdBackupInterfaceMockController                       sync.RWMutex
	lockEtcdBackupInterfaceMockCreate                           sync.RWMutex
	lockEtcdBackupInterfaceMockDelete                           sync.RWMutex
	lockEtcdBackupInterfaceMockDeleteCollection                 sync.RWMutex
	lockEtcdBackupInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockEtcdBackupInterfaceMockGet                              sync.RWMutex
	lockEtcdBackupInterfaceMockGetNamespaced                    sync.RWMutex
	lockEtcdBackupInterfaceMockList                             sync.RWMutex
	lockEtcdBackupInterfaceMockListNamespaced                   sync.RWMutex
	lockEtcdBackupInterfaceMockObjectClient                     sync.RWMutex
	lockEtcdBackupInterfaceMockUpdate                           sync.RWMutex
	lockEtcdBackupInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that EtcdBackupInterfaceMock does implement v31.EtcdBackupInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.EtcdBackupInterface = &EtcdBackupInterfaceMock{}

// EtcdBackupInterfaceMock is a mock implementation of v31.EtcdBackupInterface.
//
//     func TestSomethingThatUsesEtcdBackupInterface(t *testing.T) {
//
//         // make and configure a mocked v31.EtcdBackupInterface
//         mockedEtcdBackupInterface := &EtcdBackupInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.EtcdBackupHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.EtcdBackupLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.EtcdBackupHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.EtcdBackupLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.EtcdBackupHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.EtcdBackupLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.EtcdBackupHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.EtcdBackupLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.EtcdBackupController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.EtcdBackup) (*v3.EtcdBackup, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.EtcdBackup, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.EtcdBackup, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.EtcdBackupList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.EtcdBackupList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.EtcdBackup) (*v3.EtcdBackup, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedEtcdBackupInterface in code that requires v31.EtcdBackupInterface
//         // and then make assertions.
//
//     }
type EtcdBackupInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.EtcdBackupHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.EtcdBackupLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.EtcdBackupHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.EtcdBackupLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.EtcdBackupHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.EtcdBackupLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.EtcdBackupHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.EtcdBackupLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.EtcdBackupController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.EtcdBackup) (*v3.EtcdBackup, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.EtcdBackup, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.EtcdBackup, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.EtcdBackupList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.EtcdBackupList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.EtcdBackup) (*v3.EtcdBackup, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.EtcdBackupHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.EtcdBackupLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.EtcdBackupHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.EtcdBackupLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.EtcdBackupHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.EtcdBackupLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.EtcdBackupHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.EtcdBackupLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.EtcdBackup
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.EtcdBackup
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *EtcdBackupInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.EtcdBackupHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("EtcdBackupInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but EtcdBackupInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.EtcdBackupHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockEtcdBackupInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockEtcdBackupInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedEtcdBackupInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *EtcdBackupInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.EtcdBackupHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.EtcdBackupHandlerFunc
	}
	lockEtcdBackupInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockEtcdBackupInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *EtcdBackupInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.EtcdBackupLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("EtcdBackupInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but EtcdBackupInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.EtcdBackupLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockEtcdBackupInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockEtcdBackupInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedEtcdBackupInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *EtcdBackupInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.EtcdBackupLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.EtcdBackupLifecycle
	}
	lockEtcdBackupInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockEtcdBackupInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *EtcdBackupInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.EtcdBackupHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("EtcdBackupInterfaceMock.AddClusterScopedHandlerFunc: method is nil but EtcdBackupInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.EtcdBackupHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockEtcdBackupInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockEtcdBackupInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedEtcdBackupInterface.AddClusterScopedHandlerCalls())
func (mock *EtcdBackupInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.EtcdBackupHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.EtcdBackupHandlerFunc
	}
	lockEtcdBackupInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockEtcdBackupInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *EtcdBackupInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.EtcdBackupLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("EtcdBackupInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but EtcdBackupInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.EtcdBackupLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockEtcdBackupInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockEtcdBackupInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedEtcdBackupInterface.AddClusterScopedLifecycleCalls())
func (mock *EtcdBackupInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.EtcdBackupLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.EtcdBackupLifecycle
	}
	lockEtcdBackupInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockEtcdBackupInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *EtcdBackupInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.EtcdBackupHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("EtcdBackupInterfaceMock.AddFeatureHandlerFunc: method is nil but EtcdBackupInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.EtcdBackupHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockEtcdBackupInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockEtcdBackupInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedEtcdBackupInterface.AddFeatureHandlerCalls())
func (mock *EtcdBackupInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.EtcdBackupHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.EtcdBackupHandlerFunc
	}
	lockEtcdBackupInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockEtcdBackupInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *EtcdBackupInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.EtcdBackupLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("EtcdBackupInterfaceMock.AddFeatureLifecycleFunc: method is nil but EtcdBackupInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.EtcdBackupLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockEtcdBackupInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockEtcdBackupInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedEtcdBackupInterface.AddFeatureLifecycleCalls())
func (mock *EtcdBackupInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.EtcdBackupLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.EtcdBackupLifecycle
	}
	lockEtcdBackupInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockEtcdBackupInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *EtcdBackupInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.EtcdBackupHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("EtcdBackupInterfaceMock.AddHandlerFunc: method is nil but EtcdBackupInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.EtcdBackupHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockEtcdBackupInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockEtcdBackupInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedEtcdBackupInterface.AddHandlerCalls())
func (mock *EtcdBackupInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.EtcdBackupHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.EtcdBackupHandlerFunc
	}
	lockEtcdBackupInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockEtcdBackupInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *EtcdBackupInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.EtcdBackupLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("EtcdBackupInterfaceMock.AddLifecycleFunc: method is nil but EtcdBackupInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.EtcdBackupLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockEtcdBackupInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockEtcdBackupInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedEtcdBackupInterface.AddLifecycleCalls())
func (mock *EtcdBackupInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.EtcdBackupLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.EtcdBackupLifecycle
	}
	lockEtcdBackupInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockEtcdBackupInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *EtcdBackupInterfaceMock) Controller() v31.EtcdBackupController {
	if mock.ControllerFunc == nil {
		panic("EtcdBackupInterfaceMock.ControllerFunc: method is nil but EtcdBackupInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockEtcdBackupInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockEtcdBackupInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedEtcdBackupInterface.ControllerCalls())
func (mock *EtcdBackupInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockEtcdBackupInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockEtcdBackupInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *EtcdBackupInterfaceMock) Create(in1 *v3.EtcdBackup) (*v3.EtcdBackup, error) {
	if mock.CreateFunc == nil {
		panic("EtcdBackupInterfaceMock.CreateFunc: method is nil but EtcdBackupInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.EtcdBackup
	}{
		In1: in1,
	}
	lockEtcdBackupInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockEtcdBackupInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedEtcdBackupInterface.CreateCalls())
func (mock *EtcdBackupInterfaceMock) CreateCalls() []struct {
	In1 *v3.EtcdBackup
} {
	var calls []struct {
		In1 *v3.EtcdBackup
	}
	lockEtcdBackupInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockEtcdBackupInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *EtcdBackupInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("EtcdBackupInterfaceMock.DeleteFunc: method is nil but EtcdBackupInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockEtcdBackupInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockEtcdBackupInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedEtcdBackupInterface.DeleteCalls())
func (mock *EtcdBackupInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockEtcdBackupInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockEtcdBackupInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *EtcdBackupInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("EtcdBackupInterfaceMock.DeleteCollectionFunc: method is nil but EtcdBackupInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockEtcdBackupInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockEtcdBackupInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedEtcdBackupInterface.DeleteCollectionCalls())
func (mock *EtcdBackupInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockEtcdBackupInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockEtcdBackupInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *EtcdBackupInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("EtcdBackupInterfaceMock.DeleteNamespacedFunc: method is nil but EtcdBackupInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockEtcdBackupInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockEtcdBackupInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedEtcdBackupInterface.DeleteNamespacedCalls())
func (mock *EtcdBackupInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockEtcdBackupInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockEtcdBackupInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *EtcdBackupInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.EtcdBackup, error) {
	if mock.GetFunc == nil {
		panic("EtcdBackupInterfaceMock.GetFunc: method is nil but EtcdBackupInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockEtcdBackupInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockEtcdBackupInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedEtcdBackupInterface.GetCalls())
func (mock *EtcdBackupInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockEtcdBackupInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockEtcdBackupInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *EtcdBackupInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.EtcdBackup, error) {
	if mock.GetNamespacedFunc == nil {
		panic("EtcdBackupInterfaceMock.GetNamespacedFunc: method is nil but EtcdBackupInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockEtcdBackupInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockEtcdBackupInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedEtcdBackupInterface.GetNamespacedCalls())
func (mock *EtcdBackupInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockEtcdBackupInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockEtcdBackupInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *EtcdBackupInterfaceMock) List(opts metav1.ListOptions) (*v3.EtcdBackupList, error) {
	if mock.ListFunc == nil {
		panic("EtcdBackupInterfaceMock.ListFunc: method is nil but EtcdBackupInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockEtcdBackupInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockEtcdBackupInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedEtcdBackupInterface.ListCalls())
func (mock *EtcdBackupInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockEtcdBackupInterfaceMockList.RLock()
	calls = mock.calls.List
	lockEtcdBackupInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *EtcdBackupInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.EtcdBackupList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("EtcdBackupInterfaceMock.ListNamespacedFunc: method is nil but EtcdBackupInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockEtcdBackupInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockEtcdBackupInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedEtcdBackupInterface.ListNamespacedCalls())
func (mock *EtcdBackupInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockEtcdBackupInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockEtcdBackupInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *EtcdBackupInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("EtcdBackupInterfaceMock.ObjectClientFunc: method is nil but EtcdBackupInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockEtcdBackupInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockEtcdBackupInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedEtcdBackupInterface.ObjectClientCalls())
func (mock *EtcdBackupInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockEtcdBackupInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockEtcdBackupInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *EtcdBackupInterfaceMock) Update(in1 *v3.EtcdBackup) (*v3.EtcdBackup, error) {
	if mock.UpdateFunc == nil {
		panic("EtcdBackupInterfaceMock.UpdateFunc: method is nil but EtcdBackupInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.EtcdBackup
	}{
		In1: in1,
	}
	lockEtcdBackupInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockEtcdBackupInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedEtcdBackupInterface.UpdateCalls())
func (mock *EtcdBackupInterfaceMock) UpdateCalls() []struct {
	In1 *v3.EtcdBackup
} {
	var calls []struct {
		In1 *v3.EtcdBackup
	}
	lockEtcdBackupInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockEtcdBackupInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *EtcdBackupInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("EtcdBackupInterfaceMock.WatchFunc: method is nil but EtcdBackupInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockEtcdBackupInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockEtcdBackupInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedEtcdBackupInterface.WatchCalls())
func (mock *EtcdBackupInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockEtcdBackupInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockEtcdBackupInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockEtcdBackupsGetterMockEtcdBackups sync.RWMutex
)

// Ensure, that EtcdBackupsGetterMock does implement v31.EtcdBackupsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.EtcdBackupsGetter = &EtcdBackupsGetterMock{}

// EtcdBackupsGetterMock is a mock implementation of v31.EtcdBackupsGetter.
//
//     func TestSomethingThatUsesEtcdBackupsGetter(t *testing.T) {
//
//         // make and configure a mocked v31.EtcdBackupsGetter
//         mockedEtcdBackupsGetter := &EtcdBackupsGetterMock{
//             EtcdBackupsFunc: func(namespace string) v31.EtcdBackupInterface {
// 	               panic("mock out the EtcdBackups method")
//             },
//         }
//
//         // use mockedEtcdBackupsGetter in code that requires v31.EtcdBackupsGetter
//         // and then make assertions.
//
//     }
type EtcdBackupsGetterMock struct {
	// EtcdBackupsFunc mocks the EtcdBackups method.
	EtcdBackupsFunc func(namespace string) v31.EtcdBackupInterface

	// calls tracks calls to the methods.
	calls struct {
		// EtcdBackups holds details about calls to the EtcdBackups method.
		EtcdBackups []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// EtcdBackups calls EtcdBackupsFunc.
func (mock *EtcdBackupsGetterMock) EtcdBackups(namespace string) v31.EtcdBackupInterface {
	if mock.EtcdBackupsFunc == nil {
		panic("EtcdBackupsGetterMock.EtcdBackupsFunc: method is nil but EtcdBackupsGetter.EtcdBackups was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockEtcdBackupsGetterMockEtcdBackups.Lock()
	mock.calls.EtcdBackups = append(mock.calls.EtcdBackups, callInfo)
	lockEtcdBackupsGetterMockEtcdBackups.Unlock()
	return mock.EtcdBackupsFunc(namespace)
}

// EtcdBackupsCalls gets all the calls that were made to EtcdBackups.
// Check the length with:
//     len(mockedEtcdBackupsGetter.EtcdBackupsCalls())
func (mock *EtcdBackupsGetterMock) EtcdBackupsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockEtcdBackupsGetterMockEtcdBackups.RLock()
	calls = mock.calls.EtcdBackups
	lockEtcdBackupsGetterMockEtcdBackups.RUnlock()
	return calls
}
