// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockFleetWorkspaceListerMockGet  sync.RWMutex
	lockFleetWorkspaceListerMockList sync.RWMutex
)

// Ensure, that FleetWorkspaceListerMock does implement v31.FleetWorkspaceLister.
// If this is not the case, regenerate this file with moq.
var _ v31.FleetWorkspaceLister = &FleetWorkspaceListerMock{}

// FleetWorkspaceListerMock is a mock implementation of v31.FleetWorkspaceLister.
//
//     func TestSomethingThatUsesFleetWorkspaceLister(t *testing.T) {
//
//         // make and configure a mocked v31.FleetWorkspaceLister
//         mockedFleetWorkspaceLister := &FleetWorkspaceListerMock{
//             GetFunc: func(namespace string, name string) (*v3.FleetWorkspace, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.FleetWorkspace, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedFleetWorkspaceLister in code that requires v31.FleetWorkspaceLister
//         // and then make assertions.
//
//     }
type FleetWorkspaceListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.FleetWorkspace, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.FleetWorkspace, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *FleetWorkspaceListerMock) Get(namespace string, name string) (*v3.FleetWorkspace, error) {
	if mock.GetFunc == nil {
		panic("FleetWorkspaceListerMock.GetFunc: method is nil but FleetWorkspaceLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockFleetWorkspaceListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockFleetWorkspaceListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedFleetWorkspaceLister.GetCalls())
func (mock *FleetWorkspaceListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockFleetWorkspaceListerMockGet.RLock()
	calls = mock.calls.Get
	lockFleetWorkspaceListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *FleetWorkspaceListerMock) List(namespace string, selector labels.Selector) ([]*v3.FleetWorkspace, error) {
	if mock.ListFunc == nil {
		panic("FleetWorkspaceListerMock.ListFunc: method is nil but FleetWorkspaceLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockFleetWorkspaceListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockFleetWorkspaceListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedFleetWorkspaceLister.ListCalls())
func (mock *FleetWorkspaceListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockFleetWorkspaceListerMockList.RLock()
	calls = mock.calls.List
	lockFleetWorkspaceListerMockList.RUnlock()
	return calls
}

var (
	lockFleetWorkspaceControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockFleetWorkspaceControllerMockAddClusterScopedHandler        sync.RWMutex
	lockFleetWorkspaceControllerMockAddFeatureHandler              sync.RWMutex
	lockFleetWorkspaceControllerMockAddHandler                     sync.RWMutex
	lockFleetWorkspaceControllerMockEnqueue                        sync.RWMutex
	lockFleetWorkspaceControllerMockEnqueueAfter                   sync.RWMutex
	lockFleetWorkspaceControllerMockGeneric                        sync.RWMutex
	lockFleetWorkspaceControllerMockInformer                       sync.RWMutex
	lockFleetWorkspaceControllerMockLister                         sync.RWMutex
)

// Ensure, that FleetWorkspaceControllerMock does implement v31.FleetWorkspaceController.
// If this is not the case, regenerate this file with moq.
var _ v31.FleetWorkspaceController = &FleetWorkspaceControllerMock{}

// FleetWorkspaceControllerMock is a mock implementation of v31.FleetWorkspaceController.
//
//     func TestSomethingThatUsesFleetWorkspaceController(t *testing.T) {
//
//         // make and configure a mocked v31.FleetWorkspaceController
//         mockedFleetWorkspaceController := &FleetWorkspaceControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.FleetWorkspaceHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.FleetWorkspaceHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.FleetWorkspaceHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.FleetWorkspaceHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.FleetWorkspaceLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedFleetWorkspaceController in code that requires v31.FleetWorkspaceController
//         // and then make assertions.
//
//     }
type FleetWorkspaceControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.FleetWorkspaceHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.FleetWorkspaceHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.FleetWorkspaceHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.FleetWorkspaceHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.FleetWorkspaceLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.FleetWorkspaceHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.FleetWorkspaceHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.FleetWorkspaceHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.FleetWorkspaceHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *FleetWorkspaceControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.FleetWorkspaceHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("FleetWorkspaceControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but FleetWorkspaceController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.FleetWorkspaceHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockFleetWorkspaceControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockFleetWorkspaceControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedFleetWorkspaceController.AddClusterScopedFeatureHandlerCalls())
func (mock *FleetWorkspaceControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.FleetWorkspaceHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.FleetWorkspaceHandlerFunc
	}
	lockFleetWorkspaceControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockFleetWorkspaceControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *FleetWorkspaceControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.FleetWorkspaceHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("FleetWorkspaceControllerMock.AddClusterScopedHandlerFunc: method is nil but FleetWorkspaceController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.FleetWorkspaceHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockFleetWorkspaceControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockFleetWorkspaceControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedFleetWorkspaceController.AddClusterScopedHandlerCalls())
func (mock *FleetWorkspaceControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.FleetWorkspaceHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.FleetWorkspaceHandlerFunc
	}
	lockFleetWorkspaceControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockFleetWorkspaceControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *FleetWorkspaceControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.FleetWorkspaceHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("FleetWorkspaceControllerMock.AddFeatureHandlerFunc: method is nil but FleetWorkspaceController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.FleetWorkspaceHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockFleetWorkspaceControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockFleetWorkspaceControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedFleetWorkspaceController.AddFeatureHandlerCalls())
func (mock *FleetWorkspaceControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.FleetWorkspaceHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.FleetWorkspaceHandlerFunc
	}
	lockFleetWorkspaceControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockFleetWorkspaceControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *FleetWorkspaceControllerMock) AddHandler(ctx context.Context, name string, handler v31.FleetWorkspaceHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("FleetWorkspaceControllerMock.AddHandlerFunc: method is nil but FleetWorkspaceController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.FleetWorkspaceHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockFleetWorkspaceControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockFleetWorkspaceControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedFleetWorkspaceController.AddHandlerCalls())
func (mock *FleetWorkspaceControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.FleetWorkspaceHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.FleetWorkspaceHandlerFunc
	}
	lockFleetWorkspaceControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockFleetWorkspaceControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *FleetWorkspaceControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("FleetWorkspaceControllerMock.EnqueueFunc: method is nil but FleetWorkspaceController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockFleetWorkspaceControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockFleetWorkspaceControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedFleetWorkspaceController.EnqueueCalls())
func (mock *FleetWorkspaceControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockFleetWorkspaceControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockFleetWorkspaceControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *FleetWorkspaceControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("FleetWorkspaceControllerMock.EnqueueAfterFunc: method is nil but FleetWorkspaceController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockFleetWorkspaceControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockFleetWorkspaceControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedFleetWorkspaceController.EnqueueAfterCalls())
func (mock *FleetWorkspaceControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockFleetWorkspaceControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockFleetWorkspaceControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *FleetWorkspaceControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("FleetWorkspaceControllerMock.GenericFunc: method is nil but FleetWorkspaceController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockFleetWorkspaceControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockFleetWorkspaceControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedFleetWorkspaceController.GenericCalls())
func (mock *FleetWorkspaceControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockFleetWorkspaceControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockFleetWorkspaceControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *FleetWorkspaceControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("FleetWorkspaceControllerMock.InformerFunc: method is nil but FleetWorkspaceController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockFleetWorkspaceControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockFleetWorkspaceControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedFleetWorkspaceController.InformerCalls())
func (mock *FleetWorkspaceControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockFleetWorkspaceControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockFleetWorkspaceControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *FleetWorkspaceControllerMock) Lister() v31.FleetWorkspaceLister {
	if mock.ListerFunc == nil {
		panic("FleetWorkspaceControllerMock.ListerFunc: method is nil but FleetWorkspaceController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockFleetWorkspaceControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockFleetWorkspaceControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedFleetWorkspaceController.ListerCalls())
func (mock *FleetWorkspaceControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockFleetWorkspaceControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockFleetWorkspaceControllerMockLister.RUnlock()
	return calls
}

var (
	lockFleetWorkspaceInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockFleetWorkspaceInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockFleetWorkspaceInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockFleetWorkspaceInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockFleetWorkspaceInterfaceMockAddFeatureHandler                sync.RWMutex
	lockFleetWorkspaceInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockFleetWorkspaceInterfaceMockAddHandler                       sync.RWMutex
	lockFleetWorkspaceInterfaceMockAddLifecycle                     sync.RWMutex
	lockFleetWorkspaceInterfaceMockController                       sync.RWMutex
	lockFleetWorkspaceInterfaceMockCreate                           sync.RWMutex
	lockFleetWorkspaceInterfaceMockDelete                           sync.RWMutex
	lockFleetWorkspaceInterfaceMockDeleteCollection                 sync.RWMutex
	lockFleetWorkspaceInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockFleetWorkspaceInterfaceMockGet                              sync.RWMutex
	lockFleetWorkspaceInterfaceMockGetNamespaced                    sync.RWMutex
	lockFleetWorkspaceInterfaceMockList                             sync.RWMutex
	lockFleetWorkspaceInterfaceMockListNamespaced                   sync.RWMutex
	lockFleetWorkspaceInterfaceMockObjectClient                     sync.RWMutex
	lockFleetWorkspaceInterfaceMockUpdate                           sync.RWMutex
	lockFleetWorkspaceInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that FleetWorkspaceInterfaceMock does implement v31.FleetWorkspaceInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.FleetWorkspaceInterface = &FleetWorkspaceInterfaceMock{}

// FleetWorkspaceInterfaceMock is a mock implementation of v31.FleetWorkspaceInterface.
//
//     func TestSomethingThatUsesFleetWorkspaceInterface(t *testing.T) {
//
//         // make and configure a mocked v31.FleetWorkspaceInterface
//         mockedFleetWorkspaceInterface := &FleetWorkspaceInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.FleetWorkspaceHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.FleetWorkspaceLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.FleetWorkspaceHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.FleetWorkspaceLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.FleetWorkspaceHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.FleetWorkspaceLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.FleetWorkspaceHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.FleetWorkspaceLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.FleetWorkspaceController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.FleetWorkspace) (*v3.FleetWorkspace, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.FleetWorkspace, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.FleetWorkspace, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.FleetWorkspaceList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.FleetWorkspaceList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.FleetWorkspace) (*v3.FleetWorkspace, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedFleetWorkspaceInterface in code that requires v31.FleetWorkspaceInterface
//         // and then make assertions.
//
//     }
type FleetWorkspaceInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.FleetWorkspaceHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.FleetWorkspaceLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.FleetWorkspaceHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.FleetWorkspaceLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.FleetWorkspaceHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.FleetWorkspaceLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.FleetWorkspaceHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.FleetWorkspaceLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.FleetWorkspaceController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.FleetWorkspace) (*v3.FleetWorkspace, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.FleetWorkspace, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.FleetWorkspace, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.FleetWorkspaceList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.FleetWorkspaceList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.FleetWorkspace) (*v3.FleetWorkspace, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.FleetWorkspaceHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.FleetWorkspaceLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.FleetWorkspaceHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.FleetWorkspaceLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.FleetWorkspaceHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.FleetWorkspaceLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.FleetWorkspaceHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.FleetWorkspaceLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.FleetWorkspace
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.FleetWorkspace
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *FleetWorkspaceInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.FleetWorkspaceHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("FleetWorkspaceInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but FleetWorkspaceInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.FleetWorkspaceHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockFleetWorkspaceInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockFleetWorkspaceInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedFleetWorkspaceInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *FleetWorkspaceInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.FleetWorkspaceHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.FleetWorkspaceHandlerFunc
	}
	lockFleetWorkspaceInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockFleetWorkspaceInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *FleetWorkspaceInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.FleetWorkspaceLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("FleetWorkspaceInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but FleetWorkspaceInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.FleetWorkspaceLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockFleetWorkspaceInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockFleetWorkspaceInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedFleetWorkspaceInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *FleetWorkspaceInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.FleetWorkspaceLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.FleetWorkspaceLifecycle
	}
	lockFleetWorkspaceInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockFleetWorkspaceInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *FleetWorkspaceInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.FleetWorkspaceHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("FleetWorkspaceInterfaceMock.AddClusterScopedHandlerFunc: method is nil but FleetWorkspaceInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.FleetWorkspaceHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockFleetWorkspaceInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockFleetWorkspaceInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedFleetWorkspaceInterface.AddClusterScopedHandlerCalls())
func (mock *FleetWorkspaceInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.FleetWorkspaceHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.FleetWorkspaceHandlerFunc
	}
	lockFleetWorkspaceInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockFleetWorkspaceInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *FleetWorkspaceInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.FleetWorkspaceLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("FleetWorkspaceInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but FleetWorkspaceInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.FleetWorkspaceLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockFleetWorkspaceInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockFleetWorkspaceInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedFleetWorkspaceInterface.AddClusterScopedLifecycleCalls())
func (mock *FleetWorkspaceInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.FleetWorkspaceLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.FleetWorkspaceLifecycle
	}
	lockFleetWorkspaceInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockFleetWorkspaceInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *FleetWorkspaceInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.FleetWorkspaceHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("FleetWorkspaceInterfaceMock.AddFeatureHandlerFunc: method is nil but FleetWorkspaceInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.FleetWorkspaceHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockFleetWorkspaceInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockFleetWorkspaceInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedFleetWorkspaceInterface.AddFeatureHandlerCalls())
func (mock *FleetWorkspaceInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.FleetWorkspaceHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.FleetWorkspaceHandlerFunc
	}
	lockFleetWorkspaceInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockFleetWorkspaceInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *FleetWorkspaceInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.FleetWorkspaceLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("FleetWorkspaceInterfaceMock.AddFeatureLifecycleFunc: method is nil but FleetWorkspaceInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.FleetWorkspaceLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockFleetWorkspaceInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockFleetWorkspaceInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedFleetWorkspaceInterface.AddFeatureLifecycleCalls())
func (mock *FleetWorkspaceInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.FleetWorkspaceLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.FleetWorkspaceLifecycle
	}
	lockFleetWorkspaceInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockFleetWorkspaceInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *FleetWorkspaceInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.FleetWorkspaceHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("FleetWorkspaceInterfaceMock.AddHandlerFunc: method is nil but FleetWorkspaceInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.FleetWorkspaceHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockFleetWorkspaceInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockFleetWorkspaceInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedFleetWorkspaceInterface.AddHandlerCalls())
func (mock *FleetWorkspaceInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.FleetWorkspaceHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.FleetWorkspaceHandlerFunc
	}
	lockFleetWorkspaceInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockFleetWorkspaceInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *FleetWorkspaceInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.FleetWorkspaceLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("FleetWorkspaceInterfaceMock.AddLifecycleFunc: method is nil but FleetWorkspaceInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.FleetWorkspaceLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockFleetWorkspaceInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockFleetWorkspaceInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedFleetWorkspaceInterface.AddLifecycleCalls())
func (mock *FleetWorkspaceInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.FleetWorkspaceLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.FleetWorkspaceLifecycle
	}
	lockFleetWorkspaceInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockFleetWorkspaceInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *FleetWorkspaceInterfaceMock) Controller() v31.FleetWorkspaceController {
	if mock.ControllerFunc == nil {
		panic("FleetWorkspaceInterfaceMock.ControllerFunc: method is nil but FleetWorkspaceInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockFleetWorkspaceInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockFleetWorkspaceInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedFleetWorkspaceInterface.ControllerCalls())
func (mock *FleetWorkspaceInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockFleetWorkspaceInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockFleetWorkspaceInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *FleetWorkspaceInterfaceMock) Create(in1 *v3.FleetWorkspace) (*v3.FleetWorkspace, error) {
	if mock.CreateFunc == nil {
		panic("FleetWorkspaceInterfaceMock.CreateFunc: method is nil but FleetWorkspaceInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.FleetWorkspace
	}{
		In1: in1,
	}
	lockFleetWorkspaceInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockFleetWorkspaceInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedFleetWorkspaceInterface.CreateCalls())
func (mock *FleetWorkspaceInterfaceMock) CreateCalls() []struct {
	In1 *v3.FleetWorkspace
} {
	var calls []struct {
		In1 *v3.FleetWorkspace
	}
	lockFleetWorkspaceInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockFleetWorkspaceInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *FleetWorkspaceInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("FleetWorkspaceInterfaceMock.DeleteFunc: method is nil but FleetWorkspaceInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockFleetWorkspaceInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockFleetWorkspaceInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedFleetWorkspaceInterface.DeleteCalls())
func (mock *FleetWorkspaceInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockFleetWorkspaceInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockFleetWorkspaceInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *FleetWorkspaceInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("FleetWorkspaceInterfaceMock.DeleteCollectionFunc: method is nil but FleetWorkspaceInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockFleetWorkspaceInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockFleetWorkspaceInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedFleetWorkspaceInterface.DeleteCollectionCalls())
func (mock *FleetWorkspaceInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockFleetWorkspaceInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockFleetWorkspaceInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *FleetWorkspaceInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("FleetWorkspaceInterfaceMock.DeleteNamespacedFunc: method is nil but FleetWorkspaceInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockFleetWorkspaceInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockFleetWorkspaceInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedFleetWorkspaceInterface.DeleteNamespacedCalls())
func (mock *FleetWorkspaceInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockFleetWorkspaceInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockFleetWorkspaceInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *FleetWorkspaceInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.FleetWorkspace, error) {
	if mock.GetFunc == nil {
		panic("FleetWorkspaceInterfaceMock.GetFunc: method is nil but FleetWorkspaceInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockFleetWorkspaceInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockFleetWorkspaceInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedFleetWorkspaceInterface.GetCalls())
func (mock *FleetWorkspaceInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockFleetWorkspaceInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockFleetWorkspaceInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *FleetWorkspaceInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.FleetWorkspace, error) {
	if mock.GetNamespacedFunc == nil {
		panic("FleetWorkspaceInterfaceMock.GetNamespacedFunc: method is nil but FleetWorkspaceInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockFleetWorkspaceInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockFleetWorkspaceInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedFleetWorkspaceInterface.GetNamespacedCalls())
func (mock *FleetWorkspaceInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockFleetWorkspaceInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockFleetWorkspaceInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *FleetWorkspaceInterfaceMock) List(opts metav1.ListOptions) (*v3.FleetWorkspaceList, error) {
	if mock.ListFunc == nil {
		panic("FleetWorkspaceInterfaceMock.ListFunc: method is nil but FleetWorkspaceInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockFleetWorkspaceInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockFleetWorkspaceInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedFleetWorkspaceInterface.ListCalls())
func (mock *FleetWorkspaceInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockFleetWorkspaceInterfaceMockList.RLock()
	calls = mock.calls.List
	lockFleetWorkspaceInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *FleetWorkspaceInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.FleetWorkspaceList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("FleetWorkspaceInterfaceMock.ListNamespacedFunc: method is nil but FleetWorkspaceInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockFleetWorkspaceInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockFleetWorkspaceInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedFleetWorkspaceInterface.ListNamespacedCalls())
func (mock *FleetWorkspaceInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockFleetWorkspaceInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockFleetWorkspaceInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *FleetWorkspaceInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("FleetWorkspaceInterfaceMock.ObjectClientFunc: method is nil but FleetWorkspaceInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockFleetWorkspaceInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockFleetWorkspaceInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedFleetWorkspaceInterface.ObjectClientCalls())
func (mock *FleetWorkspaceInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockFleetWorkspaceInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockFleetWorkspaceInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *FleetWorkspaceInterfaceMock) Update(in1 *v3.FleetWorkspace) (*v3.FleetWorkspace, error) {
	if mock.UpdateFunc == nil {
		panic("FleetWorkspaceInterfaceMock.UpdateFunc: method is nil but FleetWorkspaceInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.FleetWorkspace
	}{
		In1: in1,
	}
	lockFleetWorkspaceInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockFleetWorkspaceInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedFleetWorkspaceInterface.UpdateCalls())
func (mock *FleetWorkspaceInterfaceMock) UpdateCalls() []struct {
	In1 *v3.FleetWorkspace
} {
	var calls []struct {
		In1 *v3.FleetWorkspace
	}
	lockFleetWorkspaceInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockFleetWorkspaceInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *FleetWorkspaceInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("FleetWorkspaceInterfaceMock.WatchFunc: method is nil but FleetWorkspaceInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockFleetWorkspaceInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockFleetWorkspaceInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedFleetWorkspaceInterface.WatchCalls())
func (mock *FleetWorkspaceInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockFleetWorkspaceInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockFleetWorkspaceInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockFleetWorkspacesGetterMockFleetWorkspaces sync.RWMutex
)

// Ensure, that FleetWorkspacesGetterMock does implement v31.FleetWorkspacesGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.FleetWorkspacesGetter = &FleetWorkspacesGetterMock{}

// FleetWorkspacesGetterMock is a mock implementation of v31.FleetWorkspacesGetter.
//
//     func TestSomethingThatUsesFleetWorkspacesGetter(t *testing.T) {
//
//         // make and configure a mocked v31.FleetWorkspacesGetter
//         mockedFleetWorkspacesGetter := &FleetWorkspacesGetterMock{
//             FleetWorkspacesFunc: func(namespace string) v31.FleetWorkspaceInterface {
// 	               panic("mock out the FleetWorkspaces method")
//             },
//         }
//
//         // use mockedFleetWorkspacesGetter in code that requires v31.FleetWorkspacesGetter
//         // and then make assertions.
//
//     }
type FleetWorkspacesGetterMock struct {
	// FleetWorkspacesFunc mocks the FleetWorkspaces method.
	FleetWorkspacesFunc func(namespace string) v31.FleetWorkspaceInterface

	// calls tracks calls to the methods.
	calls struct {
		// FleetWorkspaces holds details about calls to the FleetWorkspaces method.
		FleetWorkspaces []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// FleetWorkspaces calls FleetWorkspacesFunc.
func (mock *FleetWorkspacesGetterMock) FleetWorkspaces(namespace string) v31.FleetWorkspaceInterface {
	if mock.FleetWorkspacesFunc == nil {
		panic("FleetWorkspacesGetterMock.FleetWorkspacesFunc: method is nil but FleetWorkspacesGetter.FleetWorkspaces was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockFleetWorkspacesGetterMockFleetWorkspaces.Lock()
	mock.calls.FleetWorkspaces = append(mock.calls.FleetWorkspaces, callInfo)
	lockFleetWorkspacesGetterMockFleetWorkspaces.Unlock()
	return mock.FleetWorkspacesFunc(namespace)
}

// FleetWorkspacesCalls gets all the calls that were made to FleetWorkspaces.
// Check the length with:
//     len(mockedFleetWorkspacesGetter.FleetWorkspacesCalls())
func (mock *FleetWorkspacesGetterMock) FleetWorkspacesCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockFleetWorkspacesGetterMockFleetWorkspaces.RLock()
	calls = mock.calls.FleetWorkspaces
	lockFleetWorkspacesGetterMockFleetWorkspaces.RUnlock()
	return calls
}
