// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockGlobalDnsListerMockGet  sync.RWMutex
	lockGlobalDnsListerMockList sync.RWMutex
)

// Ensure, that GlobalDnsListerMock does implement v31.GlobalDnsLister.
// If this is not the case, regenerate this file with moq.
var _ v31.GlobalDnsLister = &GlobalDnsListerMock{}

// GlobalDnsListerMock is a mock implementation of v31.GlobalDnsLister.
//
//     func TestSomethingThatUsesGlobalDnsLister(t *testing.T) {
//
//         // make and configure a mocked v31.GlobalDnsLister
//         mockedGlobalDnsLister := &GlobalDnsListerMock{
//             GetFunc: func(namespace string, name string) (*v3.GlobalDns, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.GlobalDns, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedGlobalDnsLister in code that requires v31.GlobalDnsLister
//         // and then make assertions.
//
//     }
type GlobalDnsListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.GlobalDns, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.GlobalDns, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *GlobalDnsListerMock) Get(namespace string, name string) (*v3.GlobalDns, error) {
	if mock.GetFunc == nil {
		panic("GlobalDnsListerMock.GetFunc: method is nil but GlobalDnsLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockGlobalDnsListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockGlobalDnsListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedGlobalDnsLister.GetCalls())
func (mock *GlobalDnsListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockGlobalDnsListerMockGet.RLock()
	calls = mock.calls.Get
	lockGlobalDnsListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *GlobalDnsListerMock) List(namespace string, selector labels.Selector) ([]*v3.GlobalDns, error) {
	if mock.ListFunc == nil {
		panic("GlobalDnsListerMock.ListFunc: method is nil but GlobalDnsLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockGlobalDnsListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockGlobalDnsListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedGlobalDnsLister.ListCalls())
func (mock *GlobalDnsListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockGlobalDnsListerMockList.RLock()
	calls = mock.calls.List
	lockGlobalDnsListerMockList.RUnlock()
	return calls
}

var (
	lockGlobalDnsControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockGlobalDnsControllerMockAddClusterScopedHandler        sync.RWMutex
	lockGlobalDnsControllerMockAddFeatureHandler              sync.RWMutex
	lockGlobalDnsControllerMockAddHandler                     sync.RWMutex
	lockGlobalDnsControllerMockEnqueue                        sync.RWMutex
	lockGlobalDnsControllerMockEnqueueAfter                   sync.RWMutex
	lockGlobalDnsControllerMockGeneric                        sync.RWMutex
	lockGlobalDnsControllerMockInformer                       sync.RWMutex
	lockGlobalDnsControllerMockLister                         sync.RWMutex
)

// Ensure, that GlobalDnsControllerMock does implement v31.GlobalDnsController.
// If this is not the case, regenerate this file with moq.
var _ v31.GlobalDnsController = &GlobalDnsControllerMock{}

// GlobalDnsControllerMock is a mock implementation of v31.GlobalDnsController.
//
//     func TestSomethingThatUsesGlobalDnsController(t *testing.T) {
//
//         // make and configure a mocked v31.GlobalDnsController
//         mockedGlobalDnsController := &GlobalDnsControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.GlobalDnsHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.GlobalDnsHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GlobalDnsHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.GlobalDnsHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.GlobalDnsLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedGlobalDnsController in code that requires v31.GlobalDnsController
//         // and then make assertions.
//
//     }
type GlobalDnsControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.GlobalDnsHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.GlobalDnsHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GlobalDnsHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.GlobalDnsHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.GlobalDnsLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.GlobalDnsHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.GlobalDnsHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.GlobalDnsHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.GlobalDnsHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *GlobalDnsControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.GlobalDnsHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("GlobalDnsControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but GlobalDnsController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.GlobalDnsHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockGlobalDnsControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockGlobalDnsControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedGlobalDnsController.AddClusterScopedFeatureHandlerCalls())
func (mock *GlobalDnsControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.GlobalDnsHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.GlobalDnsHandlerFunc
	}
	lockGlobalDnsControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockGlobalDnsControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *GlobalDnsControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.GlobalDnsHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("GlobalDnsControllerMock.AddClusterScopedHandlerFunc: method is nil but GlobalDnsController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.GlobalDnsHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockGlobalDnsControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockGlobalDnsControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedGlobalDnsController.AddClusterScopedHandlerCalls())
func (mock *GlobalDnsControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.GlobalDnsHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.GlobalDnsHandlerFunc
	}
	lockGlobalDnsControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockGlobalDnsControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *GlobalDnsControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GlobalDnsHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("GlobalDnsControllerMock.AddFeatureHandlerFunc: method is nil but GlobalDnsController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.GlobalDnsHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockGlobalDnsControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockGlobalDnsControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedGlobalDnsController.AddFeatureHandlerCalls())
func (mock *GlobalDnsControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.GlobalDnsHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.GlobalDnsHandlerFunc
	}
	lockGlobalDnsControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockGlobalDnsControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *GlobalDnsControllerMock) AddHandler(ctx context.Context, name string, handler v31.GlobalDnsHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("GlobalDnsControllerMock.AddHandlerFunc: method is nil but GlobalDnsController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.GlobalDnsHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockGlobalDnsControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockGlobalDnsControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedGlobalDnsController.AddHandlerCalls())
func (mock *GlobalDnsControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.GlobalDnsHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.GlobalDnsHandlerFunc
	}
	lockGlobalDnsControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockGlobalDnsControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *GlobalDnsControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("GlobalDnsControllerMock.EnqueueFunc: method is nil but GlobalDnsController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockGlobalDnsControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockGlobalDnsControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedGlobalDnsController.EnqueueCalls())
func (mock *GlobalDnsControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockGlobalDnsControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockGlobalDnsControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *GlobalDnsControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("GlobalDnsControllerMock.EnqueueAfterFunc: method is nil but GlobalDnsController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockGlobalDnsControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockGlobalDnsControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedGlobalDnsController.EnqueueAfterCalls())
func (mock *GlobalDnsControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockGlobalDnsControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockGlobalDnsControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *GlobalDnsControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("GlobalDnsControllerMock.GenericFunc: method is nil but GlobalDnsController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockGlobalDnsControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockGlobalDnsControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedGlobalDnsController.GenericCalls())
func (mock *GlobalDnsControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockGlobalDnsControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockGlobalDnsControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *GlobalDnsControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("GlobalDnsControllerMock.InformerFunc: method is nil but GlobalDnsController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockGlobalDnsControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockGlobalDnsControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedGlobalDnsController.InformerCalls())
func (mock *GlobalDnsControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockGlobalDnsControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockGlobalDnsControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *GlobalDnsControllerMock) Lister() v31.GlobalDnsLister {
	if mock.ListerFunc == nil {
		panic("GlobalDnsControllerMock.ListerFunc: method is nil but GlobalDnsController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockGlobalDnsControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockGlobalDnsControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedGlobalDnsController.ListerCalls())
func (mock *GlobalDnsControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockGlobalDnsControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockGlobalDnsControllerMockLister.RUnlock()
	return calls
}

var (
	lockGlobalDnsInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockGlobalDnsInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockGlobalDnsInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockGlobalDnsInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockGlobalDnsInterfaceMockAddFeatureHandler                sync.RWMutex
	lockGlobalDnsInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockGlobalDnsInterfaceMockAddHandler                       sync.RWMutex
	lockGlobalDnsInterfaceMockAddLifecycle                     sync.RWMutex
	lockGlobalDnsInterfaceMockController                       sync.RWMutex
	lockGlobalDnsInterfaceMockCreate                           sync.RWMutex
	lockGlobalDnsInterfaceMockDelete                           sync.RWMutex
	lockGlobalDnsInterfaceMockDeleteCollection                 sync.RWMutex
	lockGlobalDnsInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockGlobalDnsInterfaceMockGet                              sync.RWMutex
	lockGlobalDnsInterfaceMockGetNamespaced                    sync.RWMutex
	lockGlobalDnsInterfaceMockList                             sync.RWMutex
	lockGlobalDnsInterfaceMockListNamespaced                   sync.RWMutex
	lockGlobalDnsInterfaceMockObjectClient                     sync.RWMutex
	lockGlobalDnsInterfaceMockUpdate                           sync.RWMutex
	lockGlobalDnsInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that GlobalDnsInterfaceMock does implement v31.GlobalDnsInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.GlobalDnsInterface = &GlobalDnsInterfaceMock{}

// GlobalDnsInterfaceMock is a mock implementation of v31.GlobalDnsInterface.
//
//     func TestSomethingThatUsesGlobalDnsInterface(t *testing.T) {
//
//         // make and configure a mocked v31.GlobalDnsInterface
//         mockedGlobalDnsInterface := &GlobalDnsInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.GlobalDnsHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.GlobalDnsLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.GlobalDnsHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.GlobalDnsLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GlobalDnsHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.GlobalDnsLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.GlobalDnsHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.GlobalDnsLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.GlobalDnsController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.GlobalDns) (*v3.GlobalDns, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.GlobalDns, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.GlobalDns, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.GlobalDnsList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.GlobalDnsList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.GlobalDns) (*v3.GlobalDns, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedGlobalDnsInterface in code that requires v31.GlobalDnsInterface
//         // and then make assertions.
//
//     }
type GlobalDnsInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.GlobalDnsHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.GlobalDnsLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.GlobalDnsHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.GlobalDnsLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GlobalDnsHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.GlobalDnsLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.GlobalDnsHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.GlobalDnsLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.GlobalDnsController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.GlobalDns) (*v3.GlobalDns, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.GlobalDns, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.GlobalDns, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.GlobalDnsList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.GlobalDnsList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.GlobalDns) (*v3.GlobalDns, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.GlobalDnsHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.GlobalDnsLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.GlobalDnsHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.GlobalDnsLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.GlobalDnsHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.GlobalDnsLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.GlobalDnsHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.GlobalDnsLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.GlobalDns
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.GlobalDns
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *GlobalDnsInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.GlobalDnsHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("GlobalDnsInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but GlobalDnsInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.GlobalDnsHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockGlobalDnsInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockGlobalDnsInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedGlobalDnsInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *GlobalDnsInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.GlobalDnsHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.GlobalDnsHandlerFunc
	}
	lockGlobalDnsInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockGlobalDnsInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *GlobalDnsInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.GlobalDnsLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("GlobalDnsInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but GlobalDnsInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.GlobalDnsLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockGlobalDnsInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockGlobalDnsInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedGlobalDnsInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *GlobalDnsInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.GlobalDnsLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.GlobalDnsLifecycle
	}
	lockGlobalDnsInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockGlobalDnsInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *GlobalDnsInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.GlobalDnsHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("GlobalDnsInterfaceMock.AddClusterScopedHandlerFunc: method is nil but GlobalDnsInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.GlobalDnsHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockGlobalDnsInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockGlobalDnsInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedGlobalDnsInterface.AddClusterScopedHandlerCalls())
func (mock *GlobalDnsInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.GlobalDnsHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.GlobalDnsHandlerFunc
	}
	lockGlobalDnsInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockGlobalDnsInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *GlobalDnsInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.GlobalDnsLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("GlobalDnsInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but GlobalDnsInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.GlobalDnsLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockGlobalDnsInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockGlobalDnsInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedGlobalDnsInterface.AddClusterScopedLifecycleCalls())
func (mock *GlobalDnsInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.GlobalDnsLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.GlobalDnsLifecycle
	}
	lockGlobalDnsInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockGlobalDnsInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *GlobalDnsInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GlobalDnsHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("GlobalDnsInterfaceMock.AddFeatureHandlerFunc: method is nil but GlobalDnsInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.GlobalDnsHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockGlobalDnsInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockGlobalDnsInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedGlobalDnsInterface.AddFeatureHandlerCalls())
func (mock *GlobalDnsInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.GlobalDnsHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.GlobalDnsHandlerFunc
	}
	lockGlobalDnsInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockGlobalDnsInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *GlobalDnsInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.GlobalDnsLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("GlobalDnsInterfaceMock.AddFeatureLifecycleFunc: method is nil but GlobalDnsInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.GlobalDnsLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockGlobalDnsInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockGlobalDnsInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedGlobalDnsInterface.AddFeatureLifecycleCalls())
func (mock *GlobalDnsInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.GlobalDnsLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.GlobalDnsLifecycle
	}
	lockGlobalDnsInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockGlobalDnsInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *GlobalDnsInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.GlobalDnsHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("GlobalDnsInterfaceMock.AddHandlerFunc: method is nil but GlobalDnsInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.GlobalDnsHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockGlobalDnsInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockGlobalDnsInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedGlobalDnsInterface.AddHandlerCalls())
func (mock *GlobalDnsInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.GlobalDnsHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.GlobalDnsHandlerFunc
	}
	lockGlobalDnsInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockGlobalDnsInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *GlobalDnsInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.GlobalDnsLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("GlobalDnsInterfaceMock.AddLifecycleFunc: method is nil but GlobalDnsInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.GlobalDnsLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockGlobalDnsInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockGlobalDnsInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedGlobalDnsInterface.AddLifecycleCalls())
func (mock *GlobalDnsInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.GlobalDnsLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.GlobalDnsLifecycle
	}
	lockGlobalDnsInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockGlobalDnsInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *GlobalDnsInterfaceMock) Controller() v31.GlobalDnsController {
	if mock.ControllerFunc == nil {
		panic("GlobalDnsInterfaceMock.ControllerFunc: method is nil but GlobalDnsInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockGlobalDnsInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockGlobalDnsInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedGlobalDnsInterface.ControllerCalls())
func (mock *GlobalDnsInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockGlobalDnsInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockGlobalDnsInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *GlobalDnsInterfaceMock) Create(in1 *v3.GlobalDns) (*v3.GlobalDns, error) {
	if mock.CreateFunc == nil {
		panic("GlobalDnsInterfaceMock.CreateFunc: method is nil but GlobalDnsInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.GlobalDns
	}{
		In1: in1,
	}
	lockGlobalDnsInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockGlobalDnsInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedGlobalDnsInterface.CreateCalls())
func (mock *GlobalDnsInterfaceMock) CreateCalls() []struct {
	In1 *v3.GlobalDns
} {
	var calls []struct {
		In1 *v3.GlobalDns
	}
	lockGlobalDnsInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockGlobalDnsInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *GlobalDnsInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("GlobalDnsInterfaceMock.DeleteFunc: method is nil but GlobalDnsInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockGlobalDnsInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockGlobalDnsInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedGlobalDnsInterface.DeleteCalls())
func (mock *GlobalDnsInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockGlobalDnsInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockGlobalDnsInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *GlobalDnsInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("GlobalDnsInterfaceMock.DeleteCollectionFunc: method is nil but GlobalDnsInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockGlobalDnsInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockGlobalDnsInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedGlobalDnsInterface.DeleteCollectionCalls())
func (mock *GlobalDnsInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockGlobalDnsInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockGlobalDnsInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *GlobalDnsInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("GlobalDnsInterfaceMock.DeleteNamespacedFunc: method is nil but GlobalDnsInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockGlobalDnsInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockGlobalDnsInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedGlobalDnsInterface.DeleteNamespacedCalls())
func (mock *GlobalDnsInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockGlobalDnsInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockGlobalDnsInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *GlobalDnsInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.GlobalDns, error) {
	if mock.GetFunc == nil {
		panic("GlobalDnsInterfaceMock.GetFunc: method is nil but GlobalDnsInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockGlobalDnsInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockGlobalDnsInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedGlobalDnsInterface.GetCalls())
func (mock *GlobalDnsInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockGlobalDnsInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockGlobalDnsInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *GlobalDnsInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.GlobalDns, error) {
	if mock.GetNamespacedFunc == nil {
		panic("GlobalDnsInterfaceMock.GetNamespacedFunc: method is nil but GlobalDnsInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockGlobalDnsInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockGlobalDnsInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedGlobalDnsInterface.GetNamespacedCalls())
func (mock *GlobalDnsInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockGlobalDnsInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockGlobalDnsInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *GlobalDnsInterfaceMock) List(opts metav1.ListOptions) (*v3.GlobalDnsList, error) {
	if mock.ListFunc == nil {
		panic("GlobalDnsInterfaceMock.ListFunc: method is nil but GlobalDnsInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockGlobalDnsInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockGlobalDnsInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedGlobalDnsInterface.ListCalls())
func (mock *GlobalDnsInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockGlobalDnsInterfaceMockList.RLock()
	calls = mock.calls.List
	lockGlobalDnsInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *GlobalDnsInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.GlobalDnsList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("GlobalDnsInterfaceMock.ListNamespacedFunc: method is nil but GlobalDnsInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockGlobalDnsInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockGlobalDnsInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedGlobalDnsInterface.ListNamespacedCalls())
func (mock *GlobalDnsInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockGlobalDnsInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockGlobalDnsInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *GlobalDnsInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("GlobalDnsInterfaceMock.ObjectClientFunc: method is nil but GlobalDnsInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockGlobalDnsInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockGlobalDnsInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedGlobalDnsInterface.ObjectClientCalls())
func (mock *GlobalDnsInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockGlobalDnsInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockGlobalDnsInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *GlobalDnsInterfaceMock) Update(in1 *v3.GlobalDns) (*v3.GlobalDns, error) {
	if mock.UpdateFunc == nil {
		panic("GlobalDnsInterfaceMock.UpdateFunc: method is nil but GlobalDnsInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.GlobalDns
	}{
		In1: in1,
	}
	lockGlobalDnsInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockGlobalDnsInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedGlobalDnsInterface.UpdateCalls())
func (mock *GlobalDnsInterfaceMock) UpdateCalls() []struct {
	In1 *v3.GlobalDns
} {
	var calls []struct {
		In1 *v3.GlobalDns
	}
	lockGlobalDnsInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockGlobalDnsInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *GlobalDnsInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("GlobalDnsInterfaceMock.WatchFunc: method is nil but GlobalDnsInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockGlobalDnsInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockGlobalDnsInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedGlobalDnsInterface.WatchCalls())
func (mock *GlobalDnsInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockGlobalDnsInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockGlobalDnsInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockGlobalDnsesGetterMockGlobalDnses sync.RWMutex
)

// Ensure, that GlobalDnsesGetterMock does implement v31.GlobalDnsesGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.GlobalDnsesGetter = &GlobalDnsesGetterMock{}

// GlobalDnsesGetterMock is a mock implementation of v31.GlobalDnsesGetter.
//
//     func TestSomethingThatUsesGlobalDnsesGetter(t *testing.T) {
//
//         // make and configure a mocked v31.GlobalDnsesGetter
//         mockedGlobalDnsesGetter := &GlobalDnsesGetterMock{
//             GlobalDnsesFunc: func(namespace string) v31.GlobalDnsInterface {
// 	               panic("mock out the GlobalDnses method")
//             },
//         }
//
//         // use mockedGlobalDnsesGetter in code that requires v31.GlobalDnsesGetter
//         // and then make assertions.
//
//     }
type GlobalDnsesGetterMock struct {
	// GlobalDnsesFunc mocks the GlobalDnses method.
	GlobalDnsesFunc func(namespace string) v31.GlobalDnsInterface

	// calls tracks calls to the methods.
	calls struct {
		// GlobalDnses holds details about calls to the GlobalDnses method.
		GlobalDnses []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// GlobalDnses calls GlobalDnsesFunc.
func (mock *GlobalDnsesGetterMock) GlobalDnses(namespace string) v31.GlobalDnsInterface {
	if mock.GlobalDnsesFunc == nil {
		panic("GlobalDnsesGetterMock.GlobalDnsesFunc: method is nil but GlobalDnsesGetter.GlobalDnses was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockGlobalDnsesGetterMockGlobalDnses.Lock()
	mock.calls.GlobalDnses = append(mock.calls.GlobalDnses, callInfo)
	lockGlobalDnsesGetterMockGlobalDnses.Unlock()
	return mock.GlobalDnsesFunc(namespace)
}

// GlobalDnsesCalls gets all the calls that were made to GlobalDnses.
// Check the length with:
//     len(mockedGlobalDnsesGetter.GlobalDnsesCalls())
func (mock *GlobalDnsesGetterMock) GlobalDnsesCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockGlobalDnsesGetterMockGlobalDnses.RLock()
	calls = mock.calls.GlobalDnses
	lockGlobalDnsesGetterMockGlobalDnses.RUnlock()
	return calls
}
