// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockGlobalDnsProviderListerMockGet  sync.RWMutex
	lockGlobalDnsProviderListerMockList sync.RWMutex
)

// Ensure, that GlobalDnsProviderListerMock does implement v31.GlobalDnsProviderLister.
// If this is not the case, regenerate this file with moq.
var _ v31.GlobalDnsProviderLister = &GlobalDnsProviderListerMock{}

// GlobalDnsProviderListerMock is a mock implementation of v31.GlobalDnsProviderLister.
//
//     func TestSomethingThatUsesGlobalDnsProviderLister(t *testing.T) {
//
//         // make and configure a mocked v31.GlobalDnsProviderLister
//         mockedGlobalDnsProviderLister := &GlobalDnsProviderListerMock{
//             GetFunc: func(namespace string, name string) (*v3.GlobalDnsProvider, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.GlobalDnsProvider, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedGlobalDnsProviderLister in code that requires v31.GlobalDnsProviderLister
//         // and then make assertions.
//
//     }
type GlobalDnsProviderListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.GlobalDnsProvider, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.GlobalDnsProvider, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *GlobalDnsProviderListerMock) Get(namespace string, name string) (*v3.GlobalDnsProvider, error) {
	if mock.GetFunc == nil {
		panic("GlobalDnsProviderListerMock.GetFunc: method is nil but GlobalDnsProviderLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockGlobalDnsProviderListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockGlobalDnsProviderListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedGlobalDnsProviderLister.GetCalls())
func (mock *GlobalDnsProviderListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockGlobalDnsProviderListerMockGet.RLock()
	calls = mock.calls.Get
	lockGlobalDnsProviderListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *GlobalDnsProviderListerMock) List(namespace string, selector labels.Selector) ([]*v3.GlobalDnsProvider, error) {
	if mock.ListFunc == nil {
		panic("GlobalDnsProviderListerMock.ListFunc: method is nil but GlobalDnsProviderLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockGlobalDnsProviderListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockGlobalDnsProviderListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedGlobalDnsProviderLister.ListCalls())
func (mock *GlobalDnsProviderListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockGlobalDnsProviderListerMockList.RLock()
	calls = mock.calls.List
	lockGlobalDnsProviderListerMockList.RUnlock()
	return calls
}

var (
	lockGlobalDnsProviderControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockGlobalDnsProviderControllerMockAddClusterScopedHandler        sync.RWMutex
	lockGlobalDnsProviderControllerMockAddFeatureHandler              sync.RWMutex
	lockGlobalDnsProviderControllerMockAddHandler                     sync.RWMutex
	lockGlobalDnsProviderControllerMockEnqueue                        sync.RWMutex
	lockGlobalDnsProviderControllerMockEnqueueAfter                   sync.RWMutex
	lockGlobalDnsProviderControllerMockGeneric                        sync.RWMutex
	lockGlobalDnsProviderControllerMockInformer                       sync.RWMutex
	lockGlobalDnsProviderControllerMockLister                         sync.RWMutex
)

// Ensure, that GlobalDnsProviderControllerMock does implement v31.GlobalDnsProviderController.
// If this is not the case, regenerate this file with moq.
var _ v31.GlobalDnsProviderController = &GlobalDnsProviderControllerMock{}

// GlobalDnsProviderControllerMock is a mock implementation of v31.GlobalDnsProviderController.
//
//     func TestSomethingThatUsesGlobalDnsProviderController(t *testing.T) {
//
//         // make and configure a mocked v31.GlobalDnsProviderController
//         mockedGlobalDnsProviderController := &GlobalDnsProviderControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.GlobalDnsProviderHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.GlobalDnsProviderHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GlobalDnsProviderHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.GlobalDnsProviderHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.GlobalDnsProviderLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedGlobalDnsProviderController in code that requires v31.GlobalDnsProviderController
//         // and then make assertions.
//
//     }
type GlobalDnsProviderControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.GlobalDnsProviderHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.GlobalDnsProviderHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GlobalDnsProviderHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.GlobalDnsProviderHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.GlobalDnsProviderLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.GlobalDnsProviderHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.GlobalDnsProviderHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.GlobalDnsProviderHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.GlobalDnsProviderHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *GlobalDnsProviderControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.GlobalDnsProviderHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("GlobalDnsProviderControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but GlobalDnsProviderController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.GlobalDnsProviderHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockGlobalDnsProviderControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockGlobalDnsProviderControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedGlobalDnsProviderController.AddClusterScopedFeatureHandlerCalls())
func (mock *GlobalDnsProviderControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.GlobalDnsProviderHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.GlobalDnsProviderHandlerFunc
	}
	lockGlobalDnsProviderControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockGlobalDnsProviderControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *GlobalDnsProviderControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.GlobalDnsProviderHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("GlobalDnsProviderControllerMock.AddClusterScopedHandlerFunc: method is nil but GlobalDnsProviderController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.GlobalDnsProviderHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockGlobalDnsProviderControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockGlobalDnsProviderControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedGlobalDnsProviderController.AddClusterScopedHandlerCalls())
func (mock *GlobalDnsProviderControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.GlobalDnsProviderHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.GlobalDnsProviderHandlerFunc
	}
	lockGlobalDnsProviderControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockGlobalDnsProviderControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *GlobalDnsProviderControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GlobalDnsProviderHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("GlobalDnsProviderControllerMock.AddFeatureHandlerFunc: method is nil but GlobalDnsProviderController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.GlobalDnsProviderHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockGlobalDnsProviderControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockGlobalDnsProviderControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedGlobalDnsProviderController.AddFeatureHandlerCalls())
func (mock *GlobalDnsProviderControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.GlobalDnsProviderHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.GlobalDnsProviderHandlerFunc
	}
	lockGlobalDnsProviderControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockGlobalDnsProviderControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *GlobalDnsProviderControllerMock) AddHandler(ctx context.Context, name string, handler v31.GlobalDnsProviderHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("GlobalDnsProviderControllerMock.AddHandlerFunc: method is nil but GlobalDnsProviderController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.GlobalDnsProviderHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockGlobalDnsProviderControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockGlobalDnsProviderControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedGlobalDnsProviderController.AddHandlerCalls())
func (mock *GlobalDnsProviderControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.GlobalDnsProviderHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.GlobalDnsProviderHandlerFunc
	}
	lockGlobalDnsProviderControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockGlobalDnsProviderControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *GlobalDnsProviderControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("GlobalDnsProviderControllerMock.EnqueueFunc: method is nil but GlobalDnsProviderController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockGlobalDnsProviderControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockGlobalDnsProviderControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedGlobalDnsProviderController.EnqueueCalls())
func (mock *GlobalDnsProviderControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockGlobalDnsProviderControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockGlobalDnsProviderControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *GlobalDnsProviderControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("GlobalDnsProviderControllerMock.EnqueueAfterFunc: method is nil but GlobalDnsProviderController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockGlobalDnsProviderControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockGlobalDnsProviderControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedGlobalDnsProviderController.EnqueueAfterCalls())
func (mock *GlobalDnsProviderControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockGlobalDnsProviderControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockGlobalDnsProviderControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *GlobalDnsProviderControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("GlobalDnsProviderControllerMock.GenericFunc: method is nil but GlobalDnsProviderController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockGlobalDnsProviderControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockGlobalDnsProviderControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedGlobalDnsProviderController.GenericCalls())
func (mock *GlobalDnsProviderControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockGlobalDnsProviderControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockGlobalDnsProviderControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *GlobalDnsProviderControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("GlobalDnsProviderControllerMock.InformerFunc: method is nil but GlobalDnsProviderController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockGlobalDnsProviderControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockGlobalDnsProviderControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedGlobalDnsProviderController.InformerCalls())
func (mock *GlobalDnsProviderControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockGlobalDnsProviderControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockGlobalDnsProviderControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *GlobalDnsProviderControllerMock) Lister() v31.GlobalDnsProviderLister {
	if mock.ListerFunc == nil {
		panic("GlobalDnsProviderControllerMock.ListerFunc: method is nil but GlobalDnsProviderController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockGlobalDnsProviderControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockGlobalDnsProviderControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedGlobalDnsProviderController.ListerCalls())
func (mock *GlobalDnsProviderControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockGlobalDnsProviderControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockGlobalDnsProviderControllerMockLister.RUnlock()
	return calls
}

var (
	lockGlobalDnsProviderInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockGlobalDnsProviderInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockGlobalDnsProviderInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockGlobalDnsProviderInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockGlobalDnsProviderInterfaceMockAddFeatureHandler                sync.RWMutex
	lockGlobalDnsProviderInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockGlobalDnsProviderInterfaceMockAddHandler                       sync.RWMutex
	lockGlobalDnsProviderInterfaceMockAddLifecycle                     sync.RWMutex
	lockGlobalDnsProviderInterfaceMockController                       sync.RWMutex
	lockGlobalDnsProviderInterfaceMockCreate                           sync.RWMutex
	lockGlobalDnsProviderInterfaceMockDelete                           sync.RWMutex
	lockGlobalDnsProviderInterfaceMockDeleteCollection                 sync.RWMutex
	lockGlobalDnsProviderInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockGlobalDnsProviderInterfaceMockGet                              sync.RWMutex
	lockGlobalDnsProviderInterfaceMockGetNamespaced                    sync.RWMutex
	lockGlobalDnsProviderInterfaceMockList                             sync.RWMutex
	lockGlobalDnsProviderInterfaceMockListNamespaced                   sync.RWMutex
	lockGlobalDnsProviderInterfaceMockObjectClient                     sync.RWMutex
	lockGlobalDnsProviderInterfaceMockUpdate                           sync.RWMutex
	lockGlobalDnsProviderInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that GlobalDnsProviderInterfaceMock does implement v31.GlobalDnsProviderInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.GlobalDnsProviderInterface = &GlobalDnsProviderInterfaceMock{}

// GlobalDnsProviderInterfaceMock is a mock implementation of v31.GlobalDnsProviderInterface.
//
//     func TestSomethingThatUsesGlobalDnsProviderInterface(t *testing.T) {
//
//         // make and configure a mocked v31.GlobalDnsProviderInterface
//         mockedGlobalDnsProviderInterface := &GlobalDnsProviderInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.GlobalDnsProviderHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.GlobalDnsProviderLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.GlobalDnsProviderHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.GlobalDnsProviderLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GlobalDnsProviderHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.GlobalDnsProviderLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.GlobalDnsProviderHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.GlobalDnsProviderLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.GlobalDnsProviderController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.GlobalDnsProvider) (*v3.GlobalDnsProvider, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.GlobalDnsProvider, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.GlobalDnsProvider, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.GlobalDnsProviderList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.GlobalDnsProviderList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.GlobalDnsProvider) (*v3.GlobalDnsProvider, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedGlobalDnsProviderInterface in code that requires v31.GlobalDnsProviderInterface
//         // and then make assertions.
//
//     }
type GlobalDnsProviderInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.GlobalDnsProviderHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.GlobalDnsProviderLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.GlobalDnsProviderHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.GlobalDnsProviderLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GlobalDnsProviderHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.GlobalDnsProviderLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.GlobalDnsProviderHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.GlobalDnsProviderLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.GlobalDnsProviderController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.GlobalDnsProvider) (*v3.GlobalDnsProvider, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.GlobalDnsProvider, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.GlobalDnsProvider, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.GlobalDnsProviderList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.GlobalDnsProviderList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.GlobalDnsProvider) (*v3.GlobalDnsProvider, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.GlobalDnsProviderHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.GlobalDnsProviderLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.GlobalDnsProviderHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.GlobalDnsProviderLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.GlobalDnsProviderHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.GlobalDnsProviderLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.GlobalDnsProviderHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.GlobalDnsProviderLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.GlobalDnsProvider
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.GlobalDnsProvider
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *GlobalDnsProviderInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.GlobalDnsProviderHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("GlobalDnsProviderInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but GlobalDnsProviderInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.GlobalDnsProviderHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockGlobalDnsProviderInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockGlobalDnsProviderInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedGlobalDnsProviderInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *GlobalDnsProviderInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.GlobalDnsProviderHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.GlobalDnsProviderHandlerFunc
	}
	lockGlobalDnsProviderInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockGlobalDnsProviderInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *GlobalDnsProviderInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.GlobalDnsProviderLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("GlobalDnsProviderInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but GlobalDnsProviderInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.GlobalDnsProviderLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockGlobalDnsProviderInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockGlobalDnsProviderInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedGlobalDnsProviderInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *GlobalDnsProviderInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.GlobalDnsProviderLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.GlobalDnsProviderLifecycle
	}
	lockGlobalDnsProviderInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockGlobalDnsProviderInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *GlobalDnsProviderInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.GlobalDnsProviderHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("GlobalDnsProviderInterfaceMock.AddClusterScopedHandlerFunc: method is nil but GlobalDnsProviderInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.GlobalDnsProviderHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockGlobalDnsProviderInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockGlobalDnsProviderInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedGlobalDnsProviderInterface.AddClusterScopedHandlerCalls())
func (mock *GlobalDnsProviderInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.GlobalDnsProviderHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.GlobalDnsProviderHandlerFunc
	}
	lockGlobalDnsProviderInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockGlobalDnsProviderInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *GlobalDnsProviderInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.GlobalDnsProviderLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("GlobalDnsProviderInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but GlobalDnsProviderInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.GlobalDnsProviderLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockGlobalDnsProviderInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockGlobalDnsProviderInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedGlobalDnsProviderInterface.AddClusterScopedLifecycleCalls())
func (mock *GlobalDnsProviderInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.GlobalDnsProviderLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.GlobalDnsProviderLifecycle
	}
	lockGlobalDnsProviderInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockGlobalDnsProviderInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *GlobalDnsProviderInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GlobalDnsProviderHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("GlobalDnsProviderInterfaceMock.AddFeatureHandlerFunc: method is nil but GlobalDnsProviderInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.GlobalDnsProviderHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockGlobalDnsProviderInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockGlobalDnsProviderInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedGlobalDnsProviderInterface.AddFeatureHandlerCalls())
func (mock *GlobalDnsProviderInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.GlobalDnsProviderHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.GlobalDnsProviderHandlerFunc
	}
	lockGlobalDnsProviderInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockGlobalDnsProviderInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *GlobalDnsProviderInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.GlobalDnsProviderLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("GlobalDnsProviderInterfaceMock.AddFeatureLifecycleFunc: method is nil but GlobalDnsProviderInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.GlobalDnsProviderLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockGlobalDnsProviderInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockGlobalDnsProviderInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedGlobalDnsProviderInterface.AddFeatureLifecycleCalls())
func (mock *GlobalDnsProviderInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.GlobalDnsProviderLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.GlobalDnsProviderLifecycle
	}
	lockGlobalDnsProviderInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockGlobalDnsProviderInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *GlobalDnsProviderInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.GlobalDnsProviderHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("GlobalDnsProviderInterfaceMock.AddHandlerFunc: method is nil but GlobalDnsProviderInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.GlobalDnsProviderHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockGlobalDnsProviderInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockGlobalDnsProviderInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedGlobalDnsProviderInterface.AddHandlerCalls())
func (mock *GlobalDnsProviderInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.GlobalDnsProviderHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.GlobalDnsProviderHandlerFunc
	}
	lockGlobalDnsProviderInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockGlobalDnsProviderInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *GlobalDnsProviderInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.GlobalDnsProviderLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("GlobalDnsProviderInterfaceMock.AddLifecycleFunc: method is nil but GlobalDnsProviderInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.GlobalDnsProviderLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockGlobalDnsProviderInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockGlobalDnsProviderInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedGlobalDnsProviderInterface.AddLifecycleCalls())
func (mock *GlobalDnsProviderInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.GlobalDnsProviderLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.GlobalDnsProviderLifecycle
	}
	lockGlobalDnsProviderInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockGlobalDnsProviderInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *GlobalDnsProviderInterfaceMock) Controller() v31.GlobalDnsProviderController {
	if mock.ControllerFunc == nil {
		panic("GlobalDnsProviderInterfaceMock.ControllerFunc: method is nil but GlobalDnsProviderInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockGlobalDnsProviderInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockGlobalDnsProviderInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedGlobalDnsProviderInterface.ControllerCalls())
func (mock *GlobalDnsProviderInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockGlobalDnsProviderInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockGlobalDnsProviderInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *GlobalDnsProviderInterfaceMock) Create(in1 *v3.GlobalDnsProvider) (*v3.GlobalDnsProvider, error) {
	if mock.CreateFunc == nil {
		panic("GlobalDnsProviderInterfaceMock.CreateFunc: method is nil but GlobalDnsProviderInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.GlobalDnsProvider
	}{
		In1: in1,
	}
	lockGlobalDnsProviderInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockGlobalDnsProviderInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedGlobalDnsProviderInterface.CreateCalls())
func (mock *GlobalDnsProviderInterfaceMock) CreateCalls() []struct {
	In1 *v3.GlobalDnsProvider
} {
	var calls []struct {
		In1 *v3.GlobalDnsProvider
	}
	lockGlobalDnsProviderInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockGlobalDnsProviderInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *GlobalDnsProviderInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("GlobalDnsProviderInterfaceMock.DeleteFunc: method is nil but GlobalDnsProviderInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockGlobalDnsProviderInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockGlobalDnsProviderInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedGlobalDnsProviderInterface.DeleteCalls())
func (mock *GlobalDnsProviderInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockGlobalDnsProviderInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockGlobalDnsProviderInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *GlobalDnsProviderInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("GlobalDnsProviderInterfaceMock.DeleteCollectionFunc: method is nil but GlobalDnsProviderInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockGlobalDnsProviderInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockGlobalDnsProviderInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedGlobalDnsProviderInterface.DeleteCollectionCalls())
func (mock *GlobalDnsProviderInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockGlobalDnsProviderInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockGlobalDnsProviderInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *GlobalDnsProviderInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("GlobalDnsProviderInterfaceMock.DeleteNamespacedFunc: method is nil but GlobalDnsProviderInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockGlobalDnsProviderInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockGlobalDnsProviderInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedGlobalDnsProviderInterface.DeleteNamespacedCalls())
func (mock *GlobalDnsProviderInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockGlobalDnsProviderInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockGlobalDnsProviderInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *GlobalDnsProviderInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.GlobalDnsProvider, error) {
	if mock.GetFunc == nil {
		panic("GlobalDnsProviderInterfaceMock.GetFunc: method is nil but GlobalDnsProviderInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockGlobalDnsProviderInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockGlobalDnsProviderInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedGlobalDnsProviderInterface.GetCalls())
func (mock *GlobalDnsProviderInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockGlobalDnsProviderInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockGlobalDnsProviderInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *GlobalDnsProviderInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.GlobalDnsProvider, error) {
	if mock.GetNamespacedFunc == nil {
		panic("GlobalDnsProviderInterfaceMock.GetNamespacedFunc: method is nil but GlobalDnsProviderInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockGlobalDnsProviderInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockGlobalDnsProviderInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedGlobalDnsProviderInterface.GetNamespacedCalls())
func (mock *GlobalDnsProviderInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockGlobalDnsProviderInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockGlobalDnsProviderInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *GlobalDnsProviderInterfaceMock) List(opts metav1.ListOptions) (*v3.GlobalDnsProviderList, error) {
	if mock.ListFunc == nil {
		panic("GlobalDnsProviderInterfaceMock.ListFunc: method is nil but GlobalDnsProviderInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockGlobalDnsProviderInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockGlobalDnsProviderInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedGlobalDnsProviderInterface.ListCalls())
func (mock *GlobalDnsProviderInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockGlobalDnsProviderInterfaceMockList.RLock()
	calls = mock.calls.List
	lockGlobalDnsProviderInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *GlobalDnsProviderInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.GlobalDnsProviderList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("GlobalDnsProviderInterfaceMock.ListNamespacedFunc: method is nil but GlobalDnsProviderInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockGlobalDnsProviderInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockGlobalDnsProviderInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedGlobalDnsProviderInterface.ListNamespacedCalls())
func (mock *GlobalDnsProviderInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockGlobalDnsProviderInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockGlobalDnsProviderInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *GlobalDnsProviderInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("GlobalDnsProviderInterfaceMock.ObjectClientFunc: method is nil but GlobalDnsProviderInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockGlobalDnsProviderInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockGlobalDnsProviderInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedGlobalDnsProviderInterface.ObjectClientCalls())
func (mock *GlobalDnsProviderInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockGlobalDnsProviderInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockGlobalDnsProviderInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *GlobalDnsProviderInterfaceMock) Update(in1 *v3.GlobalDnsProvider) (*v3.GlobalDnsProvider, error) {
	if mock.UpdateFunc == nil {
		panic("GlobalDnsProviderInterfaceMock.UpdateFunc: method is nil but GlobalDnsProviderInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.GlobalDnsProvider
	}{
		In1: in1,
	}
	lockGlobalDnsProviderInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockGlobalDnsProviderInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedGlobalDnsProviderInterface.UpdateCalls())
func (mock *GlobalDnsProviderInterfaceMock) UpdateCalls() []struct {
	In1 *v3.GlobalDnsProvider
} {
	var calls []struct {
		In1 *v3.GlobalDnsProvider
	}
	lockGlobalDnsProviderInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockGlobalDnsProviderInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *GlobalDnsProviderInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("GlobalDnsProviderInterfaceMock.WatchFunc: method is nil but GlobalDnsProviderInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockGlobalDnsProviderInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockGlobalDnsProviderInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedGlobalDnsProviderInterface.WatchCalls())
func (mock *GlobalDnsProviderInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockGlobalDnsProviderInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockGlobalDnsProviderInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockGlobalDnsProvidersGetterMockGlobalDnsProviders sync.RWMutex
)

// Ensure, that GlobalDnsProvidersGetterMock does implement v31.GlobalDnsProvidersGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.GlobalDnsProvidersGetter = &GlobalDnsProvidersGetterMock{}

// GlobalDnsProvidersGetterMock is a mock implementation of v31.GlobalDnsProvidersGetter.
//
//     func TestSomethingThatUsesGlobalDnsProvidersGetter(t *testing.T) {
//
//         // make and configure a mocked v31.GlobalDnsProvidersGetter
//         mockedGlobalDnsProvidersGetter := &GlobalDnsProvidersGetterMock{
//             GlobalDnsProvidersFunc: func(namespace string) v31.GlobalDnsProviderInterface {
// 	               panic("mock out the GlobalDnsProviders method")
//             },
//         }
//
//         // use mockedGlobalDnsProvidersGetter in code that requires v31.GlobalDnsProvidersGetter
//         // and then make assertions.
//
//     }
type GlobalDnsProvidersGetterMock struct {
	// GlobalDnsProvidersFunc mocks the GlobalDnsProviders method.
	GlobalDnsProvidersFunc func(namespace string) v31.GlobalDnsProviderInterface

	// calls tracks calls to the methods.
	calls struct {
		// GlobalDnsProviders holds details about calls to the GlobalDnsProviders method.
		GlobalDnsProviders []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// GlobalDnsProviders calls GlobalDnsProvidersFunc.
func (mock *GlobalDnsProvidersGetterMock) GlobalDnsProviders(namespace string) v31.GlobalDnsProviderInterface {
	if mock.GlobalDnsProvidersFunc == nil {
		panic("GlobalDnsProvidersGetterMock.GlobalDnsProvidersFunc: method is nil but GlobalDnsProvidersGetter.GlobalDnsProviders was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockGlobalDnsProvidersGetterMockGlobalDnsProviders.Lock()
	mock.calls.GlobalDnsProviders = append(mock.calls.GlobalDnsProviders, callInfo)
	lockGlobalDnsProvidersGetterMockGlobalDnsProviders.Unlock()
	return mock.GlobalDnsProvidersFunc(namespace)
}

// GlobalDnsProvidersCalls gets all the calls that were made to GlobalDnsProviders.
// Check the length with:
//     len(mockedGlobalDnsProvidersGetter.GlobalDnsProvidersCalls())
func (mock *GlobalDnsProvidersGetterMock) GlobalDnsProvidersCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockGlobalDnsProvidersGetterMockGlobalDnsProviders.RLock()
	calls = mock.calls.GlobalDnsProviders
	lockGlobalDnsProvidersGetterMockGlobalDnsProviders.RUnlock()
	return calls
}
