// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockGlobalRoleBindingListerMockGet  sync.RWMutex
	lockGlobalRoleBindingListerMockList sync.RWMutex
)

// Ensure, that GlobalRoleBindingListerMock does implement v31.GlobalRoleBindingLister.
// If this is not the case, regenerate this file with moq.
var _ v31.GlobalRoleBindingLister = &GlobalRoleBindingListerMock{}

// GlobalRoleBindingListerMock is a mock implementation of v31.GlobalRoleBindingLister.
//
//     func TestSomethingThatUsesGlobalRoleBindingLister(t *testing.T) {
//
//         // make and configure a mocked v31.GlobalRoleBindingLister
//         mockedGlobalRoleBindingLister := &GlobalRoleBindingListerMock{
//             GetFunc: func(namespace string, name string) (*v3.GlobalRoleBinding, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.GlobalRoleBinding, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedGlobalRoleBindingLister in code that requires v31.GlobalRoleBindingLister
//         // and then make assertions.
//
//     }
type GlobalRoleBindingListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.GlobalRoleBinding, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.GlobalRoleBinding, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *GlobalRoleBindingListerMock) Get(namespace string, name string) (*v3.GlobalRoleBinding, error) {
	if mock.GetFunc == nil {
		panic("GlobalRoleBindingListerMock.GetFunc: method is nil but GlobalRoleBindingLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockGlobalRoleBindingListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockGlobalRoleBindingListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedGlobalRoleBindingLister.GetCalls())
func (mock *GlobalRoleBindingListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockGlobalRoleBindingListerMockGet.RLock()
	calls = mock.calls.Get
	lockGlobalRoleBindingListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *GlobalRoleBindingListerMock) List(namespace string, selector labels.Selector) ([]*v3.GlobalRoleBinding, error) {
	if mock.ListFunc == nil {
		panic("GlobalRoleBindingListerMock.ListFunc: method is nil but GlobalRoleBindingLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockGlobalRoleBindingListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockGlobalRoleBindingListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedGlobalRoleBindingLister.ListCalls())
func (mock *GlobalRoleBindingListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockGlobalRoleBindingListerMockList.RLock()
	calls = mock.calls.List
	lockGlobalRoleBindingListerMockList.RUnlock()
	return calls
}

var (
	lockGlobalRoleBindingControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockGlobalRoleBindingControllerMockAddClusterScopedHandler        sync.RWMutex
	lockGlobalRoleBindingControllerMockAddFeatureHandler              sync.RWMutex
	lockGlobalRoleBindingControllerMockAddHandler                     sync.RWMutex
	lockGlobalRoleBindingControllerMockEnqueue                        sync.RWMutex
	lockGlobalRoleBindingControllerMockEnqueueAfter                   sync.RWMutex
	lockGlobalRoleBindingControllerMockGeneric                        sync.RWMutex
	lockGlobalRoleBindingControllerMockInformer                       sync.RWMutex
	lockGlobalRoleBindingControllerMockLister                         sync.RWMutex
)

// Ensure, that GlobalRoleBindingControllerMock does implement v31.GlobalRoleBindingController.
// If this is not the case, regenerate this file with moq.
var _ v31.GlobalRoleBindingController = &GlobalRoleBindingControllerMock{}

// GlobalRoleBindingControllerMock is a mock implementation of v31.GlobalRoleBindingController.
//
//     func TestSomethingThatUsesGlobalRoleBindingController(t *testing.T) {
//
//         // make and configure a mocked v31.GlobalRoleBindingController
//         mockedGlobalRoleBindingController := &GlobalRoleBindingControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.GlobalRoleBindingHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.GlobalRoleBindingHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GlobalRoleBindingHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.GlobalRoleBindingHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.GlobalRoleBindingLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedGlobalRoleBindingController in code that requires v31.GlobalRoleBindingController
//         // and then make assertions.
//
//     }
type GlobalRoleBindingControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.GlobalRoleBindingHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.GlobalRoleBindingHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GlobalRoleBindingHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.GlobalRoleBindingHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.GlobalRoleBindingLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.GlobalRoleBindingHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.GlobalRoleBindingHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.GlobalRoleBindingHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.GlobalRoleBindingHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *GlobalRoleBindingControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.GlobalRoleBindingHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("GlobalRoleBindingControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but GlobalRoleBindingController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.GlobalRoleBindingHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockGlobalRoleBindingControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockGlobalRoleBindingControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedGlobalRoleBindingController.AddClusterScopedFeatureHandlerCalls())
func (mock *GlobalRoleBindingControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.GlobalRoleBindingHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.GlobalRoleBindingHandlerFunc
	}
	lockGlobalRoleBindingControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockGlobalRoleBindingControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *GlobalRoleBindingControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.GlobalRoleBindingHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("GlobalRoleBindingControllerMock.AddClusterScopedHandlerFunc: method is nil but GlobalRoleBindingController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.GlobalRoleBindingHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockGlobalRoleBindingControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockGlobalRoleBindingControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedGlobalRoleBindingController.AddClusterScopedHandlerCalls())
func (mock *GlobalRoleBindingControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.GlobalRoleBindingHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.GlobalRoleBindingHandlerFunc
	}
	lockGlobalRoleBindingControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockGlobalRoleBindingControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *GlobalRoleBindingControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GlobalRoleBindingHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("GlobalRoleBindingControllerMock.AddFeatureHandlerFunc: method is nil but GlobalRoleBindingController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.GlobalRoleBindingHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockGlobalRoleBindingControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockGlobalRoleBindingControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedGlobalRoleBindingController.AddFeatureHandlerCalls())
func (mock *GlobalRoleBindingControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.GlobalRoleBindingHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.GlobalRoleBindingHandlerFunc
	}
	lockGlobalRoleBindingControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockGlobalRoleBindingControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *GlobalRoleBindingControllerMock) AddHandler(ctx context.Context, name string, handler v31.GlobalRoleBindingHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("GlobalRoleBindingControllerMock.AddHandlerFunc: method is nil but GlobalRoleBindingController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.GlobalRoleBindingHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockGlobalRoleBindingControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockGlobalRoleBindingControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedGlobalRoleBindingController.AddHandlerCalls())
func (mock *GlobalRoleBindingControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.GlobalRoleBindingHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.GlobalRoleBindingHandlerFunc
	}
	lockGlobalRoleBindingControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockGlobalRoleBindingControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *GlobalRoleBindingControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("GlobalRoleBindingControllerMock.EnqueueFunc: method is nil but GlobalRoleBindingController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockGlobalRoleBindingControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockGlobalRoleBindingControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedGlobalRoleBindingController.EnqueueCalls())
func (mock *GlobalRoleBindingControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockGlobalRoleBindingControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockGlobalRoleBindingControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *GlobalRoleBindingControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("GlobalRoleBindingControllerMock.EnqueueAfterFunc: method is nil but GlobalRoleBindingController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockGlobalRoleBindingControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockGlobalRoleBindingControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedGlobalRoleBindingController.EnqueueAfterCalls())
func (mock *GlobalRoleBindingControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockGlobalRoleBindingControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockGlobalRoleBindingControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *GlobalRoleBindingControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("GlobalRoleBindingControllerMock.GenericFunc: method is nil but GlobalRoleBindingController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockGlobalRoleBindingControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockGlobalRoleBindingControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedGlobalRoleBindingController.GenericCalls())
func (mock *GlobalRoleBindingControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockGlobalRoleBindingControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockGlobalRoleBindingControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *GlobalRoleBindingControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("GlobalRoleBindingControllerMock.InformerFunc: method is nil but GlobalRoleBindingController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockGlobalRoleBindingControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockGlobalRoleBindingControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedGlobalRoleBindingController.InformerCalls())
func (mock *GlobalRoleBindingControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockGlobalRoleBindingControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockGlobalRoleBindingControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *GlobalRoleBindingControllerMock) Lister() v31.GlobalRoleBindingLister {
	if mock.ListerFunc == nil {
		panic("GlobalRoleBindingControllerMock.ListerFunc: method is nil but GlobalRoleBindingController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockGlobalRoleBindingControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockGlobalRoleBindingControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedGlobalRoleBindingController.ListerCalls())
func (mock *GlobalRoleBindingControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockGlobalRoleBindingControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockGlobalRoleBindingControllerMockLister.RUnlock()
	return calls
}

var (
	lockGlobalRoleBindingInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockGlobalRoleBindingInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockGlobalRoleBindingInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockGlobalRoleBindingInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockGlobalRoleBindingInterfaceMockAddFeatureHandler                sync.RWMutex
	lockGlobalRoleBindingInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockGlobalRoleBindingInterfaceMockAddHandler                       sync.RWMutex
	lockGlobalRoleBindingInterfaceMockAddLifecycle                     sync.RWMutex
	lockGlobalRoleBindingInterfaceMockController                       sync.RWMutex
	lockGlobalRoleBindingInterfaceMockCreate                           sync.RWMutex
	lockGlobalRoleBindingInterfaceMockDelete                           sync.RWMutex
	lockGlobalRoleBindingInterfaceMockDeleteCollection                 sync.RWMutex
	lockGlobalRoleBindingInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockGlobalRoleBindingInterfaceMockGet                              sync.RWMutex
	lockGlobalRoleBindingInterfaceMockGetNamespaced                    sync.RWMutex
	lockGlobalRoleBindingInterfaceMockList                             sync.RWMutex
	lockGlobalRoleBindingInterfaceMockListNamespaced                   sync.RWMutex
	lockGlobalRoleBindingInterfaceMockObjectClient                     sync.RWMutex
	lockGlobalRoleBindingInterfaceMockUpdate                           sync.RWMutex
	lockGlobalRoleBindingInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that GlobalRoleBindingInterfaceMock does implement v31.GlobalRoleBindingInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.GlobalRoleBindingInterface = &GlobalRoleBindingInterfaceMock{}

// GlobalRoleBindingInterfaceMock is a mock implementation of v31.GlobalRoleBindingInterface.
//
//     func TestSomethingThatUsesGlobalRoleBindingInterface(t *testing.T) {
//
//         // make and configure a mocked v31.GlobalRoleBindingInterface
//         mockedGlobalRoleBindingInterface := &GlobalRoleBindingInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.GlobalRoleBindingHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.GlobalRoleBindingLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.GlobalRoleBindingHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.GlobalRoleBindingLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GlobalRoleBindingHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.GlobalRoleBindingLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.GlobalRoleBindingHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.GlobalRoleBindingLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.GlobalRoleBindingController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.GlobalRoleBinding) (*v3.GlobalRoleBinding, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.GlobalRoleBinding, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.GlobalRoleBinding, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.GlobalRoleBindingList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.GlobalRoleBindingList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.GlobalRoleBinding) (*v3.GlobalRoleBinding, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedGlobalRoleBindingInterface in code that requires v31.GlobalRoleBindingInterface
//         // and then make assertions.
//
//     }
type GlobalRoleBindingInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.GlobalRoleBindingHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.GlobalRoleBindingLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.GlobalRoleBindingHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.GlobalRoleBindingLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GlobalRoleBindingHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.GlobalRoleBindingLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.GlobalRoleBindingHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.GlobalRoleBindingLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.GlobalRoleBindingController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.GlobalRoleBinding) (*v3.GlobalRoleBinding, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.GlobalRoleBinding, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.GlobalRoleBinding, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.GlobalRoleBindingList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.GlobalRoleBindingList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.GlobalRoleBinding) (*v3.GlobalRoleBinding, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.GlobalRoleBindingHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.GlobalRoleBindingLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.GlobalRoleBindingHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.GlobalRoleBindingLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.GlobalRoleBindingHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.GlobalRoleBindingLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.GlobalRoleBindingHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.GlobalRoleBindingLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.GlobalRoleBinding
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.GlobalRoleBinding
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *GlobalRoleBindingInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.GlobalRoleBindingHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("GlobalRoleBindingInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but GlobalRoleBindingInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.GlobalRoleBindingHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockGlobalRoleBindingInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockGlobalRoleBindingInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedGlobalRoleBindingInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *GlobalRoleBindingInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.GlobalRoleBindingHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.GlobalRoleBindingHandlerFunc
	}
	lockGlobalRoleBindingInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockGlobalRoleBindingInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *GlobalRoleBindingInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.GlobalRoleBindingLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("GlobalRoleBindingInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but GlobalRoleBindingInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.GlobalRoleBindingLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockGlobalRoleBindingInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockGlobalRoleBindingInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedGlobalRoleBindingInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *GlobalRoleBindingInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.GlobalRoleBindingLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.GlobalRoleBindingLifecycle
	}
	lockGlobalRoleBindingInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockGlobalRoleBindingInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *GlobalRoleBindingInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.GlobalRoleBindingHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("GlobalRoleBindingInterfaceMock.AddClusterScopedHandlerFunc: method is nil but GlobalRoleBindingInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.GlobalRoleBindingHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockGlobalRoleBindingInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockGlobalRoleBindingInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedGlobalRoleBindingInterface.AddClusterScopedHandlerCalls())
func (mock *GlobalRoleBindingInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.GlobalRoleBindingHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.GlobalRoleBindingHandlerFunc
	}
	lockGlobalRoleBindingInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockGlobalRoleBindingInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *GlobalRoleBindingInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.GlobalRoleBindingLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("GlobalRoleBindingInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but GlobalRoleBindingInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.GlobalRoleBindingLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockGlobalRoleBindingInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockGlobalRoleBindingInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedGlobalRoleBindingInterface.AddClusterScopedLifecycleCalls())
func (mock *GlobalRoleBindingInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.GlobalRoleBindingLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.GlobalRoleBindingLifecycle
	}
	lockGlobalRoleBindingInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockGlobalRoleBindingInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *GlobalRoleBindingInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GlobalRoleBindingHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("GlobalRoleBindingInterfaceMock.AddFeatureHandlerFunc: method is nil but GlobalRoleBindingInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.GlobalRoleBindingHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockGlobalRoleBindingInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockGlobalRoleBindingInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedGlobalRoleBindingInterface.AddFeatureHandlerCalls())
func (mock *GlobalRoleBindingInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.GlobalRoleBindingHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.GlobalRoleBindingHandlerFunc
	}
	lockGlobalRoleBindingInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockGlobalRoleBindingInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *GlobalRoleBindingInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.GlobalRoleBindingLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("GlobalRoleBindingInterfaceMock.AddFeatureLifecycleFunc: method is nil but GlobalRoleBindingInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.GlobalRoleBindingLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockGlobalRoleBindingInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockGlobalRoleBindingInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedGlobalRoleBindingInterface.AddFeatureLifecycleCalls())
func (mock *GlobalRoleBindingInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.GlobalRoleBindingLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.GlobalRoleBindingLifecycle
	}
	lockGlobalRoleBindingInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockGlobalRoleBindingInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *GlobalRoleBindingInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.GlobalRoleBindingHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("GlobalRoleBindingInterfaceMock.AddHandlerFunc: method is nil but GlobalRoleBindingInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.GlobalRoleBindingHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockGlobalRoleBindingInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockGlobalRoleBindingInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedGlobalRoleBindingInterface.AddHandlerCalls())
func (mock *GlobalRoleBindingInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.GlobalRoleBindingHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.GlobalRoleBindingHandlerFunc
	}
	lockGlobalRoleBindingInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockGlobalRoleBindingInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *GlobalRoleBindingInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.GlobalRoleBindingLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("GlobalRoleBindingInterfaceMock.AddLifecycleFunc: method is nil but GlobalRoleBindingInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.GlobalRoleBindingLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockGlobalRoleBindingInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockGlobalRoleBindingInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedGlobalRoleBindingInterface.AddLifecycleCalls())
func (mock *GlobalRoleBindingInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.GlobalRoleBindingLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.GlobalRoleBindingLifecycle
	}
	lockGlobalRoleBindingInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockGlobalRoleBindingInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *GlobalRoleBindingInterfaceMock) Controller() v31.GlobalRoleBindingController {
	if mock.ControllerFunc == nil {
		panic("GlobalRoleBindingInterfaceMock.ControllerFunc: method is nil but GlobalRoleBindingInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockGlobalRoleBindingInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockGlobalRoleBindingInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedGlobalRoleBindingInterface.ControllerCalls())
func (mock *GlobalRoleBindingInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockGlobalRoleBindingInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockGlobalRoleBindingInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *GlobalRoleBindingInterfaceMock) Create(in1 *v3.GlobalRoleBinding) (*v3.GlobalRoleBinding, error) {
	if mock.CreateFunc == nil {
		panic("GlobalRoleBindingInterfaceMock.CreateFunc: method is nil but GlobalRoleBindingInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.GlobalRoleBinding
	}{
		In1: in1,
	}
	lockGlobalRoleBindingInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockGlobalRoleBindingInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedGlobalRoleBindingInterface.CreateCalls())
func (mock *GlobalRoleBindingInterfaceMock) CreateCalls() []struct {
	In1 *v3.GlobalRoleBinding
} {
	var calls []struct {
		In1 *v3.GlobalRoleBinding
	}
	lockGlobalRoleBindingInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockGlobalRoleBindingInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *GlobalRoleBindingInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("GlobalRoleBindingInterfaceMock.DeleteFunc: method is nil but GlobalRoleBindingInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockGlobalRoleBindingInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockGlobalRoleBindingInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedGlobalRoleBindingInterface.DeleteCalls())
func (mock *GlobalRoleBindingInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockGlobalRoleBindingInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockGlobalRoleBindingInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *GlobalRoleBindingInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("GlobalRoleBindingInterfaceMock.DeleteCollectionFunc: method is nil but GlobalRoleBindingInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockGlobalRoleBindingInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockGlobalRoleBindingInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedGlobalRoleBindingInterface.DeleteCollectionCalls())
func (mock *GlobalRoleBindingInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockGlobalRoleBindingInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockGlobalRoleBindingInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *GlobalRoleBindingInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("GlobalRoleBindingInterfaceMock.DeleteNamespacedFunc: method is nil but GlobalRoleBindingInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockGlobalRoleBindingInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockGlobalRoleBindingInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedGlobalRoleBindingInterface.DeleteNamespacedCalls())
func (mock *GlobalRoleBindingInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockGlobalRoleBindingInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockGlobalRoleBindingInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *GlobalRoleBindingInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.GlobalRoleBinding, error) {
	if mock.GetFunc == nil {
		panic("GlobalRoleBindingInterfaceMock.GetFunc: method is nil but GlobalRoleBindingInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockGlobalRoleBindingInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockGlobalRoleBindingInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedGlobalRoleBindingInterface.GetCalls())
func (mock *GlobalRoleBindingInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockGlobalRoleBindingInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockGlobalRoleBindingInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *GlobalRoleBindingInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.GlobalRoleBinding, error) {
	if mock.GetNamespacedFunc == nil {
		panic("GlobalRoleBindingInterfaceMock.GetNamespacedFunc: method is nil but GlobalRoleBindingInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockGlobalRoleBindingInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockGlobalRoleBindingInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedGlobalRoleBindingInterface.GetNamespacedCalls())
func (mock *GlobalRoleBindingInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockGlobalRoleBindingInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockGlobalRoleBindingInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *GlobalRoleBindingInterfaceMock) List(opts metav1.ListOptions) (*v3.GlobalRoleBindingList, error) {
	if mock.ListFunc == nil {
		panic("GlobalRoleBindingInterfaceMock.ListFunc: method is nil but GlobalRoleBindingInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockGlobalRoleBindingInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockGlobalRoleBindingInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedGlobalRoleBindingInterface.ListCalls())
func (mock *GlobalRoleBindingInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockGlobalRoleBindingInterfaceMockList.RLock()
	calls = mock.calls.List
	lockGlobalRoleBindingInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *GlobalRoleBindingInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.GlobalRoleBindingList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("GlobalRoleBindingInterfaceMock.ListNamespacedFunc: method is nil but GlobalRoleBindingInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockGlobalRoleBindingInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockGlobalRoleBindingInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedGlobalRoleBindingInterface.ListNamespacedCalls())
func (mock *GlobalRoleBindingInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockGlobalRoleBindingInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockGlobalRoleBindingInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *GlobalRoleBindingInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("GlobalRoleBindingInterfaceMock.ObjectClientFunc: method is nil but GlobalRoleBindingInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockGlobalRoleBindingInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockGlobalRoleBindingInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedGlobalRoleBindingInterface.ObjectClientCalls())
func (mock *GlobalRoleBindingInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockGlobalRoleBindingInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockGlobalRoleBindingInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *GlobalRoleBindingInterfaceMock) Update(in1 *v3.GlobalRoleBinding) (*v3.GlobalRoleBinding, error) {
	if mock.UpdateFunc == nil {
		panic("GlobalRoleBindingInterfaceMock.UpdateFunc: method is nil but GlobalRoleBindingInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.GlobalRoleBinding
	}{
		In1: in1,
	}
	lockGlobalRoleBindingInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockGlobalRoleBindingInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedGlobalRoleBindingInterface.UpdateCalls())
func (mock *GlobalRoleBindingInterfaceMock) UpdateCalls() []struct {
	In1 *v3.GlobalRoleBinding
} {
	var calls []struct {
		In1 *v3.GlobalRoleBinding
	}
	lockGlobalRoleBindingInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockGlobalRoleBindingInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *GlobalRoleBindingInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("GlobalRoleBindingInterfaceMock.WatchFunc: method is nil but GlobalRoleBindingInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockGlobalRoleBindingInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockGlobalRoleBindingInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedGlobalRoleBindingInterface.WatchCalls())
func (mock *GlobalRoleBindingInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockGlobalRoleBindingInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockGlobalRoleBindingInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockGlobalRoleBindingsGetterMockGlobalRoleBindings sync.RWMutex
)

// Ensure, that GlobalRoleBindingsGetterMock does implement v31.GlobalRoleBindingsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.GlobalRoleBindingsGetter = &GlobalRoleBindingsGetterMock{}

// GlobalRoleBindingsGetterMock is a mock implementation of v31.GlobalRoleBindingsGetter.
//
//     func TestSomethingThatUsesGlobalRoleBindingsGetter(t *testing.T) {
//
//         // make and configure a mocked v31.GlobalRoleBindingsGetter
//         mockedGlobalRoleBindingsGetter := &GlobalRoleBindingsGetterMock{
//             GlobalRoleBindingsFunc: func(namespace string) v31.GlobalRoleBindingInterface {
// 	               panic("mock out the GlobalRoleBindings method")
//             },
//         }
//
//         // use mockedGlobalRoleBindingsGetter in code that requires v31.GlobalRoleBindingsGetter
//         // and then make assertions.
//
//     }
type GlobalRoleBindingsGetterMock struct {
	// GlobalRoleBindingsFunc mocks the GlobalRoleBindings method.
	GlobalRoleBindingsFunc func(namespace string) v31.GlobalRoleBindingInterface

	// calls tracks calls to the methods.
	calls struct {
		// GlobalRoleBindings holds details about calls to the GlobalRoleBindings method.
		GlobalRoleBindings []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// GlobalRoleBindings calls GlobalRoleBindingsFunc.
func (mock *GlobalRoleBindingsGetterMock) GlobalRoleBindings(namespace string) v31.GlobalRoleBindingInterface {
	if mock.GlobalRoleBindingsFunc == nil {
		panic("GlobalRoleBindingsGetterMock.GlobalRoleBindingsFunc: method is nil but GlobalRoleBindingsGetter.GlobalRoleBindings was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockGlobalRoleBindingsGetterMockGlobalRoleBindings.Lock()
	mock.calls.GlobalRoleBindings = append(mock.calls.GlobalRoleBindings, callInfo)
	lockGlobalRoleBindingsGetterMockGlobalRoleBindings.Unlock()
	return mock.GlobalRoleBindingsFunc(namespace)
}

// GlobalRoleBindingsCalls gets all the calls that were made to GlobalRoleBindings.
// Check the length with:
//     len(mockedGlobalRoleBindingsGetter.GlobalRoleBindingsCalls())
func (mock *GlobalRoleBindingsGetterMock) GlobalRoleBindingsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockGlobalRoleBindingsGetterMockGlobalRoleBindings.RLock()
	calls = mock.calls.GlobalRoleBindings
	lockGlobalRoleBindingsGetterMockGlobalRoleBindings.RUnlock()
	return calls
}
