// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockGroupMemberListerMockGet  sync.RWMutex
	lockGroupMemberListerMockList sync.RWMutex
)

// Ensure, that GroupMemberListerMock does implement v31.GroupMemberLister.
// If this is not the case, regenerate this file with moq.
var _ v31.GroupMemberLister = &GroupMemberListerMock{}

// GroupMemberListerMock is a mock implementation of v31.GroupMemberLister.
//
//     func TestSomethingThatUsesGroupMemberLister(t *testing.T) {
//
//         // make and configure a mocked v31.GroupMemberLister
//         mockedGroupMemberLister := &GroupMemberListerMock{
//             GetFunc: func(namespace string, name string) (*v3.GroupMember, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.GroupMember, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedGroupMemberLister in code that requires v31.GroupMemberLister
//         // and then make assertions.
//
//     }
type GroupMemberListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.GroupMember, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.GroupMember, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *GroupMemberListerMock) Get(namespace string, name string) (*v3.GroupMember, error) {
	if mock.GetFunc == nil {
		panic("GroupMemberListerMock.GetFunc: method is nil but GroupMemberLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockGroupMemberListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockGroupMemberListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedGroupMemberLister.GetCalls())
func (mock *GroupMemberListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockGroupMemberListerMockGet.RLock()
	calls = mock.calls.Get
	lockGroupMemberListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *GroupMemberListerMock) List(namespace string, selector labels.Selector) ([]*v3.GroupMember, error) {
	if mock.ListFunc == nil {
		panic("GroupMemberListerMock.ListFunc: method is nil but GroupMemberLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockGroupMemberListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockGroupMemberListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedGroupMemberLister.ListCalls())
func (mock *GroupMemberListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockGroupMemberListerMockList.RLock()
	calls = mock.calls.List
	lockGroupMemberListerMockList.RUnlock()
	return calls
}

var (
	lockGroupMemberControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockGroupMemberControllerMockAddClusterScopedHandler        sync.RWMutex
	lockGroupMemberControllerMockAddFeatureHandler              sync.RWMutex
	lockGroupMemberControllerMockAddHandler                     sync.RWMutex
	lockGroupMemberControllerMockEnqueue                        sync.RWMutex
	lockGroupMemberControllerMockEnqueueAfter                   sync.RWMutex
	lockGroupMemberControllerMockGeneric                        sync.RWMutex
	lockGroupMemberControllerMockInformer                       sync.RWMutex
	lockGroupMemberControllerMockLister                         sync.RWMutex
)

// Ensure, that GroupMemberControllerMock does implement v31.GroupMemberController.
// If this is not the case, regenerate this file with moq.
var _ v31.GroupMemberController = &GroupMemberControllerMock{}

// GroupMemberControllerMock is a mock implementation of v31.GroupMemberController.
//
//     func TestSomethingThatUsesGroupMemberController(t *testing.T) {
//
//         // make and configure a mocked v31.GroupMemberController
//         mockedGroupMemberController := &GroupMemberControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.GroupMemberHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.GroupMemberHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GroupMemberHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.GroupMemberHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.GroupMemberLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedGroupMemberController in code that requires v31.GroupMemberController
//         // and then make assertions.
//
//     }
type GroupMemberControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.GroupMemberHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.GroupMemberHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GroupMemberHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.GroupMemberHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.GroupMemberLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.GroupMemberHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.GroupMemberHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.GroupMemberHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.GroupMemberHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *GroupMemberControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.GroupMemberHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("GroupMemberControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but GroupMemberController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.GroupMemberHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockGroupMemberControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockGroupMemberControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedGroupMemberController.AddClusterScopedFeatureHandlerCalls())
func (mock *GroupMemberControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.GroupMemberHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.GroupMemberHandlerFunc
	}
	lockGroupMemberControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockGroupMemberControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *GroupMemberControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.GroupMemberHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("GroupMemberControllerMock.AddClusterScopedHandlerFunc: method is nil but GroupMemberController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.GroupMemberHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockGroupMemberControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockGroupMemberControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedGroupMemberController.AddClusterScopedHandlerCalls())
func (mock *GroupMemberControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.GroupMemberHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.GroupMemberHandlerFunc
	}
	lockGroupMemberControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockGroupMemberControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *GroupMemberControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GroupMemberHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("GroupMemberControllerMock.AddFeatureHandlerFunc: method is nil but GroupMemberController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.GroupMemberHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockGroupMemberControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockGroupMemberControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedGroupMemberController.AddFeatureHandlerCalls())
func (mock *GroupMemberControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.GroupMemberHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.GroupMemberHandlerFunc
	}
	lockGroupMemberControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockGroupMemberControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *GroupMemberControllerMock) AddHandler(ctx context.Context, name string, handler v31.GroupMemberHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("GroupMemberControllerMock.AddHandlerFunc: method is nil but GroupMemberController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.GroupMemberHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockGroupMemberControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockGroupMemberControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedGroupMemberController.AddHandlerCalls())
func (mock *GroupMemberControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.GroupMemberHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.GroupMemberHandlerFunc
	}
	lockGroupMemberControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockGroupMemberControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *GroupMemberControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("GroupMemberControllerMock.EnqueueFunc: method is nil but GroupMemberController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockGroupMemberControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockGroupMemberControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedGroupMemberController.EnqueueCalls())
func (mock *GroupMemberControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockGroupMemberControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockGroupMemberControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *GroupMemberControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("GroupMemberControllerMock.EnqueueAfterFunc: method is nil but GroupMemberController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockGroupMemberControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockGroupMemberControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedGroupMemberController.EnqueueAfterCalls())
func (mock *GroupMemberControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockGroupMemberControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockGroupMemberControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *GroupMemberControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("GroupMemberControllerMock.GenericFunc: method is nil but GroupMemberController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockGroupMemberControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockGroupMemberControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedGroupMemberController.GenericCalls())
func (mock *GroupMemberControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockGroupMemberControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockGroupMemberControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *GroupMemberControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("GroupMemberControllerMock.InformerFunc: method is nil but GroupMemberController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockGroupMemberControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockGroupMemberControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedGroupMemberController.InformerCalls())
func (mock *GroupMemberControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockGroupMemberControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockGroupMemberControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *GroupMemberControllerMock) Lister() v31.GroupMemberLister {
	if mock.ListerFunc == nil {
		panic("GroupMemberControllerMock.ListerFunc: method is nil but GroupMemberController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockGroupMemberControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockGroupMemberControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedGroupMemberController.ListerCalls())
func (mock *GroupMemberControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockGroupMemberControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockGroupMemberControllerMockLister.RUnlock()
	return calls
}

var (
	lockGroupMemberInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockGroupMemberInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockGroupMemberInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockGroupMemberInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockGroupMemberInterfaceMockAddFeatureHandler                sync.RWMutex
	lockGroupMemberInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockGroupMemberInterfaceMockAddHandler                       sync.RWMutex
	lockGroupMemberInterfaceMockAddLifecycle                     sync.RWMutex
	lockGroupMemberInterfaceMockController                       sync.RWMutex
	lockGroupMemberInterfaceMockCreate                           sync.RWMutex
	lockGroupMemberInterfaceMockDelete                           sync.RWMutex
	lockGroupMemberInterfaceMockDeleteCollection                 sync.RWMutex
	lockGroupMemberInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockGroupMemberInterfaceMockGet                              sync.RWMutex
	lockGroupMemberInterfaceMockGetNamespaced                    sync.RWMutex
	lockGroupMemberInterfaceMockList                             sync.RWMutex
	lockGroupMemberInterfaceMockListNamespaced                   sync.RWMutex
	lockGroupMemberInterfaceMockObjectClient                     sync.RWMutex
	lockGroupMemberInterfaceMockUpdate                           sync.RWMutex
	lockGroupMemberInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that GroupMemberInterfaceMock does implement v31.GroupMemberInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.GroupMemberInterface = &GroupMemberInterfaceMock{}

// GroupMemberInterfaceMock is a mock implementation of v31.GroupMemberInterface.
//
//     func TestSomethingThatUsesGroupMemberInterface(t *testing.T) {
//
//         // make and configure a mocked v31.GroupMemberInterface
//         mockedGroupMemberInterface := &GroupMemberInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.GroupMemberHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.GroupMemberLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.GroupMemberHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.GroupMemberLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GroupMemberHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.GroupMemberLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.GroupMemberHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.GroupMemberLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.GroupMemberController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.GroupMember) (*v3.GroupMember, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.GroupMember, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.GroupMember, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.GroupMemberList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.GroupMemberList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.GroupMember) (*v3.GroupMember, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedGroupMemberInterface in code that requires v31.GroupMemberInterface
//         // and then make assertions.
//
//     }
type GroupMemberInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.GroupMemberHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.GroupMemberLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.GroupMemberHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.GroupMemberLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GroupMemberHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.GroupMemberLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.GroupMemberHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.GroupMemberLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.GroupMemberController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.GroupMember) (*v3.GroupMember, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.GroupMember, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.GroupMember, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.GroupMemberList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.GroupMemberList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.GroupMember) (*v3.GroupMember, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.GroupMemberHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.GroupMemberLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.GroupMemberHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.GroupMemberLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.GroupMemberHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.GroupMemberLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.GroupMemberHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.GroupMemberLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.GroupMember
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.GroupMember
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *GroupMemberInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.GroupMemberHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("GroupMemberInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but GroupMemberInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.GroupMemberHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockGroupMemberInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockGroupMemberInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedGroupMemberInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *GroupMemberInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.GroupMemberHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.GroupMemberHandlerFunc
	}
	lockGroupMemberInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockGroupMemberInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *GroupMemberInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.GroupMemberLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("GroupMemberInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but GroupMemberInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.GroupMemberLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockGroupMemberInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockGroupMemberInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedGroupMemberInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *GroupMemberInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.GroupMemberLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.GroupMemberLifecycle
	}
	lockGroupMemberInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockGroupMemberInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *GroupMemberInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.GroupMemberHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("GroupMemberInterfaceMock.AddClusterScopedHandlerFunc: method is nil but GroupMemberInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.GroupMemberHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockGroupMemberInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockGroupMemberInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedGroupMemberInterface.AddClusterScopedHandlerCalls())
func (mock *GroupMemberInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.GroupMemberHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.GroupMemberHandlerFunc
	}
	lockGroupMemberInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockGroupMemberInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *GroupMemberInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.GroupMemberLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("GroupMemberInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but GroupMemberInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.GroupMemberLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockGroupMemberInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockGroupMemberInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedGroupMemberInterface.AddClusterScopedLifecycleCalls())
func (mock *GroupMemberInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.GroupMemberLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.GroupMemberLifecycle
	}
	lockGroupMemberInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockGroupMemberInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *GroupMemberInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GroupMemberHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("GroupMemberInterfaceMock.AddFeatureHandlerFunc: method is nil but GroupMemberInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.GroupMemberHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockGroupMemberInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockGroupMemberInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedGroupMemberInterface.AddFeatureHandlerCalls())
func (mock *GroupMemberInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.GroupMemberHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.GroupMemberHandlerFunc
	}
	lockGroupMemberInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockGroupMemberInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *GroupMemberInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.GroupMemberLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("GroupMemberInterfaceMock.AddFeatureLifecycleFunc: method is nil but GroupMemberInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.GroupMemberLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockGroupMemberInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockGroupMemberInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedGroupMemberInterface.AddFeatureLifecycleCalls())
func (mock *GroupMemberInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.GroupMemberLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.GroupMemberLifecycle
	}
	lockGroupMemberInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockGroupMemberInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *GroupMemberInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.GroupMemberHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("GroupMemberInterfaceMock.AddHandlerFunc: method is nil but GroupMemberInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.GroupMemberHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockGroupMemberInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockGroupMemberInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedGroupMemberInterface.AddHandlerCalls())
func (mock *GroupMemberInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.GroupMemberHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.GroupMemberHandlerFunc
	}
	lockGroupMemberInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockGroupMemberInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *GroupMemberInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.GroupMemberLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("GroupMemberInterfaceMock.AddLifecycleFunc: method is nil but GroupMemberInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.GroupMemberLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockGroupMemberInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockGroupMemberInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedGroupMemberInterface.AddLifecycleCalls())
func (mock *GroupMemberInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.GroupMemberLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.GroupMemberLifecycle
	}
	lockGroupMemberInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockGroupMemberInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *GroupMemberInterfaceMock) Controller() v31.GroupMemberController {
	if mock.ControllerFunc == nil {
		panic("GroupMemberInterfaceMock.ControllerFunc: method is nil but GroupMemberInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockGroupMemberInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockGroupMemberInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedGroupMemberInterface.ControllerCalls())
func (mock *GroupMemberInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockGroupMemberInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockGroupMemberInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *GroupMemberInterfaceMock) Create(in1 *v3.GroupMember) (*v3.GroupMember, error) {
	if mock.CreateFunc == nil {
		panic("GroupMemberInterfaceMock.CreateFunc: method is nil but GroupMemberInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.GroupMember
	}{
		In1: in1,
	}
	lockGroupMemberInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockGroupMemberInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedGroupMemberInterface.CreateCalls())
func (mock *GroupMemberInterfaceMock) CreateCalls() []struct {
	In1 *v3.GroupMember
} {
	var calls []struct {
		In1 *v3.GroupMember
	}
	lockGroupMemberInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockGroupMemberInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *GroupMemberInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("GroupMemberInterfaceMock.DeleteFunc: method is nil but GroupMemberInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockGroupMemberInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockGroupMemberInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedGroupMemberInterface.DeleteCalls())
func (mock *GroupMemberInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockGroupMemberInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockGroupMemberInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *GroupMemberInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("GroupMemberInterfaceMock.DeleteCollectionFunc: method is nil but GroupMemberInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockGroupMemberInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockGroupMemberInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedGroupMemberInterface.DeleteCollectionCalls())
func (mock *GroupMemberInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockGroupMemberInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockGroupMemberInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *GroupMemberInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("GroupMemberInterfaceMock.DeleteNamespacedFunc: method is nil but GroupMemberInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockGroupMemberInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockGroupMemberInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedGroupMemberInterface.DeleteNamespacedCalls())
func (mock *GroupMemberInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockGroupMemberInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockGroupMemberInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *GroupMemberInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.GroupMember, error) {
	if mock.GetFunc == nil {
		panic("GroupMemberInterfaceMock.GetFunc: method is nil but GroupMemberInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockGroupMemberInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockGroupMemberInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedGroupMemberInterface.GetCalls())
func (mock *GroupMemberInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockGroupMemberInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockGroupMemberInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *GroupMemberInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.GroupMember, error) {
	if mock.GetNamespacedFunc == nil {
		panic("GroupMemberInterfaceMock.GetNamespacedFunc: method is nil but GroupMemberInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockGroupMemberInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockGroupMemberInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedGroupMemberInterface.GetNamespacedCalls())
func (mock *GroupMemberInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockGroupMemberInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockGroupMemberInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *GroupMemberInterfaceMock) List(opts metav1.ListOptions) (*v3.GroupMemberList, error) {
	if mock.ListFunc == nil {
		panic("GroupMemberInterfaceMock.ListFunc: method is nil but GroupMemberInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockGroupMemberInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockGroupMemberInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedGroupMemberInterface.ListCalls())
func (mock *GroupMemberInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockGroupMemberInterfaceMockList.RLock()
	calls = mock.calls.List
	lockGroupMemberInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *GroupMemberInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.GroupMemberList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("GroupMemberInterfaceMock.ListNamespacedFunc: method is nil but GroupMemberInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockGroupMemberInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockGroupMemberInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedGroupMemberInterface.ListNamespacedCalls())
func (mock *GroupMemberInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockGroupMemberInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockGroupMemberInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *GroupMemberInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("GroupMemberInterfaceMock.ObjectClientFunc: method is nil but GroupMemberInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockGroupMemberInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockGroupMemberInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedGroupMemberInterface.ObjectClientCalls())
func (mock *GroupMemberInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockGroupMemberInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockGroupMemberInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *GroupMemberInterfaceMock) Update(in1 *v3.GroupMember) (*v3.GroupMember, error) {
	if mock.UpdateFunc == nil {
		panic("GroupMemberInterfaceMock.UpdateFunc: method is nil but GroupMemberInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.GroupMember
	}{
		In1: in1,
	}
	lockGroupMemberInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockGroupMemberInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedGroupMemberInterface.UpdateCalls())
func (mock *GroupMemberInterfaceMock) UpdateCalls() []struct {
	In1 *v3.GroupMember
} {
	var calls []struct {
		In1 *v3.GroupMember
	}
	lockGroupMemberInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockGroupMemberInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *GroupMemberInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("GroupMemberInterfaceMock.WatchFunc: method is nil but GroupMemberInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockGroupMemberInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockGroupMemberInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedGroupMemberInterface.WatchCalls())
func (mock *GroupMemberInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockGroupMemberInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockGroupMemberInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockGroupMembersGetterMockGroupMembers sync.RWMutex
)

// Ensure, that GroupMembersGetterMock does implement v31.GroupMembersGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.GroupMembersGetter = &GroupMembersGetterMock{}

// GroupMembersGetterMock is a mock implementation of v31.GroupMembersGetter.
//
//     func TestSomethingThatUsesGroupMembersGetter(t *testing.T) {
//
//         // make and configure a mocked v31.GroupMembersGetter
//         mockedGroupMembersGetter := &GroupMembersGetterMock{
//             GroupMembersFunc: func(namespace string) v31.GroupMemberInterface {
// 	               panic("mock out the GroupMembers method")
//             },
//         }
//
//         // use mockedGroupMembersGetter in code that requires v31.GroupMembersGetter
//         // and then make assertions.
//
//     }
type GroupMembersGetterMock struct {
	// GroupMembersFunc mocks the GroupMembers method.
	GroupMembersFunc func(namespace string) v31.GroupMemberInterface

	// calls tracks calls to the methods.
	calls struct {
		// GroupMembers holds details about calls to the GroupMembers method.
		GroupMembers []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// GroupMembers calls GroupMembersFunc.
func (mock *GroupMembersGetterMock) GroupMembers(namespace string) v31.GroupMemberInterface {
	if mock.GroupMembersFunc == nil {
		panic("GroupMembersGetterMock.GroupMembersFunc: method is nil but GroupMembersGetter.GroupMembers was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockGroupMembersGetterMockGroupMembers.Lock()
	mock.calls.GroupMembers = append(mock.calls.GroupMembers, callInfo)
	lockGroupMembersGetterMockGroupMembers.Unlock()
	return mock.GroupMembersFunc(namespace)
}

// GroupMembersCalls gets all the calls that were made to GroupMembers.
// Check the length with:
//     len(mockedGroupMembersGetter.GroupMembersCalls())
func (mock *GroupMembersGetterMock) GroupMembersCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockGroupMembersGetterMockGroupMembers.RLock()
	calls = mock.calls.GroupMembers
	lockGroupMembersGetterMockGroupMembers.RUnlock()
	return calls
}
