// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockGroupListerMockGet  sync.RWMutex
	lockGroupListerMockList sync.RWMutex
)

// Ensure, that GroupListerMock does implement v31.GroupLister.
// If this is not the case, regenerate this file with moq.
var _ v31.GroupLister = &GroupListerMock{}

// GroupListerMock is a mock implementation of v31.GroupLister.
//
//     func TestSomethingThatUsesGroupLister(t *testing.T) {
//
//         // make and configure a mocked v31.GroupLister
//         mockedGroupLister := &GroupListerMock{
//             GetFunc: func(namespace string, name string) (*v3.Group, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.Group, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedGroupLister in code that requires v31.GroupLister
//         // and then make assertions.
//
//     }
type GroupListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.Group, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.Group, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *GroupListerMock) Get(namespace string, name string) (*v3.Group, error) {
	if mock.GetFunc == nil {
		panic("GroupListerMock.GetFunc: method is nil but GroupLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockGroupListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockGroupListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedGroupLister.GetCalls())
func (mock *GroupListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockGroupListerMockGet.RLock()
	calls = mock.calls.Get
	lockGroupListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *GroupListerMock) List(namespace string, selector labels.Selector) ([]*v3.Group, error) {
	if mock.ListFunc == nil {
		panic("GroupListerMock.ListFunc: method is nil but GroupLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockGroupListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockGroupListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedGroupLister.ListCalls())
func (mock *GroupListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockGroupListerMockList.RLock()
	calls = mock.calls.List
	lockGroupListerMockList.RUnlock()
	return calls
}

var (
	lockGroupControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockGroupControllerMockAddClusterScopedHandler        sync.RWMutex
	lockGroupControllerMockAddFeatureHandler              sync.RWMutex
	lockGroupControllerMockAddHandler                     sync.RWMutex
	lockGroupControllerMockEnqueue                        sync.RWMutex
	lockGroupControllerMockEnqueueAfter                   sync.RWMutex
	lockGroupControllerMockGeneric                        sync.RWMutex
	lockGroupControllerMockInformer                       sync.RWMutex
	lockGroupControllerMockLister                         sync.RWMutex
)

// Ensure, that GroupControllerMock does implement v31.GroupController.
// If this is not the case, regenerate this file with moq.
var _ v31.GroupController = &GroupControllerMock{}

// GroupControllerMock is a mock implementation of v31.GroupController.
//
//     func TestSomethingThatUsesGroupController(t *testing.T) {
//
//         // make and configure a mocked v31.GroupController
//         mockedGroupController := &GroupControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.GroupHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.GroupHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GroupHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.GroupHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.GroupLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedGroupController in code that requires v31.GroupController
//         // and then make assertions.
//
//     }
type GroupControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.GroupHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.GroupHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GroupHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.GroupHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.GroupLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.GroupHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.GroupHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.GroupHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.GroupHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *GroupControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.GroupHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("GroupControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but GroupController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.GroupHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockGroupControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockGroupControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedGroupController.AddClusterScopedFeatureHandlerCalls())
func (mock *GroupControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.GroupHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.GroupHandlerFunc
	}
	lockGroupControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockGroupControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *GroupControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.GroupHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("GroupControllerMock.AddClusterScopedHandlerFunc: method is nil but GroupController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.GroupHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockGroupControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockGroupControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedGroupController.AddClusterScopedHandlerCalls())
func (mock *GroupControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.GroupHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.GroupHandlerFunc
	}
	lockGroupControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockGroupControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *GroupControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GroupHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("GroupControllerMock.AddFeatureHandlerFunc: method is nil but GroupController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.GroupHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockGroupControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockGroupControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedGroupController.AddFeatureHandlerCalls())
func (mock *GroupControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.GroupHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.GroupHandlerFunc
	}
	lockGroupControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockGroupControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *GroupControllerMock) AddHandler(ctx context.Context, name string, handler v31.GroupHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("GroupControllerMock.AddHandlerFunc: method is nil but GroupController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.GroupHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockGroupControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockGroupControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedGroupController.AddHandlerCalls())
func (mock *GroupControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.GroupHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.GroupHandlerFunc
	}
	lockGroupControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockGroupControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *GroupControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("GroupControllerMock.EnqueueFunc: method is nil but GroupController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockGroupControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockGroupControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedGroupController.EnqueueCalls())
func (mock *GroupControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockGroupControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockGroupControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *GroupControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("GroupControllerMock.EnqueueAfterFunc: method is nil but GroupController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockGroupControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockGroupControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedGroupController.EnqueueAfterCalls())
func (mock *GroupControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockGroupControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockGroupControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *GroupControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("GroupControllerMock.GenericFunc: method is nil but GroupController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockGroupControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockGroupControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedGroupController.GenericCalls())
func (mock *GroupControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockGroupControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockGroupControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *GroupControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("GroupControllerMock.InformerFunc: method is nil but GroupController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockGroupControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockGroupControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedGroupController.InformerCalls())
func (mock *GroupControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockGroupControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockGroupControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *GroupControllerMock) Lister() v31.GroupLister {
	if mock.ListerFunc == nil {
		panic("GroupControllerMock.ListerFunc: method is nil but GroupController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockGroupControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockGroupControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedGroupController.ListerCalls())
func (mock *GroupControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockGroupControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockGroupControllerMockLister.RUnlock()
	return calls
}

var (
	lockGroupInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockGroupInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockGroupInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockGroupInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockGroupInterfaceMockAddFeatureHandler                sync.RWMutex
	lockGroupInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockGroupInterfaceMockAddHandler                       sync.RWMutex
	lockGroupInterfaceMockAddLifecycle                     sync.RWMutex
	lockGroupInterfaceMockController                       sync.RWMutex
	lockGroupInterfaceMockCreate                           sync.RWMutex
	lockGroupInterfaceMockDelete                           sync.RWMutex
	lockGroupInterfaceMockDeleteCollection                 sync.RWMutex
	lockGroupInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockGroupInterfaceMockGet                              sync.RWMutex
	lockGroupInterfaceMockGetNamespaced                    sync.RWMutex
	lockGroupInterfaceMockList                             sync.RWMutex
	lockGroupInterfaceMockListNamespaced                   sync.RWMutex
	lockGroupInterfaceMockObjectClient                     sync.RWMutex
	lockGroupInterfaceMockUpdate                           sync.RWMutex
	lockGroupInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that GroupInterfaceMock does implement v31.GroupInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.GroupInterface = &GroupInterfaceMock{}

// GroupInterfaceMock is a mock implementation of v31.GroupInterface.
//
//     func TestSomethingThatUsesGroupInterface(t *testing.T) {
//
//         // make and configure a mocked v31.GroupInterface
//         mockedGroupInterface := &GroupInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.GroupHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.GroupLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.GroupHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.GroupLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GroupHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.GroupLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.GroupHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.GroupLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.GroupController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.Group) (*v3.Group, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.Group, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.Group, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.GroupList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.GroupList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.Group) (*v3.Group, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedGroupInterface in code that requires v31.GroupInterface
//         // and then make assertions.
//
//     }
type GroupInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.GroupHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.GroupLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.GroupHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.GroupLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GroupHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.GroupLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.GroupHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.GroupLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.GroupController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.Group) (*v3.Group, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.Group, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.Group, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.GroupList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.GroupList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.Group) (*v3.Group, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.GroupHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.GroupLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.GroupHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.GroupLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.GroupHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.GroupLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.GroupHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.GroupLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.Group
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.Group
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *GroupInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.GroupHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("GroupInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but GroupInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.GroupHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockGroupInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockGroupInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedGroupInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *GroupInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.GroupHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.GroupHandlerFunc
	}
	lockGroupInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockGroupInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *GroupInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.GroupLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("GroupInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but GroupInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.GroupLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockGroupInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockGroupInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedGroupInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *GroupInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.GroupLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.GroupLifecycle
	}
	lockGroupInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockGroupInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *GroupInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.GroupHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("GroupInterfaceMock.AddClusterScopedHandlerFunc: method is nil but GroupInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.GroupHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockGroupInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockGroupInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedGroupInterface.AddClusterScopedHandlerCalls())
func (mock *GroupInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.GroupHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.GroupHandlerFunc
	}
	lockGroupInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockGroupInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *GroupInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.GroupLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("GroupInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but GroupInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.GroupLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockGroupInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockGroupInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedGroupInterface.AddClusterScopedLifecycleCalls())
func (mock *GroupInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.GroupLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.GroupLifecycle
	}
	lockGroupInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockGroupInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *GroupInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.GroupHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("GroupInterfaceMock.AddFeatureHandlerFunc: method is nil but GroupInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.GroupHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockGroupInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockGroupInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedGroupInterface.AddFeatureHandlerCalls())
func (mock *GroupInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.GroupHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.GroupHandlerFunc
	}
	lockGroupInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockGroupInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *GroupInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.GroupLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("GroupInterfaceMock.AddFeatureLifecycleFunc: method is nil but GroupInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.GroupLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockGroupInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockGroupInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedGroupInterface.AddFeatureLifecycleCalls())
func (mock *GroupInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.GroupLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.GroupLifecycle
	}
	lockGroupInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockGroupInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *GroupInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.GroupHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("GroupInterfaceMock.AddHandlerFunc: method is nil but GroupInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.GroupHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockGroupInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockGroupInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedGroupInterface.AddHandlerCalls())
func (mock *GroupInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.GroupHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.GroupHandlerFunc
	}
	lockGroupInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockGroupInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *GroupInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.GroupLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("GroupInterfaceMock.AddLifecycleFunc: method is nil but GroupInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.GroupLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockGroupInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockGroupInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedGroupInterface.AddLifecycleCalls())
func (mock *GroupInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.GroupLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.GroupLifecycle
	}
	lockGroupInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockGroupInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *GroupInterfaceMock) Controller() v31.GroupController {
	if mock.ControllerFunc == nil {
		panic("GroupInterfaceMock.ControllerFunc: method is nil but GroupInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockGroupInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockGroupInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedGroupInterface.ControllerCalls())
func (mock *GroupInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockGroupInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockGroupInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *GroupInterfaceMock) Create(in1 *v3.Group) (*v3.Group, error) {
	if mock.CreateFunc == nil {
		panic("GroupInterfaceMock.CreateFunc: method is nil but GroupInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.Group
	}{
		In1: in1,
	}
	lockGroupInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockGroupInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedGroupInterface.CreateCalls())
func (mock *GroupInterfaceMock) CreateCalls() []struct {
	In1 *v3.Group
} {
	var calls []struct {
		In1 *v3.Group
	}
	lockGroupInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockGroupInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *GroupInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("GroupInterfaceMock.DeleteFunc: method is nil but GroupInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockGroupInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockGroupInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedGroupInterface.DeleteCalls())
func (mock *GroupInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockGroupInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockGroupInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *GroupInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("GroupInterfaceMock.DeleteCollectionFunc: method is nil but GroupInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockGroupInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockGroupInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedGroupInterface.DeleteCollectionCalls())
func (mock *GroupInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockGroupInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockGroupInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *GroupInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("GroupInterfaceMock.DeleteNamespacedFunc: method is nil but GroupInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockGroupInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockGroupInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedGroupInterface.DeleteNamespacedCalls())
func (mock *GroupInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockGroupInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockGroupInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *GroupInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.Group, error) {
	if mock.GetFunc == nil {
		panic("GroupInterfaceMock.GetFunc: method is nil but GroupInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockGroupInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockGroupInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedGroupInterface.GetCalls())
func (mock *GroupInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockGroupInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockGroupInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *GroupInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.Group, error) {
	if mock.GetNamespacedFunc == nil {
		panic("GroupInterfaceMock.GetNamespacedFunc: method is nil but GroupInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockGroupInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockGroupInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedGroupInterface.GetNamespacedCalls())
func (mock *GroupInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockGroupInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockGroupInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *GroupInterfaceMock) List(opts metav1.ListOptions) (*v3.GroupList, error) {
	if mock.ListFunc == nil {
		panic("GroupInterfaceMock.ListFunc: method is nil but GroupInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockGroupInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockGroupInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedGroupInterface.ListCalls())
func (mock *GroupInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockGroupInterfaceMockList.RLock()
	calls = mock.calls.List
	lockGroupInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *GroupInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.GroupList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("GroupInterfaceMock.ListNamespacedFunc: method is nil but GroupInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockGroupInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockGroupInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedGroupInterface.ListNamespacedCalls())
func (mock *GroupInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockGroupInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockGroupInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *GroupInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("GroupInterfaceMock.ObjectClientFunc: method is nil but GroupInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockGroupInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockGroupInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedGroupInterface.ObjectClientCalls())
func (mock *GroupInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockGroupInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockGroupInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *GroupInterfaceMock) Update(in1 *v3.Group) (*v3.Group, error) {
	if mock.UpdateFunc == nil {
		panic("GroupInterfaceMock.UpdateFunc: method is nil but GroupInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.Group
	}{
		In1: in1,
	}
	lockGroupInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockGroupInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedGroupInterface.UpdateCalls())
func (mock *GroupInterfaceMock) UpdateCalls() []struct {
	In1 *v3.Group
} {
	var calls []struct {
		In1 *v3.Group
	}
	lockGroupInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockGroupInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *GroupInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("GroupInterfaceMock.WatchFunc: method is nil but GroupInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockGroupInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockGroupInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedGroupInterface.WatchCalls())
func (mock *GroupInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockGroupInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockGroupInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockGroupsGetterMockGroups sync.RWMutex
)

// Ensure, that GroupsGetterMock does implement v31.GroupsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.GroupsGetter = &GroupsGetterMock{}

// GroupsGetterMock is a mock implementation of v31.GroupsGetter.
//
//     func TestSomethingThatUsesGroupsGetter(t *testing.T) {
//
//         // make and configure a mocked v31.GroupsGetter
//         mockedGroupsGetter := &GroupsGetterMock{
//             GroupsFunc: func(namespace string) v31.GroupInterface {
// 	               panic("mock out the Groups method")
//             },
//         }
//
//         // use mockedGroupsGetter in code that requires v31.GroupsGetter
//         // and then make assertions.
//
//     }
type GroupsGetterMock struct {
	// GroupsFunc mocks the Groups method.
	GroupsFunc func(namespace string) v31.GroupInterface

	// calls tracks calls to the methods.
	calls struct {
		// Groups holds details about calls to the Groups method.
		Groups []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// Groups calls GroupsFunc.
func (mock *GroupsGetterMock) Groups(namespace string) v31.GroupInterface {
	if mock.GroupsFunc == nil {
		panic("GroupsGetterMock.GroupsFunc: method is nil but GroupsGetter.Groups was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockGroupsGetterMockGroups.Lock()
	mock.calls.Groups = append(mock.calls.Groups, callInfo)
	lockGroupsGetterMockGroups.Unlock()
	return mock.GroupsFunc(namespace)
}

// GroupsCalls gets all the calls that were made to Groups.
// Check the length with:
//     len(mockedGroupsGetter.GroupsCalls())
func (mock *GroupsGetterMock) GroupsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockGroupsGetterMockGroups.RLock()
	calls = mock.calls.Groups
	lockGroupsGetterMockGroups.RUnlock()
	return calls
}
