// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockMonitorMetricListerMockGet  sync.RWMutex
	lockMonitorMetricListerMockList sync.RWMutex
)

// Ensure, that MonitorMetricListerMock does implement v31.MonitorMetricLister.
// If this is not the case, regenerate this file with moq.
var _ v31.MonitorMetricLister = &MonitorMetricListerMock{}

// MonitorMetricListerMock is a mock implementation of v31.MonitorMetricLister.
//
//     func TestSomethingThatUsesMonitorMetricLister(t *testing.T) {
//
//         // make and configure a mocked v31.MonitorMetricLister
//         mockedMonitorMetricLister := &MonitorMetricListerMock{
//             GetFunc: func(namespace string, name string) (*v3.MonitorMetric, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.MonitorMetric, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedMonitorMetricLister in code that requires v31.MonitorMetricLister
//         // and then make assertions.
//
//     }
type MonitorMetricListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.MonitorMetric, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.MonitorMetric, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *MonitorMetricListerMock) Get(namespace string, name string) (*v3.MonitorMetric, error) {
	if mock.GetFunc == nil {
		panic("MonitorMetricListerMock.GetFunc: method is nil but MonitorMetricLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockMonitorMetricListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockMonitorMetricListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedMonitorMetricLister.GetCalls())
func (mock *MonitorMetricListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockMonitorMetricListerMockGet.RLock()
	calls = mock.calls.Get
	lockMonitorMetricListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *MonitorMetricListerMock) List(namespace string, selector labels.Selector) ([]*v3.MonitorMetric, error) {
	if mock.ListFunc == nil {
		panic("MonitorMetricListerMock.ListFunc: method is nil but MonitorMetricLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockMonitorMetricListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockMonitorMetricListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedMonitorMetricLister.ListCalls())
func (mock *MonitorMetricListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockMonitorMetricListerMockList.RLock()
	calls = mock.calls.List
	lockMonitorMetricListerMockList.RUnlock()
	return calls
}

var (
	lockMonitorMetricControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockMonitorMetricControllerMockAddClusterScopedHandler        sync.RWMutex
	lockMonitorMetricControllerMockAddFeatureHandler              sync.RWMutex
	lockMonitorMetricControllerMockAddHandler                     sync.RWMutex
	lockMonitorMetricControllerMockEnqueue                        sync.RWMutex
	lockMonitorMetricControllerMockEnqueueAfter                   sync.RWMutex
	lockMonitorMetricControllerMockGeneric                        sync.RWMutex
	lockMonitorMetricControllerMockInformer                       sync.RWMutex
	lockMonitorMetricControllerMockLister                         sync.RWMutex
)

// Ensure, that MonitorMetricControllerMock does implement v31.MonitorMetricController.
// If this is not the case, regenerate this file with moq.
var _ v31.MonitorMetricController = &MonitorMetricControllerMock{}

// MonitorMetricControllerMock is a mock implementation of v31.MonitorMetricController.
//
//     func TestSomethingThatUsesMonitorMetricController(t *testing.T) {
//
//         // make and configure a mocked v31.MonitorMetricController
//         mockedMonitorMetricController := &MonitorMetricControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.MonitorMetricHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.MonitorMetricHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.MonitorMetricHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.MonitorMetricHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.MonitorMetricLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedMonitorMetricController in code that requires v31.MonitorMetricController
//         // and then make assertions.
//
//     }
type MonitorMetricControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.MonitorMetricHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.MonitorMetricHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.MonitorMetricHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.MonitorMetricHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.MonitorMetricLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.MonitorMetricHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.MonitorMetricHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.MonitorMetricHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.MonitorMetricHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *MonitorMetricControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.MonitorMetricHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("MonitorMetricControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but MonitorMetricController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.MonitorMetricHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockMonitorMetricControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockMonitorMetricControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedMonitorMetricController.AddClusterScopedFeatureHandlerCalls())
func (mock *MonitorMetricControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.MonitorMetricHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.MonitorMetricHandlerFunc
	}
	lockMonitorMetricControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockMonitorMetricControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *MonitorMetricControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.MonitorMetricHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("MonitorMetricControllerMock.AddClusterScopedHandlerFunc: method is nil but MonitorMetricController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.MonitorMetricHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockMonitorMetricControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockMonitorMetricControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedMonitorMetricController.AddClusterScopedHandlerCalls())
func (mock *MonitorMetricControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.MonitorMetricHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.MonitorMetricHandlerFunc
	}
	lockMonitorMetricControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockMonitorMetricControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *MonitorMetricControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.MonitorMetricHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("MonitorMetricControllerMock.AddFeatureHandlerFunc: method is nil but MonitorMetricController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.MonitorMetricHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockMonitorMetricControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockMonitorMetricControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedMonitorMetricController.AddFeatureHandlerCalls())
func (mock *MonitorMetricControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.MonitorMetricHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.MonitorMetricHandlerFunc
	}
	lockMonitorMetricControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockMonitorMetricControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *MonitorMetricControllerMock) AddHandler(ctx context.Context, name string, handler v31.MonitorMetricHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("MonitorMetricControllerMock.AddHandlerFunc: method is nil but MonitorMetricController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.MonitorMetricHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockMonitorMetricControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockMonitorMetricControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedMonitorMetricController.AddHandlerCalls())
func (mock *MonitorMetricControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.MonitorMetricHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.MonitorMetricHandlerFunc
	}
	lockMonitorMetricControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockMonitorMetricControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *MonitorMetricControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("MonitorMetricControllerMock.EnqueueFunc: method is nil but MonitorMetricController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockMonitorMetricControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockMonitorMetricControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedMonitorMetricController.EnqueueCalls())
func (mock *MonitorMetricControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockMonitorMetricControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockMonitorMetricControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *MonitorMetricControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("MonitorMetricControllerMock.EnqueueAfterFunc: method is nil but MonitorMetricController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockMonitorMetricControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockMonitorMetricControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedMonitorMetricController.EnqueueAfterCalls())
func (mock *MonitorMetricControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockMonitorMetricControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockMonitorMetricControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *MonitorMetricControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("MonitorMetricControllerMock.GenericFunc: method is nil but MonitorMetricController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockMonitorMetricControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockMonitorMetricControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedMonitorMetricController.GenericCalls())
func (mock *MonitorMetricControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockMonitorMetricControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockMonitorMetricControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *MonitorMetricControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("MonitorMetricControllerMock.InformerFunc: method is nil but MonitorMetricController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockMonitorMetricControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockMonitorMetricControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedMonitorMetricController.InformerCalls())
func (mock *MonitorMetricControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockMonitorMetricControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockMonitorMetricControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *MonitorMetricControllerMock) Lister() v31.MonitorMetricLister {
	if mock.ListerFunc == nil {
		panic("MonitorMetricControllerMock.ListerFunc: method is nil but MonitorMetricController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockMonitorMetricControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockMonitorMetricControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedMonitorMetricController.ListerCalls())
func (mock *MonitorMetricControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockMonitorMetricControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockMonitorMetricControllerMockLister.RUnlock()
	return calls
}

var (
	lockMonitorMetricInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockMonitorMetricInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockMonitorMetricInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockMonitorMetricInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockMonitorMetricInterfaceMockAddFeatureHandler                sync.RWMutex
	lockMonitorMetricInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockMonitorMetricInterfaceMockAddHandler                       sync.RWMutex
	lockMonitorMetricInterfaceMockAddLifecycle                     sync.RWMutex
	lockMonitorMetricInterfaceMockController                       sync.RWMutex
	lockMonitorMetricInterfaceMockCreate                           sync.RWMutex
	lockMonitorMetricInterfaceMockDelete                           sync.RWMutex
	lockMonitorMetricInterfaceMockDeleteCollection                 sync.RWMutex
	lockMonitorMetricInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockMonitorMetricInterfaceMockGet                              sync.RWMutex
	lockMonitorMetricInterfaceMockGetNamespaced                    sync.RWMutex
	lockMonitorMetricInterfaceMockList                             sync.RWMutex
	lockMonitorMetricInterfaceMockListNamespaced                   sync.RWMutex
	lockMonitorMetricInterfaceMockObjectClient                     sync.RWMutex
	lockMonitorMetricInterfaceMockUpdate                           sync.RWMutex
	lockMonitorMetricInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that MonitorMetricInterfaceMock does implement v31.MonitorMetricInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.MonitorMetricInterface = &MonitorMetricInterfaceMock{}

// MonitorMetricInterfaceMock is a mock implementation of v31.MonitorMetricInterface.
//
//     func TestSomethingThatUsesMonitorMetricInterface(t *testing.T) {
//
//         // make and configure a mocked v31.MonitorMetricInterface
//         mockedMonitorMetricInterface := &MonitorMetricInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.MonitorMetricHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.MonitorMetricLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.MonitorMetricHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.MonitorMetricLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.MonitorMetricHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.MonitorMetricLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.MonitorMetricHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.MonitorMetricLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.MonitorMetricController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.MonitorMetric) (*v3.MonitorMetric, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.MonitorMetric, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.MonitorMetric, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.MonitorMetricList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.MonitorMetricList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.MonitorMetric) (*v3.MonitorMetric, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedMonitorMetricInterface in code that requires v31.MonitorMetricInterface
//         // and then make assertions.
//
//     }
type MonitorMetricInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.MonitorMetricHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.MonitorMetricLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.MonitorMetricHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.MonitorMetricLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.MonitorMetricHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.MonitorMetricLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.MonitorMetricHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.MonitorMetricLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.MonitorMetricController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.MonitorMetric) (*v3.MonitorMetric, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.MonitorMetric, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.MonitorMetric, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.MonitorMetricList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.MonitorMetricList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.MonitorMetric) (*v3.MonitorMetric, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.MonitorMetricHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.MonitorMetricLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.MonitorMetricHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.MonitorMetricLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.MonitorMetricHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.MonitorMetricLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.MonitorMetricHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.MonitorMetricLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.MonitorMetric
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.MonitorMetric
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *MonitorMetricInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.MonitorMetricHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("MonitorMetricInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but MonitorMetricInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.MonitorMetricHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockMonitorMetricInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockMonitorMetricInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedMonitorMetricInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *MonitorMetricInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.MonitorMetricHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.MonitorMetricHandlerFunc
	}
	lockMonitorMetricInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockMonitorMetricInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *MonitorMetricInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.MonitorMetricLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("MonitorMetricInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but MonitorMetricInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.MonitorMetricLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockMonitorMetricInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockMonitorMetricInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedMonitorMetricInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *MonitorMetricInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.MonitorMetricLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.MonitorMetricLifecycle
	}
	lockMonitorMetricInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockMonitorMetricInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *MonitorMetricInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.MonitorMetricHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("MonitorMetricInterfaceMock.AddClusterScopedHandlerFunc: method is nil but MonitorMetricInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.MonitorMetricHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockMonitorMetricInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockMonitorMetricInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedMonitorMetricInterface.AddClusterScopedHandlerCalls())
func (mock *MonitorMetricInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.MonitorMetricHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.MonitorMetricHandlerFunc
	}
	lockMonitorMetricInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockMonitorMetricInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *MonitorMetricInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.MonitorMetricLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("MonitorMetricInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but MonitorMetricInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.MonitorMetricLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockMonitorMetricInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockMonitorMetricInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedMonitorMetricInterface.AddClusterScopedLifecycleCalls())
func (mock *MonitorMetricInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.MonitorMetricLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.MonitorMetricLifecycle
	}
	lockMonitorMetricInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockMonitorMetricInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *MonitorMetricInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.MonitorMetricHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("MonitorMetricInterfaceMock.AddFeatureHandlerFunc: method is nil but MonitorMetricInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.MonitorMetricHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockMonitorMetricInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockMonitorMetricInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedMonitorMetricInterface.AddFeatureHandlerCalls())
func (mock *MonitorMetricInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.MonitorMetricHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.MonitorMetricHandlerFunc
	}
	lockMonitorMetricInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockMonitorMetricInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *MonitorMetricInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.MonitorMetricLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("MonitorMetricInterfaceMock.AddFeatureLifecycleFunc: method is nil but MonitorMetricInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.MonitorMetricLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockMonitorMetricInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockMonitorMetricInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedMonitorMetricInterface.AddFeatureLifecycleCalls())
func (mock *MonitorMetricInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.MonitorMetricLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.MonitorMetricLifecycle
	}
	lockMonitorMetricInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockMonitorMetricInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *MonitorMetricInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.MonitorMetricHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("MonitorMetricInterfaceMock.AddHandlerFunc: method is nil but MonitorMetricInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.MonitorMetricHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockMonitorMetricInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockMonitorMetricInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedMonitorMetricInterface.AddHandlerCalls())
func (mock *MonitorMetricInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.MonitorMetricHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.MonitorMetricHandlerFunc
	}
	lockMonitorMetricInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockMonitorMetricInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *MonitorMetricInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.MonitorMetricLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("MonitorMetricInterfaceMock.AddLifecycleFunc: method is nil but MonitorMetricInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.MonitorMetricLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockMonitorMetricInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockMonitorMetricInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedMonitorMetricInterface.AddLifecycleCalls())
func (mock *MonitorMetricInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.MonitorMetricLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.MonitorMetricLifecycle
	}
	lockMonitorMetricInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockMonitorMetricInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *MonitorMetricInterfaceMock) Controller() v31.MonitorMetricController {
	if mock.ControllerFunc == nil {
		panic("MonitorMetricInterfaceMock.ControllerFunc: method is nil but MonitorMetricInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockMonitorMetricInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockMonitorMetricInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedMonitorMetricInterface.ControllerCalls())
func (mock *MonitorMetricInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockMonitorMetricInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockMonitorMetricInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *MonitorMetricInterfaceMock) Create(in1 *v3.MonitorMetric) (*v3.MonitorMetric, error) {
	if mock.CreateFunc == nil {
		panic("MonitorMetricInterfaceMock.CreateFunc: method is nil but MonitorMetricInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.MonitorMetric
	}{
		In1: in1,
	}
	lockMonitorMetricInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockMonitorMetricInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedMonitorMetricInterface.CreateCalls())
func (mock *MonitorMetricInterfaceMock) CreateCalls() []struct {
	In1 *v3.MonitorMetric
} {
	var calls []struct {
		In1 *v3.MonitorMetric
	}
	lockMonitorMetricInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockMonitorMetricInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *MonitorMetricInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("MonitorMetricInterfaceMock.DeleteFunc: method is nil but MonitorMetricInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockMonitorMetricInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockMonitorMetricInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedMonitorMetricInterface.DeleteCalls())
func (mock *MonitorMetricInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockMonitorMetricInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockMonitorMetricInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *MonitorMetricInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("MonitorMetricInterfaceMock.DeleteCollectionFunc: method is nil but MonitorMetricInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockMonitorMetricInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockMonitorMetricInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedMonitorMetricInterface.DeleteCollectionCalls())
func (mock *MonitorMetricInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockMonitorMetricInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockMonitorMetricInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *MonitorMetricInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("MonitorMetricInterfaceMock.DeleteNamespacedFunc: method is nil but MonitorMetricInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockMonitorMetricInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockMonitorMetricInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedMonitorMetricInterface.DeleteNamespacedCalls())
func (mock *MonitorMetricInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockMonitorMetricInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockMonitorMetricInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *MonitorMetricInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.MonitorMetric, error) {
	if mock.GetFunc == nil {
		panic("MonitorMetricInterfaceMock.GetFunc: method is nil but MonitorMetricInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockMonitorMetricInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockMonitorMetricInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedMonitorMetricInterface.GetCalls())
func (mock *MonitorMetricInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockMonitorMetricInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockMonitorMetricInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *MonitorMetricInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.MonitorMetric, error) {
	if mock.GetNamespacedFunc == nil {
		panic("MonitorMetricInterfaceMock.GetNamespacedFunc: method is nil but MonitorMetricInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockMonitorMetricInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockMonitorMetricInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedMonitorMetricInterface.GetNamespacedCalls())
func (mock *MonitorMetricInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockMonitorMetricInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockMonitorMetricInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *MonitorMetricInterfaceMock) List(opts metav1.ListOptions) (*v3.MonitorMetricList, error) {
	if mock.ListFunc == nil {
		panic("MonitorMetricInterfaceMock.ListFunc: method is nil but MonitorMetricInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockMonitorMetricInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockMonitorMetricInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedMonitorMetricInterface.ListCalls())
func (mock *MonitorMetricInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockMonitorMetricInterfaceMockList.RLock()
	calls = mock.calls.List
	lockMonitorMetricInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *MonitorMetricInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.MonitorMetricList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("MonitorMetricInterfaceMock.ListNamespacedFunc: method is nil but MonitorMetricInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockMonitorMetricInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockMonitorMetricInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedMonitorMetricInterface.ListNamespacedCalls())
func (mock *MonitorMetricInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockMonitorMetricInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockMonitorMetricInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *MonitorMetricInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("MonitorMetricInterfaceMock.ObjectClientFunc: method is nil but MonitorMetricInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockMonitorMetricInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockMonitorMetricInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedMonitorMetricInterface.ObjectClientCalls())
func (mock *MonitorMetricInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockMonitorMetricInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockMonitorMetricInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *MonitorMetricInterfaceMock) Update(in1 *v3.MonitorMetric) (*v3.MonitorMetric, error) {
	if mock.UpdateFunc == nil {
		panic("MonitorMetricInterfaceMock.UpdateFunc: method is nil but MonitorMetricInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.MonitorMetric
	}{
		In1: in1,
	}
	lockMonitorMetricInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockMonitorMetricInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedMonitorMetricInterface.UpdateCalls())
func (mock *MonitorMetricInterfaceMock) UpdateCalls() []struct {
	In1 *v3.MonitorMetric
} {
	var calls []struct {
		In1 *v3.MonitorMetric
	}
	lockMonitorMetricInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockMonitorMetricInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *MonitorMetricInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("MonitorMetricInterfaceMock.WatchFunc: method is nil but MonitorMetricInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockMonitorMetricInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockMonitorMetricInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedMonitorMetricInterface.WatchCalls())
func (mock *MonitorMetricInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockMonitorMetricInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockMonitorMetricInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockMonitorMetricsGetterMockMonitorMetrics sync.RWMutex
)

// Ensure, that MonitorMetricsGetterMock does implement v31.MonitorMetricsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.MonitorMetricsGetter = &MonitorMetricsGetterMock{}

// MonitorMetricsGetterMock is a mock implementation of v31.MonitorMetricsGetter.
//
//     func TestSomethingThatUsesMonitorMetricsGetter(t *testing.T) {
//
//         // make and configure a mocked v31.MonitorMetricsGetter
//         mockedMonitorMetricsGetter := &MonitorMetricsGetterMock{
//             MonitorMetricsFunc: func(namespace string) v31.MonitorMetricInterface {
// 	               panic("mock out the MonitorMetrics method")
//             },
//         }
//
//         // use mockedMonitorMetricsGetter in code that requires v31.MonitorMetricsGetter
//         // and then make assertions.
//
//     }
type MonitorMetricsGetterMock struct {
	// MonitorMetricsFunc mocks the MonitorMetrics method.
	MonitorMetricsFunc func(namespace string) v31.MonitorMetricInterface

	// calls tracks calls to the methods.
	calls struct {
		// MonitorMetrics holds details about calls to the MonitorMetrics method.
		MonitorMetrics []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// MonitorMetrics calls MonitorMetricsFunc.
func (mock *MonitorMetricsGetterMock) MonitorMetrics(namespace string) v31.MonitorMetricInterface {
	if mock.MonitorMetricsFunc == nil {
		panic("MonitorMetricsGetterMock.MonitorMetricsFunc: method is nil but MonitorMetricsGetter.MonitorMetrics was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockMonitorMetricsGetterMockMonitorMetrics.Lock()
	mock.calls.MonitorMetrics = append(mock.calls.MonitorMetrics, callInfo)
	lockMonitorMetricsGetterMockMonitorMetrics.Unlock()
	return mock.MonitorMetricsFunc(namespace)
}

// MonitorMetricsCalls gets all the calls that were made to MonitorMetrics.
// Check the length with:
//     len(mockedMonitorMetricsGetter.MonitorMetricsCalls())
func (mock *MonitorMetricsGetterMock) MonitorMetricsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockMonitorMetricsGetterMockMonitorMetrics.RLock()
	calls = mock.calls.MonitorMetrics
	lockMonitorMetricsGetterMockMonitorMetrics.RUnlock()
	return calls
}
