// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockMultiClusterAppListerMockGet  sync.RWMutex
	lockMultiClusterAppListerMockList sync.RWMutex
)

// Ensure, that MultiClusterAppListerMock does implement v31.MultiClusterAppLister.
// If this is not the case, regenerate this file with moq.
var _ v31.MultiClusterAppLister = &MultiClusterAppListerMock{}

// MultiClusterAppListerMock is a mock implementation of v31.MultiClusterAppLister.
//
//     func TestSomethingThatUsesMultiClusterAppLister(t *testing.T) {
//
//         // make and configure a mocked v31.MultiClusterAppLister
//         mockedMultiClusterAppLister := &MultiClusterAppListerMock{
//             GetFunc: func(namespace string, name string) (*v3.MultiClusterApp, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.MultiClusterApp, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedMultiClusterAppLister in code that requires v31.MultiClusterAppLister
//         // and then make assertions.
//
//     }
type MultiClusterAppListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.MultiClusterApp, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.MultiClusterApp, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *MultiClusterAppListerMock) Get(namespace string, name string) (*v3.MultiClusterApp, error) {
	if mock.GetFunc == nil {
		panic("MultiClusterAppListerMock.GetFunc: method is nil but MultiClusterAppLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockMultiClusterAppListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockMultiClusterAppListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedMultiClusterAppLister.GetCalls())
func (mock *MultiClusterAppListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockMultiClusterAppListerMockGet.RLock()
	calls = mock.calls.Get
	lockMultiClusterAppListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *MultiClusterAppListerMock) List(namespace string, selector labels.Selector) ([]*v3.MultiClusterApp, error) {
	if mock.ListFunc == nil {
		panic("MultiClusterAppListerMock.ListFunc: method is nil but MultiClusterAppLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockMultiClusterAppListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockMultiClusterAppListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedMultiClusterAppLister.ListCalls())
func (mock *MultiClusterAppListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockMultiClusterAppListerMockList.RLock()
	calls = mock.calls.List
	lockMultiClusterAppListerMockList.RUnlock()
	return calls
}

var (
	lockMultiClusterAppControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockMultiClusterAppControllerMockAddClusterScopedHandler        sync.RWMutex
	lockMultiClusterAppControllerMockAddFeatureHandler              sync.RWMutex
	lockMultiClusterAppControllerMockAddHandler                     sync.RWMutex
	lockMultiClusterAppControllerMockEnqueue                        sync.RWMutex
	lockMultiClusterAppControllerMockEnqueueAfter                   sync.RWMutex
	lockMultiClusterAppControllerMockGeneric                        sync.RWMutex
	lockMultiClusterAppControllerMockInformer                       sync.RWMutex
	lockMultiClusterAppControllerMockLister                         sync.RWMutex
)

// Ensure, that MultiClusterAppControllerMock does implement v31.MultiClusterAppController.
// If this is not the case, regenerate this file with moq.
var _ v31.MultiClusterAppController = &MultiClusterAppControllerMock{}

// MultiClusterAppControllerMock is a mock implementation of v31.MultiClusterAppController.
//
//     func TestSomethingThatUsesMultiClusterAppController(t *testing.T) {
//
//         // make and configure a mocked v31.MultiClusterAppController
//         mockedMultiClusterAppController := &MultiClusterAppControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.MultiClusterAppHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.MultiClusterAppHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.MultiClusterAppHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.MultiClusterAppHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.MultiClusterAppLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedMultiClusterAppController in code that requires v31.MultiClusterAppController
//         // and then make assertions.
//
//     }
type MultiClusterAppControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.MultiClusterAppHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.MultiClusterAppHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.MultiClusterAppHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.MultiClusterAppHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.MultiClusterAppLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.MultiClusterAppHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.MultiClusterAppHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.MultiClusterAppHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.MultiClusterAppHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *MultiClusterAppControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.MultiClusterAppHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("MultiClusterAppControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but MultiClusterAppController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.MultiClusterAppHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockMultiClusterAppControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockMultiClusterAppControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedMultiClusterAppController.AddClusterScopedFeatureHandlerCalls())
func (mock *MultiClusterAppControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.MultiClusterAppHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.MultiClusterAppHandlerFunc
	}
	lockMultiClusterAppControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockMultiClusterAppControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *MultiClusterAppControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.MultiClusterAppHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("MultiClusterAppControllerMock.AddClusterScopedHandlerFunc: method is nil but MultiClusterAppController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.MultiClusterAppHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockMultiClusterAppControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockMultiClusterAppControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedMultiClusterAppController.AddClusterScopedHandlerCalls())
func (mock *MultiClusterAppControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.MultiClusterAppHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.MultiClusterAppHandlerFunc
	}
	lockMultiClusterAppControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockMultiClusterAppControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *MultiClusterAppControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.MultiClusterAppHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("MultiClusterAppControllerMock.AddFeatureHandlerFunc: method is nil but MultiClusterAppController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.MultiClusterAppHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockMultiClusterAppControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockMultiClusterAppControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedMultiClusterAppController.AddFeatureHandlerCalls())
func (mock *MultiClusterAppControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.MultiClusterAppHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.MultiClusterAppHandlerFunc
	}
	lockMultiClusterAppControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockMultiClusterAppControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *MultiClusterAppControllerMock) AddHandler(ctx context.Context, name string, handler v31.MultiClusterAppHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("MultiClusterAppControllerMock.AddHandlerFunc: method is nil but MultiClusterAppController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.MultiClusterAppHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockMultiClusterAppControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockMultiClusterAppControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedMultiClusterAppController.AddHandlerCalls())
func (mock *MultiClusterAppControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.MultiClusterAppHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.MultiClusterAppHandlerFunc
	}
	lockMultiClusterAppControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockMultiClusterAppControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *MultiClusterAppControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("MultiClusterAppControllerMock.EnqueueFunc: method is nil but MultiClusterAppController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockMultiClusterAppControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockMultiClusterAppControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedMultiClusterAppController.EnqueueCalls())
func (mock *MultiClusterAppControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockMultiClusterAppControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockMultiClusterAppControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *MultiClusterAppControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("MultiClusterAppControllerMock.EnqueueAfterFunc: method is nil but MultiClusterAppController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockMultiClusterAppControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockMultiClusterAppControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedMultiClusterAppController.EnqueueAfterCalls())
func (mock *MultiClusterAppControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockMultiClusterAppControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockMultiClusterAppControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *MultiClusterAppControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("MultiClusterAppControllerMock.GenericFunc: method is nil but MultiClusterAppController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockMultiClusterAppControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockMultiClusterAppControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedMultiClusterAppController.GenericCalls())
func (mock *MultiClusterAppControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockMultiClusterAppControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockMultiClusterAppControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *MultiClusterAppControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("MultiClusterAppControllerMock.InformerFunc: method is nil but MultiClusterAppController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockMultiClusterAppControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockMultiClusterAppControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedMultiClusterAppController.InformerCalls())
func (mock *MultiClusterAppControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockMultiClusterAppControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockMultiClusterAppControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *MultiClusterAppControllerMock) Lister() v31.MultiClusterAppLister {
	if mock.ListerFunc == nil {
		panic("MultiClusterAppControllerMock.ListerFunc: method is nil but MultiClusterAppController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockMultiClusterAppControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockMultiClusterAppControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedMultiClusterAppController.ListerCalls())
func (mock *MultiClusterAppControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockMultiClusterAppControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockMultiClusterAppControllerMockLister.RUnlock()
	return calls
}

var (
	lockMultiClusterAppInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockMultiClusterAppInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockMultiClusterAppInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockMultiClusterAppInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockMultiClusterAppInterfaceMockAddFeatureHandler                sync.RWMutex
	lockMultiClusterAppInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockMultiClusterAppInterfaceMockAddHandler                       sync.RWMutex
	lockMultiClusterAppInterfaceMockAddLifecycle                     sync.RWMutex
	lockMultiClusterAppInterfaceMockController                       sync.RWMutex
	lockMultiClusterAppInterfaceMockCreate                           sync.RWMutex
	lockMultiClusterAppInterfaceMockDelete                           sync.RWMutex
	lockMultiClusterAppInterfaceMockDeleteCollection                 sync.RWMutex
	lockMultiClusterAppInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockMultiClusterAppInterfaceMockGet                              sync.RWMutex
	lockMultiClusterAppInterfaceMockGetNamespaced                    sync.RWMutex
	lockMultiClusterAppInterfaceMockList                             sync.RWMutex
	lockMultiClusterAppInterfaceMockListNamespaced                   sync.RWMutex
	lockMultiClusterAppInterfaceMockObjectClient                     sync.RWMutex
	lockMultiClusterAppInterfaceMockUpdate                           sync.RWMutex
	lockMultiClusterAppInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that MultiClusterAppInterfaceMock does implement v31.MultiClusterAppInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.MultiClusterAppInterface = &MultiClusterAppInterfaceMock{}

// MultiClusterAppInterfaceMock is a mock implementation of v31.MultiClusterAppInterface.
//
//     func TestSomethingThatUsesMultiClusterAppInterface(t *testing.T) {
//
//         // make and configure a mocked v31.MultiClusterAppInterface
//         mockedMultiClusterAppInterface := &MultiClusterAppInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.MultiClusterAppHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.MultiClusterAppLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.MultiClusterAppHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.MultiClusterAppLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.MultiClusterAppHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.MultiClusterAppLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.MultiClusterAppHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.MultiClusterAppLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.MultiClusterAppController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.MultiClusterApp) (*v3.MultiClusterApp, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.MultiClusterApp, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.MultiClusterApp, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.MultiClusterAppList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.MultiClusterAppList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.MultiClusterApp) (*v3.MultiClusterApp, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedMultiClusterAppInterface in code that requires v31.MultiClusterAppInterface
//         // and then make assertions.
//
//     }
type MultiClusterAppInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.MultiClusterAppHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.MultiClusterAppLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.MultiClusterAppHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.MultiClusterAppLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.MultiClusterAppHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.MultiClusterAppLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.MultiClusterAppHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.MultiClusterAppLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.MultiClusterAppController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.MultiClusterApp) (*v3.MultiClusterApp, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.MultiClusterApp, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.MultiClusterApp, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.MultiClusterAppList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.MultiClusterAppList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.MultiClusterApp) (*v3.MultiClusterApp, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.MultiClusterAppHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.MultiClusterAppLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.MultiClusterAppHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.MultiClusterAppLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.MultiClusterAppHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.MultiClusterAppLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.MultiClusterAppHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.MultiClusterAppLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.MultiClusterApp
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.MultiClusterApp
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *MultiClusterAppInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.MultiClusterAppHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("MultiClusterAppInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but MultiClusterAppInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.MultiClusterAppHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockMultiClusterAppInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockMultiClusterAppInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedMultiClusterAppInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *MultiClusterAppInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.MultiClusterAppHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.MultiClusterAppHandlerFunc
	}
	lockMultiClusterAppInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockMultiClusterAppInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *MultiClusterAppInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.MultiClusterAppLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("MultiClusterAppInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but MultiClusterAppInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.MultiClusterAppLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockMultiClusterAppInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockMultiClusterAppInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedMultiClusterAppInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *MultiClusterAppInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.MultiClusterAppLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.MultiClusterAppLifecycle
	}
	lockMultiClusterAppInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockMultiClusterAppInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *MultiClusterAppInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.MultiClusterAppHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("MultiClusterAppInterfaceMock.AddClusterScopedHandlerFunc: method is nil but MultiClusterAppInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.MultiClusterAppHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockMultiClusterAppInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockMultiClusterAppInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedMultiClusterAppInterface.AddClusterScopedHandlerCalls())
func (mock *MultiClusterAppInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.MultiClusterAppHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.MultiClusterAppHandlerFunc
	}
	lockMultiClusterAppInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockMultiClusterAppInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *MultiClusterAppInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.MultiClusterAppLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("MultiClusterAppInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but MultiClusterAppInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.MultiClusterAppLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockMultiClusterAppInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockMultiClusterAppInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedMultiClusterAppInterface.AddClusterScopedLifecycleCalls())
func (mock *MultiClusterAppInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.MultiClusterAppLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.MultiClusterAppLifecycle
	}
	lockMultiClusterAppInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockMultiClusterAppInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *MultiClusterAppInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.MultiClusterAppHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("MultiClusterAppInterfaceMock.AddFeatureHandlerFunc: method is nil but MultiClusterAppInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.MultiClusterAppHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockMultiClusterAppInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockMultiClusterAppInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedMultiClusterAppInterface.AddFeatureHandlerCalls())
func (mock *MultiClusterAppInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.MultiClusterAppHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.MultiClusterAppHandlerFunc
	}
	lockMultiClusterAppInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockMultiClusterAppInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *MultiClusterAppInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.MultiClusterAppLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("MultiClusterAppInterfaceMock.AddFeatureLifecycleFunc: method is nil but MultiClusterAppInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.MultiClusterAppLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockMultiClusterAppInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockMultiClusterAppInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedMultiClusterAppInterface.AddFeatureLifecycleCalls())
func (mock *MultiClusterAppInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.MultiClusterAppLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.MultiClusterAppLifecycle
	}
	lockMultiClusterAppInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockMultiClusterAppInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *MultiClusterAppInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.MultiClusterAppHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("MultiClusterAppInterfaceMock.AddHandlerFunc: method is nil but MultiClusterAppInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.MultiClusterAppHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockMultiClusterAppInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockMultiClusterAppInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedMultiClusterAppInterface.AddHandlerCalls())
func (mock *MultiClusterAppInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.MultiClusterAppHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.MultiClusterAppHandlerFunc
	}
	lockMultiClusterAppInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockMultiClusterAppInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *MultiClusterAppInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.MultiClusterAppLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("MultiClusterAppInterfaceMock.AddLifecycleFunc: method is nil but MultiClusterAppInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.MultiClusterAppLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockMultiClusterAppInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockMultiClusterAppInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedMultiClusterAppInterface.AddLifecycleCalls())
func (mock *MultiClusterAppInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.MultiClusterAppLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.MultiClusterAppLifecycle
	}
	lockMultiClusterAppInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockMultiClusterAppInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *MultiClusterAppInterfaceMock) Controller() v31.MultiClusterAppController {
	if mock.ControllerFunc == nil {
		panic("MultiClusterAppInterfaceMock.ControllerFunc: method is nil but MultiClusterAppInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockMultiClusterAppInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockMultiClusterAppInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedMultiClusterAppInterface.ControllerCalls())
func (mock *MultiClusterAppInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockMultiClusterAppInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockMultiClusterAppInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *MultiClusterAppInterfaceMock) Create(in1 *v3.MultiClusterApp) (*v3.MultiClusterApp, error) {
	if mock.CreateFunc == nil {
		panic("MultiClusterAppInterfaceMock.CreateFunc: method is nil but MultiClusterAppInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.MultiClusterApp
	}{
		In1: in1,
	}
	lockMultiClusterAppInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockMultiClusterAppInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedMultiClusterAppInterface.CreateCalls())
func (mock *MultiClusterAppInterfaceMock) CreateCalls() []struct {
	In1 *v3.MultiClusterApp
} {
	var calls []struct {
		In1 *v3.MultiClusterApp
	}
	lockMultiClusterAppInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockMultiClusterAppInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *MultiClusterAppInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("MultiClusterAppInterfaceMock.DeleteFunc: method is nil but MultiClusterAppInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockMultiClusterAppInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockMultiClusterAppInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedMultiClusterAppInterface.DeleteCalls())
func (mock *MultiClusterAppInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockMultiClusterAppInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockMultiClusterAppInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *MultiClusterAppInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("MultiClusterAppInterfaceMock.DeleteCollectionFunc: method is nil but MultiClusterAppInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockMultiClusterAppInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockMultiClusterAppInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedMultiClusterAppInterface.DeleteCollectionCalls())
func (mock *MultiClusterAppInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockMultiClusterAppInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockMultiClusterAppInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *MultiClusterAppInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("MultiClusterAppInterfaceMock.DeleteNamespacedFunc: method is nil but MultiClusterAppInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockMultiClusterAppInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockMultiClusterAppInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedMultiClusterAppInterface.DeleteNamespacedCalls())
func (mock *MultiClusterAppInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockMultiClusterAppInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockMultiClusterAppInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *MultiClusterAppInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.MultiClusterApp, error) {
	if mock.GetFunc == nil {
		panic("MultiClusterAppInterfaceMock.GetFunc: method is nil but MultiClusterAppInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockMultiClusterAppInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockMultiClusterAppInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedMultiClusterAppInterface.GetCalls())
func (mock *MultiClusterAppInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockMultiClusterAppInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockMultiClusterAppInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *MultiClusterAppInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.MultiClusterApp, error) {
	if mock.GetNamespacedFunc == nil {
		panic("MultiClusterAppInterfaceMock.GetNamespacedFunc: method is nil but MultiClusterAppInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockMultiClusterAppInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockMultiClusterAppInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedMultiClusterAppInterface.GetNamespacedCalls())
func (mock *MultiClusterAppInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockMultiClusterAppInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockMultiClusterAppInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *MultiClusterAppInterfaceMock) List(opts metav1.ListOptions) (*v3.MultiClusterAppList, error) {
	if mock.ListFunc == nil {
		panic("MultiClusterAppInterfaceMock.ListFunc: method is nil but MultiClusterAppInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockMultiClusterAppInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockMultiClusterAppInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedMultiClusterAppInterface.ListCalls())
func (mock *MultiClusterAppInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockMultiClusterAppInterfaceMockList.RLock()
	calls = mock.calls.List
	lockMultiClusterAppInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *MultiClusterAppInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.MultiClusterAppList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("MultiClusterAppInterfaceMock.ListNamespacedFunc: method is nil but MultiClusterAppInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockMultiClusterAppInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockMultiClusterAppInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedMultiClusterAppInterface.ListNamespacedCalls())
func (mock *MultiClusterAppInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockMultiClusterAppInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockMultiClusterAppInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *MultiClusterAppInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("MultiClusterAppInterfaceMock.ObjectClientFunc: method is nil but MultiClusterAppInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockMultiClusterAppInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockMultiClusterAppInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedMultiClusterAppInterface.ObjectClientCalls())
func (mock *MultiClusterAppInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockMultiClusterAppInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockMultiClusterAppInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *MultiClusterAppInterfaceMock) Update(in1 *v3.MultiClusterApp) (*v3.MultiClusterApp, error) {
	if mock.UpdateFunc == nil {
		panic("MultiClusterAppInterfaceMock.UpdateFunc: method is nil but MultiClusterAppInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.MultiClusterApp
	}{
		In1: in1,
	}
	lockMultiClusterAppInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockMultiClusterAppInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedMultiClusterAppInterface.UpdateCalls())
func (mock *MultiClusterAppInterfaceMock) UpdateCalls() []struct {
	In1 *v3.MultiClusterApp
} {
	var calls []struct {
		In1 *v3.MultiClusterApp
	}
	lockMultiClusterAppInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockMultiClusterAppInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *MultiClusterAppInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("MultiClusterAppInterfaceMock.WatchFunc: method is nil but MultiClusterAppInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockMultiClusterAppInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockMultiClusterAppInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedMultiClusterAppInterface.WatchCalls())
func (mock *MultiClusterAppInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockMultiClusterAppInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockMultiClusterAppInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockMultiClusterAppsGetterMockMultiClusterApps sync.RWMutex
)

// Ensure, that MultiClusterAppsGetterMock does implement v31.MultiClusterAppsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.MultiClusterAppsGetter = &MultiClusterAppsGetterMock{}

// MultiClusterAppsGetterMock is a mock implementation of v31.MultiClusterAppsGetter.
//
//     func TestSomethingThatUsesMultiClusterAppsGetter(t *testing.T) {
//
//         // make and configure a mocked v31.MultiClusterAppsGetter
//         mockedMultiClusterAppsGetter := &MultiClusterAppsGetterMock{
//             MultiClusterAppsFunc: func(namespace string) v31.MultiClusterAppInterface {
// 	               panic("mock out the MultiClusterApps method")
//             },
//         }
//
//         // use mockedMultiClusterAppsGetter in code that requires v31.MultiClusterAppsGetter
//         // and then make assertions.
//
//     }
type MultiClusterAppsGetterMock struct {
	// MultiClusterAppsFunc mocks the MultiClusterApps method.
	MultiClusterAppsFunc func(namespace string) v31.MultiClusterAppInterface

	// calls tracks calls to the methods.
	calls struct {
		// MultiClusterApps holds details about calls to the MultiClusterApps method.
		MultiClusterApps []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// MultiClusterApps calls MultiClusterAppsFunc.
func (mock *MultiClusterAppsGetterMock) MultiClusterApps(namespace string) v31.MultiClusterAppInterface {
	if mock.MultiClusterAppsFunc == nil {
		panic("MultiClusterAppsGetterMock.MultiClusterAppsFunc: method is nil but MultiClusterAppsGetter.MultiClusterApps was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockMultiClusterAppsGetterMockMultiClusterApps.Lock()
	mock.calls.MultiClusterApps = append(mock.calls.MultiClusterApps, callInfo)
	lockMultiClusterAppsGetterMockMultiClusterApps.Unlock()
	return mock.MultiClusterAppsFunc(namespace)
}

// MultiClusterAppsCalls gets all the calls that were made to MultiClusterApps.
// Check the length with:
//     len(mockedMultiClusterAppsGetter.MultiClusterAppsCalls())
func (mock *MultiClusterAppsGetterMock) MultiClusterAppsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockMultiClusterAppsGetterMockMultiClusterApps.RLock()
	calls = mock.calls.MultiClusterApps
	lockMultiClusterAppsGetterMockMultiClusterApps.RUnlock()
	return calls
}
