// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockNodeListerMockGet  sync.RWMutex
	lockNodeListerMockList sync.RWMutex
)

// Ensure, that NodeListerMock does implement v31.NodeLister.
// If this is not the case, regenerate this file with moq.
var _ v31.NodeLister = &NodeListerMock{}

// NodeListerMock is a mock implementation of v31.NodeLister.
//
//     func TestSomethingThatUsesNodeLister(t *testing.T) {
//
//         // make and configure a mocked v31.NodeLister
//         mockedNodeLister := &NodeListerMock{
//             GetFunc: func(namespace string, name string) (*v3.Node, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.Node, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedNodeLister in code that requires v31.NodeLister
//         // and then make assertions.
//
//     }
type NodeListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.Node, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.Node, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *NodeListerMock) Get(namespace string, name string) (*v3.Node, error) {
	if mock.GetFunc == nil {
		panic("NodeListerMock.GetFunc: method is nil but NodeLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockNodeListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockNodeListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedNodeLister.GetCalls())
func (mock *NodeListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockNodeListerMockGet.RLock()
	calls = mock.calls.Get
	lockNodeListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *NodeListerMock) List(namespace string, selector labels.Selector) ([]*v3.Node, error) {
	if mock.ListFunc == nil {
		panic("NodeListerMock.ListFunc: method is nil but NodeLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockNodeListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockNodeListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedNodeLister.ListCalls())
func (mock *NodeListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockNodeListerMockList.RLock()
	calls = mock.calls.List
	lockNodeListerMockList.RUnlock()
	return calls
}

var (
	lockNodeControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockNodeControllerMockAddClusterScopedHandler        sync.RWMutex
	lockNodeControllerMockAddFeatureHandler              sync.RWMutex
	lockNodeControllerMockAddHandler                     sync.RWMutex
	lockNodeControllerMockEnqueue                        sync.RWMutex
	lockNodeControllerMockEnqueueAfter                   sync.RWMutex
	lockNodeControllerMockGeneric                        sync.RWMutex
	lockNodeControllerMockInformer                       sync.RWMutex
	lockNodeControllerMockLister                         sync.RWMutex
)

// Ensure, that NodeControllerMock does implement v31.NodeController.
// If this is not the case, regenerate this file with moq.
var _ v31.NodeController = &NodeControllerMock{}

// NodeControllerMock is a mock implementation of v31.NodeController.
//
//     func TestSomethingThatUsesNodeController(t *testing.T) {
//
//         // make and configure a mocked v31.NodeController
//         mockedNodeController := &NodeControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.NodeHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.NodeHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NodeHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.NodeHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.NodeLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedNodeController in code that requires v31.NodeController
//         // and then make assertions.
//
//     }
type NodeControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.NodeHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.NodeHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NodeHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.NodeHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.NodeLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.NodeHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.NodeHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.NodeHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.NodeHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *NodeControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.NodeHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("NodeControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but NodeController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.NodeHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockNodeControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockNodeControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedNodeController.AddClusterScopedFeatureHandlerCalls())
func (mock *NodeControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.NodeHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.NodeHandlerFunc
	}
	lockNodeControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockNodeControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *NodeControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.NodeHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("NodeControllerMock.AddClusterScopedHandlerFunc: method is nil but NodeController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.NodeHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockNodeControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockNodeControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedNodeController.AddClusterScopedHandlerCalls())
func (mock *NodeControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.NodeHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.NodeHandlerFunc
	}
	lockNodeControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockNodeControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *NodeControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NodeHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("NodeControllerMock.AddFeatureHandlerFunc: method is nil but NodeController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NodeHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockNodeControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockNodeControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedNodeController.AddFeatureHandlerCalls())
func (mock *NodeControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.NodeHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NodeHandlerFunc
	}
	lockNodeControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockNodeControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *NodeControllerMock) AddHandler(ctx context.Context, name string, handler v31.NodeHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("NodeControllerMock.AddHandlerFunc: method is nil but NodeController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.NodeHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockNodeControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockNodeControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedNodeController.AddHandlerCalls())
func (mock *NodeControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.NodeHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.NodeHandlerFunc
	}
	lockNodeControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockNodeControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *NodeControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("NodeControllerMock.EnqueueFunc: method is nil but NodeController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockNodeControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockNodeControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedNodeController.EnqueueCalls())
func (mock *NodeControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockNodeControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockNodeControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *NodeControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("NodeControllerMock.EnqueueAfterFunc: method is nil but NodeController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockNodeControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockNodeControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedNodeController.EnqueueAfterCalls())
func (mock *NodeControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockNodeControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockNodeControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *NodeControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("NodeControllerMock.GenericFunc: method is nil but NodeController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockNodeControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockNodeControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedNodeController.GenericCalls())
func (mock *NodeControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockNodeControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockNodeControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *NodeControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("NodeControllerMock.InformerFunc: method is nil but NodeController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockNodeControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockNodeControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedNodeController.InformerCalls())
func (mock *NodeControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockNodeControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockNodeControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *NodeControllerMock) Lister() v31.NodeLister {
	if mock.ListerFunc == nil {
		panic("NodeControllerMock.ListerFunc: method is nil but NodeController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockNodeControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockNodeControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedNodeController.ListerCalls())
func (mock *NodeControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockNodeControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockNodeControllerMockLister.RUnlock()
	return calls
}

var (
	lockNodeInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockNodeInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockNodeInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockNodeInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockNodeInterfaceMockAddFeatureHandler                sync.RWMutex
	lockNodeInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockNodeInterfaceMockAddHandler                       sync.RWMutex
	lockNodeInterfaceMockAddLifecycle                     sync.RWMutex
	lockNodeInterfaceMockController                       sync.RWMutex
	lockNodeInterfaceMockCreate                           sync.RWMutex
	lockNodeInterfaceMockDelete                           sync.RWMutex
	lockNodeInterfaceMockDeleteCollection                 sync.RWMutex
	lockNodeInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockNodeInterfaceMockGet                              sync.RWMutex
	lockNodeInterfaceMockGetNamespaced                    sync.RWMutex
	lockNodeInterfaceMockList                             sync.RWMutex
	lockNodeInterfaceMockListNamespaced                   sync.RWMutex
	lockNodeInterfaceMockObjectClient                     sync.RWMutex
	lockNodeInterfaceMockUpdate                           sync.RWMutex
	lockNodeInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that NodeInterfaceMock does implement v31.NodeInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.NodeInterface = &NodeInterfaceMock{}

// NodeInterfaceMock is a mock implementation of v31.NodeInterface.
//
//     func TestSomethingThatUsesNodeInterface(t *testing.T) {
//
//         // make and configure a mocked v31.NodeInterface
//         mockedNodeInterface := &NodeInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.NodeHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.NodeLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.NodeHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.NodeLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NodeHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.NodeLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.NodeHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.NodeLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.NodeController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.Node) (*v3.Node, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.Node, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.Node, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.NodeList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.NodeList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.Node) (*v3.Node, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedNodeInterface in code that requires v31.NodeInterface
//         // and then make assertions.
//
//     }
type NodeInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.NodeHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.NodeLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.NodeHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.NodeLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NodeHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.NodeLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.NodeHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.NodeLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.NodeController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.Node) (*v3.Node, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.Node, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.Node, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.NodeList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.NodeList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.Node) (*v3.Node, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.NodeHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NodeLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.NodeHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NodeLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.NodeHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NodeLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.NodeHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NodeLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.Node
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.Node
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *NodeInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.NodeHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("NodeInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but NodeInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.NodeHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockNodeInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockNodeInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedNodeInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *NodeInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.NodeHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.NodeHandlerFunc
	}
	lockNodeInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockNodeInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *NodeInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.NodeLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("NodeInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but NodeInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.NodeLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockNodeInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockNodeInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedNodeInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *NodeInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.NodeLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.NodeLifecycle
	}
	lockNodeInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockNodeInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *NodeInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.NodeHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("NodeInterfaceMock.AddClusterScopedHandlerFunc: method is nil but NodeInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.NodeHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockNodeInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockNodeInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedNodeInterface.AddClusterScopedHandlerCalls())
func (mock *NodeInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.NodeHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.NodeHandlerFunc
	}
	lockNodeInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockNodeInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *NodeInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.NodeLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("NodeInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but NodeInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.NodeLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockNodeInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockNodeInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedNodeInterface.AddClusterScopedLifecycleCalls())
func (mock *NodeInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.NodeLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.NodeLifecycle
	}
	lockNodeInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockNodeInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *NodeInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NodeHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("NodeInterfaceMock.AddFeatureHandlerFunc: method is nil but NodeInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NodeHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockNodeInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockNodeInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedNodeInterface.AddFeatureHandlerCalls())
func (mock *NodeInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.NodeHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NodeHandlerFunc
	}
	lockNodeInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockNodeInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *NodeInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.NodeLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("NodeInterfaceMock.AddFeatureLifecycleFunc: method is nil but NodeInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.NodeLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockNodeInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockNodeInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedNodeInterface.AddFeatureLifecycleCalls())
func (mock *NodeInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.NodeLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.NodeLifecycle
	}
	lockNodeInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockNodeInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *NodeInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.NodeHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("NodeInterfaceMock.AddHandlerFunc: method is nil but NodeInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.NodeHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockNodeInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockNodeInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedNodeInterface.AddHandlerCalls())
func (mock *NodeInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.NodeHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.NodeHandlerFunc
	}
	lockNodeInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockNodeInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *NodeInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.NodeLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("NodeInterfaceMock.AddLifecycleFunc: method is nil but NodeInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.NodeLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockNodeInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockNodeInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedNodeInterface.AddLifecycleCalls())
func (mock *NodeInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.NodeLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.NodeLifecycle
	}
	lockNodeInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockNodeInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *NodeInterfaceMock) Controller() v31.NodeController {
	if mock.ControllerFunc == nil {
		panic("NodeInterfaceMock.ControllerFunc: method is nil but NodeInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockNodeInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockNodeInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedNodeInterface.ControllerCalls())
func (mock *NodeInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockNodeInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockNodeInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *NodeInterfaceMock) Create(in1 *v3.Node) (*v3.Node, error) {
	if mock.CreateFunc == nil {
		panic("NodeInterfaceMock.CreateFunc: method is nil but NodeInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.Node
	}{
		In1: in1,
	}
	lockNodeInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockNodeInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedNodeInterface.CreateCalls())
func (mock *NodeInterfaceMock) CreateCalls() []struct {
	In1 *v3.Node
} {
	var calls []struct {
		In1 *v3.Node
	}
	lockNodeInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockNodeInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *NodeInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("NodeInterfaceMock.DeleteFunc: method is nil but NodeInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockNodeInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockNodeInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedNodeInterface.DeleteCalls())
func (mock *NodeInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockNodeInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockNodeInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *NodeInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("NodeInterfaceMock.DeleteCollectionFunc: method is nil but NodeInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockNodeInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockNodeInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedNodeInterface.DeleteCollectionCalls())
func (mock *NodeInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockNodeInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockNodeInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *NodeInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("NodeInterfaceMock.DeleteNamespacedFunc: method is nil but NodeInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockNodeInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockNodeInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedNodeInterface.DeleteNamespacedCalls())
func (mock *NodeInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockNodeInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockNodeInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *NodeInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.Node, error) {
	if mock.GetFunc == nil {
		panic("NodeInterfaceMock.GetFunc: method is nil but NodeInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockNodeInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockNodeInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedNodeInterface.GetCalls())
func (mock *NodeInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockNodeInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockNodeInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *NodeInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.Node, error) {
	if mock.GetNamespacedFunc == nil {
		panic("NodeInterfaceMock.GetNamespacedFunc: method is nil but NodeInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockNodeInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockNodeInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedNodeInterface.GetNamespacedCalls())
func (mock *NodeInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockNodeInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockNodeInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *NodeInterfaceMock) List(opts metav1.ListOptions) (*v3.NodeList, error) {
	if mock.ListFunc == nil {
		panic("NodeInterfaceMock.ListFunc: method is nil but NodeInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockNodeInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockNodeInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedNodeInterface.ListCalls())
func (mock *NodeInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockNodeInterfaceMockList.RLock()
	calls = mock.calls.List
	lockNodeInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *NodeInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.NodeList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("NodeInterfaceMock.ListNamespacedFunc: method is nil but NodeInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockNodeInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockNodeInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedNodeInterface.ListNamespacedCalls())
func (mock *NodeInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockNodeInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockNodeInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *NodeInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("NodeInterfaceMock.ObjectClientFunc: method is nil but NodeInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockNodeInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockNodeInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedNodeInterface.ObjectClientCalls())
func (mock *NodeInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockNodeInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockNodeInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *NodeInterfaceMock) Update(in1 *v3.Node) (*v3.Node, error) {
	if mock.UpdateFunc == nil {
		panic("NodeInterfaceMock.UpdateFunc: method is nil but NodeInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.Node
	}{
		In1: in1,
	}
	lockNodeInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockNodeInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedNodeInterface.UpdateCalls())
func (mock *NodeInterfaceMock) UpdateCalls() []struct {
	In1 *v3.Node
} {
	var calls []struct {
		In1 *v3.Node
	}
	lockNodeInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockNodeInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *NodeInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("NodeInterfaceMock.WatchFunc: method is nil but NodeInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockNodeInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockNodeInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedNodeInterface.WatchCalls())
func (mock *NodeInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockNodeInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockNodeInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockNodesGetterMockNodes sync.RWMutex
)

// Ensure, that NodesGetterMock does implement v31.NodesGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.NodesGetter = &NodesGetterMock{}

// NodesGetterMock is a mock implementation of v31.NodesGetter.
//
//     func TestSomethingThatUsesNodesGetter(t *testing.T) {
//
//         // make and configure a mocked v31.NodesGetter
//         mockedNodesGetter := &NodesGetterMock{
//             NodesFunc: func(namespace string) v31.NodeInterface {
// 	               panic("mock out the Nodes method")
//             },
//         }
//
//         // use mockedNodesGetter in code that requires v31.NodesGetter
//         // and then make assertions.
//
//     }
type NodesGetterMock struct {
	// NodesFunc mocks the Nodes method.
	NodesFunc func(namespace string) v31.NodeInterface

	// calls tracks calls to the methods.
	calls struct {
		// Nodes holds details about calls to the Nodes method.
		Nodes []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// Nodes calls NodesFunc.
func (mock *NodesGetterMock) Nodes(namespace string) v31.NodeInterface {
	if mock.NodesFunc == nil {
		panic("NodesGetterMock.NodesFunc: method is nil but NodesGetter.Nodes was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockNodesGetterMockNodes.Lock()
	mock.calls.Nodes = append(mock.calls.Nodes, callInfo)
	lockNodesGetterMockNodes.Unlock()
	return mock.NodesFunc(namespace)
}

// NodesCalls gets all the calls that were made to Nodes.
// Check the length with:
//     len(mockedNodesGetter.NodesCalls())
func (mock *NodesGetterMock) NodesCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockNodesGetterMockNodes.RLock()
	calls = mock.calls.Nodes
	lockNodesGetterMockNodes.RUnlock()
	return calls
}
