// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockNodeTemplateListerMockGet  sync.RWMutex
	lockNodeTemplateListerMockList sync.RWMutex
)

// Ensure, that NodeTemplateListerMock does implement v31.NodeTemplateLister.
// If this is not the case, regenerate this file with moq.
var _ v31.NodeTemplateLister = &NodeTemplateListerMock{}

// NodeTemplateListerMock is a mock implementation of v31.NodeTemplateLister.
//
//     func TestSomethingThatUsesNodeTemplateLister(t *testing.T) {
//
//         // make and configure a mocked v31.NodeTemplateLister
//         mockedNodeTemplateLister := &NodeTemplateListerMock{
//             GetFunc: func(namespace string, name string) (*v3.NodeTemplate, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.NodeTemplate, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedNodeTemplateLister in code that requires v31.NodeTemplateLister
//         // and then make assertions.
//
//     }
type NodeTemplateListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.NodeTemplate, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.NodeTemplate, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *NodeTemplateListerMock) Get(namespace string, name string) (*v3.NodeTemplate, error) {
	if mock.GetFunc == nil {
		panic("NodeTemplateListerMock.GetFunc: method is nil but NodeTemplateLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockNodeTemplateListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockNodeTemplateListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedNodeTemplateLister.GetCalls())
func (mock *NodeTemplateListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockNodeTemplateListerMockGet.RLock()
	calls = mock.calls.Get
	lockNodeTemplateListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *NodeTemplateListerMock) List(namespace string, selector labels.Selector) ([]*v3.NodeTemplate, error) {
	if mock.ListFunc == nil {
		panic("NodeTemplateListerMock.ListFunc: method is nil but NodeTemplateLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockNodeTemplateListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockNodeTemplateListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedNodeTemplateLister.ListCalls())
func (mock *NodeTemplateListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockNodeTemplateListerMockList.RLock()
	calls = mock.calls.List
	lockNodeTemplateListerMockList.RUnlock()
	return calls
}

var (
	lockNodeTemplateControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockNodeTemplateControllerMockAddClusterScopedHandler        sync.RWMutex
	lockNodeTemplateControllerMockAddFeatureHandler              sync.RWMutex
	lockNodeTemplateControllerMockAddHandler                     sync.RWMutex
	lockNodeTemplateControllerMockEnqueue                        sync.RWMutex
	lockNodeTemplateControllerMockEnqueueAfter                   sync.RWMutex
	lockNodeTemplateControllerMockGeneric                        sync.RWMutex
	lockNodeTemplateControllerMockInformer                       sync.RWMutex
	lockNodeTemplateControllerMockLister                         sync.RWMutex
)

// Ensure, that NodeTemplateControllerMock does implement v31.NodeTemplateController.
// If this is not the case, regenerate this file with moq.
var _ v31.NodeTemplateController = &NodeTemplateControllerMock{}

// NodeTemplateControllerMock is a mock implementation of v31.NodeTemplateController.
//
//     func TestSomethingThatUsesNodeTemplateController(t *testing.T) {
//
//         // make and configure a mocked v31.NodeTemplateController
//         mockedNodeTemplateController := &NodeTemplateControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.NodeTemplateHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.NodeTemplateHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NodeTemplateHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.NodeTemplateHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.NodeTemplateLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedNodeTemplateController in code that requires v31.NodeTemplateController
//         // and then make assertions.
//
//     }
type NodeTemplateControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.NodeTemplateHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.NodeTemplateHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NodeTemplateHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.NodeTemplateHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.NodeTemplateLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.NodeTemplateHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.NodeTemplateHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.NodeTemplateHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.NodeTemplateHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *NodeTemplateControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.NodeTemplateHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("NodeTemplateControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but NodeTemplateController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.NodeTemplateHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockNodeTemplateControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockNodeTemplateControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedNodeTemplateController.AddClusterScopedFeatureHandlerCalls())
func (mock *NodeTemplateControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.NodeTemplateHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.NodeTemplateHandlerFunc
	}
	lockNodeTemplateControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockNodeTemplateControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *NodeTemplateControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.NodeTemplateHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("NodeTemplateControllerMock.AddClusterScopedHandlerFunc: method is nil but NodeTemplateController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.NodeTemplateHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockNodeTemplateControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockNodeTemplateControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedNodeTemplateController.AddClusterScopedHandlerCalls())
func (mock *NodeTemplateControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.NodeTemplateHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.NodeTemplateHandlerFunc
	}
	lockNodeTemplateControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockNodeTemplateControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *NodeTemplateControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NodeTemplateHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("NodeTemplateControllerMock.AddFeatureHandlerFunc: method is nil but NodeTemplateController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NodeTemplateHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockNodeTemplateControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockNodeTemplateControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedNodeTemplateController.AddFeatureHandlerCalls())
func (mock *NodeTemplateControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.NodeTemplateHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NodeTemplateHandlerFunc
	}
	lockNodeTemplateControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockNodeTemplateControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *NodeTemplateControllerMock) AddHandler(ctx context.Context, name string, handler v31.NodeTemplateHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("NodeTemplateControllerMock.AddHandlerFunc: method is nil but NodeTemplateController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.NodeTemplateHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockNodeTemplateControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockNodeTemplateControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedNodeTemplateController.AddHandlerCalls())
func (mock *NodeTemplateControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.NodeTemplateHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.NodeTemplateHandlerFunc
	}
	lockNodeTemplateControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockNodeTemplateControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *NodeTemplateControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("NodeTemplateControllerMock.EnqueueFunc: method is nil but NodeTemplateController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockNodeTemplateControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockNodeTemplateControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedNodeTemplateController.EnqueueCalls())
func (mock *NodeTemplateControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockNodeTemplateControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockNodeTemplateControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *NodeTemplateControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("NodeTemplateControllerMock.EnqueueAfterFunc: method is nil but NodeTemplateController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockNodeTemplateControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockNodeTemplateControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedNodeTemplateController.EnqueueAfterCalls())
func (mock *NodeTemplateControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockNodeTemplateControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockNodeTemplateControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *NodeTemplateControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("NodeTemplateControllerMock.GenericFunc: method is nil but NodeTemplateController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockNodeTemplateControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockNodeTemplateControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedNodeTemplateController.GenericCalls())
func (mock *NodeTemplateControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockNodeTemplateControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockNodeTemplateControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *NodeTemplateControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("NodeTemplateControllerMock.InformerFunc: method is nil but NodeTemplateController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockNodeTemplateControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockNodeTemplateControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedNodeTemplateController.InformerCalls())
func (mock *NodeTemplateControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockNodeTemplateControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockNodeTemplateControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *NodeTemplateControllerMock) Lister() v31.NodeTemplateLister {
	if mock.ListerFunc == nil {
		panic("NodeTemplateControllerMock.ListerFunc: method is nil but NodeTemplateController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockNodeTemplateControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockNodeTemplateControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedNodeTemplateController.ListerCalls())
func (mock *NodeTemplateControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockNodeTemplateControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockNodeTemplateControllerMockLister.RUnlock()
	return calls
}

var (
	lockNodeTemplateInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockNodeTemplateInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockNodeTemplateInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockNodeTemplateInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockNodeTemplateInterfaceMockAddFeatureHandler                sync.RWMutex
	lockNodeTemplateInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockNodeTemplateInterfaceMockAddHandler                       sync.RWMutex
	lockNodeTemplateInterfaceMockAddLifecycle                     sync.RWMutex
	lockNodeTemplateInterfaceMockController                       sync.RWMutex
	lockNodeTemplateInterfaceMockCreate                           sync.RWMutex
	lockNodeTemplateInterfaceMockDelete                           sync.RWMutex
	lockNodeTemplateInterfaceMockDeleteCollection                 sync.RWMutex
	lockNodeTemplateInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockNodeTemplateInterfaceMockGet                              sync.RWMutex
	lockNodeTemplateInterfaceMockGetNamespaced                    sync.RWMutex
	lockNodeTemplateInterfaceMockList                             sync.RWMutex
	lockNodeTemplateInterfaceMockListNamespaced                   sync.RWMutex
	lockNodeTemplateInterfaceMockObjectClient                     sync.RWMutex
	lockNodeTemplateInterfaceMockUpdate                           sync.RWMutex
	lockNodeTemplateInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that NodeTemplateInterfaceMock does implement v31.NodeTemplateInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.NodeTemplateInterface = &NodeTemplateInterfaceMock{}

// NodeTemplateInterfaceMock is a mock implementation of v31.NodeTemplateInterface.
//
//     func TestSomethingThatUsesNodeTemplateInterface(t *testing.T) {
//
//         // make and configure a mocked v31.NodeTemplateInterface
//         mockedNodeTemplateInterface := &NodeTemplateInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.NodeTemplateHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.NodeTemplateLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.NodeTemplateHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.NodeTemplateLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NodeTemplateHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.NodeTemplateLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.NodeTemplateHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.NodeTemplateLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.NodeTemplateController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.NodeTemplate) (*v3.NodeTemplate, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.NodeTemplate, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.NodeTemplate, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.NodeTemplateList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.NodeTemplateList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.NodeTemplate) (*v3.NodeTemplate, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedNodeTemplateInterface in code that requires v31.NodeTemplateInterface
//         // and then make assertions.
//
//     }
type NodeTemplateInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.NodeTemplateHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.NodeTemplateLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.NodeTemplateHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.NodeTemplateLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NodeTemplateHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.NodeTemplateLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.NodeTemplateHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.NodeTemplateLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.NodeTemplateController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.NodeTemplate) (*v3.NodeTemplate, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.NodeTemplate, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.NodeTemplate, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.NodeTemplateList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.NodeTemplateList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.NodeTemplate) (*v3.NodeTemplate, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.NodeTemplateHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NodeTemplateLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.NodeTemplateHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NodeTemplateLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.NodeTemplateHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NodeTemplateLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.NodeTemplateHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NodeTemplateLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.NodeTemplate
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.NodeTemplate
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *NodeTemplateInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.NodeTemplateHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("NodeTemplateInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but NodeTemplateInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.NodeTemplateHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockNodeTemplateInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockNodeTemplateInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedNodeTemplateInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *NodeTemplateInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.NodeTemplateHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.NodeTemplateHandlerFunc
	}
	lockNodeTemplateInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockNodeTemplateInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *NodeTemplateInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.NodeTemplateLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("NodeTemplateInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but NodeTemplateInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.NodeTemplateLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockNodeTemplateInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockNodeTemplateInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedNodeTemplateInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *NodeTemplateInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.NodeTemplateLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.NodeTemplateLifecycle
	}
	lockNodeTemplateInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockNodeTemplateInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *NodeTemplateInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.NodeTemplateHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("NodeTemplateInterfaceMock.AddClusterScopedHandlerFunc: method is nil but NodeTemplateInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.NodeTemplateHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockNodeTemplateInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockNodeTemplateInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedNodeTemplateInterface.AddClusterScopedHandlerCalls())
func (mock *NodeTemplateInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.NodeTemplateHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.NodeTemplateHandlerFunc
	}
	lockNodeTemplateInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockNodeTemplateInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *NodeTemplateInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.NodeTemplateLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("NodeTemplateInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but NodeTemplateInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.NodeTemplateLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockNodeTemplateInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockNodeTemplateInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedNodeTemplateInterface.AddClusterScopedLifecycleCalls())
func (mock *NodeTemplateInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.NodeTemplateLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.NodeTemplateLifecycle
	}
	lockNodeTemplateInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockNodeTemplateInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *NodeTemplateInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NodeTemplateHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("NodeTemplateInterfaceMock.AddFeatureHandlerFunc: method is nil but NodeTemplateInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NodeTemplateHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockNodeTemplateInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockNodeTemplateInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedNodeTemplateInterface.AddFeatureHandlerCalls())
func (mock *NodeTemplateInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.NodeTemplateHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NodeTemplateHandlerFunc
	}
	lockNodeTemplateInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockNodeTemplateInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *NodeTemplateInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.NodeTemplateLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("NodeTemplateInterfaceMock.AddFeatureLifecycleFunc: method is nil but NodeTemplateInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.NodeTemplateLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockNodeTemplateInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockNodeTemplateInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedNodeTemplateInterface.AddFeatureLifecycleCalls())
func (mock *NodeTemplateInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.NodeTemplateLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.NodeTemplateLifecycle
	}
	lockNodeTemplateInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockNodeTemplateInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *NodeTemplateInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.NodeTemplateHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("NodeTemplateInterfaceMock.AddHandlerFunc: method is nil but NodeTemplateInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.NodeTemplateHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockNodeTemplateInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockNodeTemplateInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedNodeTemplateInterface.AddHandlerCalls())
func (mock *NodeTemplateInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.NodeTemplateHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.NodeTemplateHandlerFunc
	}
	lockNodeTemplateInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockNodeTemplateInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *NodeTemplateInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.NodeTemplateLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("NodeTemplateInterfaceMock.AddLifecycleFunc: method is nil but NodeTemplateInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.NodeTemplateLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockNodeTemplateInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockNodeTemplateInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedNodeTemplateInterface.AddLifecycleCalls())
func (mock *NodeTemplateInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.NodeTemplateLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.NodeTemplateLifecycle
	}
	lockNodeTemplateInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockNodeTemplateInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *NodeTemplateInterfaceMock) Controller() v31.NodeTemplateController {
	if mock.ControllerFunc == nil {
		panic("NodeTemplateInterfaceMock.ControllerFunc: method is nil but NodeTemplateInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockNodeTemplateInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockNodeTemplateInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedNodeTemplateInterface.ControllerCalls())
func (mock *NodeTemplateInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockNodeTemplateInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockNodeTemplateInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *NodeTemplateInterfaceMock) Create(in1 *v3.NodeTemplate) (*v3.NodeTemplate, error) {
	if mock.CreateFunc == nil {
		panic("NodeTemplateInterfaceMock.CreateFunc: method is nil but NodeTemplateInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.NodeTemplate
	}{
		In1: in1,
	}
	lockNodeTemplateInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockNodeTemplateInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedNodeTemplateInterface.CreateCalls())
func (mock *NodeTemplateInterfaceMock) CreateCalls() []struct {
	In1 *v3.NodeTemplate
} {
	var calls []struct {
		In1 *v3.NodeTemplate
	}
	lockNodeTemplateInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockNodeTemplateInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *NodeTemplateInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("NodeTemplateInterfaceMock.DeleteFunc: method is nil but NodeTemplateInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockNodeTemplateInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockNodeTemplateInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedNodeTemplateInterface.DeleteCalls())
func (mock *NodeTemplateInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockNodeTemplateInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockNodeTemplateInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *NodeTemplateInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("NodeTemplateInterfaceMock.DeleteCollectionFunc: method is nil but NodeTemplateInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockNodeTemplateInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockNodeTemplateInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedNodeTemplateInterface.DeleteCollectionCalls())
func (mock *NodeTemplateInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockNodeTemplateInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockNodeTemplateInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *NodeTemplateInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("NodeTemplateInterfaceMock.DeleteNamespacedFunc: method is nil but NodeTemplateInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockNodeTemplateInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockNodeTemplateInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedNodeTemplateInterface.DeleteNamespacedCalls())
func (mock *NodeTemplateInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockNodeTemplateInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockNodeTemplateInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *NodeTemplateInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.NodeTemplate, error) {
	if mock.GetFunc == nil {
		panic("NodeTemplateInterfaceMock.GetFunc: method is nil but NodeTemplateInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockNodeTemplateInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockNodeTemplateInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedNodeTemplateInterface.GetCalls())
func (mock *NodeTemplateInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockNodeTemplateInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockNodeTemplateInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *NodeTemplateInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.NodeTemplate, error) {
	if mock.GetNamespacedFunc == nil {
		panic("NodeTemplateInterfaceMock.GetNamespacedFunc: method is nil but NodeTemplateInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockNodeTemplateInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockNodeTemplateInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedNodeTemplateInterface.GetNamespacedCalls())
func (mock *NodeTemplateInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockNodeTemplateInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockNodeTemplateInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *NodeTemplateInterfaceMock) List(opts metav1.ListOptions) (*v3.NodeTemplateList, error) {
	if mock.ListFunc == nil {
		panic("NodeTemplateInterfaceMock.ListFunc: method is nil but NodeTemplateInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockNodeTemplateInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockNodeTemplateInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedNodeTemplateInterface.ListCalls())
func (mock *NodeTemplateInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockNodeTemplateInterfaceMockList.RLock()
	calls = mock.calls.List
	lockNodeTemplateInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *NodeTemplateInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.NodeTemplateList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("NodeTemplateInterfaceMock.ListNamespacedFunc: method is nil but NodeTemplateInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockNodeTemplateInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockNodeTemplateInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedNodeTemplateInterface.ListNamespacedCalls())
func (mock *NodeTemplateInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockNodeTemplateInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockNodeTemplateInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *NodeTemplateInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("NodeTemplateInterfaceMock.ObjectClientFunc: method is nil but NodeTemplateInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockNodeTemplateInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockNodeTemplateInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedNodeTemplateInterface.ObjectClientCalls())
func (mock *NodeTemplateInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockNodeTemplateInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockNodeTemplateInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *NodeTemplateInterfaceMock) Update(in1 *v3.NodeTemplate) (*v3.NodeTemplate, error) {
	if mock.UpdateFunc == nil {
		panic("NodeTemplateInterfaceMock.UpdateFunc: method is nil but NodeTemplateInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.NodeTemplate
	}{
		In1: in1,
	}
	lockNodeTemplateInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockNodeTemplateInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedNodeTemplateInterface.UpdateCalls())
func (mock *NodeTemplateInterfaceMock) UpdateCalls() []struct {
	In1 *v3.NodeTemplate
} {
	var calls []struct {
		In1 *v3.NodeTemplate
	}
	lockNodeTemplateInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockNodeTemplateInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *NodeTemplateInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("NodeTemplateInterfaceMock.WatchFunc: method is nil but NodeTemplateInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockNodeTemplateInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockNodeTemplateInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedNodeTemplateInterface.WatchCalls())
func (mock *NodeTemplateInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockNodeTemplateInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockNodeTemplateInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockNodeTemplatesGetterMockNodeTemplates sync.RWMutex
)

// Ensure, that NodeTemplatesGetterMock does implement v31.NodeTemplatesGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.NodeTemplatesGetter = &NodeTemplatesGetterMock{}

// NodeTemplatesGetterMock is a mock implementation of v31.NodeTemplatesGetter.
//
//     func TestSomethingThatUsesNodeTemplatesGetter(t *testing.T) {
//
//         // make and configure a mocked v31.NodeTemplatesGetter
//         mockedNodeTemplatesGetter := &NodeTemplatesGetterMock{
//             NodeTemplatesFunc: func(namespace string) v31.NodeTemplateInterface {
// 	               panic("mock out the NodeTemplates method")
//             },
//         }
//
//         // use mockedNodeTemplatesGetter in code that requires v31.NodeTemplatesGetter
//         // and then make assertions.
//
//     }
type NodeTemplatesGetterMock struct {
	// NodeTemplatesFunc mocks the NodeTemplates method.
	NodeTemplatesFunc func(namespace string) v31.NodeTemplateInterface

	// calls tracks calls to the methods.
	calls struct {
		// NodeTemplates holds details about calls to the NodeTemplates method.
		NodeTemplates []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// NodeTemplates calls NodeTemplatesFunc.
func (mock *NodeTemplatesGetterMock) NodeTemplates(namespace string) v31.NodeTemplateInterface {
	if mock.NodeTemplatesFunc == nil {
		panic("NodeTemplatesGetterMock.NodeTemplatesFunc: method is nil but NodeTemplatesGetter.NodeTemplates was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockNodeTemplatesGetterMockNodeTemplates.Lock()
	mock.calls.NodeTemplates = append(mock.calls.NodeTemplates, callInfo)
	lockNodeTemplatesGetterMockNodeTemplates.Unlock()
	return mock.NodeTemplatesFunc(namespace)
}

// NodeTemplatesCalls gets all the calls that were made to NodeTemplates.
// Check the length with:
//     len(mockedNodeTemplatesGetter.NodeTemplatesCalls())
func (mock *NodeTemplatesGetterMock) NodeTemplatesCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockNodeTemplatesGetterMockNodeTemplates.RLock()
	calls = mock.calls.NodeTemplates
	lockNodeTemplatesGetterMockNodeTemplates.RUnlock()
	return calls
}
