// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockNotifierListerMockGet  sync.RWMutex
	lockNotifierListerMockList sync.RWMutex
)

// Ensure, that NotifierListerMock does implement v31.NotifierLister.
// If this is not the case, regenerate this file with moq.
var _ v31.NotifierLister = &NotifierListerMock{}

// NotifierListerMock is a mock implementation of v31.NotifierLister.
//
//     func TestSomethingThatUsesNotifierLister(t *testing.T) {
//
//         // make and configure a mocked v31.NotifierLister
//         mockedNotifierLister := &NotifierListerMock{
//             GetFunc: func(namespace string, name string) (*v3.Notifier, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.Notifier, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedNotifierLister in code that requires v31.NotifierLister
//         // and then make assertions.
//
//     }
type NotifierListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.Notifier, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.Notifier, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *NotifierListerMock) Get(namespace string, name string) (*v3.Notifier, error) {
	if mock.GetFunc == nil {
		panic("NotifierListerMock.GetFunc: method is nil but NotifierLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockNotifierListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockNotifierListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedNotifierLister.GetCalls())
func (mock *NotifierListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockNotifierListerMockGet.RLock()
	calls = mock.calls.Get
	lockNotifierListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *NotifierListerMock) List(namespace string, selector labels.Selector) ([]*v3.Notifier, error) {
	if mock.ListFunc == nil {
		panic("NotifierListerMock.ListFunc: method is nil but NotifierLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockNotifierListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockNotifierListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedNotifierLister.ListCalls())
func (mock *NotifierListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockNotifierListerMockList.RLock()
	calls = mock.calls.List
	lockNotifierListerMockList.RUnlock()
	return calls
}

var (
	lockNotifierControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockNotifierControllerMockAddClusterScopedHandler        sync.RWMutex
	lockNotifierControllerMockAddFeatureHandler              sync.RWMutex
	lockNotifierControllerMockAddHandler                     sync.RWMutex
	lockNotifierControllerMockEnqueue                        sync.RWMutex
	lockNotifierControllerMockEnqueueAfter                   sync.RWMutex
	lockNotifierControllerMockGeneric                        sync.RWMutex
	lockNotifierControllerMockInformer                       sync.RWMutex
	lockNotifierControllerMockLister                         sync.RWMutex
)

// Ensure, that NotifierControllerMock does implement v31.NotifierController.
// If this is not the case, regenerate this file with moq.
var _ v31.NotifierController = &NotifierControllerMock{}

// NotifierControllerMock is a mock implementation of v31.NotifierController.
//
//     func TestSomethingThatUsesNotifierController(t *testing.T) {
//
//         // make and configure a mocked v31.NotifierController
//         mockedNotifierController := &NotifierControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.NotifierHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.NotifierHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NotifierHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.NotifierHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.NotifierLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedNotifierController in code that requires v31.NotifierController
//         // and then make assertions.
//
//     }
type NotifierControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.NotifierHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.NotifierHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NotifierHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.NotifierHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.NotifierLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.NotifierHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.NotifierHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.NotifierHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.NotifierHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *NotifierControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.NotifierHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("NotifierControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but NotifierController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.NotifierHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockNotifierControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockNotifierControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedNotifierController.AddClusterScopedFeatureHandlerCalls())
func (mock *NotifierControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.NotifierHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.NotifierHandlerFunc
	}
	lockNotifierControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockNotifierControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *NotifierControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.NotifierHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("NotifierControllerMock.AddClusterScopedHandlerFunc: method is nil but NotifierController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.NotifierHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockNotifierControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockNotifierControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedNotifierController.AddClusterScopedHandlerCalls())
func (mock *NotifierControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.NotifierHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.NotifierHandlerFunc
	}
	lockNotifierControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockNotifierControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *NotifierControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NotifierHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("NotifierControllerMock.AddFeatureHandlerFunc: method is nil but NotifierController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NotifierHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockNotifierControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockNotifierControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedNotifierController.AddFeatureHandlerCalls())
func (mock *NotifierControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.NotifierHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NotifierHandlerFunc
	}
	lockNotifierControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockNotifierControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *NotifierControllerMock) AddHandler(ctx context.Context, name string, handler v31.NotifierHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("NotifierControllerMock.AddHandlerFunc: method is nil but NotifierController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.NotifierHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockNotifierControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockNotifierControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedNotifierController.AddHandlerCalls())
func (mock *NotifierControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.NotifierHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.NotifierHandlerFunc
	}
	lockNotifierControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockNotifierControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *NotifierControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("NotifierControllerMock.EnqueueFunc: method is nil but NotifierController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockNotifierControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockNotifierControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedNotifierController.EnqueueCalls())
func (mock *NotifierControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockNotifierControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockNotifierControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *NotifierControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("NotifierControllerMock.EnqueueAfterFunc: method is nil but NotifierController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockNotifierControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockNotifierControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedNotifierController.EnqueueAfterCalls())
func (mock *NotifierControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockNotifierControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockNotifierControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *NotifierControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("NotifierControllerMock.GenericFunc: method is nil but NotifierController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockNotifierControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockNotifierControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedNotifierController.GenericCalls())
func (mock *NotifierControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockNotifierControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockNotifierControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *NotifierControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("NotifierControllerMock.InformerFunc: method is nil but NotifierController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockNotifierControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockNotifierControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedNotifierController.InformerCalls())
func (mock *NotifierControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockNotifierControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockNotifierControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *NotifierControllerMock) Lister() v31.NotifierLister {
	if mock.ListerFunc == nil {
		panic("NotifierControllerMock.ListerFunc: method is nil but NotifierController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockNotifierControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockNotifierControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedNotifierController.ListerCalls())
func (mock *NotifierControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockNotifierControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockNotifierControllerMockLister.RUnlock()
	return calls
}

var (
	lockNotifierInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockNotifierInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockNotifierInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockNotifierInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockNotifierInterfaceMockAddFeatureHandler                sync.RWMutex
	lockNotifierInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockNotifierInterfaceMockAddHandler                       sync.RWMutex
	lockNotifierInterfaceMockAddLifecycle                     sync.RWMutex
	lockNotifierInterfaceMockController                       sync.RWMutex
	lockNotifierInterfaceMockCreate                           sync.RWMutex
	lockNotifierInterfaceMockDelete                           sync.RWMutex
	lockNotifierInterfaceMockDeleteCollection                 sync.RWMutex
	lockNotifierInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockNotifierInterfaceMockGet                              sync.RWMutex
	lockNotifierInterfaceMockGetNamespaced                    sync.RWMutex
	lockNotifierInterfaceMockList                             sync.RWMutex
	lockNotifierInterfaceMockListNamespaced                   sync.RWMutex
	lockNotifierInterfaceMockObjectClient                     sync.RWMutex
	lockNotifierInterfaceMockUpdate                           sync.RWMutex
	lockNotifierInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that NotifierInterfaceMock does implement v31.NotifierInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.NotifierInterface = &NotifierInterfaceMock{}

// NotifierInterfaceMock is a mock implementation of v31.NotifierInterface.
//
//     func TestSomethingThatUsesNotifierInterface(t *testing.T) {
//
//         // make and configure a mocked v31.NotifierInterface
//         mockedNotifierInterface := &NotifierInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.NotifierHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.NotifierLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.NotifierHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.NotifierLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NotifierHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.NotifierLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.NotifierHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.NotifierLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.NotifierController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.Notifier) (*v3.Notifier, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.Notifier, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.Notifier, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.NotifierList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.NotifierList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.Notifier) (*v3.Notifier, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedNotifierInterface in code that requires v31.NotifierInterface
//         // and then make assertions.
//
//     }
type NotifierInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.NotifierHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.NotifierLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.NotifierHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.NotifierLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NotifierHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.NotifierLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.NotifierHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.NotifierLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.NotifierController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.Notifier) (*v3.Notifier, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.Notifier, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.Notifier, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.NotifierList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.NotifierList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.Notifier) (*v3.Notifier, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.NotifierHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NotifierLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.NotifierHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NotifierLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.NotifierHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NotifierLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.NotifierHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.NotifierLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.Notifier
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.Notifier
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *NotifierInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.NotifierHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("NotifierInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but NotifierInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.NotifierHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockNotifierInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockNotifierInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedNotifierInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *NotifierInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.NotifierHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.NotifierHandlerFunc
	}
	lockNotifierInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockNotifierInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *NotifierInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.NotifierLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("NotifierInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but NotifierInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.NotifierLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockNotifierInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockNotifierInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedNotifierInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *NotifierInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.NotifierLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.NotifierLifecycle
	}
	lockNotifierInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockNotifierInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *NotifierInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.NotifierHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("NotifierInterfaceMock.AddClusterScopedHandlerFunc: method is nil but NotifierInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.NotifierHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockNotifierInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockNotifierInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedNotifierInterface.AddClusterScopedHandlerCalls())
func (mock *NotifierInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.NotifierHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.NotifierHandlerFunc
	}
	lockNotifierInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockNotifierInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *NotifierInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.NotifierLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("NotifierInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but NotifierInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.NotifierLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockNotifierInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockNotifierInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedNotifierInterface.AddClusterScopedLifecycleCalls())
func (mock *NotifierInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.NotifierLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.NotifierLifecycle
	}
	lockNotifierInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockNotifierInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *NotifierInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.NotifierHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("NotifierInterfaceMock.AddFeatureHandlerFunc: method is nil but NotifierInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NotifierHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockNotifierInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockNotifierInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedNotifierInterface.AddFeatureHandlerCalls())
func (mock *NotifierInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.NotifierHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.NotifierHandlerFunc
	}
	lockNotifierInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockNotifierInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *NotifierInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.NotifierLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("NotifierInterfaceMock.AddFeatureLifecycleFunc: method is nil but NotifierInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.NotifierLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockNotifierInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockNotifierInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedNotifierInterface.AddFeatureLifecycleCalls())
func (mock *NotifierInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.NotifierLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.NotifierLifecycle
	}
	lockNotifierInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockNotifierInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *NotifierInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.NotifierHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("NotifierInterfaceMock.AddHandlerFunc: method is nil but NotifierInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.NotifierHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockNotifierInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockNotifierInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedNotifierInterface.AddHandlerCalls())
func (mock *NotifierInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.NotifierHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.NotifierHandlerFunc
	}
	lockNotifierInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockNotifierInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *NotifierInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.NotifierLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("NotifierInterfaceMock.AddLifecycleFunc: method is nil but NotifierInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.NotifierLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockNotifierInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockNotifierInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedNotifierInterface.AddLifecycleCalls())
func (mock *NotifierInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.NotifierLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.NotifierLifecycle
	}
	lockNotifierInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockNotifierInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *NotifierInterfaceMock) Controller() v31.NotifierController {
	if mock.ControllerFunc == nil {
		panic("NotifierInterfaceMock.ControllerFunc: method is nil but NotifierInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockNotifierInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockNotifierInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedNotifierInterface.ControllerCalls())
func (mock *NotifierInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockNotifierInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockNotifierInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *NotifierInterfaceMock) Create(in1 *v3.Notifier) (*v3.Notifier, error) {
	if mock.CreateFunc == nil {
		panic("NotifierInterfaceMock.CreateFunc: method is nil but NotifierInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.Notifier
	}{
		In1: in1,
	}
	lockNotifierInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockNotifierInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedNotifierInterface.CreateCalls())
func (mock *NotifierInterfaceMock) CreateCalls() []struct {
	In1 *v3.Notifier
} {
	var calls []struct {
		In1 *v3.Notifier
	}
	lockNotifierInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockNotifierInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *NotifierInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("NotifierInterfaceMock.DeleteFunc: method is nil but NotifierInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockNotifierInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockNotifierInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedNotifierInterface.DeleteCalls())
func (mock *NotifierInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockNotifierInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockNotifierInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *NotifierInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("NotifierInterfaceMock.DeleteCollectionFunc: method is nil but NotifierInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockNotifierInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockNotifierInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedNotifierInterface.DeleteCollectionCalls())
func (mock *NotifierInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockNotifierInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockNotifierInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *NotifierInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("NotifierInterfaceMock.DeleteNamespacedFunc: method is nil but NotifierInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockNotifierInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockNotifierInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedNotifierInterface.DeleteNamespacedCalls())
func (mock *NotifierInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockNotifierInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockNotifierInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *NotifierInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.Notifier, error) {
	if mock.GetFunc == nil {
		panic("NotifierInterfaceMock.GetFunc: method is nil but NotifierInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockNotifierInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockNotifierInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedNotifierInterface.GetCalls())
func (mock *NotifierInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockNotifierInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockNotifierInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *NotifierInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.Notifier, error) {
	if mock.GetNamespacedFunc == nil {
		panic("NotifierInterfaceMock.GetNamespacedFunc: method is nil but NotifierInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockNotifierInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockNotifierInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedNotifierInterface.GetNamespacedCalls())
func (mock *NotifierInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockNotifierInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockNotifierInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *NotifierInterfaceMock) List(opts metav1.ListOptions) (*v3.NotifierList, error) {
	if mock.ListFunc == nil {
		panic("NotifierInterfaceMock.ListFunc: method is nil but NotifierInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockNotifierInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockNotifierInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedNotifierInterface.ListCalls())
func (mock *NotifierInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockNotifierInterfaceMockList.RLock()
	calls = mock.calls.List
	lockNotifierInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *NotifierInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.NotifierList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("NotifierInterfaceMock.ListNamespacedFunc: method is nil but NotifierInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockNotifierInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockNotifierInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedNotifierInterface.ListNamespacedCalls())
func (mock *NotifierInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockNotifierInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockNotifierInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *NotifierInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("NotifierInterfaceMock.ObjectClientFunc: method is nil but NotifierInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockNotifierInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockNotifierInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedNotifierInterface.ObjectClientCalls())
func (mock *NotifierInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockNotifierInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockNotifierInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *NotifierInterfaceMock) Update(in1 *v3.Notifier) (*v3.Notifier, error) {
	if mock.UpdateFunc == nil {
		panic("NotifierInterfaceMock.UpdateFunc: method is nil but NotifierInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.Notifier
	}{
		In1: in1,
	}
	lockNotifierInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockNotifierInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedNotifierInterface.UpdateCalls())
func (mock *NotifierInterfaceMock) UpdateCalls() []struct {
	In1 *v3.Notifier
} {
	var calls []struct {
		In1 *v3.Notifier
	}
	lockNotifierInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockNotifierInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *NotifierInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("NotifierInterfaceMock.WatchFunc: method is nil but NotifierInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockNotifierInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockNotifierInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedNotifierInterface.WatchCalls())
func (mock *NotifierInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockNotifierInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockNotifierInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockNotifiersGetterMockNotifiers sync.RWMutex
)

// Ensure, that NotifiersGetterMock does implement v31.NotifiersGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.NotifiersGetter = &NotifiersGetterMock{}

// NotifiersGetterMock is a mock implementation of v31.NotifiersGetter.
//
//     func TestSomethingThatUsesNotifiersGetter(t *testing.T) {
//
//         // make and configure a mocked v31.NotifiersGetter
//         mockedNotifiersGetter := &NotifiersGetterMock{
//             NotifiersFunc: func(namespace string) v31.NotifierInterface {
// 	               panic("mock out the Notifiers method")
//             },
//         }
//
//         // use mockedNotifiersGetter in code that requires v31.NotifiersGetter
//         // and then make assertions.
//
//     }
type NotifiersGetterMock struct {
	// NotifiersFunc mocks the Notifiers method.
	NotifiersFunc func(namespace string) v31.NotifierInterface

	// calls tracks calls to the methods.
	calls struct {
		// Notifiers holds details about calls to the Notifiers method.
		Notifiers []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// Notifiers calls NotifiersFunc.
func (mock *NotifiersGetterMock) Notifiers(namespace string) v31.NotifierInterface {
	if mock.NotifiersFunc == nil {
		panic("NotifiersGetterMock.NotifiersFunc: method is nil but NotifiersGetter.Notifiers was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockNotifiersGetterMockNotifiers.Lock()
	mock.calls.Notifiers = append(mock.calls.Notifiers, callInfo)
	lockNotifiersGetterMockNotifiers.Unlock()
	return mock.NotifiersFunc(namespace)
}

// NotifiersCalls gets all the calls that were made to Notifiers.
// Check the length with:
//     len(mockedNotifiersGetter.NotifiersCalls())
func (mock *NotifiersGetterMock) NotifiersCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockNotifiersGetterMockNotifiers.RLock()
	calls = mock.calls.Notifiers
	lockNotifiersGetterMockNotifiers.RUnlock()
	return calls
}
