// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockPrincipalListerMockGet  sync.RWMutex
	lockPrincipalListerMockList sync.RWMutex
)

// Ensure, that PrincipalListerMock does implement v31.PrincipalLister.
// If this is not the case, regenerate this file with moq.
var _ v31.PrincipalLister = &PrincipalListerMock{}

// PrincipalListerMock is a mock implementation of v31.PrincipalLister.
//
//     func TestSomethingThatUsesPrincipalLister(t *testing.T) {
//
//         // make and configure a mocked v31.PrincipalLister
//         mockedPrincipalLister := &PrincipalListerMock{
//             GetFunc: func(namespace string, name string) (*v3.Principal, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.Principal, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedPrincipalLister in code that requires v31.PrincipalLister
//         // and then make assertions.
//
//     }
type PrincipalListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.Principal, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.Principal, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *PrincipalListerMock) Get(namespace string, name string) (*v3.Principal, error) {
	if mock.GetFunc == nil {
		panic("PrincipalListerMock.GetFunc: method is nil but PrincipalLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockPrincipalListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockPrincipalListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedPrincipalLister.GetCalls())
func (mock *PrincipalListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockPrincipalListerMockGet.RLock()
	calls = mock.calls.Get
	lockPrincipalListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *PrincipalListerMock) List(namespace string, selector labels.Selector) ([]*v3.Principal, error) {
	if mock.ListFunc == nil {
		panic("PrincipalListerMock.ListFunc: method is nil but PrincipalLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockPrincipalListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockPrincipalListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedPrincipalLister.ListCalls())
func (mock *PrincipalListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockPrincipalListerMockList.RLock()
	calls = mock.calls.List
	lockPrincipalListerMockList.RUnlock()
	return calls
}

var (
	lockPrincipalControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockPrincipalControllerMockAddClusterScopedHandler        sync.RWMutex
	lockPrincipalControllerMockAddFeatureHandler              sync.RWMutex
	lockPrincipalControllerMockAddHandler                     sync.RWMutex
	lockPrincipalControllerMockEnqueue                        sync.RWMutex
	lockPrincipalControllerMockEnqueueAfter                   sync.RWMutex
	lockPrincipalControllerMockGeneric                        sync.RWMutex
	lockPrincipalControllerMockInformer                       sync.RWMutex
	lockPrincipalControllerMockLister                         sync.RWMutex
)

// Ensure, that PrincipalControllerMock does implement v31.PrincipalController.
// If this is not the case, regenerate this file with moq.
var _ v31.PrincipalController = &PrincipalControllerMock{}

// PrincipalControllerMock is a mock implementation of v31.PrincipalController.
//
//     func TestSomethingThatUsesPrincipalController(t *testing.T) {
//
//         // make and configure a mocked v31.PrincipalController
//         mockedPrincipalController := &PrincipalControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.PrincipalHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.PrincipalHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.PrincipalHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.PrincipalHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.PrincipalLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedPrincipalController in code that requires v31.PrincipalController
//         // and then make assertions.
//
//     }
type PrincipalControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.PrincipalHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.PrincipalHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.PrincipalHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.PrincipalHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.PrincipalLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.PrincipalHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.PrincipalHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.PrincipalHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.PrincipalHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *PrincipalControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.PrincipalHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("PrincipalControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but PrincipalController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.PrincipalHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockPrincipalControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockPrincipalControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedPrincipalController.AddClusterScopedFeatureHandlerCalls())
func (mock *PrincipalControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.PrincipalHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.PrincipalHandlerFunc
	}
	lockPrincipalControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockPrincipalControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *PrincipalControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.PrincipalHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("PrincipalControllerMock.AddClusterScopedHandlerFunc: method is nil but PrincipalController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.PrincipalHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockPrincipalControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockPrincipalControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedPrincipalController.AddClusterScopedHandlerCalls())
func (mock *PrincipalControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.PrincipalHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.PrincipalHandlerFunc
	}
	lockPrincipalControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockPrincipalControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *PrincipalControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.PrincipalHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("PrincipalControllerMock.AddFeatureHandlerFunc: method is nil but PrincipalController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.PrincipalHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockPrincipalControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockPrincipalControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedPrincipalController.AddFeatureHandlerCalls())
func (mock *PrincipalControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.PrincipalHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.PrincipalHandlerFunc
	}
	lockPrincipalControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockPrincipalControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *PrincipalControllerMock) AddHandler(ctx context.Context, name string, handler v31.PrincipalHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("PrincipalControllerMock.AddHandlerFunc: method is nil but PrincipalController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.PrincipalHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockPrincipalControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockPrincipalControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedPrincipalController.AddHandlerCalls())
func (mock *PrincipalControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.PrincipalHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.PrincipalHandlerFunc
	}
	lockPrincipalControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockPrincipalControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *PrincipalControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("PrincipalControllerMock.EnqueueFunc: method is nil but PrincipalController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockPrincipalControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockPrincipalControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedPrincipalController.EnqueueCalls())
func (mock *PrincipalControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockPrincipalControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockPrincipalControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *PrincipalControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("PrincipalControllerMock.EnqueueAfterFunc: method is nil but PrincipalController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockPrincipalControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockPrincipalControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedPrincipalController.EnqueueAfterCalls())
func (mock *PrincipalControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockPrincipalControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockPrincipalControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *PrincipalControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("PrincipalControllerMock.GenericFunc: method is nil but PrincipalController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockPrincipalControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockPrincipalControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedPrincipalController.GenericCalls())
func (mock *PrincipalControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockPrincipalControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockPrincipalControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *PrincipalControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("PrincipalControllerMock.InformerFunc: method is nil but PrincipalController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockPrincipalControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockPrincipalControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedPrincipalController.InformerCalls())
func (mock *PrincipalControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockPrincipalControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockPrincipalControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *PrincipalControllerMock) Lister() v31.PrincipalLister {
	if mock.ListerFunc == nil {
		panic("PrincipalControllerMock.ListerFunc: method is nil but PrincipalController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockPrincipalControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockPrincipalControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedPrincipalController.ListerCalls())
func (mock *PrincipalControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockPrincipalControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockPrincipalControllerMockLister.RUnlock()
	return calls
}

var (
	lockPrincipalInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockPrincipalInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockPrincipalInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockPrincipalInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockPrincipalInterfaceMockAddFeatureHandler                sync.RWMutex
	lockPrincipalInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockPrincipalInterfaceMockAddHandler                       sync.RWMutex
	lockPrincipalInterfaceMockAddLifecycle                     sync.RWMutex
	lockPrincipalInterfaceMockController                       sync.RWMutex
	lockPrincipalInterfaceMockCreate                           sync.RWMutex
	lockPrincipalInterfaceMockDelete                           sync.RWMutex
	lockPrincipalInterfaceMockDeleteCollection                 sync.RWMutex
	lockPrincipalInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockPrincipalInterfaceMockGet                              sync.RWMutex
	lockPrincipalInterfaceMockGetNamespaced                    sync.RWMutex
	lockPrincipalInterfaceMockList                             sync.RWMutex
	lockPrincipalInterfaceMockListNamespaced                   sync.RWMutex
	lockPrincipalInterfaceMockObjectClient                     sync.RWMutex
	lockPrincipalInterfaceMockUpdate                           sync.RWMutex
	lockPrincipalInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that PrincipalInterfaceMock does implement v31.PrincipalInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.PrincipalInterface = &PrincipalInterfaceMock{}

// PrincipalInterfaceMock is a mock implementation of v31.PrincipalInterface.
//
//     func TestSomethingThatUsesPrincipalInterface(t *testing.T) {
//
//         // make and configure a mocked v31.PrincipalInterface
//         mockedPrincipalInterface := &PrincipalInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.PrincipalHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.PrincipalLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.PrincipalHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.PrincipalLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.PrincipalHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.PrincipalLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.PrincipalHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.PrincipalLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.PrincipalController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.Principal) (*v3.Principal, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.Principal, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.Principal, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.PrincipalList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.PrincipalList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.Principal) (*v3.Principal, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedPrincipalInterface in code that requires v31.PrincipalInterface
//         // and then make assertions.
//
//     }
type PrincipalInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.PrincipalHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.PrincipalLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.PrincipalHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.PrincipalLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.PrincipalHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.PrincipalLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.PrincipalHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.PrincipalLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.PrincipalController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.Principal) (*v3.Principal, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.Principal, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.Principal, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.PrincipalList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.PrincipalList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.Principal) (*v3.Principal, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.PrincipalHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.PrincipalLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.PrincipalHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.PrincipalLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.PrincipalHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.PrincipalLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.PrincipalHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.PrincipalLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.Principal
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.Principal
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *PrincipalInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.PrincipalHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("PrincipalInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but PrincipalInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.PrincipalHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockPrincipalInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockPrincipalInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedPrincipalInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *PrincipalInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.PrincipalHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.PrincipalHandlerFunc
	}
	lockPrincipalInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockPrincipalInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *PrincipalInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.PrincipalLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("PrincipalInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but PrincipalInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.PrincipalLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockPrincipalInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockPrincipalInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedPrincipalInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *PrincipalInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.PrincipalLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.PrincipalLifecycle
	}
	lockPrincipalInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockPrincipalInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *PrincipalInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.PrincipalHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("PrincipalInterfaceMock.AddClusterScopedHandlerFunc: method is nil but PrincipalInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.PrincipalHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockPrincipalInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockPrincipalInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedPrincipalInterface.AddClusterScopedHandlerCalls())
func (mock *PrincipalInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.PrincipalHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.PrincipalHandlerFunc
	}
	lockPrincipalInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockPrincipalInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *PrincipalInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.PrincipalLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("PrincipalInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but PrincipalInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.PrincipalLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockPrincipalInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockPrincipalInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedPrincipalInterface.AddClusterScopedLifecycleCalls())
func (mock *PrincipalInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.PrincipalLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.PrincipalLifecycle
	}
	lockPrincipalInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockPrincipalInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *PrincipalInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.PrincipalHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("PrincipalInterfaceMock.AddFeatureHandlerFunc: method is nil but PrincipalInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.PrincipalHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockPrincipalInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockPrincipalInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedPrincipalInterface.AddFeatureHandlerCalls())
func (mock *PrincipalInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.PrincipalHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.PrincipalHandlerFunc
	}
	lockPrincipalInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockPrincipalInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *PrincipalInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.PrincipalLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("PrincipalInterfaceMock.AddFeatureLifecycleFunc: method is nil but PrincipalInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.PrincipalLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockPrincipalInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockPrincipalInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedPrincipalInterface.AddFeatureLifecycleCalls())
func (mock *PrincipalInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.PrincipalLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.PrincipalLifecycle
	}
	lockPrincipalInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockPrincipalInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *PrincipalInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.PrincipalHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("PrincipalInterfaceMock.AddHandlerFunc: method is nil but PrincipalInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.PrincipalHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockPrincipalInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockPrincipalInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedPrincipalInterface.AddHandlerCalls())
func (mock *PrincipalInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.PrincipalHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.PrincipalHandlerFunc
	}
	lockPrincipalInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockPrincipalInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *PrincipalInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.PrincipalLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("PrincipalInterfaceMock.AddLifecycleFunc: method is nil but PrincipalInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.PrincipalLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockPrincipalInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockPrincipalInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedPrincipalInterface.AddLifecycleCalls())
func (mock *PrincipalInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.PrincipalLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.PrincipalLifecycle
	}
	lockPrincipalInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockPrincipalInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *PrincipalInterfaceMock) Controller() v31.PrincipalController {
	if mock.ControllerFunc == nil {
		panic("PrincipalInterfaceMock.ControllerFunc: method is nil but PrincipalInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockPrincipalInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockPrincipalInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedPrincipalInterface.ControllerCalls())
func (mock *PrincipalInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockPrincipalInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockPrincipalInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *PrincipalInterfaceMock) Create(in1 *v3.Principal) (*v3.Principal, error) {
	if mock.CreateFunc == nil {
		panic("PrincipalInterfaceMock.CreateFunc: method is nil but PrincipalInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.Principal
	}{
		In1: in1,
	}
	lockPrincipalInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockPrincipalInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedPrincipalInterface.CreateCalls())
func (mock *PrincipalInterfaceMock) CreateCalls() []struct {
	In1 *v3.Principal
} {
	var calls []struct {
		In1 *v3.Principal
	}
	lockPrincipalInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockPrincipalInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *PrincipalInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("PrincipalInterfaceMock.DeleteFunc: method is nil but PrincipalInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockPrincipalInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockPrincipalInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedPrincipalInterface.DeleteCalls())
func (mock *PrincipalInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockPrincipalInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockPrincipalInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *PrincipalInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("PrincipalInterfaceMock.DeleteCollectionFunc: method is nil but PrincipalInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockPrincipalInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockPrincipalInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedPrincipalInterface.DeleteCollectionCalls())
func (mock *PrincipalInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockPrincipalInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockPrincipalInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *PrincipalInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("PrincipalInterfaceMock.DeleteNamespacedFunc: method is nil but PrincipalInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockPrincipalInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockPrincipalInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedPrincipalInterface.DeleteNamespacedCalls())
func (mock *PrincipalInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockPrincipalInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockPrincipalInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *PrincipalInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.Principal, error) {
	if mock.GetFunc == nil {
		panic("PrincipalInterfaceMock.GetFunc: method is nil but PrincipalInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockPrincipalInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockPrincipalInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedPrincipalInterface.GetCalls())
func (mock *PrincipalInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockPrincipalInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockPrincipalInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *PrincipalInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.Principal, error) {
	if mock.GetNamespacedFunc == nil {
		panic("PrincipalInterfaceMock.GetNamespacedFunc: method is nil but PrincipalInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockPrincipalInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockPrincipalInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedPrincipalInterface.GetNamespacedCalls())
func (mock *PrincipalInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockPrincipalInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockPrincipalInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *PrincipalInterfaceMock) List(opts metav1.ListOptions) (*v3.PrincipalList, error) {
	if mock.ListFunc == nil {
		panic("PrincipalInterfaceMock.ListFunc: method is nil but PrincipalInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockPrincipalInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockPrincipalInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedPrincipalInterface.ListCalls())
func (mock *PrincipalInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockPrincipalInterfaceMockList.RLock()
	calls = mock.calls.List
	lockPrincipalInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *PrincipalInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.PrincipalList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("PrincipalInterfaceMock.ListNamespacedFunc: method is nil but PrincipalInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockPrincipalInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockPrincipalInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedPrincipalInterface.ListNamespacedCalls())
func (mock *PrincipalInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockPrincipalInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockPrincipalInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *PrincipalInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("PrincipalInterfaceMock.ObjectClientFunc: method is nil but PrincipalInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockPrincipalInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockPrincipalInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedPrincipalInterface.ObjectClientCalls())
func (mock *PrincipalInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockPrincipalInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockPrincipalInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *PrincipalInterfaceMock) Update(in1 *v3.Principal) (*v3.Principal, error) {
	if mock.UpdateFunc == nil {
		panic("PrincipalInterfaceMock.UpdateFunc: method is nil but PrincipalInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.Principal
	}{
		In1: in1,
	}
	lockPrincipalInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockPrincipalInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedPrincipalInterface.UpdateCalls())
func (mock *PrincipalInterfaceMock) UpdateCalls() []struct {
	In1 *v3.Principal
} {
	var calls []struct {
		In1 *v3.Principal
	}
	lockPrincipalInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockPrincipalInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *PrincipalInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("PrincipalInterfaceMock.WatchFunc: method is nil but PrincipalInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockPrincipalInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockPrincipalInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedPrincipalInterface.WatchCalls())
func (mock *PrincipalInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockPrincipalInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockPrincipalInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockPrincipalsGetterMockPrincipals sync.RWMutex
)

// Ensure, that PrincipalsGetterMock does implement v31.PrincipalsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.PrincipalsGetter = &PrincipalsGetterMock{}

// PrincipalsGetterMock is a mock implementation of v31.PrincipalsGetter.
//
//     func TestSomethingThatUsesPrincipalsGetter(t *testing.T) {
//
//         // make and configure a mocked v31.PrincipalsGetter
//         mockedPrincipalsGetter := &PrincipalsGetterMock{
//             PrincipalsFunc: func(namespace string) v31.PrincipalInterface {
// 	               panic("mock out the Principals method")
//             },
//         }
//
//         // use mockedPrincipalsGetter in code that requires v31.PrincipalsGetter
//         // and then make assertions.
//
//     }
type PrincipalsGetterMock struct {
	// PrincipalsFunc mocks the Principals method.
	PrincipalsFunc func(namespace string) v31.PrincipalInterface

	// calls tracks calls to the methods.
	calls struct {
		// Principals holds details about calls to the Principals method.
		Principals []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// Principals calls PrincipalsFunc.
func (mock *PrincipalsGetterMock) Principals(namespace string) v31.PrincipalInterface {
	if mock.PrincipalsFunc == nil {
		panic("PrincipalsGetterMock.PrincipalsFunc: method is nil but PrincipalsGetter.Principals was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockPrincipalsGetterMockPrincipals.Lock()
	mock.calls.Principals = append(mock.calls.Principals, callInfo)
	lockPrincipalsGetterMockPrincipals.Unlock()
	return mock.PrincipalsFunc(namespace)
}

// PrincipalsCalls gets all the calls that were made to Principals.
// Check the length with:
//     len(mockedPrincipalsGetter.PrincipalsCalls())
func (mock *PrincipalsGetterMock) PrincipalsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockPrincipalsGetterMockPrincipals.RLock()
	calls = mock.calls.Principals
	lockPrincipalsGetterMockPrincipals.RUnlock()
	return calls
}
