// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockProjectAlertGroupListerMockGet  sync.RWMutex
	lockProjectAlertGroupListerMockList sync.RWMutex
)

// Ensure, that ProjectAlertGroupListerMock does implement v31.ProjectAlertGroupLister.
// If this is not the case, regenerate this file with moq.
var _ v31.ProjectAlertGroupLister = &ProjectAlertGroupListerMock{}

// ProjectAlertGroupListerMock is a mock implementation of v31.ProjectAlertGroupLister.
//
//     func TestSomethingThatUsesProjectAlertGroupLister(t *testing.T) {
//
//         // make and configure a mocked v31.ProjectAlertGroupLister
//         mockedProjectAlertGroupLister := &ProjectAlertGroupListerMock{
//             GetFunc: func(namespace string, name string) (*v3.ProjectAlertGroup, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.ProjectAlertGroup, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedProjectAlertGroupLister in code that requires v31.ProjectAlertGroupLister
//         // and then make assertions.
//
//     }
type ProjectAlertGroupListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.ProjectAlertGroup, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.ProjectAlertGroup, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *ProjectAlertGroupListerMock) Get(namespace string, name string) (*v3.ProjectAlertGroup, error) {
	if mock.GetFunc == nil {
		panic("ProjectAlertGroupListerMock.GetFunc: method is nil but ProjectAlertGroupLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockProjectAlertGroupListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockProjectAlertGroupListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedProjectAlertGroupLister.GetCalls())
func (mock *ProjectAlertGroupListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockProjectAlertGroupListerMockGet.RLock()
	calls = mock.calls.Get
	lockProjectAlertGroupListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ProjectAlertGroupListerMock) List(namespace string, selector labels.Selector) ([]*v3.ProjectAlertGroup, error) {
	if mock.ListFunc == nil {
		panic("ProjectAlertGroupListerMock.ListFunc: method is nil but ProjectAlertGroupLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockProjectAlertGroupListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockProjectAlertGroupListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedProjectAlertGroupLister.ListCalls())
func (mock *ProjectAlertGroupListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockProjectAlertGroupListerMockList.RLock()
	calls = mock.calls.List
	lockProjectAlertGroupListerMockList.RUnlock()
	return calls
}

var (
	lockProjectAlertGroupControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockProjectAlertGroupControllerMockAddClusterScopedHandler        sync.RWMutex
	lockProjectAlertGroupControllerMockAddFeatureHandler              sync.RWMutex
	lockProjectAlertGroupControllerMockAddHandler                     sync.RWMutex
	lockProjectAlertGroupControllerMockEnqueue                        sync.RWMutex
	lockProjectAlertGroupControllerMockEnqueueAfter                   sync.RWMutex
	lockProjectAlertGroupControllerMockGeneric                        sync.RWMutex
	lockProjectAlertGroupControllerMockInformer                       sync.RWMutex
	lockProjectAlertGroupControllerMockLister                         sync.RWMutex
)

// Ensure, that ProjectAlertGroupControllerMock does implement v31.ProjectAlertGroupController.
// If this is not the case, regenerate this file with moq.
var _ v31.ProjectAlertGroupController = &ProjectAlertGroupControllerMock{}

// ProjectAlertGroupControllerMock is a mock implementation of v31.ProjectAlertGroupController.
//
//     func TestSomethingThatUsesProjectAlertGroupController(t *testing.T) {
//
//         // make and configure a mocked v31.ProjectAlertGroupController
//         mockedProjectAlertGroupController := &ProjectAlertGroupControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ProjectAlertGroupHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.ProjectAlertGroupHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ProjectAlertGroupHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.ProjectAlertGroupHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.ProjectAlertGroupLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedProjectAlertGroupController in code that requires v31.ProjectAlertGroupController
//         // and then make assertions.
//
//     }
type ProjectAlertGroupControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ProjectAlertGroupHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.ProjectAlertGroupHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ProjectAlertGroupHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.ProjectAlertGroupHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.ProjectAlertGroupLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.ProjectAlertGroupHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.ProjectAlertGroupHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ProjectAlertGroupHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.ProjectAlertGroupHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ProjectAlertGroupControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ProjectAlertGroupHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ProjectAlertGroupControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but ProjectAlertGroupController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.ProjectAlertGroupHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockProjectAlertGroupControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockProjectAlertGroupControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedProjectAlertGroupController.AddClusterScopedFeatureHandlerCalls())
func (mock *ProjectAlertGroupControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.ProjectAlertGroupHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.ProjectAlertGroupHandlerFunc
	}
	lockProjectAlertGroupControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockProjectAlertGroupControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ProjectAlertGroupControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.ProjectAlertGroupHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ProjectAlertGroupControllerMock.AddClusterScopedHandlerFunc: method is nil but ProjectAlertGroupController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.ProjectAlertGroupHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockProjectAlertGroupControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockProjectAlertGroupControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedProjectAlertGroupController.AddClusterScopedHandlerCalls())
func (mock *ProjectAlertGroupControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.ProjectAlertGroupHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.ProjectAlertGroupHandlerFunc
	}
	lockProjectAlertGroupControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockProjectAlertGroupControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ProjectAlertGroupControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ProjectAlertGroupHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ProjectAlertGroupControllerMock.AddFeatureHandlerFunc: method is nil but ProjectAlertGroupController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ProjectAlertGroupHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockProjectAlertGroupControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockProjectAlertGroupControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedProjectAlertGroupController.AddFeatureHandlerCalls())
func (mock *ProjectAlertGroupControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.ProjectAlertGroupHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ProjectAlertGroupHandlerFunc
	}
	lockProjectAlertGroupControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockProjectAlertGroupControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ProjectAlertGroupControllerMock) AddHandler(ctx context.Context, name string, handler v31.ProjectAlertGroupHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ProjectAlertGroupControllerMock.AddHandlerFunc: method is nil but ProjectAlertGroupController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.ProjectAlertGroupHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockProjectAlertGroupControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockProjectAlertGroupControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedProjectAlertGroupController.AddHandlerCalls())
func (mock *ProjectAlertGroupControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.ProjectAlertGroupHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.ProjectAlertGroupHandlerFunc
	}
	lockProjectAlertGroupControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockProjectAlertGroupControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *ProjectAlertGroupControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("ProjectAlertGroupControllerMock.EnqueueFunc: method is nil but ProjectAlertGroupController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockProjectAlertGroupControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockProjectAlertGroupControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedProjectAlertGroupController.EnqueueCalls())
func (mock *ProjectAlertGroupControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockProjectAlertGroupControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockProjectAlertGroupControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *ProjectAlertGroupControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("ProjectAlertGroupControllerMock.EnqueueAfterFunc: method is nil but ProjectAlertGroupController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockProjectAlertGroupControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockProjectAlertGroupControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedProjectAlertGroupController.EnqueueAfterCalls())
func (mock *ProjectAlertGroupControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockProjectAlertGroupControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockProjectAlertGroupControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *ProjectAlertGroupControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("ProjectAlertGroupControllerMock.GenericFunc: method is nil but ProjectAlertGroupController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockProjectAlertGroupControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockProjectAlertGroupControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedProjectAlertGroupController.GenericCalls())
func (mock *ProjectAlertGroupControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockProjectAlertGroupControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockProjectAlertGroupControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *ProjectAlertGroupControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("ProjectAlertGroupControllerMock.InformerFunc: method is nil but ProjectAlertGroupController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockProjectAlertGroupControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockProjectAlertGroupControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedProjectAlertGroupController.InformerCalls())
func (mock *ProjectAlertGroupControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockProjectAlertGroupControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockProjectAlertGroupControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *ProjectAlertGroupControllerMock) Lister() v31.ProjectAlertGroupLister {
	if mock.ListerFunc == nil {
		panic("ProjectAlertGroupControllerMock.ListerFunc: method is nil but ProjectAlertGroupController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockProjectAlertGroupControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockProjectAlertGroupControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedProjectAlertGroupController.ListerCalls())
func (mock *ProjectAlertGroupControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockProjectAlertGroupControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockProjectAlertGroupControllerMockLister.RUnlock()
	return calls
}

var (
	lockProjectAlertGroupInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockProjectAlertGroupInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockProjectAlertGroupInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockProjectAlertGroupInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockProjectAlertGroupInterfaceMockAddFeatureHandler                sync.RWMutex
	lockProjectAlertGroupInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockProjectAlertGroupInterfaceMockAddHandler                       sync.RWMutex
	lockProjectAlertGroupInterfaceMockAddLifecycle                     sync.RWMutex
	lockProjectAlertGroupInterfaceMockController                       sync.RWMutex
	lockProjectAlertGroupInterfaceMockCreate                           sync.RWMutex
	lockProjectAlertGroupInterfaceMockDelete                           sync.RWMutex
	lockProjectAlertGroupInterfaceMockDeleteCollection                 sync.RWMutex
	lockProjectAlertGroupInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockProjectAlertGroupInterfaceMockGet                              sync.RWMutex
	lockProjectAlertGroupInterfaceMockGetNamespaced                    sync.RWMutex
	lockProjectAlertGroupInterfaceMockList                             sync.RWMutex
	lockProjectAlertGroupInterfaceMockListNamespaced                   sync.RWMutex
	lockProjectAlertGroupInterfaceMockObjectClient                     sync.RWMutex
	lockProjectAlertGroupInterfaceMockUpdate                           sync.RWMutex
	lockProjectAlertGroupInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that ProjectAlertGroupInterfaceMock does implement v31.ProjectAlertGroupInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.ProjectAlertGroupInterface = &ProjectAlertGroupInterfaceMock{}

// ProjectAlertGroupInterfaceMock is a mock implementation of v31.ProjectAlertGroupInterface.
//
//     func TestSomethingThatUsesProjectAlertGroupInterface(t *testing.T) {
//
//         // make and configure a mocked v31.ProjectAlertGroupInterface
//         mockedProjectAlertGroupInterface := &ProjectAlertGroupInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ProjectAlertGroupHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ProjectAlertGroupLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.ProjectAlertGroupHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.ProjectAlertGroupLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ProjectAlertGroupHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.ProjectAlertGroupLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.ProjectAlertGroupHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.ProjectAlertGroupLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.ProjectAlertGroupController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.ProjectAlertGroup) (*v3.ProjectAlertGroup, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.ProjectAlertGroup, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.ProjectAlertGroup, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.ProjectAlertGroupList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.ProjectAlertGroupList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.ProjectAlertGroup) (*v3.ProjectAlertGroup, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedProjectAlertGroupInterface in code that requires v31.ProjectAlertGroupInterface
//         // and then make assertions.
//
//     }
type ProjectAlertGroupInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ProjectAlertGroupHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ProjectAlertGroupLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.ProjectAlertGroupHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.ProjectAlertGroupLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ProjectAlertGroupHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.ProjectAlertGroupLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.ProjectAlertGroupHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.ProjectAlertGroupLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.ProjectAlertGroupController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.ProjectAlertGroup) (*v3.ProjectAlertGroup, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.ProjectAlertGroup, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.ProjectAlertGroup, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.ProjectAlertGroupList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.ProjectAlertGroupList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.ProjectAlertGroup) (*v3.ProjectAlertGroup, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.ProjectAlertGroupHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ProjectAlertGroupLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.ProjectAlertGroupHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ProjectAlertGroupLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ProjectAlertGroupHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ProjectAlertGroupLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ProjectAlertGroupHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ProjectAlertGroupLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.ProjectAlertGroup
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.ProjectAlertGroup
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ProjectAlertGroupInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ProjectAlertGroupHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ProjectAlertGroupInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but ProjectAlertGroupInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.ProjectAlertGroupHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockProjectAlertGroupInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockProjectAlertGroupInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedProjectAlertGroupInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *ProjectAlertGroupInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.ProjectAlertGroupHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.ProjectAlertGroupHandlerFunc
	}
	lockProjectAlertGroupInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockProjectAlertGroupInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *ProjectAlertGroupInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ProjectAlertGroupLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("ProjectAlertGroupInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but ProjectAlertGroupInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.ProjectAlertGroupLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockProjectAlertGroupInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockProjectAlertGroupInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedProjectAlertGroupInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *ProjectAlertGroupInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.ProjectAlertGroupLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.ProjectAlertGroupLifecycle
	}
	lockProjectAlertGroupInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockProjectAlertGroupInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ProjectAlertGroupInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.ProjectAlertGroupHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ProjectAlertGroupInterfaceMock.AddClusterScopedHandlerFunc: method is nil but ProjectAlertGroupInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.ProjectAlertGroupHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockProjectAlertGroupInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockProjectAlertGroupInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedProjectAlertGroupInterface.AddClusterScopedHandlerCalls())
func (mock *ProjectAlertGroupInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.ProjectAlertGroupHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.ProjectAlertGroupHandlerFunc
	}
	lockProjectAlertGroupInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockProjectAlertGroupInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *ProjectAlertGroupInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.ProjectAlertGroupLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("ProjectAlertGroupInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but ProjectAlertGroupInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.ProjectAlertGroupLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockProjectAlertGroupInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockProjectAlertGroupInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedProjectAlertGroupInterface.AddClusterScopedLifecycleCalls())
func (mock *ProjectAlertGroupInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.ProjectAlertGroupLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.ProjectAlertGroupLifecycle
	}
	lockProjectAlertGroupInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockProjectAlertGroupInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ProjectAlertGroupInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ProjectAlertGroupHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ProjectAlertGroupInterfaceMock.AddFeatureHandlerFunc: method is nil but ProjectAlertGroupInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ProjectAlertGroupHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockProjectAlertGroupInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockProjectAlertGroupInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedProjectAlertGroupInterface.AddFeatureHandlerCalls())
func (mock *ProjectAlertGroupInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.ProjectAlertGroupHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ProjectAlertGroupHandlerFunc
	}
	lockProjectAlertGroupInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockProjectAlertGroupInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *ProjectAlertGroupInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.ProjectAlertGroupLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("ProjectAlertGroupInterfaceMock.AddFeatureLifecycleFunc: method is nil but ProjectAlertGroupInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.ProjectAlertGroupLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockProjectAlertGroupInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockProjectAlertGroupInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedProjectAlertGroupInterface.AddFeatureLifecycleCalls())
func (mock *ProjectAlertGroupInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.ProjectAlertGroupLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.ProjectAlertGroupLifecycle
	}
	lockProjectAlertGroupInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockProjectAlertGroupInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ProjectAlertGroupInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.ProjectAlertGroupHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ProjectAlertGroupInterfaceMock.AddHandlerFunc: method is nil but ProjectAlertGroupInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.ProjectAlertGroupHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockProjectAlertGroupInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockProjectAlertGroupInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedProjectAlertGroupInterface.AddHandlerCalls())
func (mock *ProjectAlertGroupInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.ProjectAlertGroupHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.ProjectAlertGroupHandlerFunc
	}
	lockProjectAlertGroupInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockProjectAlertGroupInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *ProjectAlertGroupInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.ProjectAlertGroupLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("ProjectAlertGroupInterfaceMock.AddLifecycleFunc: method is nil but ProjectAlertGroupInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.ProjectAlertGroupLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockProjectAlertGroupInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockProjectAlertGroupInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedProjectAlertGroupInterface.AddLifecycleCalls())
func (mock *ProjectAlertGroupInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.ProjectAlertGroupLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.ProjectAlertGroupLifecycle
	}
	lockProjectAlertGroupInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockProjectAlertGroupInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *ProjectAlertGroupInterfaceMock) Controller() v31.ProjectAlertGroupController {
	if mock.ControllerFunc == nil {
		panic("ProjectAlertGroupInterfaceMock.ControllerFunc: method is nil but ProjectAlertGroupInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockProjectAlertGroupInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockProjectAlertGroupInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedProjectAlertGroupInterface.ControllerCalls())
func (mock *ProjectAlertGroupInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockProjectAlertGroupInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockProjectAlertGroupInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *ProjectAlertGroupInterfaceMock) Create(in1 *v3.ProjectAlertGroup) (*v3.ProjectAlertGroup, error) {
	if mock.CreateFunc == nil {
		panic("ProjectAlertGroupInterfaceMock.CreateFunc: method is nil but ProjectAlertGroupInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.ProjectAlertGroup
	}{
		In1: in1,
	}
	lockProjectAlertGroupInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockProjectAlertGroupInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedProjectAlertGroupInterface.CreateCalls())
func (mock *ProjectAlertGroupInterfaceMock) CreateCalls() []struct {
	In1 *v3.ProjectAlertGroup
} {
	var calls []struct {
		In1 *v3.ProjectAlertGroup
	}
	lockProjectAlertGroupInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockProjectAlertGroupInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *ProjectAlertGroupInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("ProjectAlertGroupInterfaceMock.DeleteFunc: method is nil but ProjectAlertGroupInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockProjectAlertGroupInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockProjectAlertGroupInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedProjectAlertGroupInterface.DeleteCalls())
func (mock *ProjectAlertGroupInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockProjectAlertGroupInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockProjectAlertGroupInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *ProjectAlertGroupInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("ProjectAlertGroupInterfaceMock.DeleteCollectionFunc: method is nil but ProjectAlertGroupInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockProjectAlertGroupInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockProjectAlertGroupInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedProjectAlertGroupInterface.DeleteCollectionCalls())
func (mock *ProjectAlertGroupInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockProjectAlertGroupInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockProjectAlertGroupInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *ProjectAlertGroupInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("ProjectAlertGroupInterfaceMock.DeleteNamespacedFunc: method is nil but ProjectAlertGroupInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockProjectAlertGroupInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockProjectAlertGroupInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedProjectAlertGroupInterface.DeleteNamespacedCalls())
func (mock *ProjectAlertGroupInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockProjectAlertGroupInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockProjectAlertGroupInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *ProjectAlertGroupInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.ProjectAlertGroup, error) {
	if mock.GetFunc == nil {
		panic("ProjectAlertGroupInterfaceMock.GetFunc: method is nil but ProjectAlertGroupInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockProjectAlertGroupInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockProjectAlertGroupInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedProjectAlertGroupInterface.GetCalls())
func (mock *ProjectAlertGroupInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockProjectAlertGroupInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockProjectAlertGroupInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *ProjectAlertGroupInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.ProjectAlertGroup, error) {
	if mock.GetNamespacedFunc == nil {
		panic("ProjectAlertGroupInterfaceMock.GetNamespacedFunc: method is nil but ProjectAlertGroupInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockProjectAlertGroupInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockProjectAlertGroupInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedProjectAlertGroupInterface.GetNamespacedCalls())
func (mock *ProjectAlertGroupInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockProjectAlertGroupInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockProjectAlertGroupInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ProjectAlertGroupInterfaceMock) List(opts metav1.ListOptions) (*v3.ProjectAlertGroupList, error) {
	if mock.ListFunc == nil {
		panic("ProjectAlertGroupInterfaceMock.ListFunc: method is nil but ProjectAlertGroupInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockProjectAlertGroupInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockProjectAlertGroupInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedProjectAlertGroupInterface.ListCalls())
func (mock *ProjectAlertGroupInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockProjectAlertGroupInterfaceMockList.RLock()
	calls = mock.calls.List
	lockProjectAlertGroupInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *ProjectAlertGroupInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.ProjectAlertGroupList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("ProjectAlertGroupInterfaceMock.ListNamespacedFunc: method is nil but ProjectAlertGroupInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockProjectAlertGroupInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockProjectAlertGroupInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedProjectAlertGroupInterface.ListNamespacedCalls())
func (mock *ProjectAlertGroupInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockProjectAlertGroupInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockProjectAlertGroupInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *ProjectAlertGroupInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("ProjectAlertGroupInterfaceMock.ObjectClientFunc: method is nil but ProjectAlertGroupInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockProjectAlertGroupInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockProjectAlertGroupInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedProjectAlertGroupInterface.ObjectClientCalls())
func (mock *ProjectAlertGroupInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockProjectAlertGroupInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockProjectAlertGroupInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *ProjectAlertGroupInterfaceMock) Update(in1 *v3.ProjectAlertGroup) (*v3.ProjectAlertGroup, error) {
	if mock.UpdateFunc == nil {
		panic("ProjectAlertGroupInterfaceMock.UpdateFunc: method is nil but ProjectAlertGroupInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.ProjectAlertGroup
	}{
		In1: in1,
	}
	lockProjectAlertGroupInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockProjectAlertGroupInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedProjectAlertGroupInterface.UpdateCalls())
func (mock *ProjectAlertGroupInterfaceMock) UpdateCalls() []struct {
	In1 *v3.ProjectAlertGroup
} {
	var calls []struct {
		In1 *v3.ProjectAlertGroup
	}
	lockProjectAlertGroupInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockProjectAlertGroupInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *ProjectAlertGroupInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("ProjectAlertGroupInterfaceMock.WatchFunc: method is nil but ProjectAlertGroupInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockProjectAlertGroupInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockProjectAlertGroupInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedProjectAlertGroupInterface.WatchCalls())
func (mock *ProjectAlertGroupInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockProjectAlertGroupInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockProjectAlertGroupInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockProjectAlertGroupsGetterMockProjectAlertGroups sync.RWMutex
)

// Ensure, that ProjectAlertGroupsGetterMock does implement v31.ProjectAlertGroupsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.ProjectAlertGroupsGetter = &ProjectAlertGroupsGetterMock{}

// ProjectAlertGroupsGetterMock is a mock implementation of v31.ProjectAlertGroupsGetter.
//
//     func TestSomethingThatUsesProjectAlertGroupsGetter(t *testing.T) {
//
//         // make and configure a mocked v31.ProjectAlertGroupsGetter
//         mockedProjectAlertGroupsGetter := &ProjectAlertGroupsGetterMock{
//             ProjectAlertGroupsFunc: func(namespace string) v31.ProjectAlertGroupInterface {
// 	               panic("mock out the ProjectAlertGroups method")
//             },
//         }
//
//         // use mockedProjectAlertGroupsGetter in code that requires v31.ProjectAlertGroupsGetter
//         // and then make assertions.
//
//     }
type ProjectAlertGroupsGetterMock struct {
	// ProjectAlertGroupsFunc mocks the ProjectAlertGroups method.
	ProjectAlertGroupsFunc func(namespace string) v31.ProjectAlertGroupInterface

	// calls tracks calls to the methods.
	calls struct {
		// ProjectAlertGroups holds details about calls to the ProjectAlertGroups method.
		ProjectAlertGroups []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// ProjectAlertGroups calls ProjectAlertGroupsFunc.
func (mock *ProjectAlertGroupsGetterMock) ProjectAlertGroups(namespace string) v31.ProjectAlertGroupInterface {
	if mock.ProjectAlertGroupsFunc == nil {
		panic("ProjectAlertGroupsGetterMock.ProjectAlertGroupsFunc: method is nil but ProjectAlertGroupsGetter.ProjectAlertGroups was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockProjectAlertGroupsGetterMockProjectAlertGroups.Lock()
	mock.calls.ProjectAlertGroups = append(mock.calls.ProjectAlertGroups, callInfo)
	lockProjectAlertGroupsGetterMockProjectAlertGroups.Unlock()
	return mock.ProjectAlertGroupsFunc(namespace)
}

// ProjectAlertGroupsCalls gets all the calls that were made to ProjectAlertGroups.
// Check the length with:
//     len(mockedProjectAlertGroupsGetter.ProjectAlertGroupsCalls())
func (mock *ProjectAlertGroupsGetterMock) ProjectAlertGroupsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockProjectAlertGroupsGetterMockProjectAlertGroups.RLock()
	calls = mock.calls.ProjectAlertGroups
	lockProjectAlertGroupsGetterMockProjectAlertGroups.RUnlock()
	return calls
}
