// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockProjectAlertListerMockGet  sync.RWMutex
	lockProjectAlertListerMockList sync.RWMutex
)

// Ensure, that ProjectAlertListerMock does implement v31.ProjectAlertLister.
// If this is not the case, regenerate this file with moq.
var _ v31.ProjectAlertLister = &ProjectAlertListerMock{}

// ProjectAlertListerMock is a mock implementation of v31.ProjectAlertLister.
//
//     func TestSomethingThatUsesProjectAlertLister(t *testing.T) {
//
//         // make and configure a mocked v31.ProjectAlertLister
//         mockedProjectAlertLister := &ProjectAlertListerMock{
//             GetFunc: func(namespace string, name string) (*v3.ProjectAlert, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.ProjectAlert, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedProjectAlertLister in code that requires v31.ProjectAlertLister
//         // and then make assertions.
//
//     }
type ProjectAlertListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.ProjectAlert, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.ProjectAlert, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *ProjectAlertListerMock) Get(namespace string, name string) (*v3.ProjectAlert, error) {
	if mock.GetFunc == nil {
		panic("ProjectAlertListerMock.GetFunc: method is nil but ProjectAlertLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockProjectAlertListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockProjectAlertListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedProjectAlertLister.GetCalls())
func (mock *ProjectAlertListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockProjectAlertListerMockGet.RLock()
	calls = mock.calls.Get
	lockProjectAlertListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ProjectAlertListerMock) List(namespace string, selector labels.Selector) ([]*v3.ProjectAlert, error) {
	if mock.ListFunc == nil {
		panic("ProjectAlertListerMock.ListFunc: method is nil but ProjectAlertLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockProjectAlertListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockProjectAlertListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedProjectAlertLister.ListCalls())
func (mock *ProjectAlertListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockProjectAlertListerMockList.RLock()
	calls = mock.calls.List
	lockProjectAlertListerMockList.RUnlock()
	return calls
}

var (
	lockProjectAlertControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockProjectAlertControllerMockAddClusterScopedHandler        sync.RWMutex
	lockProjectAlertControllerMockAddFeatureHandler              sync.RWMutex
	lockProjectAlertControllerMockAddHandler                     sync.RWMutex
	lockProjectAlertControllerMockEnqueue                        sync.RWMutex
	lockProjectAlertControllerMockEnqueueAfter                   sync.RWMutex
	lockProjectAlertControllerMockGeneric                        sync.RWMutex
	lockProjectAlertControllerMockInformer                       sync.RWMutex
	lockProjectAlertControllerMockLister                         sync.RWMutex
)

// Ensure, that ProjectAlertControllerMock does implement v31.ProjectAlertController.
// If this is not the case, regenerate this file with moq.
var _ v31.ProjectAlertController = &ProjectAlertControllerMock{}

// ProjectAlertControllerMock is a mock implementation of v31.ProjectAlertController.
//
//     func TestSomethingThatUsesProjectAlertController(t *testing.T) {
//
//         // make and configure a mocked v31.ProjectAlertController
//         mockedProjectAlertController := &ProjectAlertControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ProjectAlertHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.ProjectAlertHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ProjectAlertHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.ProjectAlertHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.ProjectAlertLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedProjectAlertController in code that requires v31.ProjectAlertController
//         // and then make assertions.
//
//     }
type ProjectAlertControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ProjectAlertHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.ProjectAlertHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ProjectAlertHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.ProjectAlertHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.ProjectAlertLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.ProjectAlertHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.ProjectAlertHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ProjectAlertHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.ProjectAlertHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ProjectAlertControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ProjectAlertHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ProjectAlertControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but ProjectAlertController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.ProjectAlertHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockProjectAlertControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockProjectAlertControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedProjectAlertController.AddClusterScopedFeatureHandlerCalls())
func (mock *ProjectAlertControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.ProjectAlertHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.ProjectAlertHandlerFunc
	}
	lockProjectAlertControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockProjectAlertControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ProjectAlertControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.ProjectAlertHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ProjectAlertControllerMock.AddClusterScopedHandlerFunc: method is nil but ProjectAlertController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.ProjectAlertHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockProjectAlertControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockProjectAlertControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedProjectAlertController.AddClusterScopedHandlerCalls())
func (mock *ProjectAlertControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.ProjectAlertHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.ProjectAlertHandlerFunc
	}
	lockProjectAlertControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockProjectAlertControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ProjectAlertControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ProjectAlertHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ProjectAlertControllerMock.AddFeatureHandlerFunc: method is nil but ProjectAlertController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ProjectAlertHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockProjectAlertControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockProjectAlertControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedProjectAlertController.AddFeatureHandlerCalls())
func (mock *ProjectAlertControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.ProjectAlertHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ProjectAlertHandlerFunc
	}
	lockProjectAlertControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockProjectAlertControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ProjectAlertControllerMock) AddHandler(ctx context.Context, name string, handler v31.ProjectAlertHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ProjectAlertControllerMock.AddHandlerFunc: method is nil but ProjectAlertController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.ProjectAlertHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockProjectAlertControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockProjectAlertControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedProjectAlertController.AddHandlerCalls())
func (mock *ProjectAlertControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.ProjectAlertHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.ProjectAlertHandlerFunc
	}
	lockProjectAlertControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockProjectAlertControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *ProjectAlertControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("ProjectAlertControllerMock.EnqueueFunc: method is nil but ProjectAlertController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockProjectAlertControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockProjectAlertControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedProjectAlertController.EnqueueCalls())
func (mock *ProjectAlertControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockProjectAlertControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockProjectAlertControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *ProjectAlertControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("ProjectAlertControllerMock.EnqueueAfterFunc: method is nil but ProjectAlertController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockProjectAlertControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockProjectAlertControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedProjectAlertController.EnqueueAfterCalls())
func (mock *ProjectAlertControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockProjectAlertControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockProjectAlertControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *ProjectAlertControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("ProjectAlertControllerMock.GenericFunc: method is nil but ProjectAlertController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockProjectAlertControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockProjectAlertControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedProjectAlertController.GenericCalls())
func (mock *ProjectAlertControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockProjectAlertControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockProjectAlertControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *ProjectAlertControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("ProjectAlertControllerMock.InformerFunc: method is nil but ProjectAlertController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockProjectAlertControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockProjectAlertControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedProjectAlertController.InformerCalls())
func (mock *ProjectAlertControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockProjectAlertControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockProjectAlertControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *ProjectAlertControllerMock) Lister() v31.ProjectAlertLister {
	if mock.ListerFunc == nil {
		panic("ProjectAlertControllerMock.ListerFunc: method is nil but ProjectAlertController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockProjectAlertControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockProjectAlertControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedProjectAlertController.ListerCalls())
func (mock *ProjectAlertControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockProjectAlertControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockProjectAlertControllerMockLister.RUnlock()
	return calls
}

var (
	lockProjectAlertInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockProjectAlertInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockProjectAlertInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockProjectAlertInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockProjectAlertInterfaceMockAddFeatureHandler                sync.RWMutex
	lockProjectAlertInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockProjectAlertInterfaceMockAddHandler                       sync.RWMutex
	lockProjectAlertInterfaceMockAddLifecycle                     sync.RWMutex
	lockProjectAlertInterfaceMockController                       sync.RWMutex
	lockProjectAlertInterfaceMockCreate                           sync.RWMutex
	lockProjectAlertInterfaceMockDelete                           sync.RWMutex
	lockProjectAlertInterfaceMockDeleteCollection                 sync.RWMutex
	lockProjectAlertInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockProjectAlertInterfaceMockGet                              sync.RWMutex
	lockProjectAlertInterfaceMockGetNamespaced                    sync.RWMutex
	lockProjectAlertInterfaceMockList                             sync.RWMutex
	lockProjectAlertInterfaceMockListNamespaced                   sync.RWMutex
	lockProjectAlertInterfaceMockObjectClient                     sync.RWMutex
	lockProjectAlertInterfaceMockUpdate                           sync.RWMutex
	lockProjectAlertInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that ProjectAlertInterfaceMock does implement v31.ProjectAlertInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.ProjectAlertInterface = &ProjectAlertInterfaceMock{}

// ProjectAlertInterfaceMock is a mock implementation of v31.ProjectAlertInterface.
//
//     func TestSomethingThatUsesProjectAlertInterface(t *testing.T) {
//
//         // make and configure a mocked v31.ProjectAlertInterface
//         mockedProjectAlertInterface := &ProjectAlertInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ProjectAlertHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ProjectAlertLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.ProjectAlertHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.ProjectAlertLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ProjectAlertHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.ProjectAlertLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.ProjectAlertHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.ProjectAlertLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.ProjectAlertController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.ProjectAlert) (*v3.ProjectAlert, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.ProjectAlert, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.ProjectAlert, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.ProjectAlertList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.ProjectAlertList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.ProjectAlert) (*v3.ProjectAlert, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedProjectAlertInterface in code that requires v31.ProjectAlertInterface
//         // and then make assertions.
//
//     }
type ProjectAlertInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ProjectAlertHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ProjectAlertLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.ProjectAlertHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.ProjectAlertLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ProjectAlertHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.ProjectAlertLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.ProjectAlertHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.ProjectAlertLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.ProjectAlertController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.ProjectAlert) (*v3.ProjectAlert, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.ProjectAlert, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.ProjectAlert, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.ProjectAlertList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.ProjectAlertList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.ProjectAlert) (*v3.ProjectAlert, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.ProjectAlertHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ProjectAlertLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.ProjectAlertHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ProjectAlertLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ProjectAlertHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ProjectAlertLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ProjectAlertHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ProjectAlertLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.ProjectAlert
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.ProjectAlert
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ProjectAlertInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ProjectAlertHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ProjectAlertInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but ProjectAlertInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.ProjectAlertHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockProjectAlertInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockProjectAlertInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedProjectAlertInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *ProjectAlertInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.ProjectAlertHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.ProjectAlertHandlerFunc
	}
	lockProjectAlertInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockProjectAlertInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *ProjectAlertInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ProjectAlertLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("ProjectAlertInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but ProjectAlertInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.ProjectAlertLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockProjectAlertInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockProjectAlertInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedProjectAlertInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *ProjectAlertInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.ProjectAlertLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.ProjectAlertLifecycle
	}
	lockProjectAlertInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockProjectAlertInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ProjectAlertInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.ProjectAlertHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ProjectAlertInterfaceMock.AddClusterScopedHandlerFunc: method is nil but ProjectAlertInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.ProjectAlertHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockProjectAlertInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockProjectAlertInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedProjectAlertInterface.AddClusterScopedHandlerCalls())
func (mock *ProjectAlertInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.ProjectAlertHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.ProjectAlertHandlerFunc
	}
	lockProjectAlertInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockProjectAlertInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *ProjectAlertInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.ProjectAlertLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("ProjectAlertInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but ProjectAlertInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.ProjectAlertLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockProjectAlertInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockProjectAlertInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedProjectAlertInterface.AddClusterScopedLifecycleCalls())
func (mock *ProjectAlertInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.ProjectAlertLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.ProjectAlertLifecycle
	}
	lockProjectAlertInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockProjectAlertInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ProjectAlertInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ProjectAlertHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ProjectAlertInterfaceMock.AddFeatureHandlerFunc: method is nil but ProjectAlertInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ProjectAlertHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockProjectAlertInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockProjectAlertInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedProjectAlertInterface.AddFeatureHandlerCalls())
func (mock *ProjectAlertInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.ProjectAlertHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ProjectAlertHandlerFunc
	}
	lockProjectAlertInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockProjectAlertInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *ProjectAlertInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.ProjectAlertLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("ProjectAlertInterfaceMock.AddFeatureLifecycleFunc: method is nil but ProjectAlertInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.ProjectAlertLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockProjectAlertInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockProjectAlertInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedProjectAlertInterface.AddFeatureLifecycleCalls())
func (mock *ProjectAlertInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.ProjectAlertLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.ProjectAlertLifecycle
	}
	lockProjectAlertInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockProjectAlertInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ProjectAlertInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.ProjectAlertHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ProjectAlertInterfaceMock.AddHandlerFunc: method is nil but ProjectAlertInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.ProjectAlertHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockProjectAlertInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockProjectAlertInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedProjectAlertInterface.AddHandlerCalls())
func (mock *ProjectAlertInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.ProjectAlertHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.ProjectAlertHandlerFunc
	}
	lockProjectAlertInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockProjectAlertInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *ProjectAlertInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.ProjectAlertLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("ProjectAlertInterfaceMock.AddLifecycleFunc: method is nil but ProjectAlertInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.ProjectAlertLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockProjectAlertInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockProjectAlertInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedProjectAlertInterface.AddLifecycleCalls())
func (mock *ProjectAlertInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.ProjectAlertLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.ProjectAlertLifecycle
	}
	lockProjectAlertInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockProjectAlertInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *ProjectAlertInterfaceMock) Controller() v31.ProjectAlertController {
	if mock.ControllerFunc == nil {
		panic("ProjectAlertInterfaceMock.ControllerFunc: method is nil but ProjectAlertInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockProjectAlertInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockProjectAlertInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedProjectAlertInterface.ControllerCalls())
func (mock *ProjectAlertInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockProjectAlertInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockProjectAlertInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *ProjectAlertInterfaceMock) Create(in1 *v3.ProjectAlert) (*v3.ProjectAlert, error) {
	if mock.CreateFunc == nil {
		panic("ProjectAlertInterfaceMock.CreateFunc: method is nil but ProjectAlertInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.ProjectAlert
	}{
		In1: in1,
	}
	lockProjectAlertInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockProjectAlertInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedProjectAlertInterface.CreateCalls())
func (mock *ProjectAlertInterfaceMock) CreateCalls() []struct {
	In1 *v3.ProjectAlert
} {
	var calls []struct {
		In1 *v3.ProjectAlert
	}
	lockProjectAlertInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockProjectAlertInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *ProjectAlertInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("ProjectAlertInterfaceMock.DeleteFunc: method is nil but ProjectAlertInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockProjectAlertInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockProjectAlertInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedProjectAlertInterface.DeleteCalls())
func (mock *ProjectAlertInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockProjectAlertInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockProjectAlertInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *ProjectAlertInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("ProjectAlertInterfaceMock.DeleteCollectionFunc: method is nil but ProjectAlertInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockProjectAlertInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockProjectAlertInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedProjectAlertInterface.DeleteCollectionCalls())
func (mock *ProjectAlertInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockProjectAlertInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockProjectAlertInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *ProjectAlertInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("ProjectAlertInterfaceMock.DeleteNamespacedFunc: method is nil but ProjectAlertInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockProjectAlertInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockProjectAlertInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedProjectAlertInterface.DeleteNamespacedCalls())
func (mock *ProjectAlertInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockProjectAlertInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockProjectAlertInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *ProjectAlertInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.ProjectAlert, error) {
	if mock.GetFunc == nil {
		panic("ProjectAlertInterfaceMock.GetFunc: method is nil but ProjectAlertInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockProjectAlertInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockProjectAlertInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedProjectAlertInterface.GetCalls())
func (mock *ProjectAlertInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockProjectAlertInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockProjectAlertInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *ProjectAlertInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.ProjectAlert, error) {
	if mock.GetNamespacedFunc == nil {
		panic("ProjectAlertInterfaceMock.GetNamespacedFunc: method is nil but ProjectAlertInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockProjectAlertInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockProjectAlertInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedProjectAlertInterface.GetNamespacedCalls())
func (mock *ProjectAlertInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockProjectAlertInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockProjectAlertInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ProjectAlertInterfaceMock) List(opts metav1.ListOptions) (*v3.ProjectAlertList, error) {
	if mock.ListFunc == nil {
		panic("ProjectAlertInterfaceMock.ListFunc: method is nil but ProjectAlertInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockProjectAlertInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockProjectAlertInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedProjectAlertInterface.ListCalls())
func (mock *ProjectAlertInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockProjectAlertInterfaceMockList.RLock()
	calls = mock.calls.List
	lockProjectAlertInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *ProjectAlertInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.ProjectAlertList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("ProjectAlertInterfaceMock.ListNamespacedFunc: method is nil but ProjectAlertInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockProjectAlertInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockProjectAlertInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedProjectAlertInterface.ListNamespacedCalls())
func (mock *ProjectAlertInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockProjectAlertInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockProjectAlertInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *ProjectAlertInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("ProjectAlertInterfaceMock.ObjectClientFunc: method is nil but ProjectAlertInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockProjectAlertInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockProjectAlertInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedProjectAlertInterface.ObjectClientCalls())
func (mock *ProjectAlertInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockProjectAlertInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockProjectAlertInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *ProjectAlertInterfaceMock) Update(in1 *v3.ProjectAlert) (*v3.ProjectAlert, error) {
	if mock.UpdateFunc == nil {
		panic("ProjectAlertInterfaceMock.UpdateFunc: method is nil but ProjectAlertInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.ProjectAlert
	}{
		In1: in1,
	}
	lockProjectAlertInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockProjectAlertInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedProjectAlertInterface.UpdateCalls())
func (mock *ProjectAlertInterfaceMock) UpdateCalls() []struct {
	In1 *v3.ProjectAlert
} {
	var calls []struct {
		In1 *v3.ProjectAlert
	}
	lockProjectAlertInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockProjectAlertInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *ProjectAlertInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("ProjectAlertInterfaceMock.WatchFunc: method is nil but ProjectAlertInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockProjectAlertInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockProjectAlertInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedProjectAlertInterface.WatchCalls())
func (mock *ProjectAlertInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockProjectAlertInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockProjectAlertInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockProjectAlertsGetterMockProjectAlerts sync.RWMutex
)

// Ensure, that ProjectAlertsGetterMock does implement v31.ProjectAlertsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.ProjectAlertsGetter = &ProjectAlertsGetterMock{}

// ProjectAlertsGetterMock is a mock implementation of v31.ProjectAlertsGetter.
//
//     func TestSomethingThatUsesProjectAlertsGetter(t *testing.T) {
//
//         // make and configure a mocked v31.ProjectAlertsGetter
//         mockedProjectAlertsGetter := &ProjectAlertsGetterMock{
//             ProjectAlertsFunc: func(namespace string) v31.ProjectAlertInterface {
// 	               panic("mock out the ProjectAlerts method")
//             },
//         }
//
//         // use mockedProjectAlertsGetter in code that requires v31.ProjectAlertsGetter
//         // and then make assertions.
//
//     }
type ProjectAlertsGetterMock struct {
	// ProjectAlertsFunc mocks the ProjectAlerts method.
	ProjectAlertsFunc func(namespace string) v31.ProjectAlertInterface

	// calls tracks calls to the methods.
	calls struct {
		// ProjectAlerts holds details about calls to the ProjectAlerts method.
		ProjectAlerts []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// ProjectAlerts calls ProjectAlertsFunc.
func (mock *ProjectAlertsGetterMock) ProjectAlerts(namespace string) v31.ProjectAlertInterface {
	if mock.ProjectAlertsFunc == nil {
		panic("ProjectAlertsGetterMock.ProjectAlertsFunc: method is nil but ProjectAlertsGetter.ProjectAlerts was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockProjectAlertsGetterMockProjectAlerts.Lock()
	mock.calls.ProjectAlerts = append(mock.calls.ProjectAlerts, callInfo)
	lockProjectAlertsGetterMockProjectAlerts.Unlock()
	return mock.ProjectAlertsFunc(namespace)
}

// ProjectAlertsCalls gets all the calls that were made to ProjectAlerts.
// Check the length with:
//     len(mockedProjectAlertsGetter.ProjectAlertsCalls())
func (mock *ProjectAlertsGetterMock) ProjectAlertsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockProjectAlertsGetterMockProjectAlerts.RLock()
	calls = mock.calls.ProjectAlerts
	lockProjectAlertsGetterMockProjectAlerts.RUnlock()
	return calls
}
