// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockProjectAlertRuleListerMockGet  sync.RWMutex
	lockProjectAlertRuleListerMockList sync.RWMutex
)

// Ensure, that ProjectAlertRuleListerMock does implement v31.ProjectAlertRuleLister.
// If this is not the case, regenerate this file with moq.
var _ v31.ProjectAlertRuleLister = &ProjectAlertRuleListerMock{}

// ProjectAlertRuleListerMock is a mock implementation of v31.ProjectAlertRuleLister.
//
//     func TestSomethingThatUsesProjectAlertRuleLister(t *testing.T) {
//
//         // make and configure a mocked v31.ProjectAlertRuleLister
//         mockedProjectAlertRuleLister := &ProjectAlertRuleListerMock{
//             GetFunc: func(namespace string, name string) (*v3.ProjectAlertRule, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.ProjectAlertRule, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedProjectAlertRuleLister in code that requires v31.ProjectAlertRuleLister
//         // and then make assertions.
//
//     }
type ProjectAlertRuleListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.ProjectAlertRule, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.ProjectAlertRule, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *ProjectAlertRuleListerMock) Get(namespace string, name string) (*v3.ProjectAlertRule, error) {
	if mock.GetFunc == nil {
		panic("ProjectAlertRuleListerMock.GetFunc: method is nil but ProjectAlertRuleLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockProjectAlertRuleListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockProjectAlertRuleListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedProjectAlertRuleLister.GetCalls())
func (mock *ProjectAlertRuleListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockProjectAlertRuleListerMockGet.RLock()
	calls = mock.calls.Get
	lockProjectAlertRuleListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ProjectAlertRuleListerMock) List(namespace string, selector labels.Selector) ([]*v3.ProjectAlertRule, error) {
	if mock.ListFunc == nil {
		panic("ProjectAlertRuleListerMock.ListFunc: method is nil but ProjectAlertRuleLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockProjectAlertRuleListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockProjectAlertRuleListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedProjectAlertRuleLister.ListCalls())
func (mock *ProjectAlertRuleListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockProjectAlertRuleListerMockList.RLock()
	calls = mock.calls.List
	lockProjectAlertRuleListerMockList.RUnlock()
	return calls
}

var (
	lockProjectAlertRuleControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockProjectAlertRuleControllerMockAddClusterScopedHandler        sync.RWMutex
	lockProjectAlertRuleControllerMockAddFeatureHandler              sync.RWMutex
	lockProjectAlertRuleControllerMockAddHandler                     sync.RWMutex
	lockProjectAlertRuleControllerMockEnqueue                        sync.RWMutex
	lockProjectAlertRuleControllerMockEnqueueAfter                   sync.RWMutex
	lockProjectAlertRuleControllerMockGeneric                        sync.RWMutex
	lockProjectAlertRuleControllerMockInformer                       sync.RWMutex
	lockProjectAlertRuleControllerMockLister                         sync.RWMutex
)

// Ensure, that ProjectAlertRuleControllerMock does implement v31.ProjectAlertRuleController.
// If this is not the case, regenerate this file with moq.
var _ v31.ProjectAlertRuleController = &ProjectAlertRuleControllerMock{}

// ProjectAlertRuleControllerMock is a mock implementation of v31.ProjectAlertRuleController.
//
//     func TestSomethingThatUsesProjectAlertRuleController(t *testing.T) {
//
//         // make and configure a mocked v31.ProjectAlertRuleController
//         mockedProjectAlertRuleController := &ProjectAlertRuleControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ProjectAlertRuleHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.ProjectAlertRuleHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ProjectAlertRuleHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.ProjectAlertRuleHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.ProjectAlertRuleLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedProjectAlertRuleController in code that requires v31.ProjectAlertRuleController
//         // and then make assertions.
//
//     }
type ProjectAlertRuleControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ProjectAlertRuleHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.ProjectAlertRuleHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ProjectAlertRuleHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.ProjectAlertRuleHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.ProjectAlertRuleLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.ProjectAlertRuleHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.ProjectAlertRuleHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ProjectAlertRuleHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.ProjectAlertRuleHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ProjectAlertRuleControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ProjectAlertRuleHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ProjectAlertRuleControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but ProjectAlertRuleController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.ProjectAlertRuleHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockProjectAlertRuleControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockProjectAlertRuleControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedProjectAlertRuleController.AddClusterScopedFeatureHandlerCalls())
func (mock *ProjectAlertRuleControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.ProjectAlertRuleHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.ProjectAlertRuleHandlerFunc
	}
	lockProjectAlertRuleControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockProjectAlertRuleControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ProjectAlertRuleControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.ProjectAlertRuleHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ProjectAlertRuleControllerMock.AddClusterScopedHandlerFunc: method is nil but ProjectAlertRuleController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.ProjectAlertRuleHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockProjectAlertRuleControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockProjectAlertRuleControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedProjectAlertRuleController.AddClusterScopedHandlerCalls())
func (mock *ProjectAlertRuleControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.ProjectAlertRuleHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.ProjectAlertRuleHandlerFunc
	}
	lockProjectAlertRuleControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockProjectAlertRuleControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ProjectAlertRuleControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ProjectAlertRuleHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ProjectAlertRuleControllerMock.AddFeatureHandlerFunc: method is nil but ProjectAlertRuleController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ProjectAlertRuleHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockProjectAlertRuleControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockProjectAlertRuleControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedProjectAlertRuleController.AddFeatureHandlerCalls())
func (mock *ProjectAlertRuleControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.ProjectAlertRuleHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ProjectAlertRuleHandlerFunc
	}
	lockProjectAlertRuleControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockProjectAlertRuleControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ProjectAlertRuleControllerMock) AddHandler(ctx context.Context, name string, handler v31.ProjectAlertRuleHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ProjectAlertRuleControllerMock.AddHandlerFunc: method is nil but ProjectAlertRuleController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.ProjectAlertRuleHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockProjectAlertRuleControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockProjectAlertRuleControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedProjectAlertRuleController.AddHandlerCalls())
func (mock *ProjectAlertRuleControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.ProjectAlertRuleHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.ProjectAlertRuleHandlerFunc
	}
	lockProjectAlertRuleControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockProjectAlertRuleControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *ProjectAlertRuleControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("ProjectAlertRuleControllerMock.EnqueueFunc: method is nil but ProjectAlertRuleController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockProjectAlertRuleControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockProjectAlertRuleControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedProjectAlertRuleController.EnqueueCalls())
func (mock *ProjectAlertRuleControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockProjectAlertRuleControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockProjectAlertRuleControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *ProjectAlertRuleControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("ProjectAlertRuleControllerMock.EnqueueAfterFunc: method is nil but ProjectAlertRuleController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockProjectAlertRuleControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockProjectAlertRuleControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedProjectAlertRuleController.EnqueueAfterCalls())
func (mock *ProjectAlertRuleControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockProjectAlertRuleControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockProjectAlertRuleControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *ProjectAlertRuleControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("ProjectAlertRuleControllerMock.GenericFunc: method is nil but ProjectAlertRuleController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockProjectAlertRuleControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockProjectAlertRuleControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedProjectAlertRuleController.GenericCalls())
func (mock *ProjectAlertRuleControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockProjectAlertRuleControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockProjectAlertRuleControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *ProjectAlertRuleControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("ProjectAlertRuleControllerMock.InformerFunc: method is nil but ProjectAlertRuleController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockProjectAlertRuleControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockProjectAlertRuleControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedProjectAlertRuleController.InformerCalls())
func (mock *ProjectAlertRuleControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockProjectAlertRuleControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockProjectAlertRuleControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *ProjectAlertRuleControllerMock) Lister() v31.ProjectAlertRuleLister {
	if mock.ListerFunc == nil {
		panic("ProjectAlertRuleControllerMock.ListerFunc: method is nil but ProjectAlertRuleController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockProjectAlertRuleControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockProjectAlertRuleControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedProjectAlertRuleController.ListerCalls())
func (mock *ProjectAlertRuleControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockProjectAlertRuleControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockProjectAlertRuleControllerMockLister.RUnlock()
	return calls
}

var (
	lockProjectAlertRuleInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockProjectAlertRuleInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockProjectAlertRuleInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockProjectAlertRuleInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockProjectAlertRuleInterfaceMockAddFeatureHandler                sync.RWMutex
	lockProjectAlertRuleInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockProjectAlertRuleInterfaceMockAddHandler                       sync.RWMutex
	lockProjectAlertRuleInterfaceMockAddLifecycle                     sync.RWMutex
	lockProjectAlertRuleInterfaceMockController                       sync.RWMutex
	lockProjectAlertRuleInterfaceMockCreate                           sync.RWMutex
	lockProjectAlertRuleInterfaceMockDelete                           sync.RWMutex
	lockProjectAlertRuleInterfaceMockDeleteCollection                 sync.RWMutex
	lockProjectAlertRuleInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockProjectAlertRuleInterfaceMockGet                              sync.RWMutex
	lockProjectAlertRuleInterfaceMockGetNamespaced                    sync.RWMutex
	lockProjectAlertRuleInterfaceMockList                             sync.RWMutex
	lockProjectAlertRuleInterfaceMockListNamespaced                   sync.RWMutex
	lockProjectAlertRuleInterfaceMockObjectClient                     sync.RWMutex
	lockProjectAlertRuleInterfaceMockUpdate                           sync.RWMutex
	lockProjectAlertRuleInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that ProjectAlertRuleInterfaceMock does implement v31.ProjectAlertRuleInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.ProjectAlertRuleInterface = &ProjectAlertRuleInterfaceMock{}

// ProjectAlertRuleInterfaceMock is a mock implementation of v31.ProjectAlertRuleInterface.
//
//     func TestSomethingThatUsesProjectAlertRuleInterface(t *testing.T) {
//
//         // make and configure a mocked v31.ProjectAlertRuleInterface
//         mockedProjectAlertRuleInterface := &ProjectAlertRuleInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ProjectAlertRuleHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ProjectAlertRuleLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.ProjectAlertRuleHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.ProjectAlertRuleLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ProjectAlertRuleHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.ProjectAlertRuleLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.ProjectAlertRuleHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.ProjectAlertRuleLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.ProjectAlertRuleController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.ProjectAlertRule) (*v3.ProjectAlertRule, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.ProjectAlertRule, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.ProjectAlertRule, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.ProjectAlertRuleList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.ProjectAlertRuleList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.ProjectAlertRule) (*v3.ProjectAlertRule, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedProjectAlertRuleInterface in code that requires v31.ProjectAlertRuleInterface
//         // and then make assertions.
//
//     }
type ProjectAlertRuleInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ProjectAlertRuleHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ProjectAlertRuleLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.ProjectAlertRuleHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.ProjectAlertRuleLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ProjectAlertRuleHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.ProjectAlertRuleLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.ProjectAlertRuleHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.ProjectAlertRuleLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.ProjectAlertRuleController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.ProjectAlertRule) (*v3.ProjectAlertRule, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.ProjectAlertRule, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.ProjectAlertRule, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.ProjectAlertRuleList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.ProjectAlertRuleList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.ProjectAlertRule) (*v3.ProjectAlertRule, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.ProjectAlertRuleHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ProjectAlertRuleLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.ProjectAlertRuleHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ProjectAlertRuleLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ProjectAlertRuleHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ProjectAlertRuleLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ProjectAlertRuleHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ProjectAlertRuleLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.ProjectAlertRule
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.ProjectAlertRule
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ProjectAlertRuleInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ProjectAlertRuleHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ProjectAlertRuleInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but ProjectAlertRuleInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.ProjectAlertRuleHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockProjectAlertRuleInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockProjectAlertRuleInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedProjectAlertRuleInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *ProjectAlertRuleInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.ProjectAlertRuleHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.ProjectAlertRuleHandlerFunc
	}
	lockProjectAlertRuleInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockProjectAlertRuleInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *ProjectAlertRuleInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ProjectAlertRuleLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("ProjectAlertRuleInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but ProjectAlertRuleInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.ProjectAlertRuleLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockProjectAlertRuleInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockProjectAlertRuleInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedProjectAlertRuleInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *ProjectAlertRuleInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.ProjectAlertRuleLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.ProjectAlertRuleLifecycle
	}
	lockProjectAlertRuleInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockProjectAlertRuleInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ProjectAlertRuleInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.ProjectAlertRuleHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ProjectAlertRuleInterfaceMock.AddClusterScopedHandlerFunc: method is nil but ProjectAlertRuleInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.ProjectAlertRuleHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockProjectAlertRuleInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockProjectAlertRuleInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedProjectAlertRuleInterface.AddClusterScopedHandlerCalls())
func (mock *ProjectAlertRuleInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.ProjectAlertRuleHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.ProjectAlertRuleHandlerFunc
	}
	lockProjectAlertRuleInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockProjectAlertRuleInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *ProjectAlertRuleInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.ProjectAlertRuleLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("ProjectAlertRuleInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but ProjectAlertRuleInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.ProjectAlertRuleLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockProjectAlertRuleInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockProjectAlertRuleInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedProjectAlertRuleInterface.AddClusterScopedLifecycleCalls())
func (mock *ProjectAlertRuleInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.ProjectAlertRuleLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.ProjectAlertRuleLifecycle
	}
	lockProjectAlertRuleInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockProjectAlertRuleInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ProjectAlertRuleInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ProjectAlertRuleHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ProjectAlertRuleInterfaceMock.AddFeatureHandlerFunc: method is nil but ProjectAlertRuleInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ProjectAlertRuleHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockProjectAlertRuleInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockProjectAlertRuleInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedProjectAlertRuleInterface.AddFeatureHandlerCalls())
func (mock *ProjectAlertRuleInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.ProjectAlertRuleHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ProjectAlertRuleHandlerFunc
	}
	lockProjectAlertRuleInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockProjectAlertRuleInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *ProjectAlertRuleInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.ProjectAlertRuleLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("ProjectAlertRuleInterfaceMock.AddFeatureLifecycleFunc: method is nil but ProjectAlertRuleInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.ProjectAlertRuleLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockProjectAlertRuleInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockProjectAlertRuleInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedProjectAlertRuleInterface.AddFeatureLifecycleCalls())
func (mock *ProjectAlertRuleInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.ProjectAlertRuleLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.ProjectAlertRuleLifecycle
	}
	lockProjectAlertRuleInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockProjectAlertRuleInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ProjectAlertRuleInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.ProjectAlertRuleHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ProjectAlertRuleInterfaceMock.AddHandlerFunc: method is nil but ProjectAlertRuleInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.ProjectAlertRuleHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockProjectAlertRuleInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockProjectAlertRuleInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedProjectAlertRuleInterface.AddHandlerCalls())
func (mock *ProjectAlertRuleInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.ProjectAlertRuleHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.ProjectAlertRuleHandlerFunc
	}
	lockProjectAlertRuleInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockProjectAlertRuleInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *ProjectAlertRuleInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.ProjectAlertRuleLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("ProjectAlertRuleInterfaceMock.AddLifecycleFunc: method is nil but ProjectAlertRuleInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.ProjectAlertRuleLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockProjectAlertRuleInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockProjectAlertRuleInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedProjectAlertRuleInterface.AddLifecycleCalls())
func (mock *ProjectAlertRuleInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.ProjectAlertRuleLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.ProjectAlertRuleLifecycle
	}
	lockProjectAlertRuleInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockProjectAlertRuleInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *ProjectAlertRuleInterfaceMock) Controller() v31.ProjectAlertRuleController {
	if mock.ControllerFunc == nil {
		panic("ProjectAlertRuleInterfaceMock.ControllerFunc: method is nil but ProjectAlertRuleInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockProjectAlertRuleInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockProjectAlertRuleInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedProjectAlertRuleInterface.ControllerCalls())
func (mock *ProjectAlertRuleInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockProjectAlertRuleInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockProjectAlertRuleInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *ProjectAlertRuleInterfaceMock) Create(in1 *v3.ProjectAlertRule) (*v3.ProjectAlertRule, error) {
	if mock.CreateFunc == nil {
		panic("ProjectAlertRuleInterfaceMock.CreateFunc: method is nil but ProjectAlertRuleInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.ProjectAlertRule
	}{
		In1: in1,
	}
	lockProjectAlertRuleInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockProjectAlertRuleInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedProjectAlertRuleInterface.CreateCalls())
func (mock *ProjectAlertRuleInterfaceMock) CreateCalls() []struct {
	In1 *v3.ProjectAlertRule
} {
	var calls []struct {
		In1 *v3.ProjectAlertRule
	}
	lockProjectAlertRuleInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockProjectAlertRuleInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *ProjectAlertRuleInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("ProjectAlertRuleInterfaceMock.DeleteFunc: method is nil but ProjectAlertRuleInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockProjectAlertRuleInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockProjectAlertRuleInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedProjectAlertRuleInterface.DeleteCalls())
func (mock *ProjectAlertRuleInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockProjectAlertRuleInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockProjectAlertRuleInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *ProjectAlertRuleInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("ProjectAlertRuleInterfaceMock.DeleteCollectionFunc: method is nil but ProjectAlertRuleInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockProjectAlertRuleInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockProjectAlertRuleInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedProjectAlertRuleInterface.DeleteCollectionCalls())
func (mock *ProjectAlertRuleInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockProjectAlertRuleInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockProjectAlertRuleInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *ProjectAlertRuleInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("ProjectAlertRuleInterfaceMock.DeleteNamespacedFunc: method is nil but ProjectAlertRuleInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockProjectAlertRuleInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockProjectAlertRuleInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedProjectAlertRuleInterface.DeleteNamespacedCalls())
func (mock *ProjectAlertRuleInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockProjectAlertRuleInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockProjectAlertRuleInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *ProjectAlertRuleInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.ProjectAlertRule, error) {
	if mock.GetFunc == nil {
		panic("ProjectAlertRuleInterfaceMock.GetFunc: method is nil but ProjectAlertRuleInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockProjectAlertRuleInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockProjectAlertRuleInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedProjectAlertRuleInterface.GetCalls())
func (mock *ProjectAlertRuleInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockProjectAlertRuleInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockProjectAlertRuleInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *ProjectAlertRuleInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.ProjectAlertRule, error) {
	if mock.GetNamespacedFunc == nil {
		panic("ProjectAlertRuleInterfaceMock.GetNamespacedFunc: method is nil but ProjectAlertRuleInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockProjectAlertRuleInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockProjectAlertRuleInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedProjectAlertRuleInterface.GetNamespacedCalls())
func (mock *ProjectAlertRuleInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockProjectAlertRuleInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockProjectAlertRuleInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ProjectAlertRuleInterfaceMock) List(opts metav1.ListOptions) (*v3.ProjectAlertRuleList, error) {
	if mock.ListFunc == nil {
		panic("ProjectAlertRuleInterfaceMock.ListFunc: method is nil but ProjectAlertRuleInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockProjectAlertRuleInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockProjectAlertRuleInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedProjectAlertRuleInterface.ListCalls())
func (mock *ProjectAlertRuleInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockProjectAlertRuleInterfaceMockList.RLock()
	calls = mock.calls.List
	lockProjectAlertRuleInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *ProjectAlertRuleInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.ProjectAlertRuleList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("ProjectAlertRuleInterfaceMock.ListNamespacedFunc: method is nil but ProjectAlertRuleInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockProjectAlertRuleInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockProjectAlertRuleInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedProjectAlertRuleInterface.ListNamespacedCalls())
func (mock *ProjectAlertRuleInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockProjectAlertRuleInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockProjectAlertRuleInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *ProjectAlertRuleInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("ProjectAlertRuleInterfaceMock.ObjectClientFunc: method is nil but ProjectAlertRuleInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockProjectAlertRuleInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockProjectAlertRuleInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedProjectAlertRuleInterface.ObjectClientCalls())
func (mock *ProjectAlertRuleInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockProjectAlertRuleInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockProjectAlertRuleInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *ProjectAlertRuleInterfaceMock) Update(in1 *v3.ProjectAlertRule) (*v3.ProjectAlertRule, error) {
	if mock.UpdateFunc == nil {
		panic("ProjectAlertRuleInterfaceMock.UpdateFunc: method is nil but ProjectAlertRuleInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.ProjectAlertRule
	}{
		In1: in1,
	}
	lockProjectAlertRuleInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockProjectAlertRuleInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedProjectAlertRuleInterface.UpdateCalls())
func (mock *ProjectAlertRuleInterfaceMock) UpdateCalls() []struct {
	In1 *v3.ProjectAlertRule
} {
	var calls []struct {
		In1 *v3.ProjectAlertRule
	}
	lockProjectAlertRuleInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockProjectAlertRuleInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *ProjectAlertRuleInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("ProjectAlertRuleInterfaceMock.WatchFunc: method is nil but ProjectAlertRuleInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockProjectAlertRuleInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockProjectAlertRuleInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedProjectAlertRuleInterface.WatchCalls())
func (mock *ProjectAlertRuleInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockProjectAlertRuleInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockProjectAlertRuleInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockProjectAlertRulesGetterMockProjectAlertRules sync.RWMutex
)

// Ensure, that ProjectAlertRulesGetterMock does implement v31.ProjectAlertRulesGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.ProjectAlertRulesGetter = &ProjectAlertRulesGetterMock{}

// ProjectAlertRulesGetterMock is a mock implementation of v31.ProjectAlertRulesGetter.
//
//     func TestSomethingThatUsesProjectAlertRulesGetter(t *testing.T) {
//
//         // make and configure a mocked v31.ProjectAlertRulesGetter
//         mockedProjectAlertRulesGetter := &ProjectAlertRulesGetterMock{
//             ProjectAlertRulesFunc: func(namespace string) v31.ProjectAlertRuleInterface {
// 	               panic("mock out the ProjectAlertRules method")
//             },
//         }
//
//         // use mockedProjectAlertRulesGetter in code that requires v31.ProjectAlertRulesGetter
//         // and then make assertions.
//
//     }
type ProjectAlertRulesGetterMock struct {
	// ProjectAlertRulesFunc mocks the ProjectAlertRules method.
	ProjectAlertRulesFunc func(namespace string) v31.ProjectAlertRuleInterface

	// calls tracks calls to the methods.
	calls struct {
		// ProjectAlertRules holds details about calls to the ProjectAlertRules method.
		ProjectAlertRules []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// ProjectAlertRules calls ProjectAlertRulesFunc.
func (mock *ProjectAlertRulesGetterMock) ProjectAlertRules(namespace string) v31.ProjectAlertRuleInterface {
	if mock.ProjectAlertRulesFunc == nil {
		panic("ProjectAlertRulesGetterMock.ProjectAlertRulesFunc: method is nil but ProjectAlertRulesGetter.ProjectAlertRules was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockProjectAlertRulesGetterMockProjectAlertRules.Lock()
	mock.calls.ProjectAlertRules = append(mock.calls.ProjectAlertRules, callInfo)
	lockProjectAlertRulesGetterMockProjectAlertRules.Unlock()
	return mock.ProjectAlertRulesFunc(namespace)
}

// ProjectAlertRulesCalls gets all the calls that were made to ProjectAlertRules.
// Check the length with:
//     len(mockedProjectAlertRulesGetter.ProjectAlertRulesCalls())
func (mock *ProjectAlertRulesGetterMock) ProjectAlertRulesCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockProjectAlertRulesGetterMockProjectAlertRules.RLock()
	calls = mock.calls.ProjectAlertRules
	lockProjectAlertRulesGetterMockProjectAlertRules.RUnlock()
	return calls
}
