// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockProjectCatalogListerMockGet  sync.RWMutex
	lockProjectCatalogListerMockList sync.RWMutex
)

// Ensure, that ProjectCatalogListerMock does implement v31.ProjectCatalogLister.
// If this is not the case, regenerate this file with moq.
var _ v31.ProjectCatalogLister = &ProjectCatalogListerMock{}

// ProjectCatalogListerMock is a mock implementation of v31.ProjectCatalogLister.
//
//     func TestSomethingThatUsesProjectCatalogLister(t *testing.T) {
//
//         // make and configure a mocked v31.ProjectCatalogLister
//         mockedProjectCatalogLister := &ProjectCatalogListerMock{
//             GetFunc: func(namespace string, name string) (*v3.ProjectCatalog, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.ProjectCatalog, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedProjectCatalogLister in code that requires v31.ProjectCatalogLister
//         // and then make assertions.
//
//     }
type ProjectCatalogListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.ProjectCatalog, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.ProjectCatalog, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *ProjectCatalogListerMock) Get(namespace string, name string) (*v3.ProjectCatalog, error) {
	if mock.GetFunc == nil {
		panic("ProjectCatalogListerMock.GetFunc: method is nil but ProjectCatalogLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockProjectCatalogListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockProjectCatalogListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedProjectCatalogLister.GetCalls())
func (mock *ProjectCatalogListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockProjectCatalogListerMockGet.RLock()
	calls = mock.calls.Get
	lockProjectCatalogListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ProjectCatalogListerMock) List(namespace string, selector labels.Selector) ([]*v3.ProjectCatalog, error) {
	if mock.ListFunc == nil {
		panic("ProjectCatalogListerMock.ListFunc: method is nil but ProjectCatalogLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockProjectCatalogListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockProjectCatalogListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedProjectCatalogLister.ListCalls())
func (mock *ProjectCatalogListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockProjectCatalogListerMockList.RLock()
	calls = mock.calls.List
	lockProjectCatalogListerMockList.RUnlock()
	return calls
}

var (
	lockProjectCatalogControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockProjectCatalogControllerMockAddClusterScopedHandler        sync.RWMutex
	lockProjectCatalogControllerMockAddFeatureHandler              sync.RWMutex
	lockProjectCatalogControllerMockAddHandler                     sync.RWMutex
	lockProjectCatalogControllerMockEnqueue                        sync.RWMutex
	lockProjectCatalogControllerMockEnqueueAfter                   sync.RWMutex
	lockProjectCatalogControllerMockGeneric                        sync.RWMutex
	lockProjectCatalogControllerMockInformer                       sync.RWMutex
	lockProjectCatalogControllerMockLister                         sync.RWMutex
)

// Ensure, that ProjectCatalogControllerMock does implement v31.ProjectCatalogController.
// If this is not the case, regenerate this file with moq.
var _ v31.ProjectCatalogController = &ProjectCatalogControllerMock{}

// ProjectCatalogControllerMock is a mock implementation of v31.ProjectCatalogController.
//
//     func TestSomethingThatUsesProjectCatalogController(t *testing.T) {
//
//         // make and configure a mocked v31.ProjectCatalogController
//         mockedProjectCatalogController := &ProjectCatalogControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ProjectCatalogHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.ProjectCatalogHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ProjectCatalogHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.ProjectCatalogHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.ProjectCatalogLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedProjectCatalogController in code that requires v31.ProjectCatalogController
//         // and then make assertions.
//
//     }
type ProjectCatalogControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ProjectCatalogHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.ProjectCatalogHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ProjectCatalogHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.ProjectCatalogHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.ProjectCatalogLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.ProjectCatalogHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.ProjectCatalogHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ProjectCatalogHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.ProjectCatalogHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ProjectCatalogControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ProjectCatalogHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ProjectCatalogControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but ProjectCatalogController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.ProjectCatalogHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockProjectCatalogControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockProjectCatalogControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedProjectCatalogController.AddClusterScopedFeatureHandlerCalls())
func (mock *ProjectCatalogControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.ProjectCatalogHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.ProjectCatalogHandlerFunc
	}
	lockProjectCatalogControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockProjectCatalogControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ProjectCatalogControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.ProjectCatalogHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ProjectCatalogControllerMock.AddClusterScopedHandlerFunc: method is nil but ProjectCatalogController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.ProjectCatalogHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockProjectCatalogControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockProjectCatalogControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedProjectCatalogController.AddClusterScopedHandlerCalls())
func (mock *ProjectCatalogControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.ProjectCatalogHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.ProjectCatalogHandlerFunc
	}
	lockProjectCatalogControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockProjectCatalogControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ProjectCatalogControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ProjectCatalogHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ProjectCatalogControllerMock.AddFeatureHandlerFunc: method is nil but ProjectCatalogController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ProjectCatalogHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockProjectCatalogControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockProjectCatalogControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedProjectCatalogController.AddFeatureHandlerCalls())
func (mock *ProjectCatalogControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.ProjectCatalogHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ProjectCatalogHandlerFunc
	}
	lockProjectCatalogControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockProjectCatalogControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ProjectCatalogControllerMock) AddHandler(ctx context.Context, name string, handler v31.ProjectCatalogHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ProjectCatalogControllerMock.AddHandlerFunc: method is nil but ProjectCatalogController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.ProjectCatalogHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockProjectCatalogControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockProjectCatalogControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedProjectCatalogController.AddHandlerCalls())
func (mock *ProjectCatalogControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.ProjectCatalogHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.ProjectCatalogHandlerFunc
	}
	lockProjectCatalogControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockProjectCatalogControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *ProjectCatalogControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("ProjectCatalogControllerMock.EnqueueFunc: method is nil but ProjectCatalogController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockProjectCatalogControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockProjectCatalogControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedProjectCatalogController.EnqueueCalls())
func (mock *ProjectCatalogControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockProjectCatalogControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockProjectCatalogControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *ProjectCatalogControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("ProjectCatalogControllerMock.EnqueueAfterFunc: method is nil but ProjectCatalogController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockProjectCatalogControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockProjectCatalogControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedProjectCatalogController.EnqueueAfterCalls())
func (mock *ProjectCatalogControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockProjectCatalogControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockProjectCatalogControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *ProjectCatalogControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("ProjectCatalogControllerMock.GenericFunc: method is nil but ProjectCatalogController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockProjectCatalogControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockProjectCatalogControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedProjectCatalogController.GenericCalls())
func (mock *ProjectCatalogControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockProjectCatalogControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockProjectCatalogControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *ProjectCatalogControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("ProjectCatalogControllerMock.InformerFunc: method is nil but ProjectCatalogController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockProjectCatalogControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockProjectCatalogControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedProjectCatalogController.InformerCalls())
func (mock *ProjectCatalogControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockProjectCatalogControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockProjectCatalogControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *ProjectCatalogControllerMock) Lister() v31.ProjectCatalogLister {
	if mock.ListerFunc == nil {
		panic("ProjectCatalogControllerMock.ListerFunc: method is nil but ProjectCatalogController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockProjectCatalogControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockProjectCatalogControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedProjectCatalogController.ListerCalls())
func (mock *ProjectCatalogControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockProjectCatalogControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockProjectCatalogControllerMockLister.RUnlock()
	return calls
}

var (
	lockProjectCatalogInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockProjectCatalogInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockProjectCatalogInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockProjectCatalogInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockProjectCatalogInterfaceMockAddFeatureHandler                sync.RWMutex
	lockProjectCatalogInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockProjectCatalogInterfaceMockAddHandler                       sync.RWMutex
	lockProjectCatalogInterfaceMockAddLifecycle                     sync.RWMutex
	lockProjectCatalogInterfaceMockController                       sync.RWMutex
	lockProjectCatalogInterfaceMockCreate                           sync.RWMutex
	lockProjectCatalogInterfaceMockDelete                           sync.RWMutex
	lockProjectCatalogInterfaceMockDeleteCollection                 sync.RWMutex
	lockProjectCatalogInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockProjectCatalogInterfaceMockGet                              sync.RWMutex
	lockProjectCatalogInterfaceMockGetNamespaced                    sync.RWMutex
	lockProjectCatalogInterfaceMockList                             sync.RWMutex
	lockProjectCatalogInterfaceMockListNamespaced                   sync.RWMutex
	lockProjectCatalogInterfaceMockObjectClient                     sync.RWMutex
	lockProjectCatalogInterfaceMockUpdate                           sync.RWMutex
	lockProjectCatalogInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that ProjectCatalogInterfaceMock does implement v31.ProjectCatalogInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.ProjectCatalogInterface = &ProjectCatalogInterfaceMock{}

// ProjectCatalogInterfaceMock is a mock implementation of v31.ProjectCatalogInterface.
//
//     func TestSomethingThatUsesProjectCatalogInterface(t *testing.T) {
//
//         // make and configure a mocked v31.ProjectCatalogInterface
//         mockedProjectCatalogInterface := &ProjectCatalogInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ProjectCatalogHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ProjectCatalogLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.ProjectCatalogHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.ProjectCatalogLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ProjectCatalogHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.ProjectCatalogLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.ProjectCatalogHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.ProjectCatalogLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.ProjectCatalogController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.ProjectCatalog) (*v3.ProjectCatalog, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.ProjectCatalog, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.ProjectCatalog, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.ProjectCatalogList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.ProjectCatalogList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.ProjectCatalog) (*v3.ProjectCatalog, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedProjectCatalogInterface in code that requires v31.ProjectCatalogInterface
//         // and then make assertions.
//
//     }
type ProjectCatalogInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ProjectCatalogHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ProjectCatalogLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.ProjectCatalogHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.ProjectCatalogLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ProjectCatalogHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.ProjectCatalogLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.ProjectCatalogHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.ProjectCatalogLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.ProjectCatalogController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.ProjectCatalog) (*v3.ProjectCatalog, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.ProjectCatalog, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.ProjectCatalog, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.ProjectCatalogList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.ProjectCatalogList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.ProjectCatalog) (*v3.ProjectCatalog, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.ProjectCatalogHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ProjectCatalogLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.ProjectCatalogHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ProjectCatalogLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ProjectCatalogHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ProjectCatalogLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ProjectCatalogHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ProjectCatalogLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.ProjectCatalog
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.ProjectCatalog
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ProjectCatalogInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ProjectCatalogHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ProjectCatalogInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but ProjectCatalogInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.ProjectCatalogHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockProjectCatalogInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockProjectCatalogInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedProjectCatalogInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *ProjectCatalogInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.ProjectCatalogHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.ProjectCatalogHandlerFunc
	}
	lockProjectCatalogInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockProjectCatalogInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *ProjectCatalogInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ProjectCatalogLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("ProjectCatalogInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but ProjectCatalogInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.ProjectCatalogLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockProjectCatalogInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockProjectCatalogInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedProjectCatalogInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *ProjectCatalogInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.ProjectCatalogLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.ProjectCatalogLifecycle
	}
	lockProjectCatalogInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockProjectCatalogInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ProjectCatalogInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.ProjectCatalogHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ProjectCatalogInterfaceMock.AddClusterScopedHandlerFunc: method is nil but ProjectCatalogInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.ProjectCatalogHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockProjectCatalogInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockProjectCatalogInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedProjectCatalogInterface.AddClusterScopedHandlerCalls())
func (mock *ProjectCatalogInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.ProjectCatalogHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.ProjectCatalogHandlerFunc
	}
	lockProjectCatalogInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockProjectCatalogInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *ProjectCatalogInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.ProjectCatalogLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("ProjectCatalogInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but ProjectCatalogInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.ProjectCatalogLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockProjectCatalogInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockProjectCatalogInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedProjectCatalogInterface.AddClusterScopedLifecycleCalls())
func (mock *ProjectCatalogInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.ProjectCatalogLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.ProjectCatalogLifecycle
	}
	lockProjectCatalogInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockProjectCatalogInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ProjectCatalogInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ProjectCatalogHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ProjectCatalogInterfaceMock.AddFeatureHandlerFunc: method is nil but ProjectCatalogInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ProjectCatalogHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockProjectCatalogInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockProjectCatalogInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedProjectCatalogInterface.AddFeatureHandlerCalls())
func (mock *ProjectCatalogInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.ProjectCatalogHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ProjectCatalogHandlerFunc
	}
	lockProjectCatalogInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockProjectCatalogInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *ProjectCatalogInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.ProjectCatalogLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("ProjectCatalogInterfaceMock.AddFeatureLifecycleFunc: method is nil but ProjectCatalogInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.ProjectCatalogLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockProjectCatalogInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockProjectCatalogInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedProjectCatalogInterface.AddFeatureLifecycleCalls())
func (mock *ProjectCatalogInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.ProjectCatalogLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.ProjectCatalogLifecycle
	}
	lockProjectCatalogInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockProjectCatalogInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ProjectCatalogInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.ProjectCatalogHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ProjectCatalogInterfaceMock.AddHandlerFunc: method is nil but ProjectCatalogInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.ProjectCatalogHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockProjectCatalogInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockProjectCatalogInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedProjectCatalogInterface.AddHandlerCalls())
func (mock *ProjectCatalogInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.ProjectCatalogHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.ProjectCatalogHandlerFunc
	}
	lockProjectCatalogInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockProjectCatalogInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *ProjectCatalogInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.ProjectCatalogLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("ProjectCatalogInterfaceMock.AddLifecycleFunc: method is nil but ProjectCatalogInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.ProjectCatalogLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockProjectCatalogInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockProjectCatalogInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedProjectCatalogInterface.AddLifecycleCalls())
func (mock *ProjectCatalogInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.ProjectCatalogLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.ProjectCatalogLifecycle
	}
	lockProjectCatalogInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockProjectCatalogInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *ProjectCatalogInterfaceMock) Controller() v31.ProjectCatalogController {
	if mock.ControllerFunc == nil {
		panic("ProjectCatalogInterfaceMock.ControllerFunc: method is nil but ProjectCatalogInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockProjectCatalogInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockProjectCatalogInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedProjectCatalogInterface.ControllerCalls())
func (mock *ProjectCatalogInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockProjectCatalogInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockProjectCatalogInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *ProjectCatalogInterfaceMock) Create(in1 *v3.ProjectCatalog) (*v3.ProjectCatalog, error) {
	if mock.CreateFunc == nil {
		panic("ProjectCatalogInterfaceMock.CreateFunc: method is nil but ProjectCatalogInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.ProjectCatalog
	}{
		In1: in1,
	}
	lockProjectCatalogInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockProjectCatalogInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedProjectCatalogInterface.CreateCalls())
func (mock *ProjectCatalogInterfaceMock) CreateCalls() []struct {
	In1 *v3.ProjectCatalog
} {
	var calls []struct {
		In1 *v3.ProjectCatalog
	}
	lockProjectCatalogInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockProjectCatalogInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *ProjectCatalogInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("ProjectCatalogInterfaceMock.DeleteFunc: method is nil but ProjectCatalogInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockProjectCatalogInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockProjectCatalogInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedProjectCatalogInterface.DeleteCalls())
func (mock *ProjectCatalogInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockProjectCatalogInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockProjectCatalogInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *ProjectCatalogInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("ProjectCatalogInterfaceMock.DeleteCollectionFunc: method is nil but ProjectCatalogInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockProjectCatalogInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockProjectCatalogInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedProjectCatalogInterface.DeleteCollectionCalls())
func (mock *ProjectCatalogInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockProjectCatalogInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockProjectCatalogInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *ProjectCatalogInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("ProjectCatalogInterfaceMock.DeleteNamespacedFunc: method is nil but ProjectCatalogInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockProjectCatalogInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockProjectCatalogInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedProjectCatalogInterface.DeleteNamespacedCalls())
func (mock *ProjectCatalogInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockProjectCatalogInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockProjectCatalogInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *ProjectCatalogInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.ProjectCatalog, error) {
	if mock.GetFunc == nil {
		panic("ProjectCatalogInterfaceMock.GetFunc: method is nil but ProjectCatalogInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockProjectCatalogInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockProjectCatalogInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedProjectCatalogInterface.GetCalls())
func (mock *ProjectCatalogInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockProjectCatalogInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockProjectCatalogInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *ProjectCatalogInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.ProjectCatalog, error) {
	if mock.GetNamespacedFunc == nil {
		panic("ProjectCatalogInterfaceMock.GetNamespacedFunc: method is nil but ProjectCatalogInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockProjectCatalogInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockProjectCatalogInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedProjectCatalogInterface.GetNamespacedCalls())
func (mock *ProjectCatalogInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockProjectCatalogInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockProjectCatalogInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ProjectCatalogInterfaceMock) List(opts metav1.ListOptions) (*v3.ProjectCatalogList, error) {
	if mock.ListFunc == nil {
		panic("ProjectCatalogInterfaceMock.ListFunc: method is nil but ProjectCatalogInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockProjectCatalogInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockProjectCatalogInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedProjectCatalogInterface.ListCalls())
func (mock *ProjectCatalogInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockProjectCatalogInterfaceMockList.RLock()
	calls = mock.calls.List
	lockProjectCatalogInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *ProjectCatalogInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.ProjectCatalogList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("ProjectCatalogInterfaceMock.ListNamespacedFunc: method is nil but ProjectCatalogInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockProjectCatalogInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockProjectCatalogInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedProjectCatalogInterface.ListNamespacedCalls())
func (mock *ProjectCatalogInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockProjectCatalogInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockProjectCatalogInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *ProjectCatalogInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("ProjectCatalogInterfaceMock.ObjectClientFunc: method is nil but ProjectCatalogInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockProjectCatalogInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockProjectCatalogInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedProjectCatalogInterface.ObjectClientCalls())
func (mock *ProjectCatalogInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockProjectCatalogInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockProjectCatalogInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *ProjectCatalogInterfaceMock) Update(in1 *v3.ProjectCatalog) (*v3.ProjectCatalog, error) {
	if mock.UpdateFunc == nil {
		panic("ProjectCatalogInterfaceMock.UpdateFunc: method is nil but ProjectCatalogInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.ProjectCatalog
	}{
		In1: in1,
	}
	lockProjectCatalogInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockProjectCatalogInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedProjectCatalogInterface.UpdateCalls())
func (mock *ProjectCatalogInterfaceMock) UpdateCalls() []struct {
	In1 *v3.ProjectCatalog
} {
	var calls []struct {
		In1 *v3.ProjectCatalog
	}
	lockProjectCatalogInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockProjectCatalogInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *ProjectCatalogInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("ProjectCatalogInterfaceMock.WatchFunc: method is nil but ProjectCatalogInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockProjectCatalogInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockProjectCatalogInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedProjectCatalogInterface.WatchCalls())
func (mock *ProjectCatalogInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockProjectCatalogInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockProjectCatalogInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockProjectCatalogsGetterMockProjectCatalogs sync.RWMutex
)

// Ensure, that ProjectCatalogsGetterMock does implement v31.ProjectCatalogsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.ProjectCatalogsGetter = &ProjectCatalogsGetterMock{}

// ProjectCatalogsGetterMock is a mock implementation of v31.ProjectCatalogsGetter.
//
//     func TestSomethingThatUsesProjectCatalogsGetter(t *testing.T) {
//
//         // make and configure a mocked v31.ProjectCatalogsGetter
//         mockedProjectCatalogsGetter := &ProjectCatalogsGetterMock{
//             ProjectCatalogsFunc: func(namespace string) v31.ProjectCatalogInterface {
// 	               panic("mock out the ProjectCatalogs method")
//             },
//         }
//
//         // use mockedProjectCatalogsGetter in code that requires v31.ProjectCatalogsGetter
//         // and then make assertions.
//
//     }
type ProjectCatalogsGetterMock struct {
	// ProjectCatalogsFunc mocks the ProjectCatalogs method.
	ProjectCatalogsFunc func(namespace string) v31.ProjectCatalogInterface

	// calls tracks calls to the methods.
	calls struct {
		// ProjectCatalogs holds details about calls to the ProjectCatalogs method.
		ProjectCatalogs []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// ProjectCatalogs calls ProjectCatalogsFunc.
func (mock *ProjectCatalogsGetterMock) ProjectCatalogs(namespace string) v31.ProjectCatalogInterface {
	if mock.ProjectCatalogsFunc == nil {
		panic("ProjectCatalogsGetterMock.ProjectCatalogsFunc: method is nil but ProjectCatalogsGetter.ProjectCatalogs was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockProjectCatalogsGetterMockProjectCatalogs.Lock()
	mock.calls.ProjectCatalogs = append(mock.calls.ProjectCatalogs, callInfo)
	lockProjectCatalogsGetterMockProjectCatalogs.Unlock()
	return mock.ProjectCatalogsFunc(namespace)
}

// ProjectCatalogsCalls gets all the calls that were made to ProjectCatalogs.
// Check the length with:
//     len(mockedProjectCatalogsGetter.ProjectCatalogsCalls())
func (mock *ProjectCatalogsGetterMock) ProjectCatalogsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockProjectCatalogsGetterMockProjectCatalogs.RLock()
	calls = mock.calls.ProjectCatalogs
	lockProjectCatalogsGetterMockProjectCatalogs.RUnlock()
	return calls
}
