// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockProjectLoggingListerMockGet  sync.RWMutex
	lockProjectLoggingListerMockList sync.RWMutex
)

// Ensure, that ProjectLoggingListerMock does implement v31.ProjectLoggingLister.
// If this is not the case, regenerate this file with moq.
var _ v31.ProjectLoggingLister = &ProjectLoggingListerMock{}

// ProjectLoggingListerMock is a mock implementation of v31.ProjectLoggingLister.
//
//     func TestSomethingThatUsesProjectLoggingLister(t *testing.T) {
//
//         // make and configure a mocked v31.ProjectLoggingLister
//         mockedProjectLoggingLister := &ProjectLoggingListerMock{
//             GetFunc: func(namespace string, name string) (*v3.ProjectLogging, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.ProjectLogging, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedProjectLoggingLister in code that requires v31.ProjectLoggingLister
//         // and then make assertions.
//
//     }
type ProjectLoggingListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.ProjectLogging, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.ProjectLogging, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *ProjectLoggingListerMock) Get(namespace string, name string) (*v3.ProjectLogging, error) {
	if mock.GetFunc == nil {
		panic("ProjectLoggingListerMock.GetFunc: method is nil but ProjectLoggingLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockProjectLoggingListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockProjectLoggingListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedProjectLoggingLister.GetCalls())
func (mock *ProjectLoggingListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockProjectLoggingListerMockGet.RLock()
	calls = mock.calls.Get
	lockProjectLoggingListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ProjectLoggingListerMock) List(namespace string, selector labels.Selector) ([]*v3.ProjectLogging, error) {
	if mock.ListFunc == nil {
		panic("ProjectLoggingListerMock.ListFunc: method is nil but ProjectLoggingLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockProjectLoggingListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockProjectLoggingListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedProjectLoggingLister.ListCalls())
func (mock *ProjectLoggingListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockProjectLoggingListerMockList.RLock()
	calls = mock.calls.List
	lockProjectLoggingListerMockList.RUnlock()
	return calls
}

var (
	lockProjectLoggingControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockProjectLoggingControllerMockAddClusterScopedHandler        sync.RWMutex
	lockProjectLoggingControllerMockAddFeatureHandler              sync.RWMutex
	lockProjectLoggingControllerMockAddHandler                     sync.RWMutex
	lockProjectLoggingControllerMockEnqueue                        sync.RWMutex
	lockProjectLoggingControllerMockEnqueueAfter                   sync.RWMutex
	lockProjectLoggingControllerMockGeneric                        sync.RWMutex
	lockProjectLoggingControllerMockInformer                       sync.RWMutex
	lockProjectLoggingControllerMockLister                         sync.RWMutex
)

// Ensure, that ProjectLoggingControllerMock does implement v31.ProjectLoggingController.
// If this is not the case, regenerate this file with moq.
var _ v31.ProjectLoggingController = &ProjectLoggingControllerMock{}

// ProjectLoggingControllerMock is a mock implementation of v31.ProjectLoggingController.
//
//     func TestSomethingThatUsesProjectLoggingController(t *testing.T) {
//
//         // make and configure a mocked v31.ProjectLoggingController
//         mockedProjectLoggingController := &ProjectLoggingControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ProjectLoggingHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.ProjectLoggingHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ProjectLoggingHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.ProjectLoggingHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.ProjectLoggingLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedProjectLoggingController in code that requires v31.ProjectLoggingController
//         // and then make assertions.
//
//     }
type ProjectLoggingControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ProjectLoggingHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.ProjectLoggingHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ProjectLoggingHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.ProjectLoggingHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.ProjectLoggingLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.ProjectLoggingHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.ProjectLoggingHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ProjectLoggingHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.ProjectLoggingHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ProjectLoggingControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.ProjectLoggingHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ProjectLoggingControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but ProjectLoggingController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.ProjectLoggingHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockProjectLoggingControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockProjectLoggingControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedProjectLoggingController.AddClusterScopedFeatureHandlerCalls())
func (mock *ProjectLoggingControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.ProjectLoggingHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.ProjectLoggingHandlerFunc
	}
	lockProjectLoggingControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockProjectLoggingControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ProjectLoggingControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.ProjectLoggingHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ProjectLoggingControllerMock.AddClusterScopedHandlerFunc: method is nil but ProjectLoggingController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.ProjectLoggingHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockProjectLoggingControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockProjectLoggingControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedProjectLoggingController.AddClusterScopedHandlerCalls())
func (mock *ProjectLoggingControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.ProjectLoggingHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.ProjectLoggingHandlerFunc
	}
	lockProjectLoggingControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockProjectLoggingControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ProjectLoggingControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ProjectLoggingHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ProjectLoggingControllerMock.AddFeatureHandlerFunc: method is nil but ProjectLoggingController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ProjectLoggingHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockProjectLoggingControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockProjectLoggingControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedProjectLoggingController.AddFeatureHandlerCalls())
func (mock *ProjectLoggingControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.ProjectLoggingHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ProjectLoggingHandlerFunc
	}
	lockProjectLoggingControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockProjectLoggingControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ProjectLoggingControllerMock) AddHandler(ctx context.Context, name string, handler v31.ProjectLoggingHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ProjectLoggingControllerMock.AddHandlerFunc: method is nil but ProjectLoggingController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.ProjectLoggingHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockProjectLoggingControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockProjectLoggingControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedProjectLoggingController.AddHandlerCalls())
func (mock *ProjectLoggingControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.ProjectLoggingHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.ProjectLoggingHandlerFunc
	}
	lockProjectLoggingControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockProjectLoggingControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *ProjectLoggingControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("ProjectLoggingControllerMock.EnqueueFunc: method is nil but ProjectLoggingController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockProjectLoggingControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockProjectLoggingControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedProjectLoggingController.EnqueueCalls())
func (mock *ProjectLoggingControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockProjectLoggingControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockProjectLoggingControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *ProjectLoggingControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("ProjectLoggingControllerMock.EnqueueAfterFunc: method is nil but ProjectLoggingController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockProjectLoggingControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockProjectLoggingControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedProjectLoggingController.EnqueueAfterCalls())
func (mock *ProjectLoggingControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockProjectLoggingControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockProjectLoggingControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *ProjectLoggingControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("ProjectLoggingControllerMock.GenericFunc: method is nil but ProjectLoggingController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockProjectLoggingControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockProjectLoggingControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedProjectLoggingController.GenericCalls())
func (mock *ProjectLoggingControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockProjectLoggingControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockProjectLoggingControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *ProjectLoggingControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("ProjectLoggingControllerMock.InformerFunc: method is nil but ProjectLoggingController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockProjectLoggingControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockProjectLoggingControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedProjectLoggingController.InformerCalls())
func (mock *ProjectLoggingControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockProjectLoggingControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockProjectLoggingControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *ProjectLoggingControllerMock) Lister() v31.ProjectLoggingLister {
	if mock.ListerFunc == nil {
		panic("ProjectLoggingControllerMock.ListerFunc: method is nil but ProjectLoggingController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockProjectLoggingControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockProjectLoggingControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedProjectLoggingController.ListerCalls())
func (mock *ProjectLoggingControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockProjectLoggingControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockProjectLoggingControllerMockLister.RUnlock()
	return calls
}

var (
	lockProjectLoggingInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockProjectLoggingInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockProjectLoggingInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockProjectLoggingInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockProjectLoggingInterfaceMockAddFeatureHandler                sync.RWMutex
	lockProjectLoggingInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockProjectLoggingInterfaceMockAddHandler                       sync.RWMutex
	lockProjectLoggingInterfaceMockAddLifecycle                     sync.RWMutex
	lockProjectLoggingInterfaceMockController                       sync.RWMutex
	lockProjectLoggingInterfaceMockCreate                           sync.RWMutex
	lockProjectLoggingInterfaceMockDelete                           sync.RWMutex
	lockProjectLoggingInterfaceMockDeleteCollection                 sync.RWMutex
	lockProjectLoggingInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockProjectLoggingInterfaceMockGet                              sync.RWMutex
	lockProjectLoggingInterfaceMockGetNamespaced                    sync.RWMutex
	lockProjectLoggingInterfaceMockList                             sync.RWMutex
	lockProjectLoggingInterfaceMockListNamespaced                   sync.RWMutex
	lockProjectLoggingInterfaceMockObjectClient                     sync.RWMutex
	lockProjectLoggingInterfaceMockUpdate                           sync.RWMutex
	lockProjectLoggingInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that ProjectLoggingInterfaceMock does implement v31.ProjectLoggingInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.ProjectLoggingInterface = &ProjectLoggingInterfaceMock{}

// ProjectLoggingInterfaceMock is a mock implementation of v31.ProjectLoggingInterface.
//
//     func TestSomethingThatUsesProjectLoggingInterface(t *testing.T) {
//
//         // make and configure a mocked v31.ProjectLoggingInterface
//         mockedProjectLoggingInterface := &ProjectLoggingInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ProjectLoggingHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ProjectLoggingLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.ProjectLoggingHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.ProjectLoggingLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ProjectLoggingHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.ProjectLoggingLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.ProjectLoggingHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.ProjectLoggingLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.ProjectLoggingController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.ProjectLogging) (*v3.ProjectLogging, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.ProjectLogging, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.ProjectLogging, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.ProjectLoggingList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.ProjectLoggingList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.ProjectLogging) (*v3.ProjectLogging, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedProjectLoggingInterface in code that requires v31.ProjectLoggingInterface
//         // and then make assertions.
//
//     }
type ProjectLoggingInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ProjectLoggingHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ProjectLoggingLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.ProjectLoggingHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.ProjectLoggingLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ProjectLoggingHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.ProjectLoggingLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.ProjectLoggingHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.ProjectLoggingLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.ProjectLoggingController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.ProjectLogging) (*v3.ProjectLogging, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.ProjectLogging, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.ProjectLogging, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.ProjectLoggingList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.ProjectLoggingList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.ProjectLogging) (*v3.ProjectLogging, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.ProjectLoggingHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ProjectLoggingLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.ProjectLoggingHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ProjectLoggingLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ProjectLoggingHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ProjectLoggingLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.ProjectLoggingHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.ProjectLoggingLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.ProjectLogging
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.ProjectLogging
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *ProjectLoggingInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.ProjectLoggingHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("ProjectLoggingInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but ProjectLoggingInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.ProjectLoggingHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockProjectLoggingInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockProjectLoggingInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedProjectLoggingInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *ProjectLoggingInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.ProjectLoggingHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.ProjectLoggingHandlerFunc
	}
	lockProjectLoggingInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockProjectLoggingInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *ProjectLoggingInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.ProjectLoggingLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("ProjectLoggingInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but ProjectLoggingInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.ProjectLoggingLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockProjectLoggingInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockProjectLoggingInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedProjectLoggingInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *ProjectLoggingInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.ProjectLoggingLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.ProjectLoggingLifecycle
	}
	lockProjectLoggingInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockProjectLoggingInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *ProjectLoggingInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.ProjectLoggingHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("ProjectLoggingInterfaceMock.AddClusterScopedHandlerFunc: method is nil but ProjectLoggingInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.ProjectLoggingHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockProjectLoggingInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockProjectLoggingInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedProjectLoggingInterface.AddClusterScopedHandlerCalls())
func (mock *ProjectLoggingInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.ProjectLoggingHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.ProjectLoggingHandlerFunc
	}
	lockProjectLoggingInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockProjectLoggingInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *ProjectLoggingInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.ProjectLoggingLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("ProjectLoggingInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but ProjectLoggingInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.ProjectLoggingLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockProjectLoggingInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockProjectLoggingInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedProjectLoggingInterface.AddClusterScopedLifecycleCalls())
func (mock *ProjectLoggingInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.ProjectLoggingLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.ProjectLoggingLifecycle
	}
	lockProjectLoggingInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockProjectLoggingInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *ProjectLoggingInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.ProjectLoggingHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("ProjectLoggingInterfaceMock.AddFeatureHandlerFunc: method is nil but ProjectLoggingInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ProjectLoggingHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockProjectLoggingInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockProjectLoggingInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedProjectLoggingInterface.AddFeatureHandlerCalls())
func (mock *ProjectLoggingInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.ProjectLoggingHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.ProjectLoggingHandlerFunc
	}
	lockProjectLoggingInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockProjectLoggingInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *ProjectLoggingInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.ProjectLoggingLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("ProjectLoggingInterfaceMock.AddFeatureLifecycleFunc: method is nil but ProjectLoggingInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.ProjectLoggingLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockProjectLoggingInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockProjectLoggingInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedProjectLoggingInterface.AddFeatureLifecycleCalls())
func (mock *ProjectLoggingInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.ProjectLoggingLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.ProjectLoggingLifecycle
	}
	lockProjectLoggingInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockProjectLoggingInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *ProjectLoggingInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.ProjectLoggingHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("ProjectLoggingInterfaceMock.AddHandlerFunc: method is nil but ProjectLoggingInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.ProjectLoggingHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockProjectLoggingInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockProjectLoggingInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedProjectLoggingInterface.AddHandlerCalls())
func (mock *ProjectLoggingInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.ProjectLoggingHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.ProjectLoggingHandlerFunc
	}
	lockProjectLoggingInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockProjectLoggingInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *ProjectLoggingInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.ProjectLoggingLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("ProjectLoggingInterfaceMock.AddLifecycleFunc: method is nil but ProjectLoggingInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.ProjectLoggingLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockProjectLoggingInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockProjectLoggingInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedProjectLoggingInterface.AddLifecycleCalls())
func (mock *ProjectLoggingInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.ProjectLoggingLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.ProjectLoggingLifecycle
	}
	lockProjectLoggingInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockProjectLoggingInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *ProjectLoggingInterfaceMock) Controller() v31.ProjectLoggingController {
	if mock.ControllerFunc == nil {
		panic("ProjectLoggingInterfaceMock.ControllerFunc: method is nil but ProjectLoggingInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockProjectLoggingInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockProjectLoggingInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedProjectLoggingInterface.ControllerCalls())
func (mock *ProjectLoggingInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockProjectLoggingInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockProjectLoggingInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *ProjectLoggingInterfaceMock) Create(in1 *v3.ProjectLogging) (*v3.ProjectLogging, error) {
	if mock.CreateFunc == nil {
		panic("ProjectLoggingInterfaceMock.CreateFunc: method is nil but ProjectLoggingInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.ProjectLogging
	}{
		In1: in1,
	}
	lockProjectLoggingInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockProjectLoggingInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedProjectLoggingInterface.CreateCalls())
func (mock *ProjectLoggingInterfaceMock) CreateCalls() []struct {
	In1 *v3.ProjectLogging
} {
	var calls []struct {
		In1 *v3.ProjectLogging
	}
	lockProjectLoggingInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockProjectLoggingInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *ProjectLoggingInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("ProjectLoggingInterfaceMock.DeleteFunc: method is nil but ProjectLoggingInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockProjectLoggingInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockProjectLoggingInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedProjectLoggingInterface.DeleteCalls())
func (mock *ProjectLoggingInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockProjectLoggingInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockProjectLoggingInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *ProjectLoggingInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("ProjectLoggingInterfaceMock.DeleteCollectionFunc: method is nil but ProjectLoggingInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockProjectLoggingInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockProjectLoggingInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedProjectLoggingInterface.DeleteCollectionCalls())
func (mock *ProjectLoggingInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockProjectLoggingInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockProjectLoggingInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *ProjectLoggingInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("ProjectLoggingInterfaceMock.DeleteNamespacedFunc: method is nil but ProjectLoggingInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockProjectLoggingInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockProjectLoggingInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedProjectLoggingInterface.DeleteNamespacedCalls())
func (mock *ProjectLoggingInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockProjectLoggingInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockProjectLoggingInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *ProjectLoggingInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.ProjectLogging, error) {
	if mock.GetFunc == nil {
		panic("ProjectLoggingInterfaceMock.GetFunc: method is nil but ProjectLoggingInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockProjectLoggingInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockProjectLoggingInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedProjectLoggingInterface.GetCalls())
func (mock *ProjectLoggingInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockProjectLoggingInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockProjectLoggingInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *ProjectLoggingInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.ProjectLogging, error) {
	if mock.GetNamespacedFunc == nil {
		panic("ProjectLoggingInterfaceMock.GetNamespacedFunc: method is nil but ProjectLoggingInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockProjectLoggingInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockProjectLoggingInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedProjectLoggingInterface.GetNamespacedCalls())
func (mock *ProjectLoggingInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockProjectLoggingInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockProjectLoggingInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *ProjectLoggingInterfaceMock) List(opts metav1.ListOptions) (*v3.ProjectLoggingList, error) {
	if mock.ListFunc == nil {
		panic("ProjectLoggingInterfaceMock.ListFunc: method is nil but ProjectLoggingInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockProjectLoggingInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockProjectLoggingInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedProjectLoggingInterface.ListCalls())
func (mock *ProjectLoggingInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockProjectLoggingInterfaceMockList.RLock()
	calls = mock.calls.List
	lockProjectLoggingInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *ProjectLoggingInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.ProjectLoggingList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("ProjectLoggingInterfaceMock.ListNamespacedFunc: method is nil but ProjectLoggingInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockProjectLoggingInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockProjectLoggingInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedProjectLoggingInterface.ListNamespacedCalls())
func (mock *ProjectLoggingInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockProjectLoggingInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockProjectLoggingInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *ProjectLoggingInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("ProjectLoggingInterfaceMock.ObjectClientFunc: method is nil but ProjectLoggingInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockProjectLoggingInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockProjectLoggingInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedProjectLoggingInterface.ObjectClientCalls())
func (mock *ProjectLoggingInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockProjectLoggingInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockProjectLoggingInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *ProjectLoggingInterfaceMock) Update(in1 *v3.ProjectLogging) (*v3.ProjectLogging, error) {
	if mock.UpdateFunc == nil {
		panic("ProjectLoggingInterfaceMock.UpdateFunc: method is nil but ProjectLoggingInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.ProjectLogging
	}{
		In1: in1,
	}
	lockProjectLoggingInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockProjectLoggingInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedProjectLoggingInterface.UpdateCalls())
func (mock *ProjectLoggingInterfaceMock) UpdateCalls() []struct {
	In1 *v3.ProjectLogging
} {
	var calls []struct {
		In1 *v3.ProjectLogging
	}
	lockProjectLoggingInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockProjectLoggingInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *ProjectLoggingInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("ProjectLoggingInterfaceMock.WatchFunc: method is nil but ProjectLoggingInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockProjectLoggingInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockProjectLoggingInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedProjectLoggingInterface.WatchCalls())
func (mock *ProjectLoggingInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockProjectLoggingInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockProjectLoggingInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockProjectLoggingsGetterMockProjectLoggings sync.RWMutex
)

// Ensure, that ProjectLoggingsGetterMock does implement v31.ProjectLoggingsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.ProjectLoggingsGetter = &ProjectLoggingsGetterMock{}

// ProjectLoggingsGetterMock is a mock implementation of v31.ProjectLoggingsGetter.
//
//     func TestSomethingThatUsesProjectLoggingsGetter(t *testing.T) {
//
//         // make and configure a mocked v31.ProjectLoggingsGetter
//         mockedProjectLoggingsGetter := &ProjectLoggingsGetterMock{
//             ProjectLoggingsFunc: func(namespace string) v31.ProjectLoggingInterface {
// 	               panic("mock out the ProjectLoggings method")
//             },
//         }
//
//         // use mockedProjectLoggingsGetter in code that requires v31.ProjectLoggingsGetter
//         // and then make assertions.
//
//     }
type ProjectLoggingsGetterMock struct {
	// ProjectLoggingsFunc mocks the ProjectLoggings method.
	ProjectLoggingsFunc func(namespace string) v31.ProjectLoggingInterface

	// calls tracks calls to the methods.
	calls struct {
		// ProjectLoggings holds details about calls to the ProjectLoggings method.
		ProjectLoggings []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// ProjectLoggings calls ProjectLoggingsFunc.
func (mock *ProjectLoggingsGetterMock) ProjectLoggings(namespace string) v31.ProjectLoggingInterface {
	if mock.ProjectLoggingsFunc == nil {
		panic("ProjectLoggingsGetterMock.ProjectLoggingsFunc: method is nil but ProjectLoggingsGetter.ProjectLoggings was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockProjectLoggingsGetterMockProjectLoggings.Lock()
	mock.calls.ProjectLoggings = append(mock.calls.ProjectLoggings, callInfo)
	lockProjectLoggingsGetterMockProjectLoggings.Unlock()
	return mock.ProjectLoggingsFunc(namespace)
}

// ProjectLoggingsCalls gets all the calls that were made to ProjectLoggings.
// Check the length with:
//     len(mockedProjectLoggingsGetter.ProjectLoggingsCalls())
func (mock *ProjectLoggingsGetterMock) ProjectLoggingsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockProjectLoggingsGetterMockProjectLoggings.RLock()
	calls = mock.calls.ProjectLoggings
	lockProjectLoggingsGetterMockProjectLoggings.RUnlock()
	return calls
}
