// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockRkeAddonListerMockGet  sync.RWMutex
	lockRkeAddonListerMockList sync.RWMutex
)

// Ensure, that RkeAddonListerMock does implement v31.RkeAddonLister.
// If this is not the case, regenerate this file with moq.
var _ v31.RkeAddonLister = &RkeAddonListerMock{}

// RkeAddonListerMock is a mock implementation of v31.RkeAddonLister.
//
//     func TestSomethingThatUsesRkeAddonLister(t *testing.T) {
//
//         // make and configure a mocked v31.RkeAddonLister
//         mockedRkeAddonLister := &RkeAddonListerMock{
//             GetFunc: func(namespace string, name string) (*v3.RkeAddon, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.RkeAddon, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedRkeAddonLister in code that requires v31.RkeAddonLister
//         // and then make assertions.
//
//     }
type RkeAddonListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.RkeAddon, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.RkeAddon, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *RkeAddonListerMock) Get(namespace string, name string) (*v3.RkeAddon, error) {
	if mock.GetFunc == nil {
		panic("RkeAddonListerMock.GetFunc: method is nil but RkeAddonLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockRkeAddonListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockRkeAddonListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedRkeAddonLister.GetCalls())
func (mock *RkeAddonListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockRkeAddonListerMockGet.RLock()
	calls = mock.calls.Get
	lockRkeAddonListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *RkeAddonListerMock) List(namespace string, selector labels.Selector) ([]*v3.RkeAddon, error) {
	if mock.ListFunc == nil {
		panic("RkeAddonListerMock.ListFunc: method is nil but RkeAddonLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockRkeAddonListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockRkeAddonListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedRkeAddonLister.ListCalls())
func (mock *RkeAddonListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockRkeAddonListerMockList.RLock()
	calls = mock.calls.List
	lockRkeAddonListerMockList.RUnlock()
	return calls
}

var (
	lockRkeAddonControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockRkeAddonControllerMockAddClusterScopedHandler        sync.RWMutex
	lockRkeAddonControllerMockAddFeatureHandler              sync.RWMutex
	lockRkeAddonControllerMockAddHandler                     sync.RWMutex
	lockRkeAddonControllerMockEnqueue                        sync.RWMutex
	lockRkeAddonControllerMockEnqueueAfter                   sync.RWMutex
	lockRkeAddonControllerMockGeneric                        sync.RWMutex
	lockRkeAddonControllerMockInformer                       sync.RWMutex
	lockRkeAddonControllerMockLister                         sync.RWMutex
)

// Ensure, that RkeAddonControllerMock does implement v31.RkeAddonController.
// If this is not the case, regenerate this file with moq.
var _ v31.RkeAddonController = &RkeAddonControllerMock{}

// RkeAddonControllerMock is a mock implementation of v31.RkeAddonController.
//
//     func TestSomethingThatUsesRkeAddonController(t *testing.T) {
//
//         // make and configure a mocked v31.RkeAddonController
//         mockedRkeAddonController := &RkeAddonControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.RkeAddonHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.RkeAddonHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.RkeAddonHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.RkeAddonHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.RkeAddonLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedRkeAddonController in code that requires v31.RkeAddonController
//         // and then make assertions.
//
//     }
type RkeAddonControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.RkeAddonHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.RkeAddonHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.RkeAddonHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.RkeAddonHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.RkeAddonLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.RkeAddonHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.RkeAddonHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.RkeAddonHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.RkeAddonHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *RkeAddonControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.RkeAddonHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("RkeAddonControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but RkeAddonController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.RkeAddonHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockRkeAddonControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockRkeAddonControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedRkeAddonController.AddClusterScopedFeatureHandlerCalls())
func (mock *RkeAddonControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.RkeAddonHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.RkeAddonHandlerFunc
	}
	lockRkeAddonControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockRkeAddonControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *RkeAddonControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.RkeAddonHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("RkeAddonControllerMock.AddClusterScopedHandlerFunc: method is nil but RkeAddonController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.RkeAddonHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockRkeAddonControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockRkeAddonControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedRkeAddonController.AddClusterScopedHandlerCalls())
func (mock *RkeAddonControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.RkeAddonHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.RkeAddonHandlerFunc
	}
	lockRkeAddonControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockRkeAddonControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *RkeAddonControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.RkeAddonHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("RkeAddonControllerMock.AddFeatureHandlerFunc: method is nil but RkeAddonController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.RkeAddonHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockRkeAddonControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockRkeAddonControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedRkeAddonController.AddFeatureHandlerCalls())
func (mock *RkeAddonControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.RkeAddonHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.RkeAddonHandlerFunc
	}
	lockRkeAddonControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockRkeAddonControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *RkeAddonControllerMock) AddHandler(ctx context.Context, name string, handler v31.RkeAddonHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("RkeAddonControllerMock.AddHandlerFunc: method is nil but RkeAddonController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.RkeAddonHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockRkeAddonControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockRkeAddonControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedRkeAddonController.AddHandlerCalls())
func (mock *RkeAddonControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.RkeAddonHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.RkeAddonHandlerFunc
	}
	lockRkeAddonControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockRkeAddonControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *RkeAddonControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("RkeAddonControllerMock.EnqueueFunc: method is nil but RkeAddonController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockRkeAddonControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockRkeAddonControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedRkeAddonController.EnqueueCalls())
func (mock *RkeAddonControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockRkeAddonControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockRkeAddonControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *RkeAddonControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("RkeAddonControllerMock.EnqueueAfterFunc: method is nil but RkeAddonController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockRkeAddonControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockRkeAddonControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedRkeAddonController.EnqueueAfterCalls())
func (mock *RkeAddonControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockRkeAddonControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockRkeAddonControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *RkeAddonControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("RkeAddonControllerMock.GenericFunc: method is nil but RkeAddonController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockRkeAddonControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockRkeAddonControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedRkeAddonController.GenericCalls())
func (mock *RkeAddonControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockRkeAddonControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockRkeAddonControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *RkeAddonControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("RkeAddonControllerMock.InformerFunc: method is nil but RkeAddonController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockRkeAddonControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockRkeAddonControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedRkeAddonController.InformerCalls())
func (mock *RkeAddonControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockRkeAddonControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockRkeAddonControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *RkeAddonControllerMock) Lister() v31.RkeAddonLister {
	if mock.ListerFunc == nil {
		panic("RkeAddonControllerMock.ListerFunc: method is nil but RkeAddonController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockRkeAddonControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockRkeAddonControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedRkeAddonController.ListerCalls())
func (mock *RkeAddonControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockRkeAddonControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockRkeAddonControllerMockLister.RUnlock()
	return calls
}

var (
	lockRkeAddonInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockRkeAddonInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockRkeAddonInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockRkeAddonInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockRkeAddonInterfaceMockAddFeatureHandler                sync.RWMutex
	lockRkeAddonInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockRkeAddonInterfaceMockAddHandler                       sync.RWMutex
	lockRkeAddonInterfaceMockAddLifecycle                     sync.RWMutex
	lockRkeAddonInterfaceMockController                       sync.RWMutex
	lockRkeAddonInterfaceMockCreate                           sync.RWMutex
	lockRkeAddonInterfaceMockDelete                           sync.RWMutex
	lockRkeAddonInterfaceMockDeleteCollection                 sync.RWMutex
	lockRkeAddonInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockRkeAddonInterfaceMockGet                              sync.RWMutex
	lockRkeAddonInterfaceMockGetNamespaced                    sync.RWMutex
	lockRkeAddonInterfaceMockList                             sync.RWMutex
	lockRkeAddonInterfaceMockListNamespaced                   sync.RWMutex
	lockRkeAddonInterfaceMockObjectClient                     sync.RWMutex
	lockRkeAddonInterfaceMockUpdate                           sync.RWMutex
	lockRkeAddonInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that RkeAddonInterfaceMock does implement v31.RkeAddonInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.RkeAddonInterface = &RkeAddonInterfaceMock{}

// RkeAddonInterfaceMock is a mock implementation of v31.RkeAddonInterface.
//
//     func TestSomethingThatUsesRkeAddonInterface(t *testing.T) {
//
//         // make and configure a mocked v31.RkeAddonInterface
//         mockedRkeAddonInterface := &RkeAddonInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.RkeAddonHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.RkeAddonLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.RkeAddonHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.RkeAddonLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.RkeAddonHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.RkeAddonLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.RkeAddonHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.RkeAddonLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.RkeAddonController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.RkeAddon) (*v3.RkeAddon, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.RkeAddon, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.RkeAddon, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.RkeAddonList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.RkeAddonList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.RkeAddon) (*v3.RkeAddon, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedRkeAddonInterface in code that requires v31.RkeAddonInterface
//         // and then make assertions.
//
//     }
type RkeAddonInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.RkeAddonHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.RkeAddonLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.RkeAddonHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.RkeAddonLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.RkeAddonHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.RkeAddonLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.RkeAddonHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.RkeAddonLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.RkeAddonController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.RkeAddon) (*v3.RkeAddon, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.RkeAddon, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.RkeAddon, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.RkeAddonList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.RkeAddonList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.RkeAddon) (*v3.RkeAddon, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.RkeAddonHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.RkeAddonLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.RkeAddonHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.RkeAddonLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.RkeAddonHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.RkeAddonLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.RkeAddonHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.RkeAddonLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.RkeAddon
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.RkeAddon
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *RkeAddonInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.RkeAddonHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("RkeAddonInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but RkeAddonInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.RkeAddonHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockRkeAddonInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockRkeAddonInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedRkeAddonInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *RkeAddonInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.RkeAddonHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.RkeAddonHandlerFunc
	}
	lockRkeAddonInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockRkeAddonInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *RkeAddonInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.RkeAddonLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("RkeAddonInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but RkeAddonInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.RkeAddonLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockRkeAddonInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockRkeAddonInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedRkeAddonInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *RkeAddonInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.RkeAddonLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.RkeAddonLifecycle
	}
	lockRkeAddonInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockRkeAddonInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *RkeAddonInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.RkeAddonHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("RkeAddonInterfaceMock.AddClusterScopedHandlerFunc: method is nil but RkeAddonInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.RkeAddonHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockRkeAddonInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockRkeAddonInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedRkeAddonInterface.AddClusterScopedHandlerCalls())
func (mock *RkeAddonInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.RkeAddonHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.RkeAddonHandlerFunc
	}
	lockRkeAddonInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockRkeAddonInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *RkeAddonInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.RkeAddonLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("RkeAddonInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but RkeAddonInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.RkeAddonLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockRkeAddonInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockRkeAddonInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedRkeAddonInterface.AddClusterScopedLifecycleCalls())
func (mock *RkeAddonInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.RkeAddonLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.RkeAddonLifecycle
	}
	lockRkeAddonInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockRkeAddonInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *RkeAddonInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.RkeAddonHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("RkeAddonInterfaceMock.AddFeatureHandlerFunc: method is nil but RkeAddonInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.RkeAddonHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockRkeAddonInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockRkeAddonInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedRkeAddonInterface.AddFeatureHandlerCalls())
func (mock *RkeAddonInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.RkeAddonHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.RkeAddonHandlerFunc
	}
	lockRkeAddonInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockRkeAddonInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *RkeAddonInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.RkeAddonLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("RkeAddonInterfaceMock.AddFeatureLifecycleFunc: method is nil but RkeAddonInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.RkeAddonLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockRkeAddonInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockRkeAddonInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedRkeAddonInterface.AddFeatureLifecycleCalls())
func (mock *RkeAddonInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.RkeAddonLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.RkeAddonLifecycle
	}
	lockRkeAddonInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockRkeAddonInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *RkeAddonInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.RkeAddonHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("RkeAddonInterfaceMock.AddHandlerFunc: method is nil but RkeAddonInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.RkeAddonHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockRkeAddonInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockRkeAddonInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedRkeAddonInterface.AddHandlerCalls())
func (mock *RkeAddonInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.RkeAddonHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.RkeAddonHandlerFunc
	}
	lockRkeAddonInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockRkeAddonInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *RkeAddonInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.RkeAddonLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("RkeAddonInterfaceMock.AddLifecycleFunc: method is nil but RkeAddonInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.RkeAddonLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockRkeAddonInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockRkeAddonInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedRkeAddonInterface.AddLifecycleCalls())
func (mock *RkeAddonInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.RkeAddonLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.RkeAddonLifecycle
	}
	lockRkeAddonInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockRkeAddonInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *RkeAddonInterfaceMock) Controller() v31.RkeAddonController {
	if mock.ControllerFunc == nil {
		panic("RkeAddonInterfaceMock.ControllerFunc: method is nil but RkeAddonInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockRkeAddonInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockRkeAddonInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedRkeAddonInterface.ControllerCalls())
func (mock *RkeAddonInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockRkeAddonInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockRkeAddonInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *RkeAddonInterfaceMock) Create(in1 *v3.RkeAddon) (*v3.RkeAddon, error) {
	if mock.CreateFunc == nil {
		panic("RkeAddonInterfaceMock.CreateFunc: method is nil but RkeAddonInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.RkeAddon
	}{
		In1: in1,
	}
	lockRkeAddonInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockRkeAddonInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedRkeAddonInterface.CreateCalls())
func (mock *RkeAddonInterfaceMock) CreateCalls() []struct {
	In1 *v3.RkeAddon
} {
	var calls []struct {
		In1 *v3.RkeAddon
	}
	lockRkeAddonInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockRkeAddonInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *RkeAddonInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("RkeAddonInterfaceMock.DeleteFunc: method is nil but RkeAddonInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockRkeAddonInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockRkeAddonInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedRkeAddonInterface.DeleteCalls())
func (mock *RkeAddonInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockRkeAddonInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockRkeAddonInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *RkeAddonInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("RkeAddonInterfaceMock.DeleteCollectionFunc: method is nil but RkeAddonInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockRkeAddonInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockRkeAddonInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedRkeAddonInterface.DeleteCollectionCalls())
func (mock *RkeAddonInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockRkeAddonInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockRkeAddonInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *RkeAddonInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("RkeAddonInterfaceMock.DeleteNamespacedFunc: method is nil but RkeAddonInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockRkeAddonInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockRkeAddonInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedRkeAddonInterface.DeleteNamespacedCalls())
func (mock *RkeAddonInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockRkeAddonInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockRkeAddonInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *RkeAddonInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.RkeAddon, error) {
	if mock.GetFunc == nil {
		panic("RkeAddonInterfaceMock.GetFunc: method is nil but RkeAddonInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockRkeAddonInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockRkeAddonInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedRkeAddonInterface.GetCalls())
func (mock *RkeAddonInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockRkeAddonInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockRkeAddonInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *RkeAddonInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.RkeAddon, error) {
	if mock.GetNamespacedFunc == nil {
		panic("RkeAddonInterfaceMock.GetNamespacedFunc: method is nil but RkeAddonInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockRkeAddonInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockRkeAddonInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedRkeAddonInterface.GetNamespacedCalls())
func (mock *RkeAddonInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockRkeAddonInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockRkeAddonInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *RkeAddonInterfaceMock) List(opts metav1.ListOptions) (*v3.RkeAddonList, error) {
	if mock.ListFunc == nil {
		panic("RkeAddonInterfaceMock.ListFunc: method is nil but RkeAddonInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockRkeAddonInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockRkeAddonInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedRkeAddonInterface.ListCalls())
func (mock *RkeAddonInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockRkeAddonInterfaceMockList.RLock()
	calls = mock.calls.List
	lockRkeAddonInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *RkeAddonInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.RkeAddonList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("RkeAddonInterfaceMock.ListNamespacedFunc: method is nil but RkeAddonInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockRkeAddonInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockRkeAddonInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedRkeAddonInterface.ListNamespacedCalls())
func (mock *RkeAddonInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockRkeAddonInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockRkeAddonInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *RkeAddonInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("RkeAddonInterfaceMock.ObjectClientFunc: method is nil but RkeAddonInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockRkeAddonInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockRkeAddonInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedRkeAddonInterface.ObjectClientCalls())
func (mock *RkeAddonInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockRkeAddonInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockRkeAddonInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *RkeAddonInterfaceMock) Update(in1 *v3.RkeAddon) (*v3.RkeAddon, error) {
	if mock.UpdateFunc == nil {
		panic("RkeAddonInterfaceMock.UpdateFunc: method is nil but RkeAddonInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.RkeAddon
	}{
		In1: in1,
	}
	lockRkeAddonInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockRkeAddonInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedRkeAddonInterface.UpdateCalls())
func (mock *RkeAddonInterfaceMock) UpdateCalls() []struct {
	In1 *v3.RkeAddon
} {
	var calls []struct {
		In1 *v3.RkeAddon
	}
	lockRkeAddonInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockRkeAddonInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *RkeAddonInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("RkeAddonInterfaceMock.WatchFunc: method is nil but RkeAddonInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockRkeAddonInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockRkeAddonInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedRkeAddonInterface.WatchCalls())
func (mock *RkeAddonInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockRkeAddonInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockRkeAddonInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockRkeAddonsGetterMockRkeAddons sync.RWMutex
)

// Ensure, that RkeAddonsGetterMock does implement v31.RkeAddonsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.RkeAddonsGetter = &RkeAddonsGetterMock{}

// RkeAddonsGetterMock is a mock implementation of v31.RkeAddonsGetter.
//
//     func TestSomethingThatUsesRkeAddonsGetter(t *testing.T) {
//
//         // make and configure a mocked v31.RkeAddonsGetter
//         mockedRkeAddonsGetter := &RkeAddonsGetterMock{
//             RkeAddonsFunc: func(namespace string) v31.RkeAddonInterface {
// 	               panic("mock out the RkeAddons method")
//             },
//         }
//
//         // use mockedRkeAddonsGetter in code that requires v31.RkeAddonsGetter
//         // and then make assertions.
//
//     }
type RkeAddonsGetterMock struct {
	// RkeAddonsFunc mocks the RkeAddons method.
	RkeAddonsFunc func(namespace string) v31.RkeAddonInterface

	// calls tracks calls to the methods.
	calls struct {
		// RkeAddons holds details about calls to the RkeAddons method.
		RkeAddons []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// RkeAddons calls RkeAddonsFunc.
func (mock *RkeAddonsGetterMock) RkeAddons(namespace string) v31.RkeAddonInterface {
	if mock.RkeAddonsFunc == nil {
		panic("RkeAddonsGetterMock.RkeAddonsFunc: method is nil but RkeAddonsGetter.RkeAddons was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockRkeAddonsGetterMockRkeAddons.Lock()
	mock.calls.RkeAddons = append(mock.calls.RkeAddons, callInfo)
	lockRkeAddonsGetterMockRkeAddons.Unlock()
	return mock.RkeAddonsFunc(namespace)
}

// RkeAddonsCalls gets all the calls that were made to RkeAddons.
// Check the length with:
//     len(mockedRkeAddonsGetter.RkeAddonsCalls())
func (mock *RkeAddonsGetterMock) RkeAddonsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockRkeAddonsGetterMockRkeAddons.RLock()
	calls = mock.calls.RkeAddons
	lockRkeAddonsGetterMockRkeAddons.RUnlock()
	return calls
}
