// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockRkeK8sServiceOptionListerMockGet  sync.RWMutex
	lockRkeK8sServiceOptionListerMockList sync.RWMutex
)

// Ensure, that RkeK8sServiceOptionListerMock does implement v31.RkeK8sServiceOptionLister.
// If this is not the case, regenerate this file with moq.
var _ v31.RkeK8sServiceOptionLister = &RkeK8sServiceOptionListerMock{}

// RkeK8sServiceOptionListerMock is a mock implementation of v31.RkeK8sServiceOptionLister.
//
//     func TestSomethingThatUsesRkeK8sServiceOptionLister(t *testing.T) {
//
//         // make and configure a mocked v31.RkeK8sServiceOptionLister
//         mockedRkeK8sServiceOptionLister := &RkeK8sServiceOptionListerMock{
//             GetFunc: func(namespace string, name string) (*v3.RkeK8sServiceOption, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.RkeK8sServiceOption, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedRkeK8sServiceOptionLister in code that requires v31.RkeK8sServiceOptionLister
//         // and then make assertions.
//
//     }
type RkeK8sServiceOptionListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.RkeK8sServiceOption, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.RkeK8sServiceOption, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *RkeK8sServiceOptionListerMock) Get(namespace string, name string) (*v3.RkeK8sServiceOption, error) {
	if mock.GetFunc == nil {
		panic("RkeK8sServiceOptionListerMock.GetFunc: method is nil but RkeK8sServiceOptionLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockRkeK8sServiceOptionListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockRkeK8sServiceOptionListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedRkeK8sServiceOptionLister.GetCalls())
func (mock *RkeK8sServiceOptionListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockRkeK8sServiceOptionListerMockGet.RLock()
	calls = mock.calls.Get
	lockRkeK8sServiceOptionListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *RkeK8sServiceOptionListerMock) List(namespace string, selector labels.Selector) ([]*v3.RkeK8sServiceOption, error) {
	if mock.ListFunc == nil {
		panic("RkeK8sServiceOptionListerMock.ListFunc: method is nil but RkeK8sServiceOptionLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockRkeK8sServiceOptionListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockRkeK8sServiceOptionListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedRkeK8sServiceOptionLister.ListCalls())
func (mock *RkeK8sServiceOptionListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockRkeK8sServiceOptionListerMockList.RLock()
	calls = mock.calls.List
	lockRkeK8sServiceOptionListerMockList.RUnlock()
	return calls
}

var (
	lockRkeK8sServiceOptionControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockRkeK8sServiceOptionControllerMockAddClusterScopedHandler        sync.RWMutex
	lockRkeK8sServiceOptionControllerMockAddFeatureHandler              sync.RWMutex
	lockRkeK8sServiceOptionControllerMockAddHandler                     sync.RWMutex
	lockRkeK8sServiceOptionControllerMockEnqueue                        sync.RWMutex
	lockRkeK8sServiceOptionControllerMockEnqueueAfter                   sync.RWMutex
	lockRkeK8sServiceOptionControllerMockGeneric                        sync.RWMutex
	lockRkeK8sServiceOptionControllerMockInformer                       sync.RWMutex
	lockRkeK8sServiceOptionControllerMockLister                         sync.RWMutex
)

// Ensure, that RkeK8sServiceOptionControllerMock does implement v31.RkeK8sServiceOptionController.
// If this is not the case, regenerate this file with moq.
var _ v31.RkeK8sServiceOptionController = &RkeK8sServiceOptionControllerMock{}

// RkeK8sServiceOptionControllerMock is a mock implementation of v31.RkeK8sServiceOptionController.
//
//     func TestSomethingThatUsesRkeK8sServiceOptionController(t *testing.T) {
//
//         // make and configure a mocked v31.RkeK8sServiceOptionController
//         mockedRkeK8sServiceOptionController := &RkeK8sServiceOptionControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.RkeK8sServiceOptionHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.RkeK8sServiceOptionHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.RkeK8sServiceOptionHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.RkeK8sServiceOptionHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.RkeK8sServiceOptionLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedRkeK8sServiceOptionController in code that requires v31.RkeK8sServiceOptionController
//         // and then make assertions.
//
//     }
type RkeK8sServiceOptionControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.RkeK8sServiceOptionHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.RkeK8sServiceOptionHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.RkeK8sServiceOptionHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.RkeK8sServiceOptionHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.RkeK8sServiceOptionLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.RkeK8sServiceOptionHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.RkeK8sServiceOptionHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.RkeK8sServiceOptionHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.RkeK8sServiceOptionHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *RkeK8sServiceOptionControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.RkeK8sServiceOptionHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("RkeK8sServiceOptionControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but RkeK8sServiceOptionController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.RkeK8sServiceOptionHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockRkeK8sServiceOptionControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockRkeK8sServiceOptionControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedRkeK8sServiceOptionController.AddClusterScopedFeatureHandlerCalls())
func (mock *RkeK8sServiceOptionControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.RkeK8sServiceOptionHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.RkeK8sServiceOptionHandlerFunc
	}
	lockRkeK8sServiceOptionControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockRkeK8sServiceOptionControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *RkeK8sServiceOptionControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.RkeK8sServiceOptionHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("RkeK8sServiceOptionControllerMock.AddClusterScopedHandlerFunc: method is nil but RkeK8sServiceOptionController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.RkeK8sServiceOptionHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockRkeK8sServiceOptionControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockRkeK8sServiceOptionControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedRkeK8sServiceOptionController.AddClusterScopedHandlerCalls())
func (mock *RkeK8sServiceOptionControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.RkeK8sServiceOptionHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.RkeK8sServiceOptionHandlerFunc
	}
	lockRkeK8sServiceOptionControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockRkeK8sServiceOptionControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *RkeK8sServiceOptionControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.RkeK8sServiceOptionHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("RkeK8sServiceOptionControllerMock.AddFeatureHandlerFunc: method is nil but RkeK8sServiceOptionController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.RkeK8sServiceOptionHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockRkeK8sServiceOptionControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockRkeK8sServiceOptionControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedRkeK8sServiceOptionController.AddFeatureHandlerCalls())
func (mock *RkeK8sServiceOptionControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.RkeK8sServiceOptionHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.RkeK8sServiceOptionHandlerFunc
	}
	lockRkeK8sServiceOptionControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockRkeK8sServiceOptionControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *RkeK8sServiceOptionControllerMock) AddHandler(ctx context.Context, name string, handler v31.RkeK8sServiceOptionHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("RkeK8sServiceOptionControllerMock.AddHandlerFunc: method is nil but RkeK8sServiceOptionController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.RkeK8sServiceOptionHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockRkeK8sServiceOptionControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockRkeK8sServiceOptionControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedRkeK8sServiceOptionController.AddHandlerCalls())
func (mock *RkeK8sServiceOptionControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.RkeK8sServiceOptionHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.RkeK8sServiceOptionHandlerFunc
	}
	lockRkeK8sServiceOptionControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockRkeK8sServiceOptionControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *RkeK8sServiceOptionControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("RkeK8sServiceOptionControllerMock.EnqueueFunc: method is nil but RkeK8sServiceOptionController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockRkeK8sServiceOptionControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockRkeK8sServiceOptionControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedRkeK8sServiceOptionController.EnqueueCalls())
func (mock *RkeK8sServiceOptionControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockRkeK8sServiceOptionControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockRkeK8sServiceOptionControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *RkeK8sServiceOptionControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("RkeK8sServiceOptionControllerMock.EnqueueAfterFunc: method is nil but RkeK8sServiceOptionController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockRkeK8sServiceOptionControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockRkeK8sServiceOptionControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedRkeK8sServiceOptionController.EnqueueAfterCalls())
func (mock *RkeK8sServiceOptionControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockRkeK8sServiceOptionControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockRkeK8sServiceOptionControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *RkeK8sServiceOptionControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("RkeK8sServiceOptionControllerMock.GenericFunc: method is nil but RkeK8sServiceOptionController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockRkeK8sServiceOptionControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockRkeK8sServiceOptionControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedRkeK8sServiceOptionController.GenericCalls())
func (mock *RkeK8sServiceOptionControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockRkeK8sServiceOptionControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockRkeK8sServiceOptionControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *RkeK8sServiceOptionControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("RkeK8sServiceOptionControllerMock.InformerFunc: method is nil but RkeK8sServiceOptionController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockRkeK8sServiceOptionControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockRkeK8sServiceOptionControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedRkeK8sServiceOptionController.InformerCalls())
func (mock *RkeK8sServiceOptionControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockRkeK8sServiceOptionControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockRkeK8sServiceOptionControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *RkeK8sServiceOptionControllerMock) Lister() v31.RkeK8sServiceOptionLister {
	if mock.ListerFunc == nil {
		panic("RkeK8sServiceOptionControllerMock.ListerFunc: method is nil but RkeK8sServiceOptionController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockRkeK8sServiceOptionControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockRkeK8sServiceOptionControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedRkeK8sServiceOptionController.ListerCalls())
func (mock *RkeK8sServiceOptionControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockRkeK8sServiceOptionControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockRkeK8sServiceOptionControllerMockLister.RUnlock()
	return calls
}

var (
	lockRkeK8sServiceOptionInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockRkeK8sServiceOptionInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockRkeK8sServiceOptionInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockRkeK8sServiceOptionInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockRkeK8sServiceOptionInterfaceMockAddFeatureHandler                sync.RWMutex
	lockRkeK8sServiceOptionInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockRkeK8sServiceOptionInterfaceMockAddHandler                       sync.RWMutex
	lockRkeK8sServiceOptionInterfaceMockAddLifecycle                     sync.RWMutex
	lockRkeK8sServiceOptionInterfaceMockController                       sync.RWMutex
	lockRkeK8sServiceOptionInterfaceMockCreate                           sync.RWMutex
	lockRkeK8sServiceOptionInterfaceMockDelete                           sync.RWMutex
	lockRkeK8sServiceOptionInterfaceMockDeleteCollection                 sync.RWMutex
	lockRkeK8sServiceOptionInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockRkeK8sServiceOptionInterfaceMockGet                              sync.RWMutex
	lockRkeK8sServiceOptionInterfaceMockGetNamespaced                    sync.RWMutex
	lockRkeK8sServiceOptionInterfaceMockList                             sync.RWMutex
	lockRkeK8sServiceOptionInterfaceMockListNamespaced                   sync.RWMutex
	lockRkeK8sServiceOptionInterfaceMockObjectClient                     sync.RWMutex
	lockRkeK8sServiceOptionInterfaceMockUpdate                           sync.RWMutex
	lockRkeK8sServiceOptionInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that RkeK8sServiceOptionInterfaceMock does implement v31.RkeK8sServiceOptionInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.RkeK8sServiceOptionInterface = &RkeK8sServiceOptionInterfaceMock{}

// RkeK8sServiceOptionInterfaceMock is a mock implementation of v31.RkeK8sServiceOptionInterface.
//
//     func TestSomethingThatUsesRkeK8sServiceOptionInterface(t *testing.T) {
//
//         // make and configure a mocked v31.RkeK8sServiceOptionInterface
//         mockedRkeK8sServiceOptionInterface := &RkeK8sServiceOptionInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.RkeK8sServiceOptionHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.RkeK8sServiceOptionLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.RkeK8sServiceOptionHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.RkeK8sServiceOptionLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.RkeK8sServiceOptionHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.RkeK8sServiceOptionLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.RkeK8sServiceOptionHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.RkeK8sServiceOptionLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.RkeK8sServiceOptionController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.RkeK8sServiceOption) (*v3.RkeK8sServiceOption, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.RkeK8sServiceOption, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.RkeK8sServiceOption, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.RkeK8sServiceOptionList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.RkeK8sServiceOptionList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.RkeK8sServiceOption) (*v3.RkeK8sServiceOption, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedRkeK8sServiceOptionInterface in code that requires v31.RkeK8sServiceOptionInterface
//         // and then make assertions.
//
//     }
type RkeK8sServiceOptionInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.RkeK8sServiceOptionHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.RkeK8sServiceOptionLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.RkeK8sServiceOptionHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.RkeK8sServiceOptionLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.RkeK8sServiceOptionHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.RkeK8sServiceOptionLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.RkeK8sServiceOptionHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.RkeK8sServiceOptionLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.RkeK8sServiceOptionController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.RkeK8sServiceOption) (*v3.RkeK8sServiceOption, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.RkeK8sServiceOption, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.RkeK8sServiceOption, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.RkeK8sServiceOptionList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.RkeK8sServiceOptionList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.RkeK8sServiceOption) (*v3.RkeK8sServiceOption, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.RkeK8sServiceOptionHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.RkeK8sServiceOptionLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.RkeK8sServiceOptionHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.RkeK8sServiceOptionLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.RkeK8sServiceOptionHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.RkeK8sServiceOptionLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.RkeK8sServiceOptionHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.RkeK8sServiceOptionLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.RkeK8sServiceOption
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.RkeK8sServiceOption
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *RkeK8sServiceOptionInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.RkeK8sServiceOptionHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("RkeK8sServiceOptionInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but RkeK8sServiceOptionInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.RkeK8sServiceOptionHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockRkeK8sServiceOptionInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockRkeK8sServiceOptionInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedRkeK8sServiceOptionInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *RkeK8sServiceOptionInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.RkeK8sServiceOptionHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.RkeK8sServiceOptionHandlerFunc
	}
	lockRkeK8sServiceOptionInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockRkeK8sServiceOptionInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *RkeK8sServiceOptionInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.RkeK8sServiceOptionLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("RkeK8sServiceOptionInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but RkeK8sServiceOptionInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.RkeK8sServiceOptionLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockRkeK8sServiceOptionInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockRkeK8sServiceOptionInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedRkeK8sServiceOptionInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *RkeK8sServiceOptionInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.RkeK8sServiceOptionLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.RkeK8sServiceOptionLifecycle
	}
	lockRkeK8sServiceOptionInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockRkeK8sServiceOptionInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *RkeK8sServiceOptionInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.RkeK8sServiceOptionHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("RkeK8sServiceOptionInterfaceMock.AddClusterScopedHandlerFunc: method is nil but RkeK8sServiceOptionInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.RkeK8sServiceOptionHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockRkeK8sServiceOptionInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockRkeK8sServiceOptionInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedRkeK8sServiceOptionInterface.AddClusterScopedHandlerCalls())
func (mock *RkeK8sServiceOptionInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.RkeK8sServiceOptionHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.RkeK8sServiceOptionHandlerFunc
	}
	lockRkeK8sServiceOptionInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockRkeK8sServiceOptionInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *RkeK8sServiceOptionInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.RkeK8sServiceOptionLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("RkeK8sServiceOptionInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but RkeK8sServiceOptionInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.RkeK8sServiceOptionLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockRkeK8sServiceOptionInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockRkeK8sServiceOptionInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedRkeK8sServiceOptionInterface.AddClusterScopedLifecycleCalls())
func (mock *RkeK8sServiceOptionInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.RkeK8sServiceOptionLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.RkeK8sServiceOptionLifecycle
	}
	lockRkeK8sServiceOptionInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockRkeK8sServiceOptionInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *RkeK8sServiceOptionInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.RkeK8sServiceOptionHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("RkeK8sServiceOptionInterfaceMock.AddFeatureHandlerFunc: method is nil but RkeK8sServiceOptionInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.RkeK8sServiceOptionHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockRkeK8sServiceOptionInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockRkeK8sServiceOptionInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedRkeK8sServiceOptionInterface.AddFeatureHandlerCalls())
func (mock *RkeK8sServiceOptionInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.RkeK8sServiceOptionHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.RkeK8sServiceOptionHandlerFunc
	}
	lockRkeK8sServiceOptionInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockRkeK8sServiceOptionInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *RkeK8sServiceOptionInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.RkeK8sServiceOptionLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("RkeK8sServiceOptionInterfaceMock.AddFeatureLifecycleFunc: method is nil but RkeK8sServiceOptionInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.RkeK8sServiceOptionLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockRkeK8sServiceOptionInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockRkeK8sServiceOptionInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedRkeK8sServiceOptionInterface.AddFeatureLifecycleCalls())
func (mock *RkeK8sServiceOptionInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.RkeK8sServiceOptionLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.RkeK8sServiceOptionLifecycle
	}
	lockRkeK8sServiceOptionInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockRkeK8sServiceOptionInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *RkeK8sServiceOptionInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.RkeK8sServiceOptionHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("RkeK8sServiceOptionInterfaceMock.AddHandlerFunc: method is nil but RkeK8sServiceOptionInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.RkeK8sServiceOptionHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockRkeK8sServiceOptionInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockRkeK8sServiceOptionInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedRkeK8sServiceOptionInterface.AddHandlerCalls())
func (mock *RkeK8sServiceOptionInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.RkeK8sServiceOptionHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.RkeK8sServiceOptionHandlerFunc
	}
	lockRkeK8sServiceOptionInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockRkeK8sServiceOptionInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *RkeK8sServiceOptionInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.RkeK8sServiceOptionLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("RkeK8sServiceOptionInterfaceMock.AddLifecycleFunc: method is nil but RkeK8sServiceOptionInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.RkeK8sServiceOptionLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockRkeK8sServiceOptionInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockRkeK8sServiceOptionInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedRkeK8sServiceOptionInterface.AddLifecycleCalls())
func (mock *RkeK8sServiceOptionInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.RkeK8sServiceOptionLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.RkeK8sServiceOptionLifecycle
	}
	lockRkeK8sServiceOptionInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockRkeK8sServiceOptionInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *RkeK8sServiceOptionInterfaceMock) Controller() v31.RkeK8sServiceOptionController {
	if mock.ControllerFunc == nil {
		panic("RkeK8sServiceOptionInterfaceMock.ControllerFunc: method is nil but RkeK8sServiceOptionInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockRkeK8sServiceOptionInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockRkeK8sServiceOptionInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedRkeK8sServiceOptionInterface.ControllerCalls())
func (mock *RkeK8sServiceOptionInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockRkeK8sServiceOptionInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockRkeK8sServiceOptionInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *RkeK8sServiceOptionInterfaceMock) Create(in1 *v3.RkeK8sServiceOption) (*v3.RkeK8sServiceOption, error) {
	if mock.CreateFunc == nil {
		panic("RkeK8sServiceOptionInterfaceMock.CreateFunc: method is nil but RkeK8sServiceOptionInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.RkeK8sServiceOption
	}{
		In1: in1,
	}
	lockRkeK8sServiceOptionInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockRkeK8sServiceOptionInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedRkeK8sServiceOptionInterface.CreateCalls())
func (mock *RkeK8sServiceOptionInterfaceMock) CreateCalls() []struct {
	In1 *v3.RkeK8sServiceOption
} {
	var calls []struct {
		In1 *v3.RkeK8sServiceOption
	}
	lockRkeK8sServiceOptionInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockRkeK8sServiceOptionInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *RkeK8sServiceOptionInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("RkeK8sServiceOptionInterfaceMock.DeleteFunc: method is nil but RkeK8sServiceOptionInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockRkeK8sServiceOptionInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockRkeK8sServiceOptionInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedRkeK8sServiceOptionInterface.DeleteCalls())
func (mock *RkeK8sServiceOptionInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockRkeK8sServiceOptionInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockRkeK8sServiceOptionInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *RkeK8sServiceOptionInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("RkeK8sServiceOptionInterfaceMock.DeleteCollectionFunc: method is nil but RkeK8sServiceOptionInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockRkeK8sServiceOptionInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockRkeK8sServiceOptionInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedRkeK8sServiceOptionInterface.DeleteCollectionCalls())
func (mock *RkeK8sServiceOptionInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockRkeK8sServiceOptionInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockRkeK8sServiceOptionInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *RkeK8sServiceOptionInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("RkeK8sServiceOptionInterfaceMock.DeleteNamespacedFunc: method is nil but RkeK8sServiceOptionInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockRkeK8sServiceOptionInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockRkeK8sServiceOptionInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedRkeK8sServiceOptionInterface.DeleteNamespacedCalls())
func (mock *RkeK8sServiceOptionInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockRkeK8sServiceOptionInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockRkeK8sServiceOptionInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *RkeK8sServiceOptionInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.RkeK8sServiceOption, error) {
	if mock.GetFunc == nil {
		panic("RkeK8sServiceOptionInterfaceMock.GetFunc: method is nil but RkeK8sServiceOptionInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockRkeK8sServiceOptionInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockRkeK8sServiceOptionInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedRkeK8sServiceOptionInterface.GetCalls())
func (mock *RkeK8sServiceOptionInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockRkeK8sServiceOptionInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockRkeK8sServiceOptionInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *RkeK8sServiceOptionInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.RkeK8sServiceOption, error) {
	if mock.GetNamespacedFunc == nil {
		panic("RkeK8sServiceOptionInterfaceMock.GetNamespacedFunc: method is nil but RkeK8sServiceOptionInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockRkeK8sServiceOptionInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockRkeK8sServiceOptionInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedRkeK8sServiceOptionInterface.GetNamespacedCalls())
func (mock *RkeK8sServiceOptionInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockRkeK8sServiceOptionInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockRkeK8sServiceOptionInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *RkeK8sServiceOptionInterfaceMock) List(opts metav1.ListOptions) (*v3.RkeK8sServiceOptionList, error) {
	if mock.ListFunc == nil {
		panic("RkeK8sServiceOptionInterfaceMock.ListFunc: method is nil but RkeK8sServiceOptionInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockRkeK8sServiceOptionInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockRkeK8sServiceOptionInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedRkeK8sServiceOptionInterface.ListCalls())
func (mock *RkeK8sServiceOptionInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockRkeK8sServiceOptionInterfaceMockList.RLock()
	calls = mock.calls.List
	lockRkeK8sServiceOptionInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *RkeK8sServiceOptionInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.RkeK8sServiceOptionList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("RkeK8sServiceOptionInterfaceMock.ListNamespacedFunc: method is nil but RkeK8sServiceOptionInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockRkeK8sServiceOptionInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockRkeK8sServiceOptionInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedRkeK8sServiceOptionInterface.ListNamespacedCalls())
func (mock *RkeK8sServiceOptionInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockRkeK8sServiceOptionInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockRkeK8sServiceOptionInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *RkeK8sServiceOptionInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("RkeK8sServiceOptionInterfaceMock.ObjectClientFunc: method is nil but RkeK8sServiceOptionInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockRkeK8sServiceOptionInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockRkeK8sServiceOptionInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedRkeK8sServiceOptionInterface.ObjectClientCalls())
func (mock *RkeK8sServiceOptionInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockRkeK8sServiceOptionInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockRkeK8sServiceOptionInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *RkeK8sServiceOptionInterfaceMock) Update(in1 *v3.RkeK8sServiceOption) (*v3.RkeK8sServiceOption, error) {
	if mock.UpdateFunc == nil {
		panic("RkeK8sServiceOptionInterfaceMock.UpdateFunc: method is nil but RkeK8sServiceOptionInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.RkeK8sServiceOption
	}{
		In1: in1,
	}
	lockRkeK8sServiceOptionInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockRkeK8sServiceOptionInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedRkeK8sServiceOptionInterface.UpdateCalls())
func (mock *RkeK8sServiceOptionInterfaceMock) UpdateCalls() []struct {
	In1 *v3.RkeK8sServiceOption
} {
	var calls []struct {
		In1 *v3.RkeK8sServiceOption
	}
	lockRkeK8sServiceOptionInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockRkeK8sServiceOptionInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *RkeK8sServiceOptionInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("RkeK8sServiceOptionInterfaceMock.WatchFunc: method is nil but RkeK8sServiceOptionInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockRkeK8sServiceOptionInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockRkeK8sServiceOptionInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedRkeK8sServiceOptionInterface.WatchCalls())
func (mock *RkeK8sServiceOptionInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockRkeK8sServiceOptionInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockRkeK8sServiceOptionInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockRkeK8sServiceOptionsGetterMockRkeK8sServiceOptions sync.RWMutex
)

// Ensure, that RkeK8sServiceOptionsGetterMock does implement v31.RkeK8sServiceOptionsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.RkeK8sServiceOptionsGetter = &RkeK8sServiceOptionsGetterMock{}

// RkeK8sServiceOptionsGetterMock is a mock implementation of v31.RkeK8sServiceOptionsGetter.
//
//     func TestSomethingThatUsesRkeK8sServiceOptionsGetter(t *testing.T) {
//
//         // make and configure a mocked v31.RkeK8sServiceOptionsGetter
//         mockedRkeK8sServiceOptionsGetter := &RkeK8sServiceOptionsGetterMock{
//             RkeK8sServiceOptionsFunc: func(namespace string) v31.RkeK8sServiceOptionInterface {
// 	               panic("mock out the RkeK8sServiceOptions method")
//             },
//         }
//
//         // use mockedRkeK8sServiceOptionsGetter in code that requires v31.RkeK8sServiceOptionsGetter
//         // and then make assertions.
//
//     }
type RkeK8sServiceOptionsGetterMock struct {
	// RkeK8sServiceOptionsFunc mocks the RkeK8sServiceOptions method.
	RkeK8sServiceOptionsFunc func(namespace string) v31.RkeK8sServiceOptionInterface

	// calls tracks calls to the methods.
	calls struct {
		// RkeK8sServiceOptions holds details about calls to the RkeK8sServiceOptions method.
		RkeK8sServiceOptions []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// RkeK8sServiceOptions calls RkeK8sServiceOptionsFunc.
func (mock *RkeK8sServiceOptionsGetterMock) RkeK8sServiceOptions(namespace string) v31.RkeK8sServiceOptionInterface {
	if mock.RkeK8sServiceOptionsFunc == nil {
		panic("RkeK8sServiceOptionsGetterMock.RkeK8sServiceOptionsFunc: method is nil but RkeK8sServiceOptionsGetter.RkeK8sServiceOptions was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockRkeK8sServiceOptionsGetterMockRkeK8sServiceOptions.Lock()
	mock.calls.RkeK8sServiceOptions = append(mock.calls.RkeK8sServiceOptions, callInfo)
	lockRkeK8sServiceOptionsGetterMockRkeK8sServiceOptions.Unlock()
	return mock.RkeK8sServiceOptionsFunc(namespace)
}

// RkeK8sServiceOptionsCalls gets all the calls that were made to RkeK8sServiceOptions.
// Check the length with:
//     len(mockedRkeK8sServiceOptionsGetter.RkeK8sServiceOptionsCalls())
func (mock *RkeK8sServiceOptionsGetterMock) RkeK8sServiceOptionsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockRkeK8sServiceOptionsGetterMockRkeK8sServiceOptions.RLock()
	calls = mock.calls.RkeK8sServiceOptions
	lockRkeK8sServiceOptionsGetterMockRkeK8sServiceOptions.RUnlock()
	return calls
}
