// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockRkeK8sSystemImageListerMockGet  sync.RWMutex
	lockRkeK8sSystemImageListerMockList sync.RWMutex
)

// Ensure, that RkeK8sSystemImageListerMock does implement v31.RkeK8sSystemImageLister.
// If this is not the case, regenerate this file with moq.
var _ v31.RkeK8sSystemImageLister = &RkeK8sSystemImageListerMock{}

// RkeK8sSystemImageListerMock is a mock implementation of v31.RkeK8sSystemImageLister.
//
//     func TestSomethingThatUsesRkeK8sSystemImageLister(t *testing.T) {
//
//         // make and configure a mocked v31.RkeK8sSystemImageLister
//         mockedRkeK8sSystemImageLister := &RkeK8sSystemImageListerMock{
//             GetFunc: func(namespace string, name string) (*v3.RkeK8sSystemImage, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.RkeK8sSystemImage, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedRkeK8sSystemImageLister in code that requires v31.RkeK8sSystemImageLister
//         // and then make assertions.
//
//     }
type RkeK8sSystemImageListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.RkeK8sSystemImage, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.RkeK8sSystemImage, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *RkeK8sSystemImageListerMock) Get(namespace string, name string) (*v3.RkeK8sSystemImage, error) {
	if mock.GetFunc == nil {
		panic("RkeK8sSystemImageListerMock.GetFunc: method is nil but RkeK8sSystemImageLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockRkeK8sSystemImageListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockRkeK8sSystemImageListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedRkeK8sSystemImageLister.GetCalls())
func (mock *RkeK8sSystemImageListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockRkeK8sSystemImageListerMockGet.RLock()
	calls = mock.calls.Get
	lockRkeK8sSystemImageListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *RkeK8sSystemImageListerMock) List(namespace string, selector labels.Selector) ([]*v3.RkeK8sSystemImage, error) {
	if mock.ListFunc == nil {
		panic("RkeK8sSystemImageListerMock.ListFunc: method is nil but RkeK8sSystemImageLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockRkeK8sSystemImageListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockRkeK8sSystemImageListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedRkeK8sSystemImageLister.ListCalls())
func (mock *RkeK8sSystemImageListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockRkeK8sSystemImageListerMockList.RLock()
	calls = mock.calls.List
	lockRkeK8sSystemImageListerMockList.RUnlock()
	return calls
}

var (
	lockRkeK8sSystemImageControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockRkeK8sSystemImageControllerMockAddClusterScopedHandler        sync.RWMutex
	lockRkeK8sSystemImageControllerMockAddFeatureHandler              sync.RWMutex
	lockRkeK8sSystemImageControllerMockAddHandler                     sync.RWMutex
	lockRkeK8sSystemImageControllerMockEnqueue                        sync.RWMutex
	lockRkeK8sSystemImageControllerMockEnqueueAfter                   sync.RWMutex
	lockRkeK8sSystemImageControllerMockGeneric                        sync.RWMutex
	lockRkeK8sSystemImageControllerMockInformer                       sync.RWMutex
	lockRkeK8sSystemImageControllerMockLister                         sync.RWMutex
)

// Ensure, that RkeK8sSystemImageControllerMock does implement v31.RkeK8sSystemImageController.
// If this is not the case, regenerate this file with moq.
var _ v31.RkeK8sSystemImageController = &RkeK8sSystemImageControllerMock{}

// RkeK8sSystemImageControllerMock is a mock implementation of v31.RkeK8sSystemImageController.
//
//     func TestSomethingThatUsesRkeK8sSystemImageController(t *testing.T) {
//
//         // make and configure a mocked v31.RkeK8sSystemImageController
//         mockedRkeK8sSystemImageController := &RkeK8sSystemImageControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.RkeK8sSystemImageHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.RkeK8sSystemImageHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.RkeK8sSystemImageHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.RkeK8sSystemImageHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.RkeK8sSystemImageLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedRkeK8sSystemImageController in code that requires v31.RkeK8sSystemImageController
//         // and then make assertions.
//
//     }
type RkeK8sSystemImageControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.RkeK8sSystemImageHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.RkeK8sSystemImageHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.RkeK8sSystemImageHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.RkeK8sSystemImageHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.RkeK8sSystemImageLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.RkeK8sSystemImageHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.RkeK8sSystemImageHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.RkeK8sSystemImageHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.RkeK8sSystemImageHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *RkeK8sSystemImageControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.RkeK8sSystemImageHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("RkeK8sSystemImageControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but RkeK8sSystemImageController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.RkeK8sSystemImageHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockRkeK8sSystemImageControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockRkeK8sSystemImageControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedRkeK8sSystemImageController.AddClusterScopedFeatureHandlerCalls())
func (mock *RkeK8sSystemImageControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.RkeK8sSystemImageHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.RkeK8sSystemImageHandlerFunc
	}
	lockRkeK8sSystemImageControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockRkeK8sSystemImageControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *RkeK8sSystemImageControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.RkeK8sSystemImageHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("RkeK8sSystemImageControllerMock.AddClusterScopedHandlerFunc: method is nil but RkeK8sSystemImageController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.RkeK8sSystemImageHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockRkeK8sSystemImageControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockRkeK8sSystemImageControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedRkeK8sSystemImageController.AddClusterScopedHandlerCalls())
func (mock *RkeK8sSystemImageControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.RkeK8sSystemImageHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.RkeK8sSystemImageHandlerFunc
	}
	lockRkeK8sSystemImageControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockRkeK8sSystemImageControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *RkeK8sSystemImageControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.RkeK8sSystemImageHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("RkeK8sSystemImageControllerMock.AddFeatureHandlerFunc: method is nil but RkeK8sSystemImageController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.RkeK8sSystemImageHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockRkeK8sSystemImageControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockRkeK8sSystemImageControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedRkeK8sSystemImageController.AddFeatureHandlerCalls())
func (mock *RkeK8sSystemImageControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.RkeK8sSystemImageHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.RkeK8sSystemImageHandlerFunc
	}
	lockRkeK8sSystemImageControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockRkeK8sSystemImageControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *RkeK8sSystemImageControllerMock) AddHandler(ctx context.Context, name string, handler v31.RkeK8sSystemImageHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("RkeK8sSystemImageControllerMock.AddHandlerFunc: method is nil but RkeK8sSystemImageController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.RkeK8sSystemImageHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockRkeK8sSystemImageControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockRkeK8sSystemImageControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedRkeK8sSystemImageController.AddHandlerCalls())
func (mock *RkeK8sSystemImageControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.RkeK8sSystemImageHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.RkeK8sSystemImageHandlerFunc
	}
	lockRkeK8sSystemImageControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockRkeK8sSystemImageControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *RkeK8sSystemImageControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("RkeK8sSystemImageControllerMock.EnqueueFunc: method is nil but RkeK8sSystemImageController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockRkeK8sSystemImageControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockRkeK8sSystemImageControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedRkeK8sSystemImageController.EnqueueCalls())
func (mock *RkeK8sSystemImageControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockRkeK8sSystemImageControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockRkeK8sSystemImageControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *RkeK8sSystemImageControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("RkeK8sSystemImageControllerMock.EnqueueAfterFunc: method is nil but RkeK8sSystemImageController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockRkeK8sSystemImageControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockRkeK8sSystemImageControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedRkeK8sSystemImageController.EnqueueAfterCalls())
func (mock *RkeK8sSystemImageControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockRkeK8sSystemImageControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockRkeK8sSystemImageControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *RkeK8sSystemImageControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("RkeK8sSystemImageControllerMock.GenericFunc: method is nil but RkeK8sSystemImageController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockRkeK8sSystemImageControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockRkeK8sSystemImageControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedRkeK8sSystemImageController.GenericCalls())
func (mock *RkeK8sSystemImageControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockRkeK8sSystemImageControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockRkeK8sSystemImageControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *RkeK8sSystemImageControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("RkeK8sSystemImageControllerMock.InformerFunc: method is nil but RkeK8sSystemImageController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockRkeK8sSystemImageControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockRkeK8sSystemImageControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedRkeK8sSystemImageController.InformerCalls())
func (mock *RkeK8sSystemImageControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockRkeK8sSystemImageControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockRkeK8sSystemImageControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *RkeK8sSystemImageControllerMock) Lister() v31.RkeK8sSystemImageLister {
	if mock.ListerFunc == nil {
		panic("RkeK8sSystemImageControllerMock.ListerFunc: method is nil but RkeK8sSystemImageController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockRkeK8sSystemImageControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockRkeK8sSystemImageControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedRkeK8sSystemImageController.ListerCalls())
func (mock *RkeK8sSystemImageControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockRkeK8sSystemImageControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockRkeK8sSystemImageControllerMockLister.RUnlock()
	return calls
}

var (
	lockRkeK8sSystemImageInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockRkeK8sSystemImageInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockRkeK8sSystemImageInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockRkeK8sSystemImageInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockRkeK8sSystemImageInterfaceMockAddFeatureHandler                sync.RWMutex
	lockRkeK8sSystemImageInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockRkeK8sSystemImageInterfaceMockAddHandler                       sync.RWMutex
	lockRkeK8sSystemImageInterfaceMockAddLifecycle                     sync.RWMutex
	lockRkeK8sSystemImageInterfaceMockController                       sync.RWMutex
	lockRkeK8sSystemImageInterfaceMockCreate                           sync.RWMutex
	lockRkeK8sSystemImageInterfaceMockDelete                           sync.RWMutex
	lockRkeK8sSystemImageInterfaceMockDeleteCollection                 sync.RWMutex
	lockRkeK8sSystemImageInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockRkeK8sSystemImageInterfaceMockGet                              sync.RWMutex
	lockRkeK8sSystemImageInterfaceMockGetNamespaced                    sync.RWMutex
	lockRkeK8sSystemImageInterfaceMockList                             sync.RWMutex
	lockRkeK8sSystemImageInterfaceMockListNamespaced                   sync.RWMutex
	lockRkeK8sSystemImageInterfaceMockObjectClient                     sync.RWMutex
	lockRkeK8sSystemImageInterfaceMockUpdate                           sync.RWMutex
	lockRkeK8sSystemImageInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that RkeK8sSystemImageInterfaceMock does implement v31.RkeK8sSystemImageInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.RkeK8sSystemImageInterface = &RkeK8sSystemImageInterfaceMock{}

// RkeK8sSystemImageInterfaceMock is a mock implementation of v31.RkeK8sSystemImageInterface.
//
//     func TestSomethingThatUsesRkeK8sSystemImageInterface(t *testing.T) {
//
//         // make and configure a mocked v31.RkeK8sSystemImageInterface
//         mockedRkeK8sSystemImageInterface := &RkeK8sSystemImageInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.RkeK8sSystemImageHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.RkeK8sSystemImageLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.RkeK8sSystemImageHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.RkeK8sSystemImageLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.RkeK8sSystemImageHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.RkeK8sSystemImageLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.RkeK8sSystemImageHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.RkeK8sSystemImageLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.RkeK8sSystemImageController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.RkeK8sSystemImage) (*v3.RkeK8sSystemImage, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.RkeK8sSystemImage, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.RkeK8sSystemImage, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.RkeK8sSystemImageList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.RkeK8sSystemImageList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.RkeK8sSystemImage) (*v3.RkeK8sSystemImage, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedRkeK8sSystemImageInterface in code that requires v31.RkeK8sSystemImageInterface
//         // and then make assertions.
//
//     }
type RkeK8sSystemImageInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.RkeK8sSystemImageHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.RkeK8sSystemImageLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.RkeK8sSystemImageHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.RkeK8sSystemImageLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.RkeK8sSystemImageHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.RkeK8sSystemImageLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.RkeK8sSystemImageHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.RkeK8sSystemImageLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.RkeK8sSystemImageController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.RkeK8sSystemImage) (*v3.RkeK8sSystemImage, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.RkeK8sSystemImage, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.RkeK8sSystemImage, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.RkeK8sSystemImageList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.RkeK8sSystemImageList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.RkeK8sSystemImage) (*v3.RkeK8sSystemImage, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.RkeK8sSystemImageHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.RkeK8sSystemImageLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.RkeK8sSystemImageHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.RkeK8sSystemImageLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.RkeK8sSystemImageHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.RkeK8sSystemImageLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.RkeK8sSystemImageHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.RkeK8sSystemImageLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.RkeK8sSystemImage
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.RkeK8sSystemImage
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *RkeK8sSystemImageInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.RkeK8sSystemImageHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("RkeK8sSystemImageInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but RkeK8sSystemImageInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.RkeK8sSystemImageHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockRkeK8sSystemImageInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockRkeK8sSystemImageInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedRkeK8sSystemImageInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *RkeK8sSystemImageInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.RkeK8sSystemImageHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.RkeK8sSystemImageHandlerFunc
	}
	lockRkeK8sSystemImageInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockRkeK8sSystemImageInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *RkeK8sSystemImageInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.RkeK8sSystemImageLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("RkeK8sSystemImageInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but RkeK8sSystemImageInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.RkeK8sSystemImageLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockRkeK8sSystemImageInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockRkeK8sSystemImageInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedRkeK8sSystemImageInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *RkeK8sSystemImageInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.RkeK8sSystemImageLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.RkeK8sSystemImageLifecycle
	}
	lockRkeK8sSystemImageInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockRkeK8sSystemImageInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *RkeK8sSystemImageInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.RkeK8sSystemImageHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("RkeK8sSystemImageInterfaceMock.AddClusterScopedHandlerFunc: method is nil but RkeK8sSystemImageInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.RkeK8sSystemImageHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockRkeK8sSystemImageInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockRkeK8sSystemImageInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedRkeK8sSystemImageInterface.AddClusterScopedHandlerCalls())
func (mock *RkeK8sSystemImageInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.RkeK8sSystemImageHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.RkeK8sSystemImageHandlerFunc
	}
	lockRkeK8sSystemImageInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockRkeK8sSystemImageInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *RkeK8sSystemImageInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.RkeK8sSystemImageLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("RkeK8sSystemImageInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but RkeK8sSystemImageInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.RkeK8sSystemImageLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockRkeK8sSystemImageInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockRkeK8sSystemImageInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedRkeK8sSystemImageInterface.AddClusterScopedLifecycleCalls())
func (mock *RkeK8sSystemImageInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.RkeK8sSystemImageLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.RkeK8sSystemImageLifecycle
	}
	lockRkeK8sSystemImageInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockRkeK8sSystemImageInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *RkeK8sSystemImageInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.RkeK8sSystemImageHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("RkeK8sSystemImageInterfaceMock.AddFeatureHandlerFunc: method is nil but RkeK8sSystemImageInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.RkeK8sSystemImageHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockRkeK8sSystemImageInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockRkeK8sSystemImageInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedRkeK8sSystemImageInterface.AddFeatureHandlerCalls())
func (mock *RkeK8sSystemImageInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.RkeK8sSystemImageHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.RkeK8sSystemImageHandlerFunc
	}
	lockRkeK8sSystemImageInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockRkeK8sSystemImageInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *RkeK8sSystemImageInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.RkeK8sSystemImageLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("RkeK8sSystemImageInterfaceMock.AddFeatureLifecycleFunc: method is nil but RkeK8sSystemImageInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.RkeK8sSystemImageLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockRkeK8sSystemImageInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockRkeK8sSystemImageInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedRkeK8sSystemImageInterface.AddFeatureLifecycleCalls())
func (mock *RkeK8sSystemImageInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.RkeK8sSystemImageLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.RkeK8sSystemImageLifecycle
	}
	lockRkeK8sSystemImageInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockRkeK8sSystemImageInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *RkeK8sSystemImageInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.RkeK8sSystemImageHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("RkeK8sSystemImageInterfaceMock.AddHandlerFunc: method is nil but RkeK8sSystemImageInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.RkeK8sSystemImageHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockRkeK8sSystemImageInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockRkeK8sSystemImageInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedRkeK8sSystemImageInterface.AddHandlerCalls())
func (mock *RkeK8sSystemImageInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.RkeK8sSystemImageHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.RkeK8sSystemImageHandlerFunc
	}
	lockRkeK8sSystemImageInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockRkeK8sSystemImageInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *RkeK8sSystemImageInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.RkeK8sSystemImageLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("RkeK8sSystemImageInterfaceMock.AddLifecycleFunc: method is nil but RkeK8sSystemImageInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.RkeK8sSystemImageLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockRkeK8sSystemImageInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockRkeK8sSystemImageInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedRkeK8sSystemImageInterface.AddLifecycleCalls())
func (mock *RkeK8sSystemImageInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.RkeK8sSystemImageLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.RkeK8sSystemImageLifecycle
	}
	lockRkeK8sSystemImageInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockRkeK8sSystemImageInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *RkeK8sSystemImageInterfaceMock) Controller() v31.RkeK8sSystemImageController {
	if mock.ControllerFunc == nil {
		panic("RkeK8sSystemImageInterfaceMock.ControllerFunc: method is nil but RkeK8sSystemImageInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockRkeK8sSystemImageInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockRkeK8sSystemImageInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedRkeK8sSystemImageInterface.ControllerCalls())
func (mock *RkeK8sSystemImageInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockRkeK8sSystemImageInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockRkeK8sSystemImageInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *RkeK8sSystemImageInterfaceMock) Create(in1 *v3.RkeK8sSystemImage) (*v3.RkeK8sSystemImage, error) {
	if mock.CreateFunc == nil {
		panic("RkeK8sSystemImageInterfaceMock.CreateFunc: method is nil but RkeK8sSystemImageInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.RkeK8sSystemImage
	}{
		In1: in1,
	}
	lockRkeK8sSystemImageInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockRkeK8sSystemImageInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedRkeK8sSystemImageInterface.CreateCalls())
func (mock *RkeK8sSystemImageInterfaceMock) CreateCalls() []struct {
	In1 *v3.RkeK8sSystemImage
} {
	var calls []struct {
		In1 *v3.RkeK8sSystemImage
	}
	lockRkeK8sSystemImageInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockRkeK8sSystemImageInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *RkeK8sSystemImageInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("RkeK8sSystemImageInterfaceMock.DeleteFunc: method is nil but RkeK8sSystemImageInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockRkeK8sSystemImageInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockRkeK8sSystemImageInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedRkeK8sSystemImageInterface.DeleteCalls())
func (mock *RkeK8sSystemImageInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockRkeK8sSystemImageInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockRkeK8sSystemImageInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *RkeK8sSystemImageInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("RkeK8sSystemImageInterfaceMock.DeleteCollectionFunc: method is nil but RkeK8sSystemImageInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockRkeK8sSystemImageInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockRkeK8sSystemImageInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedRkeK8sSystemImageInterface.DeleteCollectionCalls())
func (mock *RkeK8sSystemImageInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockRkeK8sSystemImageInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockRkeK8sSystemImageInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *RkeK8sSystemImageInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("RkeK8sSystemImageInterfaceMock.DeleteNamespacedFunc: method is nil but RkeK8sSystemImageInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockRkeK8sSystemImageInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockRkeK8sSystemImageInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedRkeK8sSystemImageInterface.DeleteNamespacedCalls())
func (mock *RkeK8sSystemImageInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockRkeK8sSystemImageInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockRkeK8sSystemImageInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *RkeK8sSystemImageInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.RkeK8sSystemImage, error) {
	if mock.GetFunc == nil {
		panic("RkeK8sSystemImageInterfaceMock.GetFunc: method is nil but RkeK8sSystemImageInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockRkeK8sSystemImageInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockRkeK8sSystemImageInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedRkeK8sSystemImageInterface.GetCalls())
func (mock *RkeK8sSystemImageInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockRkeK8sSystemImageInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockRkeK8sSystemImageInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *RkeK8sSystemImageInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.RkeK8sSystemImage, error) {
	if mock.GetNamespacedFunc == nil {
		panic("RkeK8sSystemImageInterfaceMock.GetNamespacedFunc: method is nil but RkeK8sSystemImageInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockRkeK8sSystemImageInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockRkeK8sSystemImageInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedRkeK8sSystemImageInterface.GetNamespacedCalls())
func (mock *RkeK8sSystemImageInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockRkeK8sSystemImageInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockRkeK8sSystemImageInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *RkeK8sSystemImageInterfaceMock) List(opts metav1.ListOptions) (*v3.RkeK8sSystemImageList, error) {
	if mock.ListFunc == nil {
		panic("RkeK8sSystemImageInterfaceMock.ListFunc: method is nil but RkeK8sSystemImageInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockRkeK8sSystemImageInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockRkeK8sSystemImageInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedRkeK8sSystemImageInterface.ListCalls())
func (mock *RkeK8sSystemImageInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockRkeK8sSystemImageInterfaceMockList.RLock()
	calls = mock.calls.List
	lockRkeK8sSystemImageInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *RkeK8sSystemImageInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.RkeK8sSystemImageList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("RkeK8sSystemImageInterfaceMock.ListNamespacedFunc: method is nil but RkeK8sSystemImageInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockRkeK8sSystemImageInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockRkeK8sSystemImageInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedRkeK8sSystemImageInterface.ListNamespacedCalls())
func (mock *RkeK8sSystemImageInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockRkeK8sSystemImageInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockRkeK8sSystemImageInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *RkeK8sSystemImageInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("RkeK8sSystemImageInterfaceMock.ObjectClientFunc: method is nil but RkeK8sSystemImageInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockRkeK8sSystemImageInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockRkeK8sSystemImageInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedRkeK8sSystemImageInterface.ObjectClientCalls())
func (mock *RkeK8sSystemImageInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockRkeK8sSystemImageInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockRkeK8sSystemImageInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *RkeK8sSystemImageInterfaceMock) Update(in1 *v3.RkeK8sSystemImage) (*v3.RkeK8sSystemImage, error) {
	if mock.UpdateFunc == nil {
		panic("RkeK8sSystemImageInterfaceMock.UpdateFunc: method is nil but RkeK8sSystemImageInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.RkeK8sSystemImage
	}{
		In1: in1,
	}
	lockRkeK8sSystemImageInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockRkeK8sSystemImageInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedRkeK8sSystemImageInterface.UpdateCalls())
func (mock *RkeK8sSystemImageInterfaceMock) UpdateCalls() []struct {
	In1 *v3.RkeK8sSystemImage
} {
	var calls []struct {
		In1 *v3.RkeK8sSystemImage
	}
	lockRkeK8sSystemImageInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockRkeK8sSystemImageInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *RkeK8sSystemImageInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("RkeK8sSystemImageInterfaceMock.WatchFunc: method is nil but RkeK8sSystemImageInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockRkeK8sSystemImageInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockRkeK8sSystemImageInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedRkeK8sSystemImageInterface.WatchCalls())
func (mock *RkeK8sSystemImageInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockRkeK8sSystemImageInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockRkeK8sSystemImageInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockRkeK8sSystemImagesGetterMockRkeK8sSystemImages sync.RWMutex
)

// Ensure, that RkeK8sSystemImagesGetterMock does implement v31.RkeK8sSystemImagesGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.RkeK8sSystemImagesGetter = &RkeK8sSystemImagesGetterMock{}

// RkeK8sSystemImagesGetterMock is a mock implementation of v31.RkeK8sSystemImagesGetter.
//
//     func TestSomethingThatUsesRkeK8sSystemImagesGetter(t *testing.T) {
//
//         // make and configure a mocked v31.RkeK8sSystemImagesGetter
//         mockedRkeK8sSystemImagesGetter := &RkeK8sSystemImagesGetterMock{
//             RkeK8sSystemImagesFunc: func(namespace string) v31.RkeK8sSystemImageInterface {
// 	               panic("mock out the RkeK8sSystemImages method")
//             },
//         }
//
//         // use mockedRkeK8sSystemImagesGetter in code that requires v31.RkeK8sSystemImagesGetter
//         // and then make assertions.
//
//     }
type RkeK8sSystemImagesGetterMock struct {
	// RkeK8sSystemImagesFunc mocks the RkeK8sSystemImages method.
	RkeK8sSystemImagesFunc func(namespace string) v31.RkeK8sSystemImageInterface

	// calls tracks calls to the methods.
	calls struct {
		// RkeK8sSystemImages holds details about calls to the RkeK8sSystemImages method.
		RkeK8sSystemImages []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// RkeK8sSystemImages calls RkeK8sSystemImagesFunc.
func (mock *RkeK8sSystemImagesGetterMock) RkeK8sSystemImages(namespace string) v31.RkeK8sSystemImageInterface {
	if mock.RkeK8sSystemImagesFunc == nil {
		panic("RkeK8sSystemImagesGetterMock.RkeK8sSystemImagesFunc: method is nil but RkeK8sSystemImagesGetter.RkeK8sSystemImages was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockRkeK8sSystemImagesGetterMockRkeK8sSystemImages.Lock()
	mock.calls.RkeK8sSystemImages = append(mock.calls.RkeK8sSystemImages, callInfo)
	lockRkeK8sSystemImagesGetterMockRkeK8sSystemImages.Unlock()
	return mock.RkeK8sSystemImagesFunc(namespace)
}

// RkeK8sSystemImagesCalls gets all the calls that were made to RkeK8sSystemImages.
// Check the length with:
//     len(mockedRkeK8sSystemImagesGetter.RkeK8sSystemImagesCalls())
func (mock *RkeK8sSystemImagesGetterMock) RkeK8sSystemImagesCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockRkeK8sSystemImagesGetterMockRkeK8sSystemImages.RLock()
	calls = mock.calls.RkeK8sSystemImages
	lockRkeK8sSystemImagesGetterMockRkeK8sSystemImages.RUnlock()
	return calls
}
