// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockTemplateContentListerMockGet  sync.RWMutex
	lockTemplateContentListerMockList sync.RWMutex
)

// Ensure, that TemplateContentListerMock does implement v31.TemplateContentLister.
// If this is not the case, regenerate this file with moq.
var _ v31.TemplateContentLister = &TemplateContentListerMock{}

// TemplateContentListerMock is a mock implementation of v31.TemplateContentLister.
//
//     func TestSomethingThatUsesTemplateContentLister(t *testing.T) {
//
//         // make and configure a mocked v31.TemplateContentLister
//         mockedTemplateContentLister := &TemplateContentListerMock{
//             GetFunc: func(namespace string, name string) (*v3.TemplateContent, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.TemplateContent, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedTemplateContentLister in code that requires v31.TemplateContentLister
//         // and then make assertions.
//
//     }
type TemplateContentListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.TemplateContent, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.TemplateContent, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *TemplateContentListerMock) Get(namespace string, name string) (*v3.TemplateContent, error) {
	if mock.GetFunc == nil {
		panic("TemplateContentListerMock.GetFunc: method is nil but TemplateContentLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockTemplateContentListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockTemplateContentListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedTemplateContentLister.GetCalls())
func (mock *TemplateContentListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockTemplateContentListerMockGet.RLock()
	calls = mock.calls.Get
	lockTemplateContentListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *TemplateContentListerMock) List(namespace string, selector labels.Selector) ([]*v3.TemplateContent, error) {
	if mock.ListFunc == nil {
		panic("TemplateContentListerMock.ListFunc: method is nil but TemplateContentLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockTemplateContentListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockTemplateContentListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedTemplateContentLister.ListCalls())
func (mock *TemplateContentListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockTemplateContentListerMockList.RLock()
	calls = mock.calls.List
	lockTemplateContentListerMockList.RUnlock()
	return calls
}

var (
	lockTemplateContentControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockTemplateContentControllerMockAddClusterScopedHandler        sync.RWMutex
	lockTemplateContentControllerMockAddFeatureHandler              sync.RWMutex
	lockTemplateContentControllerMockAddHandler                     sync.RWMutex
	lockTemplateContentControllerMockEnqueue                        sync.RWMutex
	lockTemplateContentControllerMockEnqueueAfter                   sync.RWMutex
	lockTemplateContentControllerMockGeneric                        sync.RWMutex
	lockTemplateContentControllerMockInformer                       sync.RWMutex
	lockTemplateContentControllerMockLister                         sync.RWMutex
)

// Ensure, that TemplateContentControllerMock does implement v31.TemplateContentController.
// If this is not the case, regenerate this file with moq.
var _ v31.TemplateContentController = &TemplateContentControllerMock{}

// TemplateContentControllerMock is a mock implementation of v31.TemplateContentController.
//
//     func TestSomethingThatUsesTemplateContentController(t *testing.T) {
//
//         // make and configure a mocked v31.TemplateContentController
//         mockedTemplateContentController := &TemplateContentControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.TemplateContentHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.TemplateContentHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.TemplateContentHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.TemplateContentHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.TemplateContentLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedTemplateContentController in code that requires v31.TemplateContentController
//         // and then make assertions.
//
//     }
type TemplateContentControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.TemplateContentHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.TemplateContentHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.TemplateContentHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.TemplateContentHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.TemplateContentLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.TemplateContentHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.TemplateContentHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.TemplateContentHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.TemplateContentHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *TemplateContentControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.TemplateContentHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("TemplateContentControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but TemplateContentController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.TemplateContentHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockTemplateContentControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockTemplateContentControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedTemplateContentController.AddClusterScopedFeatureHandlerCalls())
func (mock *TemplateContentControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.TemplateContentHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.TemplateContentHandlerFunc
	}
	lockTemplateContentControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockTemplateContentControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *TemplateContentControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.TemplateContentHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("TemplateContentControllerMock.AddClusterScopedHandlerFunc: method is nil but TemplateContentController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.TemplateContentHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockTemplateContentControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockTemplateContentControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedTemplateContentController.AddClusterScopedHandlerCalls())
func (mock *TemplateContentControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.TemplateContentHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.TemplateContentHandlerFunc
	}
	lockTemplateContentControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockTemplateContentControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *TemplateContentControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.TemplateContentHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("TemplateContentControllerMock.AddFeatureHandlerFunc: method is nil but TemplateContentController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.TemplateContentHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockTemplateContentControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockTemplateContentControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedTemplateContentController.AddFeatureHandlerCalls())
func (mock *TemplateContentControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.TemplateContentHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.TemplateContentHandlerFunc
	}
	lockTemplateContentControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockTemplateContentControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *TemplateContentControllerMock) AddHandler(ctx context.Context, name string, handler v31.TemplateContentHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("TemplateContentControllerMock.AddHandlerFunc: method is nil but TemplateContentController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.TemplateContentHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockTemplateContentControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockTemplateContentControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedTemplateContentController.AddHandlerCalls())
func (mock *TemplateContentControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.TemplateContentHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.TemplateContentHandlerFunc
	}
	lockTemplateContentControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockTemplateContentControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *TemplateContentControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("TemplateContentControllerMock.EnqueueFunc: method is nil but TemplateContentController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockTemplateContentControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockTemplateContentControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedTemplateContentController.EnqueueCalls())
func (mock *TemplateContentControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockTemplateContentControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockTemplateContentControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *TemplateContentControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("TemplateContentControllerMock.EnqueueAfterFunc: method is nil but TemplateContentController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockTemplateContentControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockTemplateContentControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedTemplateContentController.EnqueueAfterCalls())
func (mock *TemplateContentControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockTemplateContentControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockTemplateContentControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *TemplateContentControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("TemplateContentControllerMock.GenericFunc: method is nil but TemplateContentController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockTemplateContentControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockTemplateContentControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedTemplateContentController.GenericCalls())
func (mock *TemplateContentControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockTemplateContentControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockTemplateContentControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *TemplateContentControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("TemplateContentControllerMock.InformerFunc: method is nil but TemplateContentController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockTemplateContentControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockTemplateContentControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedTemplateContentController.InformerCalls())
func (mock *TemplateContentControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockTemplateContentControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockTemplateContentControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *TemplateContentControllerMock) Lister() v31.TemplateContentLister {
	if mock.ListerFunc == nil {
		panic("TemplateContentControllerMock.ListerFunc: method is nil but TemplateContentController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockTemplateContentControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockTemplateContentControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedTemplateContentController.ListerCalls())
func (mock *TemplateContentControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockTemplateContentControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockTemplateContentControllerMockLister.RUnlock()
	return calls
}

var (
	lockTemplateContentInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockTemplateContentInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockTemplateContentInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockTemplateContentInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockTemplateContentInterfaceMockAddFeatureHandler                sync.RWMutex
	lockTemplateContentInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockTemplateContentInterfaceMockAddHandler                       sync.RWMutex
	lockTemplateContentInterfaceMockAddLifecycle                     sync.RWMutex
	lockTemplateContentInterfaceMockController                       sync.RWMutex
	lockTemplateContentInterfaceMockCreate                           sync.RWMutex
	lockTemplateContentInterfaceMockDelete                           sync.RWMutex
	lockTemplateContentInterfaceMockDeleteCollection                 sync.RWMutex
	lockTemplateContentInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockTemplateContentInterfaceMockGet                              sync.RWMutex
	lockTemplateContentInterfaceMockGetNamespaced                    sync.RWMutex
	lockTemplateContentInterfaceMockList                             sync.RWMutex
	lockTemplateContentInterfaceMockListNamespaced                   sync.RWMutex
	lockTemplateContentInterfaceMockObjectClient                     sync.RWMutex
	lockTemplateContentInterfaceMockUpdate                           sync.RWMutex
	lockTemplateContentInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that TemplateContentInterfaceMock does implement v31.TemplateContentInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.TemplateContentInterface = &TemplateContentInterfaceMock{}

// TemplateContentInterfaceMock is a mock implementation of v31.TemplateContentInterface.
//
//     func TestSomethingThatUsesTemplateContentInterface(t *testing.T) {
//
//         // make and configure a mocked v31.TemplateContentInterface
//         mockedTemplateContentInterface := &TemplateContentInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.TemplateContentHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.TemplateContentLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.TemplateContentHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.TemplateContentLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.TemplateContentHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.TemplateContentLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.TemplateContentHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.TemplateContentLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.TemplateContentController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.TemplateContent) (*v3.TemplateContent, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.TemplateContent, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.TemplateContent, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.TemplateContentList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.TemplateContentList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.TemplateContent) (*v3.TemplateContent, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedTemplateContentInterface in code that requires v31.TemplateContentInterface
//         // and then make assertions.
//
//     }
type TemplateContentInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.TemplateContentHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.TemplateContentLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.TemplateContentHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.TemplateContentLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.TemplateContentHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.TemplateContentLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.TemplateContentHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.TemplateContentLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.TemplateContentController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.TemplateContent) (*v3.TemplateContent, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.TemplateContent, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.TemplateContent, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.TemplateContentList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.TemplateContentList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.TemplateContent) (*v3.TemplateContent, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.TemplateContentHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.TemplateContentLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.TemplateContentHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.TemplateContentLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.TemplateContentHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.TemplateContentLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.TemplateContentHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.TemplateContentLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.TemplateContent
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.TemplateContent
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *TemplateContentInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.TemplateContentHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("TemplateContentInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but TemplateContentInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.TemplateContentHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockTemplateContentInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockTemplateContentInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedTemplateContentInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *TemplateContentInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.TemplateContentHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.TemplateContentHandlerFunc
	}
	lockTemplateContentInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockTemplateContentInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *TemplateContentInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.TemplateContentLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("TemplateContentInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but TemplateContentInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.TemplateContentLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockTemplateContentInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockTemplateContentInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedTemplateContentInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *TemplateContentInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.TemplateContentLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.TemplateContentLifecycle
	}
	lockTemplateContentInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockTemplateContentInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *TemplateContentInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.TemplateContentHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("TemplateContentInterfaceMock.AddClusterScopedHandlerFunc: method is nil but TemplateContentInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.TemplateContentHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockTemplateContentInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockTemplateContentInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedTemplateContentInterface.AddClusterScopedHandlerCalls())
func (mock *TemplateContentInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.TemplateContentHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.TemplateContentHandlerFunc
	}
	lockTemplateContentInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockTemplateContentInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *TemplateContentInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.TemplateContentLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("TemplateContentInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but TemplateContentInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.TemplateContentLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockTemplateContentInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockTemplateContentInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedTemplateContentInterface.AddClusterScopedLifecycleCalls())
func (mock *TemplateContentInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.TemplateContentLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.TemplateContentLifecycle
	}
	lockTemplateContentInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockTemplateContentInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *TemplateContentInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.TemplateContentHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("TemplateContentInterfaceMock.AddFeatureHandlerFunc: method is nil but TemplateContentInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.TemplateContentHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockTemplateContentInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockTemplateContentInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedTemplateContentInterface.AddFeatureHandlerCalls())
func (mock *TemplateContentInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.TemplateContentHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.TemplateContentHandlerFunc
	}
	lockTemplateContentInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockTemplateContentInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *TemplateContentInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.TemplateContentLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("TemplateContentInterfaceMock.AddFeatureLifecycleFunc: method is nil but TemplateContentInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.TemplateContentLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockTemplateContentInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockTemplateContentInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedTemplateContentInterface.AddFeatureLifecycleCalls())
func (mock *TemplateContentInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.TemplateContentLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.TemplateContentLifecycle
	}
	lockTemplateContentInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockTemplateContentInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *TemplateContentInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.TemplateContentHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("TemplateContentInterfaceMock.AddHandlerFunc: method is nil but TemplateContentInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.TemplateContentHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockTemplateContentInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockTemplateContentInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedTemplateContentInterface.AddHandlerCalls())
func (mock *TemplateContentInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.TemplateContentHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.TemplateContentHandlerFunc
	}
	lockTemplateContentInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockTemplateContentInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *TemplateContentInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.TemplateContentLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("TemplateContentInterfaceMock.AddLifecycleFunc: method is nil but TemplateContentInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.TemplateContentLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockTemplateContentInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockTemplateContentInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedTemplateContentInterface.AddLifecycleCalls())
func (mock *TemplateContentInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.TemplateContentLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.TemplateContentLifecycle
	}
	lockTemplateContentInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockTemplateContentInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *TemplateContentInterfaceMock) Controller() v31.TemplateContentController {
	if mock.ControllerFunc == nil {
		panic("TemplateContentInterfaceMock.ControllerFunc: method is nil but TemplateContentInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockTemplateContentInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockTemplateContentInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedTemplateContentInterface.ControllerCalls())
func (mock *TemplateContentInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockTemplateContentInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockTemplateContentInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *TemplateContentInterfaceMock) Create(in1 *v3.TemplateContent) (*v3.TemplateContent, error) {
	if mock.CreateFunc == nil {
		panic("TemplateContentInterfaceMock.CreateFunc: method is nil but TemplateContentInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.TemplateContent
	}{
		In1: in1,
	}
	lockTemplateContentInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockTemplateContentInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedTemplateContentInterface.CreateCalls())
func (mock *TemplateContentInterfaceMock) CreateCalls() []struct {
	In1 *v3.TemplateContent
} {
	var calls []struct {
		In1 *v3.TemplateContent
	}
	lockTemplateContentInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockTemplateContentInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *TemplateContentInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("TemplateContentInterfaceMock.DeleteFunc: method is nil but TemplateContentInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockTemplateContentInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockTemplateContentInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedTemplateContentInterface.DeleteCalls())
func (mock *TemplateContentInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockTemplateContentInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockTemplateContentInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *TemplateContentInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("TemplateContentInterfaceMock.DeleteCollectionFunc: method is nil but TemplateContentInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockTemplateContentInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockTemplateContentInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedTemplateContentInterface.DeleteCollectionCalls())
func (mock *TemplateContentInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockTemplateContentInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockTemplateContentInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *TemplateContentInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("TemplateContentInterfaceMock.DeleteNamespacedFunc: method is nil but TemplateContentInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockTemplateContentInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockTemplateContentInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedTemplateContentInterface.DeleteNamespacedCalls())
func (mock *TemplateContentInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockTemplateContentInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockTemplateContentInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *TemplateContentInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.TemplateContent, error) {
	if mock.GetFunc == nil {
		panic("TemplateContentInterfaceMock.GetFunc: method is nil but TemplateContentInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockTemplateContentInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockTemplateContentInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedTemplateContentInterface.GetCalls())
func (mock *TemplateContentInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockTemplateContentInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockTemplateContentInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *TemplateContentInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.TemplateContent, error) {
	if mock.GetNamespacedFunc == nil {
		panic("TemplateContentInterfaceMock.GetNamespacedFunc: method is nil but TemplateContentInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockTemplateContentInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockTemplateContentInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedTemplateContentInterface.GetNamespacedCalls())
func (mock *TemplateContentInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockTemplateContentInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockTemplateContentInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *TemplateContentInterfaceMock) List(opts metav1.ListOptions) (*v3.TemplateContentList, error) {
	if mock.ListFunc == nil {
		panic("TemplateContentInterfaceMock.ListFunc: method is nil but TemplateContentInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockTemplateContentInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockTemplateContentInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedTemplateContentInterface.ListCalls())
func (mock *TemplateContentInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockTemplateContentInterfaceMockList.RLock()
	calls = mock.calls.List
	lockTemplateContentInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *TemplateContentInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.TemplateContentList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("TemplateContentInterfaceMock.ListNamespacedFunc: method is nil but TemplateContentInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockTemplateContentInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockTemplateContentInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedTemplateContentInterface.ListNamespacedCalls())
func (mock *TemplateContentInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockTemplateContentInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockTemplateContentInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *TemplateContentInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("TemplateContentInterfaceMock.ObjectClientFunc: method is nil but TemplateContentInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockTemplateContentInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockTemplateContentInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedTemplateContentInterface.ObjectClientCalls())
func (mock *TemplateContentInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockTemplateContentInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockTemplateContentInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *TemplateContentInterfaceMock) Update(in1 *v3.TemplateContent) (*v3.TemplateContent, error) {
	if mock.UpdateFunc == nil {
		panic("TemplateContentInterfaceMock.UpdateFunc: method is nil but TemplateContentInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.TemplateContent
	}{
		In1: in1,
	}
	lockTemplateContentInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockTemplateContentInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedTemplateContentInterface.UpdateCalls())
func (mock *TemplateContentInterfaceMock) UpdateCalls() []struct {
	In1 *v3.TemplateContent
} {
	var calls []struct {
		In1 *v3.TemplateContent
	}
	lockTemplateContentInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockTemplateContentInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *TemplateContentInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("TemplateContentInterfaceMock.WatchFunc: method is nil but TemplateContentInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockTemplateContentInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockTemplateContentInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedTemplateContentInterface.WatchCalls())
func (mock *TemplateContentInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockTemplateContentInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockTemplateContentInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockTemplateContentsGetterMockTemplateContents sync.RWMutex
)

// Ensure, that TemplateContentsGetterMock does implement v31.TemplateContentsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.TemplateContentsGetter = &TemplateContentsGetterMock{}

// TemplateContentsGetterMock is a mock implementation of v31.TemplateContentsGetter.
//
//     func TestSomethingThatUsesTemplateContentsGetter(t *testing.T) {
//
//         // make and configure a mocked v31.TemplateContentsGetter
//         mockedTemplateContentsGetter := &TemplateContentsGetterMock{
//             TemplateContentsFunc: func(namespace string) v31.TemplateContentInterface {
// 	               panic("mock out the TemplateContents method")
//             },
//         }
//
//         // use mockedTemplateContentsGetter in code that requires v31.TemplateContentsGetter
//         // and then make assertions.
//
//     }
type TemplateContentsGetterMock struct {
	// TemplateContentsFunc mocks the TemplateContents method.
	TemplateContentsFunc func(namespace string) v31.TemplateContentInterface

	// calls tracks calls to the methods.
	calls struct {
		// TemplateContents holds details about calls to the TemplateContents method.
		TemplateContents []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// TemplateContents calls TemplateContentsFunc.
func (mock *TemplateContentsGetterMock) TemplateContents(namespace string) v31.TemplateContentInterface {
	if mock.TemplateContentsFunc == nil {
		panic("TemplateContentsGetterMock.TemplateContentsFunc: method is nil but TemplateContentsGetter.TemplateContents was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockTemplateContentsGetterMockTemplateContents.Lock()
	mock.calls.TemplateContents = append(mock.calls.TemplateContents, callInfo)
	lockTemplateContentsGetterMockTemplateContents.Unlock()
	return mock.TemplateContentsFunc(namespace)
}

// TemplateContentsCalls gets all the calls that were made to TemplateContents.
// Check the length with:
//     len(mockedTemplateContentsGetter.TemplateContentsCalls())
func (mock *TemplateContentsGetterMock) TemplateContentsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockTemplateContentsGetterMockTemplateContents.RLock()
	calls = mock.calls.TemplateContents
	lockTemplateContentsGetterMockTemplateContents.RUnlock()
	return calls
}
