// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v3 "github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	v31 "github.com/rancher/rancher/pkg/generated/norman/management.cattle.io/v3"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockTemplateVersionListerMockGet  sync.RWMutex
	lockTemplateVersionListerMockList sync.RWMutex
)

// Ensure, that TemplateVersionListerMock does implement v31.TemplateVersionLister.
// If this is not the case, regenerate this file with moq.
var _ v31.TemplateVersionLister = &TemplateVersionListerMock{}

// TemplateVersionListerMock is a mock implementation of v31.TemplateVersionLister.
//
//     func TestSomethingThatUsesTemplateVersionLister(t *testing.T) {
//
//         // make and configure a mocked v31.TemplateVersionLister
//         mockedTemplateVersionLister := &TemplateVersionListerMock{
//             GetFunc: func(namespace string, name string) (*v3.TemplateVersion, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v3.TemplateVersion, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedTemplateVersionLister in code that requires v31.TemplateVersionLister
//         // and then make assertions.
//
//     }
type TemplateVersionListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v3.TemplateVersion, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v3.TemplateVersion, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *TemplateVersionListerMock) Get(namespace string, name string) (*v3.TemplateVersion, error) {
	if mock.GetFunc == nil {
		panic("TemplateVersionListerMock.GetFunc: method is nil but TemplateVersionLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockTemplateVersionListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockTemplateVersionListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedTemplateVersionLister.GetCalls())
func (mock *TemplateVersionListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockTemplateVersionListerMockGet.RLock()
	calls = mock.calls.Get
	lockTemplateVersionListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *TemplateVersionListerMock) List(namespace string, selector labels.Selector) ([]*v3.TemplateVersion, error) {
	if mock.ListFunc == nil {
		panic("TemplateVersionListerMock.ListFunc: method is nil but TemplateVersionLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockTemplateVersionListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockTemplateVersionListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedTemplateVersionLister.ListCalls())
func (mock *TemplateVersionListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockTemplateVersionListerMockList.RLock()
	calls = mock.calls.List
	lockTemplateVersionListerMockList.RUnlock()
	return calls
}

var (
	lockTemplateVersionControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockTemplateVersionControllerMockAddClusterScopedHandler        sync.RWMutex
	lockTemplateVersionControllerMockAddFeatureHandler              sync.RWMutex
	lockTemplateVersionControllerMockAddHandler                     sync.RWMutex
	lockTemplateVersionControllerMockEnqueue                        sync.RWMutex
	lockTemplateVersionControllerMockEnqueueAfter                   sync.RWMutex
	lockTemplateVersionControllerMockGeneric                        sync.RWMutex
	lockTemplateVersionControllerMockInformer                       sync.RWMutex
	lockTemplateVersionControllerMockLister                         sync.RWMutex
)

// Ensure, that TemplateVersionControllerMock does implement v31.TemplateVersionController.
// If this is not the case, regenerate this file with moq.
var _ v31.TemplateVersionController = &TemplateVersionControllerMock{}

// TemplateVersionControllerMock is a mock implementation of v31.TemplateVersionController.
//
//     func TestSomethingThatUsesTemplateVersionController(t *testing.T) {
//
//         // make and configure a mocked v31.TemplateVersionController
//         mockedTemplateVersionController := &TemplateVersionControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.TemplateVersionHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v31.TemplateVersionHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.TemplateVersionHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v31.TemplateVersionHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v31.TemplateVersionLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedTemplateVersionController in code that requires v31.TemplateVersionController
//         // and then make assertions.
//
//     }
type TemplateVersionControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.TemplateVersionHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v31.TemplateVersionHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.TemplateVersionHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v31.TemplateVersionHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v31.TemplateVersionLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.TemplateVersionHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v31.TemplateVersionHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.TemplateVersionHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v31.TemplateVersionHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *TemplateVersionControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v31.TemplateVersionHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("TemplateVersionControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but TemplateVersionController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.TemplateVersionHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockTemplateVersionControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockTemplateVersionControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedTemplateVersionController.AddClusterScopedFeatureHandlerCalls())
func (mock *TemplateVersionControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v31.TemplateVersionHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v31.TemplateVersionHandlerFunc
	}
	lockTemplateVersionControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockTemplateVersionControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *TemplateVersionControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v31.TemplateVersionHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("TemplateVersionControllerMock.AddClusterScopedHandlerFunc: method is nil but TemplateVersionController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.TemplateVersionHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockTemplateVersionControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockTemplateVersionControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedTemplateVersionController.AddClusterScopedHandlerCalls())
func (mock *TemplateVersionControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v31.TemplateVersionHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v31.TemplateVersionHandlerFunc
	}
	lockTemplateVersionControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockTemplateVersionControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *TemplateVersionControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.TemplateVersionHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("TemplateVersionControllerMock.AddFeatureHandlerFunc: method is nil but TemplateVersionController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.TemplateVersionHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockTemplateVersionControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockTemplateVersionControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedTemplateVersionController.AddFeatureHandlerCalls())
func (mock *TemplateVersionControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.TemplateVersionHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.TemplateVersionHandlerFunc
	}
	lockTemplateVersionControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockTemplateVersionControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *TemplateVersionControllerMock) AddHandler(ctx context.Context, name string, handler v31.TemplateVersionHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("TemplateVersionControllerMock.AddHandlerFunc: method is nil but TemplateVersionController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v31.TemplateVersionHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockTemplateVersionControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockTemplateVersionControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedTemplateVersionController.AddHandlerCalls())
func (mock *TemplateVersionControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v31.TemplateVersionHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v31.TemplateVersionHandlerFunc
	}
	lockTemplateVersionControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockTemplateVersionControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *TemplateVersionControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("TemplateVersionControllerMock.EnqueueFunc: method is nil but TemplateVersionController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockTemplateVersionControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockTemplateVersionControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedTemplateVersionController.EnqueueCalls())
func (mock *TemplateVersionControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockTemplateVersionControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockTemplateVersionControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *TemplateVersionControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("TemplateVersionControllerMock.EnqueueAfterFunc: method is nil but TemplateVersionController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockTemplateVersionControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockTemplateVersionControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedTemplateVersionController.EnqueueAfterCalls())
func (mock *TemplateVersionControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockTemplateVersionControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockTemplateVersionControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *TemplateVersionControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("TemplateVersionControllerMock.GenericFunc: method is nil but TemplateVersionController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockTemplateVersionControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockTemplateVersionControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedTemplateVersionController.GenericCalls())
func (mock *TemplateVersionControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockTemplateVersionControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockTemplateVersionControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *TemplateVersionControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("TemplateVersionControllerMock.InformerFunc: method is nil but TemplateVersionController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockTemplateVersionControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockTemplateVersionControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedTemplateVersionController.InformerCalls())
func (mock *TemplateVersionControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockTemplateVersionControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockTemplateVersionControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *TemplateVersionControllerMock) Lister() v31.TemplateVersionLister {
	if mock.ListerFunc == nil {
		panic("TemplateVersionControllerMock.ListerFunc: method is nil but TemplateVersionController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockTemplateVersionControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockTemplateVersionControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedTemplateVersionController.ListerCalls())
func (mock *TemplateVersionControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockTemplateVersionControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockTemplateVersionControllerMockLister.RUnlock()
	return calls
}

var (
	lockTemplateVersionInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockTemplateVersionInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockTemplateVersionInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockTemplateVersionInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockTemplateVersionInterfaceMockAddFeatureHandler                sync.RWMutex
	lockTemplateVersionInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockTemplateVersionInterfaceMockAddHandler                       sync.RWMutex
	lockTemplateVersionInterfaceMockAddLifecycle                     sync.RWMutex
	lockTemplateVersionInterfaceMockController                       sync.RWMutex
	lockTemplateVersionInterfaceMockCreate                           sync.RWMutex
	lockTemplateVersionInterfaceMockDelete                           sync.RWMutex
	lockTemplateVersionInterfaceMockDeleteCollection                 sync.RWMutex
	lockTemplateVersionInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockTemplateVersionInterfaceMockGet                              sync.RWMutex
	lockTemplateVersionInterfaceMockGetNamespaced                    sync.RWMutex
	lockTemplateVersionInterfaceMockList                             sync.RWMutex
	lockTemplateVersionInterfaceMockListNamespaced                   sync.RWMutex
	lockTemplateVersionInterfaceMockObjectClient                     sync.RWMutex
	lockTemplateVersionInterfaceMockUpdate                           sync.RWMutex
	lockTemplateVersionInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that TemplateVersionInterfaceMock does implement v31.TemplateVersionInterface.
// If this is not the case, regenerate this file with moq.
var _ v31.TemplateVersionInterface = &TemplateVersionInterfaceMock{}

// TemplateVersionInterfaceMock is a mock implementation of v31.TemplateVersionInterface.
//
//     func TestSomethingThatUsesTemplateVersionInterface(t *testing.T) {
//
//         // make and configure a mocked v31.TemplateVersionInterface
//         mockedTemplateVersionInterface := &TemplateVersionInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.TemplateVersionHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.TemplateVersionLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v31.TemplateVersionHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v31.TemplateVersionLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.TemplateVersionHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v31.TemplateVersionLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v31.TemplateVersionHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v31.TemplateVersionLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v31.TemplateVersionController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v3.TemplateVersion) (*v3.TemplateVersion, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v3.TemplateVersion, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v3.TemplateVersion, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v3.TemplateVersionList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v3.TemplateVersionList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v3.TemplateVersion) (*v3.TemplateVersion, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedTemplateVersionInterface in code that requires v31.TemplateVersionInterface
//         // and then make assertions.
//
//     }
type TemplateVersionInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.TemplateVersionHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.TemplateVersionLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v31.TemplateVersionHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v31.TemplateVersionLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.TemplateVersionHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v31.TemplateVersionLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v31.TemplateVersionHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v31.TemplateVersionLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v31.TemplateVersionController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v3.TemplateVersion) (*v3.TemplateVersion, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v3.TemplateVersion, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v3.TemplateVersion, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v3.TemplateVersionList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v3.TemplateVersionList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v3.TemplateVersion) (*v3.TemplateVersion, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.TemplateVersionHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.TemplateVersionLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v31.TemplateVersionHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.TemplateVersionLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.TemplateVersionHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.TemplateVersionLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v31.TemplateVersionHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v31.TemplateVersionLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v3.TemplateVersion
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v3.TemplateVersion
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *TemplateVersionInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v31.TemplateVersionHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("TemplateVersionInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but TemplateVersionInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.TemplateVersionHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockTemplateVersionInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockTemplateVersionInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedTemplateVersionInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *TemplateVersionInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v31.TemplateVersionHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v31.TemplateVersionHandlerFunc
	}
	lockTemplateVersionInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockTemplateVersionInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *TemplateVersionInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v31.TemplateVersionLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("TemplateVersionInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but TemplateVersionInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.TemplateVersionLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockTemplateVersionInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockTemplateVersionInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedTemplateVersionInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *TemplateVersionInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v31.TemplateVersionLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v31.TemplateVersionLifecycle
	}
	lockTemplateVersionInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockTemplateVersionInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *TemplateVersionInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v31.TemplateVersionHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("TemplateVersionInterfaceMock.AddClusterScopedHandlerFunc: method is nil but TemplateVersionInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.TemplateVersionHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockTemplateVersionInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockTemplateVersionInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedTemplateVersionInterface.AddClusterScopedHandlerCalls())
func (mock *TemplateVersionInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v31.TemplateVersionHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v31.TemplateVersionHandlerFunc
	}
	lockTemplateVersionInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockTemplateVersionInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *TemplateVersionInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v31.TemplateVersionLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("TemplateVersionInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but TemplateVersionInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.TemplateVersionLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockTemplateVersionInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockTemplateVersionInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedTemplateVersionInterface.AddClusterScopedLifecycleCalls())
func (mock *TemplateVersionInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v31.TemplateVersionLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v31.TemplateVersionLifecycle
	}
	lockTemplateVersionInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockTemplateVersionInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *TemplateVersionInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v31.TemplateVersionHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("TemplateVersionInterfaceMock.AddFeatureHandlerFunc: method is nil but TemplateVersionInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.TemplateVersionHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockTemplateVersionInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockTemplateVersionInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedTemplateVersionInterface.AddFeatureHandlerCalls())
func (mock *TemplateVersionInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v31.TemplateVersionHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v31.TemplateVersionHandlerFunc
	}
	lockTemplateVersionInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockTemplateVersionInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *TemplateVersionInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v31.TemplateVersionLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("TemplateVersionInterfaceMock.AddFeatureLifecycleFunc: method is nil but TemplateVersionInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.TemplateVersionLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockTemplateVersionInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockTemplateVersionInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedTemplateVersionInterface.AddFeatureLifecycleCalls())
func (mock *TemplateVersionInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v31.TemplateVersionLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v31.TemplateVersionLifecycle
	}
	lockTemplateVersionInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockTemplateVersionInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *TemplateVersionInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v31.TemplateVersionHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("TemplateVersionInterfaceMock.AddHandlerFunc: method is nil but TemplateVersionInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v31.TemplateVersionHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockTemplateVersionInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockTemplateVersionInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedTemplateVersionInterface.AddHandlerCalls())
func (mock *TemplateVersionInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v31.TemplateVersionHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v31.TemplateVersionHandlerFunc
	}
	lockTemplateVersionInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockTemplateVersionInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *TemplateVersionInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v31.TemplateVersionLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("TemplateVersionInterfaceMock.AddLifecycleFunc: method is nil but TemplateVersionInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.TemplateVersionLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockTemplateVersionInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockTemplateVersionInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedTemplateVersionInterface.AddLifecycleCalls())
func (mock *TemplateVersionInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v31.TemplateVersionLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v31.TemplateVersionLifecycle
	}
	lockTemplateVersionInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockTemplateVersionInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *TemplateVersionInterfaceMock) Controller() v31.TemplateVersionController {
	if mock.ControllerFunc == nil {
		panic("TemplateVersionInterfaceMock.ControllerFunc: method is nil but TemplateVersionInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockTemplateVersionInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockTemplateVersionInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedTemplateVersionInterface.ControllerCalls())
func (mock *TemplateVersionInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockTemplateVersionInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockTemplateVersionInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *TemplateVersionInterfaceMock) Create(in1 *v3.TemplateVersion) (*v3.TemplateVersion, error) {
	if mock.CreateFunc == nil {
		panic("TemplateVersionInterfaceMock.CreateFunc: method is nil but TemplateVersionInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v3.TemplateVersion
	}{
		In1: in1,
	}
	lockTemplateVersionInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockTemplateVersionInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedTemplateVersionInterface.CreateCalls())
func (mock *TemplateVersionInterfaceMock) CreateCalls() []struct {
	In1 *v3.TemplateVersion
} {
	var calls []struct {
		In1 *v3.TemplateVersion
	}
	lockTemplateVersionInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockTemplateVersionInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *TemplateVersionInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("TemplateVersionInterfaceMock.DeleteFunc: method is nil but TemplateVersionInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockTemplateVersionInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockTemplateVersionInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedTemplateVersionInterface.DeleteCalls())
func (mock *TemplateVersionInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockTemplateVersionInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockTemplateVersionInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *TemplateVersionInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("TemplateVersionInterfaceMock.DeleteCollectionFunc: method is nil but TemplateVersionInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockTemplateVersionInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockTemplateVersionInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedTemplateVersionInterface.DeleteCollectionCalls())
func (mock *TemplateVersionInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockTemplateVersionInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockTemplateVersionInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *TemplateVersionInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("TemplateVersionInterfaceMock.DeleteNamespacedFunc: method is nil but TemplateVersionInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockTemplateVersionInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockTemplateVersionInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedTemplateVersionInterface.DeleteNamespacedCalls())
func (mock *TemplateVersionInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockTemplateVersionInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockTemplateVersionInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *TemplateVersionInterfaceMock) Get(name string, opts metav1.GetOptions) (*v3.TemplateVersion, error) {
	if mock.GetFunc == nil {
		panic("TemplateVersionInterfaceMock.GetFunc: method is nil but TemplateVersionInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockTemplateVersionInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockTemplateVersionInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedTemplateVersionInterface.GetCalls())
func (mock *TemplateVersionInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockTemplateVersionInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockTemplateVersionInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *TemplateVersionInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v3.TemplateVersion, error) {
	if mock.GetNamespacedFunc == nil {
		panic("TemplateVersionInterfaceMock.GetNamespacedFunc: method is nil but TemplateVersionInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockTemplateVersionInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockTemplateVersionInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedTemplateVersionInterface.GetNamespacedCalls())
func (mock *TemplateVersionInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockTemplateVersionInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockTemplateVersionInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *TemplateVersionInterfaceMock) List(opts metav1.ListOptions) (*v3.TemplateVersionList, error) {
	if mock.ListFunc == nil {
		panic("TemplateVersionInterfaceMock.ListFunc: method is nil but TemplateVersionInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockTemplateVersionInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockTemplateVersionInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedTemplateVersionInterface.ListCalls())
func (mock *TemplateVersionInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockTemplateVersionInterfaceMockList.RLock()
	calls = mock.calls.List
	lockTemplateVersionInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *TemplateVersionInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v3.TemplateVersionList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("TemplateVersionInterfaceMock.ListNamespacedFunc: method is nil but TemplateVersionInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockTemplateVersionInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockTemplateVersionInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedTemplateVersionInterface.ListNamespacedCalls())
func (mock *TemplateVersionInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockTemplateVersionInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockTemplateVersionInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *TemplateVersionInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("TemplateVersionInterfaceMock.ObjectClientFunc: method is nil but TemplateVersionInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockTemplateVersionInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockTemplateVersionInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedTemplateVersionInterface.ObjectClientCalls())
func (mock *TemplateVersionInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockTemplateVersionInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockTemplateVersionInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *TemplateVersionInterfaceMock) Update(in1 *v3.TemplateVersion) (*v3.TemplateVersion, error) {
	if mock.UpdateFunc == nil {
		panic("TemplateVersionInterfaceMock.UpdateFunc: method is nil but TemplateVersionInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v3.TemplateVersion
	}{
		In1: in1,
	}
	lockTemplateVersionInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockTemplateVersionInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedTemplateVersionInterface.UpdateCalls())
func (mock *TemplateVersionInterfaceMock) UpdateCalls() []struct {
	In1 *v3.TemplateVersion
} {
	var calls []struct {
		In1 *v3.TemplateVersion
	}
	lockTemplateVersionInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockTemplateVersionInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *TemplateVersionInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("TemplateVersionInterfaceMock.WatchFunc: method is nil but TemplateVersionInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockTemplateVersionInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockTemplateVersionInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedTemplateVersionInterface.WatchCalls())
func (mock *TemplateVersionInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockTemplateVersionInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockTemplateVersionInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockTemplateVersionsGetterMockTemplateVersions sync.RWMutex
)

// Ensure, that TemplateVersionsGetterMock does implement v31.TemplateVersionsGetter.
// If this is not the case, regenerate this file with moq.
var _ v31.TemplateVersionsGetter = &TemplateVersionsGetterMock{}

// TemplateVersionsGetterMock is a mock implementation of v31.TemplateVersionsGetter.
//
//     func TestSomethingThatUsesTemplateVersionsGetter(t *testing.T) {
//
//         // make and configure a mocked v31.TemplateVersionsGetter
//         mockedTemplateVersionsGetter := &TemplateVersionsGetterMock{
//             TemplateVersionsFunc: func(namespace string) v31.TemplateVersionInterface {
// 	               panic("mock out the TemplateVersions method")
//             },
//         }
//
//         // use mockedTemplateVersionsGetter in code that requires v31.TemplateVersionsGetter
//         // and then make assertions.
//
//     }
type TemplateVersionsGetterMock struct {
	// TemplateVersionsFunc mocks the TemplateVersions method.
	TemplateVersionsFunc func(namespace string) v31.TemplateVersionInterface

	// calls tracks calls to the methods.
	calls struct {
		// TemplateVersions holds details about calls to the TemplateVersions method.
		TemplateVersions []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// TemplateVersions calls TemplateVersionsFunc.
func (mock *TemplateVersionsGetterMock) TemplateVersions(namespace string) v31.TemplateVersionInterface {
	if mock.TemplateVersionsFunc == nil {
		panic("TemplateVersionsGetterMock.TemplateVersionsFunc: method is nil but TemplateVersionsGetter.TemplateVersions was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockTemplateVersionsGetterMockTemplateVersions.Lock()
	mock.calls.TemplateVersions = append(mock.calls.TemplateVersions, callInfo)
	lockTemplateVersionsGetterMockTemplateVersions.Unlock()
	return mock.TemplateVersionsFunc(namespace)
}

// TemplateVersionsCalls gets all the calls that were made to TemplateVersions.
// Check the length with:
//     len(mockedTemplateVersionsGetter.TemplateVersionsCalls())
func (mock *TemplateVersionsGetterMock) TemplateVersionsCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockTemplateVersionsGetterMockTemplateVersions.RLock()
	calls = mock.calls.TemplateVersions
	lockTemplateVersionsGetterMockTemplateVersions.RUnlock()
	return calls
}
