package v3

import (
	"github.com/rancher/norman/lifecycle"
	"github.com/rancher/norman/resource"
	"github.com/rancher/rancher/pkg/apis/management.cattle.io/v3"
	"k8s.io/apimachinery/pkg/runtime"
)

type CatalogTemplateLifecycle interface {
	Create(obj *v3.CatalogTemplate) (runtime.Object, error)
	Remove(obj *v3.CatalogTemplate) (runtime.Object, error)
	Updated(obj *v3.CatalogTemplate) (runtime.Object, error)
}

type catalogTemplateLifecycleAdapter struct {
	lifecycle CatalogTemplateLifecycle
}

func (w *catalogTemplateLifecycleAdapter) HasCreate() bool {
	o, ok := w.lifecycle.(lifecycle.ObjectLifecycleCondition)
	return !ok || o.HasCreate()
}

func (w *catalogTemplateLifecycleAdapter) HasFinalize() bool {
	o, ok := w.lifecycle.(lifecycle.ObjectLifecycleCondition)
	return !ok || o.HasFinalize()
}

func (w *catalogTemplateLifecycleAdapter) Create(obj runtime.Object) (runtime.Object, error) {
	o, err := w.lifecycle.Create(obj.(*v3.CatalogTemplate))
	if o == nil {
		return nil, err
	}
	return o, err
}

func (w *catalogTemplateLifecycleAdapter) Finalize(obj runtime.Object) (runtime.Object, error) {
	o, err := w.lifecycle.Remove(obj.(*v3.CatalogTemplate))
	if o == nil {
		return nil, err
	}
	return o, err
}

func (w *catalogTemplateLifecycleAdapter) Updated(obj runtime.Object) (runtime.Object, error) {
	o, err := w.lifecycle.Updated(obj.(*v3.CatalogTemplate))
	if o == nil {
		return nil, err
	}
	return o, err
}

func NewCatalogTemplateLifecycleAdapter(name string, clusterScoped bool, client CatalogTemplateInterface, l CatalogTemplateLifecycle) CatalogTemplateHandlerFunc {
	if clusterScoped {
		resource.PutClusterScoped(CatalogTemplateGroupVersionResource)
	}
	adapter := &catalogTemplateLifecycleAdapter{lifecycle: l}
	syncFn := lifecycle.NewObjectLifecycleAdapter(name, clusterScoped, adapter, client.ObjectClient())
	return func(key string, obj *v3.CatalogTemplate) (runtime.Object, error) {
		newObj, err := syncFn(key, obj)
		if o, ok := newObj.(runtime.Object); ok {
			return o, err
		}
		return nil, err
	}
}
