// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	v1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1"
	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v11 "github.com/rancher/rancher/pkg/generated/norman/monitoring.coreos.com/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockAlertmanagerListerMockGet  sync.RWMutex
	lockAlertmanagerListerMockList sync.RWMutex
)

// Ensure, that AlertmanagerListerMock does implement v11.AlertmanagerLister.
// If this is not the case, regenerate this file with moq.
var _ v11.AlertmanagerLister = &AlertmanagerListerMock{}

// AlertmanagerListerMock is a mock implementation of v11.AlertmanagerLister.
//
//     func TestSomethingThatUsesAlertmanagerLister(t *testing.T) {
//
//         // make and configure a mocked v11.AlertmanagerLister
//         mockedAlertmanagerLister := &AlertmanagerListerMock{
//             GetFunc: func(namespace string, name string) (*v1.Alertmanager, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v1.Alertmanager, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedAlertmanagerLister in code that requires v11.AlertmanagerLister
//         // and then make assertions.
//
//     }
type AlertmanagerListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v1.Alertmanager, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v1.Alertmanager, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *AlertmanagerListerMock) Get(namespace string, name string) (*v1.Alertmanager, error) {
	if mock.GetFunc == nil {
		panic("AlertmanagerListerMock.GetFunc: method is nil but AlertmanagerLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockAlertmanagerListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockAlertmanagerListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedAlertmanagerLister.GetCalls())
func (mock *AlertmanagerListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockAlertmanagerListerMockGet.RLock()
	calls = mock.calls.Get
	lockAlertmanagerListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *AlertmanagerListerMock) List(namespace string, selector labels.Selector) ([]*v1.Alertmanager, error) {
	if mock.ListFunc == nil {
		panic("AlertmanagerListerMock.ListFunc: method is nil but AlertmanagerLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockAlertmanagerListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockAlertmanagerListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedAlertmanagerLister.ListCalls())
func (mock *AlertmanagerListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockAlertmanagerListerMockList.RLock()
	calls = mock.calls.List
	lockAlertmanagerListerMockList.RUnlock()
	return calls
}

var (
	lockAlertmanagerControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockAlertmanagerControllerMockAddClusterScopedHandler        sync.RWMutex
	lockAlertmanagerControllerMockAddFeatureHandler              sync.RWMutex
	lockAlertmanagerControllerMockAddHandler                     sync.RWMutex
	lockAlertmanagerControllerMockEnqueue                        sync.RWMutex
	lockAlertmanagerControllerMockEnqueueAfter                   sync.RWMutex
	lockAlertmanagerControllerMockGeneric                        sync.RWMutex
	lockAlertmanagerControllerMockInformer                       sync.RWMutex
	lockAlertmanagerControllerMockLister                         sync.RWMutex
)

// Ensure, that AlertmanagerControllerMock does implement v11.AlertmanagerController.
// If this is not the case, regenerate this file with moq.
var _ v11.AlertmanagerController = &AlertmanagerControllerMock{}

// AlertmanagerControllerMock is a mock implementation of v11.AlertmanagerController.
//
//     func TestSomethingThatUsesAlertmanagerController(t *testing.T) {
//
//         // make and configure a mocked v11.AlertmanagerController
//         mockedAlertmanagerController := &AlertmanagerControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.AlertmanagerHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v11.AlertmanagerHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.AlertmanagerHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v11.AlertmanagerHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v11.AlertmanagerLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedAlertmanagerController in code that requires v11.AlertmanagerController
//         // and then make assertions.
//
//     }
type AlertmanagerControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.AlertmanagerHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v11.AlertmanagerHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.AlertmanagerHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v11.AlertmanagerHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v11.AlertmanagerLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.AlertmanagerHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.AlertmanagerHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.AlertmanagerHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v11.AlertmanagerHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *AlertmanagerControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.AlertmanagerHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("AlertmanagerControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but AlertmanagerController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.AlertmanagerHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockAlertmanagerControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockAlertmanagerControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedAlertmanagerController.AddClusterScopedFeatureHandlerCalls())
func (mock *AlertmanagerControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v11.AlertmanagerHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.AlertmanagerHandlerFunc
	}
	lockAlertmanagerControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockAlertmanagerControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *AlertmanagerControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v11.AlertmanagerHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("AlertmanagerControllerMock.AddClusterScopedHandlerFunc: method is nil but AlertmanagerController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.AlertmanagerHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockAlertmanagerControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockAlertmanagerControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedAlertmanagerController.AddClusterScopedHandlerCalls())
func (mock *AlertmanagerControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v11.AlertmanagerHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.AlertmanagerHandlerFunc
	}
	lockAlertmanagerControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockAlertmanagerControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *AlertmanagerControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.AlertmanagerHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("AlertmanagerControllerMock.AddFeatureHandlerFunc: method is nil but AlertmanagerController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.AlertmanagerHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockAlertmanagerControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockAlertmanagerControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedAlertmanagerController.AddFeatureHandlerCalls())
func (mock *AlertmanagerControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.AlertmanagerHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.AlertmanagerHandlerFunc
	}
	lockAlertmanagerControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockAlertmanagerControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *AlertmanagerControllerMock) AddHandler(ctx context.Context, name string, handler v11.AlertmanagerHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("AlertmanagerControllerMock.AddHandlerFunc: method is nil but AlertmanagerController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v11.AlertmanagerHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockAlertmanagerControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockAlertmanagerControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedAlertmanagerController.AddHandlerCalls())
func (mock *AlertmanagerControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v11.AlertmanagerHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v11.AlertmanagerHandlerFunc
	}
	lockAlertmanagerControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockAlertmanagerControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *AlertmanagerControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("AlertmanagerControllerMock.EnqueueFunc: method is nil but AlertmanagerController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockAlertmanagerControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockAlertmanagerControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedAlertmanagerController.EnqueueCalls())
func (mock *AlertmanagerControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockAlertmanagerControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockAlertmanagerControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *AlertmanagerControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("AlertmanagerControllerMock.EnqueueAfterFunc: method is nil but AlertmanagerController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockAlertmanagerControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockAlertmanagerControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedAlertmanagerController.EnqueueAfterCalls())
func (mock *AlertmanagerControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockAlertmanagerControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockAlertmanagerControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *AlertmanagerControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("AlertmanagerControllerMock.GenericFunc: method is nil but AlertmanagerController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockAlertmanagerControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockAlertmanagerControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedAlertmanagerController.GenericCalls())
func (mock *AlertmanagerControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockAlertmanagerControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockAlertmanagerControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *AlertmanagerControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("AlertmanagerControllerMock.InformerFunc: method is nil but AlertmanagerController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockAlertmanagerControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockAlertmanagerControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedAlertmanagerController.InformerCalls())
func (mock *AlertmanagerControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockAlertmanagerControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockAlertmanagerControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *AlertmanagerControllerMock) Lister() v11.AlertmanagerLister {
	if mock.ListerFunc == nil {
		panic("AlertmanagerControllerMock.ListerFunc: method is nil but AlertmanagerController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockAlertmanagerControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockAlertmanagerControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedAlertmanagerController.ListerCalls())
func (mock *AlertmanagerControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockAlertmanagerControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockAlertmanagerControllerMockLister.RUnlock()
	return calls
}

var (
	lockAlertmanagerInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockAlertmanagerInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockAlertmanagerInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockAlertmanagerInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockAlertmanagerInterfaceMockAddFeatureHandler                sync.RWMutex
	lockAlertmanagerInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockAlertmanagerInterfaceMockAddHandler                       sync.RWMutex
	lockAlertmanagerInterfaceMockAddLifecycle                     sync.RWMutex
	lockAlertmanagerInterfaceMockController                       sync.RWMutex
	lockAlertmanagerInterfaceMockCreate                           sync.RWMutex
	lockAlertmanagerInterfaceMockDelete                           sync.RWMutex
	lockAlertmanagerInterfaceMockDeleteCollection                 sync.RWMutex
	lockAlertmanagerInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockAlertmanagerInterfaceMockGet                              sync.RWMutex
	lockAlertmanagerInterfaceMockGetNamespaced                    sync.RWMutex
	lockAlertmanagerInterfaceMockList                             sync.RWMutex
	lockAlertmanagerInterfaceMockListNamespaced                   sync.RWMutex
	lockAlertmanagerInterfaceMockObjectClient                     sync.RWMutex
	lockAlertmanagerInterfaceMockUpdate                           sync.RWMutex
	lockAlertmanagerInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that AlertmanagerInterfaceMock does implement v11.AlertmanagerInterface.
// If this is not the case, regenerate this file with moq.
var _ v11.AlertmanagerInterface = &AlertmanagerInterfaceMock{}

// AlertmanagerInterfaceMock is a mock implementation of v11.AlertmanagerInterface.
//
//     func TestSomethingThatUsesAlertmanagerInterface(t *testing.T) {
//
//         // make and configure a mocked v11.AlertmanagerInterface
//         mockedAlertmanagerInterface := &AlertmanagerInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.AlertmanagerHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.AlertmanagerLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v11.AlertmanagerHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v11.AlertmanagerLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.AlertmanagerHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v11.AlertmanagerLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v11.AlertmanagerHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v11.AlertmanagerLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v11.AlertmanagerController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v1.Alertmanager) (*v1.Alertmanager, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v1.Alertmanager, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v1.Alertmanager, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v1.AlertmanagerList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v1.AlertmanagerList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v1.Alertmanager) (*v1.Alertmanager, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedAlertmanagerInterface in code that requires v11.AlertmanagerInterface
//         // and then make assertions.
//
//     }
type AlertmanagerInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.AlertmanagerHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.AlertmanagerLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v11.AlertmanagerHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v11.AlertmanagerLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.AlertmanagerHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v11.AlertmanagerLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v11.AlertmanagerHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v11.AlertmanagerLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v11.AlertmanagerController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v1.Alertmanager) (*v1.Alertmanager, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v1.Alertmanager, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v1.Alertmanager, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v1.AlertmanagerList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v1.AlertmanagerList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v1.Alertmanager) (*v1.Alertmanager, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.AlertmanagerHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.AlertmanagerLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.AlertmanagerHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.AlertmanagerLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.AlertmanagerHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.AlertmanagerLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.AlertmanagerHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.AlertmanagerLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v1.Alertmanager
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v1.Alertmanager
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *AlertmanagerInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.AlertmanagerHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("AlertmanagerInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but AlertmanagerInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.AlertmanagerHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockAlertmanagerInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockAlertmanagerInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedAlertmanagerInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *AlertmanagerInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v11.AlertmanagerHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.AlertmanagerHandlerFunc
	}
	lockAlertmanagerInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockAlertmanagerInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *AlertmanagerInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.AlertmanagerLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("AlertmanagerInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but AlertmanagerInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.AlertmanagerLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockAlertmanagerInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockAlertmanagerInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedAlertmanagerInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *AlertmanagerInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v11.AlertmanagerLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.AlertmanagerLifecycle
	}
	lockAlertmanagerInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockAlertmanagerInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *AlertmanagerInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v11.AlertmanagerHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("AlertmanagerInterfaceMock.AddClusterScopedHandlerFunc: method is nil but AlertmanagerInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.AlertmanagerHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockAlertmanagerInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockAlertmanagerInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedAlertmanagerInterface.AddClusterScopedHandlerCalls())
func (mock *AlertmanagerInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v11.AlertmanagerHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.AlertmanagerHandlerFunc
	}
	lockAlertmanagerInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockAlertmanagerInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *AlertmanagerInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v11.AlertmanagerLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("AlertmanagerInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but AlertmanagerInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.AlertmanagerLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockAlertmanagerInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockAlertmanagerInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedAlertmanagerInterface.AddClusterScopedLifecycleCalls())
func (mock *AlertmanagerInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v11.AlertmanagerLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.AlertmanagerLifecycle
	}
	lockAlertmanagerInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockAlertmanagerInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *AlertmanagerInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.AlertmanagerHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("AlertmanagerInterfaceMock.AddFeatureHandlerFunc: method is nil but AlertmanagerInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.AlertmanagerHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockAlertmanagerInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockAlertmanagerInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedAlertmanagerInterface.AddFeatureHandlerCalls())
func (mock *AlertmanagerInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.AlertmanagerHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.AlertmanagerHandlerFunc
	}
	lockAlertmanagerInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockAlertmanagerInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *AlertmanagerInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v11.AlertmanagerLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("AlertmanagerInterfaceMock.AddFeatureLifecycleFunc: method is nil but AlertmanagerInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.AlertmanagerLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockAlertmanagerInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockAlertmanagerInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedAlertmanagerInterface.AddFeatureLifecycleCalls())
func (mock *AlertmanagerInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v11.AlertmanagerLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.AlertmanagerLifecycle
	}
	lockAlertmanagerInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockAlertmanagerInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *AlertmanagerInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v11.AlertmanagerHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("AlertmanagerInterfaceMock.AddHandlerFunc: method is nil but AlertmanagerInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v11.AlertmanagerHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockAlertmanagerInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockAlertmanagerInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedAlertmanagerInterface.AddHandlerCalls())
func (mock *AlertmanagerInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v11.AlertmanagerHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v11.AlertmanagerHandlerFunc
	}
	lockAlertmanagerInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockAlertmanagerInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *AlertmanagerInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v11.AlertmanagerLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("AlertmanagerInterfaceMock.AddLifecycleFunc: method is nil but AlertmanagerInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.AlertmanagerLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockAlertmanagerInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockAlertmanagerInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedAlertmanagerInterface.AddLifecycleCalls())
func (mock *AlertmanagerInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v11.AlertmanagerLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.AlertmanagerLifecycle
	}
	lockAlertmanagerInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockAlertmanagerInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *AlertmanagerInterfaceMock) Controller() v11.AlertmanagerController {
	if mock.ControllerFunc == nil {
		panic("AlertmanagerInterfaceMock.ControllerFunc: method is nil but AlertmanagerInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockAlertmanagerInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockAlertmanagerInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedAlertmanagerInterface.ControllerCalls())
func (mock *AlertmanagerInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockAlertmanagerInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockAlertmanagerInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *AlertmanagerInterfaceMock) Create(in1 *v1.Alertmanager) (*v1.Alertmanager, error) {
	if mock.CreateFunc == nil {
		panic("AlertmanagerInterfaceMock.CreateFunc: method is nil but AlertmanagerInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v1.Alertmanager
	}{
		In1: in1,
	}
	lockAlertmanagerInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockAlertmanagerInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedAlertmanagerInterface.CreateCalls())
func (mock *AlertmanagerInterfaceMock) CreateCalls() []struct {
	In1 *v1.Alertmanager
} {
	var calls []struct {
		In1 *v1.Alertmanager
	}
	lockAlertmanagerInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockAlertmanagerInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *AlertmanagerInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("AlertmanagerInterfaceMock.DeleteFunc: method is nil but AlertmanagerInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockAlertmanagerInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockAlertmanagerInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedAlertmanagerInterface.DeleteCalls())
func (mock *AlertmanagerInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockAlertmanagerInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockAlertmanagerInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *AlertmanagerInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("AlertmanagerInterfaceMock.DeleteCollectionFunc: method is nil but AlertmanagerInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockAlertmanagerInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockAlertmanagerInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedAlertmanagerInterface.DeleteCollectionCalls())
func (mock *AlertmanagerInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockAlertmanagerInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockAlertmanagerInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *AlertmanagerInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("AlertmanagerInterfaceMock.DeleteNamespacedFunc: method is nil but AlertmanagerInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockAlertmanagerInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockAlertmanagerInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedAlertmanagerInterface.DeleteNamespacedCalls())
func (mock *AlertmanagerInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockAlertmanagerInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockAlertmanagerInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *AlertmanagerInterfaceMock) Get(name string, opts metav1.GetOptions) (*v1.Alertmanager, error) {
	if mock.GetFunc == nil {
		panic("AlertmanagerInterfaceMock.GetFunc: method is nil but AlertmanagerInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockAlertmanagerInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockAlertmanagerInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedAlertmanagerInterface.GetCalls())
func (mock *AlertmanagerInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockAlertmanagerInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockAlertmanagerInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *AlertmanagerInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v1.Alertmanager, error) {
	if mock.GetNamespacedFunc == nil {
		panic("AlertmanagerInterfaceMock.GetNamespacedFunc: method is nil but AlertmanagerInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockAlertmanagerInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockAlertmanagerInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedAlertmanagerInterface.GetNamespacedCalls())
func (mock *AlertmanagerInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockAlertmanagerInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockAlertmanagerInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *AlertmanagerInterfaceMock) List(opts metav1.ListOptions) (*v1.AlertmanagerList, error) {
	if mock.ListFunc == nil {
		panic("AlertmanagerInterfaceMock.ListFunc: method is nil but AlertmanagerInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockAlertmanagerInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockAlertmanagerInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedAlertmanagerInterface.ListCalls())
func (mock *AlertmanagerInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockAlertmanagerInterfaceMockList.RLock()
	calls = mock.calls.List
	lockAlertmanagerInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *AlertmanagerInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v1.AlertmanagerList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("AlertmanagerInterfaceMock.ListNamespacedFunc: method is nil but AlertmanagerInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockAlertmanagerInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockAlertmanagerInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedAlertmanagerInterface.ListNamespacedCalls())
func (mock *AlertmanagerInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockAlertmanagerInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockAlertmanagerInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *AlertmanagerInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("AlertmanagerInterfaceMock.ObjectClientFunc: method is nil but AlertmanagerInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockAlertmanagerInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockAlertmanagerInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedAlertmanagerInterface.ObjectClientCalls())
func (mock *AlertmanagerInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockAlertmanagerInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockAlertmanagerInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *AlertmanagerInterfaceMock) Update(in1 *v1.Alertmanager) (*v1.Alertmanager, error) {
	if mock.UpdateFunc == nil {
		panic("AlertmanagerInterfaceMock.UpdateFunc: method is nil but AlertmanagerInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v1.Alertmanager
	}{
		In1: in1,
	}
	lockAlertmanagerInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockAlertmanagerInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedAlertmanagerInterface.UpdateCalls())
func (mock *AlertmanagerInterfaceMock) UpdateCalls() []struct {
	In1 *v1.Alertmanager
} {
	var calls []struct {
		In1 *v1.Alertmanager
	}
	lockAlertmanagerInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockAlertmanagerInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *AlertmanagerInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("AlertmanagerInterfaceMock.WatchFunc: method is nil but AlertmanagerInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockAlertmanagerInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockAlertmanagerInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedAlertmanagerInterface.WatchCalls())
func (mock *AlertmanagerInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockAlertmanagerInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockAlertmanagerInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockAlertmanagersGetterMockAlertmanagers sync.RWMutex
)

// Ensure, that AlertmanagersGetterMock does implement v11.AlertmanagersGetter.
// If this is not the case, regenerate this file with moq.
var _ v11.AlertmanagersGetter = &AlertmanagersGetterMock{}

// AlertmanagersGetterMock is a mock implementation of v11.AlertmanagersGetter.
//
//     func TestSomethingThatUsesAlertmanagersGetter(t *testing.T) {
//
//         // make and configure a mocked v11.AlertmanagersGetter
//         mockedAlertmanagersGetter := &AlertmanagersGetterMock{
//             AlertmanagersFunc: func(namespace string) v11.AlertmanagerInterface {
// 	               panic("mock out the Alertmanagers method")
//             },
//         }
//
//         // use mockedAlertmanagersGetter in code that requires v11.AlertmanagersGetter
//         // and then make assertions.
//
//     }
type AlertmanagersGetterMock struct {
	// AlertmanagersFunc mocks the Alertmanagers method.
	AlertmanagersFunc func(namespace string) v11.AlertmanagerInterface

	// calls tracks calls to the methods.
	calls struct {
		// Alertmanagers holds details about calls to the Alertmanagers method.
		Alertmanagers []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// Alertmanagers calls AlertmanagersFunc.
func (mock *AlertmanagersGetterMock) Alertmanagers(namespace string) v11.AlertmanagerInterface {
	if mock.AlertmanagersFunc == nil {
		panic("AlertmanagersGetterMock.AlertmanagersFunc: method is nil but AlertmanagersGetter.Alertmanagers was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockAlertmanagersGetterMockAlertmanagers.Lock()
	mock.calls.Alertmanagers = append(mock.calls.Alertmanagers, callInfo)
	lockAlertmanagersGetterMockAlertmanagers.Unlock()
	return mock.AlertmanagersFunc(namespace)
}

// AlertmanagersCalls gets all the calls that were made to Alertmanagers.
// Check the length with:
//     len(mockedAlertmanagersGetter.AlertmanagersCalls())
func (mock *AlertmanagersGetterMock) AlertmanagersCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockAlertmanagersGetterMockAlertmanagers.RLock()
	calls = mock.calls.Alertmanagers
	lockAlertmanagersGetterMockAlertmanagers.RUnlock()
	return calls
}
