// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package fakes

import (
	"context"
	"sync"
	"time"

	v1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1"
	"github.com/rancher/norman/controller"
	"github.com/rancher/norman/objectclient"
	v11 "github.com/rancher/rancher/pkg/generated/norman/monitoring.coreos.com/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/tools/cache"
)

var (
	lockPrometheusListerMockGet  sync.RWMutex
	lockPrometheusListerMockList sync.RWMutex
)

// Ensure, that PrometheusListerMock does implement v11.PrometheusLister.
// If this is not the case, regenerate this file with moq.
var _ v11.PrometheusLister = &PrometheusListerMock{}

// PrometheusListerMock is a mock implementation of v11.PrometheusLister.
//
//     func TestSomethingThatUsesPrometheusLister(t *testing.T) {
//
//         // make and configure a mocked v11.PrometheusLister
//         mockedPrometheusLister := &PrometheusListerMock{
//             GetFunc: func(namespace string, name string) (*v1.Prometheus, error) {
// 	               panic("mock out the Get method")
//             },
//             ListFunc: func(namespace string, selector labels.Selector) ([]*v1.Prometheus, error) {
// 	               panic("mock out the List method")
//             },
//         }
//
//         // use mockedPrometheusLister in code that requires v11.PrometheusLister
//         // and then make assertions.
//
//     }
type PrometheusListerMock struct {
	// GetFunc mocks the Get method.
	GetFunc func(namespace string, name string) (*v1.Prometheus, error)

	// ListFunc mocks the List method.
	ListFunc func(namespace string, selector labels.Selector) ([]*v1.Prometheus, error)

	// calls tracks calls to the methods.
	calls struct {
		// Get holds details about calls to the Get method.
		Get []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// List holds details about calls to the List method.
		List []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Selector is the selector argument value.
			Selector labels.Selector
		}
	}
}

// Get calls GetFunc.
func (mock *PrometheusListerMock) Get(namespace string, name string) (*v1.Prometheus, error) {
	if mock.GetFunc == nil {
		panic("PrometheusListerMock.GetFunc: method is nil but PrometheusLister.Get was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockPrometheusListerMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockPrometheusListerMockGet.Unlock()
	return mock.GetFunc(namespace, name)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedPrometheusLister.GetCalls())
func (mock *PrometheusListerMock) GetCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockPrometheusListerMockGet.RLock()
	calls = mock.calls.Get
	lockPrometheusListerMockGet.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *PrometheusListerMock) List(namespace string, selector labels.Selector) ([]*v1.Prometheus, error) {
	if mock.ListFunc == nil {
		panic("PrometheusListerMock.ListFunc: method is nil but PrometheusLister.List was just called")
	}
	callInfo := struct {
		Namespace string
		Selector  labels.Selector
	}{
		Namespace: namespace,
		Selector:  selector,
	}
	lockPrometheusListerMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockPrometheusListerMockList.Unlock()
	return mock.ListFunc(namespace, selector)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedPrometheusLister.ListCalls())
func (mock *PrometheusListerMock) ListCalls() []struct {
	Namespace string
	Selector  labels.Selector
} {
	var calls []struct {
		Namespace string
		Selector  labels.Selector
	}
	lockPrometheusListerMockList.RLock()
	calls = mock.calls.List
	lockPrometheusListerMockList.RUnlock()
	return calls
}

var (
	lockPrometheusControllerMockAddClusterScopedFeatureHandler sync.RWMutex
	lockPrometheusControllerMockAddClusterScopedHandler        sync.RWMutex
	lockPrometheusControllerMockAddFeatureHandler              sync.RWMutex
	lockPrometheusControllerMockAddHandler                     sync.RWMutex
	lockPrometheusControllerMockEnqueue                        sync.RWMutex
	lockPrometheusControllerMockEnqueueAfter                   sync.RWMutex
	lockPrometheusControllerMockGeneric                        sync.RWMutex
	lockPrometheusControllerMockInformer                       sync.RWMutex
	lockPrometheusControllerMockLister                         sync.RWMutex
)

// Ensure, that PrometheusControllerMock does implement v11.PrometheusController.
// If this is not the case, regenerate this file with moq.
var _ v11.PrometheusController = &PrometheusControllerMock{}

// PrometheusControllerMock is a mock implementation of v11.PrometheusController.
//
//     func TestSomethingThatUsesPrometheusController(t *testing.T) {
//
//         // make and configure a mocked v11.PrometheusController
//         mockedPrometheusController := &PrometheusControllerMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.PrometheusHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, handler v11.PrometheusHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.PrometheusHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, handler v11.PrometheusHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             EnqueueFunc: func(namespace string, name string)  {
// 	               panic("mock out the Enqueue method")
//             },
//             EnqueueAfterFunc: func(namespace string, name string, after time.Duration)  {
// 	               panic("mock out the EnqueueAfter method")
//             },
//             GenericFunc: func() controller.GenericController {
// 	               panic("mock out the Generic method")
//             },
//             InformerFunc: func() cache.SharedIndexInformer {
// 	               panic("mock out the Informer method")
//             },
//             ListerFunc: func() v11.PrometheusLister {
// 	               panic("mock out the Lister method")
//             },
//         }
//
//         // use mockedPrometheusController in code that requires v11.PrometheusController
//         // and then make assertions.
//
//     }
type PrometheusControllerMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.PrometheusHandlerFunc)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, handler v11.PrometheusHandlerFunc)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.PrometheusHandlerFunc)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, handler v11.PrometheusHandlerFunc)

	// EnqueueFunc mocks the Enqueue method.
	EnqueueFunc func(namespace string, name string)

	// EnqueueAfterFunc mocks the EnqueueAfter method.
	EnqueueAfterFunc func(namespace string, name string, after time.Duration)

	// GenericFunc mocks the Generic method.
	GenericFunc func() controller.GenericController

	// InformerFunc mocks the Informer method.
	InformerFunc func() cache.SharedIndexInformer

	// ListerFunc mocks the Lister method.
	ListerFunc func() v11.PrometheusLister

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.PrometheusHandlerFunc
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Handler is the handler argument value.
			Handler v11.PrometheusHandlerFunc
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.PrometheusHandlerFunc
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Handler is the handler argument value.
			Handler v11.PrometheusHandlerFunc
		}
		// Enqueue holds details about calls to the Enqueue method.
		Enqueue []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
		}
		// EnqueueAfter holds details about calls to the EnqueueAfter method.
		EnqueueAfter []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// After is the after argument value.
			After time.Duration
		}
		// Generic holds details about calls to the Generic method.
		Generic []struct {
		}
		// Informer holds details about calls to the Informer method.
		Informer []struct {
		}
		// Lister holds details about calls to the Lister method.
		Lister []struct {
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *PrometheusControllerMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, handler v11.PrometheusHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("PrometheusControllerMock.AddClusterScopedFeatureHandlerFunc: method is nil but PrometheusController.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.PrometheusHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockPrometheusControllerMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockPrometheusControllerMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, handler)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedPrometheusController.AddClusterScopedFeatureHandlerCalls())
func (mock *PrometheusControllerMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Handler     v11.PrometheusHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Handler     v11.PrometheusHandlerFunc
	}
	lockPrometheusControllerMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockPrometheusControllerMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *PrometheusControllerMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, handler v11.PrometheusHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("PrometheusControllerMock.AddClusterScopedHandlerFunc: method is nil but PrometheusController.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.PrometheusHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Handler:     handler,
	}
	lockPrometheusControllerMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockPrometheusControllerMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, handler)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedPrometheusController.AddClusterScopedHandlerCalls())
func (mock *PrometheusControllerMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Handler     v11.PrometheusHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Handler     v11.PrometheusHandlerFunc
	}
	lockPrometheusControllerMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockPrometheusControllerMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *PrometheusControllerMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.PrometheusHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("PrometheusControllerMock.AddFeatureHandlerFunc: method is nil but PrometheusController.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.PrometheusHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockPrometheusControllerMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockPrometheusControllerMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedPrometheusController.AddFeatureHandlerCalls())
func (mock *PrometheusControllerMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.PrometheusHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.PrometheusHandlerFunc
	}
	lockPrometheusControllerMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockPrometheusControllerMockAddFeatureHandler.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *PrometheusControllerMock) AddHandler(ctx context.Context, name string, handler v11.PrometheusHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("PrometheusControllerMock.AddHandlerFunc: method is nil but PrometheusController.AddHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Name    string
		Handler v11.PrometheusHandlerFunc
	}{
		Ctx:     ctx,
		Name:    name,
		Handler: handler,
	}
	lockPrometheusControllerMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockPrometheusControllerMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, handler)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedPrometheusController.AddHandlerCalls())
func (mock *PrometheusControllerMock) AddHandlerCalls() []struct {
	Ctx     context.Context
	Name    string
	Handler v11.PrometheusHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Name    string
		Handler v11.PrometheusHandlerFunc
	}
	lockPrometheusControllerMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockPrometheusControllerMockAddHandler.RUnlock()
	return calls
}

// Enqueue calls EnqueueFunc.
func (mock *PrometheusControllerMock) Enqueue(namespace string, name string) {
	if mock.EnqueueFunc == nil {
		panic("PrometheusControllerMock.EnqueueFunc: method is nil but PrometheusController.Enqueue was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
	}{
		Namespace: namespace,
		Name:      name,
	}
	lockPrometheusControllerMockEnqueue.Lock()
	mock.calls.Enqueue = append(mock.calls.Enqueue, callInfo)
	lockPrometheusControllerMockEnqueue.Unlock()
	mock.EnqueueFunc(namespace, name)
}

// EnqueueCalls gets all the calls that were made to Enqueue.
// Check the length with:
//     len(mockedPrometheusController.EnqueueCalls())
func (mock *PrometheusControllerMock) EnqueueCalls() []struct {
	Namespace string
	Name      string
} {
	var calls []struct {
		Namespace string
		Name      string
	}
	lockPrometheusControllerMockEnqueue.RLock()
	calls = mock.calls.Enqueue
	lockPrometheusControllerMockEnqueue.RUnlock()
	return calls
}

// EnqueueAfter calls EnqueueAfterFunc.
func (mock *PrometheusControllerMock) EnqueueAfter(namespace string, name string, after time.Duration) {
	if mock.EnqueueAfterFunc == nil {
		panic("PrometheusControllerMock.EnqueueAfterFunc: method is nil but PrometheusController.EnqueueAfter was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		After     time.Duration
	}{
		Namespace: namespace,
		Name:      name,
		After:     after,
	}
	lockPrometheusControllerMockEnqueueAfter.Lock()
	mock.calls.EnqueueAfter = append(mock.calls.EnqueueAfter, callInfo)
	lockPrometheusControllerMockEnqueueAfter.Unlock()
	mock.EnqueueAfterFunc(namespace, name, after)
}

// EnqueueAfterCalls gets all the calls that were made to EnqueueAfter.
// Check the length with:
//     len(mockedPrometheusController.EnqueueAfterCalls())
func (mock *PrometheusControllerMock) EnqueueAfterCalls() []struct {
	Namespace string
	Name      string
	After     time.Duration
} {
	var calls []struct {
		Namespace string
		Name      string
		After     time.Duration
	}
	lockPrometheusControllerMockEnqueueAfter.RLock()
	calls = mock.calls.EnqueueAfter
	lockPrometheusControllerMockEnqueueAfter.RUnlock()
	return calls
}

// Generic calls GenericFunc.
func (mock *PrometheusControllerMock) Generic() controller.GenericController {
	if mock.GenericFunc == nil {
		panic("PrometheusControllerMock.GenericFunc: method is nil but PrometheusController.Generic was just called")
	}
	callInfo := struct {
	}{}
	lockPrometheusControllerMockGeneric.Lock()
	mock.calls.Generic = append(mock.calls.Generic, callInfo)
	lockPrometheusControllerMockGeneric.Unlock()
	return mock.GenericFunc()
}

// GenericCalls gets all the calls that were made to Generic.
// Check the length with:
//     len(mockedPrometheusController.GenericCalls())
func (mock *PrometheusControllerMock) GenericCalls() []struct {
} {
	var calls []struct {
	}
	lockPrometheusControllerMockGeneric.RLock()
	calls = mock.calls.Generic
	lockPrometheusControllerMockGeneric.RUnlock()
	return calls
}

// Informer calls InformerFunc.
func (mock *PrometheusControllerMock) Informer() cache.SharedIndexInformer {
	if mock.InformerFunc == nil {
		panic("PrometheusControllerMock.InformerFunc: method is nil but PrometheusController.Informer was just called")
	}
	callInfo := struct {
	}{}
	lockPrometheusControllerMockInformer.Lock()
	mock.calls.Informer = append(mock.calls.Informer, callInfo)
	lockPrometheusControllerMockInformer.Unlock()
	return mock.InformerFunc()
}

// InformerCalls gets all the calls that were made to Informer.
// Check the length with:
//     len(mockedPrometheusController.InformerCalls())
func (mock *PrometheusControllerMock) InformerCalls() []struct {
} {
	var calls []struct {
	}
	lockPrometheusControllerMockInformer.RLock()
	calls = mock.calls.Informer
	lockPrometheusControllerMockInformer.RUnlock()
	return calls
}

// Lister calls ListerFunc.
func (mock *PrometheusControllerMock) Lister() v11.PrometheusLister {
	if mock.ListerFunc == nil {
		panic("PrometheusControllerMock.ListerFunc: method is nil but PrometheusController.Lister was just called")
	}
	callInfo := struct {
	}{}
	lockPrometheusControllerMockLister.Lock()
	mock.calls.Lister = append(mock.calls.Lister, callInfo)
	lockPrometheusControllerMockLister.Unlock()
	return mock.ListerFunc()
}

// ListerCalls gets all the calls that were made to Lister.
// Check the length with:
//     len(mockedPrometheusController.ListerCalls())
func (mock *PrometheusControllerMock) ListerCalls() []struct {
} {
	var calls []struct {
	}
	lockPrometheusControllerMockLister.RLock()
	calls = mock.calls.Lister
	lockPrometheusControllerMockLister.RUnlock()
	return calls
}

var (
	lockPrometheusInterfaceMockAddClusterScopedFeatureHandler   sync.RWMutex
	lockPrometheusInterfaceMockAddClusterScopedFeatureLifecycle sync.RWMutex
	lockPrometheusInterfaceMockAddClusterScopedHandler          sync.RWMutex
	lockPrometheusInterfaceMockAddClusterScopedLifecycle        sync.RWMutex
	lockPrometheusInterfaceMockAddFeatureHandler                sync.RWMutex
	lockPrometheusInterfaceMockAddFeatureLifecycle              sync.RWMutex
	lockPrometheusInterfaceMockAddHandler                       sync.RWMutex
	lockPrometheusInterfaceMockAddLifecycle                     sync.RWMutex
	lockPrometheusInterfaceMockController                       sync.RWMutex
	lockPrometheusInterfaceMockCreate                           sync.RWMutex
	lockPrometheusInterfaceMockDelete                           sync.RWMutex
	lockPrometheusInterfaceMockDeleteCollection                 sync.RWMutex
	lockPrometheusInterfaceMockDeleteNamespaced                 sync.RWMutex
	lockPrometheusInterfaceMockGet                              sync.RWMutex
	lockPrometheusInterfaceMockGetNamespaced                    sync.RWMutex
	lockPrometheusInterfaceMockList                             sync.RWMutex
	lockPrometheusInterfaceMockListNamespaced                   sync.RWMutex
	lockPrometheusInterfaceMockObjectClient                     sync.RWMutex
	lockPrometheusInterfaceMockUpdate                           sync.RWMutex
	lockPrometheusInterfaceMockWatch                            sync.RWMutex
)

// Ensure, that PrometheusInterfaceMock does implement v11.PrometheusInterface.
// If this is not the case, regenerate this file with moq.
var _ v11.PrometheusInterface = &PrometheusInterfaceMock{}

// PrometheusInterfaceMock is a mock implementation of v11.PrometheusInterface.
//
//     func TestSomethingThatUsesPrometheusInterface(t *testing.T) {
//
//         // make and configure a mocked v11.PrometheusInterface
//         mockedPrometheusInterface := &PrometheusInterfaceMock{
//             AddClusterScopedFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.PrometheusHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedFeatureHandler method")
//             },
//             AddClusterScopedFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.PrometheusLifecycle)  {
// 	               panic("mock out the AddClusterScopedFeatureLifecycle method")
//             },
//             AddClusterScopedHandlerFunc: func(ctx context.Context, name string, clusterName string, syncMoqParam v11.PrometheusHandlerFunc)  {
// 	               panic("mock out the AddClusterScopedHandler method")
//             },
//             AddClusterScopedLifecycleFunc: func(ctx context.Context, name string, clusterName string, lifecycle v11.PrometheusLifecycle)  {
// 	               panic("mock out the AddClusterScopedLifecycle method")
//             },
//             AddFeatureHandlerFunc: func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.PrometheusHandlerFunc)  {
// 	               panic("mock out the AddFeatureHandler method")
//             },
//             AddFeatureLifecycleFunc: func(ctx context.Context, enabled func() bool, name string, lifecycle v11.PrometheusLifecycle)  {
// 	               panic("mock out the AddFeatureLifecycle method")
//             },
//             AddHandlerFunc: func(ctx context.Context, name string, syncMoqParam v11.PrometheusHandlerFunc)  {
// 	               panic("mock out the AddHandler method")
//             },
//             AddLifecycleFunc: func(ctx context.Context, name string, lifecycle v11.PrometheusLifecycle)  {
// 	               panic("mock out the AddLifecycle method")
//             },
//             ControllerFunc: func() v11.PrometheusController {
// 	               panic("mock out the Controller method")
//             },
//             CreateFunc: func(in1 *v1.Prometheus) (*v1.Prometheus, error) {
// 	               panic("mock out the Create method")
//             },
//             DeleteFunc: func(name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the Delete method")
//             },
//             DeleteCollectionFunc: func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
// 	               panic("mock out the DeleteCollection method")
//             },
//             DeleteNamespacedFunc: func(namespace string, name string, options *metav1.DeleteOptions) error {
// 	               panic("mock out the DeleteNamespaced method")
//             },
//             GetFunc: func(name string, opts metav1.GetOptions) (*v1.Prometheus, error) {
// 	               panic("mock out the Get method")
//             },
//             GetNamespacedFunc: func(namespace string, name string, opts metav1.GetOptions) (*v1.Prometheus, error) {
// 	               panic("mock out the GetNamespaced method")
//             },
//             ListFunc: func(opts metav1.ListOptions) (*v1.PrometheusList, error) {
// 	               panic("mock out the List method")
//             },
//             ListNamespacedFunc: func(namespace string, opts metav1.ListOptions) (*v1.PrometheusList, error) {
// 	               panic("mock out the ListNamespaced method")
//             },
//             ObjectClientFunc: func() *objectclient.ObjectClient {
// 	               panic("mock out the ObjectClient method")
//             },
//             UpdateFunc: func(in1 *v1.Prometheus) (*v1.Prometheus, error) {
// 	               panic("mock out the Update method")
//             },
//             WatchFunc: func(opts metav1.ListOptions) (watch.Interface, error) {
// 	               panic("mock out the Watch method")
//             },
//         }
//
//         // use mockedPrometheusInterface in code that requires v11.PrometheusInterface
//         // and then make assertions.
//
//     }
type PrometheusInterfaceMock struct {
	// AddClusterScopedFeatureHandlerFunc mocks the AddClusterScopedFeatureHandler method.
	AddClusterScopedFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.PrometheusHandlerFunc)

	// AddClusterScopedFeatureLifecycleFunc mocks the AddClusterScopedFeatureLifecycle method.
	AddClusterScopedFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.PrometheusLifecycle)

	// AddClusterScopedHandlerFunc mocks the AddClusterScopedHandler method.
	AddClusterScopedHandlerFunc func(ctx context.Context, name string, clusterName string, syncMoqParam v11.PrometheusHandlerFunc)

	// AddClusterScopedLifecycleFunc mocks the AddClusterScopedLifecycle method.
	AddClusterScopedLifecycleFunc func(ctx context.Context, name string, clusterName string, lifecycle v11.PrometheusLifecycle)

	// AddFeatureHandlerFunc mocks the AddFeatureHandler method.
	AddFeatureHandlerFunc func(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.PrometheusHandlerFunc)

	// AddFeatureLifecycleFunc mocks the AddFeatureLifecycle method.
	AddFeatureLifecycleFunc func(ctx context.Context, enabled func() bool, name string, lifecycle v11.PrometheusLifecycle)

	// AddHandlerFunc mocks the AddHandler method.
	AddHandlerFunc func(ctx context.Context, name string, syncMoqParam v11.PrometheusHandlerFunc)

	// AddLifecycleFunc mocks the AddLifecycle method.
	AddLifecycleFunc func(ctx context.Context, name string, lifecycle v11.PrometheusLifecycle)

	// ControllerFunc mocks the Controller method.
	ControllerFunc func() v11.PrometheusController

	// CreateFunc mocks the Create method.
	CreateFunc func(in1 *v1.Prometheus) (*v1.Prometheus, error)

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(name string, options *metav1.DeleteOptions) error

	// DeleteCollectionFunc mocks the DeleteCollection method.
	DeleteCollectionFunc func(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error

	// DeleteNamespacedFunc mocks the DeleteNamespaced method.
	DeleteNamespacedFunc func(namespace string, name string, options *metav1.DeleteOptions) error

	// GetFunc mocks the Get method.
	GetFunc func(name string, opts metav1.GetOptions) (*v1.Prometheus, error)

	// GetNamespacedFunc mocks the GetNamespaced method.
	GetNamespacedFunc func(namespace string, name string, opts metav1.GetOptions) (*v1.Prometheus, error)

	// ListFunc mocks the List method.
	ListFunc func(opts metav1.ListOptions) (*v1.PrometheusList, error)

	// ListNamespacedFunc mocks the ListNamespaced method.
	ListNamespacedFunc func(namespace string, opts metav1.ListOptions) (*v1.PrometheusList, error)

	// ObjectClientFunc mocks the ObjectClient method.
	ObjectClientFunc func() *objectclient.ObjectClient

	// UpdateFunc mocks the Update method.
	UpdateFunc func(in1 *v1.Prometheus) (*v1.Prometheus, error)

	// WatchFunc mocks the Watch method.
	WatchFunc func(opts metav1.ListOptions) (watch.Interface, error)

	// calls tracks calls to the methods.
	calls struct {
		// AddClusterScopedFeatureHandler holds details about calls to the AddClusterScopedFeatureHandler method.
		AddClusterScopedFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.PrometheusHandlerFunc
		}
		// AddClusterScopedFeatureLifecycle holds details about calls to the AddClusterScopedFeatureLifecycle method.
		AddClusterScopedFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.PrometheusLifecycle
		}
		// AddClusterScopedHandler holds details about calls to the AddClusterScopedHandler method.
		AddClusterScopedHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Sync is the sync argument value.
			Sync v11.PrometheusHandlerFunc
		}
		// AddClusterScopedLifecycle holds details about calls to the AddClusterScopedLifecycle method.
		AddClusterScopedLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// ClusterName is the clusterName argument value.
			ClusterName string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.PrometheusLifecycle
		}
		// AddFeatureHandler holds details about calls to the AddFeatureHandler method.
		AddFeatureHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.PrometheusHandlerFunc
		}
		// AddFeatureLifecycle holds details about calls to the AddFeatureLifecycle method.
		AddFeatureLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Enabled is the enabled argument value.
			Enabled func() bool
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.PrometheusLifecycle
		}
		// AddHandler holds details about calls to the AddHandler method.
		AddHandler []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Sync is the sync argument value.
			Sync v11.PrometheusHandlerFunc
		}
		// AddLifecycle holds details about calls to the AddLifecycle method.
		AddLifecycle []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Name is the name argument value.
			Name string
			// Lifecycle is the lifecycle argument value.
			Lifecycle v11.PrometheusLifecycle
		}
		// Controller holds details about calls to the Controller method.
		Controller []struct {
		}
		// Create holds details about calls to the Create method.
		Create []struct {
			// In1 is the in1 argument value.
			In1 *v1.Prometheus
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// DeleteCollection holds details about calls to the DeleteCollection method.
		DeleteCollection []struct {
			// DeleteOpts is the deleteOpts argument value.
			DeleteOpts *metav1.DeleteOptions
			// ListOpts is the listOpts argument value.
			ListOpts metav1.ListOptions
		}
		// DeleteNamespaced holds details about calls to the DeleteNamespaced method.
		DeleteNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Options is the options argument value.
			Options *metav1.DeleteOptions
		}
		// Get holds details about calls to the Get method.
		Get []struct {
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// GetNamespaced holds details about calls to the GetNamespaced method.
		GetNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Name is the name argument value.
			Name string
			// Opts is the opts argument value.
			Opts metav1.GetOptions
		}
		// List holds details about calls to the List method.
		List []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ListNamespaced holds details about calls to the ListNamespaced method.
		ListNamespaced []struct {
			// Namespace is the namespace argument value.
			Namespace string
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
		// ObjectClient holds details about calls to the ObjectClient method.
		ObjectClient []struct {
		}
		// Update holds details about calls to the Update method.
		Update []struct {
			// In1 is the in1 argument value.
			In1 *v1.Prometheus
		}
		// Watch holds details about calls to the Watch method.
		Watch []struct {
			// Opts is the opts argument value.
			Opts metav1.ListOptions
		}
	}
}

// AddClusterScopedFeatureHandler calls AddClusterScopedFeatureHandlerFunc.
func (mock *PrometheusInterfaceMock) AddClusterScopedFeatureHandler(ctx context.Context, enabled func() bool, name string, clusterName string, syncMoqParam v11.PrometheusHandlerFunc) {
	if mock.AddClusterScopedFeatureHandlerFunc == nil {
		panic("PrometheusInterfaceMock.AddClusterScopedFeatureHandlerFunc: method is nil but PrometheusInterface.AddClusterScopedFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.PrometheusHandlerFunc
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockPrometheusInterfaceMockAddClusterScopedFeatureHandler.Lock()
	mock.calls.AddClusterScopedFeatureHandler = append(mock.calls.AddClusterScopedFeatureHandler, callInfo)
	lockPrometheusInterfaceMockAddClusterScopedFeatureHandler.Unlock()
	mock.AddClusterScopedFeatureHandlerFunc(ctx, enabled, name, clusterName, syncMoqParam)
}

// AddClusterScopedFeatureHandlerCalls gets all the calls that were made to AddClusterScopedFeatureHandler.
// Check the length with:
//     len(mockedPrometheusInterface.AddClusterScopedFeatureHandlerCalls())
func (mock *PrometheusInterfaceMock) AddClusterScopedFeatureHandlerCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Sync        v11.PrometheusHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Sync        v11.PrometheusHandlerFunc
	}
	lockPrometheusInterfaceMockAddClusterScopedFeatureHandler.RLock()
	calls = mock.calls.AddClusterScopedFeatureHandler
	lockPrometheusInterfaceMockAddClusterScopedFeatureHandler.RUnlock()
	return calls
}

// AddClusterScopedFeatureLifecycle calls AddClusterScopedFeatureLifecycleFunc.
func (mock *PrometheusInterfaceMock) AddClusterScopedFeatureLifecycle(ctx context.Context, enabled func() bool, name string, clusterName string, lifecycle v11.PrometheusLifecycle) {
	if mock.AddClusterScopedFeatureLifecycleFunc == nil {
		panic("PrometheusInterfaceMock.AddClusterScopedFeatureLifecycleFunc: method is nil but PrometheusInterface.AddClusterScopedFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.PrometheusLifecycle
	}{
		Ctx:         ctx,
		Enabled:     enabled,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockPrometheusInterfaceMockAddClusterScopedFeatureLifecycle.Lock()
	mock.calls.AddClusterScopedFeatureLifecycle = append(mock.calls.AddClusterScopedFeatureLifecycle, callInfo)
	lockPrometheusInterfaceMockAddClusterScopedFeatureLifecycle.Unlock()
	mock.AddClusterScopedFeatureLifecycleFunc(ctx, enabled, name, clusterName, lifecycle)
}

// AddClusterScopedFeatureLifecycleCalls gets all the calls that were made to AddClusterScopedFeatureLifecycle.
// Check the length with:
//     len(mockedPrometheusInterface.AddClusterScopedFeatureLifecycleCalls())
func (mock *PrometheusInterfaceMock) AddClusterScopedFeatureLifecycleCalls() []struct {
	Ctx         context.Context
	Enabled     func() bool
	Name        string
	ClusterName string
	Lifecycle   v11.PrometheusLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Enabled     func() bool
		Name        string
		ClusterName string
		Lifecycle   v11.PrometheusLifecycle
	}
	lockPrometheusInterfaceMockAddClusterScopedFeatureLifecycle.RLock()
	calls = mock.calls.AddClusterScopedFeatureLifecycle
	lockPrometheusInterfaceMockAddClusterScopedFeatureLifecycle.RUnlock()
	return calls
}

// AddClusterScopedHandler calls AddClusterScopedHandlerFunc.
func (mock *PrometheusInterfaceMock) AddClusterScopedHandler(ctx context.Context, name string, clusterName string, syncMoqParam v11.PrometheusHandlerFunc) {
	if mock.AddClusterScopedHandlerFunc == nil {
		panic("PrometheusInterfaceMock.AddClusterScopedHandlerFunc: method is nil but PrometheusInterface.AddClusterScopedHandler was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.PrometheusHandlerFunc
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Sync:        syncMoqParam,
	}
	lockPrometheusInterfaceMockAddClusterScopedHandler.Lock()
	mock.calls.AddClusterScopedHandler = append(mock.calls.AddClusterScopedHandler, callInfo)
	lockPrometheusInterfaceMockAddClusterScopedHandler.Unlock()
	mock.AddClusterScopedHandlerFunc(ctx, name, clusterName, syncMoqParam)
}

// AddClusterScopedHandlerCalls gets all the calls that were made to AddClusterScopedHandler.
// Check the length with:
//     len(mockedPrometheusInterface.AddClusterScopedHandlerCalls())
func (mock *PrometheusInterfaceMock) AddClusterScopedHandlerCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Sync        v11.PrometheusHandlerFunc
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Sync        v11.PrometheusHandlerFunc
	}
	lockPrometheusInterfaceMockAddClusterScopedHandler.RLock()
	calls = mock.calls.AddClusterScopedHandler
	lockPrometheusInterfaceMockAddClusterScopedHandler.RUnlock()
	return calls
}

// AddClusterScopedLifecycle calls AddClusterScopedLifecycleFunc.
func (mock *PrometheusInterfaceMock) AddClusterScopedLifecycle(ctx context.Context, name string, clusterName string, lifecycle v11.PrometheusLifecycle) {
	if mock.AddClusterScopedLifecycleFunc == nil {
		panic("PrometheusInterfaceMock.AddClusterScopedLifecycleFunc: method is nil but PrometheusInterface.AddClusterScopedLifecycle was just called")
	}
	callInfo := struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.PrometheusLifecycle
	}{
		Ctx:         ctx,
		Name:        name,
		ClusterName: clusterName,
		Lifecycle:   lifecycle,
	}
	lockPrometheusInterfaceMockAddClusterScopedLifecycle.Lock()
	mock.calls.AddClusterScopedLifecycle = append(mock.calls.AddClusterScopedLifecycle, callInfo)
	lockPrometheusInterfaceMockAddClusterScopedLifecycle.Unlock()
	mock.AddClusterScopedLifecycleFunc(ctx, name, clusterName, lifecycle)
}

// AddClusterScopedLifecycleCalls gets all the calls that were made to AddClusterScopedLifecycle.
// Check the length with:
//     len(mockedPrometheusInterface.AddClusterScopedLifecycleCalls())
func (mock *PrometheusInterfaceMock) AddClusterScopedLifecycleCalls() []struct {
	Ctx         context.Context
	Name        string
	ClusterName string
	Lifecycle   v11.PrometheusLifecycle
} {
	var calls []struct {
		Ctx         context.Context
		Name        string
		ClusterName string
		Lifecycle   v11.PrometheusLifecycle
	}
	lockPrometheusInterfaceMockAddClusterScopedLifecycle.RLock()
	calls = mock.calls.AddClusterScopedLifecycle
	lockPrometheusInterfaceMockAddClusterScopedLifecycle.RUnlock()
	return calls
}

// AddFeatureHandler calls AddFeatureHandlerFunc.
func (mock *PrometheusInterfaceMock) AddFeatureHandler(ctx context.Context, enabled func() bool, name string, syncMoqParam v11.PrometheusHandlerFunc) {
	if mock.AddFeatureHandlerFunc == nil {
		panic("PrometheusInterfaceMock.AddFeatureHandlerFunc: method is nil but PrometheusInterface.AddFeatureHandler was just called")
	}
	callInfo := struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.PrometheusHandlerFunc
	}{
		Ctx:     ctx,
		Enabled: enabled,
		Name:    name,
		Sync:    syncMoqParam,
	}
	lockPrometheusInterfaceMockAddFeatureHandler.Lock()
	mock.calls.AddFeatureHandler = append(mock.calls.AddFeatureHandler, callInfo)
	lockPrometheusInterfaceMockAddFeatureHandler.Unlock()
	mock.AddFeatureHandlerFunc(ctx, enabled, name, syncMoqParam)
}

// AddFeatureHandlerCalls gets all the calls that were made to AddFeatureHandler.
// Check the length with:
//     len(mockedPrometheusInterface.AddFeatureHandlerCalls())
func (mock *PrometheusInterfaceMock) AddFeatureHandlerCalls() []struct {
	Ctx     context.Context
	Enabled func() bool
	Name    string
	Sync    v11.PrometheusHandlerFunc
} {
	var calls []struct {
		Ctx     context.Context
		Enabled func() bool
		Name    string
		Sync    v11.PrometheusHandlerFunc
	}
	lockPrometheusInterfaceMockAddFeatureHandler.RLock()
	calls = mock.calls.AddFeatureHandler
	lockPrometheusInterfaceMockAddFeatureHandler.RUnlock()
	return calls
}

// AddFeatureLifecycle calls AddFeatureLifecycleFunc.
func (mock *PrometheusInterfaceMock) AddFeatureLifecycle(ctx context.Context, enabled func() bool, name string, lifecycle v11.PrometheusLifecycle) {
	if mock.AddFeatureLifecycleFunc == nil {
		panic("PrometheusInterfaceMock.AddFeatureLifecycleFunc: method is nil but PrometheusInterface.AddFeatureLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.PrometheusLifecycle
	}{
		Ctx:       ctx,
		Enabled:   enabled,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockPrometheusInterfaceMockAddFeatureLifecycle.Lock()
	mock.calls.AddFeatureLifecycle = append(mock.calls.AddFeatureLifecycle, callInfo)
	lockPrometheusInterfaceMockAddFeatureLifecycle.Unlock()
	mock.AddFeatureLifecycleFunc(ctx, enabled, name, lifecycle)
}

// AddFeatureLifecycleCalls gets all the calls that were made to AddFeatureLifecycle.
// Check the length with:
//     len(mockedPrometheusInterface.AddFeatureLifecycleCalls())
func (mock *PrometheusInterfaceMock) AddFeatureLifecycleCalls() []struct {
	Ctx       context.Context
	Enabled   func() bool
	Name      string
	Lifecycle v11.PrometheusLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Enabled   func() bool
		Name      string
		Lifecycle v11.PrometheusLifecycle
	}
	lockPrometheusInterfaceMockAddFeatureLifecycle.RLock()
	calls = mock.calls.AddFeatureLifecycle
	lockPrometheusInterfaceMockAddFeatureLifecycle.RUnlock()
	return calls
}

// AddHandler calls AddHandlerFunc.
func (mock *PrometheusInterfaceMock) AddHandler(ctx context.Context, name string, syncMoqParam v11.PrometheusHandlerFunc) {
	if mock.AddHandlerFunc == nil {
		panic("PrometheusInterfaceMock.AddHandlerFunc: method is nil but PrometheusInterface.AddHandler was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		Name string
		Sync v11.PrometheusHandlerFunc
	}{
		Ctx:  ctx,
		Name: name,
		Sync: syncMoqParam,
	}
	lockPrometheusInterfaceMockAddHandler.Lock()
	mock.calls.AddHandler = append(mock.calls.AddHandler, callInfo)
	lockPrometheusInterfaceMockAddHandler.Unlock()
	mock.AddHandlerFunc(ctx, name, syncMoqParam)
}

// AddHandlerCalls gets all the calls that were made to AddHandler.
// Check the length with:
//     len(mockedPrometheusInterface.AddHandlerCalls())
func (mock *PrometheusInterfaceMock) AddHandlerCalls() []struct {
	Ctx  context.Context
	Name string
	Sync v11.PrometheusHandlerFunc
} {
	var calls []struct {
		Ctx  context.Context
		Name string
		Sync v11.PrometheusHandlerFunc
	}
	lockPrometheusInterfaceMockAddHandler.RLock()
	calls = mock.calls.AddHandler
	lockPrometheusInterfaceMockAddHandler.RUnlock()
	return calls
}

// AddLifecycle calls AddLifecycleFunc.
func (mock *PrometheusInterfaceMock) AddLifecycle(ctx context.Context, name string, lifecycle v11.PrometheusLifecycle) {
	if mock.AddLifecycleFunc == nil {
		panic("PrometheusInterfaceMock.AddLifecycleFunc: method is nil but PrometheusInterface.AddLifecycle was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.PrometheusLifecycle
	}{
		Ctx:       ctx,
		Name:      name,
		Lifecycle: lifecycle,
	}
	lockPrometheusInterfaceMockAddLifecycle.Lock()
	mock.calls.AddLifecycle = append(mock.calls.AddLifecycle, callInfo)
	lockPrometheusInterfaceMockAddLifecycle.Unlock()
	mock.AddLifecycleFunc(ctx, name, lifecycle)
}

// AddLifecycleCalls gets all the calls that were made to AddLifecycle.
// Check the length with:
//     len(mockedPrometheusInterface.AddLifecycleCalls())
func (mock *PrometheusInterfaceMock) AddLifecycleCalls() []struct {
	Ctx       context.Context
	Name      string
	Lifecycle v11.PrometheusLifecycle
} {
	var calls []struct {
		Ctx       context.Context
		Name      string
		Lifecycle v11.PrometheusLifecycle
	}
	lockPrometheusInterfaceMockAddLifecycle.RLock()
	calls = mock.calls.AddLifecycle
	lockPrometheusInterfaceMockAddLifecycle.RUnlock()
	return calls
}

// Controller calls ControllerFunc.
func (mock *PrometheusInterfaceMock) Controller() v11.PrometheusController {
	if mock.ControllerFunc == nil {
		panic("PrometheusInterfaceMock.ControllerFunc: method is nil but PrometheusInterface.Controller was just called")
	}
	callInfo := struct {
	}{}
	lockPrometheusInterfaceMockController.Lock()
	mock.calls.Controller = append(mock.calls.Controller, callInfo)
	lockPrometheusInterfaceMockController.Unlock()
	return mock.ControllerFunc()
}

// ControllerCalls gets all the calls that were made to Controller.
// Check the length with:
//     len(mockedPrometheusInterface.ControllerCalls())
func (mock *PrometheusInterfaceMock) ControllerCalls() []struct {
} {
	var calls []struct {
	}
	lockPrometheusInterfaceMockController.RLock()
	calls = mock.calls.Controller
	lockPrometheusInterfaceMockController.RUnlock()
	return calls
}

// Create calls CreateFunc.
func (mock *PrometheusInterfaceMock) Create(in1 *v1.Prometheus) (*v1.Prometheus, error) {
	if mock.CreateFunc == nil {
		panic("PrometheusInterfaceMock.CreateFunc: method is nil but PrometheusInterface.Create was just called")
	}
	callInfo := struct {
		In1 *v1.Prometheus
	}{
		In1: in1,
	}
	lockPrometheusInterfaceMockCreate.Lock()
	mock.calls.Create = append(mock.calls.Create, callInfo)
	lockPrometheusInterfaceMockCreate.Unlock()
	return mock.CreateFunc(in1)
}

// CreateCalls gets all the calls that were made to Create.
// Check the length with:
//     len(mockedPrometheusInterface.CreateCalls())
func (mock *PrometheusInterfaceMock) CreateCalls() []struct {
	In1 *v1.Prometheus
} {
	var calls []struct {
		In1 *v1.Prometheus
	}
	lockPrometheusInterfaceMockCreate.RLock()
	calls = mock.calls.Create
	lockPrometheusInterfaceMockCreate.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *PrometheusInterfaceMock) Delete(name string, options *metav1.DeleteOptions) error {
	if mock.DeleteFunc == nil {
		panic("PrometheusInterfaceMock.DeleteFunc: method is nil but PrometheusInterface.Delete was just called")
	}
	callInfo := struct {
		Name    string
		Options *metav1.DeleteOptions
	}{
		Name:    name,
		Options: options,
	}
	lockPrometheusInterfaceMockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	lockPrometheusInterfaceMockDelete.Unlock()
	return mock.DeleteFunc(name, options)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//     len(mockedPrometheusInterface.DeleteCalls())
func (mock *PrometheusInterfaceMock) DeleteCalls() []struct {
	Name    string
	Options *metav1.DeleteOptions
} {
	var calls []struct {
		Name    string
		Options *metav1.DeleteOptions
	}
	lockPrometheusInterfaceMockDelete.RLock()
	calls = mock.calls.Delete
	lockPrometheusInterfaceMockDelete.RUnlock()
	return calls
}

// DeleteCollection calls DeleteCollectionFunc.
func (mock *PrometheusInterfaceMock) DeleteCollection(deleteOpts *metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	if mock.DeleteCollectionFunc == nil {
		panic("PrometheusInterfaceMock.DeleteCollectionFunc: method is nil but PrometheusInterface.DeleteCollection was just called")
	}
	callInfo := struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}{
		DeleteOpts: deleteOpts,
		ListOpts:   listOpts,
	}
	lockPrometheusInterfaceMockDeleteCollection.Lock()
	mock.calls.DeleteCollection = append(mock.calls.DeleteCollection, callInfo)
	lockPrometheusInterfaceMockDeleteCollection.Unlock()
	return mock.DeleteCollectionFunc(deleteOpts, listOpts)
}

// DeleteCollectionCalls gets all the calls that were made to DeleteCollection.
// Check the length with:
//     len(mockedPrometheusInterface.DeleteCollectionCalls())
func (mock *PrometheusInterfaceMock) DeleteCollectionCalls() []struct {
	DeleteOpts *metav1.DeleteOptions
	ListOpts   metav1.ListOptions
} {
	var calls []struct {
		DeleteOpts *metav1.DeleteOptions
		ListOpts   metav1.ListOptions
	}
	lockPrometheusInterfaceMockDeleteCollection.RLock()
	calls = mock.calls.DeleteCollection
	lockPrometheusInterfaceMockDeleteCollection.RUnlock()
	return calls
}

// DeleteNamespaced calls DeleteNamespacedFunc.
func (mock *PrometheusInterfaceMock) DeleteNamespaced(namespace string, name string, options *metav1.DeleteOptions) error {
	if mock.DeleteNamespacedFunc == nil {
		panic("PrometheusInterfaceMock.DeleteNamespacedFunc: method is nil but PrometheusInterface.DeleteNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}{
		Namespace: namespace,
		Name:      name,
		Options:   options,
	}
	lockPrometheusInterfaceMockDeleteNamespaced.Lock()
	mock.calls.DeleteNamespaced = append(mock.calls.DeleteNamespaced, callInfo)
	lockPrometheusInterfaceMockDeleteNamespaced.Unlock()
	return mock.DeleteNamespacedFunc(namespace, name, options)
}

// DeleteNamespacedCalls gets all the calls that were made to DeleteNamespaced.
// Check the length with:
//     len(mockedPrometheusInterface.DeleteNamespacedCalls())
func (mock *PrometheusInterfaceMock) DeleteNamespacedCalls() []struct {
	Namespace string
	Name      string
	Options   *metav1.DeleteOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Options   *metav1.DeleteOptions
	}
	lockPrometheusInterfaceMockDeleteNamespaced.RLock()
	calls = mock.calls.DeleteNamespaced
	lockPrometheusInterfaceMockDeleteNamespaced.RUnlock()
	return calls
}

// Get calls GetFunc.
func (mock *PrometheusInterfaceMock) Get(name string, opts metav1.GetOptions) (*v1.Prometheus, error) {
	if mock.GetFunc == nil {
		panic("PrometheusInterfaceMock.GetFunc: method is nil but PrometheusInterface.Get was just called")
	}
	callInfo := struct {
		Name string
		Opts metav1.GetOptions
	}{
		Name: name,
		Opts: opts,
	}
	lockPrometheusInterfaceMockGet.Lock()
	mock.calls.Get = append(mock.calls.Get, callInfo)
	lockPrometheusInterfaceMockGet.Unlock()
	return mock.GetFunc(name, opts)
}

// GetCalls gets all the calls that were made to Get.
// Check the length with:
//     len(mockedPrometheusInterface.GetCalls())
func (mock *PrometheusInterfaceMock) GetCalls() []struct {
	Name string
	Opts metav1.GetOptions
} {
	var calls []struct {
		Name string
		Opts metav1.GetOptions
	}
	lockPrometheusInterfaceMockGet.RLock()
	calls = mock.calls.Get
	lockPrometheusInterfaceMockGet.RUnlock()
	return calls
}

// GetNamespaced calls GetNamespacedFunc.
func (mock *PrometheusInterfaceMock) GetNamespaced(namespace string, name string, opts metav1.GetOptions) (*v1.Prometheus, error) {
	if mock.GetNamespacedFunc == nil {
		panic("PrometheusInterfaceMock.GetNamespacedFunc: method is nil but PrometheusInterface.GetNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}{
		Namespace: namespace,
		Name:      name,
		Opts:      opts,
	}
	lockPrometheusInterfaceMockGetNamespaced.Lock()
	mock.calls.GetNamespaced = append(mock.calls.GetNamespaced, callInfo)
	lockPrometheusInterfaceMockGetNamespaced.Unlock()
	return mock.GetNamespacedFunc(namespace, name, opts)
}

// GetNamespacedCalls gets all the calls that were made to GetNamespaced.
// Check the length with:
//     len(mockedPrometheusInterface.GetNamespacedCalls())
func (mock *PrometheusInterfaceMock) GetNamespacedCalls() []struct {
	Namespace string
	Name      string
	Opts      metav1.GetOptions
} {
	var calls []struct {
		Namespace string
		Name      string
		Opts      metav1.GetOptions
	}
	lockPrometheusInterfaceMockGetNamespaced.RLock()
	calls = mock.calls.GetNamespaced
	lockPrometheusInterfaceMockGetNamespaced.RUnlock()
	return calls
}

// List calls ListFunc.
func (mock *PrometheusInterfaceMock) List(opts metav1.ListOptions) (*v1.PrometheusList, error) {
	if mock.ListFunc == nil {
		panic("PrometheusInterfaceMock.ListFunc: method is nil but PrometheusInterface.List was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockPrometheusInterfaceMockList.Lock()
	mock.calls.List = append(mock.calls.List, callInfo)
	lockPrometheusInterfaceMockList.Unlock()
	return mock.ListFunc(opts)
}

// ListCalls gets all the calls that were made to List.
// Check the length with:
//     len(mockedPrometheusInterface.ListCalls())
func (mock *PrometheusInterfaceMock) ListCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockPrometheusInterfaceMockList.RLock()
	calls = mock.calls.List
	lockPrometheusInterfaceMockList.RUnlock()
	return calls
}

// ListNamespaced calls ListNamespacedFunc.
func (mock *PrometheusInterfaceMock) ListNamespaced(namespace string, opts metav1.ListOptions) (*v1.PrometheusList, error) {
	if mock.ListNamespacedFunc == nil {
		panic("PrometheusInterfaceMock.ListNamespacedFunc: method is nil but PrometheusInterface.ListNamespaced was just called")
	}
	callInfo := struct {
		Namespace string
		Opts      metav1.ListOptions
	}{
		Namespace: namespace,
		Opts:      opts,
	}
	lockPrometheusInterfaceMockListNamespaced.Lock()
	mock.calls.ListNamespaced = append(mock.calls.ListNamespaced, callInfo)
	lockPrometheusInterfaceMockListNamespaced.Unlock()
	return mock.ListNamespacedFunc(namespace, opts)
}

// ListNamespacedCalls gets all the calls that were made to ListNamespaced.
// Check the length with:
//     len(mockedPrometheusInterface.ListNamespacedCalls())
func (mock *PrometheusInterfaceMock) ListNamespacedCalls() []struct {
	Namespace string
	Opts      metav1.ListOptions
} {
	var calls []struct {
		Namespace string
		Opts      metav1.ListOptions
	}
	lockPrometheusInterfaceMockListNamespaced.RLock()
	calls = mock.calls.ListNamespaced
	lockPrometheusInterfaceMockListNamespaced.RUnlock()
	return calls
}

// ObjectClient calls ObjectClientFunc.
func (mock *PrometheusInterfaceMock) ObjectClient() *objectclient.ObjectClient {
	if mock.ObjectClientFunc == nil {
		panic("PrometheusInterfaceMock.ObjectClientFunc: method is nil but PrometheusInterface.ObjectClient was just called")
	}
	callInfo := struct {
	}{}
	lockPrometheusInterfaceMockObjectClient.Lock()
	mock.calls.ObjectClient = append(mock.calls.ObjectClient, callInfo)
	lockPrometheusInterfaceMockObjectClient.Unlock()
	return mock.ObjectClientFunc()
}

// ObjectClientCalls gets all the calls that were made to ObjectClient.
// Check the length with:
//     len(mockedPrometheusInterface.ObjectClientCalls())
func (mock *PrometheusInterfaceMock) ObjectClientCalls() []struct {
} {
	var calls []struct {
	}
	lockPrometheusInterfaceMockObjectClient.RLock()
	calls = mock.calls.ObjectClient
	lockPrometheusInterfaceMockObjectClient.RUnlock()
	return calls
}

// Update calls UpdateFunc.
func (mock *PrometheusInterfaceMock) Update(in1 *v1.Prometheus) (*v1.Prometheus, error) {
	if mock.UpdateFunc == nil {
		panic("PrometheusInterfaceMock.UpdateFunc: method is nil but PrometheusInterface.Update was just called")
	}
	callInfo := struct {
		In1 *v1.Prometheus
	}{
		In1: in1,
	}
	lockPrometheusInterfaceMockUpdate.Lock()
	mock.calls.Update = append(mock.calls.Update, callInfo)
	lockPrometheusInterfaceMockUpdate.Unlock()
	return mock.UpdateFunc(in1)
}

// UpdateCalls gets all the calls that were made to Update.
// Check the length with:
//     len(mockedPrometheusInterface.UpdateCalls())
func (mock *PrometheusInterfaceMock) UpdateCalls() []struct {
	In1 *v1.Prometheus
} {
	var calls []struct {
		In1 *v1.Prometheus
	}
	lockPrometheusInterfaceMockUpdate.RLock()
	calls = mock.calls.Update
	lockPrometheusInterfaceMockUpdate.RUnlock()
	return calls
}

// Watch calls WatchFunc.
func (mock *PrometheusInterfaceMock) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	if mock.WatchFunc == nil {
		panic("PrometheusInterfaceMock.WatchFunc: method is nil but PrometheusInterface.Watch was just called")
	}
	callInfo := struct {
		Opts metav1.ListOptions
	}{
		Opts: opts,
	}
	lockPrometheusInterfaceMockWatch.Lock()
	mock.calls.Watch = append(mock.calls.Watch, callInfo)
	lockPrometheusInterfaceMockWatch.Unlock()
	return mock.WatchFunc(opts)
}

// WatchCalls gets all the calls that were made to Watch.
// Check the length with:
//     len(mockedPrometheusInterface.WatchCalls())
func (mock *PrometheusInterfaceMock) WatchCalls() []struct {
	Opts metav1.ListOptions
} {
	var calls []struct {
		Opts metav1.ListOptions
	}
	lockPrometheusInterfaceMockWatch.RLock()
	calls = mock.calls.Watch
	lockPrometheusInterfaceMockWatch.RUnlock()
	return calls
}

var (
	lockPrometheusesGetterMockPrometheuses sync.RWMutex
)

// Ensure, that PrometheusesGetterMock does implement v11.PrometheusesGetter.
// If this is not the case, regenerate this file with moq.
var _ v11.PrometheusesGetter = &PrometheusesGetterMock{}

// PrometheusesGetterMock is a mock implementation of v11.PrometheusesGetter.
//
//     func TestSomethingThatUsesPrometheusesGetter(t *testing.T) {
//
//         // make and configure a mocked v11.PrometheusesGetter
//         mockedPrometheusesGetter := &PrometheusesGetterMock{
//             PrometheusesFunc: func(namespace string) v11.PrometheusInterface {
// 	               panic("mock out the Prometheuses method")
//             },
//         }
//
//         // use mockedPrometheusesGetter in code that requires v11.PrometheusesGetter
//         // and then make assertions.
//
//     }
type PrometheusesGetterMock struct {
	// PrometheusesFunc mocks the Prometheuses method.
	PrometheusesFunc func(namespace string) v11.PrometheusInterface

	// calls tracks calls to the methods.
	calls struct {
		// Prometheuses holds details about calls to the Prometheuses method.
		Prometheuses []struct {
			// Namespace is the namespace argument value.
			Namespace string
		}
	}
}

// Prometheuses calls PrometheusesFunc.
func (mock *PrometheusesGetterMock) Prometheuses(namespace string) v11.PrometheusInterface {
	if mock.PrometheusesFunc == nil {
		panic("PrometheusesGetterMock.PrometheusesFunc: method is nil but PrometheusesGetter.Prometheuses was just called")
	}
	callInfo := struct {
		Namespace string
	}{
		Namespace: namespace,
	}
	lockPrometheusesGetterMockPrometheuses.Lock()
	mock.calls.Prometheuses = append(mock.calls.Prometheuses, callInfo)
	lockPrometheusesGetterMockPrometheuses.Unlock()
	return mock.PrometheusesFunc(namespace)
}

// PrometheusesCalls gets all the calls that were made to Prometheuses.
// Check the length with:
//     len(mockedPrometheusesGetter.PrometheusesCalls())
func (mock *PrometheusesGetterMock) PrometheusesCalls() []struct {
	Namespace string
} {
	var calls []struct {
		Namespace string
	}
	lockPrometheusesGetterMockPrometheuses.RLock()
	calls = mock.calls.Prometheuses
	lockPrometheusesGetterMockPrometheuses.RUnlock()
	return calls
}
